# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DedicatedHostArgs', 'DedicatedHost']

@pulumi.input_type
class DedicatedHostArgs:
    def __init__(__self__, *,
                 dedicated_host_type: pulumi.Input[str],
                 action_on_maintenance: Optional[pulumi.Input[str]] = None,
                 auto_placement: Optional[pulumi.Input[str]] = None,
                 auto_release_time: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 cpu_over_commit_ratio: Optional[pulumi.Input[float]] = None,
                 dedicated_host_cluster_id: Optional[pulumi.Input[str]] = None,
                 dedicated_host_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 detail_fee: Optional[pulumi.Input[bool]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 expired_time: Optional[pulumi.Input[str]] = None,
                 min_quantity: Optional[pulumi.Input[int]] = None,
                 network_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedHostNetworkAttributeArgs']]]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 sale_cycle: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DedicatedHost resource.
        :param pulumi.Input[str] dedicated_host_type: The type of the dedicated host. You can call the [DescribeDedicatedHostTypes](https://www.alibabacloud.com/help/doc-detail/134240.htm) operation to obtain the most recent list of dedicated host types.
        :param pulumi.Input[str] action_on_maintenance: The policy used to migrate the instances from the dedicated host when the dedicated host fails or needs to be repaired online. Valid values: `Migrate`, `Stop`.
        :param pulumi.Input[str] auto_placement: Specifies whether to add the dedicated host to the resource pool for automatic deployment. If you do not specify the DedicatedHostId parameter when you create an instance on a dedicated host, Alibaba Cloud automatically selects a dedicated host from the resource pool to host the instance. Valid values: `on`, `off`. Default: `on`.
        :param pulumi.Input[str] auto_release_time: The automatic release time of the dedicated host. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
        :param pulumi.Input[bool] auto_renew: Specifies whether to automatically renew the subscription dedicated host.
        :param pulumi.Input[int] auto_renew_period: The auto-renewal period of the dedicated host. Unit: months. Valid values: `1`, `2`, `3`, `6`, and `12`. takes effect and is required only when the AutoRenew parameter is set to true.
        :param pulumi.Input[float] cpu_over_commit_ratio: CPU oversold ratio. Only custom specifications g6s, c6s, r6s support setting the CPU oversold ratio.
        :param pulumi.Input[str] dedicated_host_cluster_id: The dedicated host cluster ID to which the dedicated host belongs.
        :param pulumi.Input[str] dedicated_host_name: The name of the dedicated host. The name must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[str] description: The description of the dedicated host. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[bool] detail_fee: Specifies whether to return the billing details of the order when the billing method is changed from subscription to pay-as-you-go. Default: `false`.
        :param pulumi.Input[bool] dry_run: Specifies whether to only validate the request. Default: `false`.
        :param pulumi.Input[str] expired_time: The subscription period of the dedicated host. The Period parameter takes effect and is required only when the ChargeType parameter is set to PrePaid.
        :param pulumi.Input[int] min_quantity: Specify the minimum purchase quantity of a dedicated host.
        :param pulumi.Input[Sequence[pulumi.Input['DedicatedHostNetworkAttributeArgs']]] network_attributes: dedicated host network parameters. contains the following attributes:
        :param pulumi.Input[str] payment_type: The billing method of the dedicated host. Valid values: `PrePaid`, `PostPaid`. Default: `PostPaid`.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group to which the dedicated host belongs.
        :param pulumi.Input[str] sale_cycle: The unit of the subscription period of the dedicated host.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] zone_id: The zone ID of the dedicated host. This parameter is empty by default. If you do not specify this parameter, the system automatically selects a zone.
        """
        pulumi.set(__self__, "dedicated_host_type", dedicated_host_type)
        if action_on_maintenance is not None:
            pulumi.set(__self__, "action_on_maintenance", action_on_maintenance)
        if auto_placement is not None:
            pulumi.set(__self__, "auto_placement", auto_placement)
        if auto_release_time is not None:
            pulumi.set(__self__, "auto_release_time", auto_release_time)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if cpu_over_commit_ratio is not None:
            pulumi.set(__self__, "cpu_over_commit_ratio", cpu_over_commit_ratio)
        if dedicated_host_cluster_id is not None:
            pulumi.set(__self__, "dedicated_host_cluster_id", dedicated_host_cluster_id)
        if dedicated_host_name is not None:
            pulumi.set(__self__, "dedicated_host_name", dedicated_host_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detail_fee is not None:
            pulumi.set(__self__, "detail_fee", detail_fee)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if min_quantity is not None:
            pulumi.set(__self__, "min_quantity", min_quantity)
        if network_attributes is not None:
            pulumi.set(__self__, "network_attributes", network_attributes)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if sale_cycle is not None:
            pulumi.set(__self__, "sale_cycle", sale_cycle)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="dedicatedHostType")
    def dedicated_host_type(self) -> pulumi.Input[str]:
        """
        The type of the dedicated host. You can call the [DescribeDedicatedHostTypes](https://www.alibabacloud.com/help/doc-detail/134240.htm) operation to obtain the most recent list of dedicated host types.
        """
        return pulumi.get(self, "dedicated_host_type")

    @dedicated_host_type.setter
    def dedicated_host_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "dedicated_host_type", value)

    @property
    @pulumi.getter(name="actionOnMaintenance")
    def action_on_maintenance(self) -> Optional[pulumi.Input[str]]:
        """
        The policy used to migrate the instances from the dedicated host when the dedicated host fails or needs to be repaired online. Valid values: `Migrate`, `Stop`.
        """
        return pulumi.get(self, "action_on_maintenance")

    @action_on_maintenance.setter
    def action_on_maintenance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_on_maintenance", value)

    @property
    @pulumi.getter(name="autoPlacement")
    def auto_placement(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to add the dedicated host to the resource pool for automatic deployment. If you do not specify the DedicatedHostId parameter when you create an instance on a dedicated host, Alibaba Cloud automatically selects a dedicated host from the resource pool to host the instance. Valid values: `on`, `off`. Default: `on`.
        """
        return pulumi.get(self, "auto_placement")

    @auto_placement.setter
    def auto_placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_placement", value)

    @property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> Optional[pulumi.Input[str]]:
        """
        The automatic release time of the dedicated host. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
        """
        return pulumi.get(self, "auto_release_time")

    @auto_release_time.setter
    def auto_release_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_release_time", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically renew the subscription dedicated host.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        The auto-renewal period of the dedicated host. Unit: months. Valid values: `1`, `2`, `3`, `6`, and `12`. takes effect and is required only when the AutoRenew parameter is set to true.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="cpuOverCommitRatio")
    def cpu_over_commit_ratio(self) -> Optional[pulumi.Input[float]]:
        """
        CPU oversold ratio. Only custom specifications g6s, c6s, r6s support setting the CPU oversold ratio.
        """
        return pulumi.get(self, "cpu_over_commit_ratio")

    @cpu_over_commit_ratio.setter
    def cpu_over_commit_ratio(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu_over_commit_ratio", value)

    @property
    @pulumi.getter(name="dedicatedHostClusterId")
    def dedicated_host_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The dedicated host cluster ID to which the dedicated host belongs.
        """
        return pulumi.get(self, "dedicated_host_cluster_id")

    @dedicated_host_cluster_id.setter
    def dedicated_host_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_host_cluster_id", value)

    @property
    @pulumi.getter(name="dedicatedHostName")
    def dedicated_host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the dedicated host. The name must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "dedicated_host_name")

    @dedicated_host_name.setter
    def dedicated_host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_host_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the dedicated host. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="detailFee")
    def detail_fee(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to return the billing details of the order when the billing method is changed from subscription to pay-as-you-go. Default: `false`.
        """
        return pulumi.get(self, "detail_fee")

    @detail_fee.setter
    def detail_fee(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "detail_fee", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to only validate the request. Default: `false`.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[pulumi.Input[str]]:
        """
        The subscription period of the dedicated host. The Period parameter takes effect and is required only when the ChargeType parameter is set to PrePaid.
        """
        return pulumi.get(self, "expired_time")

    @expired_time.setter
    def expired_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expired_time", value)

    @property
    @pulumi.getter(name="minQuantity")
    def min_quantity(self) -> Optional[pulumi.Input[int]]:
        """
        Specify the minimum purchase quantity of a dedicated host.
        """
        return pulumi.get(self, "min_quantity")

    @min_quantity.setter
    def min_quantity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_quantity", value)

    @property
    @pulumi.getter(name="networkAttributes")
    def network_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedHostNetworkAttributeArgs']]]]:
        """
        dedicated host network parameters. contains the following attributes:
        """
        return pulumi.get(self, "network_attributes")

    @network_attributes.setter
    def network_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedHostNetworkAttributeArgs']]]]):
        pulumi.set(self, "network_attributes", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The billing method of the dedicated host. Valid values: `PrePaid`, `PostPaid`. Default: `PostPaid`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group to which the dedicated host belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="saleCycle")
    def sale_cycle(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of the subscription period of the dedicated host.
        """
        return pulumi.get(self, "sale_cycle")

    @sale_cycle.setter
    def sale_cycle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sale_cycle", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of the dedicated host. This parameter is empty by default. If you do not specify this parameter, the system automatically selects a zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _DedicatedHostState:
    def __init__(__self__, *,
                 action_on_maintenance: Optional[pulumi.Input[str]] = None,
                 auto_placement: Optional[pulumi.Input[str]] = None,
                 auto_release_time: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 cpu_over_commit_ratio: Optional[pulumi.Input[float]] = None,
                 dedicated_host_cluster_id: Optional[pulumi.Input[str]] = None,
                 dedicated_host_name: Optional[pulumi.Input[str]] = None,
                 dedicated_host_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 detail_fee: Optional[pulumi.Input[bool]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 expired_time: Optional[pulumi.Input[str]] = None,
                 min_quantity: Optional[pulumi.Input[int]] = None,
                 network_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedHostNetworkAttributeArgs']]]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 sale_cycle: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DedicatedHost resources.
        :param pulumi.Input[str] action_on_maintenance: The policy used to migrate the instances from the dedicated host when the dedicated host fails or needs to be repaired online. Valid values: `Migrate`, `Stop`.
        :param pulumi.Input[str] auto_placement: Specifies whether to add the dedicated host to the resource pool for automatic deployment. If you do not specify the DedicatedHostId parameter when you create an instance on a dedicated host, Alibaba Cloud automatically selects a dedicated host from the resource pool to host the instance. Valid values: `on`, `off`. Default: `on`.
        :param pulumi.Input[str] auto_release_time: The automatic release time of the dedicated host. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
        :param pulumi.Input[bool] auto_renew: Specifies whether to automatically renew the subscription dedicated host.
        :param pulumi.Input[int] auto_renew_period: The auto-renewal period of the dedicated host. Unit: months. Valid values: `1`, `2`, `3`, `6`, and `12`. takes effect and is required only when the AutoRenew parameter is set to true.
        :param pulumi.Input[float] cpu_over_commit_ratio: CPU oversold ratio. Only custom specifications g6s, c6s, r6s support setting the CPU oversold ratio.
        :param pulumi.Input[str] dedicated_host_cluster_id: The dedicated host cluster ID to which the dedicated host belongs.
        :param pulumi.Input[str] dedicated_host_name: The name of the dedicated host. The name must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[str] dedicated_host_type: The type of the dedicated host. You can call the [DescribeDedicatedHostTypes](https://www.alibabacloud.com/help/doc-detail/134240.htm) operation to obtain the most recent list of dedicated host types.
        :param pulumi.Input[str] description: The description of the dedicated host. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[bool] detail_fee: Specifies whether to return the billing details of the order when the billing method is changed from subscription to pay-as-you-go. Default: `false`.
        :param pulumi.Input[bool] dry_run: Specifies whether to only validate the request. Default: `false`.
        :param pulumi.Input[str] expired_time: The subscription period of the dedicated host. The Period parameter takes effect and is required only when the ChargeType parameter is set to PrePaid.
        :param pulumi.Input[int] min_quantity: Specify the minimum purchase quantity of a dedicated host.
        :param pulumi.Input[Sequence[pulumi.Input['DedicatedHostNetworkAttributeArgs']]] network_attributes: dedicated host network parameters. contains the following attributes:
        :param pulumi.Input[str] payment_type: The billing method of the dedicated host. Valid values: `PrePaid`, `PostPaid`. Default: `PostPaid`.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group to which the dedicated host belongs.
        :param pulumi.Input[str] sale_cycle: The unit of the subscription period of the dedicated host.
        :param pulumi.Input[str] status: The status of the dedicated host.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] zone_id: The zone ID of the dedicated host. This parameter is empty by default. If you do not specify this parameter, the system automatically selects a zone.
        """
        if action_on_maintenance is not None:
            pulumi.set(__self__, "action_on_maintenance", action_on_maintenance)
        if auto_placement is not None:
            pulumi.set(__self__, "auto_placement", auto_placement)
        if auto_release_time is not None:
            pulumi.set(__self__, "auto_release_time", auto_release_time)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if cpu_over_commit_ratio is not None:
            pulumi.set(__self__, "cpu_over_commit_ratio", cpu_over_commit_ratio)
        if dedicated_host_cluster_id is not None:
            pulumi.set(__self__, "dedicated_host_cluster_id", dedicated_host_cluster_id)
        if dedicated_host_name is not None:
            pulumi.set(__self__, "dedicated_host_name", dedicated_host_name)
        if dedicated_host_type is not None:
            pulumi.set(__self__, "dedicated_host_type", dedicated_host_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detail_fee is not None:
            pulumi.set(__self__, "detail_fee", detail_fee)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if min_quantity is not None:
            pulumi.set(__self__, "min_quantity", min_quantity)
        if network_attributes is not None:
            pulumi.set(__self__, "network_attributes", network_attributes)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if sale_cycle is not None:
            pulumi.set(__self__, "sale_cycle", sale_cycle)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="actionOnMaintenance")
    def action_on_maintenance(self) -> Optional[pulumi.Input[str]]:
        """
        The policy used to migrate the instances from the dedicated host when the dedicated host fails or needs to be repaired online. Valid values: `Migrate`, `Stop`.
        """
        return pulumi.get(self, "action_on_maintenance")

    @action_on_maintenance.setter
    def action_on_maintenance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action_on_maintenance", value)

    @property
    @pulumi.getter(name="autoPlacement")
    def auto_placement(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to add the dedicated host to the resource pool for automatic deployment. If you do not specify the DedicatedHostId parameter when you create an instance on a dedicated host, Alibaba Cloud automatically selects a dedicated host from the resource pool to host the instance. Valid values: `on`, `off`. Default: `on`.
        """
        return pulumi.get(self, "auto_placement")

    @auto_placement.setter
    def auto_placement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_placement", value)

    @property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> Optional[pulumi.Input[str]]:
        """
        The automatic release time of the dedicated host. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
        """
        return pulumi.get(self, "auto_release_time")

    @auto_release_time.setter
    def auto_release_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_release_time", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically renew the subscription dedicated host.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        The auto-renewal period of the dedicated host. Unit: months. Valid values: `1`, `2`, `3`, `6`, and `12`. takes effect and is required only when the AutoRenew parameter is set to true.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="cpuOverCommitRatio")
    def cpu_over_commit_ratio(self) -> Optional[pulumi.Input[float]]:
        """
        CPU oversold ratio. Only custom specifications g6s, c6s, r6s support setting the CPU oversold ratio.
        """
        return pulumi.get(self, "cpu_over_commit_ratio")

    @cpu_over_commit_ratio.setter
    def cpu_over_commit_ratio(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu_over_commit_ratio", value)

    @property
    @pulumi.getter(name="dedicatedHostClusterId")
    def dedicated_host_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The dedicated host cluster ID to which the dedicated host belongs.
        """
        return pulumi.get(self, "dedicated_host_cluster_id")

    @dedicated_host_cluster_id.setter
    def dedicated_host_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_host_cluster_id", value)

    @property
    @pulumi.getter(name="dedicatedHostName")
    def dedicated_host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the dedicated host. The name must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "dedicated_host_name")

    @dedicated_host_name.setter
    def dedicated_host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_host_name", value)

    @property
    @pulumi.getter(name="dedicatedHostType")
    def dedicated_host_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the dedicated host. You can call the [DescribeDedicatedHostTypes](https://www.alibabacloud.com/help/doc-detail/134240.htm) operation to obtain the most recent list of dedicated host types.
        """
        return pulumi.get(self, "dedicated_host_type")

    @dedicated_host_type.setter
    def dedicated_host_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_host_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the dedicated host. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="detailFee")
    def detail_fee(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to return the billing details of the order when the billing method is changed from subscription to pay-as-you-go. Default: `false`.
        """
        return pulumi.get(self, "detail_fee")

    @detail_fee.setter
    def detail_fee(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "detail_fee", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to only validate the request. Default: `false`.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[pulumi.Input[str]]:
        """
        The subscription period of the dedicated host. The Period parameter takes effect and is required only when the ChargeType parameter is set to PrePaid.
        """
        return pulumi.get(self, "expired_time")

    @expired_time.setter
    def expired_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expired_time", value)

    @property
    @pulumi.getter(name="minQuantity")
    def min_quantity(self) -> Optional[pulumi.Input[int]]:
        """
        Specify the minimum purchase quantity of a dedicated host.
        """
        return pulumi.get(self, "min_quantity")

    @min_quantity.setter
    def min_quantity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_quantity", value)

    @property
    @pulumi.getter(name="networkAttributes")
    def network_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedHostNetworkAttributeArgs']]]]:
        """
        dedicated host network parameters. contains the following attributes:
        """
        return pulumi.get(self, "network_attributes")

    @network_attributes.setter
    def network_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedHostNetworkAttributeArgs']]]]):
        pulumi.set(self, "network_attributes", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The billing method of the dedicated host. Valid values: `PrePaid`, `PostPaid`. Default: `PostPaid`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group to which the dedicated host belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="saleCycle")
    def sale_cycle(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of the subscription period of the dedicated host.
        """
        return pulumi.get(self, "sale_cycle")

    @sale_cycle.setter
    def sale_cycle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sale_cycle", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the dedicated host.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of the dedicated host. This parameter is empty by default. If you do not specify this parameter, the system automatically selects a zone.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class DedicatedHost(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_on_maintenance: Optional[pulumi.Input[str]] = None,
                 auto_placement: Optional[pulumi.Input[str]] = None,
                 auto_release_time: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 cpu_over_commit_ratio: Optional[pulumi.Input[float]] = None,
                 dedicated_host_cluster_id: Optional[pulumi.Input[str]] = None,
                 dedicated_host_name: Optional[pulumi.Input[str]] = None,
                 dedicated_host_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 detail_fee: Optional[pulumi.Input[bool]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 expired_time: Optional[pulumi.Input[str]] = None,
                 min_quantity: Optional[pulumi.Input[int]] = None,
                 network_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DedicatedHostNetworkAttributeArgs']]]]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 sale_cycle: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Ecs dedicated host can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/dedicatedHost:DedicatedHost default dh-2zedmxxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action_on_maintenance: The policy used to migrate the instances from the dedicated host when the dedicated host fails or needs to be repaired online. Valid values: `Migrate`, `Stop`.
        :param pulumi.Input[str] auto_placement: Specifies whether to add the dedicated host to the resource pool for automatic deployment. If you do not specify the DedicatedHostId parameter when you create an instance on a dedicated host, Alibaba Cloud automatically selects a dedicated host from the resource pool to host the instance. Valid values: `on`, `off`. Default: `on`.
        :param pulumi.Input[str] auto_release_time: The automatic release time of the dedicated host. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
        :param pulumi.Input[bool] auto_renew: Specifies whether to automatically renew the subscription dedicated host.
        :param pulumi.Input[int] auto_renew_period: The auto-renewal period of the dedicated host. Unit: months. Valid values: `1`, `2`, `3`, `6`, and `12`. takes effect and is required only when the AutoRenew parameter is set to true.
        :param pulumi.Input[float] cpu_over_commit_ratio: CPU oversold ratio. Only custom specifications g6s, c6s, r6s support setting the CPU oversold ratio.
        :param pulumi.Input[str] dedicated_host_cluster_id: The dedicated host cluster ID to which the dedicated host belongs.
        :param pulumi.Input[str] dedicated_host_name: The name of the dedicated host. The name must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[str] dedicated_host_type: The type of the dedicated host. You can call the [DescribeDedicatedHostTypes](https://www.alibabacloud.com/help/doc-detail/134240.htm) operation to obtain the most recent list of dedicated host types.
        :param pulumi.Input[str] description: The description of the dedicated host. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[bool] detail_fee: Specifies whether to return the billing details of the order when the billing method is changed from subscription to pay-as-you-go. Default: `false`.
        :param pulumi.Input[bool] dry_run: Specifies whether to only validate the request. Default: `false`.
        :param pulumi.Input[str] expired_time: The subscription period of the dedicated host. The Period parameter takes effect and is required only when the ChargeType parameter is set to PrePaid.
        :param pulumi.Input[int] min_quantity: Specify the minimum purchase quantity of a dedicated host.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DedicatedHostNetworkAttributeArgs']]]] network_attributes: dedicated host network parameters. contains the following attributes:
        :param pulumi.Input[str] payment_type: The billing method of the dedicated host. Valid values: `PrePaid`, `PostPaid`. Default: `PostPaid`.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group to which the dedicated host belongs.
        :param pulumi.Input[str] sale_cycle: The unit of the subscription period of the dedicated host.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] zone_id: The zone ID of the dedicated host. This parameter is empty by default. If you do not specify this parameter, the system automatically selects a zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DedicatedHostArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Ecs dedicated host can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/dedicatedHost:DedicatedHost default dh-2zedmxxxx
        ```

        :param str resource_name: The name of the resource.
        :param DedicatedHostArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DedicatedHostArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_on_maintenance: Optional[pulumi.Input[str]] = None,
                 auto_placement: Optional[pulumi.Input[str]] = None,
                 auto_release_time: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 cpu_over_commit_ratio: Optional[pulumi.Input[float]] = None,
                 dedicated_host_cluster_id: Optional[pulumi.Input[str]] = None,
                 dedicated_host_name: Optional[pulumi.Input[str]] = None,
                 dedicated_host_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 detail_fee: Optional[pulumi.Input[bool]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 expired_time: Optional[pulumi.Input[str]] = None,
                 min_quantity: Optional[pulumi.Input[int]] = None,
                 network_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DedicatedHostNetworkAttributeArgs']]]]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 sale_cycle: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DedicatedHostArgs.__new__(DedicatedHostArgs)

            __props__.__dict__["action_on_maintenance"] = action_on_maintenance
            __props__.__dict__["auto_placement"] = auto_placement
            __props__.__dict__["auto_release_time"] = auto_release_time
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["cpu_over_commit_ratio"] = cpu_over_commit_ratio
            __props__.__dict__["dedicated_host_cluster_id"] = dedicated_host_cluster_id
            __props__.__dict__["dedicated_host_name"] = dedicated_host_name
            if dedicated_host_type is None and not opts.urn:
                raise TypeError("Missing required property 'dedicated_host_type'")
            __props__.__dict__["dedicated_host_type"] = dedicated_host_type
            __props__.__dict__["description"] = description
            __props__.__dict__["detail_fee"] = detail_fee
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["expired_time"] = expired_time
            __props__.__dict__["min_quantity"] = min_quantity
            __props__.__dict__["network_attributes"] = network_attributes
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["sale_cycle"] = sale_cycle
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["status"] = None
        super(DedicatedHost, __self__).__init__(
            'alicloud:ecs/dedicatedHost:DedicatedHost',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_on_maintenance: Optional[pulumi.Input[str]] = None,
            auto_placement: Optional[pulumi.Input[str]] = None,
            auto_release_time: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            auto_renew_period: Optional[pulumi.Input[int]] = None,
            cpu_over_commit_ratio: Optional[pulumi.Input[float]] = None,
            dedicated_host_cluster_id: Optional[pulumi.Input[str]] = None,
            dedicated_host_name: Optional[pulumi.Input[str]] = None,
            dedicated_host_type: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            detail_fee: Optional[pulumi.Input[bool]] = None,
            dry_run: Optional[pulumi.Input[bool]] = None,
            expired_time: Optional[pulumi.Input[str]] = None,
            min_quantity: Optional[pulumi.Input[int]] = None,
            network_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DedicatedHostNetworkAttributeArgs']]]]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            sale_cycle: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'DedicatedHost':
        """
        Get an existing DedicatedHost resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action_on_maintenance: The policy used to migrate the instances from the dedicated host when the dedicated host fails or needs to be repaired online. Valid values: `Migrate`, `Stop`.
        :param pulumi.Input[str] auto_placement: Specifies whether to add the dedicated host to the resource pool for automatic deployment. If you do not specify the DedicatedHostId parameter when you create an instance on a dedicated host, Alibaba Cloud automatically selects a dedicated host from the resource pool to host the instance. Valid values: `on`, `off`. Default: `on`.
        :param pulumi.Input[str] auto_release_time: The automatic release time of the dedicated host. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
        :param pulumi.Input[bool] auto_renew: Specifies whether to automatically renew the subscription dedicated host.
        :param pulumi.Input[int] auto_renew_period: The auto-renewal period of the dedicated host. Unit: months. Valid values: `1`, `2`, `3`, `6`, and `12`. takes effect and is required only when the AutoRenew parameter is set to true.
        :param pulumi.Input[float] cpu_over_commit_ratio: CPU oversold ratio. Only custom specifications g6s, c6s, r6s support setting the CPU oversold ratio.
        :param pulumi.Input[str] dedicated_host_cluster_id: The dedicated host cluster ID to which the dedicated host belongs.
        :param pulumi.Input[str] dedicated_host_name: The name of the dedicated host. The name must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[str] dedicated_host_type: The type of the dedicated host. You can call the [DescribeDedicatedHostTypes](https://www.alibabacloud.com/help/doc-detail/134240.htm) operation to obtain the most recent list of dedicated host types.
        :param pulumi.Input[str] description: The description of the dedicated host. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[bool] detail_fee: Specifies whether to return the billing details of the order when the billing method is changed from subscription to pay-as-you-go. Default: `false`.
        :param pulumi.Input[bool] dry_run: Specifies whether to only validate the request. Default: `false`.
        :param pulumi.Input[str] expired_time: The subscription period of the dedicated host. The Period parameter takes effect and is required only when the ChargeType parameter is set to PrePaid.
        :param pulumi.Input[int] min_quantity: Specify the minimum purchase quantity of a dedicated host.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DedicatedHostNetworkAttributeArgs']]]] network_attributes: dedicated host network parameters. contains the following attributes:
        :param pulumi.Input[str] payment_type: The billing method of the dedicated host. Valid values: `PrePaid`, `PostPaid`. Default: `PostPaid`.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group to which the dedicated host belongs.
        :param pulumi.Input[str] sale_cycle: The unit of the subscription period of the dedicated host.
        :param pulumi.Input[str] status: The status of the dedicated host.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] zone_id: The zone ID of the dedicated host. This parameter is empty by default. If you do not specify this parameter, the system automatically selects a zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DedicatedHostState.__new__(_DedicatedHostState)

        __props__.__dict__["action_on_maintenance"] = action_on_maintenance
        __props__.__dict__["auto_placement"] = auto_placement
        __props__.__dict__["auto_release_time"] = auto_release_time
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["cpu_over_commit_ratio"] = cpu_over_commit_ratio
        __props__.__dict__["dedicated_host_cluster_id"] = dedicated_host_cluster_id
        __props__.__dict__["dedicated_host_name"] = dedicated_host_name
        __props__.__dict__["dedicated_host_type"] = dedicated_host_type
        __props__.__dict__["description"] = description
        __props__.__dict__["detail_fee"] = detail_fee
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["expired_time"] = expired_time
        __props__.__dict__["min_quantity"] = min_quantity
        __props__.__dict__["network_attributes"] = network_attributes
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["sale_cycle"] = sale_cycle
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zone_id"] = zone_id
        return DedicatedHost(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionOnMaintenance")
    def action_on_maintenance(self) -> pulumi.Output[Optional[str]]:
        """
        The policy used to migrate the instances from the dedicated host when the dedicated host fails or needs to be repaired online. Valid values: `Migrate`, `Stop`.
        """
        return pulumi.get(self, "action_on_maintenance")

    @property
    @pulumi.getter(name="autoPlacement")
    def auto_placement(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether to add the dedicated host to the resource pool for automatic deployment. If you do not specify the DedicatedHostId parameter when you create an instance on a dedicated host, Alibaba Cloud automatically selects a dedicated host from the resource pool to host the instance. Valid values: `on`, `off`. Default: `on`.
        """
        return pulumi.get(self, "auto_placement")

    @property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> pulumi.Output[str]:
        """
        The automatic release time of the dedicated host. Specify the time in the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time must be in UTC+0.
        """
        return pulumi.get(self, "auto_release_time")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to automatically renew the subscription dedicated host.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[int]]:
        """
        The auto-renewal period of the dedicated host. Unit: months. Valid values: `1`, `2`, `3`, `6`, and `12`. takes effect and is required only when the AutoRenew parameter is set to true.
        """
        return pulumi.get(self, "auto_renew_period")

    @property
    @pulumi.getter(name="cpuOverCommitRatio")
    def cpu_over_commit_ratio(self) -> pulumi.Output[Optional[float]]:
        """
        CPU oversold ratio. Only custom specifications g6s, c6s, r6s support setting the CPU oversold ratio.
        """
        return pulumi.get(self, "cpu_over_commit_ratio")

    @property
    @pulumi.getter(name="dedicatedHostClusterId")
    def dedicated_host_cluster_id(self) -> pulumi.Output[Optional[str]]:
        """
        The dedicated host cluster ID to which the dedicated host belongs.
        """
        return pulumi.get(self, "dedicated_host_cluster_id")

    @property
    @pulumi.getter(name="dedicatedHostName")
    def dedicated_host_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the dedicated host. The name must be 2 to 128 characters in length. It must start with a letter but cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "dedicated_host_name")

    @property
    @pulumi.getter(name="dedicatedHostType")
    def dedicated_host_type(self) -> pulumi.Output[str]:
        """
        The type of the dedicated host. You can call the [DescribeDedicatedHostTypes](https://www.alibabacloud.com/help/doc-detail/134240.htm) operation to obtain the most recent list of dedicated host types.
        """
        return pulumi.get(self, "dedicated_host_type")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the dedicated host. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="detailFee")
    def detail_fee(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to return the billing details of the order when the billing method is changed from subscription to pay-as-you-go. Default: `false`.
        """
        return pulumi.get(self, "detail_fee")

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to only validate the request. Default: `false`.
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> pulumi.Output[str]:
        """
        The subscription period of the dedicated host. The Period parameter takes effect and is required only when the ChargeType parameter is set to PrePaid.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="minQuantity")
    def min_quantity(self) -> pulumi.Output[Optional[int]]:
        """
        Specify the minimum purchase quantity of a dedicated host.
        """
        return pulumi.get(self, "min_quantity")

    @property
    @pulumi.getter(name="networkAttributes")
    def network_attributes(self) -> pulumi.Output[Optional[Sequence['outputs.DedicatedHostNetworkAttribute']]]:
        """
        dedicated host network parameters. contains the following attributes:
        """
        return pulumi.get(self, "network_attributes")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The billing method of the dedicated host. Valid values: `PrePaid`, `PostPaid`. Default: `PostPaid`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group to which the dedicated host belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="saleCycle")
    def sale_cycle(self) -> pulumi.Output[str]:
        """
        The unit of the subscription period of the dedicated host.
        """
        return pulumi.get(self, "sale_cycle")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the dedicated host.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone ID of the dedicated host. This parameter is empty by default. If you do not specify this parameter, the system automatically selects a zone.
        """
        return pulumi.get(self, "zone_id")

