# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DiskAttachmentArgs', 'DiskAttachment']

@pulumi.input_type
class DiskAttachmentArgs:
    def __init__(__self__, *,
                 disk_id: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 bootable: Optional[pulumi.Input[bool]] = None,
                 delete_with_instance: Optional[pulumi.Input[bool]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DiskAttachment resource.
        :param pulumi.Input[str] disk_id: ID of the Disk to be attached.
        :param pulumi.Input[str] instance_id: ID of the Instance to attach to.
        """
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "instance_id", instance_id)
        if bootable is not None:
            pulumi.set(__self__, "bootable", bootable)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Input[str]:
        """
        ID of the Disk to be attached.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "disk_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        ID of the Instance to attach to.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def bootable(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "bootable")

    @bootable.setter
    def bootable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bootable", value)

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_with_instance")

    @delete_with_instance.setter
    def delete_with_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_with_instance", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)


@pulumi.input_type
class _DiskAttachmentState:
    def __init__(__self__, *,
                 bootable: Optional[pulumi.Input[bool]] = None,
                 delete_with_instance: Optional[pulumi.Input[bool]] = None,
                 device: Optional[pulumi.Input[str]] = None,
                 disk_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DiskAttachment resources.
        :param pulumi.Input[str] disk_id: ID of the Disk to be attached.
        :param pulumi.Input[str] instance_id: ID of the Instance to attach to.
        """
        if bootable is not None:
            pulumi.set(__self__, "bootable", bootable)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disk_id is not None:
            pulumi.set(__self__, "disk_id", disk_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if password is not None:
            pulumi.set(__self__, "password", password)

    @property
    @pulumi.getter
    def bootable(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "bootable")

    @bootable.setter
    def bootable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "bootable", value)

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "delete_with_instance")

    @delete_with_instance.setter
    def delete_with_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_with_instance", value)

    @property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device", value)

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Disk to be attached.
        """
        return pulumi.get(self, "disk_id")

    @disk_id.setter
    def disk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the Instance to attach to.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)


class DiskAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bootable: Optional[pulumi.Input[bool]] = None,
                 delete_with_instance: Optional[pulumi.Input[bool]] = None,
                 disk_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        > **DEPRECATED:** This resource has been renamed to ecs.EcsDiskAttachment from version 1.122.0.

        Provides an Alicloud ECS Disk Attachment as a resource, to attach and detach disks from ECS Instances.

        ## Example Usage

        Basic usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        # Create a new ECS disk-attachment and use it attach one disk to a new instance.
        ecs_sg = alicloud.ecs.SecurityGroup("ecsSg", description="New security group")
        ecs_disk = alicloud.ecs.Disk("ecsDisk",
            availability_zone="cn-beijing-a",
            size=50,
            tags={
                "Name": "TerraformTest-disk",
            })
        ecs_instance = alicloud.ecs.Instance("ecsInstance",
            image_id="ubuntu_18_04_64_20G_alibase_20190624.vhd",
            instance_type="ecs.n4.small",
            availability_zone="cn-beijing-a",
            security_groups=[ecs_sg.id],
            instance_name="Hello",
            internet_charge_type="PayByBandwidth",
            tags={
                "Name": "TerraformTest-instance",
            })
        ecs_disk_att = alicloud.ecs.DiskAttachment("ecsDiskAtt",
            disk_id=ecs_disk.id,
            instance_id=ecs_instance.id)
        ```

        ## Import

        The disk attachment can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/diskAttachment:DiskAttachment example d-abc12345678:i-abc12355
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] disk_id: ID of the Disk to be attached.
        :param pulumi.Input[str] instance_id: ID of the Instance to attach to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DiskAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **DEPRECATED:** This resource has been renamed to ecs.EcsDiskAttachment from version 1.122.0.

        Provides an Alicloud ECS Disk Attachment as a resource, to attach and detach disks from ECS Instances.

        ## Example Usage

        Basic usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        # Create a new ECS disk-attachment and use it attach one disk to a new instance.
        ecs_sg = alicloud.ecs.SecurityGroup("ecsSg", description="New security group")
        ecs_disk = alicloud.ecs.Disk("ecsDisk",
            availability_zone="cn-beijing-a",
            size=50,
            tags={
                "Name": "TerraformTest-disk",
            })
        ecs_instance = alicloud.ecs.Instance("ecsInstance",
            image_id="ubuntu_18_04_64_20G_alibase_20190624.vhd",
            instance_type="ecs.n4.small",
            availability_zone="cn-beijing-a",
            security_groups=[ecs_sg.id],
            instance_name="Hello",
            internet_charge_type="PayByBandwidth",
            tags={
                "Name": "TerraformTest-instance",
            })
        ecs_disk_att = alicloud.ecs.DiskAttachment("ecsDiskAtt",
            disk_id=ecs_disk.id,
            instance_id=ecs_instance.id)
        ```

        ## Import

        The disk attachment can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/diskAttachment:DiskAttachment example d-abc12345678:i-abc12355
        ```

        :param str resource_name: The name of the resource.
        :param DiskAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DiskAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bootable: Optional[pulumi.Input[bool]] = None,
                 delete_with_instance: Optional[pulumi.Input[bool]] = None,
                 disk_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DiskAttachmentArgs.__new__(DiskAttachmentArgs)

            __props__.__dict__["bootable"] = bootable
            __props__.__dict__["delete_with_instance"] = delete_with_instance
            if disk_id is None and not opts.urn:
                raise TypeError("Missing required property 'disk_id'")
            __props__.__dict__["disk_id"] = disk_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["password"] = password
            __props__.__dict__["device"] = None
        super(DiskAttachment, __self__).__init__(
            'alicloud:ecs/diskAttachment:DiskAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bootable: Optional[pulumi.Input[bool]] = None,
            delete_with_instance: Optional[pulumi.Input[bool]] = None,
            device: Optional[pulumi.Input[str]] = None,
            disk_id: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            key_pair_name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None) -> 'DiskAttachment':
        """
        Get an existing DiskAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] disk_id: ID of the Disk to be attached.
        :param pulumi.Input[str] instance_id: ID of the Instance to attach to.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DiskAttachmentState.__new__(_DiskAttachmentState)

        __props__.__dict__["bootable"] = bootable
        __props__.__dict__["delete_with_instance"] = delete_with_instance
        __props__.__dict__["device"] = device
        __props__.__dict__["disk_id"] = disk_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["password"] = password
        return DiskAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bootable(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "bootable")

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "delete_with_instance")

    @property
    @pulumi.getter
    def device(self) -> pulumi.Output[str]:
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> pulumi.Output[str]:
        """
        ID of the Disk to be attached.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        ID of the Instance to attach to.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "password")

