# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['EcsImagePipelineArgs', 'EcsImagePipeline']

@pulumi.input_type
class EcsImagePipelineArgs:
    def __init__(__self__, *,
                 base_image: pulumi.Input[str],
                 base_image_type: pulumi.Input[str],
                 add_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 build_content: Optional[pulumi.Input[str]] = None,
                 delete_instance_on_failure: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 to_region_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EcsImagePipeline resource.
        :param pulumi.Input[str] base_image: The source image. When you set `base_image_type` to `IMAGE`, set `base_image` to the ID of a custom image. When you set `base_image_type` to `IMAGE_FAMILY`, set `base_image` to the name of an image family.
        :param pulumi.Input[str] base_image_type: The type of the source image. Valid values: `IMAGE`, `IMAGE_FAMILY`.
               - IMAGE: custom image.
               - IMAGE_FAMILY: image family.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] add_accounts: The ID of Alibaba Cloud account to which to share the created image.
        :param pulumi.Input[str] build_content: The content of the image template. The content cannot be greater than 16 KB in size, and can contain up to 127 commands.
        :param pulumi.Input[bool] delete_instance_on_failure: Specifies whether to release the intermediate instance if the image cannot be created.
        :param pulumi.Input[str] description: The description of the image template. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`. **Note:** If the intermediate instance cannot be started, the instance is released by default.
        :param pulumi.Input[str] image_name: The name prefix of the image to be created. The prefix must be `2` to `64` characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.),and hyphens (-).
        :param pulumi.Input[str] instance_type: The instance type of the instance. You can call the DescribeInstanceTypes operation to query instance types. If you do not specify this parameter, an instance type that provides the fewest vCPUs and memory resources is automatically selected. This configuration is subject to resource availability of instance types. For example, the `ecs.g6.large` instance type is selected by default. If available `ecs.g6.large` resources are insufficient, the `ecs.g6.xlarge` instance type is selected.
        :param pulumi.Input[int] internet_max_bandwidth_out: The size of the outbound public bandwidth for the intermediate instance. Unit: `Mbit/s`. Valid values: `0` to `100`. Default value: `0`.
        :param pulumi.Input[str] name: The name of the image template. The name must be `2` to `128` characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.),and hyphens (-).
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[int] system_disk_size: The size of the system disk of the intermediate instance. Unit: GiB. Valid values: `20` to `500`. Default value: `40`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] to_region_ids: The ID of region to which to distribute the created image.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch. If you do not specify this parameter, a virtual private cloud (VPC) and a vSwitch are created by default.
        """
        pulumi.set(__self__, "base_image", base_image)
        pulumi.set(__self__, "base_image_type", base_image_type)
        if add_accounts is not None:
            pulumi.set(__self__, "add_accounts", add_accounts)
        if build_content is not None:
            pulumi.set(__self__, "build_content", build_content)
        if delete_instance_on_failure is not None:
            pulumi.set(__self__, "delete_instance_on_failure", delete_instance_on_failure)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if to_region_ids is not None:
            pulumi.set(__self__, "to_region_ids", to_region_ids)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="baseImage")
    def base_image(self) -> pulumi.Input[str]:
        """
        The source image. When you set `base_image_type` to `IMAGE`, set `base_image` to the ID of a custom image. When you set `base_image_type` to `IMAGE_FAMILY`, set `base_image` to the name of an image family.
        """
        return pulumi.get(self, "base_image")

    @base_image.setter
    def base_image(self, value: pulumi.Input[str]):
        pulumi.set(self, "base_image", value)

    @property
    @pulumi.getter(name="baseImageType")
    def base_image_type(self) -> pulumi.Input[str]:
        """
        The type of the source image. Valid values: `IMAGE`, `IMAGE_FAMILY`.
        - IMAGE: custom image.
        - IMAGE_FAMILY: image family.
        """
        return pulumi.get(self, "base_image_type")

    @base_image_type.setter
    def base_image_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "base_image_type", value)

    @property
    @pulumi.getter(name="addAccounts")
    def add_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID of Alibaba Cloud account to which to share the created image.
        """
        return pulumi.get(self, "add_accounts")

    @add_accounts.setter
    def add_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "add_accounts", value)

    @property
    @pulumi.getter(name="buildContent")
    def build_content(self) -> Optional[pulumi.Input[str]]:
        """
        The content of the image template. The content cannot be greater than 16 KB in size, and can contain up to 127 commands.
        """
        return pulumi.get(self, "build_content")

    @build_content.setter
    def build_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_content", value)

    @property
    @pulumi.getter(name="deleteInstanceOnFailure")
    def delete_instance_on_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to release the intermediate instance if the image cannot be created.
        """
        return pulumi.get(self, "delete_instance_on_failure")

    @delete_instance_on_failure.setter
    def delete_instance_on_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_instance_on_failure", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the image template. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`. **Note:** If the intermediate instance cannot be started, the instance is released by default.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name prefix of the image to be created. The prefix must be `2` to `64` characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.),and hyphens (-).
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type of the instance. You can call the DescribeInstanceTypes operation to query instance types. If you do not specify this parameter, an instance type that provides the fewest vCPUs and memory resources is automatically selected. This configuration is subject to resource availability of instance types. For example, the `ecs.g6.large` instance type is selected by default. If available `ecs.g6.large` resources are insufficient, the `ecs.g6.xlarge` instance type is selected.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the outbound public bandwidth for the intermediate instance. Unit: `Mbit/s`. Valid values: `0` to `100`. Default value: `0`.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the image template. The name must be `2` to `128` characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.),and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the system disk of the intermediate instance. Unit: GiB. Valid values: `20` to `500`. Default value: `40`.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "system_disk_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="toRegionIds")
    def to_region_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID of region to which to distribute the created image.
        """
        return pulumi.get(self, "to_region_ids")

    @to_region_ids.setter
    def to_region_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "to_region_ids", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the vSwitch. If you do not specify this parameter, a virtual private cloud (VPC) and a vSwitch are created by default.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _EcsImagePipelineState:
    def __init__(__self__, *,
                 add_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 base_image: Optional[pulumi.Input[str]] = None,
                 base_image_type: Optional[pulumi.Input[str]] = None,
                 build_content: Optional[pulumi.Input[str]] = None,
                 delete_instance_on_failure: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 to_region_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EcsImagePipeline resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] add_accounts: The ID of Alibaba Cloud account to which to share the created image.
        :param pulumi.Input[str] base_image: The source image. When you set `base_image_type` to `IMAGE`, set `base_image` to the ID of a custom image. When you set `base_image_type` to `IMAGE_FAMILY`, set `base_image` to the name of an image family.
        :param pulumi.Input[str] base_image_type: The type of the source image. Valid values: `IMAGE`, `IMAGE_FAMILY`.
               - IMAGE: custom image.
               - IMAGE_FAMILY: image family.
        :param pulumi.Input[str] build_content: The content of the image template. The content cannot be greater than 16 KB in size, and can contain up to 127 commands.
        :param pulumi.Input[bool] delete_instance_on_failure: Specifies whether to release the intermediate instance if the image cannot be created.
        :param pulumi.Input[str] description: The description of the image template. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`. **Note:** If the intermediate instance cannot be started, the instance is released by default.
        :param pulumi.Input[str] image_name: The name prefix of the image to be created. The prefix must be `2` to `64` characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.),and hyphens (-).
        :param pulumi.Input[str] instance_type: The instance type of the instance. You can call the DescribeInstanceTypes operation to query instance types. If you do not specify this parameter, an instance type that provides the fewest vCPUs and memory resources is automatically selected. This configuration is subject to resource availability of instance types. For example, the `ecs.g6.large` instance type is selected by default. If available `ecs.g6.large` resources are insufficient, the `ecs.g6.xlarge` instance type is selected.
        :param pulumi.Input[int] internet_max_bandwidth_out: The size of the outbound public bandwidth for the intermediate instance. Unit: `Mbit/s`. Valid values: `0` to `100`. Default value: `0`.
        :param pulumi.Input[str] name: The name of the image template. The name must be `2` to `128` characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.),and hyphens (-).
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[int] system_disk_size: The size of the system disk of the intermediate instance. Unit: GiB. Valid values: `20` to `500`. Default value: `40`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] to_region_ids: The ID of region to which to distribute the created image.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch. If you do not specify this parameter, a virtual private cloud (VPC) and a vSwitch are created by default.
        """
        if add_accounts is not None:
            pulumi.set(__self__, "add_accounts", add_accounts)
        if base_image is not None:
            pulumi.set(__self__, "base_image", base_image)
        if base_image_type is not None:
            pulumi.set(__self__, "base_image_type", base_image_type)
        if build_content is not None:
            pulumi.set(__self__, "build_content", build_content)
        if delete_instance_on_failure is not None:
            pulumi.set(__self__, "delete_instance_on_failure", delete_instance_on_failure)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if to_region_ids is not None:
            pulumi.set(__self__, "to_region_ids", to_region_ids)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="addAccounts")
    def add_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID of Alibaba Cloud account to which to share the created image.
        """
        return pulumi.get(self, "add_accounts")

    @add_accounts.setter
    def add_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "add_accounts", value)

    @property
    @pulumi.getter(name="baseImage")
    def base_image(self) -> Optional[pulumi.Input[str]]:
        """
        The source image. When you set `base_image_type` to `IMAGE`, set `base_image` to the ID of a custom image. When you set `base_image_type` to `IMAGE_FAMILY`, set `base_image` to the name of an image family.
        """
        return pulumi.get(self, "base_image")

    @base_image.setter
    def base_image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_image", value)

    @property
    @pulumi.getter(name="baseImageType")
    def base_image_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the source image. Valid values: `IMAGE`, `IMAGE_FAMILY`.
        - IMAGE: custom image.
        - IMAGE_FAMILY: image family.
        """
        return pulumi.get(self, "base_image_type")

    @base_image_type.setter
    def base_image_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "base_image_type", value)

    @property
    @pulumi.getter(name="buildContent")
    def build_content(self) -> Optional[pulumi.Input[str]]:
        """
        The content of the image template. The content cannot be greater than 16 KB in size, and can contain up to 127 commands.
        """
        return pulumi.get(self, "build_content")

    @build_content.setter
    def build_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_content", value)

    @property
    @pulumi.getter(name="deleteInstanceOnFailure")
    def delete_instance_on_failure(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to release the intermediate instance if the image cannot be created.
        """
        return pulumi.get(self, "delete_instance_on_failure")

    @delete_instance_on_failure.setter
    def delete_instance_on_failure(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_instance_on_failure", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the image template. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`. **Note:** If the intermediate instance cannot be started, the instance is released by default.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name prefix of the image to be created. The prefix must be `2` to `64` characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.),and hyphens (-).
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type of the instance. You can call the DescribeInstanceTypes operation to query instance types. If you do not specify this parameter, an instance type that provides the fewest vCPUs and memory resources is automatically selected. This configuration is subject to resource availability of instance types. For example, the `ecs.g6.large` instance type is selected by default. If available `ecs.g6.large` resources are insufficient, the `ecs.g6.xlarge` instance type is selected.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the outbound public bandwidth for the intermediate instance. Unit: `Mbit/s`. Valid values: `0` to `100`. Default value: `0`.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the image template. The name must be `2` to `128` characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.),and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the system disk of the intermediate instance. Unit: GiB. Valid values: `20` to `500`. Default value: `40`.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "system_disk_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="toRegionIds")
    def to_region_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID of region to which to distribute the created image.
        """
        return pulumi.get(self, "to_region_ids")

    @to_region_ids.setter
    def to_region_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "to_region_ids", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the vSwitch. If you do not specify this parameter, a virtual private cloud (VPC) and a vSwitch are created by default.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)


class EcsImagePipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 base_image: Optional[pulumi.Input[str]] = None,
                 base_image_type: Optional[pulumi.Input[str]] = None,
                 build_content: Optional[pulumi.Input[str]] = None,
                 delete_instance_on_failure: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 to_region_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a ECS Image Pipeline resource.

        For information about ECS Image Pipeline and how to use it, see [What is Image Pipeline](https://www.alibabacloud.com/help/en/doc-detail/200427.html).

        > **NOTE:** Available in v1.163.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_resource_groups = alicloud.resourcemanager.get_resource_groups(name_regex="default")
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
            most_recent=True,
            owners="system")
        default_instance_types = alicloud.ecs.get_instance_types(image_id=default_images.ids[0])
        default_account = alicloud.get_account()
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name="terraform-example",
            cidr_block="172.17.3.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_ecs_image_pipeline = alicloud.ecs.EcsImagePipeline("defaultEcsImagePipeline",
            add_accounts=[default_account.id],
            base_image=default_images.ids[0],
            base_image_type="IMAGE",
            build_content="RUN yum update -y",
            delete_instance_on_failure=False,
            image_name="terraform-example",
            description="terraform-example",
            instance_type=default_instance_types.ids[0],
            resource_group_id=default_resource_groups.groups[0].id,
            internet_max_bandwidth_out=20,
            system_disk_size=40,
            to_region_ids=[
                "cn-qingdao",
                "cn-zhangjiakou",
            ],
            vswitch_id=default_switch.id,
            tags={
                "Created": "TF",
                "For": "Acceptance-test",
            })
        ```

        ## Import

        ECS Image Pipeline can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/ecsImagePipeline:EcsImagePipeline example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] add_accounts: The ID of Alibaba Cloud account to which to share the created image.
        :param pulumi.Input[str] base_image: The source image. When you set `base_image_type` to `IMAGE`, set `base_image` to the ID of a custom image. When you set `base_image_type` to `IMAGE_FAMILY`, set `base_image` to the name of an image family.
        :param pulumi.Input[str] base_image_type: The type of the source image. Valid values: `IMAGE`, `IMAGE_FAMILY`.
               - IMAGE: custom image.
               - IMAGE_FAMILY: image family.
        :param pulumi.Input[str] build_content: The content of the image template. The content cannot be greater than 16 KB in size, and can contain up to 127 commands.
        :param pulumi.Input[bool] delete_instance_on_failure: Specifies whether to release the intermediate instance if the image cannot be created.
        :param pulumi.Input[str] description: The description of the image template. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`. **Note:** If the intermediate instance cannot be started, the instance is released by default.
        :param pulumi.Input[str] image_name: The name prefix of the image to be created. The prefix must be `2` to `64` characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.),and hyphens (-).
        :param pulumi.Input[str] instance_type: The instance type of the instance. You can call the DescribeInstanceTypes operation to query instance types. If you do not specify this parameter, an instance type that provides the fewest vCPUs and memory resources is automatically selected. This configuration is subject to resource availability of instance types. For example, the `ecs.g6.large` instance type is selected by default. If available `ecs.g6.large` resources are insufficient, the `ecs.g6.xlarge` instance type is selected.
        :param pulumi.Input[int] internet_max_bandwidth_out: The size of the outbound public bandwidth for the intermediate instance. Unit: `Mbit/s`. Valid values: `0` to `100`. Default value: `0`.
        :param pulumi.Input[str] name: The name of the image template. The name must be `2` to `128` characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.),and hyphens (-).
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[int] system_disk_size: The size of the system disk of the intermediate instance. Unit: GiB. Valid values: `20` to `500`. Default value: `40`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] to_region_ids: The ID of region to which to distribute the created image.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch. If you do not specify this parameter, a virtual private cloud (VPC) and a vSwitch are created by default.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EcsImagePipelineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECS Image Pipeline resource.

        For information about ECS Image Pipeline and how to use it, see [What is Image Pipeline](https://www.alibabacloud.com/help/en/doc-detail/200427.html).

        > **NOTE:** Available in v1.163.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_resource_groups = alicloud.resourcemanager.get_resource_groups(name_regex="default")
        default_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
            most_recent=True,
            owners="system")
        default_instance_types = alicloud.ecs.get_instance_types(image_id=default_images.ids[0])
        default_account = alicloud.get_account()
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name="terraform-example",
            cidr_block="172.17.3.0/24")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name="terraform-example",
            cidr_block="172.17.3.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_ecs_image_pipeline = alicloud.ecs.EcsImagePipeline("defaultEcsImagePipeline",
            add_accounts=[default_account.id],
            base_image=default_images.ids[0],
            base_image_type="IMAGE",
            build_content="RUN yum update -y",
            delete_instance_on_failure=False,
            image_name="terraform-example",
            description="terraform-example",
            instance_type=default_instance_types.ids[0],
            resource_group_id=default_resource_groups.groups[0].id,
            internet_max_bandwidth_out=20,
            system_disk_size=40,
            to_region_ids=[
                "cn-qingdao",
                "cn-zhangjiakou",
            ],
            vswitch_id=default_switch.id,
            tags={
                "Created": "TF",
                "For": "Acceptance-test",
            })
        ```

        ## Import

        ECS Image Pipeline can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/ecsImagePipeline:EcsImagePipeline example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EcsImagePipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EcsImagePipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 base_image: Optional[pulumi.Input[str]] = None,
                 base_image_type: Optional[pulumi.Input[str]] = None,
                 build_content: Optional[pulumi.Input[str]] = None,
                 delete_instance_on_failure: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 to_region_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EcsImagePipelineArgs.__new__(EcsImagePipelineArgs)

            __props__.__dict__["add_accounts"] = add_accounts
            if base_image is None and not opts.urn:
                raise TypeError("Missing required property 'base_image'")
            __props__.__dict__["base_image"] = base_image
            if base_image_type is None and not opts.urn:
                raise TypeError("Missing required property 'base_image_type'")
            __props__.__dict__["base_image_type"] = base_image_type
            __props__.__dict__["build_content"] = build_content
            __props__.__dict__["delete_instance_on_failure"] = delete_instance_on_failure
            __props__.__dict__["description"] = description
            __props__.__dict__["image_name"] = image_name
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
            __props__.__dict__["name"] = name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["system_disk_size"] = system_disk_size
            __props__.__dict__["tags"] = tags
            __props__.__dict__["to_region_ids"] = to_region_ids
            __props__.__dict__["vswitch_id"] = vswitch_id
        super(EcsImagePipeline, __self__).__init__(
            'alicloud:ecs/ecsImagePipeline:EcsImagePipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            add_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            base_image: Optional[pulumi.Input[str]] = None,
            base_image_type: Optional[pulumi.Input[str]] = None,
            build_content: Optional[pulumi.Input[str]] = None,
            delete_instance_on_failure: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            image_name: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            system_disk_size: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            to_region_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None) -> 'EcsImagePipeline':
        """
        Get an existing EcsImagePipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] add_accounts: The ID of Alibaba Cloud account to which to share the created image.
        :param pulumi.Input[str] base_image: The source image. When you set `base_image_type` to `IMAGE`, set `base_image` to the ID of a custom image. When you set `base_image_type` to `IMAGE_FAMILY`, set `base_image` to the name of an image family.
        :param pulumi.Input[str] base_image_type: The type of the source image. Valid values: `IMAGE`, `IMAGE_FAMILY`.
               - IMAGE: custom image.
               - IMAGE_FAMILY: image family.
        :param pulumi.Input[str] build_content: The content of the image template. The content cannot be greater than 16 KB in size, and can contain up to 127 commands.
        :param pulumi.Input[bool] delete_instance_on_failure: Specifies whether to release the intermediate instance if the image cannot be created.
        :param pulumi.Input[str] description: The description of the image template. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`. **Note:** If the intermediate instance cannot be started, the instance is released by default.
        :param pulumi.Input[str] image_name: The name prefix of the image to be created. The prefix must be `2` to `64` characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.),and hyphens (-).
        :param pulumi.Input[str] instance_type: The instance type of the instance. You can call the DescribeInstanceTypes operation to query instance types. If you do not specify this parameter, an instance type that provides the fewest vCPUs and memory resources is automatically selected. This configuration is subject to resource availability of instance types. For example, the `ecs.g6.large` instance type is selected by default. If available `ecs.g6.large` resources are insufficient, the `ecs.g6.xlarge` instance type is selected.
        :param pulumi.Input[int] internet_max_bandwidth_out: The size of the outbound public bandwidth for the intermediate instance. Unit: `Mbit/s`. Valid values: `0` to `100`. Default value: `0`.
        :param pulumi.Input[str] name: The name of the image template. The name must be `2` to `128` characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.),and hyphens (-).
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[int] system_disk_size: The size of the system disk of the intermediate instance. Unit: GiB. Valid values: `20` to `500`. Default value: `40`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] to_region_ids: The ID of region to which to distribute the created image.
        :param pulumi.Input[str] vswitch_id: The ID of the vSwitch. If you do not specify this parameter, a virtual private cloud (VPC) and a vSwitch are created by default.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EcsImagePipelineState.__new__(_EcsImagePipelineState)

        __props__.__dict__["add_accounts"] = add_accounts
        __props__.__dict__["base_image"] = base_image
        __props__.__dict__["base_image_type"] = base_image_type
        __props__.__dict__["build_content"] = build_content
        __props__.__dict__["delete_instance_on_failure"] = delete_instance_on_failure
        __props__.__dict__["description"] = description
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["system_disk_size"] = system_disk_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["to_region_ids"] = to_region_ids
        __props__.__dict__["vswitch_id"] = vswitch_id
        return EcsImagePipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addAccounts")
    def add_accounts(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The ID of Alibaba Cloud account to which to share the created image.
        """
        return pulumi.get(self, "add_accounts")

    @property
    @pulumi.getter(name="baseImage")
    def base_image(self) -> pulumi.Output[str]:
        """
        The source image. When you set `base_image_type` to `IMAGE`, set `base_image` to the ID of a custom image. When you set `base_image_type` to `IMAGE_FAMILY`, set `base_image` to the name of an image family.
        """
        return pulumi.get(self, "base_image")

    @property
    @pulumi.getter(name="baseImageType")
    def base_image_type(self) -> pulumi.Output[str]:
        """
        The type of the source image. Valid values: `IMAGE`, `IMAGE_FAMILY`.
        - IMAGE: custom image.
        - IMAGE_FAMILY: image family.
        """
        return pulumi.get(self, "base_image_type")

    @property
    @pulumi.getter(name="buildContent")
    def build_content(self) -> pulumi.Output[Optional[str]]:
        """
        The content of the image template. The content cannot be greater than 16 KB in size, and can contain up to 127 commands.
        """
        return pulumi.get(self, "build_content")

    @property
    @pulumi.getter(name="deleteInstanceOnFailure")
    def delete_instance_on_failure(self) -> pulumi.Output[bool]:
        """
        Specifies whether to release the intermediate instance if the image cannot be created.
        """
        return pulumi.get(self, "delete_instance_on_failure")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the image template. The description must be `2` to `256` characters in length and cannot start with `http://` or `https://`. **Note:** If the intermediate instance cannot be started, the instance is released by default.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name prefix of the image to be created. The prefix must be `2` to `64` characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.),and hyphens (-).
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[str]]:
        """
        The instance type of the instance. You can call the DescribeInstanceTypes operation to query instance types. If you do not specify this parameter, an instance type that provides the fewest vCPUs and memory resources is automatically selected. This configuration is subject to resource availability of instance types. For example, the `ecs.g6.large` instance type is selected by default. If available `ecs.g6.large` resources are insufficient, the `ecs.g6.xlarge` instance type is selected.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> pulumi.Output[int]:
        """
        The size of the outbound public bandwidth for the intermediate instance. Unit: `Mbit/s`. Valid values: `0` to `100`. Default value: `0`.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the image template. The name must be `2` to `128` characters in length. It must start with a letter and cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), periods (.),and hyphens (-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> pulumi.Output[int]:
        """
        The size of the system disk of the intermediate instance. Unit: GiB. Valid values: `20` to `500`. Default value: `40`.
        """
        return pulumi.get(self, "system_disk_size")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="toRegionIds")
    def to_region_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The ID of region to which to distribute the created image.
        """
        return pulumi.get(self, "to_region_ids")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the vSwitch. If you do not specify this parameter, a virtual private cloud (VPC) and a vSwitch are created by default.
        """
        return pulumi.get(self, "vswitch_id")

