# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EcsInstanceSetArgs', 'EcsInstanceSet']

@pulumi.input_type
class EcsInstanceSetArgs:
    def __init__(__self__, *,
                 image_id: pulumi.Input[str],
                 instance_type: pulumi.Input[str],
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 amount: Optional[pulumi.Input[int]] = None,
                 auto_release_time: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 boot_check_os_with_assistant: Optional[pulumi.Input[bool]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetDataDiskArgs']]]] = None,
                 dedicated_host_id: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exclude_instance_filter: Optional[pulumi.Input['EcsInstanceSetExcludeInstanceFilterArgs']] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 launch_template_version: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetNetworkInterfaceArgs']]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 ram_role_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_description: Optional[pulumi.Input[str]] = None,
                 system_disk_name: Optional[pulumi.Input[str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 unique_suffix: Optional[pulumi.Input[bool]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EcsInstanceSet resource.
        :param pulumi.Input[str] image_id: The Image to use for the instance.
        :param pulumi.Input[str] instance_type: The type of instance to start.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of security group ids to associate with.
        :param pulumi.Input[int] amount: The number of instances that you want to create. Valid values: `1` to `100`.
        :param pulumi.Input[str] auto_release_time: The automatic release time of the `PostPaid` instance.
        :param pulumi.Input[bool] auto_renew: Whether to enable auto-renewal for the instance. This parameter is valid only when the `instance_charge_type` is set to `PrePaid`.
        :param pulumi.Input[int] auto_renew_period: Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`.
               - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `6`, `12`.
               - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
        :param pulumi.Input[bool] boot_check_os_with_assistant: Indicate how to check instance ready to use.
        :param pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetDataDiskArgs']]] data_disks: The list of data disks created with instance. See `data_disks` below..
        :param pulumi.Input[str] dedicated_host_id: The ID of the dedicated host on which to create the instance. If the `dedicated_host_id` is specified, the `spot_strategy` and `spot_price_limit`  are ignored. This is because preemptible instances cannot be created on dedicated hosts.
        :param pulumi.Input[bool] deletion_protection: Whether to enable release protection for the instance.
        :param pulumi.Input[str] deployment_set_id: The ID of the deployment set to which to deploy the instance.
        :param pulumi.Input[str] description: The description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with `http://` or `https://`.
        :param pulumi.Input['EcsInstanceSetExcludeInstanceFilterArgs'] exclude_instance_filter: The instances that need to be excluded from the Instance Set.  See `exclude_instance_filter` below.
        :param pulumi.Input[str] host_name: The hostname of instance.
        :param pulumi.Input[str] hpc_cluster_id: The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
        :param pulumi.Input[str] instance_charge_type: The billing method of the instance. Valid values: `PrePaid`, `PostPaid`.
        :param pulumi.Input[str] instance_name: The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with `http://` or `https://`.
        :param pulumi.Input[str] internet_charge_type: The Internet charge type of the instance. Valid values are `PayByBandwidth`, `PayByTraffic`.
        :param pulumi.Input[int] internet_max_bandwidth_out: The Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Valid values: `1` to `100`.
        :param pulumi.Input[str] key_pair_name: The name of key pair that can login ECS instance successfully without password.
        :param pulumi.Input[str] launch_template_id: The ID of the launch template.
        :param pulumi.Input[str] launch_template_name: The name of the launch template. To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
        :param pulumi.Input[str] launch_template_version: The version of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetNetworkInterfaceArgs']]] network_interfaces: A list of NetworkInterface. See `network_interfaces` below..
        :param pulumi.Input[str] password: The password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols.
        :param pulumi.Input[bool] password_inherit: Whether to use the password preset in the image.
        :param pulumi.Input[int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`.
               - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
               - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
        :param pulumi.Input[str] period_unit: The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: `Week`, `Month`.
        :param pulumi.Input[str] ram_role_name: The Instance RAM role name.
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the instance belongs.
        :param pulumi.Input[str] security_enhancement_strategy: The security enhancement strategy.
        :param pulumi.Input[float] spot_price_limit: The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
        :param pulumi.Input[str] spot_strategy: The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'.
        :param pulumi.Input[str] system_disk_auto_snapshot_policy_id: The ID of the automatic snapshot policy applied to the system disk.
        :param pulumi.Input[str] system_disk_category: The category of the system disk. Valid values are `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
        :param pulumi.Input[str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[str] system_disk_name: The name of the system disk.
        :param pulumi.Input[str] system_disk_performance_level: The performance level of the ESSD used as the system disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
        :param pulumi.Input[int] system_disk_size: The size of the system disk, measured in GiB. Value range:  values: `20` to `500`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[bool] unique_suffix: Whether to automatically append incremental suffixes to the hostname specified by the HostName parameter and to the instance name specified by the InstanceName parameter when you batch create instances. The incremental suffixes can range from `001` to `999`.
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch in VPC.
        :param pulumi.Input[str] zone_id: The ID of the zone in which to create the instance.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if auto_release_time is not None:
            pulumi.set(__self__, "auto_release_time", auto_release_time)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if boot_check_os_with_assistant is not None:
            pulumi.set(__self__, "boot_check_os_with_assistant", boot_check_os_with_assistant)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if dedicated_host_id is not None:
            pulumi.set(__self__, "dedicated_host_id", dedicated_host_id)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_instance_filter is not None:
            pulumi.set(__self__, "exclude_instance_filter", exclude_instance_filter)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if hpc_cluster_id is not None:
            pulumi.set(__self__, "hpc_cluster_id", hpc_cluster_id)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if launch_template_version is not None:
            pulumi.set(__self__, "launch_template_version", launch_template_version)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if system_disk_auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "system_disk_auto_snapshot_policy_id", system_disk_auto_snapshot_policy_id)
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_description is not None:
            pulumi.set(__self__, "system_disk_description", system_disk_description)
        if system_disk_name is not None:
            pulumi.set(__self__, "system_disk_name", system_disk_name)
        if system_disk_performance_level is not None:
            pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unique_suffix is not None:
            pulumi.set(__self__, "unique_suffix", unique_suffix)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        The Image to use for the instance.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        The type of instance to start.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of security group ids to associate with.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[int]]:
        """
        The number of instances that you want to create. Valid values: `1` to `100`.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "amount", value)

    @property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> Optional[pulumi.Input[str]]:
        """
        The automatic release time of the `PostPaid` instance.
        """
        return pulumi.get(self, "auto_release_time")

    @auto_release_time.setter
    def auto_release_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_release_time", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable auto-renewal for the instance. This parameter is valid only when the `instance_charge_type` is set to `PrePaid`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`.
        - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `6`, `12`.
        - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="bootCheckOsWithAssistant")
    def boot_check_os_with_assistant(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate how to check instance ready to use.
        """
        return pulumi.get(self, "boot_check_os_with_assistant")

    @boot_check_os_with_assistant.setter
    def boot_check_os_with_assistant(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "boot_check_os_with_assistant", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetDataDiskArgs']]]]:
        """
        The list of data disks created with instance. See `data_disks` below..
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dedicated host on which to create the instance. If the `dedicated_host_id` is specified, the `spot_strategy` and `spot_price_limit`  are ignored. This is because preemptible instances cannot be created on dedicated hosts.
        """
        return pulumi.get(self, "dedicated_host_id")

    @dedicated_host_id.setter
    def dedicated_host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_host_id", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable release protection for the instance.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the deployment set to which to deploy the instance.
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_set_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="excludeInstanceFilter")
    def exclude_instance_filter(self) -> Optional[pulumi.Input['EcsInstanceSetExcludeInstanceFilterArgs']]:
        """
        The instances that need to be excluded from the Instance Set.  See `exclude_instance_filter` below.
        """
        return pulumi.get(self, "exclude_instance_filter")

    @exclude_instance_filter.setter
    def exclude_instance_filter(self, value: Optional[pulumi.Input['EcsInstanceSetExcludeInstanceFilterArgs']]):
        pulumi.set(self, "exclude_instance_filter", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname of instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @hpc_cluster_id.setter
    def hpc_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hpc_cluster_id", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The billing method of the instance. Valid values: `PrePaid`, `PostPaid`.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with `http://` or `https://`.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Internet charge type of the instance. Valid values are `PayByBandwidth`, `PayByTraffic`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[int]]:
        """
        The Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Valid values: `1` to `100`.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of key pair that can login ECS instance successfully without password.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the launch template.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the launch template. To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the launch template.
        """
        return pulumi.get(self, "launch_template_version")

    @launch_template_version.setter
    def launch_template_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_version", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetNetworkInterfaceArgs']]]]:
        """
        A list of NetworkInterface. See `network_interfaces` below..
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use the password preset in the image.
        """
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_inherit", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`.
        - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
        - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: `Week`, `Month`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Instance RAM role name.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ram_role_name", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of resource group which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The security enhancement strategy.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[float]]:
        """
        The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "spot_price_limit", value)

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_strategy", value)

    @property
    @pulumi.getter(name="systemDiskAutoSnapshotPolicyId")
    def system_disk_auto_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the automatic snapshot policy applied to the system disk.
        """
        return pulumi.get(self, "system_disk_auto_snapshot_policy_id")

    @system_disk_auto_snapshot_policy_id.setter
    def system_disk_auto_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_auto_snapshot_policy_id", value)

    @property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The category of the system disk. Valid values are `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
        """
        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_category", value)

    @property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the system disk. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "system_disk_description")

    @system_disk_description.setter
    def system_disk_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_description", value)

    @property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the system disk.
        """
        return pulumi.get(self, "system_disk_name")

    @system_disk_name.setter
    def system_disk_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_name", value)

    @property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        The performance level of the ESSD used as the system disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @system_disk_performance_level.setter
    def system_disk_performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_performance_level", value)

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the system disk, measured in GiB. Value range:  values: `20` to `500`.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "system_disk_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="uniqueSuffix")
    def unique_suffix(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically append incremental suffixes to the hostname specified by the HostName parameter and to the instance name specified by the InstanceName parameter when you batch create instances. The incremental suffixes can range from `001` to `999`.
        """
        return pulumi.get(self, "unique_suffix")

    @unique_suffix.setter
    def unique_suffix(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unique_suffix", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual switch ID to launch in VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the zone in which to create the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _EcsInstanceSetState:
    def __init__(__self__, *,
                 amount: Optional[pulumi.Input[int]] = None,
                 auto_release_time: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 boot_check_os_with_assistant: Optional[pulumi.Input[bool]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetDataDiskArgs']]]] = None,
                 dedicated_host_id: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exclude_instance_filter: Optional[pulumi.Input['EcsInstanceSetExcludeInstanceFilterArgs']] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 launch_template_version: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetNetworkInterfaceArgs']]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 ram_role_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_description: Optional[pulumi.Input[str]] = None,
                 system_disk_name: Optional[pulumi.Input[str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 unique_suffix: Optional[pulumi.Input[bool]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EcsInstanceSet resources.
        :param pulumi.Input[int] amount: The number of instances that you want to create. Valid values: `1` to `100`.
        :param pulumi.Input[str] auto_release_time: The automatic release time of the `PostPaid` instance.
        :param pulumi.Input[bool] auto_renew: Whether to enable auto-renewal for the instance. This parameter is valid only when the `instance_charge_type` is set to `PrePaid`.
        :param pulumi.Input[int] auto_renew_period: Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`.
               - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `6`, `12`.
               - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
        :param pulumi.Input[bool] boot_check_os_with_assistant: Indicate how to check instance ready to use.
        :param pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetDataDiskArgs']]] data_disks: The list of data disks created with instance. See `data_disks` below..
        :param pulumi.Input[str] dedicated_host_id: The ID of the dedicated host on which to create the instance. If the `dedicated_host_id` is specified, the `spot_strategy` and `spot_price_limit`  are ignored. This is because preemptible instances cannot be created on dedicated hosts.
        :param pulumi.Input[bool] deletion_protection: Whether to enable release protection for the instance.
        :param pulumi.Input[str] deployment_set_id: The ID of the deployment set to which to deploy the instance.
        :param pulumi.Input[str] description: The description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with `http://` or `https://`.
        :param pulumi.Input['EcsInstanceSetExcludeInstanceFilterArgs'] exclude_instance_filter: The instances that need to be excluded from the Instance Set.  See `exclude_instance_filter` below.
        :param pulumi.Input[str] host_name: The hostname of instance.
        :param pulumi.Input[str] hpc_cluster_id: The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
        :param pulumi.Input[str] image_id: The Image to use for the instance.
        :param pulumi.Input[str] instance_charge_type: The billing method of the instance. Valid values: `PrePaid`, `PostPaid`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_ids: A list of ECS Instance ID.
        :param pulumi.Input[str] instance_name: The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with `http://` or `https://`.
        :param pulumi.Input[str] instance_type: The type of instance to start.
        :param pulumi.Input[str] internet_charge_type: The Internet charge type of the instance. Valid values are `PayByBandwidth`, `PayByTraffic`.
        :param pulumi.Input[int] internet_max_bandwidth_out: The Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Valid values: `1` to `100`.
        :param pulumi.Input[str] key_pair_name: The name of key pair that can login ECS instance successfully without password.
        :param pulumi.Input[str] launch_template_id: The ID of the launch template.
        :param pulumi.Input[str] launch_template_name: The name of the launch template. To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
        :param pulumi.Input[str] launch_template_version: The version of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetNetworkInterfaceArgs']]] network_interfaces: A list of NetworkInterface. See `network_interfaces` below..
        :param pulumi.Input[str] password: The password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols.
        :param pulumi.Input[bool] password_inherit: Whether to use the password preset in the image.
        :param pulumi.Input[int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`.
               - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
               - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
        :param pulumi.Input[str] period_unit: The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: `Week`, `Month`.
        :param pulumi.Input[str] ram_role_name: The Instance RAM role name.
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the instance belongs.
        :param pulumi.Input[str] security_enhancement_strategy: The security enhancement strategy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of security group ids to associate with.
        :param pulumi.Input[float] spot_price_limit: The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
        :param pulumi.Input[str] spot_strategy: The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'.
        :param pulumi.Input[str] system_disk_auto_snapshot_policy_id: The ID of the automatic snapshot policy applied to the system disk.
        :param pulumi.Input[str] system_disk_category: The category of the system disk. Valid values are `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
        :param pulumi.Input[str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[str] system_disk_name: The name of the system disk.
        :param pulumi.Input[str] system_disk_performance_level: The performance level of the ESSD used as the system disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
        :param pulumi.Input[int] system_disk_size: The size of the system disk, measured in GiB. Value range:  values: `20` to `500`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[bool] unique_suffix: Whether to automatically append incremental suffixes to the hostname specified by the HostName parameter and to the instance name specified by the InstanceName parameter when you batch create instances. The incremental suffixes can range from `001` to `999`.
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch in VPC.
        :param pulumi.Input[str] zone_id: The ID of the zone in which to create the instance.
        """
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if auto_release_time is not None:
            pulumi.set(__self__, "auto_release_time", auto_release_time)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_period is not None:
            pulumi.set(__self__, "auto_renew_period", auto_renew_period)
        if boot_check_os_with_assistant is not None:
            pulumi.set(__self__, "boot_check_os_with_assistant", boot_check_os_with_assistant)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if dedicated_host_id is not None:
            pulumi.set(__self__, "dedicated_host_id", dedicated_host_id)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclude_instance_filter is not None:
            pulumi.set(__self__, "exclude_instance_filter", exclude_instance_filter)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if hpc_cluster_id is not None:
            pulumi.set(__self__, "hpc_cluster_id", hpc_cluster_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_ids is not None:
            pulumi.set(__self__, "instance_ids", instance_ids)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if launch_template_version is not None:
            pulumi.set(__self__, "launch_template_version", launch_template_version)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if system_disk_auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "system_disk_auto_snapshot_policy_id", system_disk_auto_snapshot_policy_id)
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_description is not None:
            pulumi.set(__self__, "system_disk_description", system_disk_description)
        if system_disk_name is not None:
            pulumi.set(__self__, "system_disk_name", system_disk_name)
        if system_disk_performance_level is not None:
            pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unique_suffix is not None:
            pulumi.set(__self__, "unique_suffix", unique_suffix)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[int]]:
        """
        The number of instances that you want to create. Valid values: `1` to `100`.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "amount", value)

    @property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> Optional[pulumi.Input[str]]:
        """
        The automatic release time of the `PostPaid` instance.
        """
        return pulumi.get(self, "auto_release_time")

    @auto_release_time.setter
    def auto_release_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_release_time", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable auto-renewal for the instance. This parameter is valid only when the `instance_charge_type` is set to `PrePaid`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`.
        - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `6`, `12`.
        - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
        """
        return pulumi.get(self, "auto_renew_period")

    @auto_renew_period.setter
    def auto_renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_period", value)

    @property
    @pulumi.getter(name="bootCheckOsWithAssistant")
    def boot_check_os_with_assistant(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicate how to check instance ready to use.
        """
        return pulumi.get(self, "boot_check_os_with_assistant")

    @boot_check_os_with_assistant.setter
    def boot_check_os_with_assistant(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "boot_check_os_with_assistant", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetDataDiskArgs']]]]:
        """
        The list of data disks created with instance. See `data_disks` below..
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dedicated host on which to create the instance. If the `dedicated_host_id` is specified, the `spot_strategy` and `spot_price_limit`  are ignored. This is because preemptible instances cannot be created on dedicated hosts.
        """
        return pulumi.get(self, "dedicated_host_id")

    @dedicated_host_id.setter
    def dedicated_host_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dedicated_host_id", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable release protection for the instance.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the deployment set to which to deploy the instance.
        """
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_set_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="excludeInstanceFilter")
    def exclude_instance_filter(self) -> Optional[pulumi.Input['EcsInstanceSetExcludeInstanceFilterArgs']]:
        """
        The instances that need to be excluded from the Instance Set.  See `exclude_instance_filter` below.
        """
        return pulumi.get(self, "exclude_instance_filter")

    @exclude_instance_filter.setter
    def exclude_instance_filter(self, value: Optional[pulumi.Input['EcsInstanceSetExcludeInstanceFilterArgs']]):
        pulumi.set(self, "exclude_instance_filter", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname of instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @hpc_cluster_id.setter
    def hpc_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hpc_cluster_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Image to use for the instance.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The billing method of the instance. Valid values: `PrePaid`, `PostPaid`.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of ECS Instance ID.
        """
        return pulumi.get(self, "instance_ids")

    @instance_ids.setter
    def instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_ids", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with `http://` or `https://`.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of instance to start.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Internet charge type of the instance. Valid values are `PayByBandwidth`, `PayByTraffic`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[int]]:
        """
        The Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Valid values: `1` to `100`.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of key pair that can login ECS instance successfully without password.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the launch template.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the launch template. To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the launch template.
        """
        return pulumi.get(self, "launch_template_version")

    @launch_template_version.setter
    def launch_template_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_version", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetNetworkInterfaceArgs']]]]:
        """
        A list of NetworkInterface. See `network_interfaces` below..
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EcsInstanceSetNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use the password preset in the image.
        """
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_inherit", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`.
        - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
        - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: `Week`, `Month`.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Instance RAM role name.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ram_role_name", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of resource group which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The security enhancement strategy.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of security group ids to associate with.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[float]]:
        """
        The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "spot_price_limit", value)

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_strategy", value)

    @property
    @pulumi.getter(name="systemDiskAutoSnapshotPolicyId")
    def system_disk_auto_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the automatic snapshot policy applied to the system disk.
        """
        return pulumi.get(self, "system_disk_auto_snapshot_policy_id")

    @system_disk_auto_snapshot_policy_id.setter
    def system_disk_auto_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_auto_snapshot_policy_id", value)

    @property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The category of the system disk. Valid values are `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
        """
        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_category", value)

    @property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the system disk. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "system_disk_description")

    @system_disk_description.setter
    def system_disk_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_description", value)

    @property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the system disk.
        """
        return pulumi.get(self, "system_disk_name")

    @system_disk_name.setter
    def system_disk_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_name", value)

    @property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        The performance level of the ESSD used as the system disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @system_disk_performance_level.setter
    def system_disk_performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_performance_level", value)

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the system disk, measured in GiB. Value range:  values: `20` to `500`.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "system_disk_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="uniqueSuffix")
    def unique_suffix(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically append incremental suffixes to the hostname specified by the HostName parameter and to the instance name specified by the InstanceName parameter when you batch create instances. The incremental suffixes can range from `001` to `999`.
        """
        return pulumi.get(self, "unique_suffix")

    @unique_suffix.setter
    def unique_suffix(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unique_suffix", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual switch ID to launch in VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the zone in which to create the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class EcsInstanceSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[int]] = None,
                 auto_release_time: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 boot_check_os_with_assistant: Optional[pulumi.Input[bool]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EcsInstanceSetDataDiskArgs']]]]] = None,
                 dedicated_host_id: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exclude_instance_filter: Optional[pulumi.Input[pulumi.InputType['EcsInstanceSetExcludeInstanceFilterArgs']]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 launch_template_version: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EcsInstanceSetNetworkInterfaceArgs']]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 ram_role_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_description: Optional[pulumi.Input[str]] = None,
                 system_disk_name: Optional[pulumi.Input[str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 unique_suffix: Optional[pulumi.Input[bool]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a ECS Instance Set resource.

        For information about ECS Instance Set and how to use it, see [What is Instance Set](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/runinstances).

        > **NOTE:** Available since v1.173.0.

        > **NOTE:** This resource is used to batch create a group of instance resources with the same configuration. However, this resource is not recommended. `ecs.Instance` is preferred.

        > **NOTE:** In the instances managed by this resource, names are automatically generated based on `instance_name` and `unique_suffix`.

        > **NOTE:** Only `tags` support batch modification.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="172.17.3.0/24")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="172.17.3.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        beijing_k = alicloud.ecs.EcsInstanceSet("beijingK",
            amount=10,
            image_id=default_images.images[0].id,
            instance_type=default_instance_types.instance_types[0].id,
            instance_name=name,
            instance_charge_type="PostPaid",
            system_disk_performance_level="PL0",
            system_disk_category="cloud_efficiency",
            system_disk_size=200,
            vswitch_id=default_switch.id,
            security_group_ids=[__item.id for __item in [default_security_group]],
            zone_id=default_zones.zones[0].id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] amount: The number of instances that you want to create. Valid values: `1` to `100`.
        :param pulumi.Input[str] auto_release_time: The automatic release time of the `PostPaid` instance.
        :param pulumi.Input[bool] auto_renew: Whether to enable auto-renewal for the instance. This parameter is valid only when the `instance_charge_type` is set to `PrePaid`.
        :param pulumi.Input[int] auto_renew_period: Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`.
               - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `6`, `12`.
               - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
        :param pulumi.Input[bool] boot_check_os_with_assistant: Indicate how to check instance ready to use.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EcsInstanceSetDataDiskArgs']]]] data_disks: The list of data disks created with instance. See `data_disks` below..
        :param pulumi.Input[str] dedicated_host_id: The ID of the dedicated host on which to create the instance. If the `dedicated_host_id` is specified, the `spot_strategy` and `spot_price_limit`  are ignored. This is because preemptible instances cannot be created on dedicated hosts.
        :param pulumi.Input[bool] deletion_protection: Whether to enable release protection for the instance.
        :param pulumi.Input[str] deployment_set_id: The ID of the deployment set to which to deploy the instance.
        :param pulumi.Input[str] description: The description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with `http://` or `https://`.
        :param pulumi.Input[pulumi.InputType['EcsInstanceSetExcludeInstanceFilterArgs']] exclude_instance_filter: The instances that need to be excluded from the Instance Set.  See `exclude_instance_filter` below.
        :param pulumi.Input[str] host_name: The hostname of instance.
        :param pulumi.Input[str] hpc_cluster_id: The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
        :param pulumi.Input[str] image_id: The Image to use for the instance.
        :param pulumi.Input[str] instance_charge_type: The billing method of the instance. Valid values: `PrePaid`, `PostPaid`.
        :param pulumi.Input[str] instance_name: The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with `http://` or `https://`.
        :param pulumi.Input[str] instance_type: The type of instance to start.
        :param pulumi.Input[str] internet_charge_type: The Internet charge type of the instance. Valid values are `PayByBandwidth`, `PayByTraffic`.
        :param pulumi.Input[int] internet_max_bandwidth_out: The Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Valid values: `1` to `100`.
        :param pulumi.Input[str] key_pair_name: The name of key pair that can login ECS instance successfully without password.
        :param pulumi.Input[str] launch_template_id: The ID of the launch template.
        :param pulumi.Input[str] launch_template_name: The name of the launch template. To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
        :param pulumi.Input[str] launch_template_version: The version of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EcsInstanceSetNetworkInterfaceArgs']]]] network_interfaces: A list of NetworkInterface. See `network_interfaces` below..
        :param pulumi.Input[str] password: The password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols.
        :param pulumi.Input[bool] password_inherit: Whether to use the password preset in the image.
        :param pulumi.Input[int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`.
               - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
               - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
        :param pulumi.Input[str] period_unit: The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: `Week`, `Month`.
        :param pulumi.Input[str] ram_role_name: The Instance RAM role name.
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the instance belongs.
        :param pulumi.Input[str] security_enhancement_strategy: The security enhancement strategy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of security group ids to associate with.
        :param pulumi.Input[float] spot_price_limit: The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
        :param pulumi.Input[str] spot_strategy: The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'.
        :param pulumi.Input[str] system_disk_auto_snapshot_policy_id: The ID of the automatic snapshot policy applied to the system disk.
        :param pulumi.Input[str] system_disk_category: The category of the system disk. Valid values are `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
        :param pulumi.Input[str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[str] system_disk_name: The name of the system disk.
        :param pulumi.Input[str] system_disk_performance_level: The performance level of the ESSD used as the system disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
        :param pulumi.Input[int] system_disk_size: The size of the system disk, measured in GiB. Value range:  values: `20` to `500`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[bool] unique_suffix: Whether to automatically append incremental suffixes to the hostname specified by the HostName parameter and to the instance name specified by the InstanceName parameter when you batch create instances. The incremental suffixes can range from `001` to `999`.
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch in VPC.
        :param pulumi.Input[str] zone_id: The ID of the zone in which to create the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EcsInstanceSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECS Instance Set resource.

        For information about ECS Instance Set and how to use it, see [What is Instance Set](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/runinstances).

        > **NOTE:** Available since v1.173.0.

        > **NOTE:** This resource is used to batch create a group of instance resources with the same configuration. However, this resource is not recommended. `ecs.Instance` is preferred.

        > **NOTE:** In the instances managed by this resource, names are automatically generated based on `instance_name` and `unique_suffix`.

        > **NOTE:** Only `tags` support batch modification.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_[0-9]+_[0-9]+_x64*",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="172.17.3.0/24")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="172.17.3.0/24",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        beijing_k = alicloud.ecs.EcsInstanceSet("beijingK",
            amount=10,
            image_id=default_images.images[0].id,
            instance_type=default_instance_types.instance_types[0].id,
            instance_name=name,
            instance_charge_type="PostPaid",
            system_disk_performance_level="PL0",
            system_disk_category="cloud_efficiency",
            system_disk_size=200,
            vswitch_id=default_switch.id,
            security_group_ids=[__item.id for __item in [default_security_group]],
            zone_id=default_zones.zones[0].id)
        ```

        :param str resource_name: The name of the resource.
        :param EcsInstanceSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EcsInstanceSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[int]] = None,
                 auto_release_time: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_period: Optional[pulumi.Input[int]] = None,
                 boot_check_os_with_assistant: Optional[pulumi.Input[bool]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EcsInstanceSetDataDiskArgs']]]]] = None,
                 dedicated_host_id: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exclude_instance_filter: Optional[pulumi.Input[pulumi.InputType['EcsInstanceSetExcludeInstanceFilterArgs']]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 hpc_cluster_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 launch_template_version: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EcsInstanceSetNetworkInterfaceArgs']]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 ram_role_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_description: Optional[pulumi.Input[str]] = None,
                 system_disk_name: Optional[pulumi.Input[str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 unique_suffix: Optional[pulumi.Input[bool]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EcsInstanceSetArgs.__new__(EcsInstanceSetArgs)

            __props__.__dict__["amount"] = amount
            __props__.__dict__["auto_release_time"] = auto_release_time
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_renew_period"] = auto_renew_period
            __props__.__dict__["boot_check_os_with_assistant"] = boot_check_os_with_assistant
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["dedicated_host_id"] = dedicated_host_id
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["deployment_set_id"] = deployment_set_id
            __props__.__dict__["description"] = description
            __props__.__dict__["exclude_instance_filter"] = exclude_instance_filter
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["hpc_cluster_id"] = hpc_cluster_id
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["instance_name"] = instance_name
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["launch_template_id"] = launch_template_id
            __props__.__dict__["launch_template_name"] = launch_template_name
            __props__.__dict__["launch_template_version"] = launch_template_version
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["password_inherit"] = password_inherit
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["ram_role_name"] = ram_role_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
            if security_group_ids is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_ids'")
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["spot_price_limit"] = spot_price_limit
            __props__.__dict__["spot_strategy"] = spot_strategy
            __props__.__dict__["system_disk_auto_snapshot_policy_id"] = system_disk_auto_snapshot_policy_id
            __props__.__dict__["system_disk_category"] = system_disk_category
            __props__.__dict__["system_disk_description"] = system_disk_description
            __props__.__dict__["system_disk_name"] = system_disk_name
            __props__.__dict__["system_disk_performance_level"] = system_disk_performance_level
            __props__.__dict__["system_disk_size"] = system_disk_size
            __props__.__dict__["tags"] = tags
            __props__.__dict__["unique_suffix"] = unique_suffix
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
            __props__.__dict__["instance_ids"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EcsInstanceSet, __self__).__init__(
            'alicloud:ecs/ecsInstanceSet:EcsInstanceSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            amount: Optional[pulumi.Input[int]] = None,
            auto_release_time: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            auto_renew_period: Optional[pulumi.Input[int]] = None,
            boot_check_os_with_assistant: Optional[pulumi.Input[bool]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EcsInstanceSetDataDiskArgs']]]]] = None,
            dedicated_host_id: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            deployment_set_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            exclude_instance_filter: Optional[pulumi.Input[pulumi.InputType['EcsInstanceSetExcludeInstanceFilterArgs']]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            hpc_cluster_id: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            instance_charge_type: Optional[pulumi.Input[str]] = None,
            instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            internet_charge_type: Optional[pulumi.Input[str]] = None,
            internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
            key_pair_name: Optional[pulumi.Input[str]] = None,
            launch_template_id: Optional[pulumi.Input[str]] = None,
            launch_template_name: Optional[pulumi.Input[str]] = None,
            launch_template_version: Optional[pulumi.Input[str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EcsInstanceSetNetworkInterfaceArgs']]]]] = None,
            password: Optional[pulumi.Input[str]] = None,
            password_inherit: Optional[pulumi.Input[bool]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            ram_role_name: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            spot_price_limit: Optional[pulumi.Input[float]] = None,
            spot_strategy: Optional[pulumi.Input[str]] = None,
            system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
            system_disk_category: Optional[pulumi.Input[str]] = None,
            system_disk_description: Optional[pulumi.Input[str]] = None,
            system_disk_name: Optional[pulumi.Input[str]] = None,
            system_disk_performance_level: Optional[pulumi.Input[str]] = None,
            system_disk_size: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            unique_suffix: Optional[pulumi.Input[bool]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'EcsInstanceSet':
        """
        Get an existing EcsInstanceSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] amount: The number of instances that you want to create. Valid values: `1` to `100`.
        :param pulumi.Input[str] auto_release_time: The automatic release time of the `PostPaid` instance.
        :param pulumi.Input[bool] auto_renew: Whether to enable auto-renewal for the instance. This parameter is valid only when the `instance_charge_type` is set to `PrePaid`.
        :param pulumi.Input[int] auto_renew_period: Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`.
               - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `6`, `12`.
               - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
        :param pulumi.Input[bool] boot_check_os_with_assistant: Indicate how to check instance ready to use.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EcsInstanceSetDataDiskArgs']]]] data_disks: The list of data disks created with instance. See `data_disks` below..
        :param pulumi.Input[str] dedicated_host_id: The ID of the dedicated host on which to create the instance. If the `dedicated_host_id` is specified, the `spot_strategy` and `spot_price_limit`  are ignored. This is because preemptible instances cannot be created on dedicated hosts.
        :param pulumi.Input[bool] deletion_protection: Whether to enable release protection for the instance.
        :param pulumi.Input[str] deployment_set_id: The ID of the deployment set to which to deploy the instance.
        :param pulumi.Input[str] description: The description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with `http://` or `https://`.
        :param pulumi.Input[pulumi.InputType['EcsInstanceSetExcludeInstanceFilterArgs']] exclude_instance_filter: The instances that need to be excluded from the Instance Set.  See `exclude_instance_filter` below.
        :param pulumi.Input[str] host_name: The hostname of instance.
        :param pulumi.Input[str] hpc_cluster_id: The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
        :param pulumi.Input[str] image_id: The Image to use for the instance.
        :param pulumi.Input[str] instance_charge_type: The billing method of the instance. Valid values: `PrePaid`, `PostPaid`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_ids: A list of ECS Instance ID.
        :param pulumi.Input[str] instance_name: The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with `http://` or `https://`.
        :param pulumi.Input[str] instance_type: The type of instance to start.
        :param pulumi.Input[str] internet_charge_type: The Internet charge type of the instance. Valid values are `PayByBandwidth`, `PayByTraffic`.
        :param pulumi.Input[int] internet_max_bandwidth_out: The Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Valid values: `1` to `100`.
        :param pulumi.Input[str] key_pair_name: The name of key pair that can login ECS instance successfully without password.
        :param pulumi.Input[str] launch_template_id: The ID of the launch template.
        :param pulumi.Input[str] launch_template_name: The name of the launch template. To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
        :param pulumi.Input[str] launch_template_version: The version of the launch template.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EcsInstanceSetNetworkInterfaceArgs']]]] network_interfaces: A list of NetworkInterface. See `network_interfaces` below..
        :param pulumi.Input[str] password: The password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols.
        :param pulumi.Input[bool] password_inherit: Whether to use the password preset in the image.
        :param pulumi.Input[int] period: The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`.
               - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
               - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
        :param pulumi.Input[str] period_unit: The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: `Week`, `Month`.
        :param pulumi.Input[str] ram_role_name: The Instance RAM role name.
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the instance belongs.
        :param pulumi.Input[str] security_enhancement_strategy: The security enhancement strategy.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of security group ids to associate with.
        :param pulumi.Input[float] spot_price_limit: The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
        :param pulumi.Input[str] spot_strategy: The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'.
        :param pulumi.Input[str] system_disk_auto_snapshot_policy_id: The ID of the automatic snapshot policy applied to the system disk.
        :param pulumi.Input[str] system_disk_category: The category of the system disk. Valid values are `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
        :param pulumi.Input[str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
        :param pulumi.Input[str] system_disk_name: The name of the system disk.
        :param pulumi.Input[str] system_disk_performance_level: The performance level of the ESSD used as the system disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
        :param pulumi.Input[int] system_disk_size: The size of the system disk, measured in GiB. Value range:  values: `20` to `500`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[bool] unique_suffix: Whether to automatically append incremental suffixes to the hostname specified by the HostName parameter and to the instance name specified by the InstanceName parameter when you batch create instances. The incremental suffixes can range from `001` to `999`.
        :param pulumi.Input[str] vswitch_id: The virtual switch ID to launch in VPC.
        :param pulumi.Input[str] zone_id: The ID of the zone in which to create the instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EcsInstanceSetState.__new__(_EcsInstanceSetState)

        __props__.__dict__["amount"] = amount
        __props__.__dict__["auto_release_time"] = auto_release_time
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_renew_period"] = auto_renew_period
        __props__.__dict__["boot_check_os_with_assistant"] = boot_check_os_with_assistant
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["dedicated_host_id"] = dedicated_host_id
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["deployment_set_id"] = deployment_set_id
        __props__.__dict__["description"] = description
        __props__.__dict__["exclude_instance_filter"] = exclude_instance_filter
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["hpc_cluster_id"] = hpc_cluster_id
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["instance_ids"] = instance_ids
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["launch_template_id"] = launch_template_id
        __props__.__dict__["launch_template_name"] = launch_template_name
        __props__.__dict__["launch_template_version"] = launch_template_version
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["password"] = password
        __props__.__dict__["password_inherit"] = password_inherit
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["ram_role_name"] = ram_role_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["spot_price_limit"] = spot_price_limit
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["system_disk_auto_snapshot_policy_id"] = system_disk_auto_snapshot_policy_id
        __props__.__dict__["system_disk_category"] = system_disk_category
        __props__.__dict__["system_disk_description"] = system_disk_description
        __props__.__dict__["system_disk_name"] = system_disk_name
        __props__.__dict__["system_disk_performance_level"] = system_disk_performance_level
        __props__.__dict__["system_disk_size"] = system_disk_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["unique_suffix"] = unique_suffix
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return EcsInstanceSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def amount(self) -> pulumi.Output[Optional[int]]:
        """
        The number of instances that you want to create. Valid values: `1` to `100`.
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> pulumi.Output[Optional[str]]:
        """
        The automatic release time of the `PostPaid` instance.
        """
        return pulumi.get(self, "auto_release_time")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable auto-renewal for the instance. This parameter is valid only when the `instance_charge_type` is set to `PrePaid`.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="autoRenewPeriod")
    def auto_renew_period(self) -> pulumi.Output[Optional[int]]:
        """
        Auto renewal period of an instance, in the unit of month. It is valid when `instance_charge_type` is `PrePaid`.
        - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `6`, `12`.
        - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
        """
        return pulumi.get(self, "auto_renew_period")

    @property
    @pulumi.getter(name="bootCheckOsWithAssistant")
    def boot_check_os_with_assistant(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicate how to check instance ready to use.
        """
        return pulumi.get(self, "boot_check_os_with_assistant")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.EcsInstanceSetDataDisk']]]:
        """
        The list of data disks created with instance. See `data_disks` below..
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the dedicated host on which to create the instance. If the `dedicated_host_id` is specified, the `spot_strategy` and `spot_price_limit`  are ignored. This is because preemptible instances cannot be created on dedicated hosts.
        """
        return pulumi.get(self, "dedicated_host_id")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[bool]:
        """
        Whether to enable release protection for the instance.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the deployment set to which to deploy the instance.
        """
        return pulumi.get(self, "deployment_set_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the instance, This description can have a string of 2 to 256 characters, It cannot begin with `http://` or `https://`.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="excludeInstanceFilter")
    def exclude_instance_filter(self) -> pulumi.Output[Optional['outputs.EcsInstanceSetExcludeInstanceFilter']]:
        """
        The instances that need to be excluded from the Instance Set.  See `exclude_instance_filter` below.
        """
        return pulumi.get(self, "exclude_instance_filter")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[str]:
        """
        The hostname of instance.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the Elastic High Performance Computing (E-HPC) cluster to which to assign the instance.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        The Image to use for the instance.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[Optional[str]]:
        """
        The billing method of the instance. Valid values: `PrePaid`, `PostPaid`.
        """
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of ECS Instance ID.
        """
        return pulumi.get(self, "instance_ids")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the ECS. This instance_name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin with a hyphen, and must not begin with `http://` or `https://`.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The type of instance to start.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[str]:
        """
        The Internet charge type of the instance. Valid values are `PayByBandwidth`, `PayByTraffic`.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> pulumi.Output[int]:
        """
        The Maximum outgoing bandwidth to the public network, measured in Mbps (Mega bit per second). Valid values: `1` to `100`.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of key pair that can login ECS instance successfully without password.
        """
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the launch template.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the launch template. To use a launch template to create an instance, you must use the `launch_template_id` or `launch_template_name` parameter to specify the launch template.
        """
        return pulumi.get(self, "launch_template_name")

    @property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> pulumi.Output[Optional[str]]:
        """
        The version of the launch template.
        """
        return pulumi.get(self, "launch_template_version")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.EcsInstanceSetNetworkInterface']]]:
        """
        A list of NetworkInterface. See `network_interfaces` below..
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password to an instance is a string of 8 to 30 characters. It must contain uppercase/lowercase letters and numerals, but cannot contain special symbols.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to use the password preset in the image.
        """
        return pulumi.get(self, "password_inherit")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `instance_charge_type` is `PrePaid`.
        - When `period_unit` is `Month`, Valid values: `1`, `2`, `3`, `4`, `5`, `6`, `7`, `8`, `9`, `12`, `24`, `36`, `48`, `60`.
        - When `period_unit` is `Week`, Valid values: `1`, `2`, `3`.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        The duration unit that you will buy the resource. It is valid when `instance_charge_type` is 'PrePaid'. Valid value: `Week`, `Month`.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> pulumi.Output[Optional[str]]:
        """
        The Instance RAM role name.
        """
        return pulumi.get(self, "ram_role_name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of resource group which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        The security enhancement strategy.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of security group ids to associate with.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> pulumi.Output[float]:
        """
        The hourly price threshold of a instance, and it takes effect only when parameter 'spot_strategy' is 'SpotWithPriceLimit'. Three decimals is allowed at most.
        """
        return pulumi.get(self, "spot_price_limit")

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[str]:
        """
        The spot strategy of a Pay-As-You-Go instance, and it takes effect only when parameter `instance_charge_type` is 'PostPaid'.
        """
        return pulumi.get(self, "spot_strategy")

    @property
    @pulumi.getter(name="systemDiskAutoSnapshotPolicyId")
    def system_disk_auto_snapshot_policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the automatic snapshot policy applied to the system disk.
        """
        return pulumi.get(self, "system_disk_auto_snapshot_policy_id")

    @property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> pulumi.Output[str]:
        """
        The category of the system disk. Valid values are `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
        """
        return pulumi.get(self, "system_disk_category")

    @property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the system disk. The description must be 2 to 256 characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "system_disk_description")

    @property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the system disk.
        """
        return pulumi.get(self, "system_disk_name")

    @property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> pulumi.Output[str]:
        """
        The performance level of the ESSD used as the system disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> pulumi.Output[int]:
        """
        The size of the system disk, measured in GiB. Value range:  values: `20` to `500`.
        """
        return pulumi.get(self, "system_disk_size")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="uniqueSuffix")
    def unique_suffix(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to automatically append incremental suffixes to the hostname specified by the HostName parameter and to the instance name specified by the InstanceName parameter when you batch create instances. The incremental suffixes can range from `001` to `999`.
        """
        return pulumi.get(self, "unique_suffix")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[str]]:
        """
        The virtual switch ID to launch in VPC.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The ID of the zone in which to create the instance.
        """
        return pulumi.get(self, "zone_id")

