# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['EipAddressArgs', 'EipAddress']

@pulumi.input_type
class EipAddressArgs:
    def __init__(__self__, *,
                 activity_id: Optional[pulumi.Input[str]] = None,
                 address_name: Optional[pulumi.Input[str]] = None,
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 high_definition_monitor_log_status: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 log_project: Optional[pulumi.Input[str]] = None,
                 log_store: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 netmode: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 pricing_cycle: Optional[pulumi.Input[str]] = None,
                 public_ip_address_pool_id: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EipAddress resource.
        :param pulumi.Input[str] activity_id: Special activity ID. This parameter is not required.
        :param pulumi.Input[str] address_name: The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
        :param pulumi.Input[bool] auto_pay: Whether to pay automatically. Valid values: `true` and `false`. Default value: `true`. When `auto_pay` is `true`, The order will be automatically paid. When `auto_pay` is `false`, The order needs to go to the order center to complete the payment. **NOTE:** When `payment_type` is `Subscription`, this parameter is valid.
        :param pulumi.Input[str] bandwidth: The maximum bandwidth of the EIP. Valid values: `1` to `200`. Unit: Mbit/s. Default value: `5`.
        :param pulumi.Input[bool] deletion_protection: Whether the delete protection function is turned on.
               - **true**: enabled.
               - **false**: not enabled.
        :param pulumi.Input[str] description: The description of the EIP.
        :param pulumi.Input[str] high_definition_monitor_log_status: Whether the second-level monitoring is enabled for the EIP.
               - **OFF**: not enabled.
               - **ON**: enabled.
        :param pulumi.Input[str] instance_charge_type: . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
        :param pulumi.Input[str] internet_charge_type: Renewal Payment type.
               - **PayByBandwidth**: billed by fixed bandwidth.
               - **PayByTraffic**: Billing by traffic.
        :param pulumi.Input[str] isp: The line type. You can set this parameter only when you create a `PayAsYouGo` EIP. Valid values:
        :param pulumi.Input[str] log_project: The Name of the logging service LogProject. Current parameter is required when configuring high precision second-by-second monitoring for EIP.
        :param pulumi.Input[str] log_store: The Name of the logging service LogStore. Current parameter is required when configuring high precision second-by-second monitoring for EIP.
        :param pulumi.Input[str] name: . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
        :param pulumi.Input[str] netmode: The type of the network. Valid value is `public` (Internet).
        :param pulumi.Input[str] payment_type: The billing method of the EIP. Valid values:  `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[int] period: When the PricingCycle is set to Month, the Period value ranges from 1 to 9.When the PricingCycle is set to Year, the Period range is 1 to 5.If the value of the InstanceChargeType parameter is PrePaid, this parameter is required. If the value of the InstanceChargeType parameter is PostPaid, this parameter is not filled in.
        :param pulumi.Input[str] pricing_cycle: Value:Month (default): Pay monthly.Year: Pay per Year.This parameter is required when the value of the InstanceChargeType parameter is Subscription(PrePaid). This parameter is optional when the value of the InstanceChargeType parameter is PayAsYouGo(PostPaid).
        :param pulumi.Input[str] public_ip_address_pool_id: The ID of the IP address pool to which the EIP belongs.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_protection_types: Security protection level.
               - When the return is empty, the basic DDoS protection is specified.
               - When **antidos_enhanced** is returned, it indicates DDoS protection (enhanced version).
        :param pulumi.Input[Mapping[str, Any]] tags: The tag of the resource.
        :param pulumi.Input[str] zone: The zone of the EIP.This parameter is returned only for whitelist users that are visible to the zone.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if activity_id is not None:
            pulumi.set(__self__, "activity_id", activity_id)
        if address_name is not None:
            pulumi.set(__self__, "address_name", address_name)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if high_definition_monitor_log_status is not None:
            pulumi.set(__self__, "high_definition_monitor_log_status", high_definition_monitor_log_status)
        if instance_charge_type is not None:
            warnings.warn("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_charge_type is deprecated: Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if log_project is not None:
            pulumi.set(__self__, "log_project", log_project)
        if log_store is not None:
            pulumi.set(__self__, "log_store", log_store)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if netmode is not None:
            pulumi.set(__self__, "netmode", netmode)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if public_ip_address_pool_id is not None:
            pulumi.set(__self__, "public_ip_address_pool_id", public_ip_address_pool_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_protection_types is not None:
            pulumi.set(__self__, "security_protection_types", security_protection_types)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="activityId")
    def activity_id(self) -> Optional[pulumi.Input[str]]:
        """
        Special activity ID. This parameter is not required.
        """
        return pulumi.get(self, "activity_id")

    @activity_id.setter
    def activity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activity_id", value)

    @property
    @pulumi.getter(name="addressName")
    def address_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
        """
        return pulumi.get(self, "address_name")

    @address_name.setter
    def address_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_name", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to pay automatically. Valid values: `true` and `false`. Default value: `true`. When `auto_pay` is `true`, The order will be automatically paid. When `auto_pay` is `false`, The order needs to go to the order center to complete the payment. **NOTE:** When `payment_type` is `Subscription`, this parameter is valid.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum bandwidth of the EIP. Valid values: `1` to `200`. Unit: Mbit/s. Default value: `5`.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the delete protection function is turned on.
        - **true**: enabled.
        - **false**: not enabled.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the EIP.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="highDefinitionMonitorLogStatus")
    def high_definition_monitor_log_status(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the second-level monitoring is enabled for the EIP.
        - **OFF**: not enabled.
        - **ON**: enabled.
        """
        return pulumi.get(self, "high_definition_monitor_log_status")

    @high_definition_monitor_log_status.setter
    def high_definition_monitor_log_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "high_definition_monitor_log_status", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
        """
        warnings.warn("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""", DeprecationWarning)
        pulumi.log.warn("""instance_charge_type is deprecated: Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")

        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Renewal Payment type.
        - **PayByBandwidth**: billed by fixed bandwidth.
        - **PayByTraffic**: Billing by traffic.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[str]]:
        """
        The line type. You can set this parameter only when you create a `PayAsYouGo` EIP. Valid values:
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "isp", value)

    @property
    @pulumi.getter(name="logProject")
    def log_project(self) -> Optional[pulumi.Input[str]]:
        """
        The Name of the logging service LogProject. Current parameter is required when configuring high precision second-by-second monitoring for EIP.
        """
        return pulumi.get(self, "log_project")

    @log_project.setter
    def log_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_project", value)

    @property
    @pulumi.getter(name="logStore")
    def log_store(self) -> Optional[pulumi.Input[str]]:
        """
        The Name of the logging service LogStore. Current parameter is required when configuring high precision second-by-second monitoring for EIP.
        """
        return pulumi.get(self, "log_store")

    @log_store.setter
    def log_store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_store", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
        """
        warnings.warn("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""", DeprecationWarning)
        pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")

        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def netmode(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the network. Valid value is `public` (Internet).
        """
        return pulumi.get(self, "netmode")

    @netmode.setter
    def netmode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netmode", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The billing method of the EIP. Valid values:  `Subscription`, `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        When the PricingCycle is set to Month, the Period value ranges from 1 to 9.When the PricingCycle is set to Year, the Period range is 1 to 5.If the value of the InstanceChargeType parameter is PrePaid, this parameter is required. If the value of the InstanceChargeType parameter is PostPaid, this parameter is not filled in.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[str]]:
        """
        Value:Month (default): Pay monthly.Year: Pay per Year.This parameter is required when the value of the InstanceChargeType parameter is Subscription(PrePaid). This parameter is optional when the value of the InstanceChargeType parameter is PayAsYouGo(PostPaid).
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pricing_cycle", value)

    @property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the IP address pool to which the EIP belongs.
        """
        return pulumi.get(self, "public_ip_address_pool_id")

    @public_ip_address_pool_id.setter
    def public_ip_address_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address_pool_id", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Security protection level.
        - When the return is empty, the basic DDoS protection is specified.
        - When **antidos_enhanced** is returned, it indicates DDoS protection (enhanced version).
        """
        return pulumi.get(self, "security_protection_types")

    @security_protection_types.setter
    def security_protection_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_protection_types", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone of the EIP.This parameter is returned only for whitelist users that are visible to the zone.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _EipAddressState:
    def __init__(__self__, *,
                 activity_id: Optional[pulumi.Input[str]] = None,
                 address_name: Optional[pulumi.Input[str]] = None,
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 high_definition_monitor_log_status: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 log_project: Optional[pulumi.Input[str]] = None,
                 log_store: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 netmode: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 pricing_cycle: Optional[pulumi.Input[str]] = None,
                 public_ip_address_pool_id: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EipAddress resources.
        :param pulumi.Input[str] activity_id: Special activity ID. This parameter is not required.
        :param pulumi.Input[str] address_name: The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
        :param pulumi.Input[bool] auto_pay: Whether to pay automatically. Valid values: `true` and `false`. Default value: `true`. When `auto_pay` is `true`, The order will be automatically paid. When `auto_pay` is `false`, The order needs to go to the order center to complete the payment. **NOTE:** When `payment_type` is `Subscription`, this parameter is valid.
        :param pulumi.Input[str] bandwidth: The maximum bandwidth of the EIP. Valid values: `1` to `200`. Unit: Mbit/s. Default value: `5`.
        :param pulumi.Input[str] create_time: The time when the EIP was created.
        :param pulumi.Input[bool] deletion_protection: Whether the delete protection function is turned on.
               - **true**: enabled.
               - **false**: not enabled.
        :param pulumi.Input[str] description: The description of the EIP.
        :param pulumi.Input[str] high_definition_monitor_log_status: Whether the second-level monitoring is enabled for the EIP.
               - **OFF**: not enabled.
               - **ON**: enabled.
        :param pulumi.Input[str] instance_charge_type: . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
        :param pulumi.Input[str] internet_charge_type: Renewal Payment type.
               - **PayByBandwidth**: billed by fixed bandwidth.
               - **PayByTraffic**: Billing by traffic.
        :param pulumi.Input[str] ip_address: The IP address of the EIP.
        :param pulumi.Input[str] isp: The line type. You can set this parameter only when you create a `PayAsYouGo` EIP. Valid values:
        :param pulumi.Input[str] log_project: The Name of the logging service LogProject. Current parameter is required when configuring high precision second-by-second monitoring for EIP.
        :param pulumi.Input[str] log_store: The Name of the logging service LogStore. Current parameter is required when configuring high precision second-by-second monitoring for EIP.
        :param pulumi.Input[str] name: . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
        :param pulumi.Input[str] netmode: The type of the network. Valid value is `public` (Internet).
        :param pulumi.Input[str] payment_type: The billing method of the EIP. Valid values:  `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[int] period: When the PricingCycle is set to Month, the Period value ranges from 1 to 9.When the PricingCycle is set to Year, the Period range is 1 to 5.If the value of the InstanceChargeType parameter is PrePaid, this parameter is required. If the value of the InstanceChargeType parameter is PostPaid, this parameter is not filled in.
        :param pulumi.Input[str] pricing_cycle: Value:Month (default): Pay monthly.Year: Pay per Year.This parameter is required when the value of the InstanceChargeType parameter is Subscription(PrePaid). This parameter is optional when the value of the InstanceChargeType parameter is PayAsYouGo(PostPaid).
        :param pulumi.Input[str] public_ip_address_pool_id: The ID of the IP address pool to which the EIP belongs.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_protection_types: Security protection level.
               - When the return is empty, the basic DDoS protection is specified.
               - When **antidos_enhanced** is returned, it indicates DDoS protection (enhanced version).
        :param pulumi.Input[str] status: The status of the EIP.
        :param pulumi.Input[Mapping[str, Any]] tags: The tag of the resource.
        :param pulumi.Input[str] zone: The zone of the EIP.This parameter is returned only for whitelist users that are visible to the zone.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        if activity_id is not None:
            pulumi.set(__self__, "activity_id", activity_id)
        if address_name is not None:
            pulumi.set(__self__, "address_name", address_name)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if high_definition_monitor_log_status is not None:
            pulumi.set(__self__, "high_definition_monitor_log_status", high_definition_monitor_log_status)
        if instance_charge_type is not None:
            warnings.warn("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_charge_type is deprecated: Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if log_project is not None:
            pulumi.set(__self__, "log_project", log_project)
        if log_store is not None:
            pulumi.set(__self__, "log_store", log_store)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if netmode is not None:
            pulumi.set(__self__, "netmode", netmode)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if pricing_cycle is not None:
            pulumi.set(__self__, "pricing_cycle", pricing_cycle)
        if public_ip_address_pool_id is not None:
            pulumi.set(__self__, "public_ip_address_pool_id", public_ip_address_pool_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_protection_types is not None:
            pulumi.set(__self__, "security_protection_types", security_protection_types)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="activityId")
    def activity_id(self) -> Optional[pulumi.Input[str]]:
        """
        Special activity ID. This parameter is not required.
        """
        return pulumi.get(self, "activity_id")

    @activity_id.setter
    def activity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activity_id", value)

    @property
    @pulumi.getter(name="addressName")
    def address_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
        """
        return pulumi.get(self, "address_name")

    @address_name.setter
    def address_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_name", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to pay automatically. Valid values: `true` and `false`. Default value: `true`. When `auto_pay` is `true`, The order will be automatically paid. When `auto_pay` is `false`, The order needs to go to the order center to complete the payment. **NOTE:** When `payment_type` is `Subscription`, this parameter is valid.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum bandwidth of the EIP. Valid values: `1` to `200`. Unit: Mbit/s. Default value: `5`.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the EIP was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the delete protection function is turned on.
        - **true**: enabled.
        - **false**: not enabled.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the EIP.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="highDefinitionMonitorLogStatus")
    def high_definition_monitor_log_status(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the second-level monitoring is enabled for the EIP.
        - **OFF**: not enabled.
        - **ON**: enabled.
        """
        return pulumi.get(self, "high_definition_monitor_log_status")

    @high_definition_monitor_log_status.setter
    def high_definition_monitor_log_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "high_definition_monitor_log_status", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
        """
        warnings.warn("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""", DeprecationWarning)
        pulumi.log.warn("""instance_charge_type is deprecated: Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")

        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Renewal Payment type.
        - **PayByBandwidth**: billed by fixed bandwidth.
        - **PayByTraffic**: Billing by traffic.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the EIP.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[str]]:
        """
        The line type. You can set this parameter only when you create a `PayAsYouGo` EIP. Valid values:
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "isp", value)

    @property
    @pulumi.getter(name="logProject")
    def log_project(self) -> Optional[pulumi.Input[str]]:
        """
        The Name of the logging service LogProject. Current parameter is required when configuring high precision second-by-second monitoring for EIP.
        """
        return pulumi.get(self, "log_project")

    @log_project.setter
    def log_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_project", value)

    @property
    @pulumi.getter(name="logStore")
    def log_store(self) -> Optional[pulumi.Input[str]]:
        """
        The Name of the logging service LogStore. Current parameter is required when configuring high precision second-by-second monitoring for EIP.
        """
        return pulumi.get(self, "log_store")

    @log_store.setter
    def log_store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_store", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
        """
        warnings.warn("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""", DeprecationWarning)
        pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")

        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def netmode(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the network. Valid value is `public` (Internet).
        """
        return pulumi.get(self, "netmode")

    @netmode.setter
    def netmode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netmode", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The billing method of the EIP. Valid values:  `Subscription`, `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        When the PricingCycle is set to Month, the Period value ranges from 1 to 9.When the PricingCycle is set to Year, the Period range is 1 to 5.If the value of the InstanceChargeType parameter is PrePaid, this parameter is required. If the value of the InstanceChargeType parameter is PostPaid, this parameter is not filled in.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> Optional[pulumi.Input[str]]:
        """
        Value:Month (default): Pay monthly.Year: Pay per Year.This parameter is required when the value of the InstanceChargeType parameter is Subscription(PrePaid). This parameter is optional when the value of the InstanceChargeType parameter is PayAsYouGo(PostPaid).
        """
        return pulumi.get(self, "pricing_cycle")

    @pricing_cycle.setter
    def pricing_cycle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pricing_cycle", value)

    @property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the IP address pool to which the EIP belongs.
        """
        return pulumi.get(self, "public_ip_address_pool_id")

    @public_ip_address_pool_id.setter
    def public_ip_address_pool_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip_address_pool_id", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Security protection level.
        - When the return is empty, the basic DDoS protection is specified.
        - When **antidos_enhanced** is returned, it indicates DDoS protection (enhanced version).
        """
        return pulumi.get(self, "security_protection_types")

    @security_protection_types.setter
    def security_protection_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_protection_types", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the EIP.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The zone of the EIP.This parameter is returned only for whitelist users that are visible to the zone.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class EipAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activity_id: Optional[pulumi.Input[str]] = None,
                 address_name: Optional[pulumi.Input[str]] = None,
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 high_definition_monitor_log_status: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 log_project: Optional[pulumi.Input[str]] = None,
                 log_store: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 netmode: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 pricing_cycle: Optional[pulumi.Input[str]] = None,
                 public_ip_address_pool_id: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        EIP Address can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/eipAddress:EipAddress example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] activity_id: Special activity ID. This parameter is not required.
        :param pulumi.Input[str] address_name: The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
        :param pulumi.Input[bool] auto_pay: Whether to pay automatically. Valid values: `true` and `false`. Default value: `true`. When `auto_pay` is `true`, The order will be automatically paid. When `auto_pay` is `false`, The order needs to go to the order center to complete the payment. **NOTE:** When `payment_type` is `Subscription`, this parameter is valid.
        :param pulumi.Input[str] bandwidth: The maximum bandwidth of the EIP. Valid values: `1` to `200`. Unit: Mbit/s. Default value: `5`.
        :param pulumi.Input[bool] deletion_protection: Whether the delete protection function is turned on.
               - **true**: enabled.
               - **false**: not enabled.
        :param pulumi.Input[str] description: The description of the EIP.
        :param pulumi.Input[str] high_definition_monitor_log_status: Whether the second-level monitoring is enabled for the EIP.
               - **OFF**: not enabled.
               - **ON**: enabled.
        :param pulumi.Input[str] instance_charge_type: . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
        :param pulumi.Input[str] internet_charge_type: Renewal Payment type.
               - **PayByBandwidth**: billed by fixed bandwidth.
               - **PayByTraffic**: Billing by traffic.
        :param pulumi.Input[str] isp: The line type. You can set this parameter only when you create a `PayAsYouGo` EIP. Valid values:
        :param pulumi.Input[str] log_project: The Name of the logging service LogProject. Current parameter is required when configuring high precision second-by-second monitoring for EIP.
        :param pulumi.Input[str] log_store: The Name of the logging service LogStore. Current parameter is required when configuring high precision second-by-second monitoring for EIP.
        :param pulumi.Input[str] name: . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
        :param pulumi.Input[str] netmode: The type of the network. Valid value is `public` (Internet).
        :param pulumi.Input[str] payment_type: The billing method of the EIP. Valid values:  `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[int] period: When the PricingCycle is set to Month, the Period value ranges from 1 to 9.When the PricingCycle is set to Year, the Period range is 1 to 5.If the value of the InstanceChargeType parameter is PrePaid, this parameter is required. If the value of the InstanceChargeType parameter is PostPaid, this parameter is not filled in.
        :param pulumi.Input[str] pricing_cycle: Value:Month (default): Pay monthly.Year: Pay per Year.This parameter is required when the value of the InstanceChargeType parameter is Subscription(PrePaid). This parameter is optional when the value of the InstanceChargeType parameter is PayAsYouGo(PostPaid).
        :param pulumi.Input[str] public_ip_address_pool_id: The ID of the IP address pool to which the EIP belongs.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_protection_types: Security protection level.
               - When the return is empty, the basic DDoS protection is specified.
               - When **antidos_enhanced** is returned, it indicates DDoS protection (enhanced version).
        :param pulumi.Input[Mapping[str, Any]] tags: The tag of the resource.
        :param pulumi.Input[str] zone: The zone of the EIP.This parameter is returned only for whitelist users that are visible to the zone.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EipAddressArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        EIP Address can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/eipAddress:EipAddress example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EipAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 activity_id: Optional[pulumi.Input[str]] = None,
                 address_name: Optional[pulumi.Input[str]] = None,
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 high_definition_monitor_log_status: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 log_project: Optional[pulumi.Input[str]] = None,
                 log_store: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 netmode: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 pricing_cycle: Optional[pulumi.Input[str]] = None,
                 public_ip_address_pool_id: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipAddressArgs.__new__(EipAddressArgs)

            __props__.__dict__["activity_id"] = activity_id
            __props__.__dict__["address_name"] = address_name
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["high_definition_monitor_log_status"] = high_definition_monitor_log_status
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["isp"] = isp
            __props__.__dict__["log_project"] = log_project
            __props__.__dict__["log_store"] = log_store
            __props__.__dict__["name"] = name
            __props__.__dict__["netmode"] = netmode
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["pricing_cycle"] = pricing_cycle
            __props__.__dict__["public_ip_address_pool_id"] = public_ip_address_pool_id
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_protection_types"] = security_protection_types
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone"] = zone
            __props__.__dict__["create_time"] = None
            __props__.__dict__["ip_address"] = None
            __props__.__dict__["status"] = None
        super(EipAddress, __self__).__init__(
            'alicloud:ecs/eipAddress:EipAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            activity_id: Optional[pulumi.Input[str]] = None,
            address_name: Optional[pulumi.Input[str]] = None,
            auto_pay: Optional[pulumi.Input[bool]] = None,
            bandwidth: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            high_definition_monitor_log_status: Optional[pulumi.Input[str]] = None,
            instance_charge_type: Optional[pulumi.Input[str]] = None,
            internet_charge_type: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            isp: Optional[pulumi.Input[str]] = None,
            log_project: Optional[pulumi.Input[str]] = None,
            log_store: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            netmode: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            pricing_cycle: Optional[pulumi.Input[str]] = None,
            public_ip_address_pool_id: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            security_protection_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'EipAddress':
        """
        Get an existing EipAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] activity_id: Special activity ID. This parameter is not required.
        :param pulumi.Input[str] address_name: The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
        :param pulumi.Input[bool] auto_pay: Whether to pay automatically. Valid values: `true` and `false`. Default value: `true`. When `auto_pay` is `true`, The order will be automatically paid. When `auto_pay` is `false`, The order needs to go to the order center to complete the payment. **NOTE:** When `payment_type` is `Subscription`, this parameter is valid.
        :param pulumi.Input[str] bandwidth: The maximum bandwidth of the EIP. Valid values: `1` to `200`. Unit: Mbit/s. Default value: `5`.
        :param pulumi.Input[str] create_time: The time when the EIP was created.
        :param pulumi.Input[bool] deletion_protection: Whether the delete protection function is turned on.
               - **true**: enabled.
               - **false**: not enabled.
        :param pulumi.Input[str] description: The description of the EIP.
        :param pulumi.Input[str] high_definition_monitor_log_status: Whether the second-level monitoring is enabled for the EIP.
               - **OFF**: not enabled.
               - **ON**: enabled.
        :param pulumi.Input[str] instance_charge_type: . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
        :param pulumi.Input[str] internet_charge_type: Renewal Payment type.
               - **PayByBandwidth**: billed by fixed bandwidth.
               - **PayByTraffic**: Billing by traffic.
        :param pulumi.Input[str] ip_address: The IP address of the EIP.
        :param pulumi.Input[str] isp: The line type. You can set this parameter only when you create a `PayAsYouGo` EIP. Valid values:
        :param pulumi.Input[str] log_project: The Name of the logging service LogProject. Current parameter is required when configuring high precision second-by-second monitoring for EIP.
        :param pulumi.Input[str] log_store: The Name of the logging service LogStore. Current parameter is required when configuring high precision second-by-second monitoring for EIP.
        :param pulumi.Input[str] name: . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
        :param pulumi.Input[str] netmode: The type of the network. Valid value is `public` (Internet).
        :param pulumi.Input[str] payment_type: The billing method of the EIP. Valid values:  `Subscription`, `PayAsYouGo`.
        :param pulumi.Input[int] period: When the PricingCycle is set to Month, the Period value ranges from 1 to 9.When the PricingCycle is set to Year, the Period range is 1 to 5.If the value of the InstanceChargeType parameter is PrePaid, this parameter is required. If the value of the InstanceChargeType parameter is PostPaid, this parameter is not filled in.
        :param pulumi.Input[str] pricing_cycle: Value:Month (default): Pay monthly.Year: Pay per Year.This parameter is required when the value of the InstanceChargeType parameter is Subscription(PrePaid). This parameter is optional when the value of the InstanceChargeType parameter is PayAsYouGo(PostPaid).
        :param pulumi.Input[str] public_ip_address_pool_id: The ID of the IP address pool to which the EIP belongs.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_protection_types: Security protection level.
               - When the return is empty, the basic DDoS protection is specified.
               - When **antidos_enhanced** is returned, it indicates DDoS protection (enhanced version).
        :param pulumi.Input[str] status: The status of the EIP.
        :param pulumi.Input[Mapping[str, Any]] tags: The tag of the resource.
        :param pulumi.Input[str] zone: The zone of the EIP.This parameter is returned only for whitelist users that are visible to the zone.
               
               The following arguments will be discarded. Please use new fields as soon as possible:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipAddressState.__new__(_EipAddressState)

        __props__.__dict__["activity_id"] = activity_id
        __props__.__dict__["address_name"] = address_name
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["high_definition_monitor_log_status"] = high_definition_monitor_log_status
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["isp"] = isp
        __props__.__dict__["log_project"] = log_project
        __props__.__dict__["log_store"] = log_store
        __props__.__dict__["name"] = name
        __props__.__dict__["netmode"] = netmode
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["pricing_cycle"] = pricing_cycle
        __props__.__dict__["public_ip_address_pool_id"] = public_ip_address_pool_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_protection_types"] = security_protection_types
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["zone"] = zone
        return EipAddress(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activityId")
    def activity_id(self) -> pulumi.Output[Optional[str]]:
        """
        Special activity ID. This parameter is not required.
        """
        return pulumi.get(self, "activity_id")

    @property
    @pulumi.getter(name="addressName")
    def address_name(self) -> pulumi.Output[str]:
        """
        The name of the EIP instance. This name can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://.
        """
        return pulumi.get(self, "address_name")

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to pay automatically. Valid values: `true` and `false`. Default value: `true`. When `auto_pay` is `true`, The order will be automatically paid. When `auto_pay` is `false`, The order needs to go to the order center to complete the payment. **NOTE:** When `payment_type` is `Subscription`, this parameter is valid.
        """
        return pulumi.get(self, "auto_pay")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[str]:
        """
        The maximum bandwidth of the EIP. Valid values: `1` to `200`. Unit: Mbit/s. Default value: `5`.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time when the EIP was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[bool]:
        """
        Whether the delete protection function is turned on.
        - **true**: enabled.
        - **false**: not enabled.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the EIP.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="highDefinitionMonitorLogStatus")
    def high_definition_monitor_log_status(self) -> pulumi.Output[str]:
        """
        Whether the second-level monitoring is enabled for the EIP.
        - **OFF**: not enabled.
        - **ON**: enabled.
        """
        return pulumi.get(self, "high_definition_monitor_log_status")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[str]:
        """
        . Field 'instance_charge_type' has been deprecated from provider version 1.126.0. New field 'payment_type' instead.
        """
        warnings.warn("""Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""", DeprecationWarning)
        pulumi.log.warn("""instance_charge_type is deprecated: Field 'instance_charge_type' has been deprecated since provider version 1.126.0. New field 'payment_type' instead.""")

        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[str]:
        """
        Renewal Payment type.
        - **PayByBandwidth**: billed by fixed bandwidth.
        - **PayByTraffic**: Billing by traffic.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The IP address of the EIP.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def isp(self) -> pulumi.Output[str]:
        """
        The line type. You can set this parameter only when you create a `PayAsYouGo` EIP. Valid values:
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter(name="logProject")
    def log_project(self) -> pulumi.Output[Optional[str]]:
        """
        The Name of the logging service LogProject. Current parameter is required when configuring high precision second-by-second monitoring for EIP.
        """
        return pulumi.get(self, "log_project")

    @property
    @pulumi.getter(name="logStore")
    def log_store(self) -> pulumi.Output[Optional[str]]:
        """
        The Name of the logging service LogStore. Current parameter is required when configuring high precision second-by-second monitoring for EIP.
        """
        return pulumi.get(self, "log_store")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        . Field 'name' has been deprecated from provider version 1.126.0. New field 'address_name' instead.
        """
        warnings.warn("""Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""", DeprecationWarning)
        pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated since provider version 1.126.0. New field 'address_name' instead.""")

        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def netmode(self) -> pulumi.Output[str]:
        """
        The type of the network. Valid value is `public` (Internet).
        """
        return pulumi.get(self, "netmode")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The billing method of the EIP. Valid values:  `Subscription`, `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        When the PricingCycle is set to Month, the Period value ranges from 1 to 9.When the PricingCycle is set to Year, the Period range is 1 to 5.If the value of the InstanceChargeType parameter is PrePaid, this parameter is required. If the value of the InstanceChargeType parameter is PostPaid, this parameter is not filled in.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="pricingCycle")
    def pricing_cycle(self) -> pulumi.Output[Optional[str]]:
        """
        Value:Month (default): Pay monthly.Year: Pay per Year.This parameter is required when the value of the InstanceChargeType parameter is Subscription(PrePaid). This parameter is optional when the value of the InstanceChargeType parameter is PayAsYouGo(PostPaid).
        """
        return pulumi.get(self, "pricing_cycle")

    @property
    @pulumi.getter(name="publicIpAddressPoolId")
    def public_ip_address_pool_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the IP address pool to which the EIP belongs.
        """
        return pulumi.get(self, "public_ip_address_pool_id")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityProtectionTypes")
    def security_protection_types(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Security protection level.
        - When the return is empty, the basic DDoS protection is specified.
        - When **antidos_enhanced** is returned, it indicates DDoS protection (enhanced version).
        """
        return pulumi.get(self, "security_protection_types")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the EIP.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        The zone of the EIP.This parameter is returned only for whitelist users that are visible to the zone.

        The following arguments will be discarded. Please use new fields as soon as possible:
        """
        return pulumi.get(self, "zone")

