# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['EipSegmentAddressArgs', 'EipSegmentAddress']

@pulumi.input_type
class EipSegmentAddressArgs:
    def __init__(__self__, *,
                 eip_mask: pulumi.Input[str],
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 netmode: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a EipSegmentAddress resource.
        :param pulumi.Input[str] eip_mask: Mask of consecutive EIPs. Value:28: For a single call, the system will allocate 16 consecutive EIPs.27: For a single call, the system will allocate 32 consecutive EIPs.26: For a single call, the system will allocate 64 consecutive EIPs.25: For a single call, the system will allocate 128 consecutive EIPs.24: For a single call, the system will allocate 256 consecutive EIPs.
        :param pulumi.Input[str] bandwidth: The peak bandwidth of the EIP. Unit: Mbps. When the value of instancargetype is PostPaid and the value of InternetChargeType is PayByBandwidth, the range of Bandwidth is 1 to 500. If the value of instancargetype is PostPaid and the value of InternetChargeType is PayByTraffic, the range of Bandwidth is 1 to 200. When instancargetype is set to PrePaid, the range of Bandwidth is 1 to 1000. The default value is 5 Mbps.
        :param pulumi.Input[str] internet_charge_type: Continuous EIP billing method, valid values:
               - **PayByBandwidth** (default): Billing based on fixed bandwidth.
               - **PayByTraffic**: Billing by usage flow.
        :param pulumi.Input[str] isp: Line type. Valid values:
               - **BGP** (default):BGP (multi-line) line. BGP (multi-line) EIP is supported in all regions.
               - **BGP_PRO** :BGP (multi-line)_boutique line. Currently, only Hong Kong, Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), the Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions support BGP (multi-line)_boutique route EIP.
               For more information about BGP (multi-line) lines and BGP (multi-line) premium lines, see EIP line types.
               If you are a whitelist user with single-line bandwidth, you can also select the following types:
               - **ChinaTelecom** : China Telecom
               - **ChinaUnicom** : China Unicom
               - **ChinaMobile** : China Mobile
               - **ChinaTelecom_L2** : China Telecom L2
               - **ChinaUnicom_L2** : China Unicom L2
               - **ChinaMobile_L2** : China Mobile L2
               If you are a user of Hangzhou Financial Cloud, this field is required. The value is `BGP_FinanceCloud`.
        :param pulumi.Input[str] netmode: The network type. Set the value to **public**.
        """
        pulumi.set(__self__, "eip_mask", eip_mask)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if netmode is not None:
            pulumi.set(__self__, "netmode", netmode)

    @property
    @pulumi.getter(name="eipMask")
    def eip_mask(self) -> pulumi.Input[str]:
        """
        Mask of consecutive EIPs. Value:28: For a single call, the system will allocate 16 consecutive EIPs.27: For a single call, the system will allocate 32 consecutive EIPs.26: For a single call, the system will allocate 64 consecutive EIPs.25: For a single call, the system will allocate 128 consecutive EIPs.24: For a single call, the system will allocate 256 consecutive EIPs.
        """
        return pulumi.get(self, "eip_mask")

    @eip_mask.setter
    def eip_mask(self, value: pulumi.Input[str]):
        pulumi.set(self, "eip_mask", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        The peak bandwidth of the EIP. Unit: Mbps. When the value of instancargetype is PostPaid and the value of InternetChargeType is PayByBandwidth, the range of Bandwidth is 1 to 500. If the value of instancargetype is PostPaid and the value of InternetChargeType is PayByTraffic, the range of Bandwidth is 1 to 200. When instancargetype is set to PrePaid, the range of Bandwidth is 1 to 1000. The default value is 5 Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Continuous EIP billing method, valid values:
        - **PayByBandwidth** (default): Billing based on fixed bandwidth.
        - **PayByTraffic**: Billing by usage flow.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[str]]:
        """
        Line type. Valid values:
        - **BGP** (default):BGP (multi-line) line. BGP (multi-line) EIP is supported in all regions.
        - **BGP_PRO** :BGP (multi-line)_boutique line. Currently, only Hong Kong, Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), the Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions support BGP (multi-line)_boutique route EIP.
        For more information about BGP (multi-line) lines and BGP (multi-line) premium lines, see EIP line types.
        If you are a whitelist user with single-line bandwidth, you can also select the following types:
        - **ChinaTelecom** : China Telecom
        - **ChinaUnicom** : China Unicom
        - **ChinaMobile** : China Mobile
        - **ChinaTelecom_L2** : China Telecom L2
        - **ChinaUnicom_L2** : China Unicom L2
        - **ChinaMobile_L2** : China Mobile L2
        If you are a user of Hangzhou Financial Cloud, this field is required. The value is `BGP_FinanceCloud`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "isp", value)

    @property
    @pulumi.getter
    def netmode(self) -> Optional[pulumi.Input[str]]:
        """
        The network type. Set the value to **public**.
        """
        return pulumi.get(self, "netmode")

    @netmode.setter
    def netmode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netmode", value)


@pulumi.input_type
class _EipSegmentAddressState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 eip_mask: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 netmode: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering EipSegmentAddress resources.
        :param pulumi.Input[str] bandwidth: The peak bandwidth of the EIP. Unit: Mbps. When the value of instancargetype is PostPaid and the value of InternetChargeType is PayByBandwidth, the range of Bandwidth is 1 to 500. If the value of instancargetype is PostPaid and the value of InternetChargeType is PayByTraffic, the range of Bandwidth is 1 to 200. When instancargetype is set to PrePaid, the range of Bandwidth is 1 to 1000. The default value is 5 Mbps.
        :param pulumi.Input[str] create_time: The time when the contiguous Elastic IP address group was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[str] eip_mask: Mask of consecutive EIPs. Value:28: For a single call, the system will allocate 16 consecutive EIPs.27: For a single call, the system will allocate 32 consecutive EIPs.26: For a single call, the system will allocate 64 consecutive EIPs.25: For a single call, the system will allocate 128 consecutive EIPs.24: For a single call, the system will allocate 256 consecutive EIPs.
        :param pulumi.Input[str] internet_charge_type: Continuous EIP billing method, valid values:
               - **PayByBandwidth** (default): Billing based on fixed bandwidth.
               - **PayByTraffic**: Billing by usage flow.
        :param pulumi.Input[str] isp: Line type. Valid values:
               - **BGP** (default):BGP (multi-line) line. BGP (multi-line) EIP is supported in all regions.
               - **BGP_PRO** :BGP (multi-line)_boutique line. Currently, only Hong Kong, Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), the Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions support BGP (multi-line)_boutique route EIP.
               For more information about BGP (multi-line) lines and BGP (multi-line) premium lines, see EIP line types.
               If you are a whitelist user with single-line bandwidth, you can also select the following types:
               - **ChinaTelecom** : China Telecom
               - **ChinaUnicom** : China Unicom
               - **ChinaMobile** : China Mobile
               - **ChinaTelecom_L2** : China Telecom L2
               - **ChinaUnicom_L2** : China Unicom L2
               - **ChinaMobile_L2** : China Mobile L2
               If you are a user of Hangzhou Financial Cloud, this field is required. The value is `BGP_FinanceCloud`.
        :param pulumi.Input[str] netmode: The network type. Set the value to **public**.
        :param pulumi.Input[str] status: The status of the resource.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if eip_mask is not None:
            pulumi.set(__self__, "eip_mask", eip_mask)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if netmode is not None:
            pulumi.set(__self__, "netmode", netmode)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        The peak bandwidth of the EIP. Unit: Mbps. When the value of instancargetype is PostPaid and the value of InternetChargeType is PayByBandwidth, the range of Bandwidth is 1 to 500. If the value of instancargetype is PostPaid and the value of InternetChargeType is PayByTraffic, the range of Bandwidth is 1 to 200. When instancargetype is set to PrePaid, the range of Bandwidth is 1 to 1000. The default value is 5 Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the contiguous Elastic IP address group was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="eipMask")
    def eip_mask(self) -> Optional[pulumi.Input[str]]:
        """
        Mask of consecutive EIPs. Value:28: For a single call, the system will allocate 16 consecutive EIPs.27: For a single call, the system will allocate 32 consecutive EIPs.26: For a single call, the system will allocate 64 consecutive EIPs.25: For a single call, the system will allocate 128 consecutive EIPs.24: For a single call, the system will allocate 256 consecutive EIPs.
        """
        return pulumi.get(self, "eip_mask")

    @eip_mask.setter
    def eip_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_mask", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Continuous EIP billing method, valid values:
        - **PayByBandwidth** (default): Billing based on fixed bandwidth.
        - **PayByTraffic**: Billing by usage flow.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[str]]:
        """
        Line type. Valid values:
        - **BGP** (default):BGP (multi-line) line. BGP (multi-line) EIP is supported in all regions.
        - **BGP_PRO** :BGP (multi-line)_boutique line. Currently, only Hong Kong, Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), the Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions support BGP (multi-line)_boutique route EIP.
        For more information about BGP (multi-line) lines and BGP (multi-line) premium lines, see EIP line types.
        If you are a whitelist user with single-line bandwidth, you can also select the following types:
        - **ChinaTelecom** : China Telecom
        - **ChinaUnicom** : China Unicom
        - **ChinaMobile** : China Mobile
        - **ChinaTelecom_L2** : China Telecom L2
        - **ChinaUnicom_L2** : China Unicom L2
        - **ChinaMobile_L2** : China Mobile L2
        If you are a user of Hangzhou Financial Cloud, this field is required. The value is `BGP_FinanceCloud`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "isp", value)

    @property
    @pulumi.getter
    def netmode(self) -> Optional[pulumi.Input[str]]:
        """
        The network type. Set the value to **public**.
        """
        return pulumi.get(self, "netmode")

    @netmode.setter
    def netmode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "netmode", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class EipSegmentAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 eip_mask: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 netmode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a EIP Segment Address resource.

        For information about EIP Segment Address and how to use it, see [What is Segment Address](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/allocateeipsegmentaddress).

        > **NOTE:** Available since v1.207.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ecs.EipSegmentAddress("default",
            bandwidth="5",
            eip_mask="28",
            internet_charge_type="PayByBandwidth",
            isp="BGP",
            netmode="public")
        ```

        ## Import

        EIP Segment Address can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/eipSegmentAddress:EipSegmentAddress example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bandwidth: The peak bandwidth of the EIP. Unit: Mbps. When the value of instancargetype is PostPaid and the value of InternetChargeType is PayByBandwidth, the range of Bandwidth is 1 to 500. If the value of instancargetype is PostPaid and the value of InternetChargeType is PayByTraffic, the range of Bandwidth is 1 to 200. When instancargetype is set to PrePaid, the range of Bandwidth is 1 to 1000. The default value is 5 Mbps.
        :param pulumi.Input[str] eip_mask: Mask of consecutive EIPs. Value:28: For a single call, the system will allocate 16 consecutive EIPs.27: For a single call, the system will allocate 32 consecutive EIPs.26: For a single call, the system will allocate 64 consecutive EIPs.25: For a single call, the system will allocate 128 consecutive EIPs.24: For a single call, the system will allocate 256 consecutive EIPs.
        :param pulumi.Input[str] internet_charge_type: Continuous EIP billing method, valid values:
               - **PayByBandwidth** (default): Billing based on fixed bandwidth.
               - **PayByTraffic**: Billing by usage flow.
        :param pulumi.Input[str] isp: Line type. Valid values:
               - **BGP** (default):BGP (multi-line) line. BGP (multi-line) EIP is supported in all regions.
               - **BGP_PRO** :BGP (multi-line)_boutique line. Currently, only Hong Kong, Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), the Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions support BGP (multi-line)_boutique route EIP.
               For more information about BGP (multi-line) lines and BGP (multi-line) premium lines, see EIP line types.
               If you are a whitelist user with single-line bandwidth, you can also select the following types:
               - **ChinaTelecom** : China Telecom
               - **ChinaUnicom** : China Unicom
               - **ChinaMobile** : China Mobile
               - **ChinaTelecom_L2** : China Telecom L2
               - **ChinaUnicom_L2** : China Unicom L2
               - **ChinaMobile_L2** : China Mobile L2
               If you are a user of Hangzhou Financial Cloud, this field is required. The value is `BGP_FinanceCloud`.
        :param pulumi.Input[str] netmode: The network type. Set the value to **public**.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EipSegmentAddressArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a EIP Segment Address resource.

        For information about EIP Segment Address and how to use it, see [What is Segment Address](https://www.alibabacloud.com/help/en/virtual-private-cloud/latest/allocateeipsegmentaddress).

        > **NOTE:** Available since v1.207.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ecs.EipSegmentAddress("default",
            bandwidth="5",
            eip_mask="28",
            internet_charge_type="PayByBandwidth",
            isp="BGP",
            netmode="public")
        ```

        ## Import

        EIP Segment Address can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/eipSegmentAddress:EipSegmentAddress example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EipSegmentAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipSegmentAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 eip_mask: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 netmode: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipSegmentAddressArgs.__new__(EipSegmentAddressArgs)

            __props__.__dict__["bandwidth"] = bandwidth
            if eip_mask is None and not opts.urn:
                raise TypeError("Missing required property 'eip_mask'")
            __props__.__dict__["eip_mask"] = eip_mask
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["isp"] = isp
            __props__.__dict__["netmode"] = netmode
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(EipSegmentAddress, __self__).__init__(
            'alicloud:ecs/eipSegmentAddress:EipSegmentAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            eip_mask: Optional[pulumi.Input[str]] = None,
            internet_charge_type: Optional[pulumi.Input[str]] = None,
            isp: Optional[pulumi.Input[str]] = None,
            netmode: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'EipSegmentAddress':
        """
        Get an existing EipSegmentAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bandwidth: The peak bandwidth of the EIP. Unit: Mbps. When the value of instancargetype is PostPaid and the value of InternetChargeType is PayByBandwidth, the range of Bandwidth is 1 to 500. If the value of instancargetype is PostPaid and the value of InternetChargeType is PayByTraffic, the range of Bandwidth is 1 to 200. When instancargetype is set to PrePaid, the range of Bandwidth is 1 to 1000. The default value is 5 Mbps.
        :param pulumi.Input[str] create_time: The time when the contiguous Elastic IP address group was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        :param pulumi.Input[str] eip_mask: Mask of consecutive EIPs. Value:28: For a single call, the system will allocate 16 consecutive EIPs.27: For a single call, the system will allocate 32 consecutive EIPs.26: For a single call, the system will allocate 64 consecutive EIPs.25: For a single call, the system will allocate 128 consecutive EIPs.24: For a single call, the system will allocate 256 consecutive EIPs.
        :param pulumi.Input[str] internet_charge_type: Continuous EIP billing method, valid values:
               - **PayByBandwidth** (default): Billing based on fixed bandwidth.
               - **PayByTraffic**: Billing by usage flow.
        :param pulumi.Input[str] isp: Line type. Valid values:
               - **BGP** (default):BGP (multi-line) line. BGP (multi-line) EIP is supported in all regions.
               - **BGP_PRO** :BGP (multi-line)_boutique line. Currently, only Hong Kong, Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), the Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions support BGP (multi-line)_boutique route EIP.
               For more information about BGP (multi-line) lines and BGP (multi-line) premium lines, see EIP line types.
               If you are a whitelist user with single-line bandwidth, you can also select the following types:
               - **ChinaTelecom** : China Telecom
               - **ChinaUnicom** : China Unicom
               - **ChinaMobile** : China Mobile
               - **ChinaTelecom_L2** : China Telecom L2
               - **ChinaUnicom_L2** : China Unicom L2
               - **ChinaMobile_L2** : China Mobile L2
               If you are a user of Hangzhou Financial Cloud, this field is required. The value is `BGP_FinanceCloud`.
        :param pulumi.Input[str] netmode: The network type. Set the value to **public**.
        :param pulumi.Input[str] status: The status of the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipSegmentAddressState.__new__(_EipSegmentAddressState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["eip_mask"] = eip_mask
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["isp"] = isp
        __props__.__dict__["netmode"] = netmode
        __props__.__dict__["status"] = status
        return EipSegmentAddress(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[Optional[str]]:
        """
        The peak bandwidth of the EIP. Unit: Mbps. When the value of instancargetype is PostPaid and the value of InternetChargeType is PayByBandwidth, the range of Bandwidth is 1 to 500. If the value of instancargetype is PostPaid and the value of InternetChargeType is PayByTraffic, the range of Bandwidth is 1 to 200. When instancargetype is set to PrePaid, the range of Bandwidth is 1 to 1000. The default value is 5 Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time when the contiguous Elastic IP address group was created. The time follows the ISO 8601 standard in the yyyy-MM-ddTHH:mm:ssZ format. The time is displayed in UTC.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="eipMask")
    def eip_mask(self) -> pulumi.Output[str]:
        """
        Mask of consecutive EIPs. Value:28: For a single call, the system will allocate 16 consecutive EIPs.27: For a single call, the system will allocate 32 consecutive EIPs.26: For a single call, the system will allocate 64 consecutive EIPs.25: For a single call, the system will allocate 128 consecutive EIPs.24: For a single call, the system will allocate 256 consecutive EIPs.
        """
        return pulumi.get(self, "eip_mask")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[Optional[str]]:
        """
        Continuous EIP billing method, valid values:
        - **PayByBandwidth** (default): Billing based on fixed bandwidth.
        - **PayByTraffic**: Billing by usage flow.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter
    def isp(self) -> pulumi.Output[Optional[str]]:
        """
        Line type. Valid values:
        - **BGP** (default):BGP (multi-line) line. BGP (multi-line) EIP is supported in all regions.
        - **BGP_PRO** :BGP (multi-line)_boutique line. Currently, only Hong Kong, Singapore, Japan (Tokyo), Malaysia (Kuala Lumpur), the Philippines (Manila), Indonesia (Jakarta), and Thailand (Bangkok) regions support BGP (multi-line)_boutique route EIP.
        For more information about BGP (multi-line) lines and BGP (multi-line) premium lines, see EIP line types.
        If you are a whitelist user with single-line bandwidth, you can also select the following types:
        - **ChinaTelecom** : China Telecom
        - **ChinaUnicom** : China Unicom
        - **ChinaMobile** : China Mobile
        - **ChinaTelecom_L2** : China Telecom L2
        - **ChinaUnicom_L2** : China Unicom L2
        - **ChinaMobile_L2** : China Mobile L2
        If you are a user of Hangzhou Financial Cloud, this field is required. The value is `BGP_FinanceCloud`.
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter
    def netmode(self) -> pulumi.Output[Optional[str]]:
        """
        The network type. Set the value to **public**.
        """
        return pulumi.get(self, "netmode")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

