# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ElasticityAssuranceArgs', 'ElasticityAssurance']

@pulumi.input_type
class ElasticityAssuranceArgs:
    def __init__(__self__, *,
                 instance_amount: pulumi.Input[int],
                 instance_type: pulumi.Input[str],
                 zone_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 assurance_times: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 private_pool_options_match_criteria: Optional[pulumi.Input[str]] = None,
                 private_pool_options_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a ElasticityAssurance resource.
        :param pulumi.Input[int] instance_amount: The total number of instances for which to reserve the capacity of an instance type. Valid values: 1 to 1000.
        :param pulumi.Input[str] instance_type: Instance type. Currently, only one instance type is supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_ids: The zone ID of the region to which the elastic Protection Service belongs. Currently, only the creation of flexible protection services in one available area is supported.
        :param pulumi.Input[str] assurance_times: The total number of times that the elasticity assurance can be applied. Set the value to Unlimited. This value indicates that the elasticity assurance can be applied an unlimited number of times within its effective duration. Default value: Unlimited.
        :param pulumi.Input[str] description: Description of flexible guarantee service.
        :param pulumi.Input[int] period: Length of purchase. The unit of duration is determined by the 'period_unit' parameter. Default value: 1.
               - When the `period_unit` parameter is set to Month, the valid values are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
               - When the `period_unit` parameter is set to Year, the valid values are 1, 2, 3, 4, and 5.
        :param pulumi.Input[str] period_unit: Duration unit. Value range:-Month: Month-Year: YearDefault value: Year
        :param pulumi.Input[str] private_pool_options_match_criteria: The matching mode of flexible guarantee service. Possible values:-Open: flexible guarantee service for Open mode.-Target: specifies the flexible guarantee service of the mode.
        :param pulumi.Input[str] private_pool_options_name: The name of the flexible protection service.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] start_time: Flexible guarantee service effective time.
        :param pulumi.Input[Mapping[str, Any]] tags: The tag key-value pair information bound by the elastic guarantee service.
        """
        pulumi.set(__self__, "instance_amount", instance_amount)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "zone_ids", zone_ids)
        if assurance_times is not None:
            pulumi.set(__self__, "assurance_times", assurance_times)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if private_pool_options_match_criteria is not None:
            pulumi.set(__self__, "private_pool_options_match_criteria", private_pool_options_match_criteria)
        if private_pool_options_name is not None:
            pulumi.set(__self__, "private_pool_options_name", private_pool_options_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="instanceAmount")
    def instance_amount(self) -> pulumi.Input[int]:
        """
        The total number of instances for which to reserve the capacity of an instance type. Valid values: 1 to 1000.
        """
        return pulumi.get(self, "instance_amount")

    @instance_amount.setter
    def instance_amount(self, value: pulumi.Input[int]):
        pulumi.set(self, "instance_amount", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        Instance type. Currently, only one instance type is supported.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The zone ID of the region to which the elastic Protection Service belongs. Currently, only the creation of flexible protection services in one available area is supported.
        """
        return pulumi.get(self, "zone_ids")

    @zone_ids.setter
    def zone_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "zone_ids", value)

    @property
    @pulumi.getter(name="assuranceTimes")
    def assurance_times(self) -> Optional[pulumi.Input[str]]:
        """
        The total number of times that the elasticity assurance can be applied. Set the value to Unlimited. This value indicates that the elasticity assurance can be applied an unlimited number of times within its effective duration. Default value: Unlimited.
        """
        return pulumi.get(self, "assurance_times")

    @assurance_times.setter
    def assurance_times(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assurance_times", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of flexible guarantee service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Length of purchase. The unit of duration is determined by the 'period_unit' parameter. Default value: 1.
        - When the `period_unit` parameter is set to Month, the valid values are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
        - When the `period_unit` parameter is set to Year, the valid values are 1, 2, 3, 4, and 5.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Duration unit. Value range:-Month: Month-Year: YearDefault value: Year
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="privatePoolOptionsMatchCriteria")
    def private_pool_options_match_criteria(self) -> Optional[pulumi.Input[str]]:
        """
        The matching mode of flexible guarantee service. Possible values:-Open: flexible guarantee service for Open mode.-Target: specifies the flexible guarantee service of the mode.
        """
        return pulumi.get(self, "private_pool_options_match_criteria")

    @private_pool_options_match_criteria.setter
    def private_pool_options_match_criteria(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_pool_options_match_criteria", value)

    @property
    @pulumi.getter(name="privatePoolOptionsName")
    def private_pool_options_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the flexible protection service.
        """
        return pulumi.get(self, "private_pool_options_name")

    @private_pool_options_name.setter
    def private_pool_options_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_pool_options_name", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Flexible guarantee service effective time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The tag key-value pair information bound by the elastic guarantee service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ElasticityAssuranceState:
    def __init__(__self__, *,
                 assurance_times: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 elasticity_assurance_id: Optional[pulumi.Input[str]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 instance_amount: Optional[pulumi.Input[int]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 private_pool_options_match_criteria: Optional[pulumi.Input[str]] = None,
                 private_pool_options_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 start_time_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 used_assurance_times: Optional[pulumi.Input[int]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering ElasticityAssurance resources.
        :param pulumi.Input[str] assurance_times: The total number of times that the elasticity assurance can be applied. Set the value to Unlimited. This value indicates that the elasticity assurance can be applied an unlimited number of times within its effective duration. Default value: Unlimited.
        :param pulumi.Input[str] description: Description of flexible guarantee service.
        :param pulumi.Input[str] elasticity_assurance_id: The first ID of the resource
        :param pulumi.Input[str] end_time: Flexible guarantee service failure time.
        :param pulumi.Input[int] instance_amount: The total number of instances for which to reserve the capacity of an instance type. Valid values: 1 to 1000.
        :param pulumi.Input[str] instance_charge_type: The billing method of the instance. Possible value: PostPaid. Currently, only pay-as-you-go is supported.
        :param pulumi.Input[str] instance_type: Instance type. Currently, only one instance type is supported.
        :param pulumi.Input[int] period: Length of purchase. The unit of duration is determined by the 'period_unit' parameter. Default value: 1.
               - When the `period_unit` parameter is set to Month, the valid values are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
               - When the `period_unit` parameter is set to Year, the valid values are 1, 2, 3, 4, and 5.
        :param pulumi.Input[str] period_unit: Duration unit. Value range:-Month: Month-Year: YearDefault value: Year
        :param pulumi.Input[str] private_pool_options_match_criteria: The matching mode of flexible guarantee service. Possible values:-Open: flexible guarantee service for Open mode.-Target: specifies the flexible guarantee service of the mode.
        :param pulumi.Input[str] private_pool_options_name: The name of the flexible protection service.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] start_time: Flexible guarantee service effective time.
        :param pulumi.Input[str] start_time_type: Flexible guarantee effective way. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
        :param pulumi.Input[str] status: The status of flexible guarantee services. Possible values:-Preparing: in preparation.-Prepared: to take effect.-Active: in effect.-Released: Released.
        :param pulumi.Input[Mapping[str, Any]] tags: The tag key-value pair information bound by the elastic guarantee service.
        :param pulumi.Input[int] used_assurance_times: This parameter is not yet available.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_ids: The zone ID of the region to which the elastic Protection Service belongs. Currently, only the creation of flexible protection services in one available area is supported.
        """
        if assurance_times is not None:
            pulumi.set(__self__, "assurance_times", assurance_times)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if elasticity_assurance_id is not None:
            pulumi.set(__self__, "elasticity_assurance_id", elasticity_assurance_id)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if instance_amount is not None:
            pulumi.set(__self__, "instance_amount", instance_amount)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if private_pool_options_match_criteria is not None:
            pulumi.set(__self__, "private_pool_options_match_criteria", private_pool_options_match_criteria)
        if private_pool_options_name is not None:
            pulumi.set(__self__, "private_pool_options_name", private_pool_options_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if start_time_type is not None:
            pulumi.set(__self__, "start_time_type", start_time_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if used_assurance_times is not None:
            pulumi.set(__self__, "used_assurance_times", used_assurance_times)
        if zone_ids is not None:
            pulumi.set(__self__, "zone_ids", zone_ids)

    @property
    @pulumi.getter(name="assuranceTimes")
    def assurance_times(self) -> Optional[pulumi.Input[str]]:
        """
        The total number of times that the elasticity assurance can be applied. Set the value to Unlimited. This value indicates that the elasticity assurance can be applied an unlimited number of times within its effective duration. Default value: Unlimited.
        """
        return pulumi.get(self, "assurance_times")

    @assurance_times.setter
    def assurance_times(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assurance_times", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of flexible guarantee service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="elasticityAssuranceId")
    def elasticity_assurance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "elasticity_assurance_id")

    @elasticity_assurance_id.setter
    def elasticity_assurance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "elasticity_assurance_id", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Flexible guarantee service failure time.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="instanceAmount")
    def instance_amount(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of instances for which to reserve the capacity of an instance type. Valid values: 1 to 1000.
        """
        return pulumi.get(self, "instance_amount")

    @instance_amount.setter
    def instance_amount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_amount", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The billing method of the instance. Possible value: PostPaid. Currently, only pay-as-you-go is supported.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance type. Currently, only one instance type is supported.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Length of purchase. The unit of duration is determined by the 'period_unit' parameter. Default value: 1.
        - When the `period_unit` parameter is set to Month, the valid values are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
        - When the `period_unit` parameter is set to Year, the valid values are 1, 2, 3, 4, and 5.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Duration unit. Value range:-Month: Month-Year: YearDefault value: Year
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="privatePoolOptionsMatchCriteria")
    def private_pool_options_match_criteria(self) -> Optional[pulumi.Input[str]]:
        """
        The matching mode of flexible guarantee service. Possible values:-Open: flexible guarantee service for Open mode.-Target: specifies the flexible guarantee service of the mode.
        """
        return pulumi.get(self, "private_pool_options_match_criteria")

    @private_pool_options_match_criteria.setter
    def private_pool_options_match_criteria(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_pool_options_match_criteria", value)

    @property
    @pulumi.getter(name="privatePoolOptionsName")
    def private_pool_options_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the flexible protection service.
        """
        return pulumi.get(self, "private_pool_options_name")

    @private_pool_options_name.setter
    def private_pool_options_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_pool_options_name", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Flexible guarantee service effective time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="startTimeType")
    def start_time_type(self) -> Optional[pulumi.Input[str]]:
        """
        Flexible guarantee effective way. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
        """
        return pulumi.get(self, "start_time_type")

    @start_time_type.setter
    def start_time_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of flexible guarantee services. Possible values:-Preparing: in preparation.-Prepared: to take effect.-Active: in effect.-Released: Released.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The tag key-value pair information bound by the elastic guarantee service.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="usedAssuranceTimes")
    def used_assurance_times(self) -> Optional[pulumi.Input[int]]:
        """
        This parameter is not yet available.
        """
        return pulumi.get(self, "used_assurance_times")

    @used_assurance_times.setter
    def used_assurance_times(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "used_assurance_times", value)

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The zone ID of the region to which the elastic Protection Service belongs. Currently, only the creation of flexible protection services in one available area is supported.
        """
        return pulumi.get(self, "zone_ids")

    @zone_ids.setter
    def zone_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zone_ids", value)


class ElasticityAssurance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assurance_times: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_amount: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 private_pool_options_match_criteria: Optional[pulumi.Input[str]] = None,
                 private_pool_options_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a Ecs Elasticity Assurance resource.

        For information about Ecs Elasticity Assurance and how to use it, see [What is Elasticity Assurance](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/createelasticityassurance).

        > **NOTE:** Available in v1.196.0+.

        ## Import

        Ecs Elasticity Assurance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/elasticityAssurance:ElasticityAssurance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] assurance_times: The total number of times that the elasticity assurance can be applied. Set the value to Unlimited. This value indicates that the elasticity assurance can be applied an unlimited number of times within its effective duration. Default value: Unlimited.
        :param pulumi.Input[str] description: Description of flexible guarantee service.
        :param pulumi.Input[int] instance_amount: The total number of instances for which to reserve the capacity of an instance type. Valid values: 1 to 1000.
        :param pulumi.Input[str] instance_type: Instance type. Currently, only one instance type is supported.
        :param pulumi.Input[int] period: Length of purchase. The unit of duration is determined by the 'period_unit' parameter. Default value: 1.
               - When the `period_unit` parameter is set to Month, the valid values are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
               - When the `period_unit` parameter is set to Year, the valid values are 1, 2, 3, 4, and 5.
        :param pulumi.Input[str] period_unit: Duration unit. Value range:-Month: Month-Year: YearDefault value: Year
        :param pulumi.Input[str] private_pool_options_match_criteria: The matching mode of flexible guarantee service. Possible values:-Open: flexible guarantee service for Open mode.-Target: specifies the flexible guarantee service of the mode.
        :param pulumi.Input[str] private_pool_options_name: The name of the flexible protection service.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] start_time: Flexible guarantee service effective time.
        :param pulumi.Input[Mapping[str, Any]] tags: The tag key-value pair information bound by the elastic guarantee service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_ids: The zone ID of the region to which the elastic Protection Service belongs. Currently, only the creation of flexible protection services in one available area is supported.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ElasticityAssuranceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Ecs Elasticity Assurance resource.

        For information about Ecs Elasticity Assurance and how to use it, see [What is Elasticity Assurance](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/createelasticityassurance).

        > **NOTE:** Available in v1.196.0+.

        ## Import

        Ecs Elasticity Assurance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/elasticityAssurance:ElasticityAssurance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ElasticityAssuranceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ElasticityAssuranceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assurance_times: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 instance_amount: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 private_pool_options_match_criteria: Optional[pulumi.Input[str]] = None,
                 private_pool_options_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ElasticityAssuranceArgs.__new__(ElasticityAssuranceArgs)

            __props__.__dict__["assurance_times"] = assurance_times
            __props__.__dict__["description"] = description
            if instance_amount is None and not opts.urn:
                raise TypeError("Missing required property 'instance_amount'")
            __props__.__dict__["instance_amount"] = instance_amount
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["private_pool_options_match_criteria"] = private_pool_options_match_criteria
            __props__.__dict__["private_pool_options_name"] = private_pool_options_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["tags"] = tags
            if zone_ids is None and not opts.urn:
                raise TypeError("Missing required property 'zone_ids'")
            __props__.__dict__["zone_ids"] = zone_ids
            __props__.__dict__["elasticity_assurance_id"] = None
            __props__.__dict__["end_time"] = None
            __props__.__dict__["instance_charge_type"] = None
            __props__.__dict__["start_time_type"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["used_assurance_times"] = None
        super(ElasticityAssurance, __self__).__init__(
            'alicloud:ecs/elasticityAssurance:ElasticityAssurance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assurance_times: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            elasticity_assurance_id: Optional[pulumi.Input[str]] = None,
            end_time: Optional[pulumi.Input[str]] = None,
            instance_amount: Optional[pulumi.Input[int]] = None,
            instance_charge_type: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            private_pool_options_match_criteria: Optional[pulumi.Input[str]] = None,
            private_pool_options_name: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            start_time: Optional[pulumi.Input[str]] = None,
            start_time_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            used_assurance_times: Optional[pulumi.Input[int]] = None,
            zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'ElasticityAssurance':
        """
        Get an existing ElasticityAssurance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] assurance_times: The total number of times that the elasticity assurance can be applied. Set the value to Unlimited. This value indicates that the elasticity assurance can be applied an unlimited number of times within its effective duration. Default value: Unlimited.
        :param pulumi.Input[str] description: Description of flexible guarantee service.
        :param pulumi.Input[str] elasticity_assurance_id: The first ID of the resource
        :param pulumi.Input[str] end_time: Flexible guarantee service failure time.
        :param pulumi.Input[int] instance_amount: The total number of instances for which to reserve the capacity of an instance type. Valid values: 1 to 1000.
        :param pulumi.Input[str] instance_charge_type: The billing method of the instance. Possible value: PostPaid. Currently, only pay-as-you-go is supported.
        :param pulumi.Input[str] instance_type: Instance type. Currently, only one instance type is supported.
        :param pulumi.Input[int] period: Length of purchase. The unit of duration is determined by the 'period_unit' parameter. Default value: 1.
               - When the `period_unit` parameter is set to Month, the valid values are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
               - When the `period_unit` parameter is set to Year, the valid values are 1, 2, 3, 4, and 5.
        :param pulumi.Input[str] period_unit: Duration unit. Value range:-Month: Month-Year: YearDefault value: Year
        :param pulumi.Input[str] private_pool_options_match_criteria: The matching mode of flexible guarantee service. Possible values:-Open: flexible guarantee service for Open mode.-Target: specifies the flexible guarantee service of the mode.
        :param pulumi.Input[str] private_pool_options_name: The name of the flexible protection service.
        :param pulumi.Input[str] resource_group_id: The ID of the resource group.
        :param pulumi.Input[str] start_time: Flexible guarantee service effective time.
        :param pulumi.Input[str] start_time_type: Flexible guarantee effective way. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
        :param pulumi.Input[str] status: The status of flexible guarantee services. Possible values:-Preparing: in preparation.-Prepared: to take effect.-Active: in effect.-Released: Released.
        :param pulumi.Input[Mapping[str, Any]] tags: The tag key-value pair information bound by the elastic guarantee service.
        :param pulumi.Input[int] used_assurance_times: This parameter is not yet available.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_ids: The zone ID of the region to which the elastic Protection Service belongs. Currently, only the creation of flexible protection services in one available area is supported.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ElasticityAssuranceState.__new__(_ElasticityAssuranceState)

        __props__.__dict__["assurance_times"] = assurance_times
        __props__.__dict__["description"] = description
        __props__.__dict__["elasticity_assurance_id"] = elasticity_assurance_id
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["instance_amount"] = instance_amount
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["private_pool_options_match_criteria"] = private_pool_options_match_criteria
        __props__.__dict__["private_pool_options_name"] = private_pool_options_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["start_time_type"] = start_time_type
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["used_assurance_times"] = used_assurance_times
        __props__.__dict__["zone_ids"] = zone_ids
        return ElasticityAssurance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="assuranceTimes")
    def assurance_times(self) -> pulumi.Output[str]:
        """
        The total number of times that the elasticity assurance can be applied. Set the value to Unlimited. This value indicates that the elasticity assurance can be applied an unlimited number of times within its effective duration. Default value: Unlimited.
        """
        return pulumi.get(self, "assurance_times")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of flexible guarantee service.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="elasticityAssuranceId")
    def elasticity_assurance_id(self) -> pulumi.Output[str]:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "elasticity_assurance_id")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[str]:
        """
        Flexible guarantee service failure time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="instanceAmount")
    def instance_amount(self) -> pulumi.Output[int]:
        """
        The total number of instances for which to reserve the capacity of an instance type. Valid values: 1 to 1000.
        """
        return pulumi.get(self, "instance_amount")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[str]:
        """
        The billing method of the instance. Possible value: PostPaid. Currently, only pay-as-you-go is supported.
        """
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        Instance type. Currently, only one instance type is supported.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Length of purchase. The unit of duration is determined by the 'period_unit' parameter. Default value: 1.
        - When the `period_unit` parameter is set to Month, the valid values are 1, 2, 3, 4, 5, 6, 7, 8, and 9.
        - When the `period_unit` parameter is set to Year, the valid values are 1, 2, 3, 4, and 5.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Duration unit. Value range:-Month: Month-Year: YearDefault value: Year
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter(name="privatePoolOptionsMatchCriteria")
    def private_pool_options_match_criteria(self) -> pulumi.Output[str]:
        """
        The matching mode of flexible guarantee service. Possible values:-Open: flexible guarantee service for Open mode.-Target: specifies the flexible guarantee service of the mode.
        """
        return pulumi.get(self, "private_pool_options_match_criteria")

    @property
    @pulumi.getter(name="privatePoolOptionsName")
    def private_pool_options_name(self) -> pulumi.Output[str]:
        """
        The name of the flexible protection service.
        """
        return pulumi.get(self, "private_pool_options_name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[str]:
        """
        Flexible guarantee service effective time.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="startTimeType")
    def start_time_type(self) -> pulumi.Output[str]:
        """
        Flexible guarantee effective way. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
        """
        return pulumi.get(self, "start_time_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of flexible guarantee services. Possible values:-Preparing: in preparation.-Prepared: to take effect.-Active: in effect.-Released: Released.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        The tag key-value pair information bound by the elastic guarantee service.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="usedAssuranceTimes")
    def used_assurance_times(self) -> pulumi.Output[int]:
        """
        This parameter is not yet available.
        """
        return pulumi.get(self, "used_assurance_times")

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The zone ID of the region to which the elastic Protection Service belongs. Currently, only the creation of flexible protection services in one available area is supported.
        """
        return pulumi.get(self, "zone_ids")

