# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetEcsNetworkInterfacesResult',
    'AwaitableGetEcsNetworkInterfacesResult',
    'get_ecs_network_interfaces',
    'get_ecs_network_interfaces_output',
]

@pulumi.output_type
class GetEcsNetworkInterfacesResult:
    """
    A collection of values returned by getEcsNetworkInterfaces.
    """
    def __init__(__self__, id=None, ids=None, instance_id=None, interfaces=None, name=None, name_regex=None, names=None, network_interface_name=None, output_file=None, primary_ip_address=None, private_ip=None, resource_group_id=None, security_group_id=None, service_managed=None, status=None, tags=None, type=None, vpc_id=None, vswitch_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if interfaces and not isinstance(interfaces, list):
            raise TypeError("Expected argument 'interfaces' to be a list")
        pulumi.set(__self__, "interfaces", interfaces)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if network_interface_name and not isinstance(network_interface_name, str):
            raise TypeError("Expected argument 'network_interface_name' to be a str")
        pulumi.set(__self__, "network_interface_name", network_interface_name)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if primary_ip_address and not isinstance(primary_ip_address, str):
            raise TypeError("Expected argument 'primary_ip_address' to be a str")
        pulumi.set(__self__, "primary_ip_address", primary_ip_address)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_group_id and not isinstance(security_group_id, str):
            raise TypeError("Expected argument 'security_group_id' to be a str")
        pulumi.set(__self__, "security_group_id", security_group_id)
        if service_managed and not isinstance(service_managed, bool):
            raise TypeError("Expected argument 'service_managed' to be a bool")
        pulumi.set(__self__, "service_managed", service_managed)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id and not isinstance(vswitch_id, str):
            raise TypeError("Expected argument 'vswitch_id' to be a str")
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def interfaces(self) -> Sequence['outputs.GetEcsNetworkInterfacesInterfaceResult']:
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        warnings.warn("""Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name' instead""", DeprecationWarning)
        pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.123.1. New field 'network_interface_name' instead""")

        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="networkInterfaceName")
    def network_interface_name(self) -> Optional[str]:
        return pulumi.get(self, "network_interface_name")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="primaryIpAddress")
    def primary_ip_address(self) -> Optional[str]:
        return pulumi.get(self, "primary_ip_address")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        warnings.warn("""Field 'private_ip' has been deprecated from provider version 1.123.1. New field 'primary_ip_address' instead""", DeprecationWarning)
        pulumi.log.warn("""private_ip is deprecated: Field 'private_ip' has been deprecated from provider version 1.123.1. New field 'primary_ip_address' instead""")

        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[str]:
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[str]:
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="serviceManaged")
    def service_managed(self) -> Optional[bool]:
        return pulumi.get(self, "service_managed")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[str]:
        return pulumi.get(self, "vswitch_id")


class AwaitableGetEcsNetworkInterfacesResult(GetEcsNetworkInterfacesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEcsNetworkInterfacesResult(
            id=self.id,
            ids=self.ids,
            instance_id=self.instance_id,
            interfaces=self.interfaces,
            name=self.name,
            name_regex=self.name_regex,
            names=self.names,
            network_interface_name=self.network_interface_name,
            output_file=self.output_file,
            primary_ip_address=self.primary_ip_address,
            private_ip=self.private_ip,
            resource_group_id=self.resource_group_id,
            security_group_id=self.security_group_id,
            service_managed=self.service_managed,
            status=self.status,
            tags=self.tags,
            type=self.type,
            vpc_id=self.vpc_id,
            vswitch_id=self.vswitch_id)


def get_ecs_network_interfaces(ids: Optional[Sequence[str]] = None,
                               instance_id: Optional[str] = None,
                               name: Optional[str] = None,
                               name_regex: Optional[str] = None,
                               network_interface_name: Optional[str] = None,
                               output_file: Optional[str] = None,
                               primary_ip_address: Optional[str] = None,
                               private_ip: Optional[str] = None,
                               resource_group_id: Optional[str] = None,
                               security_group_id: Optional[str] = None,
                               service_managed: Optional[bool] = None,
                               status: Optional[str] = None,
                               tags: Optional[Mapping[str, Any]] = None,
                               type: Optional[str] = None,
                               vpc_id: Optional[str] = None,
                               vswitch_id: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEcsNetworkInterfacesResult:
    """
    This data source provides the Ecs Network Interfaces of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.123.1+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.ecs.get_ecs_network_interfaces(ids=["eni-abcd1234"],
        name_regex="tf-testAcc")
    pulumi.export("firstEcsNetworkInterfaceId", example.interfaces[0].id)
    ```


    :param Sequence[str] ids: A list of Network Interface IDs.
    :param str instance_id: The instance id.
    :param str name: The network interface name.
    :param str name_regex: A regex string to filter results by Network Interface name.
    :param str network_interface_name: The network interface name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str primary_ip_address: The primary private IP address of the ENI.
    :param str private_ip: The primary private IP address of the ENI.
    :param str resource_group_id: The resource group id.
    :param str security_group_id: The security group id.
    :param bool service_managed: Whether the user of the elastic network card is a cloud product or a virtual vendor.
    :param str status: The status of the ENI.
    :param Mapping[str, Any] tags: The tags.
    :param str type: The type of the ENI.
    :param str vpc_id: The Vpc Id.
    :param str vswitch_id: The vswitch id.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['nameRegex'] = name_regex
    __args__['networkInterfaceName'] = network_interface_name
    __args__['outputFile'] = output_file
    __args__['primaryIpAddress'] = primary_ip_address
    __args__['privateIp'] = private_ip
    __args__['resourceGroupId'] = resource_group_id
    __args__['securityGroupId'] = security_group_id
    __args__['serviceManaged'] = service_managed
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['type'] = type
    __args__['vpcId'] = vpc_id
    __args__['vswitchId'] = vswitch_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ecs/getEcsNetworkInterfaces:getEcsNetworkInterfaces', __args__, opts=opts, typ=GetEcsNetworkInterfacesResult).value

    return AwaitableGetEcsNetworkInterfacesResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        interfaces=pulumi.get(__ret__, 'interfaces'),
        name=pulumi.get(__ret__, 'name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        network_interface_name=pulumi.get(__ret__, 'network_interface_name'),
        output_file=pulumi.get(__ret__, 'output_file'),
        primary_ip_address=pulumi.get(__ret__, 'primary_ip_address'),
        private_ip=pulumi.get(__ret__, 'private_ip'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        security_group_id=pulumi.get(__ret__, 'security_group_id'),
        service_managed=pulumi.get(__ret__, 'service_managed'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        type=pulumi.get(__ret__, 'type'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        vswitch_id=pulumi.get(__ret__, 'vswitch_id'))


@_utilities.lift_output_func(get_ecs_network_interfaces)
def get_ecs_network_interfaces_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                      instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                                      name: Optional[pulumi.Input[Optional[str]]] = None,
                                      name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                                      network_interface_name: Optional[pulumi.Input[Optional[str]]] = None,
                                      output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                      primary_ip_address: Optional[pulumi.Input[Optional[str]]] = None,
                                      private_ip: Optional[pulumi.Input[Optional[str]]] = None,
                                      resource_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                      security_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                      service_managed: Optional[pulumi.Input[Optional[bool]]] = None,
                                      status: Optional[pulumi.Input[Optional[str]]] = None,
                                      tags: Optional[pulumi.Input[Optional[Mapping[str, Any]]]] = None,
                                      type: Optional[pulumi.Input[Optional[str]]] = None,
                                      vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                                      vswitch_id: Optional[pulumi.Input[Optional[str]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEcsNetworkInterfacesResult]:
    """
    This data source provides the Ecs Network Interfaces of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.123.1+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    example = alicloud.ecs.get_ecs_network_interfaces(ids=["eni-abcd1234"],
        name_regex="tf-testAcc")
    pulumi.export("firstEcsNetworkInterfaceId", example.interfaces[0].id)
    ```


    :param Sequence[str] ids: A list of Network Interface IDs.
    :param str instance_id: The instance id.
    :param str name: The network interface name.
    :param str name_regex: A regex string to filter results by Network Interface name.
    :param str network_interface_name: The network interface name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str primary_ip_address: The primary private IP address of the ENI.
    :param str private_ip: The primary private IP address of the ENI.
    :param str resource_group_id: The resource group id.
    :param str security_group_id: The security group id.
    :param bool service_managed: Whether the user of the elastic network card is a cloud product or a virtual vendor.
    :param str status: The status of the ENI.
    :param Mapping[str, Any] tags: The tags.
    :param str type: The type of the ENI.
    :param str vpc_id: The Vpc Id.
    :param str vswitch_id: The vswitch id.
    """
    ...
