# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ImageImportArgs', 'ImageImport']

@pulumi.input_type
class ImageImportArgs:
    def __init__(__self__, *,
                 disk_device_mappings: pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]],
                 architecture: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ImageImport resource.
        :param pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]] disk_device_mappings: Description of the system with disks and snapshots under the image.
        :param pulumi.Input[str] architecture: Specifies the architecture of the system disk after you specify a data disk snapshot as the data source of the system disk for creating an image. Valid values: `i386` , Default is `x86_64`.
        :param pulumi.Input[str] description: Description of the image. The length is 2 to 256 English or Chinese characters, and cannot begin with http: // and https: //.
        :param pulumi.Input[str] image_name: The image name. The length is 2 ~ 128 English or Chinese characters. Must start with a english letter or Chinese, and cannot start with http: // and https: //. Can contain numbers, colons (:), underscores (_), or hyphens (-).
        :param pulumi.Input[str] license_type: The type of the license used to activate the operating system after the image is imported. Default value: `Auto`. Valid values: `Auto`,`Aliyun`,`BYOL`.
        :param pulumi.Input[str] os_type: Operating system platform type. Valid values: `windows`, Default is `linux`.
        :param pulumi.Input[str] platform: The operating system distribution. Default value: Others Linux. 
               More valid values refer to [ImportImage OpenAPI](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/importimage).
               **NOTE**: It's default value is Ubuntu before version 1.197.0.
        """
        pulumi.set(__self__, "disk_device_mappings", disk_device_mappings)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)

    @property
    @pulumi.getter(name="diskDeviceMappings")
    def disk_device_mappings(self) -> pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]]:
        """
        Description of the system with disks and snapshots under the image.
        """
        return pulumi.get(self, "disk_device_mappings")

    @disk_device_mappings.setter
    def disk_device_mappings(self, value: pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]]):
        pulumi.set(self, "disk_device_mappings", value)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the architecture of the system disk after you specify a data disk snapshot as the data source of the system disk for creating an image. Valid values: `i386` , Default is `x86_64`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the image. The length is 2 to 256 English or Chinese characters, and cannot begin with http: // and https: //.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[str]]:
        """
        The image name. The length is 2 ~ 128 English or Chinese characters. Must start with a english letter or Chinese, and cannot start with http: // and https: //. Can contain numbers, colons (:), underscores (_), or hyphens (-).
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the license used to activate the operating system after the image is imported. Default value: `Auto`. Valid values: `Auto`,`Aliyun`,`BYOL`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        Operating system platform type. Valid values: `windows`, Default is `linux`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        The operating system distribution. Default value: Others Linux. 
        More valid values refer to [ImportImage OpenAPI](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/importimage).
        **NOTE**: It's default value is Ubuntu before version 1.197.0.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)


@pulumi.input_type
class _ImageImportState:
    def __init__(__self__, *,
                 architecture: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ImageImport resources.
        :param pulumi.Input[str] architecture: Specifies the architecture of the system disk after you specify a data disk snapshot as the data source of the system disk for creating an image. Valid values: `i386` , Default is `x86_64`.
        :param pulumi.Input[str] description: Description of the image. The length is 2 to 256 English or Chinese characters, and cannot begin with http: // and https: //.
        :param pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]] disk_device_mappings: Description of the system with disks and snapshots under the image.
        :param pulumi.Input[str] image_name: The image name. The length is 2 ~ 128 English or Chinese characters. Must start with a english letter or Chinese, and cannot start with http: // and https: //. Can contain numbers, colons (:), underscores (_), or hyphens (-).
        :param pulumi.Input[str] license_type: The type of the license used to activate the operating system after the image is imported. Default value: `Auto`. Valid values: `Auto`,`Aliyun`,`BYOL`.
        :param pulumi.Input[str] os_type: Operating system platform type. Valid values: `windows`, Default is `linux`.
        :param pulumi.Input[str] platform: The operating system distribution. Default value: Others Linux. 
               More valid values refer to [ImportImage OpenAPI](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/importimage).
               **NOTE**: It's default value is Ubuntu before version 1.197.0.
        """
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_device_mappings is not None:
            pulumi.set(__self__, "disk_device_mappings", disk_device_mappings)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the architecture of the system disk after you specify a data disk snapshot as the data source of the system disk for creating an image. Valid values: `i386` , Default is `x86_64`.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the image. The length is 2 to 256 English or Chinese characters, and cannot begin with http: // and https: //.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskDeviceMappings")
    def disk_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]]]:
        """
        Description of the system with disks and snapshots under the image.
        """
        return pulumi.get(self, "disk_device_mappings")

    @disk_device_mappings.setter
    def disk_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageImportDiskDeviceMappingArgs']]]]):
        pulumi.set(self, "disk_device_mappings", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[str]]:
        """
        The image name. The length is 2 ~ 128 English or Chinese characters. Must start with a english letter or Chinese, and cannot start with http: // and https: //. Can contain numbers, colons (:), underscores (_), or hyphens (-).
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the license used to activate the operating system after the image is imported. Default value: `Auto`. Valid values: `Auto`,`Aliyun`,`BYOL`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[str]]:
        """
        Operating system platform type. Valid values: `windows`, Default is `linux`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_type", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        The operating system distribution. Default value: Others Linux. 
        More valid values refer to [ImportImage OpenAPI](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/importimage).
        **NOTE**: It's default value is Ubuntu before version 1.197.0.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)


class ImageImport(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architecture: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ImageImportDiskDeviceMappingArgs']]]]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Import a copy of your local on-premise file to ECS, and appear as a custom replacement in the corresponding domain.

        > **NOTE:** You must upload the image file to the object storage OSS in advance.

        > **NOTE:** The region where the image is imported must be the same region as the OSS bucket where the image file is uploaded.

        > **NOTE:** Available in 1.69.0+.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        this = alicloud.ecs.ImageImport("this",
            architecture="x86_64",
            description="test import image",
            disk_device_mappings=[alicloud.ecs.ImageImportDiskDeviceMappingArgs(
                disk_image_size=5,
                oss_bucket="testimportimage",
                oss_object="root.img",
            )],
            image_name="test-import-image",
            license_type="Auto",
            os_type="linux",
            platform="Ubuntu")
        ```
        ## Attributes Reference0

         The following attributes are exported:

        * `id` - ID of the image.

        ## Import

        image can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/imageImport:ImageImport default m-uf66871ape***yg1q***
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] architecture: Specifies the architecture of the system disk after you specify a data disk snapshot as the data source of the system disk for creating an image. Valid values: `i386` , Default is `x86_64`.
        :param pulumi.Input[str] description: Description of the image. The length is 2 to 256 English or Chinese characters, and cannot begin with http: // and https: //.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ImageImportDiskDeviceMappingArgs']]]] disk_device_mappings: Description of the system with disks and snapshots under the image.
        :param pulumi.Input[str] image_name: The image name. The length is 2 ~ 128 English or Chinese characters. Must start with a english letter or Chinese, and cannot start with http: // and https: //. Can contain numbers, colons (:), underscores (_), or hyphens (-).
        :param pulumi.Input[str] license_type: The type of the license used to activate the operating system after the image is imported. Default value: `Auto`. Valid values: `Auto`,`Aliyun`,`BYOL`.
        :param pulumi.Input[str] os_type: Operating system platform type. Valid values: `windows`, Default is `linux`.
        :param pulumi.Input[str] platform: The operating system distribution. Default value: Others Linux. 
               More valid values refer to [ImportImage OpenAPI](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/importimage).
               **NOTE**: It's default value is Ubuntu before version 1.197.0.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImageImportArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Import a copy of your local on-premise file to ECS, and appear as a custom replacement in the corresponding domain.

        > **NOTE:** You must upload the image file to the object storage OSS in advance.

        > **NOTE:** The region where the image is imported must be the same region as the OSS bucket where the image file is uploaded.

        > **NOTE:** Available in 1.69.0+.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        this = alicloud.ecs.ImageImport("this",
            architecture="x86_64",
            description="test import image",
            disk_device_mappings=[alicloud.ecs.ImageImportDiskDeviceMappingArgs(
                disk_image_size=5,
                oss_bucket="testimportimage",
                oss_object="root.img",
            )],
            image_name="test-import-image",
            license_type="Auto",
            os_type="linux",
            platform="Ubuntu")
        ```
        ## Attributes Reference0

         The following attributes are exported:

        * `id` - ID of the image.

        ## Import

        image can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/imageImport:ImageImport default m-uf66871ape***yg1q***
        ```

        :param str resource_name: The name of the resource.
        :param ImageImportArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageImportArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 architecture: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ImageImportDiskDeviceMappingArgs']]]]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 os_type: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageImportArgs.__new__(ImageImportArgs)

            __props__.__dict__["architecture"] = architecture
            __props__.__dict__["description"] = description
            if disk_device_mappings is None and not opts.urn:
                raise TypeError("Missing required property 'disk_device_mappings'")
            __props__.__dict__["disk_device_mappings"] = disk_device_mappings
            __props__.__dict__["image_name"] = image_name
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["platform"] = platform
        super(ImageImport, __self__).__init__(
            'alicloud:ecs/imageImport:ImageImport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            architecture: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disk_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ImageImportDiskDeviceMappingArgs']]]]] = None,
            image_name: Optional[pulumi.Input[str]] = None,
            license_type: Optional[pulumi.Input[str]] = None,
            os_type: Optional[pulumi.Input[str]] = None,
            platform: Optional[pulumi.Input[str]] = None) -> 'ImageImport':
        """
        Get an existing ImageImport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] architecture: Specifies the architecture of the system disk after you specify a data disk snapshot as the data source of the system disk for creating an image. Valid values: `i386` , Default is `x86_64`.
        :param pulumi.Input[str] description: Description of the image. The length is 2 to 256 English or Chinese characters, and cannot begin with http: // and https: //.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ImageImportDiskDeviceMappingArgs']]]] disk_device_mappings: Description of the system with disks and snapshots under the image.
        :param pulumi.Input[str] image_name: The image name. The length is 2 ~ 128 English or Chinese characters. Must start with a english letter or Chinese, and cannot start with http: // and https: //. Can contain numbers, colons (:), underscores (_), or hyphens (-).
        :param pulumi.Input[str] license_type: The type of the license used to activate the operating system after the image is imported. Default value: `Auto`. Valid values: `Auto`,`Aliyun`,`BYOL`.
        :param pulumi.Input[str] os_type: Operating system platform type. Valid values: `windows`, Default is `linux`.
        :param pulumi.Input[str] platform: The operating system distribution. Default value: Others Linux. 
               More valid values refer to [ImportImage OpenAPI](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/importimage).
               **NOTE**: It's default value is Ubuntu before version 1.197.0.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageImportState.__new__(_ImageImportState)

        __props__.__dict__["architecture"] = architecture
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_device_mappings"] = disk_device_mappings
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["platform"] = platform
        return ImageImport(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the architecture of the system disk after you specify a data disk snapshot as the data source of the system disk for creating an image. Valid values: `i386` , Default is `x86_64`.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the image. The length is 2 to 256 English or Chinese characters, and cannot begin with http: // and https: //.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskDeviceMappings")
    def disk_device_mappings(self) -> pulumi.Output[Sequence['outputs.ImageImportDiskDeviceMapping']]:
        """
        Description of the system with disks and snapshots under the image.
        """
        return pulumi.get(self, "disk_device_mappings")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[Optional[str]]:
        """
        The image name. The length is 2 ~ 128 English or Chinese characters. Must start with a english letter or Chinese, and cannot start with http: // and https: //. Can contain numbers, colons (:), underscores (_), or hyphens (-).
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of the license used to activate the operating system after the image is imported. Default value: `Auto`. Valid values: `Auto`,`Aliyun`,`BYOL`.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[Optional[str]]:
        """
        Operating system platform type. Valid values: `windows`, Default is `linux`.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[str]:
        """
        The operating system distribution. Default value: Others Linux. 
        More valid values refer to [ImportImage OpenAPI](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/importimage).
        **NOTE**: It's default value is Ubuntu before version 1.197.0.
        """
        return pulumi.get(self, "platform")

