# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LaunchTemplateArgs', 'LaunchTemplate']

@pulumi.input_type
class LaunchTemplateArgs:
    def __init__(__self__, *,
                 auto_release_time: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_vm_os_config: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_owner_alias: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 io_optimized: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input['LaunchTemplateNetworkInterfacesArgs']] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 ram_role_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_duration: Optional[pulumi.Input[str]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk: Optional[pulumi.Input['LaunchTemplateSystemDiskArgs']] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_description: Optional[pulumi.Input[str]] = None,
                 system_disk_name: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 template_resource_group_id: Optional[pulumi.Input[str]] = None,
                 template_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 userdata: Optional[pulumi.Input[str]] = None,
                 version_description: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LaunchTemplate resource.
        :param pulumi.Input[str] auto_release_time: Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]] data_disks: The list of data disks created with instance.
        :param pulumi.Input[str] description: The description of the data disk.
        :param pulumi.Input[str] host_name: Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length. It can contain A-Z, a-z, numbers, periods (.), and hyphens (-). It cannot only contain numbers. For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
        :param pulumi.Input[str] image_id: Image ID.
        :param pulumi.Input[str] instance_charge_type: Billing methods. Optional values:
               - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
               - PostPaid: Pay-As-You-Go.
               
               Default value: PostPaid.
        :param pulumi.Input[str] instance_name: The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[str] instance_type: Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
        :param pulumi.Input[str] internet_charge_type: Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
        :param pulumi.Input[int] internet_max_bandwidth_in: The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
        :param pulumi.Input[int] internet_max_bandwidth_out: Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
        :param pulumi.Input[str] io_optimized: Whether it is an I/O-optimized instance or not. Optional values:
               - none
               - optimized
        :param pulumi.Input[str] key_pair_name: The name of the key pair.
               - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
               - The password logon method for Linux instances is set to forbidden upon initialization.
        :param pulumi.Input[str] name: The name of the data disk.
        :param pulumi.Input['LaunchTemplateNetworkInterfacesArgs'] network_interfaces: The list of network interfaces created with instance.
        :param pulumi.Input[str] network_type: Network type of the instance. Value options: `classic` | `vpc`.
        :param pulumi.Input[str] ram_role_name: The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
        :param pulumi.Input[str] security_enhancement_strategy: Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
        :param pulumi.Input[str] security_group_id: The security group ID must be one in the same VPC.
        :param pulumi.Input[float] spot_price_limit: Sets the maximum hourly instance price. Supports up to three decimal places.
        :param pulumi.Input[str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
               - NoSpot: Normal Pay-As-You-Go instance.
               - SpotWithPriceLimit: Sets the maximum price for a spot instance.
               - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
        :param pulumi.Input[str] system_disk_category: The category of the system disk. System disk type. Optional values:
               - cloud: Basic cloud disk.
               - cloud_efficiency: Ultra cloud disk.
               - cloud_ssd: SSD cloud Disks.
               - ephemeral_ssd: local SSD Disks
               - cloud_essd: ESSD cloud Disks.
        :param pulumi.Input[str] system_disk_description: System disk description. It cannot begin with http:// or https://.
        :param pulumi.Input[str] system_disk_name: System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[int] system_disk_size: Size of the system disk, measured in GB. Value range: [20, 500].
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] userdata: User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
        :param pulumi.Input[str] vswitch_id: The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        if auto_release_time is not None:
            pulumi.set(__self__, "auto_release_time", auto_release_time)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_vm_os_config is not None:
            pulumi.set(__self__, "enable_vm_os_config", enable_vm_os_config)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_owner_alias is not None:
            pulumi.set(__self__, "image_owner_alias", image_owner_alias)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_in is not None:
            pulumi.set(__self__, "internet_max_bandwidth_in", internet_max_bandwidth_in)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if io_optimized is not None:
            pulumi.set(__self__, "io_optimized", io_optimized)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_duration is not None:
            pulumi.set(__self__, "spot_duration", spot_duration)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if system_disk is not None:
            pulumi.set(__self__, "system_disk", system_disk)
        if system_disk_category is not None:
            warnings.warn("""Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_category is deprecated: Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_description is not None:
            warnings.warn("""Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_description is deprecated: Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_description is not None:
            pulumi.set(__self__, "system_disk_description", system_disk_description)
        if system_disk_name is not None:
            warnings.warn("""Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_name is deprecated: Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_name is not None:
            pulumi.set(__self__, "system_disk_name", system_disk_name)
        if system_disk_size is not None:
            warnings.warn("""Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_size is deprecated: Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_resource_group_id is not None:
            pulumi.set(__self__, "template_resource_group_id", template_resource_group_id)
        if template_tags is not None:
            pulumi.set(__self__, "template_tags", template_tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if userdata is not None:
            warnings.warn("""Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""", DeprecationWarning)
            pulumi.log.warn("""userdata is deprecated: Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""")
        if userdata is not None:
            pulumi.set(__self__, "userdata", userdata)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> Optional[pulumi.Input[str]]:
        """
        Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
        """
        return pulumi.get(self, "auto_release_time")

    @auto_release_time.setter
    def auto_release_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_release_time", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]]]:
        """
        The list of data disks created with instance.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_set_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableVmOsConfig")
    def enable_vm_os_config(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enable_vm_os_config")

    @enable_vm_os_config.setter
    def enable_vm_os_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vm_os_config", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length. It can contain A-Z, a-z, numbers, periods (.), and hyphens (-). It cannot only contain numbers. For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Image ID.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "image_owner_alias")

    @image_owner_alias.setter
    def image_owner_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_owner_alias", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Billing methods. Optional values:
        - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
        - PostPaid: Pay-As-You-Go.

        Default value: PostPaid.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @internet_max_bandwidth_in.setter
    def internet_max_bandwidth_in(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_in", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @property
    @pulumi.getter(name="ioOptimized")
    def io_optimized(self) -> Optional[pulumi.Input[str]]:
        """
        Whether it is an I/O-optimized instance or not. Optional values:
        - none
        - optimized
        """
        return pulumi.get(self, "io_optimized")

    @io_optimized.setter
    def io_optimized(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "io_optimized", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the key pair.
        - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
        - The password logon method for Linux instances is set to forbidden upon initialization.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the data disk.
        """
        warnings.warn("""Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""", DeprecationWarning)
        pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""")

        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input['LaunchTemplateNetworkInterfacesArgs']]:
        """
        The list of network interfaces created with instance.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input['LaunchTemplateNetworkInterfacesArgs']]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[str]]:
        """
        Network type of the instance. Value options: `classic` | `vpc`.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_inherit", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ram_role_name", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The security group ID must be one in the same VPC.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "spot_duration")

    @spot_duration.setter
    def spot_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_duration", value)

    @property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[float]]:
        """
        Sets the maximum hourly instance price. Supports up to three decimal places.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "spot_price_limit", value)

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
        - NoSpot: Normal Pay-As-You-Go instance.
        - SpotWithPriceLimit: Sets the maximum price for a spot instance.
        - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_strategy", value)

    @property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> Optional[pulumi.Input['LaunchTemplateSystemDiskArgs']]:
        return pulumi.get(self, "system_disk")

    @system_disk.setter
    def system_disk(self, value: Optional[pulumi.Input['LaunchTemplateSystemDiskArgs']]):
        pulumi.set(self, "system_disk", value)

    @property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The category of the system disk. System disk type. Optional values:
        - cloud: Basic cloud disk.
        - cloud_efficiency: Ultra cloud disk.
        - cloud_ssd: SSD cloud Disks.
        - ephemeral_ssd: local SSD Disks
        - cloud_essd: ESSD cloud Disks.
        """
        warnings.warn("""Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
        pulumi.log.warn("""system_disk_category is deprecated: Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")

        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_category", value)

    @property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> Optional[pulumi.Input[str]]:
        """
        System disk description. It cannot begin with http:// or https://.
        """
        warnings.warn("""Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
        pulumi.log.warn("""system_disk_description is deprecated: Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")

        return pulumi.get(self, "system_disk_description")

    @system_disk_description.setter
    def system_disk_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_description", value)

    @property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> Optional[pulumi.Input[str]]:
        """
        System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        warnings.warn("""Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
        pulumi.log.warn("""system_disk_name is deprecated: Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")

        return pulumi.get(self, "system_disk_name")

    @system_disk_name.setter
    def system_disk_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_name", value)

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the system disk, measured in GB. Value range: [20, 500].
        """
        warnings.warn("""Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
        pulumi.log.warn("""system_disk_size is deprecated: Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")

        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "system_disk_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateResourceGroupId")
    def template_resource_group_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "template_resource_group_id")

    @template_resource_group_id.setter
    def template_resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_resource_group_id", value)

    @property
    @pulumi.getter(name="templateTags")
    def template_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        return pulumi.get(self, "template_tags")

    @template_tags.setter
    def template_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "template_tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def userdata(self) -> Optional[pulumi.Input[str]]:
        """
        User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
        """
        warnings.warn("""Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""", DeprecationWarning)
        pulumi.log.warn("""userdata is deprecated: Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""")

        return pulumi.get(self, "userdata")

    @userdata.setter
    def userdata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "userdata", value)

    @property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_description", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class _LaunchTemplateState:
    def __init__(__self__, *,
                 auto_release_time: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_vm_os_config: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_owner_alias: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 io_optimized: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input['LaunchTemplateNetworkInterfacesArgs']] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 ram_role_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_duration: Optional[pulumi.Input[str]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk: Optional[pulumi.Input['LaunchTemplateSystemDiskArgs']] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_description: Optional[pulumi.Input[str]] = None,
                 system_disk_name: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 template_resource_group_id: Optional[pulumi.Input[str]] = None,
                 template_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 userdata: Optional[pulumi.Input[str]] = None,
                 version_description: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LaunchTemplate resources.
        :param pulumi.Input[str] auto_release_time: Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
        :param pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]] data_disks: The list of data disks created with instance.
        :param pulumi.Input[str] description: The description of the data disk.
        :param pulumi.Input[str] host_name: Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length. It can contain A-Z, a-z, numbers, periods (.), and hyphens (-). It cannot only contain numbers. For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
        :param pulumi.Input[str] image_id: Image ID.
        :param pulumi.Input[str] instance_charge_type: Billing methods. Optional values:
               - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
               - PostPaid: Pay-As-You-Go.
               
               Default value: PostPaid.
        :param pulumi.Input[str] instance_name: The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[str] instance_type: Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
        :param pulumi.Input[str] internet_charge_type: Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
        :param pulumi.Input[int] internet_max_bandwidth_in: The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
        :param pulumi.Input[int] internet_max_bandwidth_out: Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
        :param pulumi.Input[str] io_optimized: Whether it is an I/O-optimized instance or not. Optional values:
               - none
               - optimized
        :param pulumi.Input[str] key_pair_name: The name of the key pair.
               - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
               - The password logon method for Linux instances is set to forbidden upon initialization.
        :param pulumi.Input[str] name: The name of the data disk.
        :param pulumi.Input['LaunchTemplateNetworkInterfacesArgs'] network_interfaces: The list of network interfaces created with instance.
        :param pulumi.Input[str] network_type: Network type of the instance. Value options: `classic` | `vpc`.
        :param pulumi.Input[str] ram_role_name: The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
        :param pulumi.Input[str] security_enhancement_strategy: Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
        :param pulumi.Input[str] security_group_id: The security group ID must be one in the same VPC.
        :param pulumi.Input[float] spot_price_limit: Sets the maximum hourly instance price. Supports up to three decimal places.
        :param pulumi.Input[str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
               - NoSpot: Normal Pay-As-You-Go instance.
               - SpotWithPriceLimit: Sets the maximum price for a spot instance.
               - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
        :param pulumi.Input[str] system_disk_category: The category of the system disk. System disk type. Optional values:
               - cloud: Basic cloud disk.
               - cloud_efficiency: Ultra cloud disk.
               - cloud_ssd: SSD cloud Disks.
               - ephemeral_ssd: local SSD Disks
               - cloud_essd: ESSD cloud Disks.
        :param pulumi.Input[str] system_disk_description: System disk description. It cannot begin with http:// or https://.
        :param pulumi.Input[str] system_disk_name: System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[int] system_disk_size: Size of the system disk, measured in GB. Value range: [20, 500].
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] userdata: User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
        :param pulumi.Input[str] vswitch_id: The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        if auto_release_time is not None:
            pulumi.set(__self__, "auto_release_time", auto_release_time)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if deployment_set_id is not None:
            pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_vm_os_config is not None:
            pulumi.set(__self__, "enable_vm_os_config", enable_vm_os_config)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_owner_alias is not None:
            pulumi.set(__self__, "image_owner_alias", image_owner_alias)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_in is not None:
            pulumi.set(__self__, "internet_max_bandwidth_in", internet_max_bandwidth_in)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if io_optimized is not None:
            pulumi.set(__self__, "io_optimized", io_optimized)
        if key_pair_name is not None:
            pulumi.set(__self__, "key_pair_name", key_pair_name)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)
        if name is not None:
            warnings.warn("""Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_enhancement_strategy is not None:
            pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_duration is not None:
            pulumi.set(__self__, "spot_duration", spot_duration)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if system_disk is not None:
            pulumi.set(__self__, "system_disk", system_disk)
        if system_disk_category is not None:
            warnings.warn("""Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_category is deprecated: Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_description is not None:
            warnings.warn("""Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_description is deprecated: Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_description is not None:
            pulumi.set(__self__, "system_disk_description", system_disk_description)
        if system_disk_name is not None:
            warnings.warn("""Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_name is deprecated: Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_name is not None:
            pulumi.set(__self__, "system_disk_name", system_disk_name)
        if system_disk_size is not None:
            warnings.warn("""Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
            pulumi.log.warn("""system_disk_size is deprecated: Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_resource_group_id is not None:
            pulumi.set(__self__, "template_resource_group_id", template_resource_group_id)
        if template_tags is not None:
            pulumi.set(__self__, "template_tags", template_tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if userdata is not None:
            warnings.warn("""Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""", DeprecationWarning)
            pulumi.log.warn("""userdata is deprecated: Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""")
        if userdata is not None:
            pulumi.set(__self__, "userdata", userdata)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> Optional[pulumi.Input[str]]:
        """
        Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
        """
        return pulumi.get(self, "auto_release_time")

    @auto_release_time.setter
    def auto_release_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_release_time", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]]]:
        """
        The list of data disks created with instance.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LaunchTemplateDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "deployment_set_id")

    @deployment_set_id.setter
    def deployment_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_set_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableVmOsConfig")
    def enable_vm_os_config(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "enable_vm_os_config")

    @enable_vm_os_config.setter
    def enable_vm_os_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_vm_os_config", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length. It can contain A-Z, a-z, numbers, periods (.), and hyphens (-). It cannot only contain numbers. For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Image ID.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "image_owner_alias")

    @image_owner_alias.setter
    def image_owner_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_owner_alias", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Billing methods. Optional values:
        - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
        - PostPaid: Pay-As-You-Go.

        Default value: PostPaid.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @internet_max_bandwidth_in.setter
    def internet_max_bandwidth_in(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_in", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @property
    @pulumi.getter(name="ioOptimized")
    def io_optimized(self) -> Optional[pulumi.Input[str]]:
        """
        Whether it is an I/O-optimized instance or not. Optional values:
        - none
        - optimized
        """
        return pulumi.get(self, "io_optimized")

    @io_optimized.setter
    def io_optimized(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "io_optimized", value)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the key pair.
        - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
        - The password logon method for Linux instances is set to forbidden upon initialization.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "launch_template_name")

    @launch_template_name.setter
    def launch_template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the data disk.
        """
        warnings.warn("""Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""", DeprecationWarning)
        pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""")

        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input['LaunchTemplateNetworkInterfacesArgs']]:
        """
        The list of network interfaces created with instance.
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input['LaunchTemplateNetworkInterfacesArgs']]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[str]]:
        """
        Network type of the instance. Value options: `classic` | `vpc`.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_type", value)

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_inherit", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ram_role_name", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @security_enhancement_strategy.setter
    def security_enhancement_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_enhancement_strategy", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The security group ID must be one in the same VPC.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "spot_duration")

    @spot_duration.setter
    def spot_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_duration", value)

    @property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[float]]:
        """
        Sets the maximum hourly instance price. Supports up to three decimal places.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "spot_price_limit", value)

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
        - NoSpot: Normal Pay-As-You-Go instance.
        - SpotWithPriceLimit: Sets the maximum price for a spot instance.
        - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_strategy", value)

    @property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> Optional[pulumi.Input['LaunchTemplateSystemDiskArgs']]:
        return pulumi.get(self, "system_disk")

    @system_disk.setter
    def system_disk(self, value: Optional[pulumi.Input['LaunchTemplateSystemDiskArgs']]):
        pulumi.set(self, "system_disk", value)

    @property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        The category of the system disk. System disk type. Optional values:
        - cloud: Basic cloud disk.
        - cloud_efficiency: Ultra cloud disk.
        - cloud_ssd: SSD cloud Disks.
        - ephemeral_ssd: local SSD Disks
        - cloud_essd: ESSD cloud Disks.
        """
        warnings.warn("""Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
        pulumi.log.warn("""system_disk_category is deprecated: Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")

        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_category", value)

    @property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> Optional[pulumi.Input[str]]:
        """
        System disk description. It cannot begin with http:// or https://.
        """
        warnings.warn("""Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
        pulumi.log.warn("""system_disk_description is deprecated: Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")

        return pulumi.get(self, "system_disk_description")

    @system_disk_description.setter
    def system_disk_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_description", value)

    @property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> Optional[pulumi.Input[str]]:
        """
        System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        warnings.warn("""Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
        pulumi.log.warn("""system_disk_name is deprecated: Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")

        return pulumi.get(self, "system_disk_name")

    @system_disk_name.setter
    def system_disk_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_name", value)

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the system disk, measured in GB. Value range: [20, 500].
        """
        warnings.warn("""Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
        pulumi.log.warn("""system_disk_size is deprecated: Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")

        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "system_disk_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="templateResourceGroupId")
    def template_resource_group_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "template_resource_group_id")

    @template_resource_group_id.setter
    def template_resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_resource_group_id", value)

    @property
    @pulumi.getter(name="templateTags")
    def template_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        return pulumi.get(self, "template_tags")

    @template_tags.setter
    def template_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "template_tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def userdata(self) -> Optional[pulumi.Input[str]]:
        """
        User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
        """
        warnings.warn("""Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""", DeprecationWarning)
        pulumi.log.warn("""userdata is deprecated: Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""")

        return pulumi.get(self, "userdata")

    @userdata.setter
    def userdata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "userdata", value)

    @property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_description", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class LaunchTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_release_time: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateDataDiskArgs']]]]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_vm_os_config: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_owner_alias: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 io_optimized: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[pulumi.InputType['LaunchTemplateNetworkInterfacesArgs']]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 ram_role_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_duration: Optional[pulumi.Input[str]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk: Optional[pulumi.Input[pulumi.InputType['LaunchTemplateSystemDiskArgs']]] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_description: Optional[pulumi.Input[str]] = None,
                 system_disk_name: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 template_resource_group_id: Optional[pulumi.Input[str]] = None,
                 template_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 userdata: Optional[pulumi.Input[str]] = None,
                 version_description: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an ECS Launch Template resource.

        For information about Launch Template and how to use it, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html).

        > **DEPRECATED:**  This resource  has been deprecated from version `1.120.0`. Please use new resource alicloud_ecs_launch_template.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        images = alicloud.ecs.get_images(owners="system")
        instances = alicloud.ecs.get_instances()
        template = alicloud.ecs.LaunchTemplate("template",
            description="test1",
            image_id=images.images[0].id,
            host_name="tf-test-host",
            instance_charge_type="PrePaid",
            instance_name="tf-instance-name",
            instance_type=instances.instances[0].instance_type,
            internet_charge_type="PayByBandwidth",
            internet_max_bandwidth_in=5,
            internet_max_bandwidth_out=0,
            io_optimized="none",
            key_pair_name="test-key-pair",
            ram_role_name="xxxxx",
            network_type="vpc",
            security_enhancement_strategy="Active",
            spot_price_limit=5,
            spot_strategy="SpotWithPriceLimit",
            security_group_id="sg-zxcvj0lasdf102350asdf9a",
            system_disk_category="cloud_ssd",
            system_disk_description="test disk",
            system_disk_name="hello",
            system_disk_size=40,
            resource_group_id="rg-zkdfjahg9zxncv0",
            userdata="xxxxxxxxxxxxxx",
            vswitch_id="sw-ljkngaksdjfj0nnasdf",
            vpc_id="vpc-asdfnbg0as8dfk1nb2",
            zone_id="beijing-a",
            tags={
                "tag1": "hello",
                "tag2": "world",
            },
            network_interfaces=alicloud.ecs.LaunchTemplateNetworkInterfacesArgs(
                name="eth0",
                description="hello1",
                primary_ip="10.0.0.2",
                security_group_id="xxxx",
                vswitch_id="xxxxxxx",
            ),
            data_disks=[
                alicloud.ecs.LaunchTemplateDataDiskArgs(
                    name="disk1",
                    description="test1",
                ),
                alicloud.ecs.LaunchTemplateDataDiskArgs(
                    name="disk2",
                    description="test2",
                ),
            ])
        ```

        ## Import

        Launch Template can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/launchTemplate:LaunchTemplate lt lt-abc1234567890000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_release_time: Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateDataDiskArgs']]]] data_disks: The list of data disks created with instance.
        :param pulumi.Input[str] description: The description of the data disk.
        :param pulumi.Input[str] host_name: Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length. It can contain A-Z, a-z, numbers, periods (.), and hyphens (-). It cannot only contain numbers. For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
        :param pulumi.Input[str] image_id: Image ID.
        :param pulumi.Input[str] instance_charge_type: Billing methods. Optional values:
               - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
               - PostPaid: Pay-As-You-Go.
               
               Default value: PostPaid.
        :param pulumi.Input[str] instance_name: The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[str] instance_type: Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
        :param pulumi.Input[str] internet_charge_type: Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
        :param pulumi.Input[int] internet_max_bandwidth_in: The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
        :param pulumi.Input[int] internet_max_bandwidth_out: Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
        :param pulumi.Input[str] io_optimized: Whether it is an I/O-optimized instance or not. Optional values:
               - none
               - optimized
        :param pulumi.Input[str] key_pair_name: The name of the key pair.
               - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
               - The password logon method for Linux instances is set to forbidden upon initialization.
        :param pulumi.Input[str] name: The name of the data disk.
        :param pulumi.Input[pulumi.InputType['LaunchTemplateNetworkInterfacesArgs']] network_interfaces: The list of network interfaces created with instance.
        :param pulumi.Input[str] network_type: Network type of the instance. Value options: `classic` | `vpc`.
        :param pulumi.Input[str] ram_role_name: The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
        :param pulumi.Input[str] security_enhancement_strategy: Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
        :param pulumi.Input[str] security_group_id: The security group ID must be one in the same VPC.
        :param pulumi.Input[float] spot_price_limit: Sets the maximum hourly instance price. Supports up to three decimal places.
        :param pulumi.Input[str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
               - NoSpot: Normal Pay-As-You-Go instance.
               - SpotWithPriceLimit: Sets the maximum price for a spot instance.
               - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
        :param pulumi.Input[str] system_disk_category: The category of the system disk. System disk type. Optional values:
               - cloud: Basic cloud disk.
               - cloud_efficiency: Ultra cloud disk.
               - cloud_ssd: SSD cloud Disks.
               - ephemeral_ssd: local SSD Disks
               - cloud_essd: ESSD cloud Disks.
        :param pulumi.Input[str] system_disk_description: System disk description. It cannot begin with http:// or https://.
        :param pulumi.Input[str] system_disk_name: System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[int] system_disk_size: Size of the system disk, measured in GB. Value range: [20, 500].
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] userdata: User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
        :param pulumi.Input[str] vswitch_id: The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LaunchTemplateArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an ECS Launch Template resource.

        For information about Launch Template and how to use it, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html).

        > **DEPRECATED:**  This resource  has been deprecated from version `1.120.0`. Please use new resource alicloud_ecs_launch_template.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        images = alicloud.ecs.get_images(owners="system")
        instances = alicloud.ecs.get_instances()
        template = alicloud.ecs.LaunchTemplate("template",
            description="test1",
            image_id=images.images[0].id,
            host_name="tf-test-host",
            instance_charge_type="PrePaid",
            instance_name="tf-instance-name",
            instance_type=instances.instances[0].instance_type,
            internet_charge_type="PayByBandwidth",
            internet_max_bandwidth_in=5,
            internet_max_bandwidth_out=0,
            io_optimized="none",
            key_pair_name="test-key-pair",
            ram_role_name="xxxxx",
            network_type="vpc",
            security_enhancement_strategy="Active",
            spot_price_limit=5,
            spot_strategy="SpotWithPriceLimit",
            security_group_id="sg-zxcvj0lasdf102350asdf9a",
            system_disk_category="cloud_ssd",
            system_disk_description="test disk",
            system_disk_name="hello",
            system_disk_size=40,
            resource_group_id="rg-zkdfjahg9zxncv0",
            userdata="xxxxxxxxxxxxxx",
            vswitch_id="sw-ljkngaksdjfj0nnasdf",
            vpc_id="vpc-asdfnbg0as8dfk1nb2",
            zone_id="beijing-a",
            tags={
                "tag1": "hello",
                "tag2": "world",
            },
            network_interfaces=alicloud.ecs.LaunchTemplateNetworkInterfacesArgs(
                name="eth0",
                description="hello1",
                primary_ip="10.0.0.2",
                security_group_id="xxxx",
                vswitch_id="xxxxxxx",
            ),
            data_disks=[
                alicloud.ecs.LaunchTemplateDataDiskArgs(
                    name="disk1",
                    description="test1",
                ),
                alicloud.ecs.LaunchTemplateDataDiskArgs(
                    name="disk2",
                    description="test2",
                ),
            ])
        ```

        ## Import

        Launch Template can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ecs/launchTemplate:LaunchTemplate lt lt-abc1234567890000
        ```

        :param str resource_name: The name of the resource.
        :param LaunchTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LaunchTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_release_time: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateDataDiskArgs']]]]] = None,
                 deployment_set_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_vm_os_config: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_owner_alias: Optional[pulumi.Input[str]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 io_optimized: Optional[pulumi.Input[str]] = None,
                 key_pair_name: Optional[pulumi.Input[str]] = None,
                 launch_template_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[pulumi.InputType['LaunchTemplateNetworkInterfacesArgs']]] = None,
                 network_type: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 ram_role_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_duration: Optional[pulumi.Input[str]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk: Optional[pulumi.Input[pulumi.InputType['LaunchTemplateSystemDiskArgs']]] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_description: Optional[pulumi.Input[str]] = None,
                 system_disk_name: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 template_resource_group_id: Optional[pulumi.Input[str]] = None,
                 template_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 userdata: Optional[pulumi.Input[str]] = None,
                 version_description: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LaunchTemplateArgs.__new__(LaunchTemplateArgs)

            __props__.__dict__["auto_release_time"] = auto_release_time
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["deployment_set_id"] = deployment_set_id
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_vm_os_config"] = enable_vm_os_config
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["image_owner_alias"] = image_owner_alias
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["internet_max_bandwidth_in"] = internet_max_bandwidth_in
            __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
            __props__.__dict__["io_optimized"] = io_optimized
            __props__.__dict__["key_pair_name"] = key_pair_name
            __props__.__dict__["launch_template_name"] = launch_template_name
            __props__.__dict__["name"] = name
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["password_inherit"] = password_inherit
            __props__.__dict__["period"] = period
            __props__.__dict__["private_ip_address"] = private_ip_address
            __props__.__dict__["ram_role_name"] = ram_role_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["spot_duration"] = spot_duration
            __props__.__dict__["spot_price_limit"] = spot_price_limit
            __props__.__dict__["spot_strategy"] = spot_strategy
            __props__.__dict__["system_disk"] = system_disk
            __props__.__dict__["system_disk_category"] = system_disk_category
            __props__.__dict__["system_disk_description"] = system_disk_description
            __props__.__dict__["system_disk_name"] = system_disk_name
            __props__.__dict__["system_disk_size"] = system_disk_size
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_resource_group_id"] = template_resource_group_id
            __props__.__dict__["template_tags"] = template_tags
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["userdata"] = userdata
            __props__.__dict__["version_description"] = version_description
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_id"] = zone_id
        super(LaunchTemplate, __self__).__init__(
            'alicloud:ecs/launchTemplate:LaunchTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_release_time: Optional[pulumi.Input[str]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateDataDiskArgs']]]]] = None,
            deployment_set_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enable_vm_os_config: Optional[pulumi.Input[bool]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            image_owner_alias: Optional[pulumi.Input[str]] = None,
            instance_charge_type: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            internet_charge_type: Optional[pulumi.Input[str]] = None,
            internet_max_bandwidth_in: Optional[pulumi.Input[int]] = None,
            internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
            io_optimized: Optional[pulumi.Input[str]] = None,
            key_pair_name: Optional[pulumi.Input[str]] = None,
            launch_template_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_interfaces: Optional[pulumi.Input[pulumi.InputType['LaunchTemplateNetworkInterfacesArgs']]] = None,
            network_type: Optional[pulumi.Input[str]] = None,
            password_inherit: Optional[pulumi.Input[bool]] = None,
            period: Optional[pulumi.Input[int]] = None,
            private_ip_address: Optional[pulumi.Input[str]] = None,
            ram_role_name: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            security_enhancement_strategy: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            spot_duration: Optional[pulumi.Input[str]] = None,
            spot_price_limit: Optional[pulumi.Input[float]] = None,
            spot_strategy: Optional[pulumi.Input[str]] = None,
            system_disk: Optional[pulumi.Input[pulumi.InputType['LaunchTemplateSystemDiskArgs']]] = None,
            system_disk_category: Optional[pulumi.Input[str]] = None,
            system_disk_description: Optional[pulumi.Input[str]] = None,
            system_disk_name: Optional[pulumi.Input[str]] = None,
            system_disk_size: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            template_resource_group_id: Optional[pulumi.Input[str]] = None,
            template_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            userdata: Optional[pulumi.Input[str]] = None,
            version_description: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'LaunchTemplate':
        """
        Get an existing LaunchTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_release_time: Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LaunchTemplateDataDiskArgs']]]] data_disks: The list of data disks created with instance.
        :param pulumi.Input[str] description: The description of the data disk.
        :param pulumi.Input[str] host_name: Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length. It can contain A-Z, a-z, numbers, periods (.), and hyphens (-). It cannot only contain numbers. For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
        :param pulumi.Input[str] image_id: Image ID.
        :param pulumi.Input[str] instance_charge_type: Billing methods. Optional values:
               - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
               - PostPaid: Pay-As-You-Go.
               
               Default value: PostPaid.
        :param pulumi.Input[str] instance_name: The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[str] instance_type: Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
        :param pulumi.Input[str] internet_charge_type: Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
        :param pulumi.Input[int] internet_max_bandwidth_in: The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
        :param pulumi.Input[int] internet_max_bandwidth_out: Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
        :param pulumi.Input[str] io_optimized: Whether it is an I/O-optimized instance or not. Optional values:
               - none
               - optimized
        :param pulumi.Input[str] key_pair_name: The name of the key pair.
               - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
               - The password logon method for Linux instances is set to forbidden upon initialization.
        :param pulumi.Input[str] name: The name of the data disk.
        :param pulumi.Input[pulumi.InputType['LaunchTemplateNetworkInterfacesArgs']] network_interfaces: The list of network interfaces created with instance.
        :param pulumi.Input[str] network_type: Network type of the instance. Value options: `classic` | `vpc`.
        :param pulumi.Input[str] ram_role_name: The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
        :param pulumi.Input[str] security_enhancement_strategy: Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
        :param pulumi.Input[str] security_group_id: The security group ID must be one in the same VPC.
        :param pulumi.Input[float] spot_price_limit: Sets the maximum hourly instance price. Supports up to three decimal places.
        :param pulumi.Input[str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
               - NoSpot: Normal Pay-As-You-Go instance.
               - SpotWithPriceLimit: Sets the maximum price for a spot instance.
               - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
        :param pulumi.Input[str] system_disk_category: The category of the system disk. System disk type. Optional values:
               - cloud: Basic cloud disk.
               - cloud_efficiency: Ultra cloud disk.
               - cloud_ssd: SSD cloud Disks.
               - ephemeral_ssd: local SSD Disks
               - cloud_essd: ESSD cloud Disks.
        :param pulumi.Input[str] system_disk_description: System disk description. It cannot begin with http:// or https://.
        :param pulumi.Input[str] system_disk_name: System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[int] system_disk_size: Size of the system disk, measured in GB. Value range: [20, 500].
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] userdata: User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
        :param pulumi.Input[str] vswitch_id: The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        :param pulumi.Input[str] zone_id: The zone ID of the instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LaunchTemplateState.__new__(_LaunchTemplateState)

        __props__.__dict__["auto_release_time"] = auto_release_time
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["deployment_set_id"] = deployment_set_id
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_vm_os_config"] = enable_vm_os_config
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["image_owner_alias"] = image_owner_alias
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["internet_max_bandwidth_in"] = internet_max_bandwidth_in
        __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
        __props__.__dict__["io_optimized"] = io_optimized
        __props__.__dict__["key_pair_name"] = key_pair_name
        __props__.__dict__["launch_template_name"] = launch_template_name
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["password_inherit"] = password_inherit
        __props__.__dict__["period"] = period
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["ram_role_name"] = ram_role_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_enhancement_strategy"] = security_enhancement_strategy
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["spot_duration"] = spot_duration
        __props__.__dict__["spot_price_limit"] = spot_price_limit
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["system_disk"] = system_disk
        __props__.__dict__["system_disk_category"] = system_disk_category
        __props__.__dict__["system_disk_description"] = system_disk_description
        __props__.__dict__["system_disk_name"] = system_disk_name
        __props__.__dict__["system_disk_size"] = system_disk_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_resource_group_id"] = template_resource_group_id
        __props__.__dict__["template_tags"] = template_tags
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["userdata"] = userdata
        __props__.__dict__["version_description"] = version_description
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_id"] = zone_id
        return LaunchTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> pulumi.Output[Optional[str]]:
        """
        Instance auto release time. The time is presented using the ISO8601 standard and in UTC time. The format is  YYYY-MM-DDTHH:MM:SSZ.
        """
        return pulumi.get(self, "auto_release_time")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.LaunchTemplateDataDisk']]]:
        """
        The list of data disks created with instance.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "deployment_set_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableVmOsConfig")
    def enable_vm_os_config(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "enable_vm_os_config")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[str]]:
        """
        Instance host name.It cannot start or end with a period (.) or a hyphen (-) and it cannot have two or more consecutive periods (.) or hyphens (-).For Windows: The host name can be [2, 15] characters in length. It can contain A-Z, a-z, numbers, periods (.), and hyphens (-). It cannot only contain numbers. For other operating systems: The host name can be [2, 64] characters in length. It can be segments separated by periods (.). It can contain A-Z, a-z, numbers, and hyphens (-).
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[str]]:
        """
        Image ID.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "image_owner_alias")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[Optional[str]]:
        """
        Billing methods. Optional values:
        - PrePaid: Monthly, or annual subscription. Make sure that your registered credit card is invalid or you have insufficient balance in your PayPal account. Otherwise, InvalidPayMethod error may occur.
        - PostPaid: Pay-As-You-Go.

        Default value: PostPaid.
        """
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the instance. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[str]]:
        """
        Instance type. For more information, call resource_alicloud_instances to obtain the latest instance type list.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[Optional[str]]:
        """
        Internet bandwidth billing method. Optional values: `PayByTraffic` | `PayByBandwidth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> pulumi.Output[int]:
        """
        The maximum inbound bandwidth from the Internet network, measured in Mbit/s. Value range: [1, 200].
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s. Value range: [0, 100].
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @property
    @pulumi.getter(name="ioOptimized")
    def io_optimized(self) -> pulumi.Output[Optional[str]]:
        """
        Whether it is an I/O-optimized instance or not. Optional values:
        - none
        - optimized
        """
        return pulumi.get(self, "io_optimized")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the key pair.
        - Ignore this parameter for Windows instances. It is null by default. Even if you enter this parameter, only the  Password content is used.
        - The password logon method for Linux instances is set to forbidden upon initialization.
        """
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "launch_template_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the data disk.
        """
        warnings.warn("""Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""", DeprecationWarning)
        pulumi.log.warn("""name is deprecated: Field 'name' has been deprecated from provider version 1.120.0. New field 'launch_template_name' instead.""")

        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Optional['outputs.LaunchTemplateNetworkInterfaces']]:
        """
        The list of network interfaces created with instance.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[Optional[str]]:
        """
        Network type of the instance. Value options: `classic` | `vpc`.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "password_inherit")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> pulumi.Output[Optional[str]]:
        """
        The RAM role name of the instance. You can use the RAM API ListRoles to query instance RAM role names.
        """
        return pulumi.get(self, "ram_role_name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        Whether or not to activate the security enhancement feature and install network security software free of charge. Optional values: Active | Deactive.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The security group ID must be one in the same VPC.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "spot_duration")

    @property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> pulumi.Output[Optional[float]]:
        """
        Sets the maximum hourly instance price. Supports up to three decimal places.
        """
        return pulumi.get(self, "spot_price_limit")

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. This parameter is valid and required only when InstanceChargeType is set to PostPaid. Value range:
        - NoSpot: Normal Pay-As-You-Go instance.
        - SpotWithPriceLimit: Sets the maximum price for a spot instance.
        - SpotAsPriceGo: The system automatically calculates the price. The maximum value is the Pay-As-You-Go price.
        """
        return pulumi.get(self, "spot_strategy")

    @property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> pulumi.Output['outputs.LaunchTemplateSystemDisk']:
        return pulumi.get(self, "system_disk")

    @property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> pulumi.Output[str]:
        """
        The category of the system disk. System disk type. Optional values:
        - cloud: Basic cloud disk.
        - cloud_efficiency: Ultra cloud disk.
        - cloud_ssd: SSD cloud Disks.
        - ephemeral_ssd: local SSD Disks
        - cloud_essd: ESSD cloud Disks.
        """
        warnings.warn("""Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
        pulumi.log.warn("""system_disk_category is deprecated: Field 'system_disk_category' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")

        return pulumi.get(self, "system_disk_category")

    @property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> pulumi.Output[str]:
        """
        System disk description. It cannot begin with http:// or https://.
        """
        warnings.warn("""Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
        pulumi.log.warn("""system_disk_description is deprecated: Field 'system_disk_description' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")

        return pulumi.get(self, "system_disk_description")

    @property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> pulumi.Output[str]:
        """
        System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        warnings.warn("""Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
        pulumi.log.warn("""system_disk_name is deprecated: Field 'system_disk_name' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")

        return pulumi.get(self, "system_disk_name")

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> pulumi.Output[int]:
        """
        Size of the system disk, measured in GB. Value range: [20, 500].
        """
        warnings.warn("""Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""", DeprecationWarning)
        pulumi.log.warn("""system_disk_size is deprecated: Field 'system_disk_size' has been deprecated from provider version 1.120.0. New field 'system_disk' instead.""")

        return pulumi.get(self, "system_disk_size")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="templateResourceGroupId")
    def template_resource_group_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "template_resource_group_id")

    @property
    @pulumi.getter(name="templateTags")
    def template_tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        return pulumi.get(self, "template_tags")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[str]:
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter
    def userdata(self) -> pulumi.Output[str]:
        """
        User data of the instance, which is Base64-encoded. Size of the raw data cannot exceed 16 KB.
        """
        warnings.warn("""Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""", DeprecationWarning)
        pulumi.log.warn("""userdata is deprecated: Field 'userdata' has been deprecated from provider version 1.120.0. New field 'user_data' instead.""")

        return pulumi.get(self, "userdata")

    @property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "version_description")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[str]]:
        """
        The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The zone ID of the instance.
        """
        return pulumi.get(self, "zone_id")

