# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AutoProvisioningGroupLaunchTemplateConfig',
    'DedicatedHostNetworkAttribute',
    'EcsInstanceSetDataDisk',
    'EcsInstanceSetExcludeInstanceFilter',
    'EcsInstanceSetNetworkInterface',
    'EcsLaunchTemplateDataDisk',
    'EcsLaunchTemplateNetworkInterfaces',
    'EcsLaunchTemplateSystemDisk',
    'EcsPrefixListEntry',
    'ImageDiskDeviceMapping',
    'ImageImportDiskDeviceMapping',
    'InstanceDataDisk',
    'InstanceMaintenanceTime',
    'InstanceNetworkInterfaces',
    'LaunchTemplateDataDisk',
    'LaunchTemplateNetworkInterfaces',
    'LaunchTemplateSystemDisk',
    'ReservedInstanceOperationLock',
    'GetActivationsActivationResult',
    'GetAutoSnapshotPoliciesPolicyResult',
    'GetCapacityReservationsReservationResult',
    'GetCommandsCommandResult',
    'GetDedicatedHostsHostResult',
    'GetDedicatedHostsHostCapacityResult',
    'GetDedicatedHostsHostNetworkAttributeResult',
    'GetDedicatedHostsHostOperationLockResult',
    'GetDedicatedHostsOperationLockResult',
    'GetDisksDiskResult',
    'GetDisksDiskMountInstanceResult',
    'GetDisksDiskOperationLockResult',
    'GetDisksOperationLockResult',
    'GetEcsDedicatedHostClustersClusterResult',
    'GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacityResult',
    'GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacityLocalStorageCapacityResult',
    'GetEcsDeploymentSetsSetResult',
    'GetEcsDisksDiskResult',
    'GetEcsDisksDiskMountInstanceResult',
    'GetEcsDisksDiskOperationLockResult',
    'GetEcsDisksOperationLockResult',
    'GetEcsImageComponentsComponentResult',
    'GetEcsImagePipelinePipelineResult',
    'GetEcsInvocationsInvocationResult',
    'GetEcsInvocationsInvocationInvokeInstanceResult',
    'GetEcsKeyPairsKeyPairResult',
    'GetEcsKeyPairsKeyPairInstanceResult',
    'GetEcsKeyPairsPairResult',
    'GetEcsKeyPairsPairInstanceResult',
    'GetEcsLaunchTemplatesTemplateResult',
    'GetEcsLaunchTemplatesTemplateDataDiskResult',
    'GetEcsLaunchTemplatesTemplateNetworkInterfaceResult',
    'GetEcsLaunchTemplatesTemplateSystemDiskResult',
    'GetEcsNetworkInterfacePermissionsPermissionResult',
    'GetEcsNetworkInterfacesInterfaceResult',
    'GetEcsNetworkInterfacesInterfaceAssociatedPublicIpResult',
    'GetEcsPrefixListsListResult',
    'GetEcsPrefixListsListEntryResult',
    'GetEcsSnapshotGroupsGroupResult',
    'GetEcsSnapshotsSnapshotResult',
    'GetEcsStorageCapacityUnitsUnitResult',
    'GetEipAddressesAddressResult',
    'GetEipAddressesEipResult',
    'GetEipsAddressResult',
    'GetEipsEipResult',
    'GetElasticityAssurancesAssuranceResult',
    'GetElasticityAssurancesAssuranceAllocatedResourceResult',
    'GetHpcClustersClusterResult',
    'GetImagesImageResult',
    'GetImagesImageDiskDeviceMappingResult',
    'GetInstanceTypeFamiliesFamilyResult',
    'GetInstanceTypesInstanceTypeResult',
    'GetInstanceTypesInstanceTypeBurstableInstanceResult',
    'GetInstanceTypesInstanceTypeGpuResult',
    'GetInstanceTypesInstanceTypeLocalStorageResult',
    'GetInstancesInstanceResult',
    'GetInstancesInstanceDiskDeviceMappingResult',
    'GetKeyPairsKeyPairResult',
    'GetKeyPairsKeyPairInstanceResult',
    'GetKeyPairsPairResult',
    'GetKeyPairsPairInstanceResult',
    'GetNetworkInterfacesInterfaceResult',
    'GetNetworkInterfacesInterfaceAssociatedPublicIpResult',
    'GetSecurityGroupRulesRuleResult',
    'GetSecurityGroupsGroupResult',
    'GetSnapshotsSnapshotResult',
]

@pulumi.output_type
class AutoProvisioningGroupLaunchTemplateConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxPrice":
            suggest = "max_price"
        elif key == "vswitchId":
            suggest = "vswitch_id"
        elif key == "weightedCapacity":
            suggest = "weighted_capacity"
        elif key == "instanceType":
            suggest = "instance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoProvisioningGroupLaunchTemplateConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoProvisioningGroupLaunchTemplateConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoProvisioningGroupLaunchTemplateConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_price: str,
                 vswitch_id: str,
                 weighted_capacity: str,
                 instance_type: Optional[str] = None,
                 priority: Optional[str] = None):
        """
        :param str max_price: The maximum price of the instance type specified in the Nth extended configurations of the launch template.
        :param str vswitch_id: The ID of the VSwitch in the Nth extended configurations of the launch template.
        :param str weighted_capacity: The weight of the instance type specified in the Nth extended configurations of the launch template.
        :param str instance_type: The instance type of the Nth extended configurations of the launch template.
        :param str priority: The priority of the instance type specified in the Nth extended configurations of the launch template. A value of 0 indicates the highest priority.
        """
        pulumi.set(__self__, "max_price", max_price)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "weighted_capacity", weighted_capacity)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter(name="maxPrice")
    def max_price(self) -> str:
        """
        The maximum price of the instance type specified in the Nth extended configurations of the launch template.
        """
        return pulumi.get(self, "max_price")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The ID of the VSwitch in the Nth extended configurations of the launch template.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> str:
        """
        The weight of the instance type specified in the Nth extended configurations of the launch template.
        """
        return pulumi.get(self, "weighted_capacity")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        The instance type of the Nth extended configurations of the launch template.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter
    def priority(self) -> Optional[str]:
        """
        The priority of the instance type specified in the Nth extended configurations of the launch template. A value of 0 indicates the highest priority.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class DedicatedHostNetworkAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "slbUdpTimeout":
            suggest = "slb_udp_timeout"
        elif key == "udpTimeout":
            suggest = "udp_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DedicatedHostNetworkAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DedicatedHostNetworkAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DedicatedHostNetworkAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 slb_udp_timeout: Optional[int] = None,
                 udp_timeout: Optional[int] = None):
        """
        :param int slb_udp_timeout: The timeout period for a UDP session between Server Load Balancer (SLB) and the dedicated host. Unit: seconds. Valid values: 15 to 310.
        :param int udp_timeout: The timeout period for a UDP session between a user and an Alibaba Cloud service on the dedicated host. Unit: seconds. Valid values: 15 to 310.
        """
        if slb_udp_timeout is not None:
            pulumi.set(__self__, "slb_udp_timeout", slb_udp_timeout)
        if udp_timeout is not None:
            pulumi.set(__self__, "udp_timeout", udp_timeout)

    @property
    @pulumi.getter(name="slbUdpTimeout")
    def slb_udp_timeout(self) -> Optional[int]:
        """
        The timeout period for a UDP session between Server Load Balancer (SLB) and the dedicated host. Unit: seconds. Valid values: 15 to 310.
        """
        return pulumi.get(self, "slb_udp_timeout")

    @property
    @pulumi.getter(name="udpTimeout")
    def udp_timeout(self) -> Optional[int]:
        """
        The timeout period for a UDP session between a user and an Alibaba Cloud service on the dedicated host. Unit: seconds. Valid values: 15 to 310.
        """
        return pulumi.get(self, "udp_timeout")


@pulumi.output_type
class EcsInstanceSetDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSize":
            suggest = "disk_size"
        elif key == "autoSnapshotPolicyId":
            suggest = "auto_snapshot_policy_id"
        elif key == "diskCategory":
            suggest = "disk_category"
        elif key == "diskDescription":
            suggest = "disk_description"
        elif key == "diskName":
            suggest = "disk_name"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "performanceLevel":
            suggest = "performance_level"
        elif key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EcsInstanceSetDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EcsInstanceSetDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EcsInstanceSetDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size: int,
                 auto_snapshot_policy_id: Optional[str] = None,
                 disk_category: Optional[str] = None,
                 disk_description: Optional[str] = None,
                 disk_name: Optional[str] = None,
                 encrypted: Optional[bool] = None,
                 kms_key_id: Optional[str] = None,
                 performance_level: Optional[str] = None,
                 snapshot_id: Optional[str] = None):
        """
        :param int disk_size: The size of the data disk. Unit: GiB.
               - When `disk_category` is `cloud_efficiency`, Valid values: `20` to `32768`.
               - When `disk_category` is `cloud_ssd`, Valid values: `20` to `32768`.
               - When `disk_category` is `cloud_essd`, Valid values: `20` to `32768`.
               - When `disk_category` is `cloud`, Valid values: `5` to `200`.
        :param str auto_snapshot_policy_id: The ID of the automatic snapshot policy applied to the system disk.
        :param str disk_category: The category of the disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
        :param str disk_description: The description of the data disk.
        :param str disk_name: The name of the data disk.
        :param bool encrypted: Encrypted the data in this disk. Default value: `false`.
        :param str kms_key_id: The KMS key ID corresponding to the data disk.
        :param str performance_level: The performance level of the ESSD used as data disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
        :param str snapshot_id: The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        pulumi.set(__self__, "disk_size", disk_size)
        if auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        if disk_category is not None:
            pulumi.set(__self__, "disk_category", disk_category)
        if disk_description is not None:
            pulumi.set(__self__, "disk_description", disk_description)
        if disk_name is not None:
            pulumi.set(__self__, "disk_name", disk_name)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> int:
        """
        The size of the data disk. Unit: GiB.
        - When `disk_category` is `cloud_efficiency`, Valid values: `20` to `32768`.
        - When `disk_category` is `cloud_ssd`, Valid values: `20` to `32768`.
        - When `disk_category` is `cloud_essd`, Valid values: `20` to `32768`.
        - When `disk_category` is `cloud`, Valid values: `5` to `200`.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> Optional[str]:
        """
        The ID of the automatic snapshot policy applied to the system disk.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @property
    @pulumi.getter(name="diskCategory")
    def disk_category(self) -> Optional[str]:
        """
        The category of the disk. Valid values: `cloud_efficiency`, `cloud_ssd`, `cloud_essd`, `cloud`.
        """
        return pulumi.get(self, "disk_category")

    @property
    @pulumi.getter(name="diskDescription")
    def disk_description(self) -> Optional[str]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "disk_description")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> Optional[str]:
        """
        The name of the data disk.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Encrypted the data in this disk. Default value: `false`.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The KMS key ID corresponding to the data disk.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[str]:
        """
        The performance level of the ESSD used as data disk. Valid values: `PL0`, `PL1`, `PL2`, `PL3`.
        """
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class EcsInstanceSetExcludeInstanceFilter(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str]):
        """
        :param str key: The type of the excluded. Valid values: `InstanceId`, `InstanceName`.
        :param Sequence[str] values: The value of the excluded. The identification of the excluded instances. It is a list of instance Ids or names.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The type of the excluded. Valid values: `InstanceId`, `InstanceName`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The value of the excluded. The identification of the excluded instances. It is a list of instance Ids or names.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class EcsInstanceSetNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupId":
            suggest = "security_group_id"
        elif key == "networkInterfaceName":
            suggest = "network_interface_name"
        elif key == "primaryIpAddress":
            suggest = "primary_ip_address"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EcsInstanceSetNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EcsInstanceSetNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EcsInstanceSetNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_id: str,
                 description: Optional[str] = None,
                 network_interface_name: Optional[str] = None,
                 primary_ip_address: Optional[str] = None,
                 vswitch_id: Optional[str] = None):
        """
        :param str security_group_id: The ID of the security group to which to assign secondary ENI.
        :param str description: The description of ENI.
        :param str network_interface_name: The name of ENI.
        :param str primary_ip_address: The primary private IP address of ENI.
        :param str vswitch_id: The ID of the vSwitch to which to connect ENI.
        """
        pulumi.set(__self__, "security_group_id", security_group_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if network_interface_name is not None:
            pulumi.set(__self__, "network_interface_name", network_interface_name)
        if primary_ip_address is not None:
            pulumi.set(__self__, "primary_ip_address", primary_ip_address)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        The ID of the security group to which to assign secondary ENI.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of ENI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="networkInterfaceName")
    def network_interface_name(self) -> Optional[str]:
        """
        The name of ENI.
        """
        return pulumi.get(self, "network_interface_name")

    @property
    @pulumi.getter(name="primaryIpAddress")
    def primary_ip_address(self) -> Optional[str]:
        """
        The primary private IP address of ENI.
        """
        return pulumi.get(self, "primary_ip_address")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[str]:
        """
        The ID of the vSwitch to which to connect ENI.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class EcsLaunchTemplateDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteWithInstance":
            suggest = "delete_with_instance"
        elif key == "performanceLevel":
            suggest = "performance_level"
        elif key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EcsLaunchTemplateDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EcsLaunchTemplateDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EcsLaunchTemplateDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: Optional[str] = None,
                 delete_with_instance: Optional[bool] = None,
                 description: Optional[str] = None,
                 encrypted: Optional[bool] = None,
                 name: Optional[str] = None,
                 performance_level: Optional[str] = None,
                 size: Optional[int] = None,
                 snapshot_id: Optional[str] = None):
        """
        :param str category: The category of the disk.
        :param bool delete_with_instance: Indicates whether the data disk is released with the instance.
        :param str description: The description of the data disk.
        :param bool encrypted: Encrypted the data in this disk.
        :param str name: The name of the data disk.
        :param str performance_level: The performance level of the ESSD used as the data disk.
        :param int size: The size of the data disk.
        :param str snapshot_id: The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        The category of the disk.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[bool]:
        """
        Indicates whether the data disk is released with the instance.
        """
        return pulumi.get(self, "delete_with_instance")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Encrypted the data in this disk.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the data disk.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[str]:
        """
        The performance level of the ESSD used as the data disk.
        """
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        The size of the data disk.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class EcsLaunchTemplateNetworkInterfaces(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryIp":
            suggest = "primary_ip"
        elif key == "securityGroupId":
            suggest = "security_group_id"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EcsLaunchTemplateNetworkInterfaces. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EcsLaunchTemplateNetworkInterfaces.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EcsLaunchTemplateNetworkInterfaces.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 name: Optional[str] = None,
                 primary_ip: Optional[str] = None,
                 security_group_id: Optional[str] = None,
                 vswitch_id: Optional[str] = None):
        """
        :param str description: The ENI description.
        :param str name: The ENI name.
        :param str primary_ip: The primary private IP address of the ENI.
        :param str security_group_id: The security group ID must be one in the same VPC.
        :param str vswitch_id: The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_ip is not None:
            pulumi.set(__self__, "primary_ip", primary_ip)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The ENI description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The ENI name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryIp")
    def primary_ip(self) -> Optional[str]:
        """
        The primary private IP address of the ENI.
        """
        return pulumi.get(self, "primary_ip")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[str]:
        """
        The security group ID must be one in the same VPC.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[str]:
        """
        The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class EcsLaunchTemplateSystemDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteWithInstance":
            suggest = "delete_with_instance"
        elif key == "performanceLevel":
            suggest = "performance_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EcsLaunchTemplateSystemDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EcsLaunchTemplateSystemDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EcsLaunchTemplateSystemDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: Optional[str] = None,
                 delete_with_instance: Optional[bool] = None,
                 description: Optional[str] = None,
                 encrypted: Optional[bool] = None,
                 iops: Optional[str] = None,
                 name: Optional[str] = None,
                 performance_level: Optional[str] = None,
                 size: Optional[int] = None):
        """
        :param str category: The category of the system disk. System disk type. Valid values: `all`, `cloud`, `ephemeral_ssd`, `cloud_essd`, `cloud_efficiency`, `cloud_ssd`, `local_disk`.
        :param bool delete_with_instance: Specifies whether to release the system disk when the instance is released. Default to `true`.
        :param str description: System disk description. It cannot begin with http:// or https://.
        :param bool encrypted: Specifies whether the system disk is encrypted.
        :param str iops: The Iops.
        :param str name: System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        :param str performance_level: The performance level of the ESSD used as the system disk. Valid Values: `PL0`, `PL1`, `PL2`, and `PL3`. Default to: `PL0`.
        :param int size: Size of the system disk, measured in GB. Value range: [20, 500].
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        The category of the system disk. System disk type. Valid values: `all`, `cloud`, `ephemeral_ssd`, `cloud_essd`, `cloud_efficiency`, `cloud_ssd`, `local_disk`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[bool]:
        """
        Specifies whether to release the system disk when the instance is released. Default to `true`.
        """
        return pulumi.get(self, "delete_with_instance")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        System disk description. It cannot begin with http:// or https://.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Specifies whether the system disk is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[str]:
        """
        The Iops.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        System disk name. The name is a string of 2 to 128 characters. It must begin with an English or a Chinese character. It can contain A-Z, a-z, Chinese characters, numbers, periods (.), colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[str]:
        """
        The performance level of the ESSD used as the system disk. Valid Values: `PL0`, `PL1`, `PL2`, and `PL3`. Default to: `PL0`.
        """
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        Size of the system disk, measured in GB. Value range: [20, 500].
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class EcsPrefixListEntry(dict):
    def __init__(__self__, *,
                 cidr: Optional[str] = None,
                 description: Optional[str] = None):
        """
        :param str cidr: The CIDR block in entry. This parameter is empty by default.  Take note of the following items:
               * The total number of entries must not exceed the `max_entries` value.
               * CIDR block types are determined by the IP address family. You cannot combine `IPv4` and `IPv6` CIDR blocks in a single entry.
               * CIDR blocks must be unique across all entries in a prefix list. For example, you cannot specify 192.168.1.0/24 twice in the entries of the prefix list.
               * IP addresses are supported. The system converts IP addresses into CIDR blocks. For example, if you specify 192.168.1.100, the system converts it into the 192.168.1.100/32 CIDR block.
               * If an IPv6 CIDR block is used, the system converts it to the zero compression format and changes uppercase letters into lowercase ones. For example, if you specify 2001:0DB8:0000:0000:0000:0000:0000:0000/32, the system converts it into 2001:db8::/32.
               * For more information about CIDR blocks, see the "What is CIDR block?" section of the [Network FAQ](https://www.alibabacloud.com/help/doc-detail/40637.htm) topic.  * The total number of entries must not exceed the `max_entries` value.
        :param str description: The description in entry. The description must be 2 to 32 characters in length and cannot start with `http://` or `https://`.
        """
        if cidr is not None:
            pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def cidr(self) -> Optional[str]:
        """
        The CIDR block in entry. This parameter is empty by default.  Take note of the following items:
        * The total number of entries must not exceed the `max_entries` value.
        * CIDR block types are determined by the IP address family. You cannot combine `IPv4` and `IPv6` CIDR blocks in a single entry.
        * CIDR blocks must be unique across all entries in a prefix list. For example, you cannot specify 192.168.1.0/24 twice in the entries of the prefix list.
        * IP addresses are supported. The system converts IP addresses into CIDR blocks. For example, if you specify 192.168.1.100, the system converts it into the 192.168.1.100/32 CIDR block.
        * If an IPv6 CIDR block is used, the system converts it to the zero compression format and changes uppercase letters into lowercase ones. For example, if you specify 2001:0DB8:0000:0000:0000:0000:0000:0000/32, the system converts it into 2001:db8::/32.
        * For more information about CIDR blocks, see the "What is CIDR block?" section of the [Network FAQ](https://www.alibabacloud.com/help/doc-detail/40637.htm) topic.  * The total number of entries must not exceed the `max_entries` value.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description in entry. The description must be 2 to 32 characters in length and cannot start with `http://` or `https://`.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ImageDiskDeviceMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskType":
            suggest = "disk_type"
        elif key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageDiskDeviceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageDiskDeviceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageDiskDeviceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device: Optional[str] = None,
                 disk_type: Optional[str] = None,
                 size: Optional[int] = None,
                 snapshot_id: Optional[str] = None):
        """
        :param str device: Specifies the name of a disk in the combined custom image. Value range: /dev/xvda to /dev/xvdz.
        :param str disk_type: Specifies the type of a disk in the combined custom image. If you specify this parameter, you can use a data disk snapshot as the data source of a system disk for creating an image. If it is not specified, the disk type is determined by the corresponding snapshot. Valid values: `system`, `data`,
        :param int size: Specifies the size of a disk in the combined custom image, in GiB. Value range: 5 to 2000.
        :param str snapshot_id: Specifies a snapshot that is used to create a combined custom image.
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter
    def device(self) -> Optional[str]:
        """
        Specifies the name of a disk in the combined custom image. Value range: /dev/xvda to /dev/xvdz.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        Specifies the type of a disk in the combined custom image. If you specify this parameter, you can use a data disk snapshot as the data source of a system disk for creating an image. If it is not specified, the disk type is determined by the corresponding snapshot. Valid values: `system`, `data`,
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        Specifies the size of a disk in the combined custom image, in GiB. Value range: 5 to 2000.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        Specifies a snapshot that is used to create a combined custom image.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class ImageImportDiskDeviceMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskImageSize":
            suggest = "disk_image_size"
        elif key == "ossBucket":
            suggest = "oss_bucket"
        elif key == "ossObject":
            suggest = "oss_object"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageImportDiskDeviceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageImportDiskDeviceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageImportDiskDeviceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device: Optional[str] = None,
                 disk_image_size: Optional[int] = None,
                 format: Optional[str] = None,
                 oss_bucket: Optional[str] = None,
                 oss_object: Optional[str] = None):
        """
        :param str device: The name of disk N in the custom image.
        :param int disk_image_size: Resolution size. You must ensure that the system disk space ≥ file system space. Ranges: When n = 1, the system disk: 5 ~ 500GiB, When n = 2 ~ 17, that is, data disk: 5 ~ 1000GiB, When temporary is introduced, the system automatically detects the size, which is subject to the detection result.
        :param str format: Image format. Value range: When the `RAW`, `VHD`, `qcow2` is imported into the image, the system automatically detects the image format, whichever comes first.
        :param str oss_bucket: Save the exported OSS bucket.
        :param str oss_object: The file name of your OSS Object.
               
               > **NOTE:** The disk_device_mapping is a list and it's first item will be used to system disk and other items are used to data disks.
        """
        if device is not None:
            pulumi.set(__self__, "device", device)
        if disk_image_size is not None:
            pulumi.set(__self__, "disk_image_size", disk_image_size)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if oss_bucket is not None:
            pulumi.set(__self__, "oss_bucket", oss_bucket)
        if oss_object is not None:
            pulumi.set(__self__, "oss_object", oss_object)

    @property
    @pulumi.getter
    def device(self) -> Optional[str]:
        """
        The name of disk N in the custom image.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="diskImageSize")
    def disk_image_size(self) -> Optional[int]:
        """
        Resolution size. You must ensure that the system disk space ≥ file system space. Ranges: When n = 1, the system disk: 5 ~ 500GiB, When n = 2 ~ 17, that is, data disk: 5 ~ 1000GiB, When temporary is introduced, the system automatically detects the size, which is subject to the detection result.
        """
        return pulumi.get(self, "disk_image_size")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Image format. Value range: When the `RAW`, `VHD`, `qcow2` is imported into the image, the system automatically detects the image format, whichever comes first.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="ossBucket")
    def oss_bucket(self) -> Optional[str]:
        """
        Save the exported OSS bucket.
        """
        return pulumi.get(self, "oss_bucket")

    @property
    @pulumi.getter(name="ossObject")
    def oss_object(self) -> Optional[str]:
        """
        The file name of your OSS Object.

        > **NOTE:** The disk_device_mapping is a list and it's first item will be used to system disk and other items are used to data disks.
        """
        return pulumi.get(self, "oss_object")


@pulumi.output_type
class InstanceDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoSnapshotPolicyId":
            suggest = "auto_snapshot_policy_id"
        elif key == "deleteWithInstance":
            suggest = "delete_with_instance"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "performanceLevel":
            suggest = "performance_level"
        elif key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 auto_snapshot_policy_id: Optional[str] = None,
                 category: Optional[str] = None,
                 delete_with_instance: Optional[bool] = None,
                 description: Optional[str] = None,
                 device: Optional[str] = None,
                 encrypted: Optional[bool] = None,
                 kms_key_id: Optional[str] = None,
                 name: Optional[str] = None,
                 performance_level: Optional[str] = None,
                 snapshot_id: Optional[str] = None):
        """
        :param int size: The size of the data disk.
               - cloud：[5, 2000]
               - cloud_efficiency：[20, 32768]
               - cloud_ssd：[20, 32768]
               - cloud_essd：[20, 32768]
               - ephemeral_ssd: [5, 800]
        :param str auto_snapshot_policy_id: The ID of the automatic snapshot policy applied to the system disk.
        :param str category: The category of the disk:
        :param bool delete_with_instance: Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_essd, cloud_ssd disk. If the category of this data disk was ephemeral_ssd, please don't set this param. Default value: `true`.
        :param str description: The description of the data disk.
        :param str device: The mount point of the data disk.
        :param bool encrypted: Encrypted the data in this disk. Default value: `false`.
        :param str kms_key_id: The KMS key ID corresponding to the Nth data disk.
        :param str name: The name of the data disk.
        :param str performance_level: The performance level of the ESSD used as data disk:
        :param str snapshot_id: The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        pulumi.set(__self__, "size", size)
        if auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the data disk.
        - cloud：[5, 2000]
        - cloud_efficiency：[20, 32768]
        - cloud_ssd：[20, 32768]
        - cloud_essd：[20, 32768]
        - ephemeral_ssd: [5, 800]
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> Optional[str]:
        """
        The ID of the automatic snapshot policy applied to the system disk.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        The category of the disk:
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[bool]:
        """
        Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_essd, cloud_ssd disk. If the category of this data disk was ephemeral_ssd, please don't set this param. Default value: `true`.
        """
        return pulumi.get(self, "delete_with_instance")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def device(self) -> Optional[str]:
        """
        The mount point of the data disk.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Encrypted the data in this disk. Default value: `false`.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The KMS key ID corresponding to the Nth data disk.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the data disk.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[str]:
        """
        The performance level of the ESSD used as data disk:
        """
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class InstanceMaintenanceTime(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMaintenanceTime. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMaintenanceTime.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMaintenanceTime.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[str] = None,
                 start_time: Optional[str] = None):
        """
        :param str end_time: The end time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
        :param str start_time: The start time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        The end time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        The start time of maintenance. The time must be on the hour at exactly 0 minute and 0 second. The `start_time` and `end_time` parameters must be specified at the same time. The `end_time` value must be 1 to 23 hours later than the `start_time` value. Specify the time in the HH:mm:ss format. The time must be in UTC+8.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class InstanceNetworkInterfaces(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkInterfaceId":
            suggest = "network_interface_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworkInterfaces. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworkInterfaces.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworkInterfaces.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_interface_id: Optional[str] = None):
        """
        :param str network_interface_id: The ID of the secondary ENI.
        """
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[str]:
        """
        The ID of the secondary ENI.
        """
        return pulumi.get(self, "network_interface_id")


@pulumi.output_type
class LaunchTemplateDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteWithInstance":
            suggest = "delete_with_instance"
        elif key == "performanceLevel":
            suggest = "performance_level"
        elif key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchTemplateDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchTemplateDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchTemplateDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: Optional[str] = None,
                 delete_with_instance: Optional[bool] = None,
                 description: Optional[str] = None,
                 encrypted: Optional[bool] = None,
                 name: Optional[str] = None,
                 performance_level: Optional[str] = None,
                 size: Optional[int] = None,
                 snapshot_id: Optional[str] = None):
        """
        :param str category: The category of the disk:
               - cloud: Basic cloud disk.
               - cloud_efficiency: Ultra cloud disk.
               - cloud_ssd: SSD cloud Disks.
               - ephemeral_ssd: local SSD Disks
               - cloud_essd: ESSD cloud Disks.
               
               Default to `cloud_efficiency`.
        :param bool delete_with_instance: Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.
               
               Default to true
        :param str description: The description of the data disk.
        :param bool encrypted: Encrypted the data in this disk.
               
               Default to false
        :param str name: The name of the data disk.
        :param int size: The size of the data disk.
               - cloud：[5, 2000]
               - cloud_efficiency：[20, 32768]
               - cloud_ssd：[20, 32768]
               - cloud_essd：[20, 32768]
               - ephemeral_ssd: [5, 800]
        :param str snapshot_id: The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        The category of the disk:
        - cloud: Basic cloud disk.
        - cloud_efficiency: Ultra cloud disk.
        - cloud_ssd: SSD cloud Disks.
        - ephemeral_ssd: local SSD Disks
        - cloud_essd: ESSD cloud Disks.

        Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[bool]:
        """
        Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.

        Default to true
        """
        return pulumi.get(self, "delete_with_instance")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Encrypted the data in this disk.

        Default to false
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the data disk.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[str]:
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        The size of the data disk.
        - cloud：[5, 2000]
        - cloud_efficiency：[20, 32768]
        - cloud_ssd：[20, 32768]
        - cloud_essd：[20, 32768]
        - ephemeral_ssd: [5, 800]
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class LaunchTemplateNetworkInterfaces(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "primaryIp":
            suggest = "primary_ip"
        elif key == "securityGroupId":
            suggest = "security_group_id"
        elif key == "vswitchId":
            suggest = "vswitch_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchTemplateNetworkInterfaces. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchTemplateNetworkInterfaces.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchTemplateNetworkInterfaces.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 name: Optional[str] = None,
                 primary_ip: Optional[str] = None,
                 security_group_id: Optional[str] = None,
                 vswitch_id: Optional[str] = None):
        """
        :param str description: The description of the data disk.
        :param str name: The name of the data disk.
        :param str primary_ip: The primary private IP address of the ENI.
        :param str security_group_id: The security group ID must be one in the same VPC.
        :param str vswitch_id: The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_ip is not None:
            pulumi.set(__self__, "primary_ip", primary_ip)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the data disk.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryIp")
    def primary_ip(self) -> Optional[str]:
        """
        The primary private IP address of the ENI.
        """
        return pulumi.get(self, "primary_ip")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[str]:
        """
        The security group ID must be one in the same VPC.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[str]:
        """
        The VSwitch ID for ENI. The instance must be in the same zone of the same VPC network as the ENI, but they may belong to different VSwitches.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class LaunchTemplateSystemDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteWithInstance":
            suggest = "delete_with_instance"
        elif key == "performanceLevel":
            suggest = "performance_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchTemplateSystemDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchTemplateSystemDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchTemplateSystemDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: Optional[str] = None,
                 delete_with_instance: Optional[bool] = None,
                 description: Optional[str] = None,
                 encrypted: Optional[bool] = None,
                 iops: Optional[str] = None,
                 name: Optional[str] = None,
                 performance_level: Optional[str] = None,
                 size: Optional[int] = None):
        """
        :param str category: The category of the disk:
               - cloud: Basic cloud disk.
               - cloud_efficiency: Ultra cloud disk.
               - cloud_ssd: SSD cloud Disks.
               - ephemeral_ssd: local SSD Disks
               - cloud_essd: ESSD cloud Disks.
               
               Default to `cloud_efficiency`.
        :param bool delete_with_instance: Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.
               
               Default to true
        :param str description: The description of the data disk.
        :param bool encrypted: Encrypted the data in this disk.
               
               Default to false
        :param str name: The name of the data disk.
        :param int size: The size of the data disk.
               - cloud：[5, 2000]
               - cloud_efficiency：[20, 32768]
               - cloud_ssd：[20, 32768]
               - cloud_essd：[20, 32768]
               - ephemeral_ssd: [5, 800]
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        The category of the disk:
        - cloud: Basic cloud disk.
        - cloud_efficiency: Ultra cloud disk.
        - cloud_ssd: SSD cloud Disks.
        - ephemeral_ssd: local SSD Disks
        - cloud_essd: ESSD cloud Disks.

        Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[bool]:
        """
        Delete this data disk when the instance is destroyed. It only works on cloud, cloud_efficiency, cloud_ssd and cloud_essd disk. If the category of this data disk was ephemeral_ssd, please don't set this param.

        Default to true
        """
        return pulumi.get(self, "delete_with_instance")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the data disk.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Encrypted the data in this disk.

        Default to false
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[str]:
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the data disk.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[str]:
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        The size of the data disk.
        - cloud：[5, 2000]
        - cloud_efficiency：[20, 32768]
        - cloud_ssd：[20, 32768]
        - cloud_essd：[20, 32768]
        - ephemeral_ssd: [5, 800]
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class ReservedInstanceOperationLock(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lockReason":
            suggest = "lock_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReservedInstanceOperationLock. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReservedInstanceOperationLock.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReservedInstanceOperationLock.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lock_reason: Optional[str] = None):
        """
        :param str lock_reason: The reason why the reserved instance was locked.
        """
        if lock_reason is not None:
            pulumi.set(__self__, "lock_reason", lock_reason)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> Optional[str]:
        """
        The reason why the reserved instance was locked.
        """
        return pulumi.get(self, "lock_reason")


@pulumi.output_type
class GetActivationsActivationResult(dict):
    def __init__(__self__, *,
                 activation_id: str,
                 create_time: str,
                 deregistered_count: int,
                 description: str,
                 disabled: bool,
                 id: str,
                 instance_count: int,
                 instance_name: str,
                 ip_address_range: str,
                 registered_count: int,
                 time_to_live_in_hours: int):
        """
        :param str activation_id: The ID of the activation code.
        :param str create_time: The time when the activation code was created.
        :param int deregistered_count: The number of instances that have been logged out.
        :param str description: Description of the corresponding activation code.
        :param bool disabled: Indicates whether the activation code is disabled.
        :param str id: The ID of the Activation.
        :param int instance_count: The maximum number of times the activation code is used to register a managed instance.
        :param str instance_name: The default prefix of the instance name.
        :param str ip_address_range: The IP address of the host that allows the activation code to be used.
        :param int registered_count: The number of instances that were registered.
        :param int time_to_live_in_hours: The validity period of the activation code. Unit: hours.
        """
        pulumi.set(__self__, "activation_id", activation_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "deregistered_count", deregistered_count)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disabled", disabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "ip_address_range", ip_address_range)
        pulumi.set(__self__, "registered_count", registered_count)
        pulumi.set(__self__, "time_to_live_in_hours", time_to_live_in_hours)

    @property
    @pulumi.getter(name="activationId")
    def activation_id(self) -> str:
        """
        The ID of the activation code.
        """
        return pulumi.get(self, "activation_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the activation code was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deregisteredCount")
    def deregistered_count(self) -> int:
        """
        The number of instances that have been logged out.
        """
        return pulumi.get(self, "deregistered_count")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the corresponding activation code.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disabled(self) -> bool:
        """
        Indicates whether the activation code is disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Activation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The maximum number of times the activation code is used to register a managed instance.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The default prefix of the instance name.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="ipAddressRange")
    def ip_address_range(self) -> str:
        """
        The IP address of the host that allows the activation code to be used.
        """
        return pulumi.get(self, "ip_address_range")

    @property
    @pulumi.getter(name="registeredCount")
    def registered_count(self) -> int:
        """
        The number of instances that were registered.
        """
        return pulumi.get(self, "registered_count")

    @property
    @pulumi.getter(name="timeToLiveInHours")
    def time_to_live_in_hours(self) -> int:
        """
        The validity period of the activation code. Unit: hours.
        """
        return pulumi.get(self, "time_to_live_in_hours")


@pulumi.output_type
class GetAutoSnapshotPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 auto_snapshot_policy_id: str,
                 copied_snapshots_retention_days: int,
                 disk_nums: int,
                 enable_cross_region_copy: bool,
                 id: str,
                 name: str,
                 repeat_weekdays: Sequence[str],
                 retention_days: int,
                 status: str,
                 tags: Mapping[str, Any],
                 target_copy_regions: Sequence[str],
                 time_points: Sequence[str],
                 volume_nums: int):
        """
        :param str auto_snapshot_policy_id: The ID of the Auto Snapshot Policy.
        :param int copied_snapshots_retention_days: The retention period of the snapshot copied across regions.
        :param int disk_nums: The number of disks to which the automatic snapshot policy is applied.
        :param bool enable_cross_region_copy: Specifies whether to enable the system to automatically copy snapshots across regions.
        :param str id: The ID of the Auto Snapshot Policy.
        :param str name: The snapshot policy name..
        :param Sequence[str] repeat_weekdays: The automatic snapshot repetition dates.
        :param int retention_days: The snapshot retention time, and the unit of measurement is day.
        :param str status: The status of Auto Snapshot Policy.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        :param Sequence[str] target_copy_regions: The destination region to which the snapshot is copied.
        :param Sequence[str] time_points: The automatic snapshot creation schedule, and the unit of measurement is hour.
        :param int volume_nums: The number of extended volumes on which this policy is enabled.
        """
        pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        pulumi.set(__self__, "copied_snapshots_retention_days", copied_snapshots_retention_days)
        pulumi.set(__self__, "disk_nums", disk_nums)
        pulumi.set(__self__, "enable_cross_region_copy", enable_cross_region_copy)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "repeat_weekdays", repeat_weekdays)
        pulumi.set(__self__, "retention_days", retention_days)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "target_copy_regions", target_copy_regions)
        pulumi.set(__self__, "time_points", time_points)
        pulumi.set(__self__, "volume_nums", volume_nums)

    @property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> str:
        """
        The ID of the Auto Snapshot Policy.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @property
    @pulumi.getter(name="copiedSnapshotsRetentionDays")
    def copied_snapshots_retention_days(self) -> int:
        """
        The retention period of the snapshot copied across regions.
        """
        return pulumi.get(self, "copied_snapshots_retention_days")

    @property
    @pulumi.getter(name="diskNums")
    def disk_nums(self) -> int:
        """
        The number of disks to which the automatic snapshot policy is applied.
        """
        return pulumi.get(self, "disk_nums")

    @property
    @pulumi.getter(name="enableCrossRegionCopy")
    def enable_cross_region_copy(self) -> bool:
        """
        Specifies whether to enable the system to automatically copy snapshots across regions.
        """
        return pulumi.get(self, "enable_cross_region_copy")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Auto Snapshot Policy.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The snapshot policy name..
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="repeatWeekdays")
    def repeat_weekdays(self) -> Sequence[str]:
        """
        The automatic snapshot repetition dates.
        """
        return pulumi.get(self, "repeat_weekdays")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> int:
        """
        The snapshot retention time, and the unit of measurement is day.
        """
        return pulumi.get(self, "retention_days")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of Auto Snapshot Policy.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="targetCopyRegions")
    def target_copy_regions(self) -> Sequence[str]:
        """
        The destination region to which the snapshot is copied.
        """
        return pulumi.get(self, "target_copy_regions")

    @property
    @pulumi.getter(name="timePoints")
    def time_points(self) -> Sequence[str]:
        """
        The automatic snapshot creation schedule, and the unit of measurement is hour.
        """
        return pulumi.get(self, "time_points")

    @property
    @pulumi.getter(name="volumeNums")
    def volume_nums(self) -> int:
        """
        The number of extended volumes on which this policy is enabled.
        """
        return pulumi.get(self, "volume_nums")


@pulumi.output_type
class GetCapacityReservationsReservationResult(dict):
    def __init__(__self__, *,
                 capacity_reservation_id: str,
                 capacity_reservation_name: str,
                 description: str,
                 end_time: str,
                 end_time_type: str,
                 id: str,
                 instance_amount: str,
                 instance_type: str,
                 match_criteria: str,
                 payment_type: str,
                 platform: str,
                 resource_group_id: str,
                 start_time: str,
                 start_time_type: str,
                 status: str,
                 time_slot: str,
                 zone_ids: Sequence[str],
                 tags: Optional[Mapping[str, Any]] = None):
        """
        :param str capacity_reservation_id: Capacity Reservation id
        :param str capacity_reservation_name: Capacity reservation service name.
        :param str description: description of the capacity reservation instance
        :param str end_time: end time of the capacity reservation. the capacity reservation will be  released at the end time automatically if set. otherwise it will last until manually released
        :param str end_time_type: Release mode of capacity reservation service. Value range:Limited: release at specified time. The EndTime parameter must be specified at the same time.Unlimited: manual release. No time limit.
        :param str id: The ID of the Capacity Reservation.
        :param str instance_amount: The total number of instances that need to be reserved within the capacity reservation
        :param str instance_type: Instance type. Currently, you can only set the capacity reservation service for one instance type.
        :param str match_criteria: The type of private resource pool generated after the capacity reservation service takes effect. Value range:Open: Open mode.Target: dedicated mode.Default value: Open
        :param str payment_type: The payment type of the resource. value range `PostPaid`, `PrePaid`.
        :param str platform: platform of the capacity reservation , value range `windows`, `linux`, `all`.
        :param str resource_group_id: The resource group id.
        :param str start_time: time of the capacity reservation which become active
        :param str start_time_type: The capacity is scheduled to take effect. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
        :param str status: The status of the capacity reservation. value range `All`, `Pending`, `Preparing`, `Prepared`, `Active`, `Released`.
        :param str time_slot: This parameter is under test and is not yet open for use.
        :param Sequence[str] zone_ids: The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
        :param Mapping[str, Any] tags: The tag of the resource.
        """
        pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        pulumi.set(__self__, "capacity_reservation_name", capacity_reservation_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "end_time_type", end_time_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_amount", instance_amount)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "match_criteria", match_criteria)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "start_time_type", start_time_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time_slot", time_slot)
        pulumi.set(__self__, "zone_ids", zone_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> str:
        """
        Capacity Reservation id
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="capacityReservationName")
    def capacity_reservation_name(self) -> str:
        """
        Capacity reservation service name.
        """
        return pulumi.get(self, "capacity_reservation_name")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        description of the capacity reservation instance
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        end time of the capacity reservation. the capacity reservation will be  released at the end time automatically if set. otherwise it will last until manually released
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="endTimeType")
    def end_time_type(self) -> str:
        """
        Release mode of capacity reservation service. Value range:Limited: release at specified time. The EndTime parameter must be specified at the same time.Unlimited: manual release. No time limit.
        """
        return pulumi.get(self, "end_time_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Capacity Reservation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceAmount")
    def instance_amount(self) -> str:
        """
        The total number of instances that need to be reserved within the capacity reservation
        """
        return pulumi.get(self, "instance_amount")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Instance type. Currently, you can only set the capacity reservation service for one instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="matchCriteria")
    def match_criteria(self) -> str:
        """
        The type of private resource pool generated after the capacity reservation service takes effect. Value range:Open: Open mode.Target: dedicated mode.Default value: Open
        """
        return pulumi.get(self, "match_criteria")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The payment type of the resource. value range `PostPaid`, `PrePaid`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def platform(self) -> str:
        """
        platform of the capacity reservation , value range `windows`, `linux`, `all`.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        time of the capacity reservation which become active
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="startTimeType")
    def start_time_type(self) -> str:
        """
        The capacity is scheduled to take effect. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
        """
        return pulumi.get(self, "start_time_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the capacity reservation. value range `All`, `Pending`, `Preparing`, `Prepared`, `Active`, `Released`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeSlot")
    def time_slot(self) -> str:
        """
        This parameter is under test and is not yet open for use.
        """
        return pulumi.get(self, "time_slot")

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Sequence[str]:
        """
        The ID of the zone in the region to which the capacity reservation service belongs. Currently, it is only supported to create a capacity reservation service in one zone.
        """
        return pulumi.get(self, "zone_ids")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        """
        The tag of the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetCommandsCommandResult(dict):
    def __init__(__self__, *,
                 command_content: str,
                 command_id: str,
                 description: str,
                 enable_parameter: bool,
                 id: str,
                 name: str,
                 parameter_names: Sequence[str],
                 timeout: int,
                 type: str,
                 working_dir: str):
        """
        :param str command_content: The Base64-encoded content of the command.
        :param str command_id: The ID of the Command.
        :param str description: The description of command.
        :param bool enable_parameter: Specifies whether to use custom parameters in the command to be created.
        :param str id: The ID of the Command.
        :param str name: The name of the command
        :param Sequence[str] parameter_names: A list of custom parameter names which are parsed from the command content specified when the command was being created.
        :param int timeout: The timeout period that is specified for the command to be run on ECS instances.
        :param str type: The command type.
        :param str working_dir: The execution path of the command in the ECS instance.
        """
        pulumi.set(__self__, "command_content", command_content)
        pulumi.set(__self__, "command_id", command_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enable_parameter", enable_parameter)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameter_names", parameter_names)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter(name="commandContent")
    def command_content(self) -> str:
        """
        The Base64-encoded content of the command.
        """
        return pulumi.get(self, "command_content")

    @property
    @pulumi.getter(name="commandId")
    def command_id(self) -> str:
        """
        The ID of the Command.
        """
        return pulumi.get(self, "command_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of command.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableParameter")
    def enable_parameter(self) -> bool:
        """
        Specifies whether to use custom parameters in the command to be created.
        """
        return pulumi.get(self, "enable_parameter")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Command.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the command
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parameterNames")
    def parameter_names(self) -> Sequence[str]:
        """
        A list of custom parameter names which are parsed from the command content specified when the command was being created.
        """
        return pulumi.get(self, "parameter_names")

    @property
    @pulumi.getter
    def timeout(self) -> int:
        """
        The timeout period that is specified for the command to be run on ECS instances.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The command type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> str:
        """
        The execution path of the command in the ECS instance.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class GetDedicatedHostsHostResult(dict):
    def __init__(__self__, *,
                 action_on_maintenance: str,
                 auto_placement: str,
                 auto_release_time: str,
                 capacities: Sequence['outputs.GetDedicatedHostsHostCapacityResult'],
                 cores: int,
                 cpu_over_commit_ratio: float,
                 dedicated_host_id: str,
                 dedicated_host_name: str,
                 dedicated_host_type: str,
                 description: str,
                 expired_time: str,
                 gpu_spec: str,
                 id: str,
                 machine_id: str,
                 network_attributes: Sequence['outputs.GetDedicatedHostsHostNetworkAttributeResult'],
                 operation_locks: Sequence['outputs.GetDedicatedHostsHostOperationLockResult'],
                 payment_type: str,
                 physical_gpus: int,
                 resource_group_id: str,
                 sale_cycle: str,
                 sockets: int,
                 status: str,
                 supported_custom_instance_type_families: Sequence[str],
                 supported_instance_type_families: Sequence[str],
                 supported_instance_types_lists: Sequence[str],
                 tags: Mapping[str, Any],
                 zone_id: str):
        """
        :param str action_on_maintenance: The policy used to migrate the instances from the dedicated host when the dedicated host fails or needs to be repaired online.
        :param str auto_placement: Specifies whether to add the dedicated host to the resource pool for automatic deployment.
        :param str auto_release_time: The automatic release time of the dedicated host.
        :param Sequence['GetDedicatedHostsHostCapacityArgs'] capacities: (Available in 1.123.1+) A collection of proprietary host performance indicators.
        :param int cores: A mapping of tags to assign to the resource.
        :param float cpu_over_commit_ratio: (Available in 1.123.1+) CPU oversold ratio.
        :param str dedicated_host_id: The ID of ECS Dedicated Host.
        :param str dedicated_host_name: The name of ECS Dedicated Host.
        :param str dedicated_host_type: The type of the dedicated host.
        :param str description: The description of the dedicated host.
        :param str expired_time: The expiration time of the subscription dedicated host.
        :param str gpu_spec: The GPU model.
        :param str id: ID of the ECS Dedicated Host.
        :param str machine_id: The machine code of the dedicated host.
        :param Sequence['GetDedicatedHostsHostNetworkAttributeArgs'] network_attributes: dedicated host network parameters. contains the following attributes:
        :param Sequence['GetDedicatedHostsHostOperationLockArgs'] operation_locks: The reason why the dedicated host resource is locked.
        :param str payment_type: The billing method of the dedicated host.
        :param int physical_gpus: The number of physical GPUs.
        :param str resource_group_id: The ID of the resource group to which the ECS Dedicated Host belongs.
        :param str sale_cycle: The unit of the subscription billing method.
        :param int sockets: The number of physical CPUs.
        :param str status: The status of the ECS Dedicated Host. validate value: `Available`, `Creating`, `PermanentFailure`, `Released`, `UnderAssessment`.
        :param Sequence[str] supported_custom_instance_type_families: (Available in 1.123.1+) A custom instance type family supported by a dedicated host.
        :param Sequence[str] supported_instance_type_families: (Available in 1.123.1+) ECS instance type family supported by the dedicated host.
        :param Sequence[str] supported_instance_types_lists: The list of ECS instance
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        :param str zone_id: The zone ID of the ECS Dedicated Host.
        """
        pulumi.set(__self__, "action_on_maintenance", action_on_maintenance)
        pulumi.set(__self__, "auto_placement", auto_placement)
        pulumi.set(__self__, "auto_release_time", auto_release_time)
        pulumi.set(__self__, "capacities", capacities)
        pulumi.set(__self__, "cores", cores)
        pulumi.set(__self__, "cpu_over_commit_ratio", cpu_over_commit_ratio)
        pulumi.set(__self__, "dedicated_host_id", dedicated_host_id)
        pulumi.set(__self__, "dedicated_host_name", dedicated_host_name)
        pulumi.set(__self__, "dedicated_host_type", dedicated_host_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "gpu_spec", gpu_spec)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "machine_id", machine_id)
        pulumi.set(__self__, "network_attributes", network_attributes)
        pulumi.set(__self__, "operation_locks", operation_locks)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "physical_gpus", physical_gpus)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "sale_cycle", sale_cycle)
        pulumi.set(__self__, "sockets", sockets)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "supported_custom_instance_type_families", supported_custom_instance_type_families)
        pulumi.set(__self__, "supported_instance_type_families", supported_instance_type_families)
        pulumi.set(__self__, "supported_instance_types_lists", supported_instance_types_lists)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="actionOnMaintenance")
    def action_on_maintenance(self) -> str:
        """
        The policy used to migrate the instances from the dedicated host when the dedicated host fails or needs to be repaired online.
        """
        return pulumi.get(self, "action_on_maintenance")

    @property
    @pulumi.getter(name="autoPlacement")
    def auto_placement(self) -> str:
        """
        Specifies whether to add the dedicated host to the resource pool for automatic deployment.
        """
        return pulumi.get(self, "auto_placement")

    @property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> str:
        """
        The automatic release time of the dedicated host.
        """
        return pulumi.get(self, "auto_release_time")

    @property
    @pulumi.getter
    def capacities(self) -> Sequence['outputs.GetDedicatedHostsHostCapacityResult']:
        """
        (Available in 1.123.1+) A collection of proprietary host performance indicators.
        """
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter
    def cores(self) -> int:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "cores")

    @property
    @pulumi.getter(name="cpuOverCommitRatio")
    def cpu_over_commit_ratio(self) -> float:
        """
        (Available in 1.123.1+) CPU oversold ratio.
        """
        return pulumi.get(self, "cpu_over_commit_ratio")

    @property
    @pulumi.getter(name="dedicatedHostId")
    def dedicated_host_id(self) -> str:
        """
        The ID of ECS Dedicated Host.
        """
        return pulumi.get(self, "dedicated_host_id")

    @property
    @pulumi.getter(name="dedicatedHostName")
    def dedicated_host_name(self) -> str:
        """
        The name of ECS Dedicated Host.
        """
        return pulumi.get(self, "dedicated_host_name")

    @property
    @pulumi.getter(name="dedicatedHostType")
    def dedicated_host_type(self) -> str:
        """
        The type of the dedicated host.
        """
        return pulumi.get(self, "dedicated_host_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the dedicated host.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        """
        The expiration time of the subscription dedicated host.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="gpuSpec")
    def gpu_spec(self) -> str:
        """
        The GPU model.
        """
        return pulumi.get(self, "gpu_spec")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the ECS Dedicated Host.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="machineId")
    def machine_id(self) -> str:
        """
        The machine code of the dedicated host.
        """
        return pulumi.get(self, "machine_id")

    @property
    @pulumi.getter(name="networkAttributes")
    def network_attributes(self) -> Sequence['outputs.GetDedicatedHostsHostNetworkAttributeResult']:
        """
        dedicated host network parameters. contains the following attributes:
        """
        return pulumi.get(self, "network_attributes")

    @property
    @pulumi.getter(name="operationLocks")
    def operation_locks(self) -> Sequence['outputs.GetDedicatedHostsHostOperationLockResult']:
        """
        The reason why the dedicated host resource is locked.
        """
        return pulumi.get(self, "operation_locks")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The billing method of the dedicated host.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="physicalGpus")
    def physical_gpus(self) -> int:
        """
        The number of physical GPUs.
        """
        return pulumi.get(self, "physical_gpus")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group to which the ECS Dedicated Host belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="saleCycle")
    def sale_cycle(self) -> str:
        """
        The unit of the subscription billing method.
        """
        return pulumi.get(self, "sale_cycle")

    @property
    @pulumi.getter
    def sockets(self) -> int:
        """
        The number of physical CPUs.
        """
        return pulumi.get(self, "sockets")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the ECS Dedicated Host. validate value: `Available`, `Creating`, `PermanentFailure`, `Released`, `UnderAssessment`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportedCustomInstanceTypeFamilies")
    def supported_custom_instance_type_families(self) -> Sequence[str]:
        """
        (Available in 1.123.1+) A custom instance type family supported by a dedicated host.
        """
        return pulumi.get(self, "supported_custom_instance_type_families")

    @property
    @pulumi.getter(name="supportedInstanceTypeFamilies")
    def supported_instance_type_families(self) -> Sequence[str]:
        """
        (Available in 1.123.1+) ECS instance type family supported by the dedicated host.
        """
        return pulumi.get(self, "supported_instance_type_families")

    @property
    @pulumi.getter(name="supportedInstanceTypesLists")
    def supported_instance_types_lists(self) -> Sequence[str]:
        """
        The list of ECS instance
        """
        return pulumi.get(self, "supported_instance_types_lists")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone ID of the ECS Dedicated Host.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetDedicatedHostsHostCapacityResult(dict):
    def __init__(__self__, *,
                 available_local_storage: int,
                 available_memory: float,
                 available_vcpus: int,
                 available_vgpus: int,
                 local_storage_category: str,
                 total_local_storage: int,
                 total_memory: float,
                 total_vcpus: int,
                 total_vgpus: int):
        """
        :param int available_local_storage: The remaining local disk capacity. Unit: GiB.
        :param float available_memory: The remaining memory capacity, unit: GiB.
        :param int available_vcpus: The number of remaining vCPU cores.
        :param int available_vgpus: The number of available virtual GPUs.
        :param str local_storage_category: Local disk type.
        :param int total_local_storage: The total capacity of the local disk, in GiB.
        :param float total_memory: The total memory capacity, unit: GiB.
        :param int total_vcpus: The total number of vCPU cores.
        :param int total_vgpus: The total number of virtual GPUs.
        """
        pulumi.set(__self__, "available_local_storage", available_local_storage)
        pulumi.set(__self__, "available_memory", available_memory)
        pulumi.set(__self__, "available_vcpus", available_vcpus)
        pulumi.set(__self__, "available_vgpus", available_vgpus)
        pulumi.set(__self__, "local_storage_category", local_storage_category)
        pulumi.set(__self__, "total_local_storage", total_local_storage)
        pulumi.set(__self__, "total_memory", total_memory)
        pulumi.set(__self__, "total_vcpus", total_vcpus)
        pulumi.set(__self__, "total_vgpus", total_vgpus)

    @property
    @pulumi.getter(name="availableLocalStorage")
    def available_local_storage(self) -> int:
        """
        The remaining local disk capacity. Unit: GiB.
        """
        return pulumi.get(self, "available_local_storage")

    @property
    @pulumi.getter(name="availableMemory")
    def available_memory(self) -> float:
        """
        The remaining memory capacity, unit: GiB.
        """
        return pulumi.get(self, "available_memory")

    @property
    @pulumi.getter(name="availableVcpus")
    def available_vcpus(self) -> int:
        """
        The number of remaining vCPU cores.
        """
        return pulumi.get(self, "available_vcpus")

    @property
    @pulumi.getter(name="availableVgpus")
    def available_vgpus(self) -> int:
        """
        The number of available virtual GPUs.
        """
        return pulumi.get(self, "available_vgpus")

    @property
    @pulumi.getter(name="localStorageCategory")
    def local_storage_category(self) -> str:
        """
        Local disk type.
        """
        return pulumi.get(self, "local_storage_category")

    @property
    @pulumi.getter(name="totalLocalStorage")
    def total_local_storage(self) -> int:
        """
        The total capacity of the local disk, in GiB.
        """
        return pulumi.get(self, "total_local_storage")

    @property
    @pulumi.getter(name="totalMemory")
    def total_memory(self) -> float:
        """
        The total memory capacity, unit: GiB.
        """
        return pulumi.get(self, "total_memory")

    @property
    @pulumi.getter(name="totalVcpus")
    def total_vcpus(self) -> int:
        """
        The total number of vCPU cores.
        """
        return pulumi.get(self, "total_vcpus")

    @property
    @pulumi.getter(name="totalVgpus")
    def total_vgpus(self) -> int:
        """
        The total number of virtual GPUs.
        """
        return pulumi.get(self, "total_vgpus")


@pulumi.output_type
class GetDedicatedHostsHostNetworkAttributeResult(dict):
    def __init__(__self__, *,
                 slb_udp_timeout: int,
                 udp_timeout: int):
        """
        :param int slb_udp_timeout: The timeout period for a UDP session between Server Load Balancer (SLB) and the dedicated host. Unit: seconds.
        :param int udp_timeout: (Available in 1.123.1+) The timeout period for a UDP session between a user and an Alibaba Cloud service on the dedicated host. Unit: seconds.
        """
        pulumi.set(__self__, "slb_udp_timeout", slb_udp_timeout)
        pulumi.set(__self__, "udp_timeout", udp_timeout)

    @property
    @pulumi.getter(name="slbUdpTimeout")
    def slb_udp_timeout(self) -> int:
        """
        The timeout period for a UDP session between Server Load Balancer (SLB) and the dedicated host. Unit: seconds.
        """
        return pulumi.get(self, "slb_udp_timeout")

    @property
    @pulumi.getter(name="udpTimeout")
    def udp_timeout(self) -> int:
        """
        (Available in 1.123.1+) The timeout period for a UDP session between a user and an Alibaba Cloud service on the dedicated host. Unit: seconds.
        """
        return pulumi.get(self, "udp_timeout")


@pulumi.output_type
class GetDedicatedHostsHostOperationLockResult(dict):
    def __init__(__self__, *,
                 lock_reason: str):
        """
        :param str lock_reason: The reason why the dedicated host resource is locked.
        """
        pulumi.set(__self__, "lock_reason", lock_reason)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> str:
        """
        The reason why the dedicated host resource is locked.
        """
        return pulumi.get(self, "lock_reason")


@pulumi.output_type
class GetDedicatedHostsOperationLockResult(dict):
    def __init__(__self__, *,
                 lock_reason: Optional[str] = None):
        """
        :param str lock_reason: The reason why the dedicated host resource is locked.
        """
        if lock_reason is not None:
            pulumi.set(__self__, "lock_reason", lock_reason)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> Optional[str]:
        """
        The reason why the dedicated host resource is locked.
        """
        return pulumi.get(self, "lock_reason")


@pulumi.output_type
class GetDisksDiskResult(dict):
    def __init__(__self__, *,
                 attached_time: str,
                 auto_snapshot_policy_id: str,
                 availability_zone: str,
                 category: str,
                 creation_time: str,
                 delete_auto_snapshot: bool,
                 delete_with_instance: bool,
                 description: str,
                 detached_time: str,
                 device: str,
                 disk_id: str,
                 disk_name: str,
                 disk_type: str,
                 enable_auto_snapshot: bool,
                 enable_automated_snapshot_policy: bool,
                 encrypted: str,
                 expired_time: str,
                 id: str,
                 image_id: str,
                 instance_id: str,
                 iops: int,
                 iops_read: int,
                 iops_write: int,
                 kms_key_id: str,
                 mount_instance_num: int,
                 mount_instances: Sequence['outputs.GetDisksDiskMountInstanceResult'],
                 name: str,
                 operation_locks: Sequence['outputs.GetDisksDiskOperationLockResult'],
                 payment_type: str,
                 performance_level: str,
                 portable: bool,
                 product_code: str,
                 region_id: str,
                 resource_group_id: str,
                 size: int,
                 snapshot_id: str,
                 status: str,
                 tags: Mapping[str, Any],
                 type: str,
                 zone_id: str):
        """
        :param str attached_time: Disk attachment time.
        :param str availability_zone: Availability zone of the disk.
        :param str category: Disk category. Possible values: `cloud` (basic cloud disk), `cloud_efficiency` (ultra cloud disk), `ephemeral_ssd` (local SSD cloud disk), `cloud_ssd` (SSD cloud disk), and `cloud_essd` (ESSD cloud disk).
        :param str creation_time: Disk creation time.
        :param str description: Disk description.
        :param str detached_time: Disk detachment time.
        :param str encrypted: Indicate whether the disk is encrypted or not. Possible values: `on` and `off`.
        :param str id: ID of the disk.
        :param str image_id: ID of the image from which the disk is created. It is null unless the disk is created using an image.
        :param str instance_id: Filter the results by the specified ECS instance ID.
        :param str name: Disk name.
        :param str region_id: Region ID the disk belongs to.
        :param str resource_group_id: The Id of resource group which the disk belongs.
        :param int size: Disk size in GiB.
        :param str snapshot_id: Snapshot used to create the disk. It is null if no snapshot is used to create the disk.
        :param str status: Current status. Possible values: `In_use`, `Available`, `Attaching`, `Detaching`, `Creating` and `ReIniting`.
        :param Mapping[str, Any] tags: A map of tags assigned to the disks. It must be in the format:
               ```python
               import pulumi
               import pulumi_alicloud as alicloud
               
               disks_ds = alicloud.ecs.get_disks(tags={
                   "tagKey1": "tagValue1",
                   "tagKey2": "tagValue2",
               })
               ```
        :param str type: Disk type. Possible values: `system` and `data`.
        """
        pulumi.set(__self__, "attached_time", attached_time)
        pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "delete_auto_snapshot", delete_auto_snapshot)
        pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "detached_time", detached_time)
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "enable_auto_snapshot", enable_auto_snapshot)
        pulumi.set(__self__, "enable_automated_snapshot_policy", enable_automated_snapshot_policy)
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "iops", iops)
        pulumi.set(__self__, "iops_read", iops_read)
        pulumi.set(__self__, "iops_write", iops_write)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "mount_instance_num", mount_instance_num)
        pulumi.set(__self__, "mount_instances", mount_instances)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operation_locks", operation_locks)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "performance_level", performance_level)
        pulumi.set(__self__, "portable", portable)
        pulumi.set(__self__, "product_code", product_code)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="attachedTime")
    def attached_time(self) -> str:
        """
        Disk attachment time.
        """
        return pulumi.get(self, "attached_time")

    @property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> str:
        return pulumi.get(self, "auto_snapshot_policy_id")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Availability zone of the disk.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Disk category. Possible values: `cloud` (basic cloud disk), `cloud_efficiency` (ultra cloud disk), `ephemeral_ssd` (local SSD cloud disk), `cloud_ssd` (SSD cloud disk), and `cloud_essd` (ESSD cloud disk).
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Disk creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deleteAutoSnapshot")
    def delete_auto_snapshot(self) -> bool:
        return pulumi.get(self, "delete_auto_snapshot")

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> bool:
        return pulumi.get(self, "delete_with_instance")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Disk description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="detachedTime")
    def detached_time(self) -> str:
        """
        Disk detachment time.
        """
        return pulumi.get(self, "detached_time")

    @property
    @pulumi.getter
    def device(self) -> str:
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> str:
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> str:
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="enableAutoSnapshot")
    def enable_auto_snapshot(self) -> bool:
        return pulumi.get(self, "enable_auto_snapshot")

    @property
    @pulumi.getter(name="enableAutomatedSnapshotPolicy")
    def enable_automated_snapshot_policy(self) -> bool:
        return pulumi.get(self, "enable_automated_snapshot_policy")

    @property
    @pulumi.getter
    def encrypted(self) -> str:
        """
        Indicate whether the disk is encrypted or not. Possible values: `on` and `off`.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the disk.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        ID of the image from which the disk is created. It is null unless the disk is created using an image.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        Filter the results by the specified ECS instance ID.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def iops(self) -> int:
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="iopsRead")
    def iops_read(self) -> int:
        return pulumi.get(self, "iops_read")

    @property
    @pulumi.getter(name="iopsWrite")
    def iops_write(self) -> int:
        return pulumi.get(self, "iops_write")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="mountInstanceNum")
    def mount_instance_num(self) -> int:
        return pulumi.get(self, "mount_instance_num")

    @property
    @pulumi.getter(name="mountInstances")
    def mount_instances(self) -> Sequence['outputs.GetDisksDiskMountInstanceResult']:
        return pulumi.get(self, "mount_instances")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operationLocks")
    def operation_locks(self) -> Sequence['outputs.GetDisksDiskOperationLockResult']:
        return pulumi.get(self, "operation_locks")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> str:
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter
    def portable(self) -> bool:
        return pulumi.get(self, "portable")

    @property
    @pulumi.getter(name="productCode")
    def product_code(self) -> str:
        return pulumi.get(self, "product_code")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        Region ID the disk belongs to.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which the disk belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Disk size in GiB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> str:
        """
        Snapshot used to create the disk. It is null if no snapshot is used to create the disk.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status. Possible values: `In_use`, `Available`, `Attaching`, `Detaching`, `Creating` and `ReIniting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A map of tags assigned to the disks. It must be in the format:
        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        disks_ds = alicloud.ecs.get_disks(tags={
            "tagKey1": "tagValue1",
            "tagKey2": "tagValue2",
        })
        ```
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Disk type. Possible values: `system` and `data`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetDisksDiskMountInstanceResult(dict):
    def __init__(__self__, *,
                 attached_time: str,
                 device: str,
                 instance_id: str):
        """
        :param str attached_time: Disk attachment time.
        :param str instance_id: Filter the results by the specified ECS instance ID.
        """
        pulumi.set(__self__, "attached_time", attached_time)
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="attachedTime")
    def attached_time(self) -> str:
        """
        Disk attachment time.
        """
        return pulumi.get(self, "attached_time")

    @property
    @pulumi.getter
    def device(self) -> str:
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        Filter the results by the specified ECS instance ID.
        """
        return pulumi.get(self, "instance_id")


@pulumi.output_type
class GetDisksDiskOperationLockResult(dict):
    def __init__(__self__, *,
                 lock_reason: str):
        pulumi.set(__self__, "lock_reason", lock_reason)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> str:
        return pulumi.get(self, "lock_reason")


@pulumi.output_type
class GetDisksOperationLockResult(dict):
    def __init__(__self__, *,
                 lock_reason: Optional[str] = None):
        if lock_reason is not None:
            pulumi.set(__self__, "lock_reason", lock_reason)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> Optional[str]:
        return pulumi.get(self, "lock_reason")


@pulumi.output_type
class GetEcsDedicatedHostClustersClusterResult(dict):
    def __init__(__self__, *,
                 dedicated_host_cluster_capacities: Sequence['outputs.GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacityResult'],
                 dedicated_host_cluster_id: str,
                 dedicated_host_cluster_name: str,
                 dedicated_host_ids: Sequence[str],
                 description: str,
                 id: str,
                 resource_group_id: str,
                 tags: Mapping[str, Any],
                 zone_id: str):
        """
        :param Sequence['GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacityArgs'] dedicated_host_cluster_capacities: The capacity of the dedicated host cluster.
        :param str dedicated_host_cluster_id: The ID of the dedicated host cluster.
        :param str dedicated_host_cluster_name: The name of the dedicated host cluster.
        :param Sequence[str] dedicated_host_ids: The IDs of dedicated hosts in the dedicated host cluster.
        :param str description: The description of the dedicated host cluster.
        :param str id: The ID of the Dedicated Host Cluster.
        :param str resource_group_id: The ID of the resource group to which the dedicated host cluster belongs.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        :param str zone_id: The zone ID of the dedicated host cluster.
        """
        pulumi.set(__self__, "dedicated_host_cluster_capacities", dedicated_host_cluster_capacities)
        pulumi.set(__self__, "dedicated_host_cluster_id", dedicated_host_cluster_id)
        pulumi.set(__self__, "dedicated_host_cluster_name", dedicated_host_cluster_name)
        pulumi.set(__self__, "dedicated_host_ids", dedicated_host_ids)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="dedicatedHostClusterCapacities")
    def dedicated_host_cluster_capacities(self) -> Sequence['outputs.GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacityResult']:
        """
        The capacity of the dedicated host cluster.
        """
        return pulumi.get(self, "dedicated_host_cluster_capacities")

    @property
    @pulumi.getter(name="dedicatedHostClusterId")
    def dedicated_host_cluster_id(self) -> str:
        """
        The ID of the dedicated host cluster.
        """
        return pulumi.get(self, "dedicated_host_cluster_id")

    @property
    @pulumi.getter(name="dedicatedHostClusterName")
    def dedicated_host_cluster_name(self) -> str:
        """
        The name of the dedicated host cluster.
        """
        return pulumi.get(self, "dedicated_host_cluster_name")

    @property
    @pulumi.getter(name="dedicatedHostIds")
    def dedicated_host_ids(self) -> Sequence[str]:
        """
        The IDs of dedicated hosts in the dedicated host cluster.
        """
        return pulumi.get(self, "dedicated_host_ids")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the dedicated host cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Dedicated Host Cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group to which the dedicated host cluster belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone ID of the dedicated host cluster.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacityResult(dict):
    def __init__(__self__, *,
                 available_memory: int,
                 available_vcpus: int,
                 local_storage_capacities: Sequence['outputs.GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacityLocalStorageCapacityResult'],
                 total_memory: int,
                 total_vcpus: int):
        """
        :param int available_memory: The available memory size. Unit: `GiB`.
        :param int available_vcpus: The number of available vCPUs.
        :param Sequence['GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacityLocalStorageCapacityArgs'] local_storage_capacities: The local storage.
        :param int total_memory: The total memory size. Unit: `GiB`.
        :param int total_vcpus: The total number of vCPUs.
        """
        pulumi.set(__self__, "available_memory", available_memory)
        pulumi.set(__self__, "available_vcpus", available_vcpus)
        pulumi.set(__self__, "local_storage_capacities", local_storage_capacities)
        pulumi.set(__self__, "total_memory", total_memory)
        pulumi.set(__self__, "total_vcpus", total_vcpus)

    @property
    @pulumi.getter(name="availableMemory")
    def available_memory(self) -> int:
        """
        The available memory size. Unit: `GiB`.
        """
        return pulumi.get(self, "available_memory")

    @property
    @pulumi.getter(name="availableVcpus")
    def available_vcpus(self) -> int:
        """
        The number of available vCPUs.
        """
        return pulumi.get(self, "available_vcpus")

    @property
    @pulumi.getter(name="localStorageCapacities")
    def local_storage_capacities(self) -> Sequence['outputs.GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacityLocalStorageCapacityResult']:
        """
        The local storage.
        """
        return pulumi.get(self, "local_storage_capacities")

    @property
    @pulumi.getter(name="totalMemory")
    def total_memory(self) -> int:
        """
        The total memory size. Unit: `GiB`.
        """
        return pulumi.get(self, "total_memory")

    @property
    @pulumi.getter(name="totalVcpus")
    def total_vcpus(self) -> int:
        """
        The total number of vCPUs.
        """
        return pulumi.get(self, "total_vcpus")


@pulumi.output_type
class GetEcsDedicatedHostClustersClusterDedicatedHostClusterCapacityLocalStorageCapacityResult(dict):
    def __init__(__self__, *,
                 available_disk: int,
                 data_disk_category: str,
                 total_disk: int):
        """
        :param int available_disk: The available capacity of the local disk. Unit: `GiB`.
        :param str data_disk_category: The category of the data disk. Valid values:`cloud`, `cloud_efficiency`, `cloud_ssd`, `ephemeral_ssd`, `cloud_essd`.
        :param int total_disk: The total capacity of the local disk. Unit: `GiB`.
        """
        pulumi.set(__self__, "available_disk", available_disk)
        pulumi.set(__self__, "data_disk_category", data_disk_category)
        pulumi.set(__self__, "total_disk", total_disk)

    @property
    @pulumi.getter(name="availableDisk")
    def available_disk(self) -> int:
        """
        The available capacity of the local disk. Unit: `GiB`.
        """
        return pulumi.get(self, "available_disk")

    @property
    @pulumi.getter(name="dataDiskCategory")
    def data_disk_category(self) -> str:
        """
        The category of the data disk. Valid values:`cloud`, `cloud_efficiency`, `cloud_ssd`, `ephemeral_ssd`, `cloud_essd`.
        """
        return pulumi.get(self, "data_disk_category")

    @property
    @pulumi.getter(name="totalDisk")
    def total_disk(self) -> int:
        """
        The total capacity of the local disk. Unit: `GiB`.
        """
        return pulumi.get(self, "total_disk")


@pulumi.output_type
class GetEcsDeploymentSetsSetResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 deployment_set_id: str,
                 deployment_set_name: str,
                 description: str,
                 domain: str,
                 granularity: str,
                 id: str,
                 instance_amount: int,
                 instance_ids: Sequence[str],
                 strategy: str):
        """
        :param str create_time: The time when the deployment set was created.
        :param str deployment_set_id: The ID of the Deployment Set.
        :param str deployment_set_name: The name of the deployment set.
        :param str description: The description of the deployment set.
        :param str domain: The deployment domain.
        :param str granularity: The deployment granularity.
        :param str id: The ID of the Deployment Set.
        :param int instance_amount: The number of instances in the deployment set.
        :param Sequence[str] instance_ids: The IDs of the instances in the deployment set.
        :param str strategy: The deployment strategy.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        pulumi.set(__self__, "deployment_set_name", deployment_set_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "granularity", granularity)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_amount", instance_amount)
        pulumi.set(__self__, "instance_ids", instance_ids)
        pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the deployment set was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> str:
        """
        The ID of the Deployment Set.
        """
        return pulumi.get(self, "deployment_set_id")

    @property
    @pulumi.getter(name="deploymentSetName")
    def deployment_set_name(self) -> str:
        """
        The name of the deployment set.
        """
        return pulumi.get(self, "deployment_set_name")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the deployment set.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The deployment domain.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def granularity(self) -> str:
        """
        The deployment granularity.
        """
        return pulumi.get(self, "granularity")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Deployment Set.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceAmount")
    def instance_amount(self) -> int:
        """
        The number of instances in the deployment set.
        """
        return pulumi.get(self, "instance_amount")

    @property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> Sequence[str]:
        """
        The IDs of the instances in the deployment set.
        """
        return pulumi.get(self, "instance_ids")

    @property
    @pulumi.getter
    def strategy(self) -> str:
        """
        The deployment strategy.
        """
        return pulumi.get(self, "strategy")


@pulumi.output_type
class GetEcsDisksDiskResult(dict):
    def __init__(__self__, *,
                 attached_time: str,
                 auto_snapshot_policy_id: str,
                 availability_zone: str,
                 category: str,
                 creation_time: str,
                 delete_auto_snapshot: bool,
                 delete_with_instance: bool,
                 description: str,
                 detached_time: str,
                 device: str,
                 disk_id: str,
                 disk_name: str,
                 disk_type: str,
                 enable_auto_snapshot: bool,
                 enable_automated_snapshot_policy: bool,
                 encrypted: str,
                 expired_time: str,
                 id: str,
                 image_id: str,
                 instance_id: str,
                 iops: int,
                 iops_read: int,
                 iops_write: int,
                 kms_key_id: str,
                 mount_instance_num: int,
                 mount_instances: Sequence['outputs.GetEcsDisksDiskMountInstanceResult'],
                 name: str,
                 operation_locks: Sequence['outputs.GetEcsDisksDiskOperationLockResult'],
                 payment_type: str,
                 performance_level: str,
                 portable: bool,
                 product_code: str,
                 region_id: str,
                 resource_group_id: str,
                 size: int,
                 snapshot_id: str,
                 status: str,
                 tags: Mapping[str, Any],
                 type: str,
                 zone_id: str):
        """
        :param str attached_time: A mount of time.
        :param str auto_snapshot_policy_id: Query cloud disks based on the automatic snapshot policy ID.
        :param str availability_zone: Availability zone of the disk.
        :param str category: Disk category.
        :param str creation_time: Disk creation time.
        :param bool delete_auto_snapshot: Indicates whether the automatic snapshot is deleted when the disk is released.
        :param bool delete_with_instance: Indicates whether the disk is released together with the instance.
        :param str description: Disk description.
        :param str detached_time: Disk detachment time.
        :param str device: The mount point of the disk.
        :param str disk_id: ID of the disk.
        :param str disk_name: The disk name.
        :param str disk_type: The disk type.
        :param bool enable_auto_snapshot: Whether the disk implements an automatic snapshot policy.
        :param bool enable_automated_snapshot_policy: Whether the disk implements an automatic snapshot policy.
        :param str encrypted: Indicate whether the disk is encrypted or not.
        :param str id: ID of the disk.
        :param str image_id: ID of the image from which the disk is created. It is null unless the disk is created using an image.
        :param str instance_id: The instance ID of the disk mount.
        :param str kms_key_id: The kms key id.
        :param int mount_instance_num: Number of instances mounted on shared storage.
        :param Sequence['GetEcsDisksDiskMountInstanceArgs'] mount_instances: Disk mount instances.
        :param str name: Disk name.
        :param str payment_type: Payment method for disk.
        :param str performance_level: Performance levels of ESSD cloud disk.
        :param bool portable: Whether the disk is unmountable.
        :param str product_code: The product logo of the cloud market.
        :param str region_id: Region ID the disk belongs to.
        :param str resource_group_id: The Id of resource group.
        :param int size: Disk size in GiB.
        :param str snapshot_id: Snapshot used to create the disk. It is null if no snapshot is used to create the disk.
        :param str status: Current status.
        :param Mapping[str, Any] tags: A map of tags assigned to the disk.
        :param str type: Disk type.
        :param str zone_id: The zone id.
        """
        pulumi.set(__self__, "attached_time", attached_time)
        pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "delete_auto_snapshot", delete_auto_snapshot)
        pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "detached_time", detached_time)
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "enable_auto_snapshot", enable_auto_snapshot)
        pulumi.set(__self__, "enable_automated_snapshot_policy", enable_automated_snapshot_policy)
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "iops", iops)
        pulumi.set(__self__, "iops_read", iops_read)
        pulumi.set(__self__, "iops_write", iops_write)
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        pulumi.set(__self__, "mount_instance_num", mount_instance_num)
        pulumi.set(__self__, "mount_instances", mount_instances)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operation_locks", operation_locks)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "performance_level", performance_level)
        pulumi.set(__self__, "portable", portable)
        pulumi.set(__self__, "product_code", product_code)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="attachedTime")
    def attached_time(self) -> str:
        """
        A mount of time.
        """
        return pulumi.get(self, "attached_time")

    @property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> str:
        """
        Query cloud disks based on the automatic snapshot policy ID.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Availability zone of the disk.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Disk category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Disk creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deleteAutoSnapshot")
    def delete_auto_snapshot(self) -> bool:
        """
        Indicates whether the automatic snapshot is deleted when the disk is released.
        """
        return pulumi.get(self, "delete_auto_snapshot")

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> bool:
        """
        Indicates whether the disk is released together with the instance.
        """
        return pulumi.get(self, "delete_with_instance")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Disk description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="detachedTime")
    def detached_time(self) -> str:
        """
        Disk detachment time.
        """
        return pulumi.get(self, "detached_time")

    @property
    @pulumi.getter
    def device(self) -> str:
        """
        The mount point of the disk.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> str:
        """
        ID of the disk.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> str:
        """
        The disk name.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        The disk type.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="enableAutoSnapshot")
    def enable_auto_snapshot(self) -> bool:
        """
        Whether the disk implements an automatic snapshot policy.
        """
        return pulumi.get(self, "enable_auto_snapshot")

    @property
    @pulumi.getter(name="enableAutomatedSnapshotPolicy")
    def enable_automated_snapshot_policy(self) -> bool:
        """
        Whether the disk implements an automatic snapshot policy.
        """
        return pulumi.get(self, "enable_automated_snapshot_policy")

    @property
    @pulumi.getter
    def encrypted(self) -> str:
        """
        Indicate whether the disk is encrypted or not.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the disk.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        ID of the image from which the disk is created. It is null unless the disk is created using an image.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The instance ID of the disk mount.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def iops(self) -> int:
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="iopsRead")
    def iops_read(self) -> int:
        return pulumi.get(self, "iops_read")

    @property
    @pulumi.getter(name="iopsWrite")
    def iops_write(self) -> int:
        return pulumi.get(self, "iops_write")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The kms key id.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="mountInstanceNum")
    def mount_instance_num(self) -> int:
        """
        Number of instances mounted on shared storage.
        """
        return pulumi.get(self, "mount_instance_num")

    @property
    @pulumi.getter(name="mountInstances")
    def mount_instances(self) -> Sequence['outputs.GetEcsDisksDiskMountInstanceResult']:
        """
        Disk mount instances.
        """
        return pulumi.get(self, "mount_instances")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operationLocks")
    def operation_locks(self) -> Sequence['outputs.GetEcsDisksDiskOperationLockResult']:
        return pulumi.get(self, "operation_locks")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        Payment method for disk.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> str:
        """
        Performance levels of ESSD cloud disk.
        """
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter
    def portable(self) -> bool:
        """
        Whether the disk is unmountable.
        """
        return pulumi.get(self, "portable")

    @property
    @pulumi.getter(name="productCode")
    def product_code(self) -> str:
        """
        The product logo of the cloud market.
        """
        return pulumi.get(self, "product_code")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        Region ID the disk belongs to.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Disk size in GiB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> str:
        """
        Snapshot used to create the disk. It is null if no snapshot is used to create the disk.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A map of tags assigned to the disk.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Disk type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone id.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetEcsDisksDiskMountInstanceResult(dict):
    def __init__(__self__, *,
                 attached_time: str,
                 device: str,
                 instance_id: str):
        """
        :param str attached_time: A mount of time.
        :param str device: The mount point of the disk.
        :param str instance_id: The instance ID of the disk mount.
        """
        pulumi.set(__self__, "attached_time", attached_time)
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="attachedTime")
    def attached_time(self) -> str:
        """
        A mount of time.
        """
        return pulumi.get(self, "attached_time")

    @property
    @pulumi.getter
    def device(self) -> str:
        """
        The mount point of the disk.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The instance ID of the disk mount.
        """
        return pulumi.get(self, "instance_id")


@pulumi.output_type
class GetEcsDisksDiskOperationLockResult(dict):
    def __init__(__self__, *,
                 lock_reason: str):
        pulumi.set(__self__, "lock_reason", lock_reason)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> str:
        return pulumi.get(self, "lock_reason")


@pulumi.output_type
class GetEcsDisksOperationLockResult(dict):
    def __init__(__self__, *,
                 lock_reason: Optional[str] = None):
        if lock_reason is not None:
            pulumi.set(__self__, "lock_reason", lock_reason)

    @property
    @pulumi.getter(name="lockReason")
    def lock_reason(self) -> Optional[str]:
        return pulumi.get(self, "lock_reason")


@pulumi.output_type
class GetEcsImageComponentsComponentResult(dict):
    def __init__(__self__, *,
                 component_type: str,
                 content: str,
                 create_time: str,
                 description: str,
                 id: str,
                 image_component_id: str,
                 image_component_name: str,
                 owner: str,
                 resource_group_id: str,
                 system_type: str,
                 tags: Mapping[str, Any]):
        """
        :param str component_type: The type of the image component.
        :param str content: The content of the image component.
        :param str create_time: The time when the image component was created.
        :param str description: The description of the image component.
        :param str id: The ID of the Image Component.
        :param str image_component_id: The ID of the image component.
        :param str image_component_name: The name of the image component.
        :param str owner: The type of the image component.
        :param str resource_group_id: The ID of the resource group.
        :param str system_type: The operating system type supported by the image component.
        :param Mapping[str, Any] tags: List of label key-value pairs.
        """
        pulumi.set(__self__, "component_type", component_type)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_component_id", image_component_id)
        pulumi.set(__self__, "image_component_name", image_component_name)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "system_type", system_type)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="componentType")
    def component_type(self) -> str:
        """
        The type of the image component.
        """
        return pulumi.get(self, "component_type")

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The content of the image component.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the image component was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the image component.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Image Component.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageComponentId")
    def image_component_id(self) -> str:
        """
        The ID of the image component.
        """
        return pulumi.get(self, "image_component_id")

    @property
    @pulumi.getter(name="imageComponentName")
    def image_component_name(self) -> str:
        """
        The name of the image component.
        """
        return pulumi.get(self, "image_component_name")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        The type of the image component.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> str:
        """
        The operating system type supported by the image component.
        """
        return pulumi.get(self, "system_type")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        List of label key-value pairs.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetEcsImagePipelinePipelineResult(dict):
    def __init__(__self__, *,
                 add_accounts: Sequence[str],
                 base_image: str,
                 base_image_type: str,
                 build_content: str,
                 creation_time: str,
                 delete_instance_on_failure: bool,
                 description: str,
                 id: str,
                 image_name: str,
                 image_pipeline_id: str,
                 instance_type: str,
                 internet_max_bandwidth_out: int,
                 name: str,
                 resource_group_id: str,
                 system_disk_size: int,
                 to_region_ids: Sequence[str],
                 vswitch_id: str,
                 tags: Optional[Mapping[str, Any]] = None):
        """
        :param Sequence[str] add_accounts: The IDs of Alibaba Cloud accounts to which the image was shared.
        :param str base_image: The source image.
        :param str base_image_type: The type of the source image.
        :param str build_content: The content of the image template.
        :param str creation_time: The time when the image template was created.
        :param bool delete_instance_on_failure: Indicates whether the intermediate instance was released when the image failed to be created.
        :param str description: The description of the image template.
        :param str id: The ID of the Image Pipeline.
        :param str image_name: The name prefix of the created image.
        :param str image_pipeline_id: The ID of the image template.
        :param str instance_type: The instance type of the intermediate instance.
        :param int internet_max_bandwidth_out: The size of the outbound public bandwidth for the intermediate instance. Unit: `Mbit/s`.
        :param str name: The name of the image template.
        :param str resource_group_id: The ID of the resource group to which the image template belongs.
        :param int system_disk_size: The system disk size of the intermediate instance. Unit: `GiB`.
        :param Sequence[str] to_region_ids: The IDs of regions to which to distribute the created image.
        :param str vswitch_id: The vswitch id.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "add_accounts", add_accounts)
        pulumi.set(__self__, "base_image", base_image)
        pulumi.set(__self__, "base_image_type", base_image_type)
        pulumi.set(__self__, "build_content", build_content)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "delete_instance_on_failure", delete_instance_on_failure)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_name", image_name)
        pulumi.set(__self__, "image_pipeline_id", image_pipeline_id)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "system_disk_size", system_disk_size)
        pulumi.set(__self__, "to_region_ids", to_region_ids)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addAccounts")
    def add_accounts(self) -> Sequence[str]:
        """
        The IDs of Alibaba Cloud accounts to which the image was shared.
        """
        return pulumi.get(self, "add_accounts")

    @property
    @pulumi.getter(name="baseImage")
    def base_image(self) -> str:
        """
        The source image.
        """
        return pulumi.get(self, "base_image")

    @property
    @pulumi.getter(name="baseImageType")
    def base_image_type(self) -> str:
        """
        The type of the source image.
        """
        return pulumi.get(self, "base_image_type")

    @property
    @pulumi.getter(name="buildContent")
    def build_content(self) -> str:
        """
        The content of the image template.
        """
        return pulumi.get(self, "build_content")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The time when the image template was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deleteInstanceOnFailure")
    def delete_instance_on_failure(self) -> bool:
        """
        Indicates whether the intermediate instance was released when the image failed to be created.
        """
        return pulumi.get(self, "delete_instance_on_failure")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the image template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Image Pipeline.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The name prefix of the created image.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="imagePipelineId")
    def image_pipeline_id(self) -> str:
        """
        The ID of the image template.
        """
        return pulumi.get(self, "image_pipeline_id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The instance type of the intermediate instance.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> int:
        """
        The size of the outbound public bandwidth for the intermediate instance. Unit: `Mbit/s`.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the image template.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group to which the image template belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> int:
        """
        The system disk size of the intermediate instance. Unit: `GiB`.
        """
        return pulumi.get(self, "system_disk_size")

    @property
    @pulumi.getter(name="toRegionIds")
    def to_region_ids(self) -> Sequence[str]:
        """
        The IDs of regions to which to distribute the created image.
        """
        return pulumi.get(self, "to_region_ids")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetEcsInvocationsInvocationResult(dict):
    def __init__(__self__, *,
                 command_content: str,
                 command_id: str,
                 command_name: str,
                 command_type: str,
                 create_time: str,
                 frequency: str,
                 id: str,
                 invocation_id: str,
                 invocation_status: str,
                 invoke_instances: Sequence['outputs.GetEcsInvocationsInvocationInvokeInstanceResult'],
                 invoke_status: str,
                 parameters: str,
                 repeat_mode: str,
                 timed: bool,
                 username: str):
        """
        :param str command_content: The Base64-encoded command content.
        :param str command_id: The ID of the command.
        :param str command_name: The name of the command.
        :param str command_type: The type of the command.
        :param str create_time: The creation time of the resource.
        :param str frequency: The schedule on which the recurring execution of the command takes place. For information about the value specifications, see [Cron expression](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/cron-expression).
        :param str id: The ID of the Invocation.
        :param str invocation_id: The ID of the Invocation.
        :param str invocation_status: The execution state on a single instance. Valid values: `Pending`, `Scheduled`, `Running`, `Success`, `Failed`, `Stopping`, `Stopped`, `PartialFailed`.
        :param Sequence['GetEcsInvocationsInvocationInvokeInstanceArgs'] invoke_instances: Execute target instance set type.
        :param str invoke_status: The overall execution state of the command. **Note:** We recommend that you ignore this parameter and check the value of the `invocation_status` response parameter for the overall execution state.
        :param str parameters: The custom parameters in the command.
        :param str repeat_mode: Indicates the execution mode of the command.
        :param bool timed: Indicates whether the commands are to be automatically run.
               * `error_code	` - The code that indicates why the command failed to be sent or run.
               * `instance_invoke_status	` - **Note:** We recommend that you ignore this parameter and check the value of the `invocation_status` response parameter for the overall execution state.
        :param str username: The username that was used to run the command on the instance.
        """
        pulumi.set(__self__, "command_content", command_content)
        pulumi.set(__self__, "command_id", command_id)
        pulumi.set(__self__, "command_name", command_name)
        pulumi.set(__self__, "command_type", command_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "invocation_id", invocation_id)
        pulumi.set(__self__, "invocation_status", invocation_status)
        pulumi.set(__self__, "invoke_instances", invoke_instances)
        pulumi.set(__self__, "invoke_status", invoke_status)
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "repeat_mode", repeat_mode)
        pulumi.set(__self__, "timed", timed)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="commandContent")
    def command_content(self) -> str:
        """
        The Base64-encoded command content.
        """
        return pulumi.get(self, "command_content")

    @property
    @pulumi.getter(name="commandId")
    def command_id(self) -> str:
        """
        The ID of the command.
        """
        return pulumi.get(self, "command_id")

    @property
    @pulumi.getter(name="commandName")
    def command_name(self) -> str:
        """
        The name of the command.
        """
        return pulumi.get(self, "command_name")

    @property
    @pulumi.getter(name="commandType")
    def command_type(self) -> str:
        """
        The type of the command.
        """
        return pulumi.get(self, "command_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def frequency(self) -> str:
        """
        The schedule on which the recurring execution of the command takes place. For information about the value specifications, see [Cron expression](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/cron-expression).
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Invocation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="invocationId")
    def invocation_id(self) -> str:
        """
        The ID of the Invocation.
        """
        return pulumi.get(self, "invocation_id")

    @property
    @pulumi.getter(name="invocationStatus")
    def invocation_status(self) -> str:
        """
        The execution state on a single instance. Valid values: `Pending`, `Scheduled`, `Running`, `Success`, `Failed`, `Stopping`, `Stopped`, `PartialFailed`.
        """
        return pulumi.get(self, "invocation_status")

    @property
    @pulumi.getter(name="invokeInstances")
    def invoke_instances(self) -> Sequence['outputs.GetEcsInvocationsInvocationInvokeInstanceResult']:
        """
        Execute target instance set type.
        """
        return pulumi.get(self, "invoke_instances")

    @property
    @pulumi.getter(name="invokeStatus")
    def invoke_status(self) -> str:
        """
        The overall execution state of the command. **Note:** We recommend that you ignore this parameter and check the value of the `invocation_status` response parameter for the overall execution state.
        """
        return pulumi.get(self, "invoke_status")

    @property
    @pulumi.getter
    def parameters(self) -> str:
        """
        The custom parameters in the command.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="repeatMode")
    def repeat_mode(self) -> str:
        """
        Indicates the execution mode of the command.
        """
        return pulumi.get(self, "repeat_mode")

    @property
    @pulumi.getter
    def timed(self) -> bool:
        """
        Indicates whether the commands are to be automatically run.
        * `error_code	` - The code that indicates why the command failed to be sent or run.
        * `instance_invoke_status	` - **Note:** We recommend that you ignore this parameter and check the value of the `invocation_status` response parameter for the overall execution state.
        """
        return pulumi.get(self, "timed")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        The username that was used to run the command on the instance.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetEcsInvocationsInvocationInvokeInstanceResult(dict):
    def __init__(__self__, *,
                 creation_time: str,
                 dropped: int,
                 error_code: str,
                 error_info: str,
                 exit_code: int,
                 finish_time: str,
                 instance_id: str,
                 instance_invoke_status: str,
                 invocation_status: str,
                 output: str,
                 repeats: int,
                 start_time: str,
                 stop_time: str,
                 timed: bool,
                 update_time: str):
        """
        :param str creation_time: The start time of the execution.
        :param int dropped: The size of truncated and discarded text when the value of the Output response parameter exceeds 24 KB in size.
        :param str error_info: Details about the reason why the command failed to be sent or run.
        :param int exit_code: The exit code of the execution.
        :param str finish_time: The end time of the execution.
        :param str instance_id: The ID of the instance.
        :param str invocation_status: The execution state on a single instance. Valid values: `Pending`, `Scheduled`, `Running`, `Success`, `Failed`, `Stopping`, `Stopped`, `PartialFailed`.
        :param str output: The output of the command.
        :param int repeats: The number of times that the command is run on the instance.
        :param str start_time: The time when the command started to be run on the instance.
        :param str stop_time: The time when the command stopped being run on the instance. If you call the StopInvocation operation to manually stop the execution, the value is the time when you call the operation.
        :param bool timed: Indicates whether the commands are to be automatically run.
               * `error_code	` - The code that indicates why the command failed to be sent or run.
               * `instance_invoke_status	` - **Note:** We recommend that you ignore this parameter and check the value of the `invocation_status` response parameter for the overall execution state.
        :param str update_time: The time when the execution state was updated.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "dropped", dropped)
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "error_info", error_info)
        pulumi.set(__self__, "exit_code", exit_code)
        pulumi.set(__self__, "finish_time", finish_time)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_invoke_status", instance_invoke_status)
        pulumi.set(__self__, "invocation_status", invocation_status)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "repeats", repeats)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "stop_time", stop_time)
        pulumi.set(__self__, "timed", timed)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The start time of the execution.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def dropped(self) -> int:
        """
        The size of truncated and discarded text when the value of the Output response parameter exceeds 24 KB in size.
        """
        return pulumi.get(self, "dropped")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> str:
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorInfo")
    def error_info(self) -> str:
        """
        Details about the reason why the command failed to be sent or run.
        """
        return pulumi.get(self, "error_info")

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> int:
        """
        The exit code of the execution.
        """
        return pulumi.get(self, "exit_code")

    @property
    @pulumi.getter(name="finishTime")
    def finish_time(self) -> str:
        """
        The end time of the execution.
        """
        return pulumi.get(self, "finish_time")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceInvokeStatus")
    def instance_invoke_status(self) -> str:
        return pulumi.get(self, "instance_invoke_status")

    @property
    @pulumi.getter(name="invocationStatus")
    def invocation_status(self) -> str:
        """
        The execution state on a single instance. Valid values: `Pending`, `Scheduled`, `Running`, `Success`, `Failed`, `Stopping`, `Stopped`, `PartialFailed`.
        """
        return pulumi.get(self, "invocation_status")

    @property
    @pulumi.getter
    def output(self) -> str:
        """
        The output of the command.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def repeats(self) -> int:
        """
        The number of times that the command is run on the instance.
        """
        return pulumi.get(self, "repeats")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The time when the command started to be run on the instance.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> str:
        """
        The time when the command stopped being run on the instance. If you call the StopInvocation operation to manually stop the execution, the value is the time when you call the operation.
        """
        return pulumi.get(self, "stop_time")

    @property
    @pulumi.getter
    def timed(self) -> bool:
        """
        Indicates whether the commands are to be automatically run.
        * `error_code	` - The code that indicates why the command failed to be sent or run.
        * `instance_invoke_status	` - **Note:** We recommend that you ignore this parameter and check the value of the `invocation_status` response parameter for the overall execution state.
        """
        return pulumi.get(self, "timed")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The time when the execution state was updated.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GetEcsKeyPairsKeyPairResult(dict):
    def __init__(__self__, *,
                 finger_print: str,
                 id: str,
                 instances: Sequence['outputs.GetEcsKeyPairsKeyPairInstanceResult'],
                 key_name: str,
                 key_pair_name: str,
                 resource_group_id: str,
                 tags: Mapping[str, Any]):
        """
        :param str finger_print: The finger print of the key pair.
        :param str id: The ID of the Key Pair.
        :param Sequence['GetEcsKeyPairsKeyPairInstanceArgs'] instances: A list of ECS instances that has been bound this key pair.
        :param str key_name: The Key Pair Name.
        :param str resource_group_id: The Resource Group Id.
        :param Mapping[str, Any] tags: The tags.
        """
        pulumi.set(__self__, "finger_print", finger_print)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="fingerPrint")
    def finger_print(self) -> str:
        """
        The finger print of the key pair.
        """
        return pulumi.get(self, "finger_print")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Key Pair.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetEcsKeyPairsKeyPairInstanceResult']:
        """
        A list of ECS instances that has been bound this key pair.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        The Key Pair Name.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> str:
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Resource Group Id.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        The tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetEcsKeyPairsKeyPairInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 description: str,
                 image_id: str,
                 instance_id: str,
                 instance_name: str,
                 instance_type: str,
                 key_name: str,
                 private_ip: str,
                 public_ip: str,
                 region_id: str,
                 status: str,
                 vswitch_id: str):
        """
        :param str availability_zone: The ID of the availability zone where the ECS instance is located.
        :param str instance_id: The ID of the ECS instance.
        :param str instance_name: The name of the ECS instance.
        :param str key_name: The Key Pair Name.
        :param str private_ip: The private IP address of the ECS instance.
        :param str public_ip: The public IP address or EIP of the ECS instance.
        :param str vswitch_id: The ID of the VSwitch attached to the ECS instance.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        The ID of the availability zone where the ECS instance is located.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of the ECS instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        The Key Pair Name.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address of the ECS instance.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        The public IP address or EIP of the ECS instance.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The ID of the VSwitch attached to the ECS instance.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetEcsKeyPairsPairResult(dict):
    def __init__(__self__, *,
                 finger_print: str,
                 id: str,
                 instances: Sequence['outputs.GetEcsKeyPairsPairInstanceResult'],
                 key_name: str,
                 key_pair_name: str,
                 resource_group_id: str,
                 tags: Mapping[str, Any]):
        """
        :param str finger_print: The finger print of the key pair.
        :param str id: The ID of the Key Pair.
        :param Sequence['GetEcsKeyPairsPairInstanceArgs'] instances: A list of ECS instances that has been bound this key pair.
        :param str key_name: The Key Pair Name.
        :param str resource_group_id: The Resource Group Id.
        :param Mapping[str, Any] tags: The tags.
        """
        pulumi.set(__self__, "finger_print", finger_print)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="fingerPrint")
    def finger_print(self) -> str:
        """
        The finger print of the key pair.
        """
        return pulumi.get(self, "finger_print")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Key Pair.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetEcsKeyPairsPairInstanceResult']:
        """
        A list of ECS instances that has been bound this key pair.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        The Key Pair Name.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> str:
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Resource Group Id.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        The tags.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetEcsKeyPairsPairInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 description: str,
                 image_id: str,
                 instance_id: str,
                 instance_name: str,
                 instance_type: str,
                 key_name: str,
                 private_ip: str,
                 public_ip: str,
                 region_id: str,
                 status: str,
                 vswitch_id: str):
        """
        :param str availability_zone: The ID of the availability zone where the ECS instance is located.
        :param str instance_id: The ID of the ECS instance.
        :param str instance_name: The name of the ECS instance.
        :param str key_name: The Key Pair Name.
        :param str private_ip: The private IP address of the ECS instance.
        :param str public_ip: The public IP address or EIP of the ECS instance.
        :param str vswitch_id: The ID of the VSwitch attached to the ECS instance.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        The ID of the availability zone where the ECS instance is located.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of the ECS instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        The Key Pair Name.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address of the ECS instance.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        The public IP address or EIP of the ECS instance.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The ID of the VSwitch attached to the ECS instance.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetEcsLaunchTemplatesTemplateResult(dict):
    def __init__(__self__, *,
                 auto_release_time: str,
                 created_by: str,
                 data_disks: Sequence['outputs.GetEcsLaunchTemplatesTemplateDataDiskResult'],
                 default_version_number: int,
                 deployment_set_id: str,
                 description: str,
                 enable_vm_os_config: bool,
                 host_name: str,
                 id: str,
                 image_id: str,
                 image_owner_alias: str,
                 instance_charge_type: str,
                 instance_name: str,
                 instance_type: str,
                 internet_charge_type: str,
                 internet_max_bandwidth_in: int,
                 internet_max_bandwidth_out: int,
                 io_optimized: str,
                 key_pair_name: str,
                 latest_version_number: int,
                 launch_template_id: str,
                 launch_template_name: str,
                 modified_time: str,
                 network_interfaces: Sequence['outputs.GetEcsLaunchTemplatesTemplateNetworkInterfaceResult'],
                 network_type: str,
                 password_inherit: bool,
                 period: int,
                 private_ip_address: str,
                 ram_role_name: str,
                 resource_group_id: str,
                 security_enhancement_strategy: str,
                 security_group_id: str,
                 security_group_ids: Sequence[str],
                 spot_duration: str,
                 spot_price_limit: float,
                 spot_strategy: str,
                 system_disks: Sequence['outputs.GetEcsLaunchTemplatesTemplateSystemDiskResult'],
                 template_tags: Mapping[str, Any],
                 user_data: str,
                 version_description: str,
                 vpc_id: str,
                 vswitch_id: str,
                 zone_id: str):
        """
        :param str auto_release_time: Instance auto release time.
        :param str created_by: CreatedBy.
        :param Sequence['GetEcsLaunchTemplatesTemplateDataDiskArgs'] data_disks: The list of data disks created with instance.
        :param int default_version_number: The Default Version Number.
        :param str deployment_set_id: The Deployment Set Id.
        :param str description: System disk description.
        :param bool enable_vm_os_config: Whether to enable the instance operating system configuration.
        :param str host_name: Instance host name.
        :param str id: The ID of the Launch Template.
        :param str image_id: The Image Id.
        :param str image_owner_alias: Mirror source.
        :param str instance_charge_type: Internet bandwidth billing method.
        :param str instance_name: The Instance Name.
        :param str instance_type: Instance type.
        :param str internet_charge_type: Internet bandwidth billing method.
        :param int internet_max_bandwidth_in: The maximum inbound bandwidth from the Internet network, measured in Mbit/s.
        :param int internet_max_bandwidth_out: Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s.
        :param str io_optimized: Whether it is an I/O-optimized instance or not.
        :param str key_pair_name: The name of the key pair.
        :param int latest_version_number: The Latest Version Number.
        :param str launch_template_id: The ID of the Launch Template.
        :param str launch_template_name: The Launch Template Name.
        :param str modified_time: The Modified Time.
        :param Sequence['GetEcsLaunchTemplatesTemplateNetworkInterfaceArgs'] network_interfaces: The list of network interfaces created with instance.
        :param str network_type: Network type of the instance.
        :param bool password_inherit: Whether to use the password preset by the mirror.
        :param int period: The subscription period of the instance.
        :param str private_ip_address: The private IP address of the instance.
        :param str ram_role_name: The RAM role name of the instance.
        :param str resource_group_id: The ID of the resource group to which to assign the instance, Elastic Block Storage (EBS) device, and ENI.
        :param str security_enhancement_strategy: Whether or not to activate the security enhancement feature and install network security software free of charge.
        :param str security_group_id: The security group ID.
        :param Sequence[str] security_group_ids: The security group IDs.
        :param str spot_duration: The protection period of the preemptible instance.
        :param float spot_price_limit: Sets the maximum hourly instance price.
        :param str spot_strategy: The spot strategy for a Pay-As-You-Go instance.
        :param Sequence['GetEcsLaunchTemplatesTemplateSystemDiskArgs'] system_disks: The System Disk.
        :param Mapping[str, Any] template_tags: The template tags.
        :param str user_data: The User Data.
        :param str version_description: The Version Description.
        :param str vpc_id: VpcId.
        :param str vswitch_id: The vswitch id.
        :param str zone_id: The Zone Id.
        """
        pulumi.set(__self__, "auto_release_time", auto_release_time)
        pulumi.set(__self__, "created_by", created_by)
        pulumi.set(__self__, "data_disks", data_disks)
        pulumi.set(__self__, "default_version_number", default_version_number)
        pulumi.set(__self__, "deployment_set_id", deployment_set_id)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enable_vm_os_config", enable_vm_os_config)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_owner_alias", image_owner_alias)
        pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "internet_max_bandwidth_in", internet_max_bandwidth_in)
        pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        pulumi.set(__self__, "io_optimized", io_optimized)
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        pulumi.set(__self__, "latest_version_number", latest_version_number)
        pulumi.set(__self__, "launch_template_id", launch_template_id)
        pulumi.set(__self__, "launch_template_name", launch_template_name)
        pulumi.set(__self__, "modified_time", modified_time)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "password_inherit", password_inherit)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "ram_role_name", ram_role_name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "security_enhancement_strategy", security_enhancement_strategy)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "spot_duration", spot_duration)
        pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        pulumi.set(__self__, "spot_strategy", spot_strategy)
        pulumi.set(__self__, "system_disks", system_disks)
        pulumi.set(__self__, "template_tags", template_tags)
        pulumi.set(__self__, "user_data", user_data)
        pulumi.set(__self__, "version_description", version_description)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="autoReleaseTime")
    def auto_release_time(self) -> str:
        """
        Instance auto release time.
        """
        return pulumi.get(self, "auto_release_time")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        CreatedBy.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Sequence['outputs.GetEcsLaunchTemplatesTemplateDataDiskResult']:
        """
        The list of data disks created with instance.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="defaultVersionNumber")
    def default_version_number(self) -> int:
        """
        The Default Version Number.
        """
        return pulumi.get(self, "default_version_number")

    @property
    @pulumi.getter(name="deploymentSetId")
    def deployment_set_id(self) -> str:
        """
        The Deployment Set Id.
        """
        return pulumi.get(self, "deployment_set_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        System disk description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableVmOsConfig")
    def enable_vm_os_config(self) -> bool:
        """
        Whether to enable the instance operating system configuration.
        """
        return pulumi.get(self, "enable_vm_os_config")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        Instance host name.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Launch Template.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The Image Id.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> str:
        """
        Mirror source.
        """
        return pulumi.get(self, "image_owner_alias")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> str:
        """
        Internet bandwidth billing method.
        """
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The Instance Name.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> str:
        """
        Internet bandwidth billing method.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> int:
        """
        The maximum inbound bandwidth from the Internet network, measured in Mbit/s.
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> int:
        """
        Maximum outbound bandwidth from the Internet, its unit of measurement is Mbit/s.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @property
    @pulumi.getter(name="ioOptimized")
    def io_optimized(self) -> str:
        """
        Whether it is an I/O-optimized instance or not.
        """
        return pulumi.get(self, "io_optimized")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> str:
        """
        The name of the key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="latestVersionNumber")
    def latest_version_number(self) -> int:
        """
        The Latest Version Number.
        """
        return pulumi.get(self, "latest_version_number")

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> str:
        """
        The ID of the Launch Template.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> str:
        """
        The Launch Template Name.
        """
        return pulumi.get(self, "launch_template_name")

    @property
    @pulumi.getter(name="modifiedTime")
    def modified_time(self) -> str:
        """
        The Modified Time.
        """
        return pulumi.get(self, "modified_time")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Sequence['outputs.GetEcsLaunchTemplatesTemplateNetworkInterfaceResult']:
        """
        The list of network interfaces created with instance.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        Network type of the instance.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> bool:
        """
        Whether to use the password preset by the mirror.
        """
        return pulumi.get(self, "password_inherit")

    @property
    @pulumi.getter
    def period(self) -> int:
        """
        The subscription period of the instance.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> str:
        """
        The private IP address of the instance.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> str:
        """
        The RAM role name of the instance.
        """
        return pulumi.get(self, "ram_role_name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group to which to assign the instance, Elastic Block Storage (EBS) device, and ENI.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityEnhancementStrategy")
    def security_enhancement_strategy(self) -> str:
        """
        Whether or not to activate the security enhancement feature and install network security software free of charge.
        """
        return pulumi.get(self, "security_enhancement_strategy")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        The security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The security group IDs.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> str:
        """
        The protection period of the preemptible instance.
        """
        return pulumi.get(self, "spot_duration")

    @property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> float:
        """
        Sets the maximum hourly instance price.
        """
        return pulumi.get(self, "spot_price_limit")

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> str:
        """
        The spot strategy for a Pay-As-You-Go instance.
        """
        return pulumi.get(self, "spot_strategy")

    @property
    @pulumi.getter(name="systemDisks")
    def system_disks(self) -> Sequence['outputs.GetEcsLaunchTemplatesTemplateSystemDiskResult']:
        """
        The System Disk.
        """
        return pulumi.get(self, "system_disks")

    @property
    @pulumi.getter(name="templateTags")
    def template_tags(self) -> Mapping[str, Any]:
        """
        The template tags.
        """
        return pulumi.get(self, "template_tags")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> str:
        """
        The User Data.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> str:
        """
        The Version Description.
        """
        return pulumi.get(self, "version_description")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        VpcId.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The Zone Id.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetEcsLaunchTemplatesTemplateDataDiskResult(dict):
    def __init__(__self__, *,
                 category: str,
                 delete_with_instance: bool,
                 description: str,
                 encrypted: bool,
                 name: str,
                 performance_level: str,
                 size: int,
                 snapshot_id: str):
        """
        :param str category: The category of the system disk.
        :param bool delete_with_instance: Specifies whether to release the system disk when the instance is released.
        :param str description: System disk description.
        :param bool encrypted: Encrypted the data in this disk.
        :param str name: System disk name.
        :param str performance_level: The performance level of the ESSD used as the system disk.
        :param int size: Size of the system disk, measured in GB.
        :param str snapshot_id: The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "performance_level", performance_level)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        The category of the system disk.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> bool:
        """
        Specifies whether to release the system disk when the instance is released.
        """
        return pulumi.get(self, "delete_with_instance")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        System disk description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def encrypted(self) -> bool:
        """
        Encrypted the data in this disk.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        System disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> str:
        """
        The performance level of the ESSD used as the system disk.
        """
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Size of the system disk, measured in GB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> str:
        """
        The snapshot ID used to initialize the data disk. If the size specified by snapshot is greater that the size of the disk, use the size specified by snapshot as the size of the data disk.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class GetEcsLaunchTemplatesTemplateNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 description: str,
                 name: str,
                 primary_ip: str,
                 security_group_id: str,
                 vswitch_id: str):
        """
        :param str description: System disk description.
        :param str name: System disk name.
        :param str primary_ip: The primary private IP address of the ENI.
        :param str security_group_id: The security group ID.
        :param str vswitch_id: The vswitch id.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary_ip", primary_ip)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        System disk description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        System disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryIp")
    def primary_ip(self) -> str:
        """
        The primary private IP address of the ENI.
        """
        return pulumi.get(self, "primary_ip")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        The security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetEcsLaunchTemplatesTemplateSystemDiskResult(dict):
    def __init__(__self__, *,
                 category: str,
                 delete_with_instance: bool,
                 description: str,
                 iops: str,
                 name: str,
                 performance_level: str,
                 size: int):
        """
        :param str category: The category of the system disk.
        :param bool delete_with_instance: Specifies whether to release the system disk when the instance is released.
        :param str description: System disk description.
        :param str iops: The Iops.
        :param str name: System disk name.
        :param str performance_level: The performance level of the ESSD used as the system disk.
        :param int size: Size of the system disk, measured in GB.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "iops", iops)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "performance_level", performance_level)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        The category of the system disk.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> bool:
        """
        Specifies whether to release the system disk when the instance is released.
        """
        return pulumi.get(self, "delete_with_instance")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        System disk description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def iops(self) -> str:
        """
        The Iops.
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        System disk name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> str:
        """
        The performance level of the ESSD used as the system disk.
        """
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Size of the system disk, measured in GB.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class GetEcsNetworkInterfacePermissionsPermissionResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 id: str,
                 network_interface_id: str,
                 network_interface_permission_id: str,
                 permission: str,
                 service_name: str,
                 status: str):
        """
        :param str account_id: Alibaba Cloud Partner (Certified ISV) account ID or individual user ID.
        :param str id: The ID of the Network Interface Permission.
        :param str network_interface_id: The ID of the network interface.
        :param str network_interface_permission_id: The ID of the Network Interface Permissions.
        :param str permission: The permissions of the Network Interface.
        :param str service_name: Alibaba Cloud service name.
        :param str status: The Status of the Network Interface Permissions.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "network_interface_permission_id", network_interface_permission_id)
        pulumi.set(__self__, "permission", permission)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        Alibaba Cloud Partner (Certified ISV) account ID or individual user ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Network Interface Permission.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> str:
        """
        The ID of the network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter(name="networkInterfacePermissionId")
    def network_interface_permission_id(self) -> str:
        """
        The ID of the Network Interface Permissions.
        """
        return pulumi.get(self, "network_interface_permission_id")

    @property
    @pulumi.getter
    def permission(self) -> str:
        """
        The permissions of the Network Interface.
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        Alibaba Cloud service name.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The Status of the Network Interface Permissions.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetEcsNetworkInterfacesInterfaceResult(dict):
    def __init__(__self__, *,
                 associated_public_ips: Sequence['outputs.GetEcsNetworkInterfacesInterfaceAssociatedPublicIpResult'],
                 creation_time: str,
                 description: str,
                 id: str,
                 instance_id: str,
                 mac: str,
                 name: str,
                 network_interface_id: str,
                 network_interface_name: str,
                 network_interface_traffic_mode: str,
                 owner_id: str,
                 primary_ip_address: str,
                 private_ip: str,
                 private_ip_addresses: Sequence[str],
                 private_ips: Sequence[str],
                 queue_number: int,
                 resource_group_id: str,
                 security_group_ids: Sequence[str],
                 security_groups: Sequence[str],
                 service_id: int,
                 service_managed: bool,
                 status: str,
                 tags: Mapping[str, Any],
                 type: str,
                 vpc_id: str,
                 vswitch_id: str,
                 zone_id: str):
        """
        :param Sequence['GetEcsNetworkInterfacesInterfaceAssociatedPublicIpArgs'] associated_public_ips: The EIP associated with the secondary private IP address of the ENI.  **NOTE:** Available in v1.163.0+.
        :param str creation_time: The creation time.
        :param str description: The description of the ENI.
        :param str id: The ID of the Network Interface.
        :param str instance_id: The instance id.
        :param str mac: The MAC address of the ENI.
        :param str name: The network interface name.
        :param str network_interface_id: The network interface id.
        :param str network_interface_name: The network interface name.
        :param str network_interface_traffic_mode: The communication mode of the elastic network card.
        :param str owner_id: The ID of the account to which the ENIC belongs.
        :param str primary_ip_address: The primary private IP address of the ENI.
        :param str private_ip: The primary private IP address of the ENI.
        :param Sequence[str] private_ips: A list of secondary private IP address that is assigned to the ENI.
        :param int queue_number: Number of network card queues.
        :param str resource_group_id: The resource group id.
        :param Sequence[str] security_group_ids: The security group ids.
        :param Sequence[str] security_groups: The security groups.
        :param int service_id: The service id.
        :param bool service_managed: Whether the user of the elastic network card is a cloud product or a virtual vendor.
        :param str status: The status of the ENI.
        :param Mapping[str, Any] tags: The tags.
        :param str type: The type of the ENI.
        :param str vpc_id: The Vpc Id.
        :param str vswitch_id: The vswitch id.
        :param str zone_id: The zone id.
        """
        pulumi.set(__self__, "associated_public_ips", associated_public_ips)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "mac", mac)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "network_interface_name", network_interface_name)
        pulumi.set(__self__, "network_interface_traffic_mode", network_interface_traffic_mode)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "primary_ip_address", primary_ip_address)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        pulumi.set(__self__, "private_ips", private_ips)
        pulumi.set(__self__, "queue_number", queue_number)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "security_groups", security_groups)
        pulumi.set(__self__, "service_id", service_id)
        pulumi.set(__self__, "service_managed", service_managed)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="associatedPublicIps")
    def associated_public_ips(self) -> Sequence['outputs.GetEcsNetworkInterfacesInterfaceAssociatedPublicIpResult']:
        """
        The EIP associated with the secondary private IP address of the ENI.  **NOTE:** Available in v1.163.0+.
        """
        return pulumi.get(self, "associated_public_ips")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the ENI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Network Interface.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The instance id.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def mac(self) -> str:
        """
        The MAC address of the ENI.
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The network interface name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> str:
        """
        The network interface id.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter(name="networkInterfaceName")
    def network_interface_name(self) -> str:
        """
        The network interface name.
        """
        return pulumi.get(self, "network_interface_name")

    @property
    @pulumi.getter(name="networkInterfaceTrafficMode")
    def network_interface_traffic_mode(self) -> str:
        """
        The communication mode of the elastic network card.
        """
        return pulumi.get(self, "network_interface_traffic_mode")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> str:
        """
        The ID of the account to which the ENIC belongs.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="primaryIpAddress")
    def primary_ip_address(self) -> str:
        """
        The primary private IP address of the ENI.
        """
        return pulumi.get(self, "primary_ip_address")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The primary private IP address of the ENI.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Sequence[str]:
        return pulumi.get(self, "private_ip_addresses")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence[str]:
        """
        A list of secondary private IP address that is assigned to the ENI.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="queueNumber")
    def queue_number(self) -> int:
        """
        Number of network card queues.
        """
        return pulumi.get(self, "queue_number")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        """
        The security group ids.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence[str]:
        """
        The security groups.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> int:
        """
        The service id.
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="serviceManaged")
    def service_managed(self) -> bool:
        """
        Whether the user of the elastic network card is a cloud product or a virtual vendor.
        """
        return pulumi.get(self, "service_managed")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the ENI.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        The tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the ENI.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The Vpc Id.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The vswitch id.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone id.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetEcsNetworkInterfacesInterfaceAssociatedPublicIpResult(dict):
    def __init__(__self__, *,
                 public_ip_address: str):
        """
        :param str public_ip_address: The EIP of the ENI.
        """
        pulumi.set(__self__, "public_ip_address", public_ip_address)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        """
        The EIP of the ENI.
        """
        return pulumi.get(self, "public_ip_address")


@pulumi.output_type
class GetEcsPrefixListsListResult(dict):
    def __init__(__self__, *,
                 address_family: str,
                 association_count: int,
                 create_time: str,
                 description: str,
                 entries: Sequence['outputs.GetEcsPrefixListsListEntryResult'],
                 id: str,
                 max_entries: int,
                 prefix_list_id: str,
                 prefix_list_name: str):
        """
        :param str address_family: The address family of the prefix list. Valid values:`IPv4`,`IPv6`.
        :param int association_count: The amount of associated resources.
        :param str create_time: The time when the prefix list was created.
        :param str description: The description of the prefix list.
        :param str id: The ID of the prefix list.
        :param int max_entries: The maximum number of entries that the prefix list supports.
        :param str prefix_list_id: The ID of the prefix list.
        :param str prefix_list_name: The name of the prefix list.
        """
        pulumi.set(__self__, "address_family", address_family)
        pulumi.set(__self__, "association_count", association_count)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "entries", entries)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "max_entries", max_entries)
        pulumi.set(__self__, "prefix_list_id", prefix_list_id)
        pulumi.set(__self__, "prefix_list_name", prefix_list_name)

    @property
    @pulumi.getter(name="addressFamily")
    def address_family(self) -> str:
        """
        The address family of the prefix list. Valid values:`IPv4`,`IPv6`.
        """
        return pulumi.get(self, "address_family")

    @property
    @pulumi.getter(name="associationCount")
    def association_count(self) -> int:
        """
        The amount of associated resources.
        """
        return pulumi.get(self, "association_count")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the prefix list was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the prefix list.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.GetEcsPrefixListsListEntryResult']:
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the prefix list.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxEntries")
    def max_entries(self) -> int:
        """
        The maximum number of entries that the prefix list supports.
        """
        return pulumi.get(self, "max_entries")

    @property
    @pulumi.getter(name="prefixListId")
    def prefix_list_id(self) -> str:
        """
        The ID of the prefix list.
        """
        return pulumi.get(self, "prefix_list_id")

    @property
    @pulumi.getter(name="prefixListName")
    def prefix_list_name(self) -> str:
        """
        The name of the prefix list.
        """
        return pulumi.get(self, "prefix_list_name")


@pulumi.output_type
class GetEcsPrefixListsListEntryResult(dict):
    def __init__(__self__, *,
                 cidr: str,
                 description: str):
        """
        :param str description: The description of the prefix list.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def cidr(self) -> str:
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the prefix list.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetEcsSnapshotGroupsGroupResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: str,
                 instance_id: str,
                 resource_group_id: str,
                 snapshot_group_id: str,
                 snapshot_group_name: str,
                 status: str,
                 tags: Optional[Mapping[str, Any]] = None):
        """
        :param str description: The description of the snapshot-consistent group.
        :param str id: The ID of the Snapshot Group.
        :param str instance_id: The ID of the instance.
        :param str resource_group_id: The ID of the resource group to which the snapshot consistency group belongs.
        :param str snapshot_group_id: The first ID of the resource.
        :param str snapshot_group_name: The name of the snapshot-consistent group.
        :param str status: The status of the resource.
        :param Mapping[str, Any] tags: List of label key-value pairs.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "snapshot_group_id", snapshot_group_id)
        pulumi.set(__self__, "snapshot_group_name", snapshot_group_name)
        pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the snapshot-consistent group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Snapshot Group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group to which the snapshot consistency group belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="snapshotGroupId")
    def snapshot_group_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "snapshot_group_id")

    @property
    @pulumi.getter(name="snapshotGroupName")
    def snapshot_group_name(self) -> str:
        """
        The name of the snapshot-consistent group.
        """
        return pulumi.get(self, "snapshot_group_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        """
        List of label key-value pairs.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetEcsSnapshotsSnapshotResult(dict):
    def __init__(__self__, *,
                 category: str,
                 creation_time: str,
                 description: str,
                 disk_id: str,
                 encrypted: bool,
                 id: str,
                 instant_access: bool,
                 instant_access_retention_days: int,
                 name: str,
                 product_code: str,
                 progress: str,
                 remain_time: int,
                 resource_group_id: str,
                 retention_days: int,
                 snapshot_id: str,
                 snapshot_name: str,
                 snapshot_sn: str,
                 snapshot_type: str,
                 source_disk_id: str,
                 source_disk_size: str,
                 source_disk_type: str,
                 source_storage_type: str,
                 status: str,
                 tags: Mapping[str, Any],
                 type: str,
                 usage: str):
        """
        :param str category: The category of the snapshot.
        :param str description: The description of the snapshot.
        :param str disk_id: The source disk id.
        :param bool encrypted: Whether the snapshot is encrypted.
        :param str id: The ID of the Snapshot.
        :param bool instant_access: Whether snapshot speed availability is enabled.
        :param int instant_access_retention_days: Specifies the retention period of the instant access feature. After the retention period ends, the snapshot is automatically released.
        :param str product_code: The product number inherited from the mirror market.
        :param str progress: Snapshot creation progress, in percentage.
        :param int remain_time: Remaining completion time for the snapshot being created.
        :param str resource_group_id: The resource group id.
        :param int retention_days: Automatic snapshot retention days.
        :param str snapshot_id: The snapshot id.
        :param str snapshot_name: Snapshot Display Name.
        :param str snapshot_sn: The serial number of the snapshot.
        :param str snapshot_type: Snapshot creation type.
        :param str source_disk_size: Source disk capacity.
        :param str source_disk_type: Source disk attributes.
        :param str source_storage_type: Original disk type.
        :param str status: The status of the snapshot.
        :param Mapping[str, Any] tags: The tags.
        :param str usage: A resource type that has a reference relationship.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instant_access", instant_access)
        pulumi.set(__self__, "instant_access_retention_days", instant_access_retention_days)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product_code", product_code)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "remain_time", remain_time)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "retention_days", retention_days)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "snapshot_name", snapshot_name)
        pulumi.set(__self__, "snapshot_sn", snapshot_sn)
        pulumi.set(__self__, "snapshot_type", snapshot_type)
        pulumi.set(__self__, "source_disk_id", source_disk_id)
        pulumi.set(__self__, "source_disk_size", source_disk_size)
        pulumi.set(__self__, "source_disk_type", source_disk_type)
        pulumi.set(__self__, "source_storage_type", source_storage_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "usage", usage)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        The category of the snapshot.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the snapshot.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> str:
        """
        The source disk id.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter
    def encrypted(self) -> bool:
        """
        Whether the snapshot is encrypted.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Snapshot.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instantAccess")
    def instant_access(self) -> bool:
        """
        Whether snapshot speed availability is enabled.
        """
        return pulumi.get(self, "instant_access")

    @property
    @pulumi.getter(name="instantAccessRetentionDays")
    def instant_access_retention_days(self) -> int:
        """
        Specifies the retention period of the instant access feature. After the retention period ends, the snapshot is automatically released.
        """
        return pulumi.get(self, "instant_access_retention_days")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productCode")
    def product_code(self) -> str:
        """
        The product number inherited from the mirror market.
        """
        return pulumi.get(self, "product_code")

    @property
    @pulumi.getter
    def progress(self) -> str:
        """
        Snapshot creation progress, in percentage.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter(name="remainTime")
    def remain_time(self) -> int:
        """
        Remaining completion time for the snapshot being created.
        """
        return pulumi.get(self, "remain_time")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> int:
        """
        Automatic snapshot retention days.
        """
        return pulumi.get(self, "retention_days")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> str:
        """
        The snapshot id.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> str:
        """
        Snapshot Display Name.
        """
        return pulumi.get(self, "snapshot_name")

    @property
    @pulumi.getter(name="snapshotSn")
    def snapshot_sn(self) -> str:
        """
        The serial number of the snapshot.
        """
        return pulumi.get(self, "snapshot_sn")

    @property
    @pulumi.getter(name="snapshotType")
    def snapshot_type(self) -> str:
        """
        Snapshot creation type.
        """
        return pulumi.get(self, "snapshot_type")

    @property
    @pulumi.getter(name="sourceDiskId")
    def source_disk_id(self) -> str:
        return pulumi.get(self, "source_disk_id")

    @property
    @pulumi.getter(name="sourceDiskSize")
    def source_disk_size(self) -> str:
        """
        Source disk capacity.
        """
        return pulumi.get(self, "source_disk_size")

    @property
    @pulumi.getter(name="sourceDiskType")
    def source_disk_type(self) -> str:
        """
        Source disk attributes.
        """
        return pulumi.get(self, "source_disk_type")

    @property
    @pulumi.getter(name="sourceStorageType")
    def source_storage_type(self) -> str:
        """
        Original disk type.
        """
        return pulumi.get(self, "source_storage_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the snapshot.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        The tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def usage(self) -> str:
        """
        A resource type that has a reference relationship.
        """
        return pulumi.get(self, "usage")


@pulumi.output_type
class GetEcsStorageCapacityUnitsUnitResult(dict):
    def __init__(__self__, *,
                 allocation_status: str,
                 capacity: int,
                 create_time: str,
                 description: str,
                 expired_time: str,
                 id: str,
                 start_time: str,
                 status: str,
                 storage_capacity_unit_id: str,
                 storage_capacity_unit_name: str):
        """
        :param str allocation_status: When the AllocationType value is Shared, this parameter indicates the allocation status of Storage Capacity Unit. Valid values: `allocated`, `Ignored`.
        :param int capacity: The capacity of the Storage Capacity Unit.
        :param str create_time: The time when the Storage Capacity Unit was created.
        :param str description: The description of the Storage Capacity Unit.
        :param str expired_time: The time when the Storage Capacity Unit expires.
        :param str id: The ID of the Storage Capacity Unit.
        :param str start_time: The effective time of the Storage Capacity Unit.
        :param str status: The status of Storage Capacity Unit.
        :param str storage_capacity_unit_id: The ID of Storage Capacity Unit.
        :param str storage_capacity_unit_name: The name of the Storage Capacity Unit.
        """
        pulumi.set(__self__, "allocation_status", allocation_status)
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_capacity_unit_id", storage_capacity_unit_id)
        pulumi.set(__self__, "storage_capacity_unit_name", storage_capacity_unit_name)

    @property
    @pulumi.getter(name="allocationStatus")
    def allocation_status(self) -> str:
        """
        When the AllocationType value is Shared, this parameter indicates the allocation status of Storage Capacity Unit. Valid values: `allocated`, `Ignored`.
        """
        return pulumi.get(self, "allocation_status")

    @property
    @pulumi.getter
    def capacity(self) -> int:
        """
        The capacity of the Storage Capacity Unit.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the Storage Capacity Unit was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Storage Capacity Unit.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        """
        The time when the Storage Capacity Unit expires.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Storage Capacity Unit.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The effective time of the Storage Capacity Unit.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of Storage Capacity Unit.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageCapacityUnitId")
    def storage_capacity_unit_id(self) -> str:
        """
        The ID of Storage Capacity Unit.
        """
        return pulumi.get(self, "storage_capacity_unit_id")

    @property
    @pulumi.getter(name="storageCapacityUnitName")
    def storage_capacity_unit_name(self) -> str:
        """
        The name of the Storage Capacity Unit.
        """
        return pulumi.get(self, "storage_capacity_unit_name")


@pulumi.output_type
class GetEipAddressesAddressResult(dict):
    def __init__(__self__, *,
                 address_name: str,
                 allocation_id: str,
                 available_regions: Sequence[str],
                 bandwidth: str,
                 bandwidth_package_bandwidth: str,
                 bandwidth_package_id: str,
                 bandwidth_package_type: str,
                 create_time: str,
                 deletion_protection: bool,
                 description: str,
                 expired_time: str,
                 has_reservation_data: str,
                 hd_monitor_status: str,
                 id: str,
                 instance_id: str,
                 instance_region_id: str,
                 instance_type: str,
                 internet_charge_type: str,
                 ip_address: str,
                 isp: str,
                 operation_locks: Sequence[str],
                 payment_type: str,
                 reservation_active_time: str,
                 reservation_bandwidth: str,
                 reservation_internet_charge_type: str,
                 reservation_order_type: str,
                 resource_group_id: str,
                 second_limited: bool,
                 segment_instance_id: str,
                 status: str,
                 tags: Mapping[str, Any]):
        """
        :param str address_name: The name of the EIP.
        :param str allocation_id: The ID of the EIP.
        :param Sequence[str] available_regions: The ID of the region to which the EIP belongs.
        :param str bandwidth: The maximum bandwidth of the EIP. Unit: Mbit/s.
        :param str bandwidth_package_bandwidth: The bandwidth value of the EIP bandwidth plan with which the EIP is associated.
        :param str bandwidth_package_id: The ID of the EIP bandwidth plan.
        :param str bandwidth_package_type: The type of the bandwidth. Only CommonBandwidthPackage (an EIP bandwidth plan) is returned.
        :param str create_time: The time when the EIP was created.
        :param bool deletion_protection: Indicates whether deletion protection is enabled.
        :param str description: The description of the EIP.
        :param str expired_time: The expiration date. The time follows the ISO 8601 standard and is displayed in UTC. Format: YYYY-MM-DDThh:mmZ.
        :param str has_reservation_data: Indicates whether renewal data is included. This parameter returns true only when the parameter IncludeReservationData is set to true, and some orders have not taken effect.
        :param str hd_monitor_status: Indicates whether fine-grained monitoring is enabled for the EIP.
        :param str id: The ID of the Address.
        :param str instance_id: The ID of the instance with which the EIP is associated.
        :param str instance_region_id: The region ID of the associated resource.
        :param str instance_type: The type of the instance with which the EIP is associated.
        :param str internet_charge_type: The metering method of the EIP.
        :param str ip_address: The IP address of the EIP.
        :param str isp: The Internet service provider (ISP).
        :param Sequence[str] operation_locks: The details about the locked EIP.
        :param str payment_type: The billing method of the EIP.
        :param str reservation_active_time: The time when the renewal takes effect.
        :param str reservation_bandwidth: The bandwidth after the renewal takes effect.
        :param str reservation_internet_charge_type: The metering method of the renewal.
        :param str reservation_order_type: The type of the renewal order.
        :param str resource_group_id: The ID of the resource group.
        :param bool second_limited: Indicates whether level-2 throttling is configured.
        :param str segment_instance_id: The IDs of the contiguous EIPs.
        :param str status: The status of the EIP.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "address_name", address_name)
        pulumi.set(__self__, "allocation_id", allocation_id)
        pulumi.set(__self__, "available_regions", available_regions)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "bandwidth_package_bandwidth", bandwidth_package_bandwidth)
        pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)
        pulumi.set(__self__, "bandwidth_package_type", bandwidth_package_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "has_reservation_data", has_reservation_data)
        pulumi.set(__self__, "hd_monitor_status", hd_monitor_status)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_region_id", instance_region_id)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "isp", isp)
        pulumi.set(__self__, "operation_locks", operation_locks)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "reservation_active_time", reservation_active_time)
        pulumi.set(__self__, "reservation_bandwidth", reservation_bandwidth)
        pulumi.set(__self__, "reservation_internet_charge_type", reservation_internet_charge_type)
        pulumi.set(__self__, "reservation_order_type", reservation_order_type)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "second_limited", second_limited)
        pulumi.set(__self__, "segment_instance_id", segment_instance_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addressName")
    def address_name(self) -> str:
        """
        The name of the EIP.
        """
        return pulumi.get(self, "address_name")

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> str:
        """
        The ID of the EIP.
        """
        return pulumi.get(self, "allocation_id")

    @property
    @pulumi.getter(name="availableRegions")
    def available_regions(self) -> Sequence[str]:
        """
        The ID of the region to which the EIP belongs.
        """
        return pulumi.get(self, "available_regions")

    @property
    @pulumi.getter
    def bandwidth(self) -> str:
        """
        The maximum bandwidth of the EIP. Unit: Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="bandwidthPackageBandwidth")
    def bandwidth_package_bandwidth(self) -> str:
        """
        The bandwidth value of the EIP bandwidth plan with which the EIP is associated.
        """
        return pulumi.get(self, "bandwidth_package_bandwidth")

    @property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> str:
        """
        The ID of the EIP bandwidth plan.
        """
        return pulumi.get(self, "bandwidth_package_id")

    @property
    @pulumi.getter(name="bandwidthPackageType")
    def bandwidth_package_type(self) -> str:
        """
        The type of the bandwidth. Only CommonBandwidthPackage (an EIP bandwidth plan) is returned.
        """
        return pulumi.get(self, "bandwidth_package_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the EIP was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        """
        Indicates whether deletion protection is enabled.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the EIP.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        """
        The expiration date. The time follows the ISO 8601 standard and is displayed in UTC. Format: YYYY-MM-DDThh:mmZ.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="hasReservationData")
    def has_reservation_data(self) -> str:
        """
        Indicates whether renewal data is included. This parameter returns true only when the parameter IncludeReservationData is set to true, and some orders have not taken effect.
        """
        return pulumi.get(self, "has_reservation_data")

    @property
    @pulumi.getter(name="hdMonitorStatus")
    def hd_monitor_status(self) -> str:
        """
        Indicates whether fine-grained monitoring is enabled for the EIP.
        """
        return pulumi.get(self, "hd_monitor_status")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Address.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the instance with which the EIP is associated.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceRegionId")
    def instance_region_id(self) -> str:
        """
        The region ID of the associated resource.
        """
        return pulumi.get(self, "instance_region_id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The type of the instance with which the EIP is associated.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> str:
        """
        The metering method of the EIP.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the EIP.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def isp(self) -> str:
        """
        The Internet service provider (ISP).
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter(name="operationLocks")
    def operation_locks(self) -> Sequence[str]:
        """
        The details about the locked EIP.
        """
        return pulumi.get(self, "operation_locks")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The billing method of the EIP.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="reservationActiveTime")
    def reservation_active_time(self) -> str:
        """
        The time when the renewal takes effect.
        """
        return pulumi.get(self, "reservation_active_time")

    @property
    @pulumi.getter(name="reservationBandwidth")
    def reservation_bandwidth(self) -> str:
        """
        The bandwidth after the renewal takes effect.
        """
        return pulumi.get(self, "reservation_bandwidth")

    @property
    @pulumi.getter(name="reservationInternetChargeType")
    def reservation_internet_charge_type(self) -> str:
        """
        The metering method of the renewal.
        """
        return pulumi.get(self, "reservation_internet_charge_type")

    @property
    @pulumi.getter(name="reservationOrderType")
    def reservation_order_type(self) -> str:
        """
        The type of the renewal order.
        """
        return pulumi.get(self, "reservation_order_type")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="secondLimited")
    def second_limited(self) -> bool:
        """
        Indicates whether level-2 throttling is configured.
        """
        return pulumi.get(self, "second_limited")

    @property
    @pulumi.getter(name="segmentInstanceId")
    def segment_instance_id(self) -> str:
        """
        The IDs of the contiguous EIPs.
        """
        return pulumi.get(self, "segment_instance_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the EIP.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetEipAddressesEipResult(dict):
    def __init__(__self__, *,
                 bandwidth: str,
                 creation_time: str,
                 deletion_protection: bool,
                 id: str,
                 instance_id: str,
                 instance_type: str,
                 internet_charge_type: str,
                 ip_address: str,
                 status: str):
        """
        :param str bandwidth: The maximum bandwidth of the EIP. Unit: Mbit/s.
        :param bool deletion_protection: Indicates whether deletion protection is enabled.
        :param str id: The ID of the Address.
        :param str instance_id: The ID of the instance with which the EIP is associated.
        :param str instance_type: The type of the instance with which the EIP is associated.
        :param str internet_charge_type: The metering method of the EIP.
        :param str ip_address: The IP address of the EIP.
        :param str status: The status of the EIP.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def bandwidth(self) -> str:
        """
        The maximum bandwidth of the EIP. Unit: Mbit/s.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        """
        Indicates whether deletion protection is enabled.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Address.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the instance with which the EIP is associated.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The type of the instance with which the EIP is associated.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> str:
        """
        The metering method of the EIP.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address of the EIP.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the EIP.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetEipsAddressResult(dict):
    def __init__(__self__, *,
                 address_name: str,
                 allocation_id: str,
                 available_regions: Sequence[str],
                 bandwidth: str,
                 bandwidth_package_bandwidth: str,
                 bandwidth_package_id: str,
                 bandwidth_package_type: str,
                 create_time: str,
                 deletion_protection: bool,
                 description: str,
                 expired_time: str,
                 has_reservation_data: str,
                 hd_monitor_status: str,
                 id: str,
                 instance_id: str,
                 instance_region_id: str,
                 instance_type: str,
                 internet_charge_type: str,
                 ip_address: str,
                 isp: str,
                 operation_locks: Sequence[str],
                 payment_type: str,
                 reservation_active_time: str,
                 reservation_bandwidth: str,
                 reservation_internet_charge_type: str,
                 reservation_order_type: str,
                 resource_group_id: str,
                 second_limited: bool,
                 segment_instance_id: str,
                 status: str,
                 tags: Mapping[str, Any]):
        """
        :param str bandwidth: EIP internet max bandwidth in Mbps.
        :param bool deletion_protection: (Optional, Available in v1.124.4+) Whether enable the deletion protection or not.
        :param str id: ID of the EIP.
        :param str instance_id: The ID of the instance that is being bound.
        :param str instance_type: The instance type of that the EIP is bound.
        :param str internet_charge_type: EIP internet charge type.
        :param str ip_address: Public IP Address of the the EIP.
        :param str resource_group_id: The Id of resource group which the eips belongs.
        :param str status: EIP status. Possible values are: `Associating`, `Unassociating`, `InUse` and `Available`.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "address_name", address_name)
        pulumi.set(__self__, "allocation_id", allocation_id)
        pulumi.set(__self__, "available_regions", available_regions)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "bandwidth_package_bandwidth", bandwidth_package_bandwidth)
        pulumi.set(__self__, "bandwidth_package_id", bandwidth_package_id)
        pulumi.set(__self__, "bandwidth_package_type", bandwidth_package_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "has_reservation_data", has_reservation_data)
        pulumi.set(__self__, "hd_monitor_status", hd_monitor_status)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_region_id", instance_region_id)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "isp", isp)
        pulumi.set(__self__, "operation_locks", operation_locks)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "reservation_active_time", reservation_active_time)
        pulumi.set(__self__, "reservation_bandwidth", reservation_bandwidth)
        pulumi.set(__self__, "reservation_internet_charge_type", reservation_internet_charge_type)
        pulumi.set(__self__, "reservation_order_type", reservation_order_type)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "second_limited", second_limited)
        pulumi.set(__self__, "segment_instance_id", segment_instance_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="addressName")
    def address_name(self) -> str:
        return pulumi.get(self, "address_name")

    @property
    @pulumi.getter(name="allocationId")
    def allocation_id(self) -> str:
        return pulumi.get(self, "allocation_id")

    @property
    @pulumi.getter(name="availableRegions")
    def available_regions(self) -> Sequence[str]:
        return pulumi.get(self, "available_regions")

    @property
    @pulumi.getter
    def bandwidth(self) -> str:
        """
        EIP internet max bandwidth in Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="bandwidthPackageBandwidth")
    def bandwidth_package_bandwidth(self) -> str:
        return pulumi.get(self, "bandwidth_package_bandwidth")

    @property
    @pulumi.getter(name="bandwidthPackageId")
    def bandwidth_package_id(self) -> str:
        return pulumi.get(self, "bandwidth_package_id")

    @property
    @pulumi.getter(name="bandwidthPackageType")
    def bandwidth_package_type(self) -> str:
        return pulumi.get(self, "bandwidth_package_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        """
        (Optional, Available in v1.124.4+) Whether enable the deletion protection or not.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter(name="hasReservationData")
    def has_reservation_data(self) -> str:
        return pulumi.get(self, "has_reservation_data")

    @property
    @pulumi.getter(name="hdMonitorStatus")
    def hd_monitor_status(self) -> str:
        return pulumi.get(self, "hd_monitor_status")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the EIP.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the instance that is being bound.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceRegionId")
    def instance_region_id(self) -> str:
        return pulumi.get(self, "instance_region_id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The instance type of that the EIP is bound.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> str:
        """
        EIP internet charge type.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        Public IP Address of the the EIP.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def isp(self) -> str:
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter(name="operationLocks")
    def operation_locks(self) -> Sequence[str]:
        return pulumi.get(self, "operation_locks")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="reservationActiveTime")
    def reservation_active_time(self) -> str:
        return pulumi.get(self, "reservation_active_time")

    @property
    @pulumi.getter(name="reservationBandwidth")
    def reservation_bandwidth(self) -> str:
        return pulumi.get(self, "reservation_bandwidth")

    @property
    @pulumi.getter(name="reservationInternetChargeType")
    def reservation_internet_charge_type(self) -> str:
        return pulumi.get(self, "reservation_internet_charge_type")

    @property
    @pulumi.getter(name="reservationOrderType")
    def reservation_order_type(self) -> str:
        return pulumi.get(self, "reservation_order_type")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which the eips belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="secondLimited")
    def second_limited(self) -> bool:
        return pulumi.get(self, "second_limited")

    @property
    @pulumi.getter(name="segmentInstanceId")
    def segment_instance_id(self) -> str:
        return pulumi.get(self, "segment_instance_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        EIP status. Possible values are: `Associating`, `Unassociating`, `InUse` and `Available`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetEipsEipResult(dict):
    def __init__(__self__, *,
                 bandwidth: str,
                 creation_time: str,
                 deletion_protection: bool,
                 id: str,
                 instance_id: str,
                 instance_type: str,
                 internet_charge_type: str,
                 ip_address: str,
                 status: str):
        """
        :param str bandwidth: EIP internet max bandwidth in Mbps.
        :param str creation_time: Time of creation.
        :param bool deletion_protection: (Optional, Available in v1.124.4+) Whether enable the deletion protection or not.
        :param str id: ID of the EIP.
        :param str instance_id: The ID of the instance that is being bound.
        :param str instance_type: The instance type of that the EIP is bound.
        :param str internet_charge_type: EIP internet charge type.
        :param str ip_address: Public IP Address of the the EIP.
        :param str status: EIP status. Possible values are: `Associating`, `Unassociating`, `InUse` and `Available`.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def bandwidth(self) -> str:
        """
        EIP internet max bandwidth in Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Time of creation.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        """
        (Optional, Available in v1.124.4+) Whether enable the deletion protection or not.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the EIP.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the instance that is being bound.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The instance type of that the EIP is bound.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> str:
        """
        EIP internet charge type.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        Public IP Address of the the EIP.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        EIP status. Possible values are: `Associating`, `Unassociating`, `InUse` and `Available`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetElasticityAssurancesAssuranceResult(dict):
    def __init__(__self__, *,
                 allocated_resources: Sequence['outputs.GetElasticityAssurancesAssuranceAllocatedResourceResult'],
                 description: str,
                 elasticity_assurance_id: str,
                 end_time: str,
                 id: str,
                 instance_charge_type: str,
                 private_pool_options_id: str,
                 private_pool_options_match_criteria: str,
                 private_pool_options_name: str,
                 resource_group_id: str,
                 start_time: str,
                 start_time_type: str,
                 status: str,
                 total_assurance_times: str,
                 used_assurance_times: int,
                 tags: Optional[Mapping[str, Any]] = None):
        """
        :param Sequence['GetElasticityAssurancesAssuranceAllocatedResourceArgs'] allocated_resources: Details of resource allocation.
        :param str description: Description of flexible guarantee service.
        :param str elasticity_assurance_id: The first ID of the resource
        :param str end_time: Flexible guarantee service failure time.
        :param str id: ID of flexible guarantee service.
        :param str instance_charge_type: The billing method of the instance. Possible value: PostPaid. Currently, only pay-as-you-go is supported.
        :param str private_pool_options_id: The ID of the elasticity assurance.
        :param str private_pool_options_match_criteria: The matching mode of flexible guarantee service. Possible values:-Open: flexible guarantee service for Open mode.-Target: specifies the flexible guarantee service of the mode.
        :param str private_pool_options_name: The name of the elasticity assurance.
        :param str resource_group_id: The ID of the resource group.
        :param str start_time: Flexible guarantee service effective time.
        :param str start_time_type: Flexible guarantee effective way. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
        :param str status: The status of flexible guarantee services. Possible values: `All`, `Preparing`, `Prepared`, `Active`, `Released`.
        :param str total_assurance_times: The total number of flexible guarantee services.
        :param int used_assurance_times: This parameter is not yet available.
        :param Mapping[str, Any] tags: The tag key-value pair information bound by the elastic guarantee service.
        """
        pulumi.set(__self__, "allocated_resources", allocated_resources)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "elasticity_assurance_id", elasticity_assurance_id)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        pulumi.set(__self__, "private_pool_options_id", private_pool_options_id)
        pulumi.set(__self__, "private_pool_options_match_criteria", private_pool_options_match_criteria)
        pulumi.set(__self__, "private_pool_options_name", private_pool_options_name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "start_time_type", start_time_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "total_assurance_times", total_assurance_times)
        pulumi.set(__self__, "used_assurance_times", used_assurance_times)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="allocatedResources")
    def allocated_resources(self) -> Sequence['outputs.GetElasticityAssurancesAssuranceAllocatedResourceResult']:
        """
        Details of resource allocation.
        """
        return pulumi.get(self, "allocated_resources")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of flexible guarantee service.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="elasticityAssuranceId")
    def elasticity_assurance_id(self) -> str:
        """
        The first ID of the resource
        """
        return pulumi.get(self, "elasticity_assurance_id")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Flexible guarantee service failure time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of flexible guarantee service.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> str:
        """
        The billing method of the instance. Possible value: PostPaid. Currently, only pay-as-you-go is supported.
        """
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="privatePoolOptionsId")
    def private_pool_options_id(self) -> str:
        """
        The ID of the elasticity assurance.
        """
        return pulumi.get(self, "private_pool_options_id")

    @property
    @pulumi.getter(name="privatePoolOptionsMatchCriteria")
    def private_pool_options_match_criteria(self) -> str:
        """
        The matching mode of flexible guarantee service. Possible values:-Open: flexible guarantee service for Open mode.-Target: specifies the flexible guarantee service of the mode.
        """
        return pulumi.get(self, "private_pool_options_match_criteria")

    @property
    @pulumi.getter(name="privatePoolOptionsName")
    def private_pool_options_name(self) -> str:
        """
        The name of the elasticity assurance.
        """
        return pulumi.get(self, "private_pool_options_name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of the resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Flexible guarantee service effective time.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="startTimeType")
    def start_time_type(self) -> str:
        """
        Flexible guarantee effective way. Possible values:-Now: Effective immediately.-Later: the specified time takes effect.
        """
        return pulumi.get(self, "start_time_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of flexible guarantee services. Possible values: `All`, `Preparing`, `Prepared`, `Active`, `Released`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="totalAssuranceTimes")
    def total_assurance_times(self) -> str:
        """
        The total number of flexible guarantee services.
        """
        return pulumi.get(self, "total_assurance_times")

    @property
    @pulumi.getter(name="usedAssuranceTimes")
    def used_assurance_times(self) -> int:
        """
        This parameter is not yet available.
        """
        return pulumi.get(self, "used_assurance_times")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        """
        The tag key-value pair information bound by the elastic guarantee service.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetElasticityAssurancesAssuranceAllocatedResourceResult(dict):
    def __init__(__self__, *,
                 instance_type: str,
                 total_amount: int,
                 used_amount: int,
                 zone_id: str):
        """
        :param str instance_type: Instance type.
        :param int total_amount: The total number of instances that need to be reserved within an instance type.
        :param int used_amount: The number of instances that have been used.
        :param str zone_id: The zone ID.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "total_amount", total_amount)
        pulumi.set(__self__, "used_amount", used_amount)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="totalAmount")
    def total_amount(self) -> int:
        """
        The total number of instances that need to be reserved within an instance type.
        """
        return pulumi.get(self, "total_amount")

    @property
    @pulumi.getter(name="usedAmount")
    def used_amount(self) -> int:
        """
        The number of instances that have been used.
        """
        return pulumi.get(self, "used_amount")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone ID.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetHpcClustersClusterResult(dict):
    def __init__(__self__, *,
                 description: str,
                 hpc_cluster_id: str,
                 id: str,
                 name: str):
        """
        :param str description: The description of ECS Hpc Cluster.
        :param str hpc_cluster_id: The ID of the Hpc Cluster.
        :param str id: The ID of the Hpc Cluster.
        :param str name: The name of ECS Hpc Cluster.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "hpc_cluster_id", hpc_cluster_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of ECS Hpc Cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="hpcClusterId")
    def hpc_cluster_id(self) -> str:
        """
        The ID of the Hpc Cluster.
        """
        return pulumi.get(self, "hpc_cluster_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Hpc Cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of ECS Hpc Cluster.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetImagesImageResult(dict):
    def __init__(__self__, *,
                 architecture: str,
                 creation_time: str,
                 description: str,
                 disk_device_mappings: Sequence['outputs.GetImagesImageDiskDeviceMappingResult'],
                 id: str,
                 image_id: str,
                 image_owner_alias: str,
                 image_version: str,
                 is_copied: bool,
                 is_self_shared: str,
                 is_subscribed: bool,
                 is_support_io_optimized: bool,
                 name: str,
                 os_name: str,
                 os_name_en: str,
                 os_type: str,
                 platform: str,
                 product_code: str,
                 progress: str,
                 size: int,
                 state: str,
                 status: str,
                 usage: str,
                 tags: Optional[Mapping[str, Any]] = None):
        """
        :param str architecture: The image architecture. Valid values: `i386` and `x86_64`.
        :param str creation_time: Time of creation.
        :param str description: Description of the image.
        :param Sequence['GetImagesImageDiskDeviceMappingArgs'] disk_device_mappings: Description of the system with disks and snapshots under the image.
        :param str id: ID of the image.
        :param str image_id: The ID of the image.
        :param str image_owner_alias: Alias of the image owner.
        :param str image_version: Version of the image.
        :param bool is_subscribed: Whether the user has subscribed to the terms of service for the image product corresponding to the ProductCode.
        :param bool is_support_io_optimized: Specifies whether the image can be used on I/O optimized instances.
        :param str os_name: Display Chinese name of the OS.
        :param str os_name_en: Display English name of the OS.
        :param str os_type: The operating system type of the image. Valid values: `windows` and `linux`.
        :param str product_code: Product code of the image on the image market.
        :param str progress: Progress of image creation, presented in percentages.
        :param int size: Size of the created disk.
        :param str status: The status of the image. The following values are available, Separate multiple parameter values by using commas (,). Default value: `Available`. Valid values:
        :param str usage: Specifies whether to check the validity of the request without actually making the request. Valid values:
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disk_device_mappings", disk_device_mappings)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_owner_alias", image_owner_alias)
        pulumi.set(__self__, "image_version", image_version)
        pulumi.set(__self__, "is_copied", is_copied)
        pulumi.set(__self__, "is_self_shared", is_self_shared)
        pulumi.set(__self__, "is_subscribed", is_subscribed)
        pulumi.set(__self__, "is_support_io_optimized", is_support_io_optimized)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "os_name", os_name)
        pulumi.set(__self__, "os_name_en", os_name_en)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "product_code", product_code)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "usage", usage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def architecture(self) -> str:
        """
        The image architecture. Valid values: `i386` and `x86_64`.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Time of creation.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the image.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskDeviceMappings")
    def disk_device_mappings(self) -> Sequence['outputs.GetImagesImageDiskDeviceMappingResult']:
        """
        Description of the system with disks and snapshots under the image.
        """
        return pulumi.get(self, "disk_device_mappings")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the image.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The ID of the image.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageOwnerAlias")
    def image_owner_alias(self) -> str:
        """
        Alias of the image owner.
        """
        return pulumi.get(self, "image_owner_alias")

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> str:
        """
        Version of the image.
        """
        return pulumi.get(self, "image_version")

    @property
    @pulumi.getter(name="isCopied")
    def is_copied(self) -> bool:
        return pulumi.get(self, "is_copied")

    @property
    @pulumi.getter(name="isSelfShared")
    def is_self_shared(self) -> str:
        return pulumi.get(self, "is_self_shared")

    @property
    @pulumi.getter(name="isSubscribed")
    def is_subscribed(self) -> bool:
        """
        Whether the user has subscribed to the terms of service for the image product corresponding to the ProductCode.
        """
        return pulumi.get(self, "is_subscribed")

    @property
    @pulumi.getter(name="isSupportIoOptimized")
    def is_support_io_optimized(self) -> bool:
        """
        Specifies whether the image can be used on I/O optimized instances.
        """
        return pulumi.get(self, "is_support_io_optimized")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osName")
    def os_name(self) -> str:
        """
        Display Chinese name of the OS.
        """
        return pulumi.get(self, "os_name")

    @property
    @pulumi.getter(name="osNameEn")
    def os_name_en(self) -> str:
        """
        Display English name of the OS.
        """
        return pulumi.get(self, "os_name_en")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The operating system type of the image. Valid values: `windows` and `linux`.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def platform(self) -> str:
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="productCode")
    def product_code(self) -> str:
        """
        Product code of the image on the image market.
        """
        return pulumi.get(self, "product_code")

    @property
    @pulumi.getter
    def progress(self) -> str:
        """
        Progress of image creation, presented in percentages.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Size of the created disk.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def state(self) -> str:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the image. The following values are available, Separate multiple parameter values by using commas (,). Default value: `Available`. Valid values:
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def usage(self) -> str:
        """
        Specifies whether to check the validity of the request without actually making the request. Valid values:
        """
        return pulumi.get(self, "usage")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetImagesImageDiskDeviceMappingResult(dict):
    def __init__(__self__, *,
                 device: str,
                 size: str,
                 snapshot_id: str):
        """
        :param str device: Device information of the created disk: such as /dev/xvdb.
        :param str size: Size of the created disk.
        :param str snapshot_id: The ID of the snapshot used to create the custom image.
        """
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter
    def device(self) -> str:
        """
        Device information of the created disk: such as /dev/xvdb.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def size(self) -> str:
        """
        Size of the created disk.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> str:
        """
        The ID of the snapshot used to create the custom image.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class GetInstanceTypeFamiliesFamilyResult(dict):
    def __init__(__self__, *,
                 generation: str,
                 id: str,
                 zone_ids: Sequence[str]):
        """
        :param str generation: The generation of the instance type family, Valid values: `ecs-1`, `ecs-2`, `ecs-3`, `ecs-4`, `ecs-5`, `ecs-6`. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.htm).
        :param str id: ID of the instance type family.
        :param Sequence[str] zone_ids: A list of Zone to launch the instance.
        """
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "zone_ids", zone_ids)

    @property
    @pulumi.getter
    def generation(self) -> str:
        """
        The generation of the instance type family, Valid values: `ecs-1`, `ecs-2`, `ecs-3`, `ecs-4`, `ecs-5`, `ecs-6`. For more information, see [Instance type families](https://www.alibabacloud.com/help/doc-detail/25378.htm).
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the instance type family.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Sequence[str]:
        """
        A list of Zone to launch the instance.
        """
        return pulumi.get(self, "zone_ids")


@pulumi.output_type
class GetInstanceTypesInstanceTypeResult(dict):
    def __init__(__self__, *,
                 availability_zones: Sequence[str],
                 burstable_instance: 'outputs.GetInstanceTypesInstanceTypeBurstableInstanceResult',
                 cpu_core_count: int,
                 eni_amount: int,
                 family: str,
                 gpu: 'outputs.GetInstanceTypesInstanceTypeGpuResult',
                 id: str,
                 local_storage: 'outputs.GetInstanceTypesInstanceTypeLocalStorageResult',
                 memory_size: float,
                 nvme_support: str,
                 price: str):
        """
        :param Sequence[str] availability_zones: List of availability zones that support the instance type.
        :param 'GetInstanceTypesInstanceTypeBurstableInstanceArgs' burstable_instance: The burstable instance attribution:
               - initial_credit: The initial CPU credit of a burstable instance.
               - baseline_credit:  The compute performance benchmark CPU credit of a burstable instance.
        :param int cpu_core_count: Filter the results to a specific number of cpu cores.
        :param int eni_amount: Filter the result whose network interface number is no more than `eni_amount`.
        :param str family: The instance type family.
        :param 'GetInstanceTypesInstanceTypeGpuArgs' gpu: The GPU attribution of an instance type:
               - amount: The amount of GPU of an instance type.
               - category: The category of GPU of an instance type.
        :param str id: ID of the instance type.
        :param 'GetInstanceTypesInstanceTypeLocalStorageArgs' local_storage: Local storage of an instance type:
               - capacity: The capacity of a local storage in GB.
               - amount:  The number of local storage devices that an instance has been attached to.
               - category: The category of local storage that an instance has been attached to.
        :param float memory_size: Filter the results to a specific memory size in GB.
        :param str nvme_support: Indicates whether the cloud disk can be attached by using the nonvolatile memory express (NVMe) protocol. Valid values:
               - required: The cloud disk can be attached by using the NVMe protocol.
               - unsupported: The cloud disk cannot be attached by using the NVMe protocol.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "burstable_instance", burstable_instance)
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        pulumi.set(__self__, "eni_amount", eni_amount)
        pulumi.set(__self__, "family", family)
        pulumi.set(__self__, "gpu", gpu)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "local_storage", local_storage)
        pulumi.set(__self__, "memory_size", memory_size)
        pulumi.set(__self__, "nvme_support", nvme_support)
        pulumi.set(__self__, "price", price)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[str]:
        """
        List of availability zones that support the instance type.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="burstableInstance")
    def burstable_instance(self) -> 'outputs.GetInstanceTypesInstanceTypeBurstableInstanceResult':
        """
        The burstable instance attribution:
        - initial_credit: The initial CPU credit of a burstable instance.
        - baseline_credit:  The compute performance benchmark CPU credit of a burstable instance.
        """
        return pulumi.get(self, "burstable_instance")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> int:
        """
        Filter the results to a specific number of cpu cores.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="eniAmount")
    def eni_amount(self) -> int:
        """
        Filter the result whose network interface number is no more than `eni_amount`.
        """
        return pulumi.get(self, "eni_amount")

    @property
    @pulumi.getter
    def family(self) -> str:
        """
        The instance type family.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def gpu(self) -> 'outputs.GetInstanceTypesInstanceTypeGpuResult':
        """
        The GPU attribution of an instance type:
        - amount: The amount of GPU of an instance type.
        - category: The category of GPU of an instance type.
        """
        return pulumi.get(self, "gpu")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the instance type.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localStorage")
    def local_storage(self) -> 'outputs.GetInstanceTypesInstanceTypeLocalStorageResult':
        """
        Local storage of an instance type:
        - capacity: The capacity of a local storage in GB.
        - amount:  The number of local storage devices that an instance has been attached to.
        - category: The category of local storage that an instance has been attached to.
        """
        return pulumi.get(self, "local_storage")

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> float:
        """
        Filter the results to a specific memory size in GB.
        """
        return pulumi.get(self, "memory_size")

    @property
    @pulumi.getter(name="nvmeSupport")
    def nvme_support(self) -> str:
        """
        Indicates whether the cloud disk can be attached by using the nonvolatile memory express (NVMe) protocol. Valid values:
        - required: The cloud disk can be attached by using the NVMe protocol.
        - unsupported: The cloud disk cannot be attached by using the NVMe protocol.
        """
        return pulumi.get(self, "nvme_support")

    @property
    @pulumi.getter
    def price(self) -> str:
        return pulumi.get(self, "price")


@pulumi.output_type
class GetInstanceTypesInstanceTypeBurstableInstanceResult(dict):
    def __init__(__self__, *,
                 baseline_credit: str,
                 initial_credit: str):
        pulumi.set(__self__, "baseline_credit", baseline_credit)
        pulumi.set(__self__, "initial_credit", initial_credit)

    @property
    @pulumi.getter(name="baselineCredit")
    def baseline_credit(self) -> str:
        return pulumi.get(self, "baseline_credit")

    @property
    @pulumi.getter(name="initialCredit")
    def initial_credit(self) -> str:
        return pulumi.get(self, "initial_credit")


@pulumi.output_type
class GetInstanceTypesInstanceTypeGpuResult(dict):
    def __init__(__self__, *,
                 amount: str,
                 category: str):
        pulumi.set(__self__, "amount", amount)
        pulumi.set(__self__, "category", category)

    @property
    @pulumi.getter
    def amount(self) -> str:
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter
    def category(self) -> str:
        return pulumi.get(self, "category")


@pulumi.output_type
class GetInstanceTypesInstanceTypeLocalStorageResult(dict):
    def __init__(__self__, *,
                 amount: str,
                 capacity: str,
                 category: str):
        pulumi.set(__self__, "amount", amount)
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "category", category)

    @property
    @pulumi.getter
    def amount(self) -> str:
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter
    def capacity(self) -> str:
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def category(self) -> str:
        return pulumi.get(self, "category")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 creation_time: str,
                 description: str,
                 disk_device_mappings: Sequence['outputs.GetInstancesInstanceDiskDeviceMappingResult'],
                 eip: str,
                 id: str,
                 image_id: str,
                 instance_charge_type: str,
                 instance_type: str,
                 internet_charge_type: str,
                 internet_max_bandwidth_out: int,
                 key_name: str,
                 name: str,
                 private_ip: str,
                 public_ip: str,
                 ram_role_name: str,
                 region_id: str,
                 resource_group_id: str,
                 security_groups: Sequence[str],
                 spot_strategy: str,
                 status: str,
                 vpc_id: str,
                 vswitch_id: str,
                 tags: Optional[Mapping[str, Any]] = None):
        """
        :param str availability_zone: Availability zone where instances are located.
        :param str creation_time: Instance creation time.
        :param str description: Instance description.
        :param Sequence['GetInstancesInstanceDiskDeviceMappingArgs'] disk_device_mappings: Description of the attached disks.
        :param str eip: EIP address the VPC instance is using.
        :param str id: ID of the instance.
        :param str image_id: The image ID of some ECS instance used.
        :param str instance_charge_type: Instance charge type.
        :param str instance_type: Instance type.
        :param str internet_charge_type: Instance network charge type.
        :param int internet_max_bandwidth_out: Max output bandwidth for internet.
        :param str key_name: Key pair the instance is using.
        :param str name: Instance name.
        :param str private_ip: Instance private IP address.
        :param str public_ip: Instance public IP address.
        :param str ram_role_name: The RAM role name which the instance attaches.
        :param str region_id: Region ID the instance belongs to.
        :param str resource_group_id: The ID of resource group which the instance belongs.
        :param Sequence[str] security_groups: List of security group IDs the instance belongs to.
        :param str spot_strategy: Spot strategy the instance is using.
        :param str status: Instance status. Valid values: "Creating", "Starting", "Running", "Stopping" and "Stopped". If undefined, all statuses are considered.
        :param str vpc_id: ID of the VPC linked to the instances.
        :param str vswitch_id: ID of the VSwitch linked to the instances.
        :param Mapping[str, Any] tags: A map of tags assigned to the ECS instances. It must be in the format:
               ```python
               import pulumi
               import pulumi_alicloud as alicloud
               
               tagged_instances = alicloud.ecs.get_instances(tags={
                   "tagKey1": "tagValue1",
                   "tagKey2": "tagValue2",
               })
               ```
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disk_device_mappings", disk_device_mappings)
        pulumi.set(__self__, "eip", eip)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "ram_role_name", ram_role_name)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "security_groups", security_groups)
        pulumi.set(__self__, "spot_strategy", spot_strategy)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Availability zone where instances are located.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Instance creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Instance description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskDeviceMappings")
    def disk_device_mappings(self) -> Sequence['outputs.GetInstancesInstanceDiskDeviceMappingResult']:
        """
        Description of the attached disks.
        """
        return pulumi.get(self, "disk_device_mappings")

    @property
    @pulumi.getter
    def eip(self) -> str:
        """
        EIP address the VPC instance is using.
        """
        return pulumi.get(self, "eip")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The image ID of some ECS instance used.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> str:
        """
        Instance charge type.
        """
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Instance type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> str:
        """
        Instance network charge type.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> int:
        """
        Max output bandwidth for internet.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        Key pair the instance is using.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Instance name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        Instance private IP address.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        Instance public IP address.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> str:
        """
        The RAM role name which the instance attaches.
        """
        return pulumi.get(self, "ram_role_name")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        Region ID the instance belongs to.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The ID of resource group which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence[str]:
        """
        List of security group IDs the instance belongs to.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> str:
        """
        Spot strategy the instance is using.
        """
        return pulumi.get(self, "spot_strategy")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Instance status. Valid values: "Creating", "Starting", "Running", "Stopping" and "Stopped". If undefined, all statuses are considered.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        ID of the VPC linked to the instances.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        ID of the VSwitch linked to the instances.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        """
        A map of tags assigned to the ECS instances. It must be in the format:
        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        tagged_instances = alicloud.ecs.get_instances(tags={
            "tagKey1": "tagValue1",
            "tagKey2": "tagValue2",
        })
        ```
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetInstancesInstanceDiskDeviceMappingResult(dict):
    def __init__(__self__, *,
                 category: str,
                 device: str,
                 disk_id: str,
                 disk_name: str,
                 size: int,
                 type: str):
        """
        :param str category: Cloud disk category.
        :param str device: Device information of the created disk: such as /dev/xvdb.
        :param str disk_id: The ID of the Disk.
        :param str disk_name: The name of the Disk.
        :param int size: Size of the created disk.
        :param str type: Cloud disk type: system disk or data disk.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "disk_name", disk_name)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Cloud disk category.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def device(self) -> str:
        """
        Device information of the created disk: such as /dev/xvdb.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> str:
        """
        The ID of the Disk.
        """
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="diskName")
    def disk_name(self) -> str:
        """
        The name of the Disk.
        """
        return pulumi.get(self, "disk_name")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Size of the created disk.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Cloud disk type: system disk or data disk.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetKeyPairsKeyPairResult(dict):
    def __init__(__self__, *,
                 finger_print: str,
                 id: str,
                 instances: Sequence['outputs.GetKeyPairsKeyPairInstanceResult'],
                 key_name: str,
                 key_pair_name: str,
                 resource_group_id: str,
                 tags: Mapping[str, Any]):
        """
        :param str finger_print: A finger print used to retrieve specified key pair.
        :param str id: ID of the key pair.
        :param Sequence['GetKeyPairsKeyPairInstanceArgs'] instances: A list of ECS instances that has been bound this key pair.
        :param str key_name: Name of the key pair.
        :param str resource_group_id: The Id of resource group which the key pair belongs.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "finger_print", finger_print)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="fingerPrint")
    def finger_print(self) -> str:
        """
        A finger print used to retrieve specified key pair.
        """
        return pulumi.get(self, "finger_print")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the key pair.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetKeyPairsKeyPairInstanceResult']:
        """
        A list of ECS instances that has been bound this key pair.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        Name of the key pair.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> str:
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which the key pair belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetKeyPairsKeyPairInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 description: str,
                 image_id: str,
                 instance_id: str,
                 instance_name: str,
                 instance_type: str,
                 key_name: str,
                 private_ip: str,
                 public_ip: str,
                 region_id: str,
                 status: str,
                 vswitch_id: str):
        """
        :param str availability_zone: The ID of the availability zone where the ECS instance is located.
        :param str instance_id: The ID of the ECS instance.
        :param str instance_name: The name of the ECS instance.
        :param str key_name: Name of the key pair.
        :param str private_ip: The private IP address of the ECS instance.
        :param str public_ip: The public IP address or EIP of the ECS instance.
        :param str vswitch_id: The ID of the VSwitch attached to the ECS instance.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        The ID of the availability zone where the ECS instance is located.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of the ECS instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        Name of the key pair.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address of the ECS instance.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        The public IP address or EIP of the ECS instance.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The ID of the VSwitch attached to the ECS instance.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetKeyPairsPairResult(dict):
    def __init__(__self__, *,
                 finger_print: str,
                 id: str,
                 instances: Sequence['outputs.GetKeyPairsPairInstanceResult'],
                 key_name: str,
                 key_pair_name: str,
                 resource_group_id: str,
                 tags: Mapping[str, Any]):
        """
        :param str finger_print: A finger print used to retrieve specified key pair.
        :param str id: ID of the key pair.
        :param Sequence['GetKeyPairsPairInstanceArgs'] instances: A list of ECS instances that has been bound this key pair.
        :param str key_name: Name of the key pair.
        :param str resource_group_id: The Id of resource group which the key pair belongs.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "finger_print", finger_print)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="fingerPrint")
    def finger_print(self) -> str:
        """
        A finger print used to retrieve specified key pair.
        """
        return pulumi.get(self, "finger_print")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the key pair.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetKeyPairsPairInstanceResult']:
        """
        A list of ECS instances that has been bound this key pair.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        Name of the key pair.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> str:
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which the key pair belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetKeyPairsPairInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 description: str,
                 image_id: str,
                 instance_id: str,
                 instance_name: str,
                 instance_type: str,
                 key_name: str,
                 private_ip: str,
                 public_ip: str,
                 region_id: str,
                 status: str,
                 vswitch_id: str):
        """
        :param str availability_zone: The ID of the availability zone where the ECS instance is located.
        :param str instance_id: The ID of the ECS instance.
        :param str instance_name: The name of the ECS instance.
        :param str key_name: Name of the key pair.
        :param str private_ip: The private IP address of the ECS instance.
        :param str public_ip: The public IP address or EIP of the ECS instance.
        :param str vswitch_id: The ID of the VSwitch attached to the ECS instance.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        The ID of the availability zone where the ECS instance is located.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The ID of the ECS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of the ECS instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> str:
        """
        Name of the key pair.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address of the ECS instance.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        The public IP address or EIP of the ECS instance.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The ID of the VSwitch attached to the ECS instance.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetNetworkInterfacesInterfaceResult(dict):
    def __init__(__self__, *,
                 associated_public_ips: Sequence['outputs.GetNetworkInterfacesInterfaceAssociatedPublicIpResult'],
                 creation_time: str,
                 description: str,
                 id: str,
                 instance_id: str,
                 mac: str,
                 name: str,
                 network_interface_id: str,
                 network_interface_name: str,
                 network_interface_traffic_mode: str,
                 owner_id: str,
                 primary_ip_address: str,
                 private_ip: str,
                 private_ip_addresses: Sequence[str],
                 private_ips: Sequence[str],
                 queue_number: int,
                 resource_group_id: str,
                 security_group_ids: Sequence[str],
                 security_groups: Sequence[str],
                 service_id: int,
                 service_managed: bool,
                 status: str,
                 tags: Mapping[str, Any],
                 type: str,
                 vpc_id: str,
                 vswitch_id: str,
                 zone_id: str):
        """
        :param str creation_time: Creation time of the ENI.
        :param str description: Description of the ENI.
        :param str id: ID of the ENI.
        :param str instance_id: ID of the instance that the ENI is attached to.
        :param str mac: MAC address of the ENI.
        :param str name: Name of the ENI.
        :param str private_ip: Primary private IP of the ENI.
        :param Sequence[str] private_ips: A list of secondary private IP address that is assigned to the ENI.
        :param str resource_group_id: The Id of resource group.
        :param Sequence[str] security_groups: A list of security group that the ENI belongs to.
        :param str status: Current status of the ENI.
        :param Mapping[str, Any] tags: A map of tags assigned to the ENI.
        :param str vpc_id: ID of the VPC that the ENI belongs to.
        :param str vswitch_id: ID of the VSwitch that the ENI is linked to.
        :param str zone_id: ID of the availability zone that the ENI belongs to.
        """
        pulumi.set(__self__, "associated_public_ips", associated_public_ips)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "mac", mac)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "network_interface_name", network_interface_name)
        pulumi.set(__self__, "network_interface_traffic_mode", network_interface_traffic_mode)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "primary_ip_address", primary_ip_address)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        pulumi.set(__self__, "private_ips", private_ips)
        pulumi.set(__self__, "queue_number", queue_number)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "security_groups", security_groups)
        pulumi.set(__self__, "service_id", service_id)
        pulumi.set(__self__, "service_managed", service_managed)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="associatedPublicIps")
    def associated_public_ips(self) -> Sequence['outputs.GetNetworkInterfacesInterfaceAssociatedPublicIpResult']:
        return pulumi.get(self, "associated_public_ips")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Creation time of the ENI.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the ENI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the ENI.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        ID of the instance that the ENI is attached to.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def mac(self) -> str:
        """
        MAC address of the ENI.
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the ENI.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> str:
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter(name="networkInterfaceName")
    def network_interface_name(self) -> str:
        return pulumi.get(self, "network_interface_name")

    @property
    @pulumi.getter(name="networkInterfaceTrafficMode")
    def network_interface_traffic_mode(self) -> str:
        return pulumi.get(self, "network_interface_traffic_mode")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> str:
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="primaryIpAddress")
    def primary_ip_address(self) -> str:
        return pulumi.get(self, "primary_ip_address")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        Primary private IP of the ENI.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Sequence[str]:
        return pulumi.get(self, "private_ip_addresses")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence[str]:
        """
        A list of secondary private IP address that is assigned to the ENI.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="queueNumber")
    def queue_number(self) -> int:
        return pulumi.get(self, "queue_number")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[str]:
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence[str]:
        """
        A list of security group that the ENI belongs to.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> int:
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="serviceManaged")
    def service_managed(self) -> bool:
        return pulumi.get(self, "service_managed")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current status of the ENI.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A map of tags assigned to the ENI.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        ID of the VPC that the ENI belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        ID of the VSwitch that the ENI is linked to.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        ID of the availability zone that the ENI belongs to.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetNetworkInterfacesInterfaceAssociatedPublicIpResult(dict):
    def __init__(__self__, *,
                 public_ip_address: str):
        pulumi.set(__self__, "public_ip_address", public_ip_address)

    @property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> str:
        return pulumi.get(self, "public_ip_address")


@pulumi.output_type
class GetSecurityGroupRulesRuleResult(dict):
    def __init__(__self__, *,
                 description: str,
                 dest_cidr_ip: str,
                 dest_group_id: str,
                 dest_group_owner_account: str,
                 direction: str,
                 ip_protocol: str,
                 nic_type: str,
                 policy: str,
                 port_range: str,
                 priority: int,
                 source_cidr_ip: str,
                 source_group_id: str,
                 source_group_owner_account: str):
        """
        :param str description: The description of the rule.
        :param str dest_cidr_ip: Target IP address segment for egress authorization.
        :param str dest_group_id: Target security group id for ingress authorization.
        :param str dest_group_owner_account: Alibaba Cloud account of the target security group.
        :param str direction: Authorization direction. Valid values are: `ingress` or `egress`.
        :param str ip_protocol: The IP protocol. Valid values are: `tcp`, `udp`, `icmp`, `gre` and `all`.
        :param str nic_type: Refers to the network type. Can be either `internet` or `intranet`. The default value is `internet`.
        :param str policy: Authorization policy. Can be either `accept` or `drop`. The default value is `accept`.
        :param str port_range: The range of port numbers.
        :param int priority: Rule priority.
        :param str source_cidr_ip: Source IP address segment for ingress authorization.
        :param str source_group_id: Source security group ID for ingress authorization.
        :param str source_group_owner_account: Alibaba Cloud account of the source security group.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dest_cidr_ip", dest_cidr_ip)
        pulumi.set(__self__, "dest_group_id", dest_group_id)
        pulumi.set(__self__, "dest_group_owner_account", dest_group_owner_account)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "nic_type", nic_type)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "port_range", port_range)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "source_cidr_ip", source_cidr_ip)
        pulumi.set(__self__, "source_group_id", source_group_id)
        pulumi.set(__self__, "source_group_owner_account", source_group_owner_account)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destCidrIp")
    def dest_cidr_ip(self) -> str:
        """
        Target IP address segment for egress authorization.
        """
        return pulumi.get(self, "dest_cidr_ip")

    @property
    @pulumi.getter(name="destGroupId")
    def dest_group_id(self) -> str:
        """
        Target security group id for ingress authorization.
        """
        return pulumi.get(self, "dest_group_id")

    @property
    @pulumi.getter(name="destGroupOwnerAccount")
    def dest_group_owner_account(self) -> str:
        """
        Alibaba Cloud account of the target security group.
        """
        return pulumi.get(self, "dest_group_owner_account")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        Authorization direction. Valid values are: `ingress` or `egress`.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> str:
        """
        The IP protocol. Valid values are: `tcp`, `udp`, `icmp`, `gre` and `all`.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter(name="nicType")
    def nic_type(self) -> str:
        """
        Refers to the network type. Can be either `internet` or `intranet`. The default value is `internet`.
        """
        return pulumi.get(self, "nic_type")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        Authorization policy. Can be either `accept` or `drop`. The default value is `accept`.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> str:
        """
        The range of port numbers.
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Rule priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="sourceCidrIp")
    def source_cidr_ip(self) -> str:
        """
        Source IP address segment for ingress authorization.
        """
        return pulumi.get(self, "source_cidr_ip")

    @property
    @pulumi.getter(name="sourceGroupId")
    def source_group_id(self) -> str:
        """
        Source security group ID for ingress authorization.
        """
        return pulumi.get(self, "source_group_id")

    @property
    @pulumi.getter(name="sourceGroupOwnerAccount")
    def source_group_owner_account(self) -> str:
        """
        Alibaba Cloud account of the source security group.
        """
        return pulumi.get(self, "source_group_owner_account")


@pulumi.output_type
class GetSecurityGroupsGroupResult(dict):
    def __init__(__self__, *,
                 creation_time: str,
                 description: str,
                 id: str,
                 inner_access: bool,
                 name: str,
                 resource_group_id: str,
                 security_group_type: str,
                 vpc_id: str,
                 tags: Optional[Mapping[str, Any]] = None):
        """
        :param str creation_time: Creation time of the security group.
        :param str description: The description of the security group.
        :param str id: The ID of the security group.
        :param bool inner_access: Whether to allow inner network access.
        :param str name: The name of the security group.
        :param str resource_group_id: The Id of resource group which the security_group belongs.
        :param str security_group_type: The type of the security group.
        :param str vpc_id: Used to retrieve security groups that belong to the specified VPC ID.
        :param Mapping[str, Any] tags: A map of tags assigned to the ECS instances. It must be in the format:
               ```python
               import pulumi
               import pulumi_alicloud as alicloud
               
               tagged_security_groups = alicloud.ecs.get_security_groups(tags={
                   "tagKey1": "tagValue1",
                   "tagKey2": "tagValue2",
               })
               ```
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inner_access", inner_access)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "security_group_type", security_group_type)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Creation time of the security group.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the security group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="innerAccess")
    def inner_access(self) -> bool:
        """
        Whether to allow inner network access.
        """
        return pulumi.get(self, "inner_access")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the security group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The Id of resource group which the security_group belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityGroupType")
    def security_group_type(self) -> str:
        """
        The type of the security group.
        """
        return pulumi.get(self, "security_group_type")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Used to retrieve security groups that belong to the specified VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        """
        A map of tags assigned to the ECS instances. It must be in the format:
        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        tagged_security_groups = alicloud.ecs.get_security_groups(tags={
            "tagKey1": "tagValue1",
            "tagKey2": "tagValue2",
        })
        ```
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetSnapshotsSnapshotResult(dict):
    def __init__(__self__, *,
                 category: str,
                 creation_time: str,
                 description: str,
                 disk_id: str,
                 encrypted: bool,
                 id: str,
                 instant_access: bool,
                 instant_access_retention_days: int,
                 name: str,
                 product_code: str,
                 progress: str,
                 remain_time: int,
                 resource_group_id: str,
                 retention_days: int,
                 snapshot_id: str,
                 snapshot_name: str,
                 snapshot_sn: str,
                 snapshot_type: str,
                 source_disk_id: str,
                 source_disk_size: str,
                 source_disk_type: str,
                 source_storage_type: str,
                 status: str,
                 tags: Mapping[str, Any],
                 type: str,
                 usage: str):
        """
        :param str creation_time: Creation time. Time of creation. It is represented according to ISO8601, and UTC time is used. Format: YYYY-MM-DDThh:mmZ.
        :param str description: Description of the snapshot.
        :param bool encrypted: Whether the snapshot is encrypted or not.
        :param str id: ID of the snapshot.
        :param str name: Name of the snapshot.
        :param str product_code: Product code on the image market place.
        :param str progress: Progress of snapshot creation, presented in percentage.
        :param int remain_time: The remaining time of a snapshot creation task, in seconds.
        :param int retention_days: The number of days that an automatic snapshot retains in the console for your instance.
        :param str source_disk_id: Source disk ID, which is retained after the source disk of the snapshot is deleted.
        :param str source_disk_size: Size of the source disk, measured in GB.
        :param str source_disk_type: Source disk attribute. Value range: `System`,`Data`.
        :param str status: The snapshot status. Value range: `progressing`, `accomplished` and `failed`.
        :param Mapping[str, Any] tags: A map of tags assigned to the snapshot.
        :param str usage: Whether the snapshots are used to create resources or not. Value range: `image`, `disk`, `image_disk` and `none`.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "disk_id", disk_id)
        pulumi.set(__self__, "encrypted", encrypted)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instant_access", instant_access)
        pulumi.set(__self__, "instant_access_retention_days", instant_access_retention_days)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product_code", product_code)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "remain_time", remain_time)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "retention_days", retention_days)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "snapshot_name", snapshot_name)
        pulumi.set(__self__, "snapshot_sn", snapshot_sn)
        pulumi.set(__self__, "snapshot_type", snapshot_type)
        pulumi.set(__self__, "source_disk_id", source_disk_id)
        pulumi.set(__self__, "source_disk_size", source_disk_size)
        pulumi.set(__self__, "source_disk_type", source_disk_type)
        pulumi.set(__self__, "source_storage_type", source_storage_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "usage", usage)

    @property
    @pulumi.getter
    def category(self) -> str:
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Creation time. Time of creation. It is represented according to ISO8601, and UTC time is used. Format: YYYY-MM-DDThh:mmZ.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the snapshot.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> str:
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter
    def encrypted(self) -> bool:
        """
        Whether the snapshot is encrypted or not.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the snapshot.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instantAccess")
    def instant_access(self) -> bool:
        return pulumi.get(self, "instant_access")

    @property
    @pulumi.getter(name="instantAccessRetentionDays")
    def instant_access_retention_days(self) -> int:
        return pulumi.get(self, "instant_access_retention_days")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the snapshot.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productCode")
    def product_code(self) -> str:
        """
        Product code on the image market place.
        """
        return pulumi.get(self, "product_code")

    @property
    @pulumi.getter
    def progress(self) -> str:
        """
        Progress of snapshot creation, presented in percentage.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter(name="remainTime")
    def remain_time(self) -> int:
        """
        The remaining time of a snapshot creation task, in seconds.
        """
        return pulumi.get(self, "remain_time")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="retentionDays")
    def retention_days(self) -> int:
        """
        The number of days that an automatic snapshot retains in the console for your instance.
        """
        return pulumi.get(self, "retention_days")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> str:
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> str:
        return pulumi.get(self, "snapshot_name")

    @property
    @pulumi.getter(name="snapshotSn")
    def snapshot_sn(self) -> str:
        return pulumi.get(self, "snapshot_sn")

    @property
    @pulumi.getter(name="snapshotType")
    def snapshot_type(self) -> str:
        return pulumi.get(self, "snapshot_type")

    @property
    @pulumi.getter(name="sourceDiskId")
    def source_disk_id(self) -> str:
        """
        Source disk ID, which is retained after the source disk of the snapshot is deleted.
        """
        return pulumi.get(self, "source_disk_id")

    @property
    @pulumi.getter(name="sourceDiskSize")
    def source_disk_size(self) -> str:
        """
        Size of the source disk, measured in GB.
        """
        return pulumi.get(self, "source_disk_size")

    @property
    @pulumi.getter(name="sourceDiskType")
    def source_disk_type(self) -> str:
        """
        Source disk attribute. Value range: `System`,`Data`.
        """
        return pulumi.get(self, "source_disk_type")

    @property
    @pulumi.getter(name="sourceStorageType")
    def source_storage_type(self) -> str:
        return pulumi.get(self, "source_storage_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The snapshot status. Value range: `progressing`, `accomplished` and `failed`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, Any]:
        """
        A map of tags assigned to the snapshot.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def usage(self) -> str:
        """
        Whether the snapshots are used to create resources or not. Value range: `image`, `disk`, `image_disk` and `none`.
        """
        return pulumi.get(self, "usage")


