# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['K8sApplicationArgs', 'K8sApplication']

@pulumi.input_type
class K8sApplicationArgs:
    def __init__(__self__, *,
                 application_name: pulumi.Input[str],
                 cluster_id: pulumi.Input[str],
                 application_descriotion: Optional[pulumi.Input[str]] = None,
                 command: Optional[pulumi.Input[str]] = None,
                 command_args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 edas_container_version: Optional[pulumi.Input[str]] = None,
                 envs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 internet_slb_id: Optional[pulumi.Input[str]] = None,
                 internet_slb_port: Optional[pulumi.Input[int]] = None,
                 internet_slb_protocol: Optional[pulumi.Input[str]] = None,
                 internet_target_port: Optional[pulumi.Input[int]] = None,
                 jdk: Optional[pulumi.Input[str]] = None,
                 limit_m_cpu: Optional[pulumi.Input[int]] = None,
                 limit_mem: Optional[pulumi.Input[int]] = None,
                 liveness: Optional[pulumi.Input[str]] = None,
                 local_volume: Optional[pulumi.Input[str]] = None,
                 logical_region_id: Optional[pulumi.Input[str]] = None,
                 mount_descs: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 nas_id: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 package_url: Optional[pulumi.Input[str]] = None,
                 package_version: Optional[pulumi.Input[str]] = None,
                 post_start: Optional[pulumi.Input[str]] = None,
                 pre_stop: Optional[pulumi.Input[str]] = None,
                 readiness: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 requests_m_cpu: Optional[pulumi.Input[int]] = None,
                 requests_mem: Optional[pulumi.Input[int]] = None,
                 web_container: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a K8sApplication resource.
        :param pulumi.Input[str] application_name: The name of the application you want to create. Must start with character,supports numbers, letters and dashes (-), supports up to 36 characters
        :param pulumi.Input[str] cluster_id: The ID of the alicloud container service kubernetes cluster that you want to import to. You can call the ListCluster operation to query.
        :param pulumi.Input[str] application_descriotion: The description of the application
        :param pulumi.Input[str] command: The set command, if set, will replace the startup command in the mirror when the mirror is started.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command_args: Used in combination with the command, the parameter of the command is a JsonArray string in the format: `[{"argument":"-c"},{"argument":"test"}]`. Among them, -c and test are two parameters that need to be set.
        :param pulumi.Input[str] edas_container_version: EDAS-Container version that the deployed package depends on. Image does not support this parameter.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] envs: Deployment environment variables, the format must conform to the JSON object array, such as: `{"name":"x","value":"y"},{"name":"x2","value":"y2"}`, If you want to cancel the configuration, you need to set an empty JSON array "" to indicate no configuration.
        :param pulumi.Input[str] image_url: Mirror address. When the package_type is set to 'Image', this parameter item is required.
        :param pulumi.Input[str] internet_slb_id: Public network SLB ID. If not configured, EDAS will automatically purchase a new SLB for the user.
               It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[int] internet_slb_port: The public network SLB front-end port, range 1~65535. It has been deprecated and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[str] internet_slb_protocol: The public network SLB protocol supports TCP, HTTP and HTTPS protocols. It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[int] internet_target_port: The private SLB back-end port, is also the service port of the application, ranging from 1 to 65535.
               It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[str] jdk: The JDK version that the deployed package depends on. The optional parameter values are Open JDK 7 and Open JDK 8. Image does not support this parameter.
        :param pulumi.Input[int] limit_m_cpu: The CPU quota of the application instance during application operation. Unit: Number of millcores, set to 0 means unlimited, similar to request_cpu.
        :param pulumi.Input[int] limit_mem: The memory limit of the application instance during application operation, unit: M.
        :param pulumi.Input[str] liveness: Container survival status monitoring, format such as: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1,"tcpSocket":{"host":"", "port":8080} }`.
        :param pulumi.Input[str] local_volume: The configuration of the host file mounted to the container. For example: `[{"type":"","nodePath":"/localfiles","mountPath":"/app/files"},{"type":"Directory","nodePath":"/mnt", "mountPath":"/app/storage"}]`. Among them, nodePath is the host path; mountPath is the path in the container; type is the mount type.
        :param pulumi.Input[str] logical_region_id: The ID corresponding to the EDAS namespace, the non-default namespace must be filled in.
        :param pulumi.Input[str] mount_descs: Mount configuration description, as a serialized JSON. For example: `[{"nasPath": "/k8s","mountPath": "/mnt"},{"nasPath": "/files","mountPath": "/app/files"}]`. Among them, nasPath refers to the file storage path; mountPath refers to the path mounted in the container.
        :param pulumi.Input[str] namespace: The namespace of the K8s cluster, it will determine which K8s namespace your application is deployed in. The default is 'default'.
        :param pulumi.Input[str] nas_id: The ID of the mounted NAS must be in the same region as the cluster. It must have an available mount point creation quota, or its mount point must be on a switch in the VPC. If it is not filled in and the mountDescs field exists, a NAS will be automatically purchased and mounted on the switch in the VPC by default.
        :param pulumi.Input[str] package_type: Application package type. Optional parameter values include: FatJar, WAR and Image.
        :param pulumi.Input[str] package_url: The url of the package to deploy.Applications deployed through FatJar or WAR packages need to configure it.
        :param pulumi.Input[str] package_version: The version number of the deployment package. WAR and FatJar types are required. Please customize its meaning.
        :param pulumi.Input[str] post_start: Execute script after startup
        :param pulumi.Input[str] pre_stop: Execute script before stopping
        :param pulumi.Input[str] readiness: Container service status check. If the check fails, the traffic passing through K8s Service will not be transferred to the container. The format is: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1, "httpGet": {"path": "/consumer","port": 8080,"scheme": "HTTP","httpHeaders": [{"name": "test","value": "testvalue"} ]}}`.
        :param pulumi.Input[int] replicas: Number of application instances.
        :param pulumi.Input[int] requests_m_cpu: When the application is created, the CPU quota of the application instance, unit: number of millcores, similar to request_cpu
        :param pulumi.Input[int] requests_mem: When the application is created, the memory limit of the application instance, unit: M. When set to 0, it means unlimited.
        :param pulumi.Input[str] web_container: The Tomcat version that the deployment package depends on. Applicable to Spring Cloud and Dubbo applications deployed through WAR packages. Image does not support this parameter.
        """
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "cluster_id", cluster_id)
        if application_descriotion is not None:
            pulumi.set(__self__, "application_descriotion", application_descriotion)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if command_args is not None:
            pulumi.set(__self__, "command_args", command_args)
        if edas_container_version is not None:
            pulumi.set(__self__, "edas_container_version", edas_container_version)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if internet_slb_id is not None:
            warnings.warn("""Field 'internet_slb_id' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
            pulumi.log.warn("""internet_slb_id is deprecated: Field 'internet_slb_id' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")
        if internet_slb_id is not None:
            pulumi.set(__self__, "internet_slb_id", internet_slb_id)
        if internet_slb_port is not None:
            warnings.warn("""Field 'internet_slb_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
            pulumi.log.warn("""internet_slb_port is deprecated: Field 'internet_slb_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")
        if internet_slb_port is not None:
            pulumi.set(__self__, "internet_slb_port", internet_slb_port)
        if internet_slb_protocol is not None:
            warnings.warn("""Field 'internet_slb_protocol' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
            pulumi.log.warn("""internet_slb_protocol is deprecated: Field 'internet_slb_protocol' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")
        if internet_slb_protocol is not None:
            pulumi.set(__self__, "internet_slb_protocol", internet_slb_protocol)
        if internet_target_port is not None:
            warnings.warn("""Field 'internet_target_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
            pulumi.log.warn("""internet_target_port is deprecated: Field 'internet_target_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")
        if internet_target_port is not None:
            pulumi.set(__self__, "internet_target_port", internet_target_port)
        if jdk is not None:
            pulumi.set(__self__, "jdk", jdk)
        if limit_m_cpu is not None:
            pulumi.set(__self__, "limit_m_cpu", limit_m_cpu)
        if limit_mem is not None:
            pulumi.set(__self__, "limit_mem", limit_mem)
        if liveness is not None:
            pulumi.set(__self__, "liveness", liveness)
        if local_volume is not None:
            pulumi.set(__self__, "local_volume", local_volume)
        if logical_region_id is not None:
            pulumi.set(__self__, "logical_region_id", logical_region_id)
        if mount_descs is not None:
            pulumi.set(__self__, "mount_descs", mount_descs)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if nas_id is not None:
            pulumi.set(__self__, "nas_id", nas_id)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if package_url is not None:
            pulumi.set(__self__, "package_url", package_url)
        if package_version is not None:
            pulumi.set(__self__, "package_version", package_version)
        if post_start is not None:
            pulumi.set(__self__, "post_start", post_start)
        if pre_stop is not None:
            pulumi.set(__self__, "pre_stop", pre_stop)
        if readiness is not None:
            pulumi.set(__self__, "readiness", readiness)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if requests_m_cpu is not None:
            pulumi.set(__self__, "requests_m_cpu", requests_m_cpu)
        if requests_mem is not None:
            pulumi.set(__self__, "requests_mem", requests_mem)
        if web_container is not None:
            pulumi.set(__self__, "web_container", web_container)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> pulumi.Input[str]:
        """
        The name of the application you want to create. Must start with character,supports numbers, letters and dashes (-), supports up to 36 characters
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_name", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The ID of the alicloud container service kubernetes cluster that you want to import to. You can call the ListCluster operation to query.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="applicationDescriotion")
    def application_descriotion(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the application
        """
        return pulumi.get(self, "application_descriotion")

    @application_descriotion.setter
    def application_descriotion(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_descriotion", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[str]]:
        """
        The set command, if set, will replace the startup command in the mirror when the mirror is started.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter(name="commandArgs")
    def command_args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Used in combination with the command, the parameter of the command is a JsonArray string in the format: `[{"argument":"-c"},{"argument":"test"}]`. Among them, -c and test are two parameters that need to be set.
        """
        return pulumi.get(self, "command_args")

    @command_args.setter
    def command_args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command_args", value)

    @property
    @pulumi.getter(name="edasContainerVersion")
    def edas_container_version(self) -> Optional[pulumi.Input[str]]:
        """
        EDAS-Container version that the deployed package depends on. Image does not support this parameter.
        """
        return pulumi.get(self, "edas_container_version")

    @edas_container_version.setter
    def edas_container_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edas_container_version", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Deployment environment variables, the format must conform to the JSON object array, such as: `{"name":"x","value":"y"},{"name":"x2","value":"y2"}`, If you want to cancel the configuration, you need to set an empty JSON array "" to indicate no configuration.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[str]]:
        """
        Mirror address. When the package_type is set to 'Image', this parameter item is required.
        """
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_url", value)

    @property
    @pulumi.getter(name="internetSlbId")
    def internet_slb_id(self) -> Optional[pulumi.Input[str]]:
        """
        Public network SLB ID. If not configured, EDAS will automatically purchase a new SLB for the user.
        It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        """
        warnings.warn("""Field 'internet_slb_id' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
        pulumi.log.warn("""internet_slb_id is deprecated: Field 'internet_slb_id' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")

        return pulumi.get(self, "internet_slb_id")

    @internet_slb_id.setter
    def internet_slb_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_slb_id", value)

    @property
    @pulumi.getter(name="internetSlbPort")
    def internet_slb_port(self) -> Optional[pulumi.Input[int]]:
        """
        The public network SLB front-end port, range 1~65535. It has been deprecated and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        """
        warnings.warn("""Field 'internet_slb_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
        pulumi.log.warn("""internet_slb_port is deprecated: Field 'internet_slb_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")

        return pulumi.get(self, "internet_slb_port")

    @internet_slb_port.setter
    def internet_slb_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_slb_port", value)

    @property
    @pulumi.getter(name="internetSlbProtocol")
    def internet_slb_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The public network SLB protocol supports TCP, HTTP and HTTPS protocols. It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        """
        warnings.warn("""Field 'internet_slb_protocol' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
        pulumi.log.warn("""internet_slb_protocol is deprecated: Field 'internet_slb_protocol' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")

        return pulumi.get(self, "internet_slb_protocol")

    @internet_slb_protocol.setter
    def internet_slb_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_slb_protocol", value)

    @property
    @pulumi.getter(name="internetTargetPort")
    def internet_target_port(self) -> Optional[pulumi.Input[int]]:
        """
        The private SLB back-end port, is also the service port of the application, ranging from 1 to 65535.
        It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        """
        warnings.warn("""Field 'internet_target_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
        pulumi.log.warn("""internet_target_port is deprecated: Field 'internet_target_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")

        return pulumi.get(self, "internet_target_port")

    @internet_target_port.setter
    def internet_target_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_target_port", value)

    @property
    @pulumi.getter
    def jdk(self) -> Optional[pulumi.Input[str]]:
        """
        The JDK version that the deployed package depends on. The optional parameter values are Open JDK 7 and Open JDK 8. Image does not support this parameter.
        """
        return pulumi.get(self, "jdk")

    @jdk.setter
    def jdk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jdk", value)

    @property
    @pulumi.getter(name="limitMCpu")
    def limit_m_cpu(self) -> Optional[pulumi.Input[int]]:
        """
        The CPU quota of the application instance during application operation. Unit: Number of millcores, set to 0 means unlimited, similar to request_cpu.
        """
        return pulumi.get(self, "limit_m_cpu")

    @limit_m_cpu.setter
    def limit_m_cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "limit_m_cpu", value)

    @property
    @pulumi.getter(name="limitMem")
    def limit_mem(self) -> Optional[pulumi.Input[int]]:
        """
        The memory limit of the application instance during application operation, unit: M.
        """
        return pulumi.get(self, "limit_mem")

    @limit_mem.setter
    def limit_mem(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "limit_mem", value)

    @property
    @pulumi.getter
    def liveness(self) -> Optional[pulumi.Input[str]]:
        """
        Container survival status monitoring, format such as: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1,"tcpSocket":{"host":"", "port":8080} }`.
        """
        return pulumi.get(self, "liveness")

    @liveness.setter
    def liveness(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "liveness", value)

    @property
    @pulumi.getter(name="localVolume")
    def local_volume(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration of the host file mounted to the container. For example: `[{"type":"","nodePath":"/localfiles","mountPath":"/app/files"},{"type":"Directory","nodePath":"/mnt", "mountPath":"/app/storage"}]`. Among them, nodePath is the host path; mountPath is the path in the container; type is the mount type.
        """
        return pulumi.get(self, "local_volume")

    @local_volume.setter
    def local_volume(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_volume", value)

    @property
    @pulumi.getter(name="logicalRegionId")
    def logical_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID corresponding to the EDAS namespace, the non-default namespace must be filled in.
        """
        return pulumi.get(self, "logical_region_id")

    @logical_region_id.setter
    def logical_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logical_region_id", value)

    @property
    @pulumi.getter(name="mountDescs")
    def mount_descs(self) -> Optional[pulumi.Input[str]]:
        """
        Mount configuration description, as a serialized JSON. For example: `[{"nasPath": "/k8s","mountPath": "/mnt"},{"nasPath": "/files","mountPath": "/app/files"}]`. Among them, nasPath refers to the file storage path; mountPath refers to the path mounted in the container.
        """
        return pulumi.get(self, "mount_descs")

    @mount_descs.setter
    def mount_descs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_descs", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace of the K8s cluster, it will determine which K8s namespace your application is deployed in. The default is 'default'.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="nasId")
    def nas_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the mounted NAS must be in the same region as the cluster. It must have an available mount point creation quota, or its mount point must be on a switch in the VPC. If it is not filled in and the mountDescs field exists, a NAS will be automatically purchased and mounted on the switch in the VPC by default.
        """
        return pulumi.get(self, "nas_id")

    @nas_id.setter
    def nas_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nas_id", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[str]]:
        """
        Application package type. Optional parameter values include: FatJar, WAR and Image.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter(name="packageUrl")
    def package_url(self) -> Optional[pulumi.Input[str]]:
        """
        The url of the package to deploy.Applications deployed through FatJar or WAR packages need to configure it.
        """
        return pulumi.get(self, "package_url")

    @package_url.setter
    def package_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_url", value)

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version number of the deployment package. WAR and FatJar types are required. Please customize its meaning.
        """
        return pulumi.get(self, "package_version")

    @package_version.setter
    def package_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_version", value)

    @property
    @pulumi.getter(name="postStart")
    def post_start(self) -> Optional[pulumi.Input[str]]:
        """
        Execute script after startup
        """
        return pulumi.get(self, "post_start")

    @post_start.setter
    def post_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "post_start", value)

    @property
    @pulumi.getter(name="preStop")
    def pre_stop(self) -> Optional[pulumi.Input[str]]:
        """
        Execute script before stopping
        """
        return pulumi.get(self, "pre_stop")

    @pre_stop.setter
    def pre_stop(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_stop", value)

    @property
    @pulumi.getter
    def readiness(self) -> Optional[pulumi.Input[str]]:
        """
        Container service status check. If the check fails, the traffic passing through K8s Service will not be transferred to the container. The format is: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1, "httpGet": {"path": "/consumer","port": 8080,"scheme": "HTTP","httpHeaders": [{"name": "test","value": "testvalue"} ]}}`.
        """
        return pulumi.get(self, "readiness")

    @readiness.setter
    def readiness(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "readiness", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        """
        Number of application instances.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="requestsMCpu")
    def requests_m_cpu(self) -> Optional[pulumi.Input[int]]:
        """
        When the application is created, the CPU quota of the application instance, unit: number of millcores, similar to request_cpu
        """
        return pulumi.get(self, "requests_m_cpu")

    @requests_m_cpu.setter
    def requests_m_cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "requests_m_cpu", value)

    @property
    @pulumi.getter(name="requestsMem")
    def requests_mem(self) -> Optional[pulumi.Input[int]]:
        """
        When the application is created, the memory limit of the application instance, unit: M. When set to 0, it means unlimited.
        """
        return pulumi.get(self, "requests_mem")

    @requests_mem.setter
    def requests_mem(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "requests_mem", value)

    @property
    @pulumi.getter(name="webContainer")
    def web_container(self) -> Optional[pulumi.Input[str]]:
        """
        The Tomcat version that the deployment package depends on. Applicable to Spring Cloud and Dubbo applications deployed through WAR packages. Image does not support this parameter.
        """
        return pulumi.get(self, "web_container")

    @web_container.setter
    def web_container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_container", value)


@pulumi.input_type
class _K8sApplicationState:
    def __init__(__self__, *,
                 application_descriotion: Optional[pulumi.Input[str]] = None,
                 application_name: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 command: Optional[pulumi.Input[str]] = None,
                 command_args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 edas_container_version: Optional[pulumi.Input[str]] = None,
                 envs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 internet_slb_id: Optional[pulumi.Input[str]] = None,
                 internet_slb_port: Optional[pulumi.Input[int]] = None,
                 internet_slb_protocol: Optional[pulumi.Input[str]] = None,
                 internet_target_port: Optional[pulumi.Input[int]] = None,
                 jdk: Optional[pulumi.Input[str]] = None,
                 limit_m_cpu: Optional[pulumi.Input[int]] = None,
                 limit_mem: Optional[pulumi.Input[int]] = None,
                 liveness: Optional[pulumi.Input[str]] = None,
                 local_volume: Optional[pulumi.Input[str]] = None,
                 logical_region_id: Optional[pulumi.Input[str]] = None,
                 mount_descs: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 nas_id: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 package_url: Optional[pulumi.Input[str]] = None,
                 package_version: Optional[pulumi.Input[str]] = None,
                 post_start: Optional[pulumi.Input[str]] = None,
                 pre_stop: Optional[pulumi.Input[str]] = None,
                 readiness: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 requests_m_cpu: Optional[pulumi.Input[int]] = None,
                 requests_mem: Optional[pulumi.Input[int]] = None,
                 web_container: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering K8sApplication resources.
        :param pulumi.Input[str] application_descriotion: The description of the application
        :param pulumi.Input[str] application_name: The name of the application you want to create. Must start with character,supports numbers, letters and dashes (-), supports up to 36 characters
        :param pulumi.Input[str] cluster_id: The ID of the alicloud container service kubernetes cluster that you want to import to. You can call the ListCluster operation to query.
        :param pulumi.Input[str] command: The set command, if set, will replace the startup command in the mirror when the mirror is started.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command_args: Used in combination with the command, the parameter of the command is a JsonArray string in the format: `[{"argument":"-c"},{"argument":"test"}]`. Among them, -c and test are two parameters that need to be set.
        :param pulumi.Input[str] edas_container_version: EDAS-Container version that the deployed package depends on. Image does not support this parameter.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] envs: Deployment environment variables, the format must conform to the JSON object array, such as: `{"name":"x","value":"y"},{"name":"x2","value":"y2"}`, If you want to cancel the configuration, you need to set an empty JSON array "" to indicate no configuration.
        :param pulumi.Input[str] image_url: Mirror address. When the package_type is set to 'Image', this parameter item is required.
        :param pulumi.Input[str] internet_slb_id: Public network SLB ID. If not configured, EDAS will automatically purchase a new SLB for the user.
               It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[int] internet_slb_port: The public network SLB front-end port, range 1~65535. It has been deprecated and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[str] internet_slb_protocol: The public network SLB protocol supports TCP, HTTP and HTTPS protocols. It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[int] internet_target_port: The private SLB back-end port, is also the service port of the application, ranging from 1 to 65535.
               It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[str] jdk: The JDK version that the deployed package depends on. The optional parameter values are Open JDK 7 and Open JDK 8. Image does not support this parameter.
        :param pulumi.Input[int] limit_m_cpu: The CPU quota of the application instance during application operation. Unit: Number of millcores, set to 0 means unlimited, similar to request_cpu.
        :param pulumi.Input[int] limit_mem: The memory limit of the application instance during application operation, unit: M.
        :param pulumi.Input[str] liveness: Container survival status monitoring, format such as: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1,"tcpSocket":{"host":"", "port":8080} }`.
        :param pulumi.Input[str] local_volume: The configuration of the host file mounted to the container. For example: `[{"type":"","nodePath":"/localfiles","mountPath":"/app/files"},{"type":"Directory","nodePath":"/mnt", "mountPath":"/app/storage"}]`. Among them, nodePath is the host path; mountPath is the path in the container; type is the mount type.
        :param pulumi.Input[str] logical_region_id: The ID corresponding to the EDAS namespace, the non-default namespace must be filled in.
        :param pulumi.Input[str] mount_descs: Mount configuration description, as a serialized JSON. For example: `[{"nasPath": "/k8s","mountPath": "/mnt"},{"nasPath": "/files","mountPath": "/app/files"}]`. Among them, nasPath refers to the file storage path; mountPath refers to the path mounted in the container.
        :param pulumi.Input[str] namespace: The namespace of the K8s cluster, it will determine which K8s namespace your application is deployed in. The default is 'default'.
        :param pulumi.Input[str] nas_id: The ID of the mounted NAS must be in the same region as the cluster. It must have an available mount point creation quota, or its mount point must be on a switch in the VPC. If it is not filled in and the mountDescs field exists, a NAS will be automatically purchased and mounted on the switch in the VPC by default.
        :param pulumi.Input[str] package_type: Application package type. Optional parameter values include: FatJar, WAR and Image.
        :param pulumi.Input[str] package_url: The url of the package to deploy.Applications deployed through FatJar or WAR packages need to configure it.
        :param pulumi.Input[str] package_version: The version number of the deployment package. WAR and FatJar types are required. Please customize its meaning.
        :param pulumi.Input[str] post_start: Execute script after startup
        :param pulumi.Input[str] pre_stop: Execute script before stopping
        :param pulumi.Input[str] readiness: Container service status check. If the check fails, the traffic passing through K8s Service will not be transferred to the container. The format is: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1, "httpGet": {"path": "/consumer","port": 8080,"scheme": "HTTP","httpHeaders": [{"name": "test","value": "testvalue"} ]}}`.
        :param pulumi.Input[int] replicas: Number of application instances.
        :param pulumi.Input[int] requests_m_cpu: When the application is created, the CPU quota of the application instance, unit: number of millcores, similar to request_cpu
        :param pulumi.Input[int] requests_mem: When the application is created, the memory limit of the application instance, unit: M. When set to 0, it means unlimited.
        :param pulumi.Input[str] web_container: The Tomcat version that the deployment package depends on. Applicable to Spring Cloud and Dubbo applications deployed through WAR packages. Image does not support this parameter.
        """
        if application_descriotion is not None:
            pulumi.set(__self__, "application_descriotion", application_descriotion)
        if application_name is not None:
            pulumi.set(__self__, "application_name", application_name)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if command_args is not None:
            pulumi.set(__self__, "command_args", command_args)
        if edas_container_version is not None:
            pulumi.set(__self__, "edas_container_version", edas_container_version)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if internet_slb_id is not None:
            warnings.warn("""Field 'internet_slb_id' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
            pulumi.log.warn("""internet_slb_id is deprecated: Field 'internet_slb_id' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")
        if internet_slb_id is not None:
            pulumi.set(__self__, "internet_slb_id", internet_slb_id)
        if internet_slb_port is not None:
            warnings.warn("""Field 'internet_slb_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
            pulumi.log.warn("""internet_slb_port is deprecated: Field 'internet_slb_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")
        if internet_slb_port is not None:
            pulumi.set(__self__, "internet_slb_port", internet_slb_port)
        if internet_slb_protocol is not None:
            warnings.warn("""Field 'internet_slb_protocol' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
            pulumi.log.warn("""internet_slb_protocol is deprecated: Field 'internet_slb_protocol' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")
        if internet_slb_protocol is not None:
            pulumi.set(__self__, "internet_slb_protocol", internet_slb_protocol)
        if internet_target_port is not None:
            warnings.warn("""Field 'internet_target_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
            pulumi.log.warn("""internet_target_port is deprecated: Field 'internet_target_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")
        if internet_target_port is not None:
            pulumi.set(__self__, "internet_target_port", internet_target_port)
        if jdk is not None:
            pulumi.set(__self__, "jdk", jdk)
        if limit_m_cpu is not None:
            pulumi.set(__self__, "limit_m_cpu", limit_m_cpu)
        if limit_mem is not None:
            pulumi.set(__self__, "limit_mem", limit_mem)
        if liveness is not None:
            pulumi.set(__self__, "liveness", liveness)
        if local_volume is not None:
            pulumi.set(__self__, "local_volume", local_volume)
        if logical_region_id is not None:
            pulumi.set(__self__, "logical_region_id", logical_region_id)
        if mount_descs is not None:
            pulumi.set(__self__, "mount_descs", mount_descs)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if nas_id is not None:
            pulumi.set(__self__, "nas_id", nas_id)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if package_url is not None:
            pulumi.set(__self__, "package_url", package_url)
        if package_version is not None:
            pulumi.set(__self__, "package_version", package_version)
        if post_start is not None:
            pulumi.set(__self__, "post_start", post_start)
        if pre_stop is not None:
            pulumi.set(__self__, "pre_stop", pre_stop)
        if readiness is not None:
            pulumi.set(__self__, "readiness", readiness)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if requests_m_cpu is not None:
            pulumi.set(__self__, "requests_m_cpu", requests_m_cpu)
        if requests_mem is not None:
            pulumi.set(__self__, "requests_mem", requests_mem)
        if web_container is not None:
            pulumi.set(__self__, "web_container", web_container)

    @property
    @pulumi.getter(name="applicationDescriotion")
    def application_descriotion(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the application
        """
        return pulumi.get(self, "application_descriotion")

    @application_descriotion.setter
    def application_descriotion(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_descriotion", value)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the application you want to create. Must start with character,supports numbers, letters and dashes (-), supports up to 36 characters
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "application_name", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the alicloud container service kubernetes cluster that you want to import to. You can call the ListCluster operation to query.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def command(self) -> Optional[pulumi.Input[str]]:
        """
        The set command, if set, will replace the startup command in the mirror when the mirror is started.
        """
        return pulumi.get(self, "command")

    @command.setter
    def command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "command", value)

    @property
    @pulumi.getter(name="commandArgs")
    def command_args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Used in combination with the command, the parameter of the command is a JsonArray string in the format: `[{"argument":"-c"},{"argument":"test"}]`. Among them, -c and test are two parameters that need to be set.
        """
        return pulumi.get(self, "command_args")

    @command_args.setter
    def command_args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "command_args", value)

    @property
    @pulumi.getter(name="edasContainerVersion")
    def edas_container_version(self) -> Optional[pulumi.Input[str]]:
        """
        EDAS-Container version that the deployed package depends on. Image does not support this parameter.
        """
        return pulumi.get(self, "edas_container_version")

    @edas_container_version.setter
    def edas_container_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edas_container_version", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Deployment environment variables, the format must conform to the JSON object array, such as: `{"name":"x","value":"y"},{"name":"x2","value":"y2"}`, If you want to cancel the configuration, you need to set an empty JSON array "" to indicate no configuration.
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[str]]:
        """
        Mirror address. When the package_type is set to 'Image', this parameter item is required.
        """
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_url", value)

    @property
    @pulumi.getter(name="internetSlbId")
    def internet_slb_id(self) -> Optional[pulumi.Input[str]]:
        """
        Public network SLB ID. If not configured, EDAS will automatically purchase a new SLB for the user.
        It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        """
        warnings.warn("""Field 'internet_slb_id' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
        pulumi.log.warn("""internet_slb_id is deprecated: Field 'internet_slb_id' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")

        return pulumi.get(self, "internet_slb_id")

    @internet_slb_id.setter
    def internet_slb_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_slb_id", value)

    @property
    @pulumi.getter(name="internetSlbPort")
    def internet_slb_port(self) -> Optional[pulumi.Input[int]]:
        """
        The public network SLB front-end port, range 1~65535. It has been deprecated and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        """
        warnings.warn("""Field 'internet_slb_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
        pulumi.log.warn("""internet_slb_port is deprecated: Field 'internet_slb_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")

        return pulumi.get(self, "internet_slb_port")

    @internet_slb_port.setter
    def internet_slb_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_slb_port", value)

    @property
    @pulumi.getter(name="internetSlbProtocol")
    def internet_slb_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The public network SLB protocol supports TCP, HTTP and HTTPS protocols. It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        """
        warnings.warn("""Field 'internet_slb_protocol' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
        pulumi.log.warn("""internet_slb_protocol is deprecated: Field 'internet_slb_protocol' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")

        return pulumi.get(self, "internet_slb_protocol")

    @internet_slb_protocol.setter
    def internet_slb_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_slb_protocol", value)

    @property
    @pulumi.getter(name="internetTargetPort")
    def internet_target_port(self) -> Optional[pulumi.Input[int]]:
        """
        The private SLB back-end port, is also the service port of the application, ranging from 1 to 65535.
        It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        """
        warnings.warn("""Field 'internet_target_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
        pulumi.log.warn("""internet_target_port is deprecated: Field 'internet_target_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")

        return pulumi.get(self, "internet_target_port")

    @internet_target_port.setter
    def internet_target_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_target_port", value)

    @property
    @pulumi.getter
    def jdk(self) -> Optional[pulumi.Input[str]]:
        """
        The JDK version that the deployed package depends on. The optional parameter values are Open JDK 7 and Open JDK 8. Image does not support this parameter.
        """
        return pulumi.get(self, "jdk")

    @jdk.setter
    def jdk(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jdk", value)

    @property
    @pulumi.getter(name="limitMCpu")
    def limit_m_cpu(self) -> Optional[pulumi.Input[int]]:
        """
        The CPU quota of the application instance during application operation. Unit: Number of millcores, set to 0 means unlimited, similar to request_cpu.
        """
        return pulumi.get(self, "limit_m_cpu")

    @limit_m_cpu.setter
    def limit_m_cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "limit_m_cpu", value)

    @property
    @pulumi.getter(name="limitMem")
    def limit_mem(self) -> Optional[pulumi.Input[int]]:
        """
        The memory limit of the application instance during application operation, unit: M.
        """
        return pulumi.get(self, "limit_mem")

    @limit_mem.setter
    def limit_mem(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "limit_mem", value)

    @property
    @pulumi.getter
    def liveness(self) -> Optional[pulumi.Input[str]]:
        """
        Container survival status monitoring, format such as: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1,"tcpSocket":{"host":"", "port":8080} }`.
        """
        return pulumi.get(self, "liveness")

    @liveness.setter
    def liveness(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "liveness", value)

    @property
    @pulumi.getter(name="localVolume")
    def local_volume(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration of the host file mounted to the container. For example: `[{"type":"","nodePath":"/localfiles","mountPath":"/app/files"},{"type":"Directory","nodePath":"/mnt", "mountPath":"/app/storage"}]`. Among them, nodePath is the host path; mountPath is the path in the container; type is the mount type.
        """
        return pulumi.get(self, "local_volume")

    @local_volume.setter
    def local_volume(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_volume", value)

    @property
    @pulumi.getter(name="logicalRegionId")
    def logical_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID corresponding to the EDAS namespace, the non-default namespace must be filled in.
        """
        return pulumi.get(self, "logical_region_id")

    @logical_region_id.setter
    def logical_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logical_region_id", value)

    @property
    @pulumi.getter(name="mountDescs")
    def mount_descs(self) -> Optional[pulumi.Input[str]]:
        """
        Mount configuration description, as a serialized JSON. For example: `[{"nasPath": "/k8s","mountPath": "/mnt"},{"nasPath": "/files","mountPath": "/app/files"}]`. Among them, nasPath refers to the file storage path; mountPath refers to the path mounted in the container.
        """
        return pulumi.get(self, "mount_descs")

    @mount_descs.setter
    def mount_descs(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_descs", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace of the K8s cluster, it will determine which K8s namespace your application is deployed in. The default is 'default'.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="nasId")
    def nas_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the mounted NAS must be in the same region as the cluster. It must have an available mount point creation quota, or its mount point must be on a switch in the VPC. If it is not filled in and the mountDescs field exists, a NAS will be automatically purchased and mounted on the switch in the VPC by default.
        """
        return pulumi.get(self, "nas_id")

    @nas_id.setter
    def nas_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nas_id", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[str]]:
        """
        Application package type. Optional parameter values include: FatJar, WAR and Image.
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter(name="packageUrl")
    def package_url(self) -> Optional[pulumi.Input[str]]:
        """
        The url of the package to deploy.Applications deployed through FatJar or WAR packages need to configure it.
        """
        return pulumi.get(self, "package_url")

    @package_url.setter
    def package_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_url", value)

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version number of the deployment package. WAR and FatJar types are required. Please customize its meaning.
        """
        return pulumi.get(self, "package_version")

    @package_version.setter
    def package_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_version", value)

    @property
    @pulumi.getter(name="postStart")
    def post_start(self) -> Optional[pulumi.Input[str]]:
        """
        Execute script after startup
        """
        return pulumi.get(self, "post_start")

    @post_start.setter
    def post_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "post_start", value)

    @property
    @pulumi.getter(name="preStop")
    def pre_stop(self) -> Optional[pulumi.Input[str]]:
        """
        Execute script before stopping
        """
        return pulumi.get(self, "pre_stop")

    @pre_stop.setter
    def pre_stop(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_stop", value)

    @property
    @pulumi.getter
    def readiness(self) -> Optional[pulumi.Input[str]]:
        """
        Container service status check. If the check fails, the traffic passing through K8s Service will not be transferred to the container. The format is: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1, "httpGet": {"path": "/consumer","port": 8080,"scheme": "HTTP","httpHeaders": [{"name": "test","value": "testvalue"} ]}}`.
        """
        return pulumi.get(self, "readiness")

    @readiness.setter
    def readiness(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "readiness", value)

    @property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[int]]:
        """
        Number of application instances.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replicas", value)

    @property
    @pulumi.getter(name="requestsMCpu")
    def requests_m_cpu(self) -> Optional[pulumi.Input[int]]:
        """
        When the application is created, the CPU quota of the application instance, unit: number of millcores, similar to request_cpu
        """
        return pulumi.get(self, "requests_m_cpu")

    @requests_m_cpu.setter
    def requests_m_cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "requests_m_cpu", value)

    @property
    @pulumi.getter(name="requestsMem")
    def requests_mem(self) -> Optional[pulumi.Input[int]]:
        """
        When the application is created, the memory limit of the application instance, unit: M. When set to 0, it means unlimited.
        """
        return pulumi.get(self, "requests_mem")

    @requests_mem.setter
    def requests_mem(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "requests_mem", value)

    @property
    @pulumi.getter(name="webContainer")
    def web_container(self) -> Optional[pulumi.Input[str]]:
        """
        The Tomcat version that the deployment package depends on. Applicable to Spring Cloud and Dubbo applications deployed through WAR packages. Image does not support this parameter.
        """
        return pulumi.get(self, "web_container")

    @web_container.setter
    def web_container(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_container", value)


class K8sApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_descriotion: Optional[pulumi.Input[str]] = None,
                 application_name: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 command: Optional[pulumi.Input[str]] = None,
                 command_args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 edas_container_version: Optional[pulumi.Input[str]] = None,
                 envs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 internet_slb_id: Optional[pulumi.Input[str]] = None,
                 internet_slb_port: Optional[pulumi.Input[int]] = None,
                 internet_slb_protocol: Optional[pulumi.Input[str]] = None,
                 internet_target_port: Optional[pulumi.Input[int]] = None,
                 jdk: Optional[pulumi.Input[str]] = None,
                 limit_m_cpu: Optional[pulumi.Input[int]] = None,
                 limit_mem: Optional[pulumi.Input[int]] = None,
                 liveness: Optional[pulumi.Input[str]] = None,
                 local_volume: Optional[pulumi.Input[str]] = None,
                 logical_region_id: Optional[pulumi.Input[str]] = None,
                 mount_descs: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 nas_id: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 package_url: Optional[pulumi.Input[str]] = None,
                 package_version: Optional[pulumi.Input[str]] = None,
                 post_start: Optional[pulumi.Input[str]] = None,
                 pre_stop: Optional[pulumi.Input[str]] = None,
                 readiness: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 requests_m_cpu: Optional[pulumi.Input[int]] = None,
                 requests_mem: Optional[pulumi.Input[int]] = None,
                 web_container: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create an EDAS k8s application.For information about EDAS K8s Application and how to use it, see [What is EDAS K8s Application](https://www.alibabacloud.com/help/en/edas/developer-reference/api-edas-2017-08-01-insertk8sapplication).

        > **NOTE:** Available since v1.105.0.

        ## Import

        EDAS k8s application can be imported as below, e.g.

        ```sh
         $ pulumi import alicloud:edas/k8sApplication:K8sApplication new_k8s_application application_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_descriotion: The description of the application
        :param pulumi.Input[str] application_name: The name of the application you want to create. Must start with character,supports numbers, letters and dashes (-), supports up to 36 characters
        :param pulumi.Input[str] cluster_id: The ID of the alicloud container service kubernetes cluster that you want to import to. You can call the ListCluster operation to query.
        :param pulumi.Input[str] command: The set command, if set, will replace the startup command in the mirror when the mirror is started.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command_args: Used in combination with the command, the parameter of the command is a JsonArray string in the format: `[{"argument":"-c"},{"argument":"test"}]`. Among them, -c and test are two parameters that need to be set.
        :param pulumi.Input[str] edas_container_version: EDAS-Container version that the deployed package depends on. Image does not support this parameter.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] envs: Deployment environment variables, the format must conform to the JSON object array, such as: `{"name":"x","value":"y"},{"name":"x2","value":"y2"}`, If you want to cancel the configuration, you need to set an empty JSON array "" to indicate no configuration.
        :param pulumi.Input[str] image_url: Mirror address. When the package_type is set to 'Image', this parameter item is required.
        :param pulumi.Input[str] internet_slb_id: Public network SLB ID. If not configured, EDAS will automatically purchase a new SLB for the user.
               It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[int] internet_slb_port: The public network SLB front-end port, range 1~65535. It has been deprecated and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[str] internet_slb_protocol: The public network SLB protocol supports TCP, HTTP and HTTPS protocols. It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[int] internet_target_port: The private SLB back-end port, is also the service port of the application, ranging from 1 to 65535.
               It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[str] jdk: The JDK version that the deployed package depends on. The optional parameter values are Open JDK 7 and Open JDK 8. Image does not support this parameter.
        :param pulumi.Input[int] limit_m_cpu: The CPU quota of the application instance during application operation. Unit: Number of millcores, set to 0 means unlimited, similar to request_cpu.
        :param pulumi.Input[int] limit_mem: The memory limit of the application instance during application operation, unit: M.
        :param pulumi.Input[str] liveness: Container survival status monitoring, format such as: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1,"tcpSocket":{"host":"", "port":8080} }`.
        :param pulumi.Input[str] local_volume: The configuration of the host file mounted to the container. For example: `[{"type":"","nodePath":"/localfiles","mountPath":"/app/files"},{"type":"Directory","nodePath":"/mnt", "mountPath":"/app/storage"}]`. Among them, nodePath is the host path; mountPath is the path in the container; type is the mount type.
        :param pulumi.Input[str] logical_region_id: The ID corresponding to the EDAS namespace, the non-default namespace must be filled in.
        :param pulumi.Input[str] mount_descs: Mount configuration description, as a serialized JSON. For example: `[{"nasPath": "/k8s","mountPath": "/mnt"},{"nasPath": "/files","mountPath": "/app/files"}]`. Among them, nasPath refers to the file storage path; mountPath refers to the path mounted in the container.
        :param pulumi.Input[str] namespace: The namespace of the K8s cluster, it will determine which K8s namespace your application is deployed in. The default is 'default'.
        :param pulumi.Input[str] nas_id: The ID of the mounted NAS must be in the same region as the cluster. It must have an available mount point creation quota, or its mount point must be on a switch in the VPC. If it is not filled in and the mountDescs field exists, a NAS will be automatically purchased and mounted on the switch in the VPC by default.
        :param pulumi.Input[str] package_type: Application package type. Optional parameter values include: FatJar, WAR and Image.
        :param pulumi.Input[str] package_url: The url of the package to deploy.Applications deployed through FatJar or WAR packages need to configure it.
        :param pulumi.Input[str] package_version: The version number of the deployment package. WAR and FatJar types are required. Please customize its meaning.
        :param pulumi.Input[str] post_start: Execute script after startup
        :param pulumi.Input[str] pre_stop: Execute script before stopping
        :param pulumi.Input[str] readiness: Container service status check. If the check fails, the traffic passing through K8s Service will not be transferred to the container. The format is: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1, "httpGet": {"path": "/consumer","port": 8080,"scheme": "HTTP","httpHeaders": [{"name": "test","value": "testvalue"} ]}}`.
        :param pulumi.Input[int] replicas: Number of application instances.
        :param pulumi.Input[int] requests_m_cpu: When the application is created, the CPU quota of the application instance, unit: number of millcores, similar to request_cpu
        :param pulumi.Input[int] requests_mem: When the application is created, the memory limit of the application instance, unit: M. When set to 0, it means unlimited.
        :param pulumi.Input[str] web_container: The Tomcat version that the deployment package depends on. Applicable to Spring Cloud and Dubbo applications deployed through WAR packages. Image does not support this parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8sApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create an EDAS k8s application.For information about EDAS K8s Application and how to use it, see [What is EDAS K8s Application](https://www.alibabacloud.com/help/en/edas/developer-reference/api-edas-2017-08-01-insertk8sapplication).

        > **NOTE:** Available since v1.105.0.

        ## Import

        EDAS k8s application can be imported as below, e.g.

        ```sh
         $ pulumi import alicloud:edas/k8sApplication:K8sApplication new_k8s_application application_id
        ```

        :param str resource_name: The name of the resource.
        :param K8sApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8sApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_descriotion: Optional[pulumi.Input[str]] = None,
                 application_name: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 command: Optional[pulumi.Input[str]] = None,
                 command_args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 edas_container_version: Optional[pulumi.Input[str]] = None,
                 envs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 internet_slb_id: Optional[pulumi.Input[str]] = None,
                 internet_slb_port: Optional[pulumi.Input[int]] = None,
                 internet_slb_protocol: Optional[pulumi.Input[str]] = None,
                 internet_target_port: Optional[pulumi.Input[int]] = None,
                 jdk: Optional[pulumi.Input[str]] = None,
                 limit_m_cpu: Optional[pulumi.Input[int]] = None,
                 limit_mem: Optional[pulumi.Input[int]] = None,
                 liveness: Optional[pulumi.Input[str]] = None,
                 local_volume: Optional[pulumi.Input[str]] = None,
                 logical_region_id: Optional[pulumi.Input[str]] = None,
                 mount_descs: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 nas_id: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 package_url: Optional[pulumi.Input[str]] = None,
                 package_version: Optional[pulumi.Input[str]] = None,
                 post_start: Optional[pulumi.Input[str]] = None,
                 pre_stop: Optional[pulumi.Input[str]] = None,
                 readiness: Optional[pulumi.Input[str]] = None,
                 replicas: Optional[pulumi.Input[int]] = None,
                 requests_m_cpu: Optional[pulumi.Input[int]] = None,
                 requests_mem: Optional[pulumi.Input[int]] = None,
                 web_container: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8sApplicationArgs.__new__(K8sApplicationArgs)

            __props__.__dict__["application_descriotion"] = application_descriotion
            if application_name is None and not opts.urn:
                raise TypeError("Missing required property 'application_name'")
            __props__.__dict__["application_name"] = application_name
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["command"] = command
            __props__.__dict__["command_args"] = command_args
            __props__.__dict__["edas_container_version"] = edas_container_version
            __props__.__dict__["envs"] = envs
            __props__.__dict__["image_url"] = image_url
            __props__.__dict__["internet_slb_id"] = internet_slb_id
            __props__.__dict__["internet_slb_port"] = internet_slb_port
            __props__.__dict__["internet_slb_protocol"] = internet_slb_protocol
            __props__.__dict__["internet_target_port"] = internet_target_port
            __props__.__dict__["jdk"] = jdk
            __props__.__dict__["limit_m_cpu"] = limit_m_cpu
            __props__.__dict__["limit_mem"] = limit_mem
            __props__.__dict__["liveness"] = liveness
            __props__.__dict__["local_volume"] = local_volume
            __props__.__dict__["logical_region_id"] = logical_region_id
            __props__.__dict__["mount_descs"] = mount_descs
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["nas_id"] = nas_id
            __props__.__dict__["package_type"] = package_type
            __props__.__dict__["package_url"] = package_url
            __props__.__dict__["package_version"] = package_version
            __props__.__dict__["post_start"] = post_start
            __props__.__dict__["pre_stop"] = pre_stop
            __props__.__dict__["readiness"] = readiness
            __props__.__dict__["replicas"] = replicas
            __props__.__dict__["requests_m_cpu"] = requests_m_cpu
            __props__.__dict__["requests_mem"] = requests_mem
            __props__.__dict__["web_container"] = web_container
        super(K8sApplication, __self__).__init__(
            'alicloud:edas/k8sApplication:K8sApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_descriotion: Optional[pulumi.Input[str]] = None,
            application_name: Optional[pulumi.Input[str]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            command: Optional[pulumi.Input[str]] = None,
            command_args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            edas_container_version: Optional[pulumi.Input[str]] = None,
            envs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            image_url: Optional[pulumi.Input[str]] = None,
            internet_slb_id: Optional[pulumi.Input[str]] = None,
            internet_slb_port: Optional[pulumi.Input[int]] = None,
            internet_slb_protocol: Optional[pulumi.Input[str]] = None,
            internet_target_port: Optional[pulumi.Input[int]] = None,
            jdk: Optional[pulumi.Input[str]] = None,
            limit_m_cpu: Optional[pulumi.Input[int]] = None,
            limit_mem: Optional[pulumi.Input[int]] = None,
            liveness: Optional[pulumi.Input[str]] = None,
            local_volume: Optional[pulumi.Input[str]] = None,
            logical_region_id: Optional[pulumi.Input[str]] = None,
            mount_descs: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            nas_id: Optional[pulumi.Input[str]] = None,
            package_type: Optional[pulumi.Input[str]] = None,
            package_url: Optional[pulumi.Input[str]] = None,
            package_version: Optional[pulumi.Input[str]] = None,
            post_start: Optional[pulumi.Input[str]] = None,
            pre_stop: Optional[pulumi.Input[str]] = None,
            readiness: Optional[pulumi.Input[str]] = None,
            replicas: Optional[pulumi.Input[int]] = None,
            requests_m_cpu: Optional[pulumi.Input[int]] = None,
            requests_mem: Optional[pulumi.Input[int]] = None,
            web_container: Optional[pulumi.Input[str]] = None) -> 'K8sApplication':
        """
        Get an existing K8sApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] application_descriotion: The description of the application
        :param pulumi.Input[str] application_name: The name of the application you want to create. Must start with character,supports numbers, letters and dashes (-), supports up to 36 characters
        :param pulumi.Input[str] cluster_id: The ID of the alicloud container service kubernetes cluster that you want to import to. You can call the ListCluster operation to query.
        :param pulumi.Input[str] command: The set command, if set, will replace the startup command in the mirror when the mirror is started.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] command_args: Used in combination with the command, the parameter of the command is a JsonArray string in the format: `[{"argument":"-c"},{"argument":"test"}]`. Among them, -c and test are two parameters that need to be set.
        :param pulumi.Input[str] edas_container_version: EDAS-Container version that the deployed package depends on. Image does not support this parameter.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] envs: Deployment environment variables, the format must conform to the JSON object array, such as: `{"name":"x","value":"y"},{"name":"x2","value":"y2"}`, If you want to cancel the configuration, you need to set an empty JSON array "" to indicate no configuration.
        :param pulumi.Input[str] image_url: Mirror address. When the package_type is set to 'Image', this parameter item is required.
        :param pulumi.Input[str] internet_slb_id: Public network SLB ID. If not configured, EDAS will automatically purchase a new SLB for the user.
               It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[int] internet_slb_port: The public network SLB front-end port, range 1~65535. It has been deprecated and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[str] internet_slb_protocol: The public network SLB protocol supports TCP, HTTP and HTTPS protocols. It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[int] internet_target_port: The private SLB back-end port, is also the service port of the application, ranging from 1 to 65535.
               It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        :param pulumi.Input[str] jdk: The JDK version that the deployed package depends on. The optional parameter values are Open JDK 7 and Open JDK 8. Image does not support this parameter.
        :param pulumi.Input[int] limit_m_cpu: The CPU quota of the application instance during application operation. Unit: Number of millcores, set to 0 means unlimited, similar to request_cpu.
        :param pulumi.Input[int] limit_mem: The memory limit of the application instance during application operation, unit: M.
        :param pulumi.Input[str] liveness: Container survival status monitoring, format such as: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1,"tcpSocket":{"host":"", "port":8080} }`.
        :param pulumi.Input[str] local_volume: The configuration of the host file mounted to the container. For example: `[{"type":"","nodePath":"/localfiles","mountPath":"/app/files"},{"type":"Directory","nodePath":"/mnt", "mountPath":"/app/storage"}]`. Among them, nodePath is the host path; mountPath is the path in the container; type is the mount type.
        :param pulumi.Input[str] logical_region_id: The ID corresponding to the EDAS namespace, the non-default namespace must be filled in.
        :param pulumi.Input[str] mount_descs: Mount configuration description, as a serialized JSON. For example: `[{"nasPath": "/k8s","mountPath": "/mnt"},{"nasPath": "/files","mountPath": "/app/files"}]`. Among them, nasPath refers to the file storage path; mountPath refers to the path mounted in the container.
        :param pulumi.Input[str] namespace: The namespace of the K8s cluster, it will determine which K8s namespace your application is deployed in. The default is 'default'.
        :param pulumi.Input[str] nas_id: The ID of the mounted NAS must be in the same region as the cluster. It must have an available mount point creation quota, or its mount point must be on a switch in the VPC. If it is not filled in and the mountDescs field exists, a NAS will be automatically purchased and mounted on the switch in the VPC by default.
        :param pulumi.Input[str] package_type: Application package type. Optional parameter values include: FatJar, WAR and Image.
        :param pulumi.Input[str] package_url: The url of the package to deploy.Applications deployed through FatJar or WAR packages need to configure it.
        :param pulumi.Input[str] package_version: The version number of the deployment package. WAR and FatJar types are required. Please customize its meaning.
        :param pulumi.Input[str] post_start: Execute script after startup
        :param pulumi.Input[str] pre_stop: Execute script before stopping
        :param pulumi.Input[str] readiness: Container service status check. If the check fails, the traffic passing through K8s Service will not be transferred to the container. The format is: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1, "httpGet": {"path": "/consumer","port": 8080,"scheme": "HTTP","httpHeaders": [{"name": "test","value": "testvalue"} ]}}`.
        :param pulumi.Input[int] replicas: Number of application instances.
        :param pulumi.Input[int] requests_m_cpu: When the application is created, the CPU quota of the application instance, unit: number of millcores, similar to request_cpu
        :param pulumi.Input[int] requests_mem: When the application is created, the memory limit of the application instance, unit: M. When set to 0, it means unlimited.
        :param pulumi.Input[str] web_container: The Tomcat version that the deployment package depends on. Applicable to Spring Cloud and Dubbo applications deployed through WAR packages. Image does not support this parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8sApplicationState.__new__(_K8sApplicationState)

        __props__.__dict__["application_descriotion"] = application_descriotion
        __props__.__dict__["application_name"] = application_name
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["command"] = command
        __props__.__dict__["command_args"] = command_args
        __props__.__dict__["edas_container_version"] = edas_container_version
        __props__.__dict__["envs"] = envs
        __props__.__dict__["image_url"] = image_url
        __props__.__dict__["internet_slb_id"] = internet_slb_id
        __props__.__dict__["internet_slb_port"] = internet_slb_port
        __props__.__dict__["internet_slb_protocol"] = internet_slb_protocol
        __props__.__dict__["internet_target_port"] = internet_target_port
        __props__.__dict__["jdk"] = jdk
        __props__.__dict__["limit_m_cpu"] = limit_m_cpu
        __props__.__dict__["limit_mem"] = limit_mem
        __props__.__dict__["liveness"] = liveness
        __props__.__dict__["local_volume"] = local_volume
        __props__.__dict__["logical_region_id"] = logical_region_id
        __props__.__dict__["mount_descs"] = mount_descs
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["nas_id"] = nas_id
        __props__.__dict__["package_type"] = package_type
        __props__.__dict__["package_url"] = package_url
        __props__.__dict__["package_version"] = package_version
        __props__.__dict__["post_start"] = post_start
        __props__.__dict__["pre_stop"] = pre_stop
        __props__.__dict__["readiness"] = readiness
        __props__.__dict__["replicas"] = replicas
        __props__.__dict__["requests_m_cpu"] = requests_m_cpu
        __props__.__dict__["requests_mem"] = requests_mem
        __props__.__dict__["web_container"] = web_container
        return K8sApplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationDescriotion")
    def application_descriotion(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the application
        """
        return pulumi.get(self, "application_descriotion")

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> pulumi.Output[str]:
        """
        The name of the application you want to create. Must start with character,supports numbers, letters and dashes (-), supports up to 36 characters
        """
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The ID of the alicloud container service kubernetes cluster that you want to import to. You can call the ListCluster operation to query.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def command(self) -> pulumi.Output[Optional[str]]:
        """
        The set command, if set, will replace the startup command in the mirror when the mirror is started.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter(name="commandArgs")
    def command_args(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Used in combination with the command, the parameter of the command is a JsonArray string in the format: `[{"argument":"-c"},{"argument":"test"}]`. Among them, -c and test are two parameters that need to be set.
        """
        return pulumi.get(self, "command_args")

    @property
    @pulumi.getter(name="edasContainerVersion")
    def edas_container_version(self) -> pulumi.Output[Optional[str]]:
        """
        EDAS-Container version that the deployed package depends on. Image does not support this parameter.
        """
        return pulumi.get(self, "edas_container_version")

    @property
    @pulumi.getter
    def envs(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Deployment environment variables, the format must conform to the JSON object array, such as: `{"name":"x","value":"y"},{"name":"x2","value":"y2"}`, If you want to cancel the configuration, you need to set an empty JSON array "" to indicate no configuration.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> pulumi.Output[Optional[str]]:
        """
        Mirror address. When the package_type is set to 'Image', this parameter item is required.
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter(name="internetSlbId")
    def internet_slb_id(self) -> pulumi.Output[Optional[str]]:
        """
        Public network SLB ID. If not configured, EDAS will automatically purchase a new SLB for the user.
        It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        """
        warnings.warn("""Field 'internet_slb_id' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
        pulumi.log.warn("""internet_slb_id is deprecated: Field 'internet_slb_id' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")

        return pulumi.get(self, "internet_slb_id")

    @property
    @pulumi.getter(name="internetSlbPort")
    def internet_slb_port(self) -> pulumi.Output[Optional[int]]:
        """
        The public network SLB front-end port, range 1~65535. It has been deprecated and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        """
        warnings.warn("""Field 'internet_slb_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
        pulumi.log.warn("""internet_slb_port is deprecated: Field 'internet_slb_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")

        return pulumi.get(self, "internet_slb_port")

    @property
    @pulumi.getter(name="internetSlbProtocol")
    def internet_slb_protocol(self) -> pulumi.Output[Optional[str]]:
        """
        The public network SLB protocol supports TCP, HTTP and HTTPS protocols. It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        """
        warnings.warn("""Field 'internet_slb_protocol' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
        pulumi.log.warn("""internet_slb_protocol is deprecated: Field 'internet_slb_protocol' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")

        return pulumi.get(self, "internet_slb_protocol")

    @property
    @pulumi.getter(name="internetTargetPort")
    def internet_target_port(self) -> pulumi.Output[Optional[int]]:
        """
        The private SLB back-end port, is also the service port of the application, ranging from 1 to 65535.
        It has been deprecated, and new resource 'alicloud_edas_k8s_slb_attachment' replaces it.
        """
        warnings.warn("""Field 'internet_target_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""", DeprecationWarning)
        pulumi.log.warn("""internet_target_port is deprecated: Field 'internet_target_port' has been deprecated, New Resource 'alicloud_edas_k8s_slb_attachment' replaces it""")

        return pulumi.get(self, "internet_target_port")

    @property
    @pulumi.getter
    def jdk(self) -> pulumi.Output[Optional[str]]:
        """
        The JDK version that the deployed package depends on. The optional parameter values are Open JDK 7 and Open JDK 8. Image does not support this parameter.
        """
        return pulumi.get(self, "jdk")

    @property
    @pulumi.getter(name="limitMCpu")
    def limit_m_cpu(self) -> pulumi.Output[Optional[int]]:
        """
        The CPU quota of the application instance during application operation. Unit: Number of millcores, set to 0 means unlimited, similar to request_cpu.
        """
        return pulumi.get(self, "limit_m_cpu")

    @property
    @pulumi.getter(name="limitMem")
    def limit_mem(self) -> pulumi.Output[Optional[int]]:
        """
        The memory limit of the application instance during application operation, unit: M.
        """
        return pulumi.get(self, "limit_mem")

    @property
    @pulumi.getter
    def liveness(self) -> pulumi.Output[Optional[str]]:
        """
        Container survival status monitoring, format such as: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1,"tcpSocket":{"host":"", "port":8080} }`.
        """
        return pulumi.get(self, "liveness")

    @property
    @pulumi.getter(name="localVolume")
    def local_volume(self) -> pulumi.Output[Optional[str]]:
        """
        The configuration of the host file mounted to the container. For example: `[{"type":"","nodePath":"/localfiles","mountPath":"/app/files"},{"type":"Directory","nodePath":"/mnt", "mountPath":"/app/storage"}]`. Among them, nodePath is the host path; mountPath is the path in the container; type is the mount type.
        """
        return pulumi.get(self, "local_volume")

    @property
    @pulumi.getter(name="logicalRegionId")
    def logical_region_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID corresponding to the EDAS namespace, the non-default namespace must be filled in.
        """
        return pulumi.get(self, "logical_region_id")

    @property
    @pulumi.getter(name="mountDescs")
    def mount_descs(self) -> pulumi.Output[Optional[str]]:
        """
        Mount configuration description, as a serialized JSON. For example: `[{"nasPath": "/k8s","mountPath": "/mnt"},{"nasPath": "/files","mountPath": "/app/files"}]`. Among them, nasPath refers to the file storage path; mountPath refers to the path mounted in the container.
        """
        return pulumi.get(self, "mount_descs")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace of the K8s cluster, it will determine which K8s namespace your application is deployed in. The default is 'default'.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="nasId")
    def nas_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the mounted NAS must be in the same region as the cluster. It must have an available mount point creation quota, or its mount point must be on a switch in the VPC. If it is not filled in and the mountDescs field exists, a NAS will be automatically purchased and mounted on the switch in the VPC by default.
        """
        return pulumi.get(self, "nas_id")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> pulumi.Output[Optional[str]]:
        """
        Application package type. Optional parameter values include: FatJar, WAR and Image.
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="packageUrl")
    def package_url(self) -> pulumi.Output[Optional[str]]:
        """
        The url of the package to deploy.Applications deployed through FatJar or WAR packages need to configure it.
        """
        return pulumi.get(self, "package_url")

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> pulumi.Output[str]:
        """
        The version number of the deployment package. WAR and FatJar types are required. Please customize its meaning.
        """
        return pulumi.get(self, "package_version")

    @property
    @pulumi.getter(name="postStart")
    def post_start(self) -> pulumi.Output[Optional[str]]:
        """
        Execute script after startup
        """
        return pulumi.get(self, "post_start")

    @property
    @pulumi.getter(name="preStop")
    def pre_stop(self) -> pulumi.Output[Optional[str]]:
        """
        Execute script before stopping
        """
        return pulumi.get(self, "pre_stop")

    @property
    @pulumi.getter
    def readiness(self) -> pulumi.Output[Optional[str]]:
        """
        Container service status check. If the check fails, the traffic passing through K8s Service will not be transferred to the container. The format is: `{"failureThreshold": 3,"initialDelaySeconds": 5,"successThreshold": 1,"timeoutSeconds": 1, "httpGet": {"path": "/consumer","port": 8080,"scheme": "HTTP","httpHeaders": [{"name": "test","value": "testvalue"} ]}}`.
        """
        return pulumi.get(self, "readiness")

    @property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[Optional[int]]:
        """
        Number of application instances.
        """
        return pulumi.get(self, "replicas")

    @property
    @pulumi.getter(name="requestsMCpu")
    def requests_m_cpu(self) -> pulumi.Output[Optional[int]]:
        """
        When the application is created, the CPU quota of the application instance, unit: number of millcores, similar to request_cpu
        """
        return pulumi.get(self, "requests_m_cpu")

    @property
    @pulumi.getter(name="requestsMem")
    def requests_mem(self) -> pulumi.Output[Optional[int]]:
        """
        When the application is created, the memory limit of the application instance, unit: M. When set to 0, it means unlimited.
        """
        return pulumi.get(self, "requests_mem")

    @property
    @pulumi.getter(name="webContainer")
    def web_container(self) -> pulumi.Output[Optional[str]]:
        """
        The Tomcat version that the deployment package depends on. Applicable to Spring Cloud and Dubbo applications deployed through WAR packages. Image does not support this parameter.
        """
        return pulumi.get(self, "web_container")

