# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AdConnectorDirectoryArgs', 'AdConnectorDirectory']

@pulumi.input_type
class AdConnectorDirectoryArgs:
    def __init__(__self__, *,
                 directory_name: pulumi.Input[str],
                 dns_addresses: pulumi.Input[Sequence[pulumi.Input[str]]],
                 domain_name: pulumi.Input[str],
                 domain_password: pulumi.Input[str],
                 domain_user_name: pulumi.Input[str],
                 vswitch_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 desktop_access_type: Optional[pulumi.Input[str]] = None,
                 enable_admin_access: Optional[pulumi.Input[bool]] = None,
                 mfa_enabled: Optional[pulumi.Input[bool]] = None,
                 specification: Optional[pulumi.Input[int]] = None,
                 sub_domain_dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sub_domain_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AdConnectorDirectory resource.
        :param pulumi.Input[str] directory_name: The name of the directory. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_addresses: The DNS address list.
        :param pulumi.Input[str] domain_name: The name of the domain.
        :param pulumi.Input[str] domain_password: The user password of the domain administrator. The maximum number of English characters is 64.
        :param pulumi.Input[str] domain_user_name: The username of the domain administrator. The maximum number of English characters is 64.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vswitch_ids: List of VSwitch IDs in the directory.
        :param pulumi.Input[str] desktop_access_type: The desktop access type. Valid values: `VPC`, `INTERNET`, `ANY`.
        :param pulumi.Input[bool] enable_admin_access: Whether to grant local administrator rights to users who use cloud desktops.
        :param pulumi.Input[bool] mfa_enabled: Whether MFA authentication is enabled. After all AD users in this directory log on to the cloud desktop, enter the correct password and then enter the dynamic verification code generated by the MFA device. **NOTE:** The MFA device needs to be bound when logging in for the first time.
        :param pulumi.Input[int] specification: The AD Connector specifications. Valid values: `1`, `2`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sub_domain_dns_addresses: The Enterprise already has the DNS address of the AD subdomain. If `sub_domain_name` is set and this parameter is not set, the child Domain DNS is considered consistent with the parent domain.
        :param pulumi.Input[str] sub_domain_name: The Enterprise already has a fully qualified domain name (FQDN) of an AD subdomain, with both a host name and a domain name.
        """
        pulumi.set(__self__, "directory_name", directory_name)
        pulumi.set(__self__, "dns_addresses", dns_addresses)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "domain_password", domain_password)
        pulumi.set(__self__, "domain_user_name", domain_user_name)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if desktop_access_type is not None:
            pulumi.set(__self__, "desktop_access_type", desktop_access_type)
        if enable_admin_access is not None:
            pulumi.set(__self__, "enable_admin_access", enable_admin_access)
        if mfa_enabled is not None:
            pulumi.set(__self__, "mfa_enabled", mfa_enabled)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)
        if sub_domain_dns_addresses is not None:
            pulumi.set(__self__, "sub_domain_dns_addresses", sub_domain_dns_addresses)
        if sub_domain_name is not None:
            pulumi.set(__self__, "sub_domain_name", sub_domain_name)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> pulumi.Input[str]:
        """
        The name of the directory. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "directory_name")

    @directory_name.setter
    def directory_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "directory_name", value)

    @property
    @pulumi.getter(name="dnsAddresses")
    def dns_addresses(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The DNS address list.
        """
        return pulumi.get(self, "dns_addresses")

    @dns_addresses.setter
    def dns_addresses(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "dns_addresses", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Input[str]:
        """
        The name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="domainPassword")
    def domain_password(self) -> pulumi.Input[str]:
        """
        The user password of the domain administrator. The maximum number of English characters is 64.
        """
        return pulumi.get(self, "domain_password")

    @domain_password.setter
    def domain_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_password", value)

    @property
    @pulumi.getter(name="domainUserName")
    def domain_user_name(self) -> pulumi.Input[str]:
        """
        The username of the domain administrator. The maximum number of English characters is 64.
        """
        return pulumi.get(self, "domain_user_name")

    @domain_user_name.setter
    def domain_user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain_user_name", value)

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of VSwitch IDs in the directory.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "vswitch_ids", value)

    @property
    @pulumi.getter(name="desktopAccessType")
    def desktop_access_type(self) -> Optional[pulumi.Input[str]]:
        """
        The desktop access type. Valid values: `VPC`, `INTERNET`, `ANY`.
        """
        return pulumi.get(self, "desktop_access_type")

    @desktop_access_type.setter
    def desktop_access_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desktop_access_type", value)

    @property
    @pulumi.getter(name="enableAdminAccess")
    def enable_admin_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to grant local administrator rights to users who use cloud desktops.
        """
        return pulumi.get(self, "enable_admin_access")

    @enable_admin_access.setter
    def enable_admin_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_admin_access", value)

    @property
    @pulumi.getter(name="mfaEnabled")
    def mfa_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether MFA authentication is enabled. After all AD users in this directory log on to the cloud desktop, enter the correct password and then enter the dynamic verification code generated by the MFA device. **NOTE:** The MFA device needs to be bound when logging in for the first time.
        """
        return pulumi.get(self, "mfa_enabled")

    @mfa_enabled.setter
    def mfa_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mfa_enabled", value)

    @property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[int]]:
        """
        The AD Connector specifications. Valid values: `1`, `2`.
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "specification", value)

    @property
    @pulumi.getter(name="subDomainDnsAddresses")
    def sub_domain_dns_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Enterprise already has the DNS address of the AD subdomain. If `sub_domain_name` is set and this parameter is not set, the child Domain DNS is considered consistent with the parent domain.
        """
        return pulumi.get(self, "sub_domain_dns_addresses")

    @sub_domain_dns_addresses.setter
    def sub_domain_dns_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sub_domain_dns_addresses", value)

    @property
    @pulumi.getter(name="subDomainName")
    def sub_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Enterprise already has a fully qualified domain name (FQDN) of an AD subdomain, with both a host name and a domain name.
        """
        return pulumi.get(self, "sub_domain_name")

    @sub_domain_name.setter
    def sub_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sub_domain_name", value)


@pulumi.input_type
class _AdConnectorDirectoryState:
    def __init__(__self__, *,
                 desktop_access_type: Optional[pulumi.Input[str]] = None,
                 directory_name: Optional[pulumi.Input[str]] = None,
                 dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 domain_password: Optional[pulumi.Input[str]] = None,
                 domain_user_name: Optional[pulumi.Input[str]] = None,
                 enable_admin_access: Optional[pulumi.Input[bool]] = None,
                 mfa_enabled: Optional[pulumi.Input[bool]] = None,
                 specification: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 sub_domain_dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sub_domain_name: Optional[pulumi.Input[str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering AdConnectorDirectory resources.
        :param pulumi.Input[str] desktop_access_type: The desktop access type. Valid values: `VPC`, `INTERNET`, `ANY`.
        :param pulumi.Input[str] directory_name: The name of the directory. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_addresses: The DNS address list.
        :param pulumi.Input[str] domain_name: The name of the domain.
        :param pulumi.Input[str] domain_password: The user password of the domain administrator. The maximum number of English characters is 64.
        :param pulumi.Input[str] domain_user_name: The username of the domain administrator. The maximum number of English characters is 64.
        :param pulumi.Input[bool] enable_admin_access: Whether to grant local administrator rights to users who use cloud desktops.
        :param pulumi.Input[bool] mfa_enabled: Whether MFA authentication is enabled. After all AD users in this directory log on to the cloud desktop, enter the correct password and then enter the dynamic verification code generated by the MFA device. **NOTE:** The MFA device needs to be bound when logging in for the first time.
        :param pulumi.Input[int] specification: The AD Connector specifications. Valid values: `1`, `2`.
        :param pulumi.Input[str] status: The status of directory.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sub_domain_dns_addresses: The Enterprise already has the DNS address of the AD subdomain. If `sub_domain_name` is set and this parameter is not set, the child Domain DNS is considered consistent with the parent domain.
        :param pulumi.Input[str] sub_domain_name: The Enterprise already has a fully qualified domain name (FQDN) of an AD subdomain, with both a host name and a domain name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vswitch_ids: List of VSwitch IDs in the directory.
        """
        if desktop_access_type is not None:
            pulumi.set(__self__, "desktop_access_type", desktop_access_type)
        if directory_name is not None:
            pulumi.set(__self__, "directory_name", directory_name)
        if dns_addresses is not None:
            pulumi.set(__self__, "dns_addresses", dns_addresses)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if domain_password is not None:
            pulumi.set(__self__, "domain_password", domain_password)
        if domain_user_name is not None:
            pulumi.set(__self__, "domain_user_name", domain_user_name)
        if enable_admin_access is not None:
            pulumi.set(__self__, "enable_admin_access", enable_admin_access)
        if mfa_enabled is not None:
            pulumi.set(__self__, "mfa_enabled", mfa_enabled)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_domain_dns_addresses is not None:
            pulumi.set(__self__, "sub_domain_dns_addresses", sub_domain_dns_addresses)
        if sub_domain_name is not None:
            pulumi.set(__self__, "sub_domain_name", sub_domain_name)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @property
    @pulumi.getter(name="desktopAccessType")
    def desktop_access_type(self) -> Optional[pulumi.Input[str]]:
        """
        The desktop access type. Valid values: `VPC`, `INTERNET`, `ANY`.
        """
        return pulumi.get(self, "desktop_access_type")

    @desktop_access_type.setter
    def desktop_access_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desktop_access_type", value)

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the directory. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "directory_name")

    @directory_name.setter
    def directory_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directory_name", value)

    @property
    @pulumi.getter(name="dnsAddresses")
    def dns_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The DNS address list.
        """
        return pulumi.get(self, "dns_addresses")

    @dns_addresses.setter
    def dns_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "dns_addresses", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="domainPassword")
    def domain_password(self) -> Optional[pulumi.Input[str]]:
        """
        The user password of the domain administrator. The maximum number of English characters is 64.
        """
        return pulumi.get(self, "domain_password")

    @domain_password.setter
    def domain_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_password", value)

    @property
    @pulumi.getter(name="domainUserName")
    def domain_user_name(self) -> Optional[pulumi.Input[str]]:
        """
        The username of the domain administrator. The maximum number of English characters is 64.
        """
        return pulumi.get(self, "domain_user_name")

    @domain_user_name.setter
    def domain_user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_user_name", value)

    @property
    @pulumi.getter(name="enableAdminAccess")
    def enable_admin_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to grant local administrator rights to users who use cloud desktops.
        """
        return pulumi.get(self, "enable_admin_access")

    @enable_admin_access.setter
    def enable_admin_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_admin_access", value)

    @property
    @pulumi.getter(name="mfaEnabled")
    def mfa_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether MFA authentication is enabled. After all AD users in this directory log on to the cloud desktop, enter the correct password and then enter the dynamic verification code generated by the MFA device. **NOTE:** The MFA device needs to be bound when logging in for the first time.
        """
        return pulumi.get(self, "mfa_enabled")

    @mfa_enabled.setter
    def mfa_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mfa_enabled", value)

    @property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[int]]:
        """
        The AD Connector specifications. Valid values: `1`, `2`.
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "specification", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of directory.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subDomainDnsAddresses")
    def sub_domain_dns_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Enterprise already has the DNS address of the AD subdomain. If `sub_domain_name` is set and this parameter is not set, the child Domain DNS is considered consistent with the parent domain.
        """
        return pulumi.get(self, "sub_domain_dns_addresses")

    @sub_domain_dns_addresses.setter
    def sub_domain_dns_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sub_domain_dns_addresses", value)

    @property
    @pulumi.getter(name="subDomainName")
    def sub_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The Enterprise already has a fully qualified domain name (FQDN) of an AD subdomain, with both a host name and a domain name.
        """
        return pulumi.get(self, "sub_domain_name")

    @sub_domain_name.setter
    def sub_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sub_domain_name", value)

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of VSwitch IDs in the directory.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vswitch_ids", value)


class AdConnectorDirectory(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 desktop_access_type: Optional[pulumi.Input[str]] = None,
                 directory_name: Optional[pulumi.Input[str]] = None,
                 dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 domain_password: Optional[pulumi.Input[str]] = None,
                 domain_user_name: Optional[pulumi.Input[str]] = None,
                 enable_admin_access: Optional[pulumi.Input[bool]] = None,
                 mfa_enabled: Optional[pulumi.Input[bool]] = None,
                 specification: Optional[pulumi.Input[int]] = None,
                 sub_domain_dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sub_domain_name: Optional[pulumi.Input[str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a ECD Ad Connector Directory resource.

        For information about ECD Ad Connector Directory and how to use it, see [What is Ad Connector Directory](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createadconnectordirectory).

        > **NOTE:** Available since v1.174.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.eds.get_zones()
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default_zones.ids[0],
            vswitch_name=name)
        default_ad_connector_directory = alicloud.eds.AdConnectorDirectory("defaultAdConnectorDirectory",
            directory_name=name,
            desktop_access_type="INTERNET",
            dns_addresses=["127.0.0.2"],
            domain_name="corp.example.com",
            domain_password="Example1234",
            domain_user_name="sAMAccountName",
            enable_admin_access=False,
            mfa_enabled=False,
            specification=1,
            sub_domain_dns_addresses=["127.0.0.3"],
            sub_domain_name="child.example.com",
            vswitch_ids=[default_switch.id])
        ```

        ## Import

        ECD Ad Connector Directory can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:eds/adConnectorDirectory:AdConnectorDirectory example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] desktop_access_type: The desktop access type. Valid values: `VPC`, `INTERNET`, `ANY`.
        :param pulumi.Input[str] directory_name: The name of the directory. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_addresses: The DNS address list.
        :param pulumi.Input[str] domain_name: The name of the domain.
        :param pulumi.Input[str] domain_password: The user password of the domain administrator. The maximum number of English characters is 64.
        :param pulumi.Input[str] domain_user_name: The username of the domain administrator. The maximum number of English characters is 64.
        :param pulumi.Input[bool] enable_admin_access: Whether to grant local administrator rights to users who use cloud desktops.
        :param pulumi.Input[bool] mfa_enabled: Whether MFA authentication is enabled. After all AD users in this directory log on to the cloud desktop, enter the correct password and then enter the dynamic verification code generated by the MFA device. **NOTE:** The MFA device needs to be bound when logging in for the first time.
        :param pulumi.Input[int] specification: The AD Connector specifications. Valid values: `1`, `2`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sub_domain_dns_addresses: The Enterprise already has the DNS address of the AD subdomain. If `sub_domain_name` is set and this parameter is not set, the child Domain DNS is considered consistent with the parent domain.
        :param pulumi.Input[str] sub_domain_name: The Enterprise already has a fully qualified domain name (FQDN) of an AD subdomain, with both a host name and a domain name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vswitch_ids: List of VSwitch IDs in the directory.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AdConnectorDirectoryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECD Ad Connector Directory resource.

        For information about ECD Ad Connector Directory and how to use it, see [What is Ad Connector Directory](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createadconnectordirectory).

        > **NOTE:** Available since v1.174.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.eds.get_zones()
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default_zones.ids[0],
            vswitch_name=name)
        default_ad_connector_directory = alicloud.eds.AdConnectorDirectory("defaultAdConnectorDirectory",
            directory_name=name,
            desktop_access_type="INTERNET",
            dns_addresses=["127.0.0.2"],
            domain_name="corp.example.com",
            domain_password="Example1234",
            domain_user_name="sAMAccountName",
            enable_admin_access=False,
            mfa_enabled=False,
            specification=1,
            sub_domain_dns_addresses=["127.0.0.3"],
            sub_domain_name="child.example.com",
            vswitch_ids=[default_switch.id])
        ```

        ## Import

        ECD Ad Connector Directory can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:eds/adConnectorDirectory:AdConnectorDirectory example <id>
        ```

        :param str resource_name: The name of the resource.
        :param AdConnectorDirectoryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AdConnectorDirectoryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 desktop_access_type: Optional[pulumi.Input[str]] = None,
                 directory_name: Optional[pulumi.Input[str]] = None,
                 dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 domain_password: Optional[pulumi.Input[str]] = None,
                 domain_user_name: Optional[pulumi.Input[str]] = None,
                 enable_admin_access: Optional[pulumi.Input[bool]] = None,
                 mfa_enabled: Optional[pulumi.Input[bool]] = None,
                 specification: Optional[pulumi.Input[int]] = None,
                 sub_domain_dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sub_domain_name: Optional[pulumi.Input[str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AdConnectorDirectoryArgs.__new__(AdConnectorDirectoryArgs)

            __props__.__dict__["desktop_access_type"] = desktop_access_type
            if directory_name is None and not opts.urn:
                raise TypeError("Missing required property 'directory_name'")
            __props__.__dict__["directory_name"] = directory_name
            if dns_addresses is None and not opts.urn:
                raise TypeError("Missing required property 'dns_addresses'")
            __props__.__dict__["dns_addresses"] = dns_addresses
            if domain_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_name'")
            __props__.__dict__["domain_name"] = domain_name
            if domain_password is None and not opts.urn:
                raise TypeError("Missing required property 'domain_password'")
            __props__.__dict__["domain_password"] = None if domain_password is None else pulumi.Output.secret(domain_password)
            if domain_user_name is None and not opts.urn:
                raise TypeError("Missing required property 'domain_user_name'")
            __props__.__dict__["domain_user_name"] = domain_user_name
            __props__.__dict__["enable_admin_access"] = enable_admin_access
            __props__.__dict__["mfa_enabled"] = mfa_enabled
            __props__.__dict__["specification"] = specification
            __props__.__dict__["sub_domain_dns_addresses"] = sub_domain_dns_addresses
            __props__.__dict__["sub_domain_name"] = sub_domain_name
            if vswitch_ids is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_ids'")
            __props__.__dict__["vswitch_ids"] = vswitch_ids
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["domainPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AdConnectorDirectory, __self__).__init__(
            'alicloud:eds/adConnectorDirectory:AdConnectorDirectory',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            desktop_access_type: Optional[pulumi.Input[str]] = None,
            directory_name: Optional[pulumi.Input[str]] = None,
            dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            domain_password: Optional[pulumi.Input[str]] = None,
            domain_user_name: Optional[pulumi.Input[str]] = None,
            enable_admin_access: Optional[pulumi.Input[bool]] = None,
            mfa_enabled: Optional[pulumi.Input[bool]] = None,
            specification: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            sub_domain_dns_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            sub_domain_name: Optional[pulumi.Input[str]] = None,
            vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'AdConnectorDirectory':
        """
        Get an existing AdConnectorDirectory resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] desktop_access_type: The desktop access type. Valid values: `VPC`, `INTERNET`, `ANY`.
        :param pulumi.Input[str] directory_name: The name of the directory. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dns_addresses: The DNS address list.
        :param pulumi.Input[str] domain_name: The name of the domain.
        :param pulumi.Input[str] domain_password: The user password of the domain administrator. The maximum number of English characters is 64.
        :param pulumi.Input[str] domain_user_name: The username of the domain administrator. The maximum number of English characters is 64.
        :param pulumi.Input[bool] enable_admin_access: Whether to grant local administrator rights to users who use cloud desktops.
        :param pulumi.Input[bool] mfa_enabled: Whether MFA authentication is enabled. After all AD users in this directory log on to the cloud desktop, enter the correct password and then enter the dynamic verification code generated by the MFA device. **NOTE:** The MFA device needs to be bound when logging in for the first time.
        :param pulumi.Input[int] specification: The AD Connector specifications. Valid values: `1`, `2`.
        :param pulumi.Input[str] status: The status of directory.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sub_domain_dns_addresses: The Enterprise already has the DNS address of the AD subdomain. If `sub_domain_name` is set and this parameter is not set, the child Domain DNS is considered consistent with the parent domain.
        :param pulumi.Input[str] sub_domain_name: The Enterprise already has a fully qualified domain name (FQDN) of an AD subdomain, with both a host name and a domain name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vswitch_ids: List of VSwitch IDs in the directory.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AdConnectorDirectoryState.__new__(_AdConnectorDirectoryState)

        __props__.__dict__["desktop_access_type"] = desktop_access_type
        __props__.__dict__["directory_name"] = directory_name
        __props__.__dict__["dns_addresses"] = dns_addresses
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["domain_password"] = domain_password
        __props__.__dict__["domain_user_name"] = domain_user_name
        __props__.__dict__["enable_admin_access"] = enable_admin_access
        __props__.__dict__["mfa_enabled"] = mfa_enabled
        __props__.__dict__["specification"] = specification
        __props__.__dict__["status"] = status
        __props__.__dict__["sub_domain_dns_addresses"] = sub_domain_dns_addresses
        __props__.__dict__["sub_domain_name"] = sub_domain_name
        __props__.__dict__["vswitch_ids"] = vswitch_ids
        return AdConnectorDirectory(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="desktopAccessType")
    def desktop_access_type(self) -> pulumi.Output[str]:
        """
        The desktop access type. Valid values: `VPC`, `INTERNET`, `ANY`.
        """
        return pulumi.get(self, "desktop_access_type")

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> pulumi.Output[str]:
        """
        The name of the directory. The name must be 2 to 255 characters in length. It must start with a letter but cannot start with `http://` or `https://`. It can contain letters, digits, colons (:), underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "directory_name")

    @property
    @pulumi.getter(name="dnsAddresses")
    def dns_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        The DNS address list.
        """
        return pulumi.get(self, "dns_addresses")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        The name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="domainPassword")
    def domain_password(self) -> pulumi.Output[str]:
        """
        The user password of the domain administrator. The maximum number of English characters is 64.
        """
        return pulumi.get(self, "domain_password")

    @property
    @pulumi.getter(name="domainUserName")
    def domain_user_name(self) -> pulumi.Output[str]:
        """
        The username of the domain administrator. The maximum number of English characters is 64.
        """
        return pulumi.get(self, "domain_user_name")

    @property
    @pulumi.getter(name="enableAdminAccess")
    def enable_admin_access(self) -> pulumi.Output[bool]:
        """
        Whether to grant local administrator rights to users who use cloud desktops.
        """
        return pulumi.get(self, "enable_admin_access")

    @property
    @pulumi.getter(name="mfaEnabled")
    def mfa_enabled(self) -> pulumi.Output[bool]:
        """
        Whether MFA authentication is enabled. After all AD users in this directory log on to the cloud desktop, enter the correct password and then enter the dynamic verification code generated by the MFA device. **NOTE:** The MFA device needs to be bound when logging in for the first time.
        """
        return pulumi.get(self, "mfa_enabled")

    @property
    @pulumi.getter
    def specification(self) -> pulumi.Output[Optional[int]]:
        """
        The AD Connector specifications. Valid values: `1`, `2`.
        """
        return pulumi.get(self, "specification")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of directory.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subDomainDnsAddresses")
    def sub_domain_dns_addresses(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The Enterprise already has the DNS address of the AD subdomain. If `sub_domain_name` is set and this parameter is not set, the child Domain DNS is considered consistent with the parent domain.
        """
        return pulumi.get(self, "sub_domain_dns_addresses")

    @property
    @pulumi.getter(name="subDomainName")
    def sub_domain_name(self) -> pulumi.Output[Optional[str]]:
        """
        The Enterprise already has a fully qualified domain name (FQDN) of an AD subdomain, with both a host name and a domain name.
        """
        return pulumi.get(self, "sub_domain_name")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        List of VSwitch IDs in the directory.
        """
        return pulumi.get(self, "vswitch_ids")

