# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DesktopArgs', 'Desktop']

@pulumi.input_type
class DesktopArgs:
    def __init__(__self__, *,
                 bundle_id: pulumi.Input[str],
                 office_site_id: pulumi.Input[str],
                 policy_group_id: pulumi.Input[str],
                 amount: Optional[pulumi.Input[int]] = None,
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 desktop_name: Optional[pulumi.Input[str]] = None,
                 desktop_type: Optional[pulumi.Input[str]] = None,
                 end_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 root_disk_size_gib: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 stopped_mode: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_assign_mode: Optional[pulumi.Input[str]] = None,
                 user_disk_size_gib: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Desktop resource.
        :param pulumi.Input[str] bundle_id: The bundle id of the Desktop.
        :param pulumi.Input[str] office_site_id: The ID of the Simple Office Site.
        :param pulumi.Input[str] policy_group_id: The policy group id of the Desktop.
        :param pulumi.Input[int] amount: The amount of the Desktop.
        :param pulumi.Input[bool] auto_pay: The auto-pay of the Desktop whether to pay automatically. values: `true`, `false`.
        :param pulumi.Input[bool] auto_renew: The auto-renewal of the Desktop whether to renew automatically. It takes effect only when the parameter ChargeType is set to PrePaid. values: `true`, `false`.
        :param pulumi.Input[str] desktop_name: The desktop name of the Desktop.
        :param pulumi.Input[str] desktop_type: The desktop type of the Desktop.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] end_user_ids: The desktop end user id of the Desktop.
        :param pulumi.Input[str] host_name: The hostname of the Desktop.
        :param pulumi.Input[str] payment_type: The payment type of the Desktop. Valid values: `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
        :param pulumi.Input[int] period: The period of the Desktop.
        :param pulumi.Input[str] period_unit: The period unit of the Desktop.
        :param pulumi.Input[int] root_disk_size_gib: The root disk size gib of the Desktop.
        :param pulumi.Input[str] status: The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
        :param pulumi.Input[str] stopped_mode: The stopped mode of the Desktop.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] user_assign_mode: The user assign mode of the Desktop. Valid values: `ALL`, `PER_USER`. Default to `ALL`.
        :param pulumi.Input[int] user_disk_size_gib: The user disk size gib of the Desktop.
        """
        pulumi.set(__self__, "bundle_id", bundle_id)
        pulumi.set(__self__, "office_site_id", office_site_id)
        pulumi.set(__self__, "policy_group_id", policy_group_id)
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if desktop_name is not None:
            pulumi.set(__self__, "desktop_name", desktop_name)
        if desktop_type is not None:
            pulumi.set(__self__, "desktop_type", desktop_type)
        if end_user_ids is not None:
            pulumi.set(__self__, "end_user_ids", end_user_ids)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if root_disk_size_gib is not None:
            pulumi.set(__self__, "root_disk_size_gib", root_disk_size_gib)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stopped_mode is not None:
            pulumi.set(__self__, "stopped_mode", stopped_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_assign_mode is not None:
            pulumi.set(__self__, "user_assign_mode", user_assign_mode)
        if user_disk_size_gib is not None:
            pulumi.set(__self__, "user_disk_size_gib", user_disk_size_gib)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Input[str]:
        """
        The bundle id of the Desktop.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bundle_id", value)

    @property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> pulumi.Input[str]:
        """
        The ID of the Simple Office Site.
        """
        return pulumi.get(self, "office_site_id")

    @office_site_id.setter
    def office_site_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "office_site_id", value)

    @property
    @pulumi.getter(name="policyGroupId")
    def policy_group_id(self) -> pulumi.Input[str]:
        """
        The policy group id of the Desktop.
        """
        return pulumi.get(self, "policy_group_id")

    @policy_group_id.setter
    def policy_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_group_id", value)

    @property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of the Desktop.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "amount", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[bool]]:
        """
        The auto-pay of the Desktop whether to pay automatically. values: `true`, `false`.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        The auto-renewal of the Desktop whether to renew automatically. It takes effect only when the parameter ChargeType is set to PrePaid. values: `true`, `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="desktopName")
    def desktop_name(self) -> Optional[pulumi.Input[str]]:
        """
        The desktop name of the Desktop.
        """
        return pulumi.get(self, "desktop_name")

    @desktop_name.setter
    def desktop_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desktop_name", value)

    @property
    @pulumi.getter(name="desktopType")
    def desktop_type(self) -> Optional[pulumi.Input[str]]:
        """
        The desktop type of the Desktop.
        """
        return pulumi.get(self, "desktop_type")

    @desktop_type.setter
    def desktop_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desktop_type", value)

    @property
    @pulumi.getter(name="endUserIds")
    def end_user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The desktop end user id of the Desktop.
        """
        return pulumi.get(self, "end_user_ids")

    @end_user_ids.setter
    def end_user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "end_user_ids", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname of the Desktop.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the Desktop. Valid values: `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The period of the Desktop.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The period unit of the Desktop.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="rootDiskSizeGib")
    def root_disk_size_gib(self) -> Optional[pulumi.Input[int]]:
        """
        The root disk size gib of the Desktop.
        """
        return pulumi.get(self, "root_disk_size_gib")

    @root_disk_size_gib.setter
    def root_disk_size_gib(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "root_disk_size_gib", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="stoppedMode")
    def stopped_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The stopped mode of the Desktop.
        """
        return pulumi.get(self, "stopped_mode")

    @stopped_mode.setter
    def stopped_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stopped_mode", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userAssignMode")
    def user_assign_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The user assign mode of the Desktop. Valid values: `ALL`, `PER_USER`. Default to `ALL`.
        """
        return pulumi.get(self, "user_assign_mode")

    @user_assign_mode.setter
    def user_assign_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_assign_mode", value)

    @property
    @pulumi.getter(name="userDiskSizeGib")
    def user_disk_size_gib(self) -> Optional[pulumi.Input[int]]:
        """
        The user disk size gib of the Desktop.
        """
        return pulumi.get(self, "user_disk_size_gib")

    @user_disk_size_gib.setter
    def user_disk_size_gib(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_disk_size_gib", value)


@pulumi.input_type
class _DesktopState:
    def __init__(__self__, *,
                 amount: Optional[pulumi.Input[int]] = None,
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 desktop_name: Optional[pulumi.Input[str]] = None,
                 desktop_type: Optional[pulumi.Input[str]] = None,
                 end_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 office_site_id: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 policy_group_id: Optional[pulumi.Input[str]] = None,
                 root_disk_size_gib: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 stopped_mode: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_assign_mode: Optional[pulumi.Input[str]] = None,
                 user_disk_size_gib: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Desktop resources.
        :param pulumi.Input[int] amount: The amount of the Desktop.
        :param pulumi.Input[bool] auto_pay: The auto-pay of the Desktop whether to pay automatically. values: `true`, `false`.
        :param pulumi.Input[bool] auto_renew: The auto-renewal of the Desktop whether to renew automatically. It takes effect only when the parameter ChargeType is set to PrePaid. values: `true`, `false`.
        :param pulumi.Input[str] bundle_id: The bundle id of the Desktop.
        :param pulumi.Input[str] desktop_name: The desktop name of the Desktop.
        :param pulumi.Input[str] desktop_type: The desktop type of the Desktop.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] end_user_ids: The desktop end user id of the Desktop.
        :param pulumi.Input[str] host_name: The hostname of the Desktop.
        :param pulumi.Input[str] office_site_id: The ID of the Simple Office Site.
        :param pulumi.Input[str] payment_type: The payment type of the Desktop. Valid values: `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
        :param pulumi.Input[int] period: The period of the Desktop.
        :param pulumi.Input[str] period_unit: The period unit of the Desktop.
        :param pulumi.Input[str] policy_group_id: The policy group id of the Desktop.
        :param pulumi.Input[int] root_disk_size_gib: The root disk size gib of the Desktop.
        :param pulumi.Input[str] status: The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
        :param pulumi.Input[str] stopped_mode: The stopped mode of the Desktop.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] user_assign_mode: The user assign mode of the Desktop. Valid values: `ALL`, `PER_USER`. Default to `ALL`.
        :param pulumi.Input[int] user_disk_size_gib: The user disk size gib of the Desktop.
        """
        if amount is not None:
            pulumi.set(__self__, "amount", amount)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if bundle_id is not None:
            pulumi.set(__self__, "bundle_id", bundle_id)
        if desktop_name is not None:
            pulumi.set(__self__, "desktop_name", desktop_name)
        if desktop_type is not None:
            pulumi.set(__self__, "desktop_type", desktop_type)
        if end_user_ids is not None:
            pulumi.set(__self__, "end_user_ids", end_user_ids)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if office_site_id is not None:
            pulumi.set(__self__, "office_site_id", office_site_id)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if policy_group_id is not None:
            pulumi.set(__self__, "policy_group_id", policy_group_id)
        if root_disk_size_gib is not None:
            pulumi.set(__self__, "root_disk_size_gib", root_disk_size_gib)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stopped_mode is not None:
            pulumi.set(__self__, "stopped_mode", stopped_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_assign_mode is not None:
            pulumi.set(__self__, "user_assign_mode", user_assign_mode)
        if user_disk_size_gib is not None:
            pulumi.set(__self__, "user_disk_size_gib", user_disk_size_gib)

    @property
    @pulumi.getter
    def amount(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of the Desktop.
        """
        return pulumi.get(self, "amount")

    @amount.setter
    def amount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "amount", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[bool]]:
        """
        The auto-pay of the Desktop whether to pay automatically. values: `true`, `false`.
        """
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        The auto-renewal of the Desktop whether to renew automatically. It takes effect only when the parameter ChargeType is set to PrePaid. values: `true`, `false`.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        The bundle id of the Desktop.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bundle_id", value)

    @property
    @pulumi.getter(name="desktopName")
    def desktop_name(self) -> Optional[pulumi.Input[str]]:
        """
        The desktop name of the Desktop.
        """
        return pulumi.get(self, "desktop_name")

    @desktop_name.setter
    def desktop_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desktop_name", value)

    @property
    @pulumi.getter(name="desktopType")
    def desktop_type(self) -> Optional[pulumi.Input[str]]:
        """
        The desktop type of the Desktop.
        """
        return pulumi.get(self, "desktop_type")

    @desktop_type.setter
    def desktop_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desktop_type", value)

    @property
    @pulumi.getter(name="endUserIds")
    def end_user_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The desktop end user id of the Desktop.
        """
        return pulumi.get(self, "end_user_ids")

    @end_user_ids.setter
    def end_user_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "end_user_ids", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname of the Desktop.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Simple Office Site.
        """
        return pulumi.get(self, "office_site_id")

    @office_site_id.setter
    def office_site_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "office_site_id", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The payment type of the Desktop. Valid values: `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The period of the Desktop.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The period unit of the Desktop.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="policyGroupId")
    def policy_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The policy group id of the Desktop.
        """
        return pulumi.get(self, "policy_group_id")

    @policy_group_id.setter
    def policy_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_group_id", value)

    @property
    @pulumi.getter(name="rootDiskSizeGib")
    def root_disk_size_gib(self) -> Optional[pulumi.Input[int]]:
        """
        The root disk size gib of the Desktop.
        """
        return pulumi.get(self, "root_disk_size_gib")

    @root_disk_size_gib.setter
    def root_disk_size_gib(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "root_disk_size_gib", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="stoppedMode")
    def stopped_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The stopped mode of the Desktop.
        """
        return pulumi.get(self, "stopped_mode")

    @stopped_mode.setter
    def stopped_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stopped_mode", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userAssignMode")
    def user_assign_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The user assign mode of the Desktop. Valid values: `ALL`, `PER_USER`. Default to `ALL`.
        """
        return pulumi.get(self, "user_assign_mode")

    @user_assign_mode.setter
    def user_assign_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_assign_mode", value)

    @property
    @pulumi.getter(name="userDiskSizeGib")
    def user_disk_size_gib(self) -> Optional[pulumi.Input[int]]:
        """
        The user disk size gib of the Desktop.
        """
        return pulumi.get(self, "user_disk_size_gib")

    @user_disk_size_gib.setter
    def user_disk_size_gib(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "user_disk_size_gib", value)


class Desktop(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[int]] = None,
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 desktop_name: Optional[pulumi.Input[str]] = None,
                 desktop_type: Optional[pulumi.Input[str]] = None,
                 end_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 office_site_id: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 policy_group_id: Optional[pulumi.Input[str]] = None,
                 root_disk_size_gib: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 stopped_mode: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_assign_mode: Optional[pulumi.Input[str]] = None,
                 user_disk_size_gib: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a ECD Desktop resource.

        For information about ECD Desktop and how to use it, see [What is Desktop](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createdesktops)

        > **NOTE:** Available since v1.144.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_simple_office_site = alicloud.eds.SimpleOfficeSite("defaultSimpleOfficeSite",
            cidr_block="172.16.0.0/12",
            enable_admin_access=True,
            desktop_access_type="Internet",
            office_site_name=name)
        default_ecd_policy_group = alicloud.eds.EcdPolicyGroup("defaultEcdPolicyGroup",
            policy_group_name=name,
            clipboard="read",
            local_drive="read",
            usb_redirect="off",
            watermark="off",
            authorize_access_policy_rules=[alicloud.eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs(
                description=name,
                cidr_ip="1.2.3.45/24",
            )],
            authorize_security_policy_rules=[alicloud.eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs(
                type="inflow",
                policy="accept",
                description=name,
                port_range="80/80",
                ip_protocol="TCP",
                priority="1",
                cidr_ip="1.2.3.4/24",
            )])
        default_bundles = alicloud.eds.get_bundles(bundle_type="SYSTEM")
        default_desktop = alicloud.eds.Desktop("defaultDesktop",
            office_site_id=default_simple_office_site.id,
            policy_group_id=default_ecd_policy_group.id,
            bundle_id=default_bundles.bundles[1].id,
            desktop_name=name)
        ```

        ## Import

        ECD Desktop can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:eds/desktop:Desktop example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] amount: The amount of the Desktop.
        :param pulumi.Input[bool] auto_pay: The auto-pay of the Desktop whether to pay automatically. values: `true`, `false`.
        :param pulumi.Input[bool] auto_renew: The auto-renewal of the Desktop whether to renew automatically. It takes effect only when the parameter ChargeType is set to PrePaid. values: `true`, `false`.
        :param pulumi.Input[str] bundle_id: The bundle id of the Desktop.
        :param pulumi.Input[str] desktop_name: The desktop name of the Desktop.
        :param pulumi.Input[str] desktop_type: The desktop type of the Desktop.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] end_user_ids: The desktop end user id of the Desktop.
        :param pulumi.Input[str] host_name: The hostname of the Desktop.
        :param pulumi.Input[str] office_site_id: The ID of the Simple Office Site.
        :param pulumi.Input[str] payment_type: The payment type of the Desktop. Valid values: `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
        :param pulumi.Input[int] period: The period of the Desktop.
        :param pulumi.Input[str] period_unit: The period unit of the Desktop.
        :param pulumi.Input[str] policy_group_id: The policy group id of the Desktop.
        :param pulumi.Input[int] root_disk_size_gib: The root disk size gib of the Desktop.
        :param pulumi.Input[str] status: The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
        :param pulumi.Input[str] stopped_mode: The stopped mode of the Desktop.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] user_assign_mode: The user assign mode of the Desktop. Valid values: `ALL`, `PER_USER`. Default to `ALL`.
        :param pulumi.Input[int] user_disk_size_gib: The user disk size gib of the Desktop.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DesktopArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ECD Desktop resource.

        For information about ECD Desktop and how to use it, see [What is Desktop](https://www.alibabacloud.com/help/en/wuying-workspace/developer-reference/api-ecd-2020-09-30-createdesktops)

        > **NOTE:** Available since v1.144.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_simple_office_site = alicloud.eds.SimpleOfficeSite("defaultSimpleOfficeSite",
            cidr_block="172.16.0.0/12",
            enable_admin_access=True,
            desktop_access_type="Internet",
            office_site_name=name)
        default_ecd_policy_group = alicloud.eds.EcdPolicyGroup("defaultEcdPolicyGroup",
            policy_group_name=name,
            clipboard="read",
            local_drive="read",
            usb_redirect="off",
            watermark="off",
            authorize_access_policy_rules=[alicloud.eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs(
                description=name,
                cidr_ip="1.2.3.45/24",
            )],
            authorize_security_policy_rules=[alicloud.eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs(
                type="inflow",
                policy="accept",
                description=name,
                port_range="80/80",
                ip_protocol="TCP",
                priority="1",
                cidr_ip="1.2.3.4/24",
            )])
        default_bundles = alicloud.eds.get_bundles(bundle_type="SYSTEM")
        default_desktop = alicloud.eds.Desktop("defaultDesktop",
            office_site_id=default_simple_office_site.id,
            policy_group_id=default_ecd_policy_group.id,
            bundle_id=default_bundles.bundles[1].id,
            desktop_name=name)
        ```

        ## Import

        ECD Desktop can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:eds/desktop:Desktop example <id>
        ```

        :param str resource_name: The name of the resource.
        :param DesktopArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DesktopArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 amount: Optional[pulumi.Input[int]] = None,
                 auto_pay: Optional[pulumi.Input[bool]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 desktop_name: Optional[pulumi.Input[str]] = None,
                 desktop_type: Optional[pulumi.Input[str]] = None,
                 end_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 office_site_id: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 policy_group_id: Optional[pulumi.Input[str]] = None,
                 root_disk_size_gib: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 stopped_mode: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_assign_mode: Optional[pulumi.Input[str]] = None,
                 user_disk_size_gib: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DesktopArgs.__new__(DesktopArgs)

            __props__.__dict__["amount"] = amount
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            if bundle_id is None and not opts.urn:
                raise TypeError("Missing required property 'bundle_id'")
            __props__.__dict__["bundle_id"] = bundle_id
            __props__.__dict__["desktop_name"] = desktop_name
            __props__.__dict__["desktop_type"] = desktop_type
            __props__.__dict__["end_user_ids"] = end_user_ids
            __props__.__dict__["host_name"] = host_name
            if office_site_id is None and not opts.urn:
                raise TypeError("Missing required property 'office_site_id'")
            __props__.__dict__["office_site_id"] = office_site_id
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            if policy_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_group_id'")
            __props__.__dict__["policy_group_id"] = policy_group_id
            __props__.__dict__["root_disk_size_gib"] = root_disk_size_gib
            __props__.__dict__["status"] = status
            __props__.__dict__["stopped_mode"] = stopped_mode
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_assign_mode"] = user_assign_mode
            __props__.__dict__["user_disk_size_gib"] = user_disk_size_gib
        super(Desktop, __self__).__init__(
            'alicloud:eds/desktop:Desktop',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            amount: Optional[pulumi.Input[int]] = None,
            auto_pay: Optional[pulumi.Input[bool]] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            bundle_id: Optional[pulumi.Input[str]] = None,
            desktop_name: Optional[pulumi.Input[str]] = None,
            desktop_type: Optional[pulumi.Input[str]] = None,
            end_user_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            office_site_id: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            policy_group_id: Optional[pulumi.Input[str]] = None,
            root_disk_size_gib: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            stopped_mode: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            user_assign_mode: Optional[pulumi.Input[str]] = None,
            user_disk_size_gib: Optional[pulumi.Input[int]] = None) -> 'Desktop':
        """
        Get an existing Desktop resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] amount: The amount of the Desktop.
        :param pulumi.Input[bool] auto_pay: The auto-pay of the Desktop whether to pay automatically. values: `true`, `false`.
        :param pulumi.Input[bool] auto_renew: The auto-renewal of the Desktop whether to renew automatically. It takes effect only when the parameter ChargeType is set to PrePaid. values: `true`, `false`.
        :param pulumi.Input[str] bundle_id: The bundle id of the Desktop.
        :param pulumi.Input[str] desktop_name: The desktop name of the Desktop.
        :param pulumi.Input[str] desktop_type: The desktop type of the Desktop.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] end_user_ids: The desktop end user id of the Desktop.
        :param pulumi.Input[str] host_name: The hostname of the Desktop.
        :param pulumi.Input[str] office_site_id: The ID of the Simple Office Site.
        :param pulumi.Input[str] payment_type: The payment type of the Desktop. Valid values: `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
        :param pulumi.Input[int] period: The period of the Desktop.
        :param pulumi.Input[str] period_unit: The period unit of the Desktop.
        :param pulumi.Input[str] policy_group_id: The policy group id of the Desktop.
        :param pulumi.Input[int] root_disk_size_gib: The root disk size gib of the Desktop.
        :param pulumi.Input[str] status: The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
        :param pulumi.Input[str] stopped_mode: The stopped mode of the Desktop.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] user_assign_mode: The user assign mode of the Desktop. Valid values: `ALL`, `PER_USER`. Default to `ALL`.
        :param pulumi.Input[int] user_disk_size_gib: The user disk size gib of the Desktop.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DesktopState.__new__(_DesktopState)

        __props__.__dict__["amount"] = amount
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["bundle_id"] = bundle_id
        __props__.__dict__["desktop_name"] = desktop_name
        __props__.__dict__["desktop_type"] = desktop_type
        __props__.__dict__["end_user_ids"] = end_user_ids
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["office_site_id"] = office_site_id
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["policy_group_id"] = policy_group_id
        __props__.__dict__["root_disk_size_gib"] = root_disk_size_gib
        __props__.__dict__["status"] = status
        __props__.__dict__["stopped_mode"] = stopped_mode
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_assign_mode"] = user_assign_mode
        __props__.__dict__["user_disk_size_gib"] = user_disk_size_gib
        return Desktop(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def amount(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of the Desktop.
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[bool]]:
        """
        The auto-pay of the Desktop whether to pay automatically. values: `true`, `false`.
        """
        return pulumi.get(self, "auto_pay")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        The auto-renewal of the Desktop whether to renew automatically. It takes effect only when the parameter ChargeType is set to PrePaid. values: `true`, `false`.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Output[str]:
        """
        The bundle id of the Desktop.
        """
        return pulumi.get(self, "bundle_id")

    @property
    @pulumi.getter(name="desktopName")
    def desktop_name(self) -> pulumi.Output[Optional[str]]:
        """
        The desktop name of the Desktop.
        """
        return pulumi.get(self, "desktop_name")

    @property
    @pulumi.getter(name="desktopType")
    def desktop_type(self) -> pulumi.Output[str]:
        """
        The desktop type of the Desktop.
        """
        return pulumi.get(self, "desktop_type")

    @property
    @pulumi.getter(name="endUserIds")
    def end_user_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The desktop end user id of the Desktop.
        """
        return pulumi.get(self, "end_user_ids")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[str]]:
        """
        The hostname of the Desktop.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> pulumi.Output[str]:
        """
        The ID of the Simple Office Site.
        """
        return pulumi.get(self, "office_site_id")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The payment type of the Desktop. Valid values: `PayAsYouGo`, `Subscription`. Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The period of the Desktop.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        The period unit of the Desktop.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter(name="policyGroupId")
    def policy_group_id(self) -> pulumi.Output[str]:
        """
        The policy group id of the Desktop.
        """
        return pulumi.get(self, "policy_group_id")

    @property
    @pulumi.getter(name="rootDiskSizeGib")
    def root_disk_size_gib(self) -> pulumi.Output[Optional[int]]:
        """
        The root disk size gib of the Desktop.
        """
        return pulumi.get(self, "root_disk_size_gib")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="stoppedMode")
    def stopped_mode(self) -> pulumi.Output[str]:
        """
        The stopped mode of the Desktop.
        """
        return pulumi.get(self, "stopped_mode")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userAssignMode")
    def user_assign_mode(self) -> pulumi.Output[str]:
        """
        The user assign mode of the Desktop. Valid values: `ALL`, `PER_USER`. Default to `ALL`.
        """
        return pulumi.get(self, "user_assign_mode")

    @property
    @pulumi.getter(name="userDiskSizeGib")
    def user_disk_size_gib(self) -> pulumi.Output[Optional[int]]:
        """
        The user disk size gib of the Desktop.
        """
        return pulumi.get(self, "user_disk_size_gib")

