# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDesktopsResult',
    'AwaitableGetDesktopsResult',
    'get_desktops',
    'get_desktops_output',
]

@pulumi.output_type
class GetDesktopsResult:
    """
    A collection of values returned by getDesktops.
    """
    def __init__(__self__, desktop_name=None, desktops=None, end_user_ids=None, id=None, ids=None, name_regex=None, names=None, office_site_id=None, output_file=None, policy_group_id=None, status=None):
        if desktop_name and not isinstance(desktop_name, str):
            raise TypeError("Expected argument 'desktop_name' to be a str")
        pulumi.set(__self__, "desktop_name", desktop_name)
        if desktops and not isinstance(desktops, list):
            raise TypeError("Expected argument 'desktops' to be a list")
        pulumi.set(__self__, "desktops", desktops)
        if end_user_ids and not isinstance(end_user_ids, list):
            raise TypeError("Expected argument 'end_user_ids' to be a list")
        pulumi.set(__self__, "end_user_ids", end_user_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if office_site_id and not isinstance(office_site_id, str):
            raise TypeError("Expected argument 'office_site_id' to be a str")
        pulumi.set(__self__, "office_site_id", office_site_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if policy_group_id and not isinstance(policy_group_id, str):
            raise TypeError("Expected argument 'policy_group_id' to be a str")
        pulumi.set(__self__, "policy_group_id", policy_group_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="desktopName")
    def desktop_name(self) -> Optional[str]:
        return pulumi.get(self, "desktop_name")

    @property
    @pulumi.getter
    def desktops(self) -> Sequence['outputs.GetDesktopsDesktopResult']:
        return pulumi.get(self, "desktops")

    @property
    @pulumi.getter(name="endUserIds")
    def end_user_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "end_user_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> Optional[str]:
        return pulumi.get(self, "office_site_id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="policyGroupId")
    def policy_group_id(self) -> Optional[str]:
        return pulumi.get(self, "policy_group_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


class AwaitableGetDesktopsResult(GetDesktopsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDesktopsResult(
            desktop_name=self.desktop_name,
            desktops=self.desktops,
            end_user_ids=self.end_user_ids,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            office_site_id=self.office_site_id,
            output_file=self.output_file,
            policy_group_id=self.policy_group_id,
            status=self.status)


def get_desktops(desktop_name: Optional[str] = None,
                 end_user_ids: Optional[Sequence[str]] = None,
                 ids: Optional[Sequence[str]] = None,
                 name_regex: Optional[str] = None,
                 office_site_id: Optional[str] = None,
                 output_file: Optional[str] = None,
                 policy_group_id: Optional[str] = None,
                 status: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDesktopsResult:
    """
    This data source provides the Ecd Desktops of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.144.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default_simple_office_site = alicloud.eds.SimpleOfficeSite("defaultSimpleOfficeSite",
        cidr_block="172.16.0.0/12",
        desktop_access_type="Internet",
        office_site_name="your_office_site_name")
    default_bundles = alicloud.eds.get_bundles(bundle_type="SYSTEM")
    default_ecd_policy_group = alicloud.eds.EcdPolicyGroup("defaultEcdPolicyGroup",
        policy_group_name="your_policy_group_name",
        clipboard="readwrite",
        local_drive="read",
        authorize_access_policy_rules=[alicloud.eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs(
            description="example_value",
            cidr_ip="1.2.3.4/24",
        )],
        authorize_security_policy_rules=[alicloud.eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs(
            type="inflow",
            policy="accept",
            description="example_value",
            port_range="80/80",
            ip_protocol="TCP",
            priority="1",
            cidr_ip="0.0.0.0/0",
        )])
    default_user = alicloud.eds.User("defaultUser",
        end_user_id="your_end_user_id",
        email="your_email",
        phone="your_phone",
        password="your_password")
    default_desktop = alicloud.eds.Desktop("defaultDesktop",
        office_site_id=default_simple_office_site.id,
        policy_group_id=default_ecd_policy_group.id,
        bundle_id=default_bundles.bundles[0].id,
        desktop_name="your_desktop_name",
        end_user_ids=[default_user.id])
    ids = alicloud.eds.get_desktops_output(ids=[default_desktop.id])
    pulumi.export("ecdDesktopId1", ids.desktops[0].id)
    name_regex = default_desktop.desktop_name.apply(lambda desktop_name: alicloud.eds.get_desktops_output(name_regex=desktop_name))
    pulumi.export("ecdDesktopId2", name_regex.desktops[0].id)
    ```


    :param str desktop_name: The desktop name of the Desktop.
    :param Sequence[str] end_user_ids: The desktop end user id of the Desktop.
    :param Sequence[str] ids: A list of Desktop IDs.
    :param str name_regex: A regex string to filter results by Desktop name.
    :param str office_site_id: The ID of the Simple Office Site.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str policy_group_id: The policy group id of the Desktop.
    :param str status: The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
    """
    __args__ = dict()
    __args__['desktopName'] = desktop_name
    __args__['endUserIds'] = end_user_ids
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['officeSiteId'] = office_site_id
    __args__['outputFile'] = output_file
    __args__['policyGroupId'] = policy_group_id
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:eds/getDesktops:getDesktops', __args__, opts=opts, typ=GetDesktopsResult).value

    return AwaitableGetDesktopsResult(
        desktop_name=pulumi.get(__ret__, 'desktop_name'),
        desktops=pulumi.get(__ret__, 'desktops'),
        end_user_ids=pulumi.get(__ret__, 'end_user_ids'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        office_site_id=pulumi.get(__ret__, 'office_site_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        policy_group_id=pulumi.get(__ret__, 'policy_group_id'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_desktops)
def get_desktops_output(desktop_name: Optional[pulumi.Input[Optional[str]]] = None,
                        end_user_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                        ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                        name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                        office_site_id: Optional[pulumi.Input[Optional[str]]] = None,
                        output_file: Optional[pulumi.Input[Optional[str]]] = None,
                        policy_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                        status: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDesktopsResult]:
    """
    This data source provides the Ecd Desktops of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.144.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default_simple_office_site = alicloud.eds.SimpleOfficeSite("defaultSimpleOfficeSite",
        cidr_block="172.16.0.0/12",
        desktop_access_type="Internet",
        office_site_name="your_office_site_name")
    default_bundles = alicloud.eds.get_bundles(bundle_type="SYSTEM")
    default_ecd_policy_group = alicloud.eds.EcdPolicyGroup("defaultEcdPolicyGroup",
        policy_group_name="your_policy_group_name",
        clipboard="readwrite",
        local_drive="read",
        authorize_access_policy_rules=[alicloud.eds.EcdPolicyGroupAuthorizeAccessPolicyRuleArgs(
            description="example_value",
            cidr_ip="1.2.3.4/24",
        )],
        authorize_security_policy_rules=[alicloud.eds.EcdPolicyGroupAuthorizeSecurityPolicyRuleArgs(
            type="inflow",
            policy="accept",
            description="example_value",
            port_range="80/80",
            ip_protocol="TCP",
            priority="1",
            cidr_ip="0.0.0.0/0",
        )])
    default_user = alicloud.eds.User("defaultUser",
        end_user_id="your_end_user_id",
        email="your_email",
        phone="your_phone",
        password="your_password")
    default_desktop = alicloud.eds.Desktop("defaultDesktop",
        office_site_id=default_simple_office_site.id,
        policy_group_id=default_ecd_policy_group.id,
        bundle_id=default_bundles.bundles[0].id,
        desktop_name="your_desktop_name",
        end_user_ids=[default_user.id])
    ids = alicloud.eds.get_desktops_output(ids=[default_desktop.id])
    pulumi.export("ecdDesktopId1", ids.desktops[0].id)
    name_regex = default_desktop.desktop_name.apply(lambda desktop_name: alicloud.eds.get_desktops_output(name_regex=desktop_name))
    pulumi.export("ecdDesktopId2", name_regex.desktops[0].id)
    ```


    :param str desktop_name: The desktop name of the Desktop.
    :param Sequence[str] end_user_ids: The desktop end user id of the Desktop.
    :param Sequence[str] ids: A list of Desktop IDs.
    :param str name_regex: A regex string to filter results by Desktop name.
    :param str office_site_id: The ID of the Simple Office Site.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str policy_group_id: The policy group id of the Desktop.
    :param str status: The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
    """
    ...
