# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CustomPropertyPropertyValue',
    'EcdPolicyGroupAuthorizeAccessPolicyRule',
    'EcdPolicyGroupAuthorizeSecurityPolicyRule',
    'GetAdConnectorDirectoriesDirectoryResult',
    'GetAdConnectorDirectoriesDirectoryAdConnectorResult',
    'GetAdConnectorOfficeSitesSiteResult',
    'GetAdConnectorOfficeSitesSiteAdConnectorResult',
    'GetAdConnectorOfficeSitesSiteLogResult',
    'GetBundlesBundleResult',
    'GetBundlesBundleDesktopTypeAttributeResult',
    'GetBundlesBundleDiskResult',
    'GetCommandsCommandResult',
    'GetCommandsCommandInvokeDesktopResult',
    'GetCustomPropertiesPropertyResult',
    'GetCustomPropertiesPropertyPropertyValueResult',
    'GetDesktopTypesTypeResult',
    'GetDesktopsDesktopResult',
    'GetImagesImageResult',
    'GetNasFileSystemsSystemResult',
    'GetNetworkPackagesPackageResult',
    'GetPolicyGroupsGroupResult',
    'GetPolicyGroupsGroupAuthorizeAccessPolicyRuleResult',
    'GetPolicyGroupsGroupAuthorizeSecurityPolicyRuleResult',
    'GetRamDirectoriesDirectoryResult',
    'GetRamDirectoriesDirectoryAdConnectorResult',
    'GetRamDirectoriesDirectoryLogResult',
    'GetSimpleOfficeSitesSiteResult',
    'GetSnapshotsSnapshotResult',
    'GetUsersUserResult',
    'GetZonesZoneResult',
]

@pulumi.output_type
class CustomPropertyPropertyValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertyValue":
            suggest = "property_value"
        elif key == "propertyValueId":
            suggest = "property_value_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomPropertyPropertyValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomPropertyPropertyValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomPropertyPropertyValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 property_value: Optional[str] = None,
                 property_value_id: Optional[str] = None):
        """
        :param str property_value: The value of an attribute.
        :param str property_value_id: The value of an attribute id.
        """
        if property_value is not None:
            pulumi.set(__self__, "property_value", property_value)
        if property_value_id is not None:
            pulumi.set(__self__, "property_value_id", property_value_id)

    @property
    @pulumi.getter(name="propertyValue")
    def property_value(self) -> Optional[str]:
        """
        The value of an attribute.
        """
        return pulumi.get(self, "property_value")

    @property
    @pulumi.getter(name="propertyValueId")
    def property_value_id(self) -> Optional[str]:
        """
        The value of an attribute id.
        """
        return pulumi.get(self, "property_value_id")


@pulumi.output_type
class EcdPolicyGroupAuthorizeAccessPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrIp":
            suggest = "cidr_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EcdPolicyGroupAuthorizeAccessPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EcdPolicyGroupAuthorizeAccessPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EcdPolicyGroupAuthorizeAccessPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_ip: Optional[str] = None,
                 description: Optional[str] = None):
        """
        :param str cidr_ip: The cidrip of authorize access rule.
        :param str description: The description of authorize access rule.
        """
        if cidr_ip is not None:
            pulumi.set(__self__, "cidr_ip", cidr_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="cidrIp")
    def cidr_ip(self) -> Optional[str]:
        """
        The cidrip of authorize access rule.
        """
        return pulumi.get(self, "cidr_ip")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of authorize access rule.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class EcdPolicyGroupAuthorizeSecurityPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cidrIp":
            suggest = "cidr_ip"
        elif key == "ipProtocol":
            suggest = "ip_protocol"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EcdPolicyGroupAuthorizeSecurityPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EcdPolicyGroupAuthorizeSecurityPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EcdPolicyGroupAuthorizeSecurityPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidr_ip: Optional[str] = None,
                 description: Optional[str] = None,
                 ip_protocol: Optional[str] = None,
                 policy: Optional[str] = None,
                 port_range: Optional[str] = None,
                 priority: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str cidr_ip: The cidrip of security rules.
        :param str description: The description of security rules.
        :param str ip_protocol: The ip protocol of security rules.
        :param str policy: The policy of security rules.
        :param str port_range: The port range of security rules.
        :param str priority: The priority of security rules.
        :param str type: The type of security rules.
        """
        if cidr_ip is not None:
            pulumi.set(__self__, "cidr_ip", cidr_ip)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_protocol is not None:
            pulumi.set(__self__, "ip_protocol", ip_protocol)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cidrIp")
    def cidr_ip(self) -> Optional[str]:
        """
        The cidrip of security rules.
        """
        return pulumi.get(self, "cidr_ip")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of security rules.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> Optional[str]:
        """
        The ip protocol of security rules.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter
    def policy(self) -> Optional[str]:
        """
        The policy of security rules.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        """
        The port range of security rules.
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def priority(self) -> Optional[str]:
        """
        The priority of security rules.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of security rules.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAdConnectorDirectoriesDirectoryResult(dict):
    def __init__(__self__, *,
                 ad_connector_directory_id: str,
                 ad_connectors: Sequence['outputs.GetAdConnectorDirectoriesDirectoryAdConnectorResult'],
                 create_time: str,
                 custom_security_group_id: str,
                 directory_name: str,
                 directory_type: str,
                 dns_addresses: Sequence[str],
                 dns_user_name: str,
                 domain_name: str,
                 domain_user_name: str,
                 enable_admin_access: bool,
                 id: str,
                 mfa_enabled: bool,
                 status: str,
                 sub_dns_addresses: Sequence[str],
                 sub_domain_name: str,
                 trust_password: str,
                 vpc_id: str,
                 vswitch_ids: Sequence[str]):
        """
        :param str ad_connector_directory_id: The ID of the ad connector directory.
        :param Sequence['GetAdConnectorDirectoriesDirectoryAdConnectorArgs'] ad_connectors: The AD connectors.
        :param str create_time: The CreateTime of resource.
        :param str custom_security_group_id: The ID of the security group.
        :param str directory_name: The name of directory.
        :param str directory_type: The name of the domain.
        :param Sequence[str] dns_addresses: The address of DNSAddress.
        :param str dns_user_name: The username of DNS.
        :param str domain_name: The name of the domain.
        :param str domain_user_name: domain admin user name.
        :param bool enable_admin_access: Whether to grant local administrator rights to users who use cloud desktops.
        :param str id: The ID of the Ad Connector Directory.
        :param bool mfa_enabled: Whether MFA authentication is enabled. After all AD users in this directory log on to the cloud desktop, enter the correct password and then enter the dynamic verification code generated by the MFA device.
        :param str status: The status of directory.
        :param Sequence[str] sub_dns_addresses: The Enterprise already has the DNS address of the AD subdomain.
        :param str sub_domain_name: The Enterprise already has a fully qualified domain name (FQDN) of an AD subdomain, with both a host name and a domain name.
        :param str trust_password: The trust password.
        :param str vpc_id: The ID of the vpc.
        :param Sequence[str] vswitch_ids: List of VSwitch IDs in the directory.
        """
        pulumi.set(__self__, "ad_connector_directory_id", ad_connector_directory_id)
        pulumi.set(__self__, "ad_connectors", ad_connectors)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "custom_security_group_id", custom_security_group_id)
        pulumi.set(__self__, "directory_name", directory_name)
        pulumi.set(__self__, "directory_type", directory_type)
        pulumi.set(__self__, "dns_addresses", dns_addresses)
        pulumi.set(__self__, "dns_user_name", dns_user_name)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "domain_user_name", domain_user_name)
        pulumi.set(__self__, "enable_admin_access", enable_admin_access)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mfa_enabled", mfa_enabled)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "sub_dns_addresses", sub_dns_addresses)
        pulumi.set(__self__, "sub_domain_name", sub_domain_name)
        pulumi.set(__self__, "trust_password", trust_password)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @property
    @pulumi.getter(name="adConnectorDirectoryId")
    def ad_connector_directory_id(self) -> str:
        """
        The ID of the ad connector directory.
        """
        return pulumi.get(self, "ad_connector_directory_id")

    @property
    @pulumi.getter(name="adConnectors")
    def ad_connectors(self) -> Sequence['outputs.GetAdConnectorDirectoriesDirectoryAdConnectorResult']:
        """
        The AD connectors.
        """
        return pulumi.get(self, "ad_connectors")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The CreateTime of resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customSecurityGroupId")
    def custom_security_group_id(self) -> str:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "custom_security_group_id")

    @property
    @pulumi.getter(name="directoryName")
    def directory_name(self) -> str:
        """
        The name of directory.
        """
        return pulumi.get(self, "directory_name")

    @property
    @pulumi.getter(name="directoryType")
    def directory_type(self) -> str:
        """
        The name of the domain.
        """
        return pulumi.get(self, "directory_type")

    @property
    @pulumi.getter(name="dnsAddresses")
    def dns_addresses(self) -> Sequence[str]:
        """
        The address of DNSAddress.
        """
        return pulumi.get(self, "dns_addresses")

    @property
    @pulumi.getter(name="dnsUserName")
    def dns_user_name(self) -> str:
        """
        The username of DNS.
        """
        return pulumi.get(self, "dns_user_name")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="domainUserName")
    def domain_user_name(self) -> str:
        """
        domain admin user name.
        """
        return pulumi.get(self, "domain_user_name")

    @property
    @pulumi.getter(name="enableAdminAccess")
    def enable_admin_access(self) -> bool:
        """
        Whether to grant local administrator rights to users who use cloud desktops.
        """
        return pulumi.get(self, "enable_admin_access")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Ad Connector Directory.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mfaEnabled")
    def mfa_enabled(self) -> bool:
        """
        Whether MFA authentication is enabled. After all AD users in this directory log on to the cloud desktop, enter the correct password and then enter the dynamic verification code generated by the MFA device.
        """
        return pulumi.get(self, "mfa_enabled")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of directory.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subDnsAddresses")
    def sub_dns_addresses(self) -> Sequence[str]:
        """
        The Enterprise already has the DNS address of the AD subdomain.
        """
        return pulumi.get(self, "sub_dns_addresses")

    @property
    @pulumi.getter(name="subDomainName")
    def sub_domain_name(self) -> str:
        """
        The Enterprise already has a fully qualified domain name (FQDN) of an AD subdomain, with both a host name and a domain name.
        """
        return pulumi.get(self, "sub_domain_name")

    @property
    @pulumi.getter(name="trustPassword")
    def trust_password(self) -> str:
        """
        The trust password.
        """
        return pulumi.get(self, "trust_password")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the vpc.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[str]:
        """
        List of VSwitch IDs in the directory.
        """
        return pulumi.get(self, "vswitch_ids")


@pulumi.output_type
class GetAdConnectorDirectoriesDirectoryAdConnectorResult(dict):
    def __init__(__self__, *,
                 ad_connector_address: str,
                 connector_status: str,
                 network_interface_id: str,
                 specification: str,
                 trust_key: str,
                 vswitch_id: str):
        """
        :param str ad_connector_address: The address of AD connector.
        :param str connector_status: The status of connector.
        :param str network_interface_id: The ID of the network interface.
        :param str specification: The AD Connector specifications.
        :param str trust_key: The AD Connector control trust password.
        :param str vswitch_id: The ID of VSwitch.
        """
        pulumi.set(__self__, "ad_connector_address", ad_connector_address)
        pulumi.set(__self__, "connector_status", connector_status)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "specification", specification)
        pulumi.set(__self__, "trust_key", trust_key)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="adConnectorAddress")
    def ad_connector_address(self) -> str:
        """
        The address of AD connector.
        """
        return pulumi.get(self, "ad_connector_address")

    @property
    @pulumi.getter(name="connectorStatus")
    def connector_status(self) -> str:
        """
        The status of connector.
        """
        return pulumi.get(self, "connector_status")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> str:
        """
        The ID of the network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter
    def specification(self) -> str:
        """
        The AD Connector specifications.
        """
        return pulumi.get(self, "specification")

    @property
    @pulumi.getter(name="trustKey")
    def trust_key(self) -> str:
        """
        The AD Connector control trust password.
        """
        return pulumi.get(self, "trust_key")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The ID of VSwitch.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetAdConnectorOfficeSitesSiteResult(dict):
    def __init__(__self__, *,
                 ad_connector_office_site_name: str,
                 ad_connectors: Sequence['outputs.GetAdConnectorOfficeSitesSiteAdConnectorResult'],
                 bandwidth: int,
                 cen_id: str,
                 cidr_block: str,
                 create_time: str,
                 custom_security_group_id: str,
                 desktop_access_type: str,
                 desktop_vpc_endpoint: str,
                 dns_addresses: Sequence[str],
                 dns_user_name: str,
                 domain_name: str,
                 domain_user_name: str,
                 enable_admin_access: bool,
                 enable_cross_desktop_access: bool,
                 enable_internet_access: bool,
                 file_system_ids: Sequence[str],
                 id: str,
                 logs: Sequence['outputs.GetAdConnectorOfficeSitesSiteLogResult'],
                 mfa_enabled: bool,
                 network_package_id: str,
                 office_site_id: str,
                 office_site_type: str,
                 sso_enabled: bool,
                 status: str,
                 sub_domain_dns_addresses: Sequence[str],
                 sub_domain_name: str,
                 trust_password: str,
                 vpc_id: str,
                 vswitch_ids: Sequence[str]):
        """
        :param str ad_connector_office_site_name: The Name of the ad connector office site.
        :param Sequence['GetAdConnectorOfficeSitesSiteAdConnectorArgs'] ad_connectors: AD Connector Collection of Information.
        :param int bandwidth: The Internet Bandwidth Peak. Possible Values: 0~200. If This Field Is Set to 0, Indicates That There Is No Open Internet Access.
        :param str cen_id: Cloud Enterprise Network Instance Id.
        :param str cidr_block: Workspace Corresponds to the Security Office Network of IPv4 Segment.
        :param str create_time: Workspace Creation Time.
        :param str custom_security_group_id: Security Group ID.
        :param str desktop_access_type: The method that is used to connect the client to cloud desktops.
        :param str desktop_vpc_endpoint: The endpoint that is used to connect to cloud desktops over a VPC.
        :param Sequence[str] dns_addresses: Enterprise Ad Corresponding DNS Address.
        :param str dns_user_name: The Easy-to-Use DNS Name.
        :param str domain_name: Enterprise of Ad Domain Name.
        :param str domain_user_name: The Domain Administrator's Username.
        :param bool enable_admin_access: Whether to Use Cloud Desktop User Empowerment of Local Administrator Permissions.
        :param bool enable_cross_desktop_access: Indicates whether the desktop communication feature is enabled for cloud desktops in the same workspace. After the feature is enabled, the cloud desktops in the same workspace can access each other.
        :param bool enable_internet_access: Whether the Open Internet Access Function.
        :param Sequence[str] file_system_ids: NAS File System ID.
        :param str id: The ID of the Ad Connector Office Site.
        :param Sequence['GetAdConnectorOfficeSitesSiteLogArgs'] logs: Registered Log Information.
        :param bool mfa_enabled: Whether to Enable Multi-Factor Authentication MFA.
        :param str network_package_id: The ID of the Internet Access.
        :param str office_site_id: The ID of the Workspace.
        :param str office_site_type: Workspace Account System Type. Possible Values: Simple: Convenient Account. AD_CONNECTOR: Enterprise Ad Account.
        :param bool sso_enabled: Whether to Enable Single Sign-on (SSO) for User-Based SSO.
        :param str status: The workspace status.
        :param Sequence[str] sub_domain_dns_addresses: Sub-Domain DNS Address.
        :param str sub_domain_name: The AD Domain DNS Name.
        :param str trust_password: The AD Trust Password.
        :param str vpc_id: Security Office VPC ID.
        :param Sequence[str] vswitch_ids: The vswitch ids.
        """
        pulumi.set(__self__, "ad_connector_office_site_name", ad_connector_office_site_name)
        pulumi.set(__self__, "ad_connectors", ad_connectors)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "custom_security_group_id", custom_security_group_id)
        pulumi.set(__self__, "desktop_access_type", desktop_access_type)
        pulumi.set(__self__, "desktop_vpc_endpoint", desktop_vpc_endpoint)
        pulumi.set(__self__, "dns_addresses", dns_addresses)
        pulumi.set(__self__, "dns_user_name", dns_user_name)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "domain_user_name", domain_user_name)
        pulumi.set(__self__, "enable_admin_access", enable_admin_access)
        pulumi.set(__self__, "enable_cross_desktop_access", enable_cross_desktop_access)
        pulumi.set(__self__, "enable_internet_access", enable_internet_access)
        pulumi.set(__self__, "file_system_ids", file_system_ids)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "logs", logs)
        pulumi.set(__self__, "mfa_enabled", mfa_enabled)
        pulumi.set(__self__, "network_package_id", network_package_id)
        pulumi.set(__self__, "office_site_id", office_site_id)
        pulumi.set(__self__, "office_site_type", office_site_type)
        pulumi.set(__self__, "sso_enabled", sso_enabled)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "sub_domain_dns_addresses", sub_domain_dns_addresses)
        pulumi.set(__self__, "sub_domain_name", sub_domain_name)
        pulumi.set(__self__, "trust_password", trust_password)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @property
    @pulumi.getter(name="adConnectorOfficeSiteName")
    def ad_connector_office_site_name(self) -> str:
        """
        The Name of the ad connector office site.
        """
        return pulumi.get(self, "ad_connector_office_site_name")

    @property
    @pulumi.getter(name="adConnectors")
    def ad_connectors(self) -> Sequence['outputs.GetAdConnectorOfficeSitesSiteAdConnectorResult']:
        """
        AD Connector Collection of Information.
        """
        return pulumi.get(self, "ad_connectors")

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        The Internet Bandwidth Peak. Possible Values: 0~200. If This Field Is Set to 0, Indicates That There Is No Open Internet Access.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> str:
        """
        Cloud Enterprise Network Instance Id.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> str:
        """
        Workspace Corresponds to the Security Office Network of IPv4 Segment.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Workspace Creation Time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customSecurityGroupId")
    def custom_security_group_id(self) -> str:
        """
        Security Group ID.
        """
        return pulumi.get(self, "custom_security_group_id")

    @property
    @pulumi.getter(name="desktopAccessType")
    def desktop_access_type(self) -> str:
        """
        The method that is used to connect the client to cloud desktops.
        """
        return pulumi.get(self, "desktop_access_type")

    @property
    @pulumi.getter(name="desktopVpcEndpoint")
    def desktop_vpc_endpoint(self) -> str:
        """
        The endpoint that is used to connect to cloud desktops over a VPC.
        """
        return pulumi.get(self, "desktop_vpc_endpoint")

    @property
    @pulumi.getter(name="dnsAddresses")
    def dns_addresses(self) -> Sequence[str]:
        """
        Enterprise Ad Corresponding DNS Address.
        """
        return pulumi.get(self, "dns_addresses")

    @property
    @pulumi.getter(name="dnsUserName")
    def dns_user_name(self) -> str:
        """
        The Easy-to-Use DNS Name.
        """
        return pulumi.get(self, "dns_user_name")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        Enterprise of Ad Domain Name.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="domainUserName")
    def domain_user_name(self) -> str:
        """
        The Domain Administrator's Username.
        """
        return pulumi.get(self, "domain_user_name")

    @property
    @pulumi.getter(name="enableAdminAccess")
    def enable_admin_access(self) -> bool:
        """
        Whether to Use Cloud Desktop User Empowerment of Local Administrator Permissions.
        """
        return pulumi.get(self, "enable_admin_access")

    @property
    @pulumi.getter(name="enableCrossDesktopAccess")
    def enable_cross_desktop_access(self) -> bool:
        """
        Indicates whether the desktop communication feature is enabled for cloud desktops in the same workspace. After the feature is enabled, the cloud desktops in the same workspace can access each other.
        """
        return pulumi.get(self, "enable_cross_desktop_access")

    @property
    @pulumi.getter(name="enableInternetAccess")
    def enable_internet_access(self) -> bool:
        """
        Whether the Open Internet Access Function.
        """
        return pulumi.get(self, "enable_internet_access")

    @property
    @pulumi.getter(name="fileSystemIds")
    def file_system_ids(self) -> Sequence[str]:
        """
        NAS File System ID.
        """
        return pulumi.get(self, "file_system_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Ad Connector Office Site.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def logs(self) -> Sequence['outputs.GetAdConnectorOfficeSitesSiteLogResult']:
        """
        Registered Log Information.
        """
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter(name="mfaEnabled")
    def mfa_enabled(self) -> bool:
        """
        Whether to Enable Multi-Factor Authentication MFA.
        """
        return pulumi.get(self, "mfa_enabled")

    @property
    @pulumi.getter(name="networkPackageId")
    def network_package_id(self) -> str:
        """
        The ID of the Internet Access.
        """
        return pulumi.get(self, "network_package_id")

    @property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> str:
        """
        The ID of the Workspace.
        """
        return pulumi.get(self, "office_site_id")

    @property
    @pulumi.getter(name="officeSiteType")
    def office_site_type(self) -> str:
        """
        Workspace Account System Type. Possible Values: Simple: Convenient Account. AD_CONNECTOR: Enterprise Ad Account.
        """
        return pulumi.get(self, "office_site_type")

    @property
    @pulumi.getter(name="ssoEnabled")
    def sso_enabled(self) -> bool:
        """
        Whether to Enable Single Sign-on (SSO) for User-Based SSO.
        """
        return pulumi.get(self, "sso_enabled")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The workspace status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subDomainDnsAddresses")
    def sub_domain_dns_addresses(self) -> Sequence[str]:
        """
        Sub-Domain DNS Address.
        """
        return pulumi.get(self, "sub_domain_dns_addresses")

    @property
    @pulumi.getter(name="subDomainName")
    def sub_domain_name(self) -> str:
        """
        The AD Domain DNS Name.
        """
        return pulumi.get(self, "sub_domain_name")

    @property
    @pulumi.getter(name="trustPassword")
    def trust_password(self) -> str:
        """
        The AD Trust Password.
        """
        return pulumi.get(self, "trust_password")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Security Office VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[str]:
        """
        The vswitch ids.
        """
        return pulumi.get(self, "vswitch_ids")


@pulumi.output_type
class GetAdConnectorOfficeSitesSiteAdConnectorResult(dict):
    def __init__(__self__, *,
                 ad_connector_address: str,
                 connector_status: str,
                 network_interface_id: str,
                 vswitch_id: str):
        """
        :param str ad_connector_address: AD Connector across Zones, Its Connection Addresses.
        :param str connector_status: AD Connector of the State. Possible Values: Creating: in the Creation of. Connecting: Connection. Requires the User to Your Own Ad Configured on the Domain to Which. Running: Run. Expired: If You Are out-of-Date. CONNECT_ERROR: Connection Error.
        :param str network_interface_id: AD Connector Mount of the Card ID.
        :param str vswitch_id: AD Connector in the Network Corresponding to the ID of the VSwitch in.
        """
        pulumi.set(__self__, "ad_connector_address", ad_connector_address)
        pulumi.set(__self__, "connector_status", connector_status)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="adConnectorAddress")
    def ad_connector_address(self) -> str:
        """
        AD Connector across Zones, Its Connection Addresses.
        """
        return pulumi.get(self, "ad_connector_address")

    @property
    @pulumi.getter(name="connectorStatus")
    def connector_status(self) -> str:
        """
        AD Connector of the State. Possible Values: Creating: in the Creation of. Connecting: Connection. Requires the User to Your Own Ad Configured on the Domain to Which. Running: Run. Expired: If You Are out-of-Date. CONNECT_ERROR: Connection Error.
        """
        return pulumi.get(self, "connector_status")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> str:
        """
        AD Connector Mount of the Card ID.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        AD Connector in the Network Corresponding to the ID of the VSwitch in.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetAdConnectorOfficeSitesSiteLogResult(dict):
    def __init__(__self__, *,
                 level: str,
                 message: str,
                 step: str,
                 time_stamp: str):
        """
        :param str level: Log Level. Possible Values: Info: Information Error: Error Warn: Warning.
        :param str message: The Log Details.
        :param str step: Log Information Corresponding to the Step.
        :param str time_stamp: Log Print Time.
        """
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "step", step)
        pulumi.set(__self__, "time_stamp", time_stamp)

    @property
    @pulumi.getter
    def level(self) -> str:
        """
        Log Level. Possible Values: Info: Information Error: Error Warn: Warning.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The Log Details.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def step(self) -> str:
        """
        Log Information Corresponding to the Step.
        """
        return pulumi.get(self, "step")

    @property
    @pulumi.getter(name="timeStamp")
    def time_stamp(self) -> str:
        """
        Log Print Time.
        """
        return pulumi.get(self, "time_stamp")


@pulumi.output_type
class GetBundlesBundleResult(dict):
    def __init__(__self__, *,
                 bundle_id: str,
                 bundle_name: str,
                 bundle_type: str,
                 description: str,
                 desktop_type: str,
                 desktop_type_attributes: Sequence['outputs.GetBundlesBundleDesktopTypeAttributeResult'],
                 disks: Sequence['outputs.GetBundlesBundleDiskResult'],
                 id: str,
                 image_id: str,
                 os_type: str):
        """
        :param str bundle_id: The bundle id of the bundle.
        :param str bundle_name: The name of the bundle.
        :param str bundle_type: The bundle type of  the bundle. Valid values: `SYSTEM`,`CUSTOM`.
        :param str description: The description of the bundle.
        :param str desktop_type: The desktop type of the bundle.
        :param Sequence['GetBundlesBundleDesktopTypeAttributeArgs'] desktop_type_attributes: The desktop type attribute of the bundle.
        :param Sequence['GetBundlesBundleDiskArgs'] disks: The disks of the bundle.
        :param str id: The ID of the bundle.
        :param str image_id: The image id attribute of the bundle.
        :param str os_type: The os type attribute of the bundle.
        """
        pulumi.set(__self__, "bundle_id", bundle_id)
        pulumi.set(__self__, "bundle_name", bundle_name)
        pulumi.set(__self__, "bundle_type", bundle_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "desktop_type", desktop_type)
        pulumi.set(__self__, "desktop_type_attributes", desktop_type_attributes)
        pulumi.set(__self__, "disks", disks)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "os_type", os_type)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> str:
        """
        The bundle id of the bundle.
        """
        return pulumi.get(self, "bundle_id")

    @property
    @pulumi.getter(name="bundleName")
    def bundle_name(self) -> str:
        """
        The name of the bundle.
        """
        return pulumi.get(self, "bundle_name")

    @property
    @pulumi.getter(name="bundleType")
    def bundle_type(self) -> str:
        """
        The bundle type of  the bundle. Valid values: `SYSTEM`,`CUSTOM`.
        """
        return pulumi.get(self, "bundle_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the bundle.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="desktopType")
    def desktop_type(self) -> str:
        """
        The desktop type of the bundle.
        """
        return pulumi.get(self, "desktop_type")

    @property
    @pulumi.getter(name="desktopTypeAttributes")
    def desktop_type_attributes(self) -> Sequence['outputs.GetBundlesBundleDesktopTypeAttributeResult']:
        """
        The desktop type attribute of the bundle.
        """
        return pulumi.get(self, "desktop_type_attributes")

    @property
    @pulumi.getter
    def disks(self) -> Sequence['outputs.GetBundlesBundleDiskResult']:
        """
        The disks of the bundle.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the bundle.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The image id attribute of the bundle.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The os type attribute of the bundle.
        """
        return pulumi.get(self, "os_type")


@pulumi.output_type
class GetBundlesBundleDesktopTypeAttributeResult(dict):
    def __init__(__self__, *,
                 cpu_count: int,
                 gpu_count: str,
                 gpu_spec: str,
                 memory_size: str):
        """
        :param int cpu_count: The cpu count attribute of the bundle.
        :param str gpu_count: The gpu count attribute of the bundle.
        :param str gpu_spec: The gpu spec attribute of the bundle.
        :param str memory_size: The memory size attribute of the bundle.
        """
        pulumi.set(__self__, "cpu_count", cpu_count)
        pulumi.set(__self__, "gpu_count", gpu_count)
        pulumi.set(__self__, "gpu_spec", gpu_spec)
        pulumi.set(__self__, "memory_size", memory_size)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> int:
        """
        The cpu count attribute of the bundle.
        """
        return pulumi.get(self, "cpu_count")

    @property
    @pulumi.getter(name="gpuCount")
    def gpu_count(self) -> str:
        """
        The gpu count attribute of the bundle.
        """
        return pulumi.get(self, "gpu_count")

    @property
    @pulumi.getter(name="gpuSpec")
    def gpu_spec(self) -> str:
        """
        The gpu spec attribute of the bundle.
        """
        return pulumi.get(self, "gpu_spec")

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> str:
        """
        The memory size attribute of the bundle.
        """
        return pulumi.get(self, "memory_size")


@pulumi.output_type
class GetBundlesBundleDiskResult(dict):
    def __init__(__self__, *,
                 disk_size: str,
                 disk_type: str):
        """
        :param str disk_size: The disk size attribute of the bundle.
        :param str disk_type: The disk type attribute of the bundle.
        """
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "disk_type", disk_type)

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> str:
        """
        The disk size attribute of the bundle.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        The disk type attribute of the bundle.
        """
        return pulumi.get(self, "disk_type")


@pulumi.output_type
class GetCommandsCommandResult(dict):
    def __init__(__self__, *,
                 command_content: str,
                 command_type: str,
                 create_time: str,
                 id: str,
                 invoke_desktops: Sequence['outputs.GetCommandsCommandInvokeDesktopResult'],
                 invoke_id: str,
                 status: str):
        """
        :param str command_content: The Contents of the Script to Base64 Encoded Transmission.
        :param str command_type: The Script Type. Valid values: `RunBatScript`, `RunPowerShellScript`.
        :param str create_time: The Task of Creation Time.
        :param str id: The ID of the Command.
        :param Sequence['GetCommandsCommandInvokeDesktopArgs'] invoke_desktops: The Implementation of the Target Cloud Desktop Collection.
        :param str invoke_id: The invoke id of the Command.
        :param str status: Script Is Executed in the Overall Implementation of the State. Valid values: `Pending`, `Failed`, `PartialFailed`, `Running`, `Stopped`, `Stopping`, `Finished`, `Success`.
        """
        pulumi.set(__self__, "command_content", command_content)
        pulumi.set(__self__, "command_type", command_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "invoke_desktops", invoke_desktops)
        pulumi.set(__self__, "invoke_id", invoke_id)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="commandContent")
    def command_content(self) -> str:
        """
        The Contents of the Script to Base64 Encoded Transmission.
        """
        return pulumi.get(self, "command_content")

    @property
    @pulumi.getter(name="commandType")
    def command_type(self) -> str:
        """
        The Script Type. Valid values: `RunBatScript`, `RunPowerShellScript`.
        """
        return pulumi.get(self, "command_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The Task of Creation Time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Command.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="invokeDesktops")
    def invoke_desktops(self) -> Sequence['outputs.GetCommandsCommandInvokeDesktopResult']:
        """
        The Implementation of the Target Cloud Desktop Collection.
        """
        return pulumi.get(self, "invoke_desktops")

    @property
    @pulumi.getter(name="invokeId")
    def invoke_id(self) -> str:
        """
        The invoke id of the Command.
        """
        return pulumi.get(self, "invoke_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Script Is Executed in the Overall Implementation of the State. Valid values: `Pending`, `Failed`, `PartialFailed`, `Running`, `Stopped`, `Stopping`, `Finished`, `Success`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetCommandsCommandInvokeDesktopResult(dict):
    def __init__(__self__, *,
                 desktop_id: str,
                 dropped: int,
                 error_code: str,
                 error_info: str,
                 exit_code: str,
                 finish_time: str,
                 invocation_status: str,
                 output: str,
                 repeats: int,
                 start_time: str,
                 stop_time: str):
        """
        :param str desktop_id: The desktop id of the Desktop.
        :param int dropped: Output Field Text Length Exceeds 24 KB of Truncated Discarded Text Length.
        :param str error_code: Command of the Failure Or Perform the Reason for the Failure of the Code.
        :param str error_info: Command of the Failure Or Perform the Reason for the Failure of the Details.
        :param str exit_code: Command of the Failure Or Perform the Reason for the Failure of the Details.
        :param str finish_time: The Script Process until the End of Time.
        :param str invocation_status: A Single Cloud Desktop Script Progress Status.
        :param str output: Script the Output of the Process.
        :param int repeats: Command in the Desktop Implementation.
        :param str start_time: The Script Process on the Desktop, in the Start Timing of the Execution.
        :param str stop_time: If You Use the invocation Indicates That the Call of the Time.
        """
        pulumi.set(__self__, "desktop_id", desktop_id)
        pulumi.set(__self__, "dropped", dropped)
        pulumi.set(__self__, "error_code", error_code)
        pulumi.set(__self__, "error_info", error_info)
        pulumi.set(__self__, "exit_code", exit_code)
        pulumi.set(__self__, "finish_time", finish_time)
        pulumi.set(__self__, "invocation_status", invocation_status)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "repeats", repeats)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "stop_time", stop_time)

    @property
    @pulumi.getter(name="desktopId")
    def desktop_id(self) -> str:
        """
        The desktop id of the Desktop.
        """
        return pulumi.get(self, "desktop_id")

    @property
    @pulumi.getter
    def dropped(self) -> int:
        """
        Output Field Text Length Exceeds 24 KB of Truncated Discarded Text Length.
        """
        return pulumi.get(self, "dropped")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> str:
        """
        Command of the Failure Or Perform the Reason for the Failure of the Code.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorInfo")
    def error_info(self) -> str:
        """
        Command of the Failure Or Perform the Reason for the Failure of the Details.
        """
        return pulumi.get(self, "error_info")

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> str:
        """
        Command of the Failure Or Perform the Reason for the Failure of the Details.
        """
        return pulumi.get(self, "exit_code")

    @property
    @pulumi.getter(name="finishTime")
    def finish_time(self) -> str:
        """
        The Script Process until the End of Time.
        """
        return pulumi.get(self, "finish_time")

    @property
    @pulumi.getter(name="invocationStatus")
    def invocation_status(self) -> str:
        """
        A Single Cloud Desktop Script Progress Status.
        """
        return pulumi.get(self, "invocation_status")

    @property
    @pulumi.getter
    def output(self) -> str:
        """
        Script the Output of the Process.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def repeats(self) -> int:
        """
        Command in the Desktop Implementation.
        """
        return pulumi.get(self, "repeats")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The Script Process on the Desktop, in the Start Timing of the Execution.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="stopTime")
    def stop_time(self) -> str:
        """
        If You Use the invocation Indicates That the Call of the Time.
        """
        return pulumi.get(self, "stop_time")


@pulumi.output_type
class GetCustomPropertiesPropertyResult(dict):
    def __init__(__self__, *,
                 custom_property_id: str,
                 id: str,
                 property_key: str,
                 property_values: Sequence['outputs.GetCustomPropertiesPropertyPropertyValueResult']):
        """
        :param str custom_property_id: The first ID of the resource.
        :param str id: The ID of the Custom Property.
        :param str property_key: The Custom attribute key.
        :param Sequence['GetCustomPropertiesPropertyPropertyValueArgs'] property_values: Custom attribute sets the value of.
        """
        pulumi.set(__self__, "custom_property_id", custom_property_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "property_key", property_key)
        pulumi.set(__self__, "property_values", property_values)

    @property
    @pulumi.getter(name="customPropertyId")
    def custom_property_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "custom_property_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Custom Property.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="propertyKey")
    def property_key(self) -> str:
        """
        The Custom attribute key.
        """
        return pulumi.get(self, "property_key")

    @property
    @pulumi.getter(name="propertyValues")
    def property_values(self) -> Sequence['outputs.GetCustomPropertiesPropertyPropertyValueResult']:
        """
        Custom attribute sets the value of.
        """
        return pulumi.get(self, "property_values")


@pulumi.output_type
class GetCustomPropertiesPropertyPropertyValueResult(dict):
    def __init__(__self__, *,
                 property_value: str,
                 property_value_id: str):
        """
        :param str property_value: The value of an attribute.
        :param str property_value_id: The value of an attribute id.
        """
        pulumi.set(__self__, "property_value", property_value)
        pulumi.set(__self__, "property_value_id", property_value_id)

    @property
    @pulumi.getter(name="propertyValue")
    def property_value(self) -> str:
        """
        The value of an attribute.
        """
        return pulumi.get(self, "property_value")

    @property
    @pulumi.getter(name="propertyValueId")
    def property_value_id(self) -> str:
        """
        The value of an attribute id.
        """
        return pulumi.get(self, "property_value_id")


@pulumi.output_type
class GetDesktopTypesTypeResult(dict):
    def __init__(__self__, *,
                 cpu_count: str,
                 data_disk_size: str,
                 desktop_type_id: str,
                 gpu_count: float,
                 gpu_spec: str,
                 id: str,
                 instance_type_family: str,
                 memory_size: str,
                 status: str,
                 system_disk_size: str):
        """
        :param str cpu_count: The CPU cores.
        :param str data_disk_size: The size of the data disk. Unit: GiB.
        :param str desktop_type_id: Specification ID.
        :param float gpu_count: The GPU cores.
        :param str gpu_spec: The GPU video memory.
        :param str id: The ID of the Desktop Type.
        :param str instance_type_family: The Specification family.
        :param str memory_size: The Memory size. Unit: MiB.
        :param str status: The status of the resource.
        :param str system_disk_size: The size of the system disk. Unit: GiB.
        """
        pulumi.set(__self__, "cpu_count", cpu_count)
        pulumi.set(__self__, "data_disk_size", data_disk_size)
        pulumi.set(__self__, "desktop_type_id", desktop_type_id)
        pulumi.set(__self__, "gpu_count", gpu_count)
        pulumi.set(__self__, "gpu_spec", gpu_spec)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_type_family", instance_type_family)
        pulumi.set(__self__, "memory_size", memory_size)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "system_disk_size", system_disk_size)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> str:
        """
        The CPU cores.
        """
        return pulumi.get(self, "cpu_count")

    @property
    @pulumi.getter(name="dataDiskSize")
    def data_disk_size(self) -> str:
        """
        The size of the data disk. Unit: GiB.
        """
        return pulumi.get(self, "data_disk_size")

    @property
    @pulumi.getter(name="desktopTypeId")
    def desktop_type_id(self) -> str:
        """
        Specification ID.
        """
        return pulumi.get(self, "desktop_type_id")

    @property
    @pulumi.getter(name="gpuCount")
    def gpu_count(self) -> float:
        """
        The GPU cores.
        """
        return pulumi.get(self, "gpu_count")

    @property
    @pulumi.getter(name="gpuSpec")
    def gpu_spec(self) -> str:
        """
        The GPU video memory.
        """
        return pulumi.get(self, "gpu_spec")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Desktop Type.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceTypeFamily")
    def instance_type_family(self) -> str:
        """
        The Specification family.
        """
        return pulumi.get(self, "instance_type_family")

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> str:
        """
        The Memory size. Unit: MiB.
        """
        return pulumi.get(self, "memory_size")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> str:
        """
        The size of the system disk. Unit: GiB.
        """
        return pulumi.get(self, "system_disk_size")


@pulumi.output_type
class GetDesktopsDesktopResult(dict):
    def __init__(__self__, *,
                 cpu: int,
                 create_time: str,
                 desktop_id: str,
                 desktop_name: str,
                 desktop_type: str,
                 directory_id: str,
                 end_user_ids: Sequence[str],
                 expired_time: str,
                 id: str,
                 image_id: str,
                 memory: str,
                 network_interface_id: str,
                 payment_type: str,
                 policy_group_id: str,
                 status: str,
                 system_disk_size: int):
        """
        :param int cpu: The number of CPUs.
        :param str create_time: The creation time of the Desktop.
        :param str desktop_id: The desktop id of the Desktop.
        :param str desktop_name: The desktop name of the Desktop.
        :param str desktop_type: The desktop type of the Desktop.
        :param str directory_id: The directory id of the Desktop.
        :param Sequence[str] end_user_ids: The desktop end user id of the Desktop.
        :param str expired_time: The expired time of the Desktop.
        :param str id: The ID of the Desktop.
        :param str image_id: The image id of the Desktop.
        :param str memory: The memory of the Desktop.
        :param str network_interface_id: The network interface id of the Desktop.
        :param str payment_type: The payment type of the Desktop.
        :param str policy_group_id: The policy group id of the Desktop.
        :param str status: The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
        :param int system_disk_size: The system disk size of the Desktop.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "desktop_id", desktop_id)
        pulumi.set(__self__, "desktop_name", desktop_name)
        pulumi.set(__self__, "desktop_type", desktop_type)
        pulumi.set(__self__, "directory_id", directory_id)
        pulumi.set(__self__, "end_user_ids", end_user_ids)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "policy_group_id", policy_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "system_disk_size", system_disk_size)

    @property
    @pulumi.getter
    def cpu(self) -> int:
        """
        The number of CPUs.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the Desktop.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="desktopId")
    def desktop_id(self) -> str:
        """
        The desktop id of the Desktop.
        """
        return pulumi.get(self, "desktop_id")

    @property
    @pulumi.getter(name="desktopName")
    def desktop_name(self) -> str:
        """
        The desktop name of the Desktop.
        """
        return pulumi.get(self, "desktop_name")

    @property
    @pulumi.getter(name="desktopType")
    def desktop_type(self) -> str:
        """
        The desktop type of the Desktop.
        """
        return pulumi.get(self, "desktop_type")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> str:
        """
        The directory id of the Desktop.
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter(name="endUserIds")
    def end_user_ids(self) -> Sequence[str]:
        """
        The desktop end user id of the Desktop.
        """
        return pulumi.get(self, "end_user_ids")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        """
        The expired time of the Desktop.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Desktop.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The image id of the Desktop.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter
    def memory(self) -> str:
        """
        The memory of the Desktop.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> str:
        """
        The network interface id of the Desktop.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The payment type of the Desktop.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="policyGroupId")
    def policy_group_id(self) -> str:
        """
        The policy group id of the Desktop.
        """
        return pulumi.get(self, "policy_group_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the Desktop. Valid values: `Deleted`, `Expired`, `Pending`, `Running`, `Starting`, `Stopped`, `Stopping`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> int:
        """
        The system disk size of the Desktop.
        """
        return pulumi.get(self, "system_disk_size")


@pulumi.output_type
class GetImagesImageResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 data_disk_size: int,
                 description: str,
                 gpu_category: bool,
                 id: str,
                 image_id: str,
                 image_name: str,
                 image_type: str,
                 os_type: str,
                 progress: str,
                 size: int,
                 status: str):
        """
        :param str create_time: The creation time of the image.
        :param int data_disk_size: The size of data disk of the image.
        :param str description: The description of the image.
        :param bool gpu_category: The Gpu Category of the image.
        :param str id: The ID of the Image.
        :param str image_id: The image id of the image.
        :param str image_name: The image name.
        :param str image_type: The image type of the image. Valid values: `SYSTEM`, `CUSTOM`.
        :param str os_type: The os type of the image.
        :param str progress: The progress of the image.
        :param int size: The size of the image.
        :param str status: The status of the image. Valid values: `Creating`, `Available`, `CreateFailed`.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "data_disk_size", data_disk_size)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "gpu_category", gpu_category)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_name", image_name)
        pulumi.set(__self__, "image_type", image_type)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the image.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataDiskSize")
    def data_disk_size(self) -> int:
        """
        The size of data disk of the image.
        """
        return pulumi.get(self, "data_disk_size")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the image.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="gpuCategory")
    def gpu_category(self) -> bool:
        """
        The Gpu Category of the image.
        """
        return pulumi.get(self, "gpu_category")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Image.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The image id of the image.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The image name.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> str:
        """
        The image type of the image. Valid values: `SYSTEM`, `CUSTOM`.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="osType")
    def os_type(self) -> str:
        """
        The os type of the image.
        """
        return pulumi.get(self, "os_type")

    @property
    @pulumi.getter
    def progress(self) -> str:
        """
        The progress of the image.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of the image.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the image. Valid values: `Creating`, `Available`, `CreateFailed`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNasFileSystemsSystemResult(dict):
    def __init__(__self__, *,
                 capacity: str,
                 create_time: str,
                 description: str,
                 file_system_id: str,
                 file_system_type: str,
                 id: str,
                 metered_size: str,
                 mount_target_domain: str,
                 mount_target_status: str,
                 nas_file_system_name: str,
                 office_site_id: str,
                 office_site_name: str,
                 status: str,
                 storage_type: str,
                 support_acl: bool,
                 zone_id: str):
        """
        :param str capacity: The capacity of nas file system.
        :param str create_time: The create time of nas file system.
        :param str description: The description of nas file system.
        :param str file_system_id: The filesystem id of nas file system.
        :param str file_system_type: The type of nas file system.
        :param str id: The ID of the Nas File System.
        :param str metered_size: The size of metered.
        :param str mount_target_domain: The domain of mount target.
        :param str mount_target_status: The status of mount target. Valid values: `Pending`, `Active`, `Inactive`,`Deleting`,`Invalid`.
        :param str nas_file_system_name: The name of nas file system.
        :param str office_site_id: The ID of office site.
        :param str office_site_name: The name of office site.
        :param str status: The status of nas file system. Valid values: `Pending`, `Running`, `Stopped`,`Deleting`, `Deleted`, `Invalid`.
        :param str storage_type: The storage type of nas file system.
        :param bool support_acl: Whether to support Acl.
        :param str zone_id: The zone id of nas file system.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "file_system_id", file_system_id)
        pulumi.set(__self__, "file_system_type", file_system_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metered_size", metered_size)
        pulumi.set(__self__, "mount_target_domain", mount_target_domain)
        pulumi.set(__self__, "mount_target_status", mount_target_status)
        pulumi.set(__self__, "nas_file_system_name", nas_file_system_name)
        pulumi.set(__self__, "office_site_id", office_site_id)
        pulumi.set(__self__, "office_site_name", office_site_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "support_acl", support_acl)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def capacity(self) -> str:
        """
        The capacity of nas file system.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The create time of nas file system.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of nas file system.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fileSystemId")
    def file_system_id(self) -> str:
        """
        The filesystem id of nas file system.
        """
        return pulumi.get(self, "file_system_id")

    @property
    @pulumi.getter(name="fileSystemType")
    def file_system_type(self) -> str:
        """
        The type of nas file system.
        """
        return pulumi.get(self, "file_system_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Nas File System.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="meteredSize")
    def metered_size(self) -> str:
        """
        The size of metered.
        """
        return pulumi.get(self, "metered_size")

    @property
    @pulumi.getter(name="mountTargetDomain")
    def mount_target_domain(self) -> str:
        """
        The domain of mount target.
        """
        return pulumi.get(self, "mount_target_domain")

    @property
    @pulumi.getter(name="mountTargetStatus")
    def mount_target_status(self) -> str:
        """
        The status of mount target. Valid values: `Pending`, `Active`, `Inactive`,`Deleting`,`Invalid`.
        """
        return pulumi.get(self, "mount_target_status")

    @property
    @pulumi.getter(name="nasFileSystemName")
    def nas_file_system_name(self) -> str:
        """
        The name of nas file system.
        """
        return pulumi.get(self, "nas_file_system_name")

    @property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> str:
        """
        The ID of office site.
        """
        return pulumi.get(self, "office_site_id")

    @property
    @pulumi.getter(name="officeSiteName")
    def office_site_name(self) -> str:
        """
        The name of office site.
        """
        return pulumi.get(self, "office_site_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of nas file system. Valid values: `Pending`, `Running`, `Stopped`,`Deleting`, `Deleted`, `Invalid`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        The storage type of nas file system.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="supportAcl")
    def support_acl(self) -> bool:
        """
        Whether to support Acl.
        """
        return pulumi.get(self, "support_acl")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The zone id of nas file system.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetNetworkPackagesPackageResult(dict):
    def __init__(__self__, *,
                 bandwidth: int,
                 create_time: str,
                 eip_addresses: Sequence[str],
                 expired_time: str,
                 id: str,
                 internet_charge_type: str,
                 network_package_id: str,
                 office_site_id: str,
                 office_site_name: str,
                 status: str):
        """
        :param int bandwidth: The bandwidth of package.
        :param str create_time: The creation time of network package.
        :param Sequence[str] eip_addresses: The public IP address list of the network packet.
        :param str expired_time: The expired time of package.
        :param str id: The ID of the Network Package.
        :param str internet_charge_type: The internet charge type  of  package.
        :param str network_package_id: The ID of network package.
        :param str office_site_id: The ID of office site.
        :param str office_site_name: The name of office site.
        :param str status: The status of network package. Valid values: `Creating`, `InUse`, `Releasing`,`Released`.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "eip_addresses", eip_addresses)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "network_package_id", network_package_id)
        pulumi.set(__self__, "office_site_id", office_site_id)
        pulumi.set(__self__, "office_site_name", office_site_name)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        The bandwidth of package.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of network package.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="eipAddresses")
    def eip_addresses(self) -> Sequence[str]:
        """
        The public IP address list of the network packet.
        """
        return pulumi.get(self, "eip_addresses")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        """
        The expired time of package.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Network Package.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> str:
        """
        The internet charge type  of  package.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="networkPackageId")
    def network_package_id(self) -> str:
        """
        The ID of network package.
        """
        return pulumi.get(self, "network_package_id")

    @property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> str:
        """
        The ID of office site.
        """
        return pulumi.get(self, "office_site_id")

    @property
    @pulumi.getter(name="officeSiteName")
    def office_site_name(self) -> str:
        """
        The name of office site.
        """
        return pulumi.get(self, "office_site_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of network package. Valid values: `Creating`, `InUse`, `Releasing`,`Released`.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetPolicyGroupsGroupResult(dict):
    def __init__(__self__, *,
                 authorize_access_policy_rules: Sequence['outputs.GetPolicyGroupsGroupAuthorizeAccessPolicyRuleResult'],
                 authorize_security_policy_rules: Sequence['outputs.GetPolicyGroupsGroupAuthorizeSecurityPolicyRuleResult'],
                 camera_redirect: str,
                 clipboard: str,
                 domain_list: str,
                 eds_count: int,
                 html_access: str,
                 html_file_transfer: str,
                 id: str,
                 local_drive: str,
                 policy_group_id: str,
                 policy_group_name: str,
                 policy_group_type: str,
                 recording: str,
                 recording_end_time: str,
                 recording_fps: int,
                 recording_start_time: str,
                 status: str,
                 usb_redirect: str,
                 visual_quality: str,
                 watermark: str,
                 watermark_transparency: str,
                 watermark_type: str):
        """
        :param Sequence['GetPolicyGroupsGroupAuthorizeAccessPolicyRuleArgs'] authorize_access_policy_rules: The rule of authorize access rule.
        :param Sequence['GetPolicyGroupsGroupAuthorizeSecurityPolicyRuleArgs'] authorize_security_policy_rules: The policy rule.
        :param str camera_redirect: Whether to enable local camera redirection. Valid values: `on`, `off`.
        :param str clipboard: The clipboard policy.
        :param str domain_list: The list of domain.
        :param int eds_count: The count of eds.
        :param str html_access: The access of html5.
        :param str html_file_transfer: The html5 file transfer.
        :param str id: The ID of the Policy Group.
        :param str local_drive: Local drive redirect policy.
        :param str policy_group_id: The policy group id.
        :param str policy_group_name: The name of policy group.
        :param str policy_group_type: The type of policy group.
        :param str recording: Whether to enable screen recording. Valid values: `off`, `alltime`, `period`.
        :param str recording_end_time: The end time of recording.
        :param int recording_fps: The fps of recording. Valid values: `2`, `5`, `10`, `15`.
        :param str recording_start_time: The start time of recording.
        :param str status: The status of policy.
        :param str usb_redirect: The usb redirect policy.
        :param str visual_quality: The quality of visual.sae_ecdsae_nameecd_po
        :param str watermark: The watermark policy.
        :param str watermark_transparency: The watermark transparency.
        :param str watermark_type: The type of watemark.
        """
        pulumi.set(__self__, "authorize_access_policy_rules", authorize_access_policy_rules)
        pulumi.set(__self__, "authorize_security_policy_rules", authorize_security_policy_rules)
        pulumi.set(__self__, "camera_redirect", camera_redirect)
        pulumi.set(__self__, "clipboard", clipboard)
        pulumi.set(__self__, "domain_list", domain_list)
        pulumi.set(__self__, "eds_count", eds_count)
        pulumi.set(__self__, "html_access", html_access)
        pulumi.set(__self__, "html_file_transfer", html_file_transfer)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "local_drive", local_drive)
        pulumi.set(__self__, "policy_group_id", policy_group_id)
        pulumi.set(__self__, "policy_group_name", policy_group_name)
        pulumi.set(__self__, "policy_group_type", policy_group_type)
        pulumi.set(__self__, "recording", recording)
        pulumi.set(__self__, "recording_end_time", recording_end_time)
        pulumi.set(__self__, "recording_fps", recording_fps)
        pulumi.set(__self__, "recording_start_time", recording_start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "usb_redirect", usb_redirect)
        pulumi.set(__self__, "visual_quality", visual_quality)
        pulumi.set(__self__, "watermark", watermark)
        pulumi.set(__self__, "watermark_transparency", watermark_transparency)
        pulumi.set(__self__, "watermark_type", watermark_type)

    @property
    @pulumi.getter(name="authorizeAccessPolicyRules")
    def authorize_access_policy_rules(self) -> Sequence['outputs.GetPolicyGroupsGroupAuthorizeAccessPolicyRuleResult']:
        """
        The rule of authorize access rule.
        """
        return pulumi.get(self, "authorize_access_policy_rules")

    @property
    @pulumi.getter(name="authorizeSecurityPolicyRules")
    def authorize_security_policy_rules(self) -> Sequence['outputs.GetPolicyGroupsGroupAuthorizeSecurityPolicyRuleResult']:
        """
        The policy rule.
        """
        return pulumi.get(self, "authorize_security_policy_rules")

    @property
    @pulumi.getter(name="cameraRedirect")
    def camera_redirect(self) -> str:
        """
        Whether to enable local camera redirection. Valid values: `on`, `off`.
        """
        return pulumi.get(self, "camera_redirect")

    @property
    @pulumi.getter
    def clipboard(self) -> str:
        """
        The clipboard policy.
        """
        return pulumi.get(self, "clipboard")

    @property
    @pulumi.getter(name="domainList")
    def domain_list(self) -> str:
        """
        The list of domain.
        """
        return pulumi.get(self, "domain_list")

    @property
    @pulumi.getter(name="edsCount")
    def eds_count(self) -> int:
        """
        The count of eds.
        """
        return pulumi.get(self, "eds_count")

    @property
    @pulumi.getter(name="htmlAccess")
    def html_access(self) -> str:
        """
        The access of html5.
        """
        return pulumi.get(self, "html_access")

    @property
    @pulumi.getter(name="htmlFileTransfer")
    def html_file_transfer(self) -> str:
        """
        The html5 file transfer.
        """
        return pulumi.get(self, "html_file_transfer")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Policy Group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localDrive")
    def local_drive(self) -> str:
        """
        Local drive redirect policy.
        """
        return pulumi.get(self, "local_drive")

    @property
    @pulumi.getter(name="policyGroupId")
    def policy_group_id(self) -> str:
        """
        The policy group id.
        """
        return pulumi.get(self, "policy_group_id")

    @property
    @pulumi.getter(name="policyGroupName")
    def policy_group_name(self) -> str:
        """
        The name of policy group.
        """
        return pulumi.get(self, "policy_group_name")

    @property
    @pulumi.getter(name="policyGroupType")
    def policy_group_type(self) -> str:
        """
        The type of policy group.
        """
        return pulumi.get(self, "policy_group_type")

    @property
    @pulumi.getter
    def recording(self) -> str:
        """
        Whether to enable screen recording. Valid values: `off`, `alltime`, `period`.
        """
        return pulumi.get(self, "recording")

    @property
    @pulumi.getter(name="recordingEndTime")
    def recording_end_time(self) -> str:
        """
        The end time of recording.
        """
        return pulumi.get(self, "recording_end_time")

    @property
    @pulumi.getter(name="recordingFps")
    def recording_fps(self) -> int:
        """
        The fps of recording. Valid values: `2`, `5`, `10`, `15`.
        """
        return pulumi.get(self, "recording_fps")

    @property
    @pulumi.getter(name="recordingStartTime")
    def recording_start_time(self) -> str:
        """
        The start time of recording.
        """
        return pulumi.get(self, "recording_start_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of policy.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="usbRedirect")
    def usb_redirect(self) -> str:
        """
        The usb redirect policy.
        """
        return pulumi.get(self, "usb_redirect")

    @property
    @pulumi.getter(name="visualQuality")
    def visual_quality(self) -> str:
        """
        The quality of visual.sae_ecdsae_nameecd_po
        """
        return pulumi.get(self, "visual_quality")

    @property
    @pulumi.getter
    def watermark(self) -> str:
        """
        The watermark policy.
        """
        return pulumi.get(self, "watermark")

    @property
    @pulumi.getter(name="watermarkTransparency")
    def watermark_transparency(self) -> str:
        """
        The watermark transparency.
        """
        return pulumi.get(self, "watermark_transparency")

    @property
    @pulumi.getter(name="watermarkType")
    def watermark_type(self) -> str:
        """
        The type of watemark.
        """
        return pulumi.get(self, "watermark_type")


@pulumi.output_type
class GetPolicyGroupsGroupAuthorizeAccessPolicyRuleResult(dict):
    def __init__(__self__, *,
                 cidr_ip: str,
                 description: str):
        """
        :param str cidr_ip: The cidrip of security rules.
        :param str description: The description of security rules.
        """
        pulumi.set(__self__, "cidr_ip", cidr_ip)
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="cidrIp")
    def cidr_ip(self) -> str:
        """
        The cidrip of security rules.
        """
        return pulumi.get(self, "cidr_ip")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of security rules.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class GetPolicyGroupsGroupAuthorizeSecurityPolicyRuleResult(dict):
    def __init__(__self__, *,
                 cidr_ip: str,
                 description: str,
                 ip_protocol: str,
                 policy: str,
                 port_range: str,
                 priority: str,
                 type: str):
        """
        :param str cidr_ip: The cidrip of security rules.
        :param str description: The description of security rules.
        :param str ip_protocol: The ip protocol of security rules.
        :param str policy: The policy of security rules.
        :param str port_range: The port range of security rules.
        :param str priority: The priority of security rules.
        :param str type: The type of security rules.
        """
        pulumi.set(__self__, "cidr_ip", cidr_ip)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "ip_protocol", ip_protocol)
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "port_range", port_range)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cidrIp")
    def cidr_ip(self) -> str:
        """
        The cidrip of security rules.
        """
        return pulumi.get(self, "cidr_ip")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of security rules.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ipProtocol")
    def ip_protocol(self) -> str:
        """
        The ip protocol of security rules.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter
    def policy(self) -> str:
        """
        The policy of security rules.
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> str:
        """
        The port range of security rules.
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def priority(self) -> str:
        """
        The priority of security rules.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of security rules.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRamDirectoriesDirectoryResult(dict):
    def __init__(__self__, *,
                 ad_connectors: Sequence['outputs.GetRamDirectoriesDirectoryAdConnectorResult'],
                 create_time: str,
                 custom_security_group_id: str,
                 desktop_access_type: str,
                 desktop_vpc_endpoint: str,
                 directory_type: str,
                 dns_addresses: Sequence[str],
                 dns_user_name: str,
                 domain_name: str,
                 domain_password: str,
                 domain_user_name: str,
                 enable_admin_access: bool,
                 enable_cross_desktop_access: bool,
                 enable_internet_access: bool,
                 file_system_ids: Sequence[str],
                 id: str,
                 logs: Sequence['outputs.GetRamDirectoriesDirectoryLogResult'],
                 mfa_enabled: bool,
                 ram_directory_id: str,
                 ram_directory_name: str,
                 sso_enabled: bool,
                 status: str,
                 sub_dns_addresses: Sequence[str],
                 sub_domain_name: str,
                 trust_password: str,
                 vpc_id: str,
                 vswitch_ids: Sequence[str]):
        """
        :param Sequence['GetRamDirectoriesDirectoryAdConnectorArgs'] ad_connectors: The AD connectors.
        :param str create_time: The CreateTime of resource.
        :param str custom_security_group_id: The id of the custom security group.
        :param str desktop_access_type: The desktop access type.
        :param str desktop_vpc_endpoint: The desktop vpc endpoint.
        :param str directory_type: The directory type.
        :param Sequence[str] dns_addresses: The address of DNSAddress.
        :param str dns_user_name: The username of DNS.
        :param str domain_name: The name of the domain.
        :param str domain_password: The domain password.
        :param str domain_user_name: The username of the domain.
        :param bool enable_admin_access: Whether to enable admin access.
        :param bool enable_cross_desktop_access: Whether to enable cross desktop access.
        :param bool enable_internet_access: Whether enable internet access.
        :param Sequence[str] file_system_ids: The ids of filesystem.
        :param str id: The ID of the Ram Directory.
        :param Sequence['GetRamDirectoriesDirectoryLogArgs'] logs: The register log information.
        :param bool mfa_enabled: Whether to enable MFA.
        :param str ram_directory_id: The ID of ram directory.
        :param str ram_directory_name: The name of directory.
        :param bool sso_enabled: Whether to enable SSO.
        :param str status: The status of directory.
        :param Sequence[str] sub_dns_addresses: The address of sub DNS.
        :param str sub_domain_name: The Name of the sub-domain.
        :param str trust_password: The trust password.
        :param str vpc_id: The ID of the vpc.
        :param Sequence[str] vswitch_ids: List of VSwitch IDs in the directory.
        """
        pulumi.set(__self__, "ad_connectors", ad_connectors)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "custom_security_group_id", custom_security_group_id)
        pulumi.set(__self__, "desktop_access_type", desktop_access_type)
        pulumi.set(__self__, "desktop_vpc_endpoint", desktop_vpc_endpoint)
        pulumi.set(__self__, "directory_type", directory_type)
        pulumi.set(__self__, "dns_addresses", dns_addresses)
        pulumi.set(__self__, "dns_user_name", dns_user_name)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "domain_password", domain_password)
        pulumi.set(__self__, "domain_user_name", domain_user_name)
        pulumi.set(__self__, "enable_admin_access", enable_admin_access)
        pulumi.set(__self__, "enable_cross_desktop_access", enable_cross_desktop_access)
        pulumi.set(__self__, "enable_internet_access", enable_internet_access)
        pulumi.set(__self__, "file_system_ids", file_system_ids)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "logs", logs)
        pulumi.set(__self__, "mfa_enabled", mfa_enabled)
        pulumi.set(__self__, "ram_directory_id", ram_directory_id)
        pulumi.set(__self__, "ram_directory_name", ram_directory_name)
        pulumi.set(__self__, "sso_enabled", sso_enabled)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "sub_dns_addresses", sub_dns_addresses)
        pulumi.set(__self__, "sub_domain_name", sub_domain_name)
        pulumi.set(__self__, "trust_password", trust_password)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @property
    @pulumi.getter(name="adConnectors")
    def ad_connectors(self) -> Sequence['outputs.GetRamDirectoriesDirectoryAdConnectorResult']:
        """
        The AD connectors.
        """
        return pulumi.get(self, "ad_connectors")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The CreateTime of resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customSecurityGroupId")
    def custom_security_group_id(self) -> str:
        """
        The id of the custom security group.
        """
        return pulumi.get(self, "custom_security_group_id")

    @property
    @pulumi.getter(name="desktopAccessType")
    def desktop_access_type(self) -> str:
        """
        The desktop access type.
        """
        return pulumi.get(self, "desktop_access_type")

    @property
    @pulumi.getter(name="desktopVpcEndpoint")
    def desktop_vpc_endpoint(self) -> str:
        """
        The desktop vpc endpoint.
        """
        return pulumi.get(self, "desktop_vpc_endpoint")

    @property
    @pulumi.getter(name="directoryType")
    def directory_type(self) -> str:
        """
        The directory type.
        """
        return pulumi.get(self, "directory_type")

    @property
    @pulumi.getter(name="dnsAddresses")
    def dns_addresses(self) -> Sequence[str]:
        """
        The address of DNSAddress.
        """
        return pulumi.get(self, "dns_addresses")

    @property
    @pulumi.getter(name="dnsUserName")
    def dns_user_name(self) -> str:
        """
        The username of DNS.
        """
        return pulumi.get(self, "dns_user_name")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The name of the domain.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="domainPassword")
    def domain_password(self) -> str:
        """
        The domain password.
        """
        return pulumi.get(self, "domain_password")

    @property
    @pulumi.getter(name="domainUserName")
    def domain_user_name(self) -> str:
        """
        The username of the domain.
        """
        return pulumi.get(self, "domain_user_name")

    @property
    @pulumi.getter(name="enableAdminAccess")
    def enable_admin_access(self) -> bool:
        """
        Whether to enable admin access.
        """
        return pulumi.get(self, "enable_admin_access")

    @property
    @pulumi.getter(name="enableCrossDesktopAccess")
    def enable_cross_desktop_access(self) -> bool:
        """
        Whether to enable cross desktop access.
        """
        return pulumi.get(self, "enable_cross_desktop_access")

    @property
    @pulumi.getter(name="enableInternetAccess")
    def enable_internet_access(self) -> bool:
        """
        Whether enable internet access.
        """
        return pulumi.get(self, "enable_internet_access")

    @property
    @pulumi.getter(name="fileSystemIds")
    def file_system_ids(self) -> Sequence[str]:
        """
        The ids of filesystem.
        """
        return pulumi.get(self, "file_system_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Ram Directory.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def logs(self) -> Sequence['outputs.GetRamDirectoriesDirectoryLogResult']:
        """
        The register log information.
        """
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter(name="mfaEnabled")
    def mfa_enabled(self) -> bool:
        """
        Whether to enable MFA.
        """
        return pulumi.get(self, "mfa_enabled")

    @property
    @pulumi.getter(name="ramDirectoryId")
    def ram_directory_id(self) -> str:
        """
        The ID of ram directory.
        """
        return pulumi.get(self, "ram_directory_id")

    @property
    @pulumi.getter(name="ramDirectoryName")
    def ram_directory_name(self) -> str:
        """
        The name of directory.
        """
        return pulumi.get(self, "ram_directory_name")

    @property
    @pulumi.getter(name="ssoEnabled")
    def sso_enabled(self) -> bool:
        """
        Whether to enable SSO.
        """
        return pulumi.get(self, "sso_enabled")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of directory.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subDnsAddresses")
    def sub_dns_addresses(self) -> Sequence[str]:
        """
        The address of sub DNS.
        """
        return pulumi.get(self, "sub_dns_addresses")

    @property
    @pulumi.getter(name="subDomainName")
    def sub_domain_name(self) -> str:
        """
        The Name of the sub-domain.
        """
        return pulumi.get(self, "sub_domain_name")

    @property
    @pulumi.getter(name="trustPassword")
    def trust_password(self) -> str:
        """
        The trust password.
        """
        return pulumi.get(self, "trust_password")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the vpc.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[str]:
        """
        List of VSwitch IDs in the directory.
        """
        return pulumi.get(self, "vswitch_ids")


@pulumi.output_type
class GetRamDirectoriesDirectoryAdConnectorResult(dict):
    def __init__(__self__, *,
                 ad_connector_address: str,
                 connector_status: str,
                 network_interface_id: str,
                 vswitch_id: str):
        """
        :param str ad_connector_address: The address of AD connector.
        :param str connector_status: The status of connector.
        :param str network_interface_id: The ID of the network interface.
        :param str vswitch_id: The ID of VSwitch.
        """
        pulumi.set(__self__, "ad_connector_address", ad_connector_address)
        pulumi.set(__self__, "connector_status", connector_status)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)

    @property
    @pulumi.getter(name="adConnectorAddress")
    def ad_connector_address(self) -> str:
        """
        The address of AD connector.
        """
        return pulumi.get(self, "ad_connector_address")

    @property
    @pulumi.getter(name="connectorStatus")
    def connector_status(self) -> str:
        """
        The status of connector.
        """
        return pulumi.get(self, "connector_status")

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> str:
        """
        The ID of the network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The ID of VSwitch.
        """
        return pulumi.get(self, "vswitch_id")


@pulumi.output_type
class GetRamDirectoriesDirectoryLogResult(dict):
    def __init__(__self__, *,
                 level: str,
                 message: str,
                 step: str,
                 time_stamp: str):
        """
        :param str level: The level of log.
        :param str message: The message of log.
        :param str step: The step of log.
        :param str time_stamp: The time stamp of log.
        """
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "step", step)
        pulumi.set(__self__, "time_stamp", time_stamp)

    @property
    @pulumi.getter
    def level(self) -> str:
        """
        The level of log.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The message of log.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def step(self) -> str:
        """
        The step of log.
        """
        return pulumi.get(self, "step")

    @property
    @pulumi.getter(name="timeStamp")
    def time_stamp(self) -> str:
        """
        The time stamp of log.
        """
        return pulumi.get(self, "time_stamp")


@pulumi.output_type
class GetSimpleOfficeSitesSiteResult(dict):
    def __init__(__self__, *,
                 bandwidth: int,
                 cen_id: str,
                 cidr_block: str,
                 create_time: str,
                 custom_security_group_id: str,
                 desktop_access_type: str,
                 desktop_vpc_endpoint: str,
                 dns_addresses: Sequence[str],
                 dns_user_name: str,
                 domain_name: str,
                 domain_password: str,
                 domain_user_name: str,
                 enable_admin_access: bool,
                 enable_cross_desktop_access: bool,
                 enable_internet_access: bool,
                 file_system_ids: Sequence[str],
                 id: str,
                 mfa_enabled: bool,
                 network_package_id: str,
                 office_site_id: str,
                 office_site_type: str,
                 simple_office_site_name: str,
                 sso_enabled: bool,
                 sso_status: bool,
                 status: str,
                 sub_dns_addresses: Sequence[str],
                 sub_domain_name: str,
                 trust_password: str,
                 vpc_id: str,
                 vswitch_ids: Sequence[str]):
        """
        :param int bandwidth: The Internet Bandwidth Peak. It has been deprecated from version 1.142.0 and can be found in the new datasource alicloud_ecd_network_packages.
        :param str cen_id: Cloud Enterprise Network Instance Id.
        :param str cidr_block: Workspace Corresponds to the Security Office Network of IPv4 Segment.
        :param str create_time: Workspace Creation Time.
        :param str custom_security_group_id: Security Group ID.
        :param str desktop_access_type: Connect to the Cloud Desktop Allows the Use of the Access Mode of. Possible Values: the Internet: Only Allows the Client to Public Cloud Desktop. Virtual Private Cloud (VPC): Only Allows in the Virtual Private Cloud (VPC) in the Client to Connect to the Cloud Desktop. Any: Not by Way of Limitation. Use Client to Connect to the Cloud Desktop When It Is Possible to Choose the Connection.
        :param str desktop_vpc_endpoint: The Desktop Vpc Endpoint.
        :param Sequence[str] dns_addresses: Enterprise Ad Corresponding DNS Address.
        :param str dns_user_name: Easy-to-Use DNS Name.
        :param str domain_name: Enterprise of Ad Domain Name.
        :param str domain_password: Domain of the User Who Will Administer This Target Application Password.
        :param str domain_user_name: The Domain Administrator's Username.
        :param bool enable_admin_access: Whether to Use Cloud Desktop User Empowerment of Local Administrator Permissions.
        :param bool enable_cross_desktop_access: Enable Cross-Desktop Access.
        :param bool enable_internet_access: Whether the Open Internet Access Function.
        :param Sequence[str] file_system_ids: NAS File System ID.
        :param str id: The ID of the Simple Office Site.
        :param bool mfa_enabled: Whether to Enable Multi-Factor Authentication MFA.
        :param str network_package_id: Internet Access ID.
        :param str office_site_id: The Workspace ID.
        :param str office_site_type: Workspace Account System Type. Possible Values: Simple: Convenient Account. AD_CONNECTOR: Enterprise Ad Account.
        :param str simple_office_site_name: The simple office site name.
        :param bool sso_enabled: Whether to Enable Single Sign-on (SSO) for User-Based SSO.
        :param bool sso_status: Whether to Enable Single Sign-on (SSO) for User-Based SSO.
        :param str status: Workspace State. Possible Values: Registering: Registered in the Registered: Registered.
        :param Sequence[str] sub_dns_addresses: AD Subdomain of the DNS Address.
        :param str sub_domain_name: AD Domain DNS Name.
        :param str trust_password: AD Trust Password.
        :param str vpc_id: Security Office VPC ID.
        :param Sequence[str] vswitch_ids: The vswitch ids.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "custom_security_group_id", custom_security_group_id)
        pulumi.set(__self__, "desktop_access_type", desktop_access_type)
        pulumi.set(__self__, "desktop_vpc_endpoint", desktop_vpc_endpoint)
        pulumi.set(__self__, "dns_addresses", dns_addresses)
        pulumi.set(__self__, "dns_user_name", dns_user_name)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "domain_password", domain_password)
        pulumi.set(__self__, "domain_user_name", domain_user_name)
        pulumi.set(__self__, "enable_admin_access", enable_admin_access)
        pulumi.set(__self__, "enable_cross_desktop_access", enable_cross_desktop_access)
        pulumi.set(__self__, "enable_internet_access", enable_internet_access)
        pulumi.set(__self__, "file_system_ids", file_system_ids)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mfa_enabled", mfa_enabled)
        pulumi.set(__self__, "network_package_id", network_package_id)
        pulumi.set(__self__, "office_site_id", office_site_id)
        pulumi.set(__self__, "office_site_type", office_site_type)
        pulumi.set(__self__, "simple_office_site_name", simple_office_site_name)
        pulumi.set(__self__, "sso_enabled", sso_enabled)
        pulumi.set(__self__, "sso_status", sso_status)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "sub_dns_addresses", sub_dns_addresses)
        pulumi.set(__self__, "sub_domain_name", sub_domain_name)
        pulumi.set(__self__, "trust_password", trust_password)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        The Internet Bandwidth Peak. It has been deprecated from version 1.142.0 and can be found in the new datasource alicloud_ecd_network_packages.
        """
        warnings.warn("""Field 'bandwidth' has been deprecated from provider version 1.142.0.""", DeprecationWarning)
        pulumi.log.warn("""bandwidth is deprecated: Field 'bandwidth' has been deprecated from provider version 1.142.0.""")

        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> str:
        """
        Cloud Enterprise Network Instance Id.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> str:
        """
        Workspace Corresponds to the Security Office Network of IPv4 Segment.
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Workspace Creation Time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customSecurityGroupId")
    def custom_security_group_id(self) -> str:
        """
        Security Group ID.
        """
        return pulumi.get(self, "custom_security_group_id")

    @property
    @pulumi.getter(name="desktopAccessType")
    def desktop_access_type(self) -> str:
        """
        Connect to the Cloud Desktop Allows the Use of the Access Mode of. Possible Values: the Internet: Only Allows the Client to Public Cloud Desktop. Virtual Private Cloud (VPC): Only Allows in the Virtual Private Cloud (VPC) in the Client to Connect to the Cloud Desktop. Any: Not by Way of Limitation. Use Client to Connect to the Cloud Desktop When It Is Possible to Choose the Connection.
        """
        return pulumi.get(self, "desktop_access_type")

    @property
    @pulumi.getter(name="desktopVpcEndpoint")
    def desktop_vpc_endpoint(self) -> str:
        """
        The Desktop Vpc Endpoint.
        """
        return pulumi.get(self, "desktop_vpc_endpoint")

    @property
    @pulumi.getter(name="dnsAddresses")
    def dns_addresses(self) -> Sequence[str]:
        """
        Enterprise Ad Corresponding DNS Address.
        """
        return pulumi.get(self, "dns_addresses")

    @property
    @pulumi.getter(name="dnsUserName")
    def dns_user_name(self) -> str:
        """
        Easy-to-Use DNS Name.
        """
        return pulumi.get(self, "dns_user_name")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        Enterprise of Ad Domain Name.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="domainPassword")
    def domain_password(self) -> str:
        """
        Domain of the User Who Will Administer This Target Application Password.
        """
        return pulumi.get(self, "domain_password")

    @property
    @pulumi.getter(name="domainUserName")
    def domain_user_name(self) -> str:
        """
        The Domain Administrator's Username.
        """
        return pulumi.get(self, "domain_user_name")

    @property
    @pulumi.getter(name="enableAdminAccess")
    def enable_admin_access(self) -> bool:
        """
        Whether to Use Cloud Desktop User Empowerment of Local Administrator Permissions.
        """
        return pulumi.get(self, "enable_admin_access")

    @property
    @pulumi.getter(name="enableCrossDesktopAccess")
    def enable_cross_desktop_access(self) -> bool:
        """
        Enable Cross-Desktop Access.
        """
        return pulumi.get(self, "enable_cross_desktop_access")

    @property
    @pulumi.getter(name="enableInternetAccess")
    def enable_internet_access(self) -> bool:
        """
        Whether the Open Internet Access Function.
        """
        warnings.warn("""Field 'enable_internet_access' has been deprecated from provider version 1.142.0.""", DeprecationWarning)
        pulumi.log.warn("""enable_internet_access is deprecated: Field 'enable_internet_access' has been deprecated from provider version 1.142.0.""")

        return pulumi.get(self, "enable_internet_access")

    @property
    @pulumi.getter(name="fileSystemIds")
    def file_system_ids(self) -> Sequence[str]:
        """
        NAS File System ID.
        """
        return pulumi.get(self, "file_system_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Simple Office Site.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mfaEnabled")
    def mfa_enabled(self) -> bool:
        """
        Whether to Enable Multi-Factor Authentication MFA.
        """
        return pulumi.get(self, "mfa_enabled")

    @property
    @pulumi.getter(name="networkPackageId")
    def network_package_id(self) -> str:
        """
        Internet Access ID.
        """
        return pulumi.get(self, "network_package_id")

    @property
    @pulumi.getter(name="officeSiteId")
    def office_site_id(self) -> str:
        """
        The Workspace ID.
        """
        return pulumi.get(self, "office_site_id")

    @property
    @pulumi.getter(name="officeSiteType")
    def office_site_type(self) -> str:
        """
        Workspace Account System Type. Possible Values: Simple: Convenient Account. AD_CONNECTOR: Enterprise Ad Account.
        """
        return pulumi.get(self, "office_site_type")

    @property
    @pulumi.getter(name="simpleOfficeSiteName")
    def simple_office_site_name(self) -> str:
        """
        The simple office site name.
        """
        return pulumi.get(self, "simple_office_site_name")

    @property
    @pulumi.getter(name="ssoEnabled")
    def sso_enabled(self) -> bool:
        """
        Whether to Enable Single Sign-on (SSO) for User-Based SSO.
        """
        return pulumi.get(self, "sso_enabled")

    @property
    @pulumi.getter(name="ssoStatus")
    def sso_status(self) -> bool:
        """
        Whether to Enable Single Sign-on (SSO) for User-Based SSO.
        """
        return pulumi.get(self, "sso_status")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Workspace State. Possible Values: Registering: Registered in the Registered: Registered.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subDnsAddresses")
    def sub_dns_addresses(self) -> Sequence[str]:
        """
        AD Subdomain of the DNS Address.
        """
        return pulumi.get(self, "sub_dns_addresses")

    @property
    @pulumi.getter(name="subDomainName")
    def sub_domain_name(self) -> str:
        """
        AD Domain DNS Name.
        """
        return pulumi.get(self, "sub_domain_name")

    @property
    @pulumi.getter(name="trustPassword")
    def trust_password(self) -> str:
        """
        AD Trust Password.
        """
        return pulumi.get(self, "trust_password")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Security Office VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[str]:
        """
        The vswitch ids.
        """
        return pulumi.get(self, "vswitch_ids")


@pulumi.output_type
class GetSnapshotsSnapshotResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 description: str,
                 desktop_id: str,
                 id: str,
                 progress: str,
                 remain_time: int,
                 snapshot_id: str,
                 snapshot_name: str,
                 snapshot_type: str,
                 source_disk_size: str,
                 source_disk_type: str,
                 status: str):
        """
        :param str create_time: The time when the snapshot was created.
        :param str description: The description of the snapshot.
        :param str desktop_id: The ID of the cloud desktop to which the snapshot belongs.
        :param str id: The ID of the Snapshot.
        :param str progress: The progress of creating the snapshot.
        :param int remain_time: The remaining time that is required to create the snapshot. Unit: seconds.
        :param str snapshot_id: The ID of the snapshot.
        :param str snapshot_name: The name of the snapshot.
        :param str snapshot_type: The type of the snapshot.
        :param str source_disk_size: The capacity of the source disk. Unit: GiB.
        :param str source_disk_type: The type of the source disk.
        :param str status: The status of the snapshot.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "desktop_id", desktop_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "remain_time", remain_time)
        pulumi.set(__self__, "snapshot_id", snapshot_id)
        pulumi.set(__self__, "snapshot_name", snapshot_name)
        pulumi.set(__self__, "snapshot_type", snapshot_type)
        pulumi.set(__self__, "source_disk_size", source_disk_size)
        pulumi.set(__self__, "source_disk_type", source_disk_type)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the snapshot was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the snapshot.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="desktopId")
    def desktop_id(self) -> str:
        """
        The ID of the cloud desktop to which the snapshot belongs.
        """
        return pulumi.get(self, "desktop_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Snapshot.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def progress(self) -> str:
        """
        The progress of creating the snapshot.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter(name="remainTime")
    def remain_time(self) -> int:
        """
        The remaining time that is required to create the snapshot. Unit: seconds.
        """
        return pulumi.get(self, "remain_time")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> str:
        """
        The ID of the snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> str:
        """
        The name of the snapshot.
        """
        return pulumi.get(self, "snapshot_name")

    @property
    @pulumi.getter(name="snapshotType")
    def snapshot_type(self) -> str:
        """
        The type of the snapshot.
        """
        return pulumi.get(self, "snapshot_type")

    @property
    @pulumi.getter(name="sourceDiskSize")
    def source_disk_size(self) -> str:
        """
        The capacity of the source disk. Unit: GiB.
        """
        return pulumi.get(self, "source_disk_size")

    @property
    @pulumi.getter(name="sourceDiskType")
    def source_disk_type(self) -> str:
        """
        The type of the source disk.
        """
        return pulumi.get(self, "source_disk_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the snapshot.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 email: str,
                 end_user_id: str,
                 id: str,
                 phone: str,
                 status: str):
        """
        :param str email: The email of the user email.
        :param str end_user_id: The Username. The custom setting is composed of lowercase letters, numbers and underscores, and the length is 3~24 characters.
        :param str id: The ID of the user id.
        :param str phone: The phone of the mobile phone number.
        :param str status: The status of the resource.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "end_user_id", end_user_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "phone", phone)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email of the user email.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="endUserId")
    def end_user_id(self) -> str:
        """
        The Username. The custom setting is composed of lowercase letters, numbers and underscores, and the length is 3~24 characters.
        """
        return pulumi.get(self, "end_user_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the user id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def phone(self) -> str:
        """
        The phone of the mobile phone number.
        """
        return pulumi.get(self, "phone")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 zone_id: str):
        """
        :param str zone_id: String to filter results by zone id.
        """
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        String to filter results by zone id.
        """
        return pulumi.get(self, "zone_id")


