# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpdsResult',
    'AwaitableGetVpdsResult',
    'get_vpds',
    'get_vpds_output',
]

@pulumi.output_type
class GetVpdsResult:
    """
    A collection of values returned by getVpds.
    """
    def __init__(__self__, enable_details=None, id=None, ids=None, name_regex=None, names=None, output_file=None, page_number=None, page_size=None, resource_group_id=None, status=None, vpd_id=None, vpd_name=None, vpds=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if resource_group_id and not isinstance(resource_group_id, str):
            raise TypeError("Expected argument 'resource_group_id' to be a str")
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vpd_id and not isinstance(vpd_id, str):
            raise TypeError("Expected argument 'vpd_id' to be a str")
        pulumi.set(__self__, "vpd_id", vpd_id)
        if vpd_name and not isinstance(vpd_name, str):
            raise TypeError("Expected argument 'vpd_name' to be a str")
        pulumi.set(__self__, "vpd_name", vpd_name)
        if vpds and not isinstance(vpds, list):
            raise TypeError("Expected argument 'vpds' to be a list")
        pulumi.set(__self__, "vpds", vpds)

    @property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[bool]:
        return pulumi.get(self, "enable_details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        A list of Vpd IDs.
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        A list of name of Vpds.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[int]:
        return pulumi.get(self, "page_number")

    @property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[int]:
        return pulumi.get(self, "page_size")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[str]:
        """
        Resource group id
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The Vpd status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpdId")
    def vpd_id(self) -> Optional[str]:
        """
        The id of the vpd.
        """
        return pulumi.get(self, "vpd_id")

    @property
    @pulumi.getter(name="vpdName")
    def vpd_name(self) -> Optional[str]:
        """
        The Name of the VPD.
        """
        return pulumi.get(self, "vpd_name")

    @property
    @pulumi.getter
    def vpds(self) -> Sequence['outputs.GetVpdsVpdResult']:
        """
        A list of Vpd Entries. Each element contains the following attributes:
        """
        return pulumi.get(self, "vpds")


class AwaitableGetVpdsResult(GetVpdsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpdsResult(
            enable_details=self.enable_details,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            resource_group_id=self.resource_group_id,
            status=self.status,
            vpd_id=self.vpd_id,
            vpd_name=self.vpd_name,
            vpds=self.vpds)


def get_vpds(enable_details: Optional[bool] = None,
             ids: Optional[Sequence[str]] = None,
             name_regex: Optional[str] = None,
             output_file: Optional[str] = None,
             page_number: Optional[int] = None,
             page_size: Optional[int] = None,
             resource_group_id: Optional[str] = None,
             status: Optional[str] = None,
             vpd_id: Optional[str] = None,
             vpd_name: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpdsResult:
    """
    This data source provides Eflo Vpd available to the user.[What is Vpd](https://help.aliyun.com/document_detail/604976.html)

    > **NOTE:** Available in 1.201.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.eflo.get_vpds(ids=[alicloud_eflo_vpd["default"]["id"]],
        name_regex=alicloud_eflo_vpd["default"]["name"],
        vpd_name="RMC-Terraform-Test")
    pulumi.export("alicloudEfloVpdExampleId", default.vpds[0].id)
    ```


    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[str] ids: A list of Vpd IDs.
    :param str name_regex: A regex string to filter results by Group Metric Rule name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str resource_group_id: The Resource group id
    :param str status: The Vpd status. Valid values: `Available`, `Not Available`, `Executing`, `Deleting`,
    :param str vpd_id: The id of the vpd.
    :param str vpd_name: The Name of the VPD.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['resourceGroupId'] = resource_group_id
    __args__['status'] = status
    __args__['vpdId'] = vpd_id
    __args__['vpdName'] = vpd_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:eflo/getVpds:getVpds', __args__, opts=opts, typ=GetVpdsResult).value

    return AwaitableGetVpdsResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        resource_group_id=pulumi.get(__ret__, 'resource_group_id'),
        status=pulumi.get(__ret__, 'status'),
        vpd_id=pulumi.get(__ret__, 'vpd_id'),
        vpd_name=pulumi.get(__ret__, 'vpd_name'),
        vpds=pulumi.get(__ret__, 'vpds'))


@_utilities.lift_output_func(get_vpds)
def get_vpds_output(enable_details: Optional[pulumi.Input[Optional[bool]]] = None,
                    ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                    name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                    output_file: Optional[pulumi.Input[Optional[str]]] = None,
                    page_number: Optional[pulumi.Input[Optional[int]]] = None,
                    page_size: Optional[pulumi.Input[Optional[int]]] = None,
                    resource_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                    status: Optional[pulumi.Input[Optional[str]]] = None,
                    vpd_id: Optional[pulumi.Input[Optional[str]]] = None,
                    vpd_name: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVpdsResult]:
    """
    This data source provides Eflo Vpd available to the user.[What is Vpd](https://help.aliyun.com/document_detail/604976.html)

    > **NOTE:** Available in 1.201.0+

    ## Example Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.eflo.get_vpds(ids=[alicloud_eflo_vpd["default"]["id"]],
        name_regex=alicloud_eflo_vpd["default"]["name"],
        vpd_name="RMC-Terraform-Test")
    pulumi.export("alicloudEfloVpdExampleId", default.vpds[0].id)
    ```


    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param Sequence[str] ids: A list of Vpd IDs.
    :param str name_regex: A regex string to filter results by Group Metric Rule name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str resource_group_id: The Resource group id
    :param str status: The Vpd status. Valid values: `Available`, `Not Available`, `Executing`, `Deleting`,
    :param str vpd_id: The id of the vpd.
    :param str vpd_name: The Name of the VPD.
    """
    ...
