# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AnycastEipAddressAttachmentArgs', 'AnycastEipAddressAttachment']

@pulumi.input_type
class AnycastEipAddressAttachmentArgs:
    def __init__(__self__, *,
                 anycast_id: pulumi.Input[str],
                 bind_instance_id: pulumi.Input[str],
                 bind_instance_region_id: pulumi.Input[str],
                 bind_instance_type: pulumi.Input[str],
                 association_mode: Optional[pulumi.Input[str]] = None,
                 pop_locations: Optional[pulumi.Input[Sequence[pulumi.Input['AnycastEipAddressAttachmentPopLocationArgs']]]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AnycastEipAddressAttachment resource.
        :param pulumi.Input[str] anycast_id: The ID of the Anycast EIP instance.
        :param pulumi.Input[str] bind_instance_id: The ID of the cloud resource instance to be bound.
        :param pulumi.Input[str] bind_instance_region_id: The region ID of the cloud resource instance to be bound.You can only bind cloud resource instances in some regions. You can call the describeanystserverregions operation to obtain the region ID of the cloud resource instances that can be bound.
        :param pulumi.Input[str] bind_instance_type: The type of the cloud resource instance to be bound. Value:
               - **SlbInstance**: a private network SLB instance.
               - **NetworkInterface**: ENI.
        :param pulumi.Input[str] association_mode: Binding mode, value:
               - **Default**: The Default mode. The cloud resource instance to be bound is set as the Default origin.
               - **Normal**: In Normal mode, the cloud resource instance to be bound is set to the common source station.
        :param pulumi.Input[Sequence[pulumi.Input['AnycastEipAddressAttachmentPopLocationArgs']]] pop_locations: The access point information of the associated access area when the cloud resource instance is bound.If you are binding for the first time, this parameter does not need to be configured, and the system automatically associates all access areas. See `pop_locations` below.
        :param pulumi.Input[str] private_ip_address: The secondary private IP address of the elastic network card to be bound.This parameter takes effect only when **BindInstanceType** is set to **NetworkInterface. When you do not enter, this parameter is the primary private IP of the ENI by default.
        """
        pulumi.set(__self__, "anycast_id", anycast_id)
        pulumi.set(__self__, "bind_instance_id", bind_instance_id)
        pulumi.set(__self__, "bind_instance_region_id", bind_instance_region_id)
        pulumi.set(__self__, "bind_instance_type", bind_instance_type)
        if association_mode is not None:
            pulumi.set(__self__, "association_mode", association_mode)
        if pop_locations is not None:
            pulumi.set(__self__, "pop_locations", pop_locations)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)

    @property
    @pulumi.getter(name="anycastId")
    def anycast_id(self) -> pulumi.Input[str]:
        """
        The ID of the Anycast EIP instance.
        """
        return pulumi.get(self, "anycast_id")

    @anycast_id.setter
    def anycast_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "anycast_id", value)

    @property
    @pulumi.getter(name="bindInstanceId")
    def bind_instance_id(self) -> pulumi.Input[str]:
        """
        The ID of the cloud resource instance to be bound.
        """
        return pulumi.get(self, "bind_instance_id")

    @bind_instance_id.setter
    def bind_instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bind_instance_id", value)

    @property
    @pulumi.getter(name="bindInstanceRegionId")
    def bind_instance_region_id(self) -> pulumi.Input[str]:
        """
        The region ID of the cloud resource instance to be bound.You can only bind cloud resource instances in some regions. You can call the describeanystserverregions operation to obtain the region ID of the cloud resource instances that can be bound.
        """
        return pulumi.get(self, "bind_instance_region_id")

    @bind_instance_region_id.setter
    def bind_instance_region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bind_instance_region_id", value)

    @property
    @pulumi.getter(name="bindInstanceType")
    def bind_instance_type(self) -> pulumi.Input[str]:
        """
        The type of the cloud resource instance to be bound. Value:
        - **SlbInstance**: a private network SLB instance.
        - **NetworkInterface**: ENI.
        """
        return pulumi.get(self, "bind_instance_type")

    @bind_instance_type.setter
    def bind_instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "bind_instance_type", value)

    @property
    @pulumi.getter(name="associationMode")
    def association_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Binding mode, value:
        - **Default**: The Default mode. The cloud resource instance to be bound is set as the Default origin.
        - **Normal**: In Normal mode, the cloud resource instance to be bound is set to the common source station.
        """
        return pulumi.get(self, "association_mode")

    @association_mode.setter
    def association_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "association_mode", value)

    @property
    @pulumi.getter(name="popLocations")
    def pop_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AnycastEipAddressAttachmentPopLocationArgs']]]]:
        """
        The access point information of the associated access area when the cloud resource instance is bound.If you are binding for the first time, this parameter does not need to be configured, and the system automatically associates all access areas. See `pop_locations` below.
        """
        return pulumi.get(self, "pop_locations")

    @pop_locations.setter
    def pop_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AnycastEipAddressAttachmentPopLocationArgs']]]]):
        pulumi.set(self, "pop_locations", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The secondary private IP address of the elastic network card to be bound.This parameter takes effect only when **BindInstanceType** is set to **NetworkInterface. When you do not enter, this parameter is the primary private IP of the ENI by default.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)


@pulumi.input_type
class _AnycastEipAddressAttachmentState:
    def __init__(__self__, *,
                 anycast_id: Optional[pulumi.Input[str]] = None,
                 association_mode: Optional[pulumi.Input[str]] = None,
                 bind_instance_id: Optional[pulumi.Input[str]] = None,
                 bind_instance_region_id: Optional[pulumi.Input[str]] = None,
                 bind_instance_type: Optional[pulumi.Input[str]] = None,
                 bind_time: Optional[pulumi.Input[str]] = None,
                 pop_locations: Optional[pulumi.Input[Sequence[pulumi.Input['AnycastEipAddressAttachmentPopLocationArgs']]]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AnycastEipAddressAttachment resources.
        :param pulumi.Input[str] anycast_id: The ID of the Anycast EIP instance.
        :param pulumi.Input[str] association_mode: Binding mode, value:
               - **Default**: The Default mode. The cloud resource instance to be bound is set as the Default origin.
               - **Normal**: In Normal mode, the cloud resource instance to be bound is set to the common source station.
        :param pulumi.Input[str] bind_instance_id: The ID of the cloud resource instance to be bound.
        :param pulumi.Input[str] bind_instance_region_id: The region ID of the cloud resource instance to be bound.You can only bind cloud resource instances in some regions. You can call the describeanystserverregions operation to obtain the region ID of the cloud resource instances that can be bound.
        :param pulumi.Input[str] bind_instance_type: The type of the cloud resource instance to be bound. Value:
               - **SlbInstance**: a private network SLB instance.
               - **NetworkInterface**: ENI.
        :param pulumi.Input[str] bind_time: Binding time.Time is expressed according to ISO8601 standard and UTC time is used. The format is: 'YYYY-MM-DDThh:mm:ssZ'.
        :param pulumi.Input[Sequence[pulumi.Input['AnycastEipAddressAttachmentPopLocationArgs']]] pop_locations: The access point information of the associated access area when the cloud resource instance is bound.If you are binding for the first time, this parameter does not need to be configured, and the system automatically associates all access areas. See `pop_locations` below.
        :param pulumi.Input[str] private_ip_address: The secondary private IP address of the elastic network card to be bound.This parameter takes effect only when **BindInstanceType** is set to **NetworkInterface. When you do not enter, this parameter is the primary private IP of the ENI by default.
        :param pulumi.Input[str] status: The status of the bound cloud resource instance. Value:BINDING: BINDING.Bound: Bound.UNBINDING: UNBINDING.DELETED: DELETED.MODIFYING: being modified.
        """
        if anycast_id is not None:
            pulumi.set(__self__, "anycast_id", anycast_id)
        if association_mode is not None:
            pulumi.set(__self__, "association_mode", association_mode)
        if bind_instance_id is not None:
            pulumi.set(__self__, "bind_instance_id", bind_instance_id)
        if bind_instance_region_id is not None:
            pulumi.set(__self__, "bind_instance_region_id", bind_instance_region_id)
        if bind_instance_type is not None:
            pulumi.set(__self__, "bind_instance_type", bind_instance_type)
        if bind_time is not None:
            pulumi.set(__self__, "bind_time", bind_time)
        if pop_locations is not None:
            pulumi.set(__self__, "pop_locations", pop_locations)
        if private_ip_address is not None:
            pulumi.set(__self__, "private_ip_address", private_ip_address)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="anycastId")
    def anycast_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Anycast EIP instance.
        """
        return pulumi.get(self, "anycast_id")

    @anycast_id.setter
    def anycast_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "anycast_id", value)

    @property
    @pulumi.getter(name="associationMode")
    def association_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Binding mode, value:
        - **Default**: The Default mode. The cloud resource instance to be bound is set as the Default origin.
        - **Normal**: In Normal mode, the cloud resource instance to be bound is set to the common source station.
        """
        return pulumi.get(self, "association_mode")

    @association_mode.setter
    def association_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "association_mode", value)

    @property
    @pulumi.getter(name="bindInstanceId")
    def bind_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the cloud resource instance to be bound.
        """
        return pulumi.get(self, "bind_instance_id")

    @bind_instance_id.setter
    def bind_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bind_instance_id", value)

    @property
    @pulumi.getter(name="bindInstanceRegionId")
    def bind_instance_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The region ID of the cloud resource instance to be bound.You can only bind cloud resource instances in some regions. You can call the describeanystserverregions operation to obtain the region ID of the cloud resource instances that can be bound.
        """
        return pulumi.get(self, "bind_instance_region_id")

    @bind_instance_region_id.setter
    def bind_instance_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bind_instance_region_id", value)

    @property
    @pulumi.getter(name="bindInstanceType")
    def bind_instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the cloud resource instance to be bound. Value:
        - **SlbInstance**: a private network SLB instance.
        - **NetworkInterface**: ENI.
        """
        return pulumi.get(self, "bind_instance_type")

    @bind_instance_type.setter
    def bind_instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bind_instance_type", value)

    @property
    @pulumi.getter(name="bindTime")
    def bind_time(self) -> Optional[pulumi.Input[str]]:
        """
        Binding time.Time is expressed according to ISO8601 standard and UTC time is used. The format is: 'YYYY-MM-DDThh:mm:ssZ'.
        """
        return pulumi.get(self, "bind_time")

    @bind_time.setter
    def bind_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bind_time", value)

    @property
    @pulumi.getter(name="popLocations")
    def pop_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AnycastEipAddressAttachmentPopLocationArgs']]]]:
        """
        The access point information of the associated access area when the cloud resource instance is bound.If you are binding for the first time, this parameter does not need to be configured, and the system automatically associates all access areas. See `pop_locations` below.
        """
        return pulumi.get(self, "pop_locations")

    @pop_locations.setter
    def pop_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AnycastEipAddressAttachmentPopLocationArgs']]]]):
        pulumi.set(self, "pop_locations", value)

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The secondary private IP address of the elastic network card to be bound.This parameter takes effect only when **BindInstanceType** is set to **NetworkInterface. When you do not enter, this parameter is the primary private IP of the ENI by default.
        """
        return pulumi.get(self, "private_ip_address")

    @private_ip_address.setter
    def private_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip_address", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the bound cloud resource instance. Value:BINDING: BINDING.Bound: Bound.UNBINDING: UNBINDING.DELETED: DELETED.MODIFYING: being modified.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class AnycastEipAddressAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anycast_id: Optional[pulumi.Input[str]] = None,
                 association_mode: Optional[pulumi.Input[str]] = None,
                 bind_instance_id: Optional[pulumi.Input[str]] = None,
                 bind_instance_region_id: Optional[pulumi.Input[str]] = None,
                 bind_instance_type: Optional[pulumi.Input[str]] = None,
                 pop_locations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnycastEipAddressAttachmentPopLocationArgs']]]]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Eipanycast Anycast Eip Address Attachment resource.

        For information about Eipanycast Anycast Eip Address Attachment and how to use it, see [What is Anycast Eip Address Attachment](https://www.alibabacloud.com/help/en/anycast-eip/latest/api-eipanycast-2020-03-09-associateanycasteipaddress).

        > **NOTE:** Available since v1.113.0.

        > **NOTE:** The following regions support currently while Slb instance support bound.
        [eu-west-1-gb33-a01,cn-hongkong-am4-c04,ap-southeast-os30-a01,us-west-ot7-a01,ap-south-in73-a01,ap-southeast-my88-a01]

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.slb.get_zones(available_slb_address_type="vpc")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.1.0.0/16",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("defaultApplicationLoadBalancer",
            address_type="intranet",
            vswitch_id=default_switch.id,
            load_balancer_name=name,
            load_balancer_spec="slb.s1.small",
            master_zone_id=default_zones.zones[0].id)
        default_anycast_eip_address = alicloud.eipanycast.AnycastEipAddress("defaultAnycastEipAddress",
            anycast_eip_address_name=name,
            service_location="ChineseMainland")
        default_regions = alicloud.get_regions(current=True)
        default_anycast_eip_address_attachment = alicloud.eipanycast.AnycastEipAddressAttachment("defaultAnycastEipAddressAttachment",
            bind_instance_id=default_application_load_balancer.id,
            bind_instance_type="SlbInstance",
            bind_instance_region_id=default_regions.regions[0].id,
            anycast_id=default_anycast_eip_address.id)
        ```

        Multiple Usage

        > **NOTE:**  Anycast EIP supports binding cloud resource instances in multiple regions. Only one cloud resource instance is supported as the default origin station, and the rest are normal origin stations. When no access point is specified or an access point is added, the access request is forwarded to the default origin by default.  If you are bound for the first time, the Default value of the binding mode is **Default * *. /li> li> If you are not binding for the first time, you can set the binding mode to **Default**, and the new Default origin will take effect. The original Default origin will be changed to a common origin.

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        beijing = alicloud.Provider("beijing", region="cn-beijing")
        hangzhou = alicloud.Provider("hangzhou", region="cn-hangzhou")
        default_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        default_vpc = alicloud.vpc.Network("defaultVpc",
            vpc_name=name,
            cidr_block="192.168.0.0/16",
            opts=pulumi.ResourceOptions(provider="alicloud.beijing"))
        default_vsw = alicloud.vpc.Switch("defaultVsw",
            vpc_id=default_vpc.id,
            cidr_block="192.168.0.0/24",
            zone_id=default_zones.zones[0].id,
            opts=pulumi.ResourceOptions(provider="alicloud.beijing"))
        defaultu_bs_eci = alicloud.ecs.SecurityGroup("defaultuBsECI", vpc_id=default_vpc.id,
        opts=pulumi.ResourceOptions(provider="alicloud.beijing"))
        default9_k_dl_n7 = alicloud.ecs.Instance("default9KDlN7",
            image_id=default_images.images[0].id,
            instance_type=default_instance_types.instance_types[0].id,
            instance_name=name,
            security_groups=[defaultu_bs_eci.id],
            availability_zone=default_vsw.zone_id,
            instance_charge_type="PostPaid",
            system_disk_category="cloud_efficiency",
            vswitch_id=default_vsw.id,
            opts=pulumi.ResourceOptions(provider="alicloud.beijing"))
        default_xkp_frs = alicloud.eipanycast.AnycastEipAddress("defaultXkpFRs", service_location="ChineseMainland",
        opts=pulumi.ResourceOptions(provider="alicloud.hangzhou"))
        default_vpc2 = alicloud.vpc.Network("defaultVpc2",
            vpc_name=f"{name}6",
            cidr_block="192.168.0.0/16",
            opts=pulumi.ResourceOptions(provider="alicloud.hangzhou"))
        default2_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default2_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default2_instance_types = alicloud.ecs.get_instance_types(availability_zone=default2_zones.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        defaultds_vsw2 = alicloud.vpc.Switch("defaultdsVsw2",
            vpc_id=default_vpc2.id,
            cidr_block="192.168.0.0/24",
            zone_id=default2_zones.zones[1].id,
            opts=pulumi.ResourceOptions(provider="alicloud.hangzhou"))
        defaultu_bs_eci2 = alicloud.ecs.SecurityGroup("defaultuBsECI2", vpc_id=default_vpc2.id,
        opts=pulumi.ResourceOptions(provider="alicloud.hangzhou"))
        default_ecs2 = alicloud.ecs.Instance("defaultEcs2",
            image_id=default2_images.images[0].id,
            instance_type=default2_instance_types.instance_types[0].id,
            instance_name=name,
            security_groups=[defaultu_bs_eci2.id],
            availability_zone=defaultds_vsw2.zone_id,
            instance_charge_type="PostPaid",
            system_disk_category="cloud_efficiency",
            vswitch_id=defaultds_vsw2.id,
            opts=pulumi.ResourceOptions(provider="alicloud.hangzhou"))
        default_ef_ybjy = alicloud.eipanycast.AnycastEipAddressAttachment("defaultEfYBJY",
            bind_instance_id=default9_k_dl_n7.network_interface_id,
            bind_instance_type="NetworkInterface",
            bind_instance_region_id="cn-beijing",
            anycast_id=default_xkp_frs.id,
            association_mode="Default",
            opts=pulumi.ResourceOptions(provider="alicloud.beijing"))
        normal = alicloud.eipanycast.AnycastEipAddressAttachment("normal",
            bind_instance_id=default_ecs2.network_interface_id,
            bind_instance_type="NetworkInterface",
            bind_instance_region_id="cn-hangzhou",
            anycast_id=default_ef_ybjy.anycast_id,
            opts=pulumi.ResourceOptions(provider="alicloud.hangzhou"))
        ```

        ## Import

        Eipanycast Anycast Eip Address Attachment can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:eipanycast/anycastEipAddressAttachment:AnycastEipAddressAttachment example <anycast_id>:<bind_instance_id>:<bind_instance_region_id>:<bind_instance_type>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] anycast_id: The ID of the Anycast EIP instance.
        :param pulumi.Input[str] association_mode: Binding mode, value:
               - **Default**: The Default mode. The cloud resource instance to be bound is set as the Default origin.
               - **Normal**: In Normal mode, the cloud resource instance to be bound is set to the common source station.
        :param pulumi.Input[str] bind_instance_id: The ID of the cloud resource instance to be bound.
        :param pulumi.Input[str] bind_instance_region_id: The region ID of the cloud resource instance to be bound.You can only bind cloud resource instances in some regions. You can call the describeanystserverregions operation to obtain the region ID of the cloud resource instances that can be bound.
        :param pulumi.Input[str] bind_instance_type: The type of the cloud resource instance to be bound. Value:
               - **SlbInstance**: a private network SLB instance.
               - **NetworkInterface**: ENI.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnycastEipAddressAttachmentPopLocationArgs']]]] pop_locations: The access point information of the associated access area when the cloud resource instance is bound.If you are binding for the first time, this parameter does not need to be configured, and the system automatically associates all access areas. See `pop_locations` below.
        :param pulumi.Input[str] private_ip_address: The secondary private IP address of the elastic network card to be bound.This parameter takes effect only when **BindInstanceType** is set to **NetworkInterface. When you do not enter, this parameter is the primary private IP of the ENI by default.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnycastEipAddressAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Eipanycast Anycast Eip Address Attachment resource.

        For information about Eipanycast Anycast Eip Address Attachment and how to use it, see [What is Anycast Eip Address Attachment](https://www.alibabacloud.com/help/en/anycast-eip/latest/api-eipanycast-2020-03-09-associateanycasteipaddress).

        > **NOTE:** Available since v1.113.0.

        > **NOTE:** The following regions support currently while Slb instance support bound.
        [eu-west-1-gb33-a01,cn-hongkong-am4-c04,ap-southeast-os30-a01,us-west-ot7-a01,ap-south-in73-a01,ap-southeast-my88-a01]

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.slb.get_zones(available_slb_address_type="vpc")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vswitch_name=name,
            cidr_block="10.1.0.0/16",
            vpc_id=default_network.id,
            zone_id=default_zones.zones[0].id)
        default_application_load_balancer = alicloud.slb.ApplicationLoadBalancer("defaultApplicationLoadBalancer",
            address_type="intranet",
            vswitch_id=default_switch.id,
            load_balancer_name=name,
            load_balancer_spec="slb.s1.small",
            master_zone_id=default_zones.zones[0].id)
        default_anycast_eip_address = alicloud.eipanycast.AnycastEipAddress("defaultAnycastEipAddress",
            anycast_eip_address_name=name,
            service_location="ChineseMainland")
        default_regions = alicloud.get_regions(current=True)
        default_anycast_eip_address_attachment = alicloud.eipanycast.AnycastEipAddressAttachment("defaultAnycastEipAddressAttachment",
            bind_instance_id=default_application_load_balancer.id,
            bind_instance_type="SlbInstance",
            bind_instance_region_id=default_regions.regions[0].id,
            anycast_id=default_anycast_eip_address.id)
        ```

        Multiple Usage

        > **NOTE:**  Anycast EIP supports binding cloud resource instances in multiple regions. Only one cloud resource instance is supported as the default origin station, and the rest are normal origin stations. When no access point is specified or an access point is added, the access request is forwarded to the default origin by default.  If you are bound for the first time, the Default value of the binding mode is **Default * *. /li> li> If you are not binding for the first time, you can set the binding mode to **Default**, and the new Default origin will take effect. The original Default origin will be changed to a common origin.

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        beijing = alicloud.Provider("beijing", region="cn-beijing")
        hangzhou = alicloud.Provider("hangzhou", region="cn-hangzhou")
        default_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        default_vpc = alicloud.vpc.Network("defaultVpc",
            vpc_name=name,
            cidr_block="192.168.0.0/16",
            opts=pulumi.ResourceOptions(provider="alicloud.beijing"))
        default_vsw = alicloud.vpc.Switch("defaultVsw",
            vpc_id=default_vpc.id,
            cidr_block="192.168.0.0/24",
            zone_id=default_zones.zones[0].id,
            opts=pulumi.ResourceOptions(provider="alicloud.beijing"))
        defaultu_bs_eci = alicloud.ecs.SecurityGroup("defaultuBsECI", vpc_id=default_vpc.id,
        opts=pulumi.ResourceOptions(provider="alicloud.beijing"))
        default9_k_dl_n7 = alicloud.ecs.Instance("default9KDlN7",
            image_id=default_images.images[0].id,
            instance_type=default_instance_types.instance_types[0].id,
            instance_name=name,
            security_groups=[defaultu_bs_eci.id],
            availability_zone=default_vsw.zone_id,
            instance_charge_type="PostPaid",
            system_disk_category="cloud_efficiency",
            vswitch_id=default_vsw.id,
            opts=pulumi.ResourceOptions(provider="alicloud.beijing"))
        default_xkp_frs = alicloud.eipanycast.AnycastEipAddress("defaultXkpFRs", service_location="ChineseMainland",
        opts=pulumi.ResourceOptions(provider="alicloud.hangzhou"))
        default_vpc2 = alicloud.vpc.Network("defaultVpc2",
            vpc_name=f"{name}6",
            cidr_block="192.168.0.0/16",
            opts=pulumi.ResourceOptions(provider="alicloud.hangzhou"))
        default2_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default2_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default2_instance_types = alicloud.ecs.get_instance_types(availability_zone=default2_zones.zones[0].id,
            cpu_core_count=1,
            memory_size=2)
        defaultds_vsw2 = alicloud.vpc.Switch("defaultdsVsw2",
            vpc_id=default_vpc2.id,
            cidr_block="192.168.0.0/24",
            zone_id=default2_zones.zones[1].id,
            opts=pulumi.ResourceOptions(provider="alicloud.hangzhou"))
        defaultu_bs_eci2 = alicloud.ecs.SecurityGroup("defaultuBsECI2", vpc_id=default_vpc2.id,
        opts=pulumi.ResourceOptions(provider="alicloud.hangzhou"))
        default_ecs2 = alicloud.ecs.Instance("defaultEcs2",
            image_id=default2_images.images[0].id,
            instance_type=default2_instance_types.instance_types[0].id,
            instance_name=name,
            security_groups=[defaultu_bs_eci2.id],
            availability_zone=defaultds_vsw2.zone_id,
            instance_charge_type="PostPaid",
            system_disk_category="cloud_efficiency",
            vswitch_id=defaultds_vsw2.id,
            opts=pulumi.ResourceOptions(provider="alicloud.hangzhou"))
        default_ef_ybjy = alicloud.eipanycast.AnycastEipAddressAttachment("defaultEfYBJY",
            bind_instance_id=default9_k_dl_n7.network_interface_id,
            bind_instance_type="NetworkInterface",
            bind_instance_region_id="cn-beijing",
            anycast_id=default_xkp_frs.id,
            association_mode="Default",
            opts=pulumi.ResourceOptions(provider="alicloud.beijing"))
        normal = alicloud.eipanycast.AnycastEipAddressAttachment("normal",
            bind_instance_id=default_ecs2.network_interface_id,
            bind_instance_type="NetworkInterface",
            bind_instance_region_id="cn-hangzhou",
            anycast_id=default_ef_ybjy.anycast_id,
            opts=pulumi.ResourceOptions(provider="alicloud.hangzhou"))
        ```

        ## Import

        Eipanycast Anycast Eip Address Attachment can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:eipanycast/anycastEipAddressAttachment:AnycastEipAddressAttachment example <anycast_id>:<bind_instance_id>:<bind_instance_region_id>:<bind_instance_type>
        ```

        :param str resource_name: The name of the resource.
        :param AnycastEipAddressAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnycastEipAddressAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 anycast_id: Optional[pulumi.Input[str]] = None,
                 association_mode: Optional[pulumi.Input[str]] = None,
                 bind_instance_id: Optional[pulumi.Input[str]] = None,
                 bind_instance_region_id: Optional[pulumi.Input[str]] = None,
                 bind_instance_type: Optional[pulumi.Input[str]] = None,
                 pop_locations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnycastEipAddressAttachmentPopLocationArgs']]]]] = None,
                 private_ip_address: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnycastEipAddressAttachmentArgs.__new__(AnycastEipAddressAttachmentArgs)

            if anycast_id is None and not opts.urn:
                raise TypeError("Missing required property 'anycast_id'")
            __props__.__dict__["anycast_id"] = anycast_id
            __props__.__dict__["association_mode"] = association_mode
            if bind_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'bind_instance_id'")
            __props__.__dict__["bind_instance_id"] = bind_instance_id
            if bind_instance_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'bind_instance_region_id'")
            __props__.__dict__["bind_instance_region_id"] = bind_instance_region_id
            if bind_instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'bind_instance_type'")
            __props__.__dict__["bind_instance_type"] = bind_instance_type
            __props__.__dict__["pop_locations"] = pop_locations
            __props__.__dict__["private_ip_address"] = private_ip_address
            __props__.__dict__["bind_time"] = None
            __props__.__dict__["status"] = None
        super(AnycastEipAddressAttachment, __self__).__init__(
            'alicloud:eipanycast/anycastEipAddressAttachment:AnycastEipAddressAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            anycast_id: Optional[pulumi.Input[str]] = None,
            association_mode: Optional[pulumi.Input[str]] = None,
            bind_instance_id: Optional[pulumi.Input[str]] = None,
            bind_instance_region_id: Optional[pulumi.Input[str]] = None,
            bind_instance_type: Optional[pulumi.Input[str]] = None,
            bind_time: Optional[pulumi.Input[str]] = None,
            pop_locations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnycastEipAddressAttachmentPopLocationArgs']]]]] = None,
            private_ip_address: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'AnycastEipAddressAttachment':
        """
        Get an existing AnycastEipAddressAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] anycast_id: The ID of the Anycast EIP instance.
        :param pulumi.Input[str] association_mode: Binding mode, value:
               - **Default**: The Default mode. The cloud resource instance to be bound is set as the Default origin.
               - **Normal**: In Normal mode, the cloud resource instance to be bound is set to the common source station.
        :param pulumi.Input[str] bind_instance_id: The ID of the cloud resource instance to be bound.
        :param pulumi.Input[str] bind_instance_region_id: The region ID of the cloud resource instance to be bound.You can only bind cloud resource instances in some regions. You can call the describeanystserverregions operation to obtain the region ID of the cloud resource instances that can be bound.
        :param pulumi.Input[str] bind_instance_type: The type of the cloud resource instance to be bound. Value:
               - **SlbInstance**: a private network SLB instance.
               - **NetworkInterface**: ENI.
        :param pulumi.Input[str] bind_time: Binding time.Time is expressed according to ISO8601 standard and UTC time is used. The format is: 'YYYY-MM-DDThh:mm:ssZ'.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AnycastEipAddressAttachmentPopLocationArgs']]]] pop_locations: The access point information of the associated access area when the cloud resource instance is bound.If you are binding for the first time, this parameter does not need to be configured, and the system automatically associates all access areas. See `pop_locations` below.
        :param pulumi.Input[str] private_ip_address: The secondary private IP address of the elastic network card to be bound.This parameter takes effect only when **BindInstanceType** is set to **NetworkInterface. When you do not enter, this parameter is the primary private IP of the ENI by default.
        :param pulumi.Input[str] status: The status of the bound cloud resource instance. Value:BINDING: BINDING.Bound: Bound.UNBINDING: UNBINDING.DELETED: DELETED.MODIFYING: being modified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnycastEipAddressAttachmentState.__new__(_AnycastEipAddressAttachmentState)

        __props__.__dict__["anycast_id"] = anycast_id
        __props__.__dict__["association_mode"] = association_mode
        __props__.__dict__["bind_instance_id"] = bind_instance_id
        __props__.__dict__["bind_instance_region_id"] = bind_instance_region_id
        __props__.__dict__["bind_instance_type"] = bind_instance_type
        __props__.__dict__["bind_time"] = bind_time
        __props__.__dict__["pop_locations"] = pop_locations
        __props__.__dict__["private_ip_address"] = private_ip_address
        __props__.__dict__["status"] = status
        return AnycastEipAddressAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="anycastId")
    def anycast_id(self) -> pulumi.Output[str]:
        """
        The ID of the Anycast EIP instance.
        """
        return pulumi.get(self, "anycast_id")

    @property
    @pulumi.getter(name="associationMode")
    def association_mode(self) -> pulumi.Output[str]:
        """
        Binding mode, value:
        - **Default**: The Default mode. The cloud resource instance to be bound is set as the Default origin.
        - **Normal**: In Normal mode, the cloud resource instance to be bound is set to the common source station.
        """
        return pulumi.get(self, "association_mode")

    @property
    @pulumi.getter(name="bindInstanceId")
    def bind_instance_id(self) -> pulumi.Output[str]:
        """
        The ID of the cloud resource instance to be bound.
        """
        return pulumi.get(self, "bind_instance_id")

    @property
    @pulumi.getter(name="bindInstanceRegionId")
    def bind_instance_region_id(self) -> pulumi.Output[str]:
        """
        The region ID of the cloud resource instance to be bound.You can only bind cloud resource instances in some regions. You can call the describeanystserverregions operation to obtain the region ID of the cloud resource instances that can be bound.
        """
        return pulumi.get(self, "bind_instance_region_id")

    @property
    @pulumi.getter(name="bindInstanceType")
    def bind_instance_type(self) -> pulumi.Output[str]:
        """
        The type of the cloud resource instance to be bound. Value:
        - **SlbInstance**: a private network SLB instance.
        - **NetworkInterface**: ENI.
        """
        return pulumi.get(self, "bind_instance_type")

    @property
    @pulumi.getter(name="bindTime")
    def bind_time(self) -> pulumi.Output[str]:
        """
        Binding time.Time is expressed according to ISO8601 standard and UTC time is used. The format is: 'YYYY-MM-DDThh:mm:ssZ'.
        """
        return pulumi.get(self, "bind_time")

    @property
    @pulumi.getter(name="popLocations")
    def pop_locations(self) -> pulumi.Output[Optional[Sequence['outputs.AnycastEipAddressAttachmentPopLocation']]]:
        """
        The access point information of the associated access area when the cloud resource instance is bound.If you are binding for the first time, this parameter does not need to be configured, and the system automatically associates all access areas. See `pop_locations` below.
        """
        return pulumi.get(self, "pop_locations")

    @property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> pulumi.Output[Optional[str]]:
        """
        The secondary private IP address of the elastic network card to be bound.This parameter takes effect only when **BindInstanceType** is set to **NetworkInterface. When you do not enter, this parameter is the primary private IP of the ENI by default.
        """
        return pulumi.get(self, "private_ip_address")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the bound cloud resource instance. Value:BINDING: BINDING.Bound: Bound.UNBINDING: UNBINDING.DELETED: DELETED.MODIFYING: being modified.
        """
        return pulumi.get(self, "status")

