# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 data_node_amount: pulumi.Input[int],
                 data_node_disk_size: pulumi.Input[int],
                 data_node_disk_type: pulumi.Input[str],
                 data_node_spec: pulumi.Input[str],
                 version: pulumi.Input[str],
                 vswitch_id: pulumi.Input[str],
                 auto_renew_duration: Optional[pulumi.Input[int]] = None,
                 client_node_amount: Optional[pulumi.Input[int]] = None,
                 client_node_spec: Optional[pulumi.Input[str]] = None,
                 data_node_disk_encrypted: Optional[pulumi.Input[bool]] = None,
                 data_node_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_kibana_private_network: Optional[pulumi.Input[bool]] = None,
                 enable_kibana_public_network: Optional[pulumi.Input[bool]] = None,
                 enable_public: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 kibana_node_spec: Optional[pulumi.Input[str]] = None,
                 kibana_private_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kibana_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 master_node_disk_type: Optional[pulumi.Input[str]] = None,
                 master_node_spec: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 private_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 public_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 renew_status: Optional[pulumi.Input[str]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 setting_config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[int] data_node_amount: The Elasticsearch cluster's data node quantity, between 2 and 50.
        :param pulumi.Input[int] data_node_disk_size: The single data node storage space.
        :param pulumi.Input[str] data_node_disk_type: The data node disk type. Supported values: cloud_ssd, cloud_efficiency.
        :param pulumi.Input[str] data_node_spec: The data node specifications of the Elasticsearch instance.
        :param pulumi.Input[str] version: Elasticsearch version. Supported values: `5.5.3_with_X-Pack`, `6.3_with_X-Pack`, `6.7_with_X-Pack`, `6.8_with_X-Pack`, `7.4_with_X-Pack` and `7.7_with_X-Pack`.
        :param pulumi.Input[str] vswitch_id: The ID of VSwitch.
        :param pulumi.Input[int] auto_renew_duration: Auto-renewal period of an Elasticsearch Instance, in the unit of the month. It is valid when `instance_charge_type` is `PrePaid` and `renew_status` is `AutoRenewal`.
        :param pulumi.Input[int] client_node_amount: The Elasticsearch cluster's client node quantity, between 2 and 25.
        :param pulumi.Input[str] client_node_spec: The client node spec. If specified, client node will be created.
        :param pulumi.Input[bool] data_node_disk_encrypted: If encrypt the data node disk. Valid values are `true`, `false`. Default to `false`.
        :param pulumi.Input[str] data_node_disk_performance_level: Cloud disk performance level. Valid values are `PL0`, `PL1`, `PL2`, `PL3`. The `data_node_disk_type` muse be `cloud_essd`.
        :param pulumi.Input[str] description: The description of instance. It a string of 0 to 30 characters.
        :param pulumi.Input[bool] enable_kibana_private_network: Bool, default to false. When it set to true, the instance can close kibana private network access。
        :param pulumi.Input[bool] enable_kibana_public_network: Bool, default to true. When it set to false, the instance can enable kibana public network access。
        :param pulumi.Input[bool] enable_public: Bool, default to false. When it set to true, the instance can enable public network access。
        :param pulumi.Input[str] instance_charge_type: Valid values are `PrePaid`, `PostPaid`. Default to `PostPaid`. From version 1.69.0, the Elasticsearch cluster allows you to update your instance_charge_ype from `PostPaid` to `PrePaid`, the following attributes are required: `period`. But, updating from `PostPaid` to `PrePaid` is not supported.
        :param pulumi.Input[str] kibana_node_spec: The kibana node specifications of the Elasticsearch instance. Default is `elasticsearch.n4.small`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kibana_private_whitelists: Set the Kibana's IP whitelist in private network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kibana_whitelists: Set the Kibana's IP whitelist in internet network.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored, but you have to specify one of `password` and `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[str] master_node_disk_type: The single master node storage space. Valid values are `PrePaid`, `PostPaid`.
        :param pulumi.Input[str] master_node_spec: The dedicated master node spec. If specified, dedicated master node will be created.
        :param pulumi.Input[str] password: The password of the instance. The password can be 8 to 30 characters in length and must contain three of the following conditions: uppercase letters, lowercase letters, numbers, and special characters (`!@#$%^&*()_+-=`).
        :param pulumi.Input[int] period: The duration that you will buy Elasticsearch instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1. From version 1.69.2, when to modify this value, the resource can renewal a `PrePaid` instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_whitelists: Set the instance's IP whitelist in VPC network.
        :param pulumi.Input[str] protocol: Elasticsearch protocol. Supported values: `HTTP`, `HTTPS`.default is `HTTP`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_whitelists: Set the instance's IP whitelist in internet network.
        :param pulumi.Input[str] renew_status: The renewal status of the specified instance. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`.The `instance_charge_type` must be `PrePaid`.
        :param pulumi.Input[str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `M`, `Y`.
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the Elasticsearch instance belongs.
        :param pulumi.Input[Mapping[str, Any]] setting_config: The YML configuration of the instance.[Detailed introduction](https://www.alibabacloud.com/help/doc-detail/61336.html).
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] zone_count: The Multi-AZ supported for Elasticsearch, between 1 and 3. The `data_node_amount` value must be an integral multiple of the `zone_count` value.
        """
        pulumi.set(__self__, "data_node_amount", data_node_amount)
        pulumi.set(__self__, "data_node_disk_size", data_node_disk_size)
        pulumi.set(__self__, "data_node_disk_type", data_node_disk_type)
        pulumi.set(__self__, "data_node_spec", data_node_spec)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if client_node_amount is not None:
            pulumi.set(__self__, "client_node_amount", client_node_amount)
        if client_node_spec is not None:
            pulumi.set(__self__, "client_node_spec", client_node_spec)
        if data_node_disk_encrypted is not None:
            pulumi.set(__self__, "data_node_disk_encrypted", data_node_disk_encrypted)
        if data_node_disk_performance_level is not None:
            pulumi.set(__self__, "data_node_disk_performance_level", data_node_disk_performance_level)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_kibana_private_network is not None:
            pulumi.set(__self__, "enable_kibana_private_network", enable_kibana_private_network)
        if enable_kibana_public_network is not None:
            pulumi.set(__self__, "enable_kibana_public_network", enable_kibana_public_network)
        if enable_public is not None:
            pulumi.set(__self__, "enable_public", enable_public)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if kibana_node_spec is not None:
            pulumi.set(__self__, "kibana_node_spec", kibana_node_spec)
        if kibana_private_whitelists is not None:
            pulumi.set(__self__, "kibana_private_whitelists", kibana_private_whitelists)
        if kibana_whitelists is not None:
            pulumi.set(__self__, "kibana_whitelists", kibana_whitelists)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if master_node_disk_type is not None:
            pulumi.set(__self__, "master_node_disk_type", master_node_disk_type)
        if master_node_spec is not None:
            pulumi.set(__self__, "master_node_spec", master_node_spec)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if private_whitelists is not None:
            pulumi.set(__self__, "private_whitelists", private_whitelists)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if public_whitelists is not None:
            pulumi.set(__self__, "public_whitelists", public_whitelists)
        if renew_status is not None:
            pulumi.set(__self__, "renew_status", renew_status)
        if renewal_duration_unit is not None:
            pulumi.set(__self__, "renewal_duration_unit", renewal_duration_unit)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if setting_config is not None:
            pulumi.set(__self__, "setting_config", setting_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter(name="dataNodeAmount")
    def data_node_amount(self) -> pulumi.Input[int]:
        """
        The Elasticsearch cluster's data node quantity, between 2 and 50.
        """
        return pulumi.get(self, "data_node_amount")

    @data_node_amount.setter
    def data_node_amount(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_node_amount", value)

    @property
    @pulumi.getter(name="dataNodeDiskSize")
    def data_node_disk_size(self) -> pulumi.Input[int]:
        """
        The single data node storage space.
        """
        return pulumi.get(self, "data_node_disk_size")

    @data_node_disk_size.setter
    def data_node_disk_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "data_node_disk_size", value)

    @property
    @pulumi.getter(name="dataNodeDiskType")
    def data_node_disk_type(self) -> pulumi.Input[str]:
        """
        The data node disk type. Supported values: cloud_ssd, cloud_efficiency.
        """
        return pulumi.get(self, "data_node_disk_type")

    @data_node_disk_type.setter
    def data_node_disk_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_node_disk_type", value)

    @property
    @pulumi.getter(name="dataNodeSpec")
    def data_node_spec(self) -> pulumi.Input[str]:
        """
        The data node specifications of the Elasticsearch instance.
        """
        return pulumi.get(self, "data_node_spec")

    @data_node_spec.setter
    def data_node_spec(self, value: pulumi.Input[str]):
        pulumi.set(self, "data_node_spec", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Elasticsearch version. Supported values: `5.5.3_with_X-Pack`, `6.3_with_X-Pack`, `6.7_with_X-Pack`, `6.8_with_X-Pack`, `7.4_with_X-Pack` and `7.7_with_X-Pack`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[str]:
        """
        The ID of VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Auto-renewal period of an Elasticsearch Instance, in the unit of the month. It is valid when `instance_charge_type` is `PrePaid` and `renew_status` is `AutoRenewal`.
        """
        return pulumi.get(self, "auto_renew_duration")

    @auto_renew_duration.setter
    def auto_renew_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_duration", value)

    @property
    @pulumi.getter(name="clientNodeAmount")
    def client_node_amount(self) -> Optional[pulumi.Input[int]]:
        """
        The Elasticsearch cluster's client node quantity, between 2 and 25.
        """
        return pulumi.get(self, "client_node_amount")

    @client_node_amount.setter
    def client_node_amount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "client_node_amount", value)

    @property
    @pulumi.getter(name="clientNodeSpec")
    def client_node_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The client node spec. If specified, client node will be created.
        """
        return pulumi.get(self, "client_node_spec")

    @client_node_spec.setter
    def client_node_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_node_spec", value)

    @property
    @pulumi.getter(name="dataNodeDiskEncrypted")
    def data_node_disk_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        If encrypt the data node disk. Valid values are `true`, `false`. Default to `false`.
        """
        return pulumi.get(self, "data_node_disk_encrypted")

    @data_node_disk_encrypted.setter
    def data_node_disk_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "data_node_disk_encrypted", value)

    @property
    @pulumi.getter(name="dataNodeDiskPerformanceLevel")
    def data_node_disk_performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud disk performance level. Valid values are `PL0`, `PL1`, `PL2`, `PL3`. The `data_node_disk_type` muse be `cloud_essd`.
        """
        return pulumi.get(self, "data_node_disk_performance_level")

    @data_node_disk_performance_level.setter
    def data_node_disk_performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_node_disk_performance_level", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of instance. It a string of 0 to 30 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableKibanaPrivateNetwork")
    def enable_kibana_private_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Bool, default to false. When it set to true, the instance can close kibana private network access。
        """
        return pulumi.get(self, "enable_kibana_private_network")

    @enable_kibana_private_network.setter
    def enable_kibana_private_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_kibana_private_network", value)

    @property
    @pulumi.getter(name="enableKibanaPublicNetwork")
    def enable_kibana_public_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Bool, default to true. When it set to false, the instance can enable kibana public network access。
        """
        return pulumi.get(self, "enable_kibana_public_network")

    @enable_kibana_public_network.setter
    def enable_kibana_public_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_kibana_public_network", value)

    @property
    @pulumi.getter(name="enablePublic")
    def enable_public(self) -> Optional[pulumi.Input[bool]]:
        """
        Bool, default to false. When it set to true, the instance can enable public network access。
        """
        return pulumi.get(self, "enable_public")

    @enable_public.setter
    def enable_public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_public", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values are `PrePaid`, `PostPaid`. Default to `PostPaid`. From version 1.69.0, the Elasticsearch cluster allows you to update your instance_charge_ype from `PostPaid` to `PrePaid`, the following attributes are required: `period`. But, updating from `PostPaid` to `PrePaid` is not supported.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="kibanaNodeSpec")
    def kibana_node_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The kibana node specifications of the Elasticsearch instance. Default is `elasticsearch.n4.small`.
        """
        return pulumi.get(self, "kibana_node_spec")

    @kibana_node_spec.setter
    def kibana_node_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kibana_node_spec", value)

    @property
    @pulumi.getter(name="kibanaPrivateWhitelists")
    def kibana_private_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set the Kibana's IP whitelist in private network.
        """
        return pulumi.get(self, "kibana_private_whitelists")

    @kibana_private_whitelists.setter
    def kibana_private_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kibana_private_whitelists", value)

    @property
    @pulumi.getter(name="kibanaWhitelists")
    def kibana_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set the Kibana's IP whitelist in internet network.
        """
        return pulumi.get(self, "kibana_whitelists")

    @kibana_whitelists.setter
    def kibana_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kibana_whitelists", value)

    @property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[str]]:
        """
        An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored, but you have to specify one of `password` and `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @property
    @pulumi.getter(name="masterNodeDiskType")
    def master_node_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The single master node storage space. Valid values are `PrePaid`, `PostPaid`.
        """
        return pulumi.get(self, "master_node_disk_type")

    @master_node_disk_type.setter
    def master_node_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_node_disk_type", value)

    @property
    @pulumi.getter(name="masterNodeSpec")
    def master_node_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The dedicated master node spec. If specified, dedicated master node will be created.
        """
        return pulumi.get(self, "master_node_spec")

    @master_node_spec.setter
    def master_node_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_node_spec", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the instance. The password can be 8 to 30 characters in length and must contain three of the following conditions: uppercase letters, lowercase letters, numbers, and special characters (`!@#$%^&*()_+-=`).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration that you will buy Elasticsearch instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1. From version 1.69.2, when to modify this value, the resource can renewal a `PrePaid` instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="privateWhitelists")
    def private_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set the instance's IP whitelist in VPC network.
        """
        return pulumi.get(self, "private_whitelists")

    @private_whitelists.setter
    def private_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_whitelists", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Elasticsearch protocol. Supported values: `HTTP`, `HTTPS`.default is `HTTP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="publicWhitelists")
    def public_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set the instance's IP whitelist in internet network.
        """
        return pulumi.get(self, "public_whitelists")

    @public_whitelists.setter
    def public_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_whitelists", value)

    @property
    @pulumi.getter(name="renewStatus")
    def renew_status(self) -> Optional[pulumi.Input[str]]:
        """
        The renewal status of the specified instance. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`.The `instance_charge_type` must be `PrePaid`.
        """
        return pulumi.get(self, "renew_status")

    @renew_status.setter
    def renew_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renew_status", value)

    @property
    @pulumi.getter(name="renewalDurationUnit")
    def renewal_duration_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `M`, `Y`.
        """
        return pulumi.get(self, "renewal_duration_unit")

    @renewal_duration_unit.setter
    def renewal_duration_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renewal_duration_unit", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of resource group which the Elasticsearch instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="settingConfig")
    def setting_config(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The YML configuration of the instance.[Detailed introduction](https://www.alibabacloud.com/help/doc-detail/61336.html).
        """
        return pulumi.get(self, "setting_config")

    @setting_config.setter
    def setting_config(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "setting_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[pulumi.Input[int]]:
        """
        The Multi-AZ supported for Elasticsearch, between 1 and 3. The `data_node_amount` value must be an integral multiple of the `zone_count` value.
        """
        return pulumi.get(self, "zone_count")

    @zone_count.setter
    def zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_count", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_renew_duration: Optional[pulumi.Input[int]] = None,
                 client_node_amount: Optional[pulumi.Input[int]] = None,
                 client_node_spec: Optional[pulumi.Input[str]] = None,
                 data_node_amount: Optional[pulumi.Input[int]] = None,
                 data_node_disk_encrypted: Optional[pulumi.Input[bool]] = None,
                 data_node_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 data_node_disk_size: Optional[pulumi.Input[int]] = None,
                 data_node_disk_type: Optional[pulumi.Input[str]] = None,
                 data_node_spec: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 enable_kibana_private_network: Optional[pulumi.Input[bool]] = None,
                 enable_kibana_public_network: Optional[pulumi.Input[bool]] = None,
                 enable_public: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 kibana_domain: Optional[pulumi.Input[str]] = None,
                 kibana_node_spec: Optional[pulumi.Input[str]] = None,
                 kibana_port: Optional[pulumi.Input[int]] = None,
                 kibana_private_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kibana_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 master_node_disk_type: Optional[pulumi.Input[str]] = None,
                 master_node_spec: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 private_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 public_domain: Optional[pulumi.Input[str]] = None,
                 public_port: Optional[pulumi.Input[int]] = None,
                 public_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 renew_status: Optional[pulumi.Input[str]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 setting_config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[int] auto_renew_duration: Auto-renewal period of an Elasticsearch Instance, in the unit of the month. It is valid when `instance_charge_type` is `PrePaid` and `renew_status` is `AutoRenewal`.
        :param pulumi.Input[int] client_node_amount: The Elasticsearch cluster's client node quantity, between 2 and 25.
        :param pulumi.Input[str] client_node_spec: The client node spec. If specified, client node will be created.
        :param pulumi.Input[int] data_node_amount: The Elasticsearch cluster's data node quantity, between 2 and 50.
        :param pulumi.Input[bool] data_node_disk_encrypted: If encrypt the data node disk. Valid values are `true`, `false`. Default to `false`.
        :param pulumi.Input[str] data_node_disk_performance_level: Cloud disk performance level. Valid values are `PL0`, `PL1`, `PL2`, `PL3`. The `data_node_disk_type` muse be `cloud_essd`.
        :param pulumi.Input[int] data_node_disk_size: The single data node storage space.
        :param pulumi.Input[str] data_node_disk_type: The data node disk type. Supported values: cloud_ssd, cloud_efficiency.
        :param pulumi.Input[str] data_node_spec: The data node specifications of the Elasticsearch instance.
        :param pulumi.Input[str] description: The description of instance. It a string of 0 to 30 characters.
        :param pulumi.Input[str] domain: Instance connection domain (only VPC network access supported).
        :param pulumi.Input[bool] enable_kibana_private_network: Bool, default to false. When it set to true, the instance can close kibana private network access。
        :param pulumi.Input[bool] enable_kibana_public_network: Bool, default to true. When it set to false, the instance can enable kibana public network access。
        :param pulumi.Input[bool] enable_public: Bool, default to false. When it set to true, the instance can enable public network access。
        :param pulumi.Input[str] instance_charge_type: Valid values are `PrePaid`, `PostPaid`. Default to `PostPaid`. From version 1.69.0, the Elasticsearch cluster allows you to update your instance_charge_ype from `PostPaid` to `PrePaid`, the following attributes are required: `period`. But, updating from `PostPaid` to `PrePaid` is not supported.
        :param pulumi.Input[str] kibana_domain: Kibana console domain (Internet access supported).
        :param pulumi.Input[str] kibana_node_spec: The kibana node specifications of the Elasticsearch instance. Default is `elasticsearch.n4.small`.
        :param pulumi.Input[int] kibana_port: Kibana console port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kibana_private_whitelists: Set the Kibana's IP whitelist in private network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kibana_whitelists: Set the Kibana's IP whitelist in internet network.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored, but you have to specify one of `password` and `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[str] master_node_disk_type: The single master node storage space. Valid values are `PrePaid`, `PostPaid`.
        :param pulumi.Input[str] master_node_spec: The dedicated master node spec. If specified, dedicated master node will be created.
        :param pulumi.Input[str] password: The password of the instance. The password can be 8 to 30 characters in length and must contain three of the following conditions: uppercase letters, lowercase letters, numbers, and special characters (`!@#$%^&*()_+-=`).
        :param pulumi.Input[int] period: The duration that you will buy Elasticsearch instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1. From version 1.69.2, when to modify this value, the resource can renewal a `PrePaid` instance.
        :param pulumi.Input[int] port: Instance connection port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_whitelists: Set the instance's IP whitelist in VPC network.
        :param pulumi.Input[str] protocol: Elasticsearch protocol. Supported values: `HTTP`, `HTTPS`.default is `HTTP`.
        :param pulumi.Input[str] public_domain: Instance connection public domain.
        :param pulumi.Input[int] public_port: Instance connection public port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_whitelists: Set the instance's IP whitelist in internet network.
        :param pulumi.Input[str] renew_status: The renewal status of the specified instance. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`.The `instance_charge_type` must be `PrePaid`.
        :param pulumi.Input[str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `M`, `Y`.
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the Elasticsearch instance belongs.
        :param pulumi.Input[Mapping[str, Any]] setting_config: The YML configuration of the instance.[Detailed introduction](https://www.alibabacloud.com/help/doc-detail/61336.html).
        :param pulumi.Input[str] status: The Elasticsearch instance status. Includes `active`, `activating`, `inactive`. Some operations are denied when status is not `active`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] version: Elasticsearch version. Supported values: `5.5.3_with_X-Pack`, `6.3_with_X-Pack`, `6.7_with_X-Pack`, `6.8_with_X-Pack`, `7.4_with_X-Pack` and `7.7_with_X-Pack`.
        :param pulumi.Input[str] vswitch_id: The ID of VSwitch.
        :param pulumi.Input[int] zone_count: The Multi-AZ supported for Elasticsearch, between 1 and 3. The `data_node_amount` value must be an integral multiple of the `zone_count` value.
        """
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if client_node_amount is not None:
            pulumi.set(__self__, "client_node_amount", client_node_amount)
        if client_node_spec is not None:
            pulumi.set(__self__, "client_node_spec", client_node_spec)
        if data_node_amount is not None:
            pulumi.set(__self__, "data_node_amount", data_node_amount)
        if data_node_disk_encrypted is not None:
            pulumi.set(__self__, "data_node_disk_encrypted", data_node_disk_encrypted)
        if data_node_disk_performance_level is not None:
            pulumi.set(__self__, "data_node_disk_performance_level", data_node_disk_performance_level)
        if data_node_disk_size is not None:
            pulumi.set(__self__, "data_node_disk_size", data_node_disk_size)
        if data_node_disk_type is not None:
            pulumi.set(__self__, "data_node_disk_type", data_node_disk_type)
        if data_node_spec is not None:
            pulumi.set(__self__, "data_node_spec", data_node_spec)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if enable_kibana_private_network is not None:
            pulumi.set(__self__, "enable_kibana_private_network", enable_kibana_private_network)
        if enable_kibana_public_network is not None:
            pulumi.set(__self__, "enable_kibana_public_network", enable_kibana_public_network)
        if enable_public is not None:
            pulumi.set(__self__, "enable_public", enable_public)
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if kibana_domain is not None:
            pulumi.set(__self__, "kibana_domain", kibana_domain)
        if kibana_node_spec is not None:
            pulumi.set(__self__, "kibana_node_spec", kibana_node_spec)
        if kibana_port is not None:
            pulumi.set(__self__, "kibana_port", kibana_port)
        if kibana_private_whitelists is not None:
            pulumi.set(__self__, "kibana_private_whitelists", kibana_private_whitelists)
        if kibana_whitelists is not None:
            pulumi.set(__self__, "kibana_whitelists", kibana_whitelists)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if master_node_disk_type is not None:
            pulumi.set(__self__, "master_node_disk_type", master_node_disk_type)
        if master_node_spec is not None:
            pulumi.set(__self__, "master_node_spec", master_node_spec)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_whitelists is not None:
            pulumi.set(__self__, "private_whitelists", private_whitelists)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if public_domain is not None:
            pulumi.set(__self__, "public_domain", public_domain)
        if public_port is not None:
            pulumi.set(__self__, "public_port", public_port)
        if public_whitelists is not None:
            pulumi.set(__self__, "public_whitelists", public_whitelists)
        if renew_status is not None:
            pulumi.set(__self__, "renew_status", renew_status)
        if renewal_duration_unit is not None:
            pulumi.set(__self__, "renewal_duration_unit", renewal_duration_unit)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if setting_config is not None:
            pulumi.set(__self__, "setting_config", setting_config)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[pulumi.Input[int]]:
        """
        Auto-renewal period of an Elasticsearch Instance, in the unit of the month. It is valid when `instance_charge_type` is `PrePaid` and `renew_status` is `AutoRenewal`.
        """
        return pulumi.get(self, "auto_renew_duration")

    @auto_renew_duration.setter
    def auto_renew_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_duration", value)

    @property
    @pulumi.getter(name="clientNodeAmount")
    def client_node_amount(self) -> Optional[pulumi.Input[int]]:
        """
        The Elasticsearch cluster's client node quantity, between 2 and 25.
        """
        return pulumi.get(self, "client_node_amount")

    @client_node_amount.setter
    def client_node_amount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "client_node_amount", value)

    @property
    @pulumi.getter(name="clientNodeSpec")
    def client_node_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The client node spec. If specified, client node will be created.
        """
        return pulumi.get(self, "client_node_spec")

    @client_node_spec.setter
    def client_node_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_node_spec", value)

    @property
    @pulumi.getter(name="dataNodeAmount")
    def data_node_amount(self) -> Optional[pulumi.Input[int]]:
        """
        The Elasticsearch cluster's data node quantity, between 2 and 50.
        """
        return pulumi.get(self, "data_node_amount")

    @data_node_amount.setter
    def data_node_amount(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_node_amount", value)

    @property
    @pulumi.getter(name="dataNodeDiskEncrypted")
    def data_node_disk_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        If encrypt the data node disk. Valid values are `true`, `false`. Default to `false`.
        """
        return pulumi.get(self, "data_node_disk_encrypted")

    @data_node_disk_encrypted.setter
    def data_node_disk_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "data_node_disk_encrypted", value)

    @property
    @pulumi.getter(name="dataNodeDiskPerformanceLevel")
    def data_node_disk_performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud disk performance level. Valid values are `PL0`, `PL1`, `PL2`, `PL3`. The `data_node_disk_type` muse be `cloud_essd`.
        """
        return pulumi.get(self, "data_node_disk_performance_level")

    @data_node_disk_performance_level.setter
    def data_node_disk_performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_node_disk_performance_level", value)

    @property
    @pulumi.getter(name="dataNodeDiskSize")
    def data_node_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The single data node storage space.
        """
        return pulumi.get(self, "data_node_disk_size")

    @data_node_disk_size.setter
    def data_node_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_node_disk_size", value)

    @property
    @pulumi.getter(name="dataNodeDiskType")
    def data_node_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The data node disk type. Supported values: cloud_ssd, cloud_efficiency.
        """
        return pulumi.get(self, "data_node_disk_type")

    @data_node_disk_type.setter
    def data_node_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_node_disk_type", value)

    @property
    @pulumi.getter(name="dataNodeSpec")
    def data_node_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The data node specifications of the Elasticsearch instance.
        """
        return pulumi.get(self, "data_node_spec")

    @data_node_spec.setter
    def data_node_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_node_spec", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of instance. It a string of 0 to 30 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        Instance connection domain (only VPC network access supported).
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="enableKibanaPrivateNetwork")
    def enable_kibana_private_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Bool, default to false. When it set to true, the instance can close kibana private network access。
        """
        return pulumi.get(self, "enable_kibana_private_network")

    @enable_kibana_private_network.setter
    def enable_kibana_private_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_kibana_private_network", value)

    @property
    @pulumi.getter(name="enableKibanaPublicNetwork")
    def enable_kibana_public_network(self) -> Optional[pulumi.Input[bool]]:
        """
        Bool, default to true. When it set to false, the instance can enable kibana public network access。
        """
        return pulumi.get(self, "enable_kibana_public_network")

    @enable_kibana_public_network.setter
    def enable_kibana_public_network(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_kibana_public_network", value)

    @property
    @pulumi.getter(name="enablePublic")
    def enable_public(self) -> Optional[pulumi.Input[bool]]:
        """
        Bool, default to false. When it set to true, the instance can enable public network access。
        """
        return pulumi.get(self, "enable_public")

    @enable_public.setter
    def enable_public(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_public", value)

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values are `PrePaid`, `PostPaid`. Default to `PostPaid`. From version 1.69.0, the Elasticsearch cluster allows you to update your instance_charge_ype from `PostPaid` to `PrePaid`, the following attributes are required: `period`. But, updating from `PostPaid` to `PrePaid` is not supported.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_type", value)

    @property
    @pulumi.getter(name="kibanaDomain")
    def kibana_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Kibana console domain (Internet access supported).
        """
        return pulumi.get(self, "kibana_domain")

    @kibana_domain.setter
    def kibana_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kibana_domain", value)

    @property
    @pulumi.getter(name="kibanaNodeSpec")
    def kibana_node_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The kibana node specifications of the Elasticsearch instance. Default is `elasticsearch.n4.small`.
        """
        return pulumi.get(self, "kibana_node_spec")

    @kibana_node_spec.setter
    def kibana_node_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kibana_node_spec", value)

    @property
    @pulumi.getter(name="kibanaPort")
    def kibana_port(self) -> Optional[pulumi.Input[int]]:
        """
        Kibana console port.
        """
        return pulumi.get(self, "kibana_port")

    @kibana_port.setter
    def kibana_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "kibana_port", value)

    @property
    @pulumi.getter(name="kibanaPrivateWhitelists")
    def kibana_private_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set the Kibana's IP whitelist in private network.
        """
        return pulumi.get(self, "kibana_private_whitelists")

    @kibana_private_whitelists.setter
    def kibana_private_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kibana_private_whitelists", value)

    @property
    @pulumi.getter(name="kibanaWhitelists")
    def kibana_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set the Kibana's IP whitelist in internet network.
        """
        return pulumi.get(self, "kibana_whitelists")

    @kibana_whitelists.setter
    def kibana_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kibana_whitelists", value)

    @property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[str]]:
        """
        An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored, but you have to specify one of `password` and `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @property
    @pulumi.getter(name="masterNodeDiskType")
    def master_node_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The single master node storage space. Valid values are `PrePaid`, `PostPaid`.
        """
        return pulumi.get(self, "master_node_disk_type")

    @master_node_disk_type.setter
    def master_node_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_node_disk_type", value)

    @property
    @pulumi.getter(name="masterNodeSpec")
    def master_node_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The dedicated master node spec. If specified, dedicated master node will be created.
        """
        return pulumi.get(self, "master_node_spec")

    @master_node_spec.setter
    def master_node_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_node_spec", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the instance. The password can be 8 to 30 characters in length and must contain three of the following conditions: uppercase letters, lowercase letters, numbers, and special characters (`!@#$%^&*()_+-=`).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration that you will buy Elasticsearch instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1. From version 1.69.2, when to modify this value, the resource can renewal a `PrePaid` instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Instance connection port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateWhitelists")
    def private_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set the instance's IP whitelist in VPC network.
        """
        return pulumi.get(self, "private_whitelists")

    @private_whitelists.setter
    def private_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_whitelists", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Elasticsearch protocol. Supported values: `HTTP`, `HTTPS`.default is `HTTP`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="publicDomain")
    def public_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Instance connection public domain.
        """
        return pulumi.get(self, "public_domain")

    @public_domain.setter
    def public_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_domain", value)

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> Optional[pulumi.Input[int]]:
        """
        Instance connection public port.
        """
        return pulumi.get(self, "public_port")

    @public_port.setter
    def public_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "public_port", value)

    @property
    @pulumi.getter(name="publicWhitelists")
    def public_whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set the instance's IP whitelist in internet network.
        """
        return pulumi.get(self, "public_whitelists")

    @public_whitelists.setter
    def public_whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_whitelists", value)

    @property
    @pulumi.getter(name="renewStatus")
    def renew_status(self) -> Optional[pulumi.Input[str]]:
        """
        The renewal status of the specified instance. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`.The `instance_charge_type` must be `PrePaid`.
        """
        return pulumi.get(self, "renew_status")

    @renew_status.setter
    def renew_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renew_status", value)

    @property
    @pulumi.getter(name="renewalDurationUnit")
    def renewal_duration_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `M`, `Y`.
        """
        return pulumi.get(self, "renewal_duration_unit")

    @renewal_duration_unit.setter
    def renewal_duration_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renewal_duration_unit", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of resource group which the Elasticsearch instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="settingConfig")
    def setting_config(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        The YML configuration of the instance.[Detailed introduction](https://www.alibabacloud.com/help/doc-detail/61336.html).
        """
        return pulumi.get(self, "setting_config")

    @setting_config.setter
    def setting_config(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "setting_config", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The Elasticsearch instance status. Includes `active`, `activating`, `inactive`. Some operations are denied when status is not `active`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Elasticsearch version. Supported values: `5.5.3_with_X-Pack`, `6.3_with_X-Pack`, `6.7_with_X-Pack`, `6.8_with_X-Pack`, `7.4_with_X-Pack` and `7.7_with_X-Pack`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[pulumi.Input[int]]:
        """
        The Multi-AZ supported for Elasticsearch, between 1 and 3. The `data_node_amount` value must be an integral multiple of the `zone_count` value.
        """
        return pulumi.get(self, "zone_count")

    @zone_count.setter
    def zone_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "zone_count", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew_duration: Optional[pulumi.Input[int]] = None,
                 client_node_amount: Optional[pulumi.Input[int]] = None,
                 client_node_spec: Optional[pulumi.Input[str]] = None,
                 data_node_amount: Optional[pulumi.Input[int]] = None,
                 data_node_disk_encrypted: Optional[pulumi.Input[bool]] = None,
                 data_node_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 data_node_disk_size: Optional[pulumi.Input[int]] = None,
                 data_node_disk_type: Optional[pulumi.Input[str]] = None,
                 data_node_spec: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_kibana_private_network: Optional[pulumi.Input[bool]] = None,
                 enable_kibana_public_network: Optional[pulumi.Input[bool]] = None,
                 enable_public: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 kibana_node_spec: Optional[pulumi.Input[str]] = None,
                 kibana_private_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kibana_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 master_node_disk_type: Optional[pulumi.Input[str]] = None,
                 master_node_spec: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 private_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 public_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 renew_status: Optional[pulumi.Input[str]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 setting_config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        ## Import

        Elasticsearch can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:elasticsearch/instance:Instance example es-cn-abcde123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] auto_renew_duration: Auto-renewal period of an Elasticsearch Instance, in the unit of the month. It is valid when `instance_charge_type` is `PrePaid` and `renew_status` is `AutoRenewal`.
        :param pulumi.Input[int] client_node_amount: The Elasticsearch cluster's client node quantity, between 2 and 25.
        :param pulumi.Input[str] client_node_spec: The client node spec. If specified, client node will be created.
        :param pulumi.Input[int] data_node_amount: The Elasticsearch cluster's data node quantity, between 2 and 50.
        :param pulumi.Input[bool] data_node_disk_encrypted: If encrypt the data node disk. Valid values are `true`, `false`. Default to `false`.
        :param pulumi.Input[str] data_node_disk_performance_level: Cloud disk performance level. Valid values are `PL0`, `PL1`, `PL2`, `PL3`. The `data_node_disk_type` muse be `cloud_essd`.
        :param pulumi.Input[int] data_node_disk_size: The single data node storage space.
        :param pulumi.Input[str] data_node_disk_type: The data node disk type. Supported values: cloud_ssd, cloud_efficiency.
        :param pulumi.Input[str] data_node_spec: The data node specifications of the Elasticsearch instance.
        :param pulumi.Input[str] description: The description of instance. It a string of 0 to 30 characters.
        :param pulumi.Input[bool] enable_kibana_private_network: Bool, default to false. When it set to true, the instance can close kibana private network access。
        :param pulumi.Input[bool] enable_kibana_public_network: Bool, default to true. When it set to false, the instance can enable kibana public network access。
        :param pulumi.Input[bool] enable_public: Bool, default to false. When it set to true, the instance can enable public network access。
        :param pulumi.Input[str] instance_charge_type: Valid values are `PrePaid`, `PostPaid`. Default to `PostPaid`. From version 1.69.0, the Elasticsearch cluster allows you to update your instance_charge_ype from `PostPaid` to `PrePaid`, the following attributes are required: `period`. But, updating from `PostPaid` to `PrePaid` is not supported.
        :param pulumi.Input[str] kibana_node_spec: The kibana node specifications of the Elasticsearch instance. Default is `elasticsearch.n4.small`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kibana_private_whitelists: Set the Kibana's IP whitelist in private network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kibana_whitelists: Set the Kibana's IP whitelist in internet network.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored, but you have to specify one of `password` and `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[str] master_node_disk_type: The single master node storage space. Valid values are `PrePaid`, `PostPaid`.
        :param pulumi.Input[str] master_node_spec: The dedicated master node spec. If specified, dedicated master node will be created.
        :param pulumi.Input[str] password: The password of the instance. The password can be 8 to 30 characters in length and must contain three of the following conditions: uppercase letters, lowercase letters, numbers, and special characters (`!@#$%^&*()_+-=`).
        :param pulumi.Input[int] period: The duration that you will buy Elasticsearch instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1. From version 1.69.2, when to modify this value, the resource can renewal a `PrePaid` instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_whitelists: Set the instance's IP whitelist in VPC network.
        :param pulumi.Input[str] protocol: Elasticsearch protocol. Supported values: `HTTP`, `HTTPS`.default is `HTTP`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_whitelists: Set the instance's IP whitelist in internet network.
        :param pulumi.Input[str] renew_status: The renewal status of the specified instance. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`.The `instance_charge_type` must be `PrePaid`.
        :param pulumi.Input[str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `M`, `Y`.
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the Elasticsearch instance belongs.
        :param pulumi.Input[Mapping[str, Any]] setting_config: The YML configuration of the instance.[Detailed introduction](https://www.alibabacloud.com/help/doc-detail/61336.html).
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] version: Elasticsearch version. Supported values: `5.5.3_with_X-Pack`, `6.3_with_X-Pack`, `6.7_with_X-Pack`, `6.8_with_X-Pack`, `7.4_with_X-Pack` and `7.7_with_X-Pack`.
        :param pulumi.Input[str] vswitch_id: The ID of VSwitch.
        :param pulumi.Input[int] zone_count: The Multi-AZ supported for Elasticsearch, between 1 and 3. The `data_node_amount` value must be an integral multiple of the `zone_count` value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Elasticsearch can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:elasticsearch/instance:Instance example es-cn-abcde123456
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew_duration: Optional[pulumi.Input[int]] = None,
                 client_node_amount: Optional[pulumi.Input[int]] = None,
                 client_node_spec: Optional[pulumi.Input[str]] = None,
                 data_node_amount: Optional[pulumi.Input[int]] = None,
                 data_node_disk_encrypted: Optional[pulumi.Input[bool]] = None,
                 data_node_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 data_node_disk_size: Optional[pulumi.Input[int]] = None,
                 data_node_disk_type: Optional[pulumi.Input[str]] = None,
                 data_node_spec: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_kibana_private_network: Optional[pulumi.Input[bool]] = None,
                 enable_kibana_public_network: Optional[pulumi.Input[bool]] = None,
                 enable_public: Optional[pulumi.Input[bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[str]] = None,
                 kibana_node_spec: Optional[pulumi.Input[str]] = None,
                 kibana_private_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kibana_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 master_node_disk_type: Optional[pulumi.Input[str]] = None,
                 master_node_spec: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 private_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 public_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 renew_status: Optional[pulumi.Input[str]] = None,
                 renewal_duration_unit: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 setting_config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 zone_count: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_renew_duration"] = auto_renew_duration
            __props__.__dict__["client_node_amount"] = client_node_amount
            __props__.__dict__["client_node_spec"] = client_node_spec
            if data_node_amount is None and not opts.urn:
                raise TypeError("Missing required property 'data_node_amount'")
            __props__.__dict__["data_node_amount"] = data_node_amount
            __props__.__dict__["data_node_disk_encrypted"] = data_node_disk_encrypted
            __props__.__dict__["data_node_disk_performance_level"] = data_node_disk_performance_level
            if data_node_disk_size is None and not opts.urn:
                raise TypeError("Missing required property 'data_node_disk_size'")
            __props__.__dict__["data_node_disk_size"] = data_node_disk_size
            if data_node_disk_type is None and not opts.urn:
                raise TypeError("Missing required property 'data_node_disk_type'")
            __props__.__dict__["data_node_disk_type"] = data_node_disk_type
            if data_node_spec is None and not opts.urn:
                raise TypeError("Missing required property 'data_node_spec'")
            __props__.__dict__["data_node_spec"] = data_node_spec
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_kibana_private_network"] = enable_kibana_private_network
            __props__.__dict__["enable_kibana_public_network"] = enable_kibana_public_network
            __props__.__dict__["enable_public"] = enable_public
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["kibana_node_spec"] = kibana_node_spec
            __props__.__dict__["kibana_private_whitelists"] = kibana_private_whitelists
            __props__.__dict__["kibana_whitelists"] = kibana_whitelists
            __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
            __props__.__dict__["kms_encryption_context"] = kms_encryption_context
            __props__.__dict__["master_node_disk_type"] = master_node_disk_type
            __props__.__dict__["master_node_spec"] = master_node_spec
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["period"] = period
            __props__.__dict__["private_whitelists"] = private_whitelists
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["public_whitelists"] = public_whitelists
            __props__.__dict__["renew_status"] = renew_status
            __props__.__dict__["renewal_duration_unit"] = renewal_duration_unit
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["setting_config"] = setting_config
            __props__.__dict__["tags"] = tags
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["zone_count"] = zone_count
            __props__.__dict__["domain"] = None
            __props__.__dict__["kibana_domain"] = None
            __props__.__dict__["kibana_port"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["public_domain"] = None
            __props__.__dict__["public_port"] = None
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'alicloud:elasticsearch/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew_duration: Optional[pulumi.Input[int]] = None,
            client_node_amount: Optional[pulumi.Input[int]] = None,
            client_node_spec: Optional[pulumi.Input[str]] = None,
            data_node_amount: Optional[pulumi.Input[int]] = None,
            data_node_disk_encrypted: Optional[pulumi.Input[bool]] = None,
            data_node_disk_performance_level: Optional[pulumi.Input[str]] = None,
            data_node_disk_size: Optional[pulumi.Input[int]] = None,
            data_node_disk_type: Optional[pulumi.Input[str]] = None,
            data_node_spec: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            enable_kibana_private_network: Optional[pulumi.Input[bool]] = None,
            enable_kibana_public_network: Optional[pulumi.Input[bool]] = None,
            enable_public: Optional[pulumi.Input[bool]] = None,
            instance_charge_type: Optional[pulumi.Input[str]] = None,
            kibana_domain: Optional[pulumi.Input[str]] = None,
            kibana_node_spec: Optional[pulumi.Input[str]] = None,
            kibana_port: Optional[pulumi.Input[int]] = None,
            kibana_private_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            kibana_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            kms_encrypted_password: Optional[pulumi.Input[str]] = None,
            kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            master_node_disk_type: Optional[pulumi.Input[str]] = None,
            master_node_spec: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            port: Optional[pulumi.Input[int]] = None,
            private_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            public_domain: Optional[pulumi.Input[str]] = None,
            public_port: Optional[pulumi.Input[int]] = None,
            public_whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            renew_status: Optional[pulumi.Input[str]] = None,
            renewal_duration_unit: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            setting_config: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            version: Optional[pulumi.Input[str]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            zone_count: Optional[pulumi.Input[int]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] auto_renew_duration: Auto-renewal period of an Elasticsearch Instance, in the unit of the month. It is valid when `instance_charge_type` is `PrePaid` and `renew_status` is `AutoRenewal`.
        :param pulumi.Input[int] client_node_amount: The Elasticsearch cluster's client node quantity, between 2 and 25.
        :param pulumi.Input[str] client_node_spec: The client node spec. If specified, client node will be created.
        :param pulumi.Input[int] data_node_amount: The Elasticsearch cluster's data node quantity, between 2 and 50.
        :param pulumi.Input[bool] data_node_disk_encrypted: If encrypt the data node disk. Valid values are `true`, `false`. Default to `false`.
        :param pulumi.Input[str] data_node_disk_performance_level: Cloud disk performance level. Valid values are `PL0`, `PL1`, `PL2`, `PL3`. The `data_node_disk_type` muse be `cloud_essd`.
        :param pulumi.Input[int] data_node_disk_size: The single data node storage space.
        :param pulumi.Input[str] data_node_disk_type: The data node disk type. Supported values: cloud_ssd, cloud_efficiency.
        :param pulumi.Input[str] data_node_spec: The data node specifications of the Elasticsearch instance.
        :param pulumi.Input[str] description: The description of instance. It a string of 0 to 30 characters.
        :param pulumi.Input[str] domain: Instance connection domain (only VPC network access supported).
        :param pulumi.Input[bool] enable_kibana_private_network: Bool, default to false. When it set to true, the instance can close kibana private network access。
        :param pulumi.Input[bool] enable_kibana_public_network: Bool, default to true. When it set to false, the instance can enable kibana public network access。
        :param pulumi.Input[bool] enable_public: Bool, default to false. When it set to true, the instance can enable public network access。
        :param pulumi.Input[str] instance_charge_type: Valid values are `PrePaid`, `PostPaid`. Default to `PostPaid`. From version 1.69.0, the Elasticsearch cluster allows you to update your instance_charge_ype from `PostPaid` to `PrePaid`, the following attributes are required: `period`. But, updating from `PostPaid` to `PrePaid` is not supported.
        :param pulumi.Input[str] kibana_domain: Kibana console domain (Internet access supported).
        :param pulumi.Input[str] kibana_node_spec: The kibana node specifications of the Elasticsearch instance. Default is `elasticsearch.n4.small`.
        :param pulumi.Input[int] kibana_port: Kibana console port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kibana_private_whitelists: Set the Kibana's IP whitelist in private network.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kibana_whitelists: Set the Kibana's IP whitelist in internet network.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored, but you have to specify one of `password` and `kms_encrypted_password` fields.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[str] master_node_disk_type: The single master node storage space. Valid values are `PrePaid`, `PostPaid`.
        :param pulumi.Input[str] master_node_spec: The dedicated master node spec. If specified, dedicated master node will be created.
        :param pulumi.Input[str] password: The password of the instance. The password can be 8 to 30 characters in length and must contain three of the following conditions: uppercase letters, lowercase letters, numbers, and special characters (`!@#$%^&*()_+-=`).
        :param pulumi.Input[int] period: The duration that you will buy Elasticsearch instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1. From version 1.69.2, when to modify this value, the resource can renewal a `PrePaid` instance.
        :param pulumi.Input[int] port: Instance connection port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_whitelists: Set the instance's IP whitelist in VPC network.
        :param pulumi.Input[str] protocol: Elasticsearch protocol. Supported values: `HTTP`, `HTTPS`.default is `HTTP`.
        :param pulumi.Input[str] public_domain: Instance connection public domain.
        :param pulumi.Input[int] public_port: Instance connection public port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_whitelists: Set the instance's IP whitelist in internet network.
        :param pulumi.Input[str] renew_status: The renewal status of the specified instance. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`.The `instance_charge_type` must be `PrePaid`.
        :param pulumi.Input[str] renewal_duration_unit: Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `M`, `Y`.
        :param pulumi.Input[str] resource_group_id: The ID of resource group which the Elasticsearch instance belongs.
        :param pulumi.Input[Mapping[str, Any]] setting_config: The YML configuration of the instance.[Detailed introduction](https://www.alibabacloud.com/help/doc-detail/61336.html).
        :param pulumi.Input[str] status: The Elasticsearch instance status. Includes `active`, `activating`, `inactive`. Some operations are denied when status is not `active`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[str] version: Elasticsearch version. Supported values: `5.5.3_with_X-Pack`, `6.3_with_X-Pack`, `6.7_with_X-Pack`, `6.8_with_X-Pack`, `7.4_with_X-Pack` and `7.7_with_X-Pack`.
        :param pulumi.Input[str] vswitch_id: The ID of VSwitch.
        :param pulumi.Input[int] zone_count: The Multi-AZ supported for Elasticsearch, between 1 and 3. The `data_node_amount` value must be an integral multiple of the `zone_count` value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_renew_duration"] = auto_renew_duration
        __props__.__dict__["client_node_amount"] = client_node_amount
        __props__.__dict__["client_node_spec"] = client_node_spec
        __props__.__dict__["data_node_amount"] = data_node_amount
        __props__.__dict__["data_node_disk_encrypted"] = data_node_disk_encrypted
        __props__.__dict__["data_node_disk_performance_level"] = data_node_disk_performance_level
        __props__.__dict__["data_node_disk_size"] = data_node_disk_size
        __props__.__dict__["data_node_disk_type"] = data_node_disk_type
        __props__.__dict__["data_node_spec"] = data_node_spec
        __props__.__dict__["description"] = description
        __props__.__dict__["domain"] = domain
        __props__.__dict__["enable_kibana_private_network"] = enable_kibana_private_network
        __props__.__dict__["enable_kibana_public_network"] = enable_kibana_public_network
        __props__.__dict__["enable_public"] = enable_public
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["kibana_domain"] = kibana_domain
        __props__.__dict__["kibana_node_spec"] = kibana_node_spec
        __props__.__dict__["kibana_port"] = kibana_port
        __props__.__dict__["kibana_private_whitelists"] = kibana_private_whitelists
        __props__.__dict__["kibana_whitelists"] = kibana_whitelists
        __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
        __props__.__dict__["kms_encryption_context"] = kms_encryption_context
        __props__.__dict__["master_node_disk_type"] = master_node_disk_type
        __props__.__dict__["master_node_spec"] = master_node_spec
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["port"] = port
        __props__.__dict__["private_whitelists"] = private_whitelists
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["public_domain"] = public_domain
        __props__.__dict__["public_port"] = public_port
        __props__.__dict__["public_whitelists"] = public_whitelists
        __props__.__dict__["renew_status"] = renew_status
        __props__.__dict__["renewal_duration_unit"] = renewal_duration_unit
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["setting_config"] = setting_config
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["zone_count"] = zone_count
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> pulumi.Output[Optional[int]]:
        """
        Auto-renewal period of an Elasticsearch Instance, in the unit of the month. It is valid when `instance_charge_type` is `PrePaid` and `renew_status` is `AutoRenewal`.
        """
        return pulumi.get(self, "auto_renew_duration")

    @property
    @pulumi.getter(name="clientNodeAmount")
    def client_node_amount(self) -> pulumi.Output[Optional[int]]:
        """
        The Elasticsearch cluster's client node quantity, between 2 and 25.
        """
        return pulumi.get(self, "client_node_amount")

    @property
    @pulumi.getter(name="clientNodeSpec")
    def client_node_spec(self) -> pulumi.Output[Optional[str]]:
        """
        The client node spec. If specified, client node will be created.
        """
        return pulumi.get(self, "client_node_spec")

    @property
    @pulumi.getter(name="dataNodeAmount")
    def data_node_amount(self) -> pulumi.Output[int]:
        """
        The Elasticsearch cluster's data node quantity, between 2 and 50.
        """
        return pulumi.get(self, "data_node_amount")

    @property
    @pulumi.getter(name="dataNodeDiskEncrypted")
    def data_node_disk_encrypted(self) -> pulumi.Output[Optional[bool]]:
        """
        If encrypt the data node disk. Valid values are `true`, `false`. Default to `false`.
        """
        return pulumi.get(self, "data_node_disk_encrypted")

    @property
    @pulumi.getter(name="dataNodeDiskPerformanceLevel")
    def data_node_disk_performance_level(self) -> pulumi.Output[Optional[str]]:
        """
        Cloud disk performance level. Valid values are `PL0`, `PL1`, `PL2`, `PL3`. The `data_node_disk_type` muse be `cloud_essd`.
        """
        return pulumi.get(self, "data_node_disk_performance_level")

    @property
    @pulumi.getter(name="dataNodeDiskSize")
    def data_node_disk_size(self) -> pulumi.Output[int]:
        """
        The single data node storage space.
        """
        return pulumi.get(self, "data_node_disk_size")

    @property
    @pulumi.getter(name="dataNodeDiskType")
    def data_node_disk_type(self) -> pulumi.Output[str]:
        """
        The data node disk type. Supported values: cloud_ssd, cloud_efficiency.
        """
        return pulumi.get(self, "data_node_disk_type")

    @property
    @pulumi.getter(name="dataNodeSpec")
    def data_node_spec(self) -> pulumi.Output[str]:
        """
        The data node specifications of the Elasticsearch instance.
        """
        return pulumi.get(self, "data_node_spec")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of instance. It a string of 0 to 30 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        Instance connection domain (only VPC network access supported).
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="enableKibanaPrivateNetwork")
    def enable_kibana_private_network(self) -> pulumi.Output[Optional[bool]]:
        """
        Bool, default to false. When it set to true, the instance can close kibana private network access。
        """
        return pulumi.get(self, "enable_kibana_private_network")

    @property
    @pulumi.getter(name="enableKibanaPublicNetwork")
    def enable_kibana_public_network(self) -> pulumi.Output[Optional[bool]]:
        """
        Bool, default to true. When it set to false, the instance can enable kibana public network access。
        """
        return pulumi.get(self, "enable_kibana_public_network")

    @property
    @pulumi.getter(name="enablePublic")
    def enable_public(self) -> pulumi.Output[Optional[bool]]:
        """
        Bool, default to false. When it set to true, the instance can enable public network access。
        """
        return pulumi.get(self, "enable_public")

    @property
    @pulumi.getter(name="instanceChargeType")
    def instance_charge_type(self) -> pulumi.Output[Optional[str]]:
        """
        Valid values are `PrePaid`, `PostPaid`. Default to `PostPaid`. From version 1.69.0, the Elasticsearch cluster allows you to update your instance_charge_ype from `PostPaid` to `PrePaid`, the following attributes are required: `period`. But, updating from `PostPaid` to `PrePaid` is not supported.
        """
        return pulumi.get(self, "instance_charge_type")

    @property
    @pulumi.getter(name="kibanaDomain")
    def kibana_domain(self) -> pulumi.Output[str]:
        """
        Kibana console domain (Internet access supported).
        """
        return pulumi.get(self, "kibana_domain")

    @property
    @pulumi.getter(name="kibanaNodeSpec")
    def kibana_node_spec(self) -> pulumi.Output[str]:
        """
        The kibana node specifications of the Elasticsearch instance. Default is `elasticsearch.n4.small`.
        """
        return pulumi.get(self, "kibana_node_spec")

    @property
    @pulumi.getter(name="kibanaPort")
    def kibana_port(self) -> pulumi.Output[int]:
        """
        Kibana console port.
        """
        return pulumi.get(self, "kibana_port")

    @property
    @pulumi.getter(name="kibanaPrivateWhitelists")
    def kibana_private_whitelists(self) -> pulumi.Output[Sequence[str]]:
        """
        Set the Kibana's IP whitelist in private network.
        """
        return pulumi.get(self, "kibana_private_whitelists")

    @property
    @pulumi.getter(name="kibanaWhitelists")
    def kibana_whitelists(self) -> pulumi.Output[Sequence[str]]:
        """
        Set the Kibana's IP whitelist in internet network.
        """
        return pulumi.get(self, "kibana_whitelists")

    @property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> pulumi.Output[Optional[str]]:
        """
        An KMS encrypts password used to an instance. If the `password` is filled in, this field will be ignored, but you have to specify one of `password` and `kms_encrypted_password` fields.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating instance with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @property
    @pulumi.getter(name="masterNodeDiskType")
    def master_node_disk_type(self) -> pulumi.Output[Optional[str]]:
        """
        The single master node storage space. Valid values are `PrePaid`, `PostPaid`.
        """
        return pulumi.get(self, "master_node_disk_type")

    @property
    @pulumi.getter(name="masterNodeSpec")
    def master_node_spec(self) -> pulumi.Output[Optional[str]]:
        """
        The dedicated master node spec. If specified, dedicated master node will be created.
        """
        return pulumi.get(self, "master_node_spec")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password of the instance. The password can be 8 to 30 characters in length and must contain three of the following conditions: uppercase letters, lowercase letters, numbers, and special characters (`!@#$%^&*()_+-=`).
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The duration that you will buy Elasticsearch instance (in month). It is valid when instance_charge_type is `PrePaid`. Valid values: [1~9], 12, 24, 36. Default to 1. From version 1.69.2, when to modify this value, the resource can renewal a `PrePaid` instance.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Instance connection port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateWhitelists")
    def private_whitelists(self) -> pulumi.Output[Sequence[str]]:
        """
        Set the instance's IP whitelist in VPC network.
        """
        return pulumi.get(self, "private_whitelists")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[str]]:
        """
        Elasticsearch protocol. Supported values: `HTTP`, `HTTPS`.default is `HTTP`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="publicDomain")
    def public_domain(self) -> pulumi.Output[str]:
        """
        Instance connection public domain.
        """
        return pulumi.get(self, "public_domain")

    @property
    @pulumi.getter(name="publicPort")
    def public_port(self) -> pulumi.Output[int]:
        """
        Instance connection public port.
        """
        return pulumi.get(self, "public_port")

    @property
    @pulumi.getter(name="publicWhitelists")
    def public_whitelists(self) -> pulumi.Output[Sequence[str]]:
        """
        Set the instance's IP whitelist in internet network.
        """
        return pulumi.get(self, "public_whitelists")

    @property
    @pulumi.getter(name="renewStatus")
    def renew_status(self) -> pulumi.Output[Optional[str]]:
        """
        The renewal status of the specified instance. Valid values: `AutoRenewal`, `ManualRenewal`, `NotRenewal`.The `instance_charge_type` must be `PrePaid`.
        """
        return pulumi.get(self, "renew_status")

    @property
    @pulumi.getter(name="renewalDurationUnit")
    def renewal_duration_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Auto-Renewal Cycle Unit Values Include: Month: Month. Year: Years. Valid values: `M`, `Y`.
        """
        return pulumi.get(self, "renewal_duration_unit")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The ID of resource group which the Elasticsearch instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="settingConfig")
    def setting_config(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        The YML configuration of the instance.[Detailed introduction](https://www.alibabacloud.com/help/doc-detail/61336.html).
        """
        return pulumi.get(self, "setting_config")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The Elasticsearch instance status. Includes `active`, `activating`, `inactive`. Some operations are denied when status is not `active`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Elasticsearch version. Supported values: `5.5.3_with_X-Pack`, `6.3_with_X-Pack`, `6.7_with_X-Pack`, `6.8_with_X-Pack`, `7.4_with_X-Pack` and `7.7_with_X-Pack`.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[str]:
        """
        The ID of VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> pulumi.Output[Optional[int]]:
        """
        The Multi-AZ supported for Elasticsearch, between 1 and 3. The `data_node_amount` value must be an integral multiple of the `zone_count` value.
        """
        return pulumi.get(self, "zone_count")

