# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ClusterApplicationConfigArgs',
    'ClusterBootstrapScriptArgs',
    'ClusterBootstrapScriptNodeSelectorArgs',
    'ClusterNodeAttributeArgs',
    'ClusterNodeGroupArgs',
    'ClusterNodeGroupCostOptimizedConfigArgs',
    'ClusterNodeGroupDataDiskArgs',
    'ClusterNodeGroupSpotBidPriceArgs',
    'ClusterNodeGroupSubscriptionConfigArgs',
    'ClusterNodeGroupSystemDiskArgs',
    'ClusterSubscriptionConfigArgs',
]

@pulumi.input_type
class ClusterApplicationConfigArgs:
    def __init__(__self__, *,
                 application_name: pulumi.Input[str],
                 config_file_name: pulumi.Input[str],
                 config_item_key: pulumi.Input[str],
                 config_item_value: pulumi.Input[str],
                 config_description: Optional[pulumi.Input[str]] = None,
                 config_scope: Optional[pulumi.Input[str]] = None,
                 node_group_id: Optional[pulumi.Input[str]] = None,
                 node_group_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] application_name: The application name of EMR cluster which has installed.
        :param pulumi.Input[str] config_file_name: The configuration file name of application installed.
        :param pulumi.Input[str] config_item_key: The configuration item key of application installed.
        :param pulumi.Input[str] config_item_value: The configuration item value of application installed.
        :param pulumi.Input[str] config_description: The configuration description of application installed.
        :param pulumi.Input[str] config_scope: The configuration scope of emr cluster. Supported value: CLUSTER or NODEGROUP.
        :param pulumi.Input[str] node_group_id: The configuration effected which node group id of emr cluster.
        :param pulumi.Input[str] node_group_name: The configuration effected which node group name of emr cluster.
        """
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "config_file_name", config_file_name)
        pulumi.set(__self__, "config_item_key", config_item_key)
        pulumi.set(__self__, "config_item_value", config_item_value)
        if config_description is not None:
            pulumi.set(__self__, "config_description", config_description)
        if config_scope is not None:
            pulumi.set(__self__, "config_scope", config_scope)
        if node_group_id is not None:
            pulumi.set(__self__, "node_group_id", node_group_id)
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> pulumi.Input[str]:
        """
        The application name of EMR cluster which has installed.
        """
        return pulumi.get(self, "application_name")

    @application_name.setter
    def application_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "application_name", value)

    @property
    @pulumi.getter(name="configFileName")
    def config_file_name(self) -> pulumi.Input[str]:
        """
        The configuration file name of application installed.
        """
        return pulumi.get(self, "config_file_name")

    @config_file_name.setter
    def config_file_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "config_file_name", value)

    @property
    @pulumi.getter(name="configItemKey")
    def config_item_key(self) -> pulumi.Input[str]:
        """
        The configuration item key of application installed.
        """
        return pulumi.get(self, "config_item_key")

    @config_item_key.setter
    def config_item_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "config_item_key", value)

    @property
    @pulumi.getter(name="configItemValue")
    def config_item_value(self) -> pulumi.Input[str]:
        """
        The configuration item value of application installed.
        """
        return pulumi.get(self, "config_item_value")

    @config_item_value.setter
    def config_item_value(self, value: pulumi.Input[str]):
        pulumi.set(self, "config_item_value", value)

    @property
    @pulumi.getter(name="configDescription")
    def config_description(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration description of application installed.
        """
        return pulumi.get(self, "config_description")

    @config_description.setter
    def config_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_description", value)

    @property
    @pulumi.getter(name="configScope")
    def config_scope(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration scope of emr cluster. Supported value: CLUSTER or NODEGROUP.
        """
        return pulumi.get(self, "config_scope")

    @config_scope.setter
    def config_scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_scope", value)

    @property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration effected which node group id of emr cluster.
        """
        return pulumi.get(self, "node_group_id")

    @node_group_id.setter
    def node_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_group_id", value)

    @property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration effected which node group name of emr cluster.
        """
        return pulumi.get(self, "node_group_name")

    @node_group_name.setter
    def node_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_group_name", value)


@pulumi.input_type
class ClusterBootstrapScriptArgs:
    def __init__(__self__, *,
                 execution_fail_strategy: pulumi.Input[str],
                 execution_moment: pulumi.Input[str],
                 node_selector: pulumi.Input['ClusterBootstrapScriptNodeSelectorArgs'],
                 script_args: pulumi.Input[str],
                 script_name: pulumi.Input[str],
                 script_path: pulumi.Input[str],
                 priority: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] execution_fail_strategy: The bootstrap scripts execution fail strategy, ’FAILED_BLOCKED’ or ‘FAILED_CONTINUE’ .
        :param pulumi.Input[str] execution_moment: The bootstrap scripts execution moment, ’BEFORE_INSTALL’ or ‘AFTER_STARTED’ .
        :param pulumi.Input['ClusterBootstrapScriptNodeSelectorArgs'] node_selector: The bootstrap scripts execution target. See `node_selector` below.
        :param pulumi.Input[str] script_args: The bootstrap script args, e.g. "--a=b".
        :param pulumi.Input[str] script_name: The bootstrap script name.
        :param pulumi.Input[str] script_path: The bootstrap script path, e.g. "oss://bucket/path".
        :param pulumi.Input[int] priority: The bootstrap scripts priority.
        """
        pulumi.set(__self__, "execution_fail_strategy", execution_fail_strategy)
        pulumi.set(__self__, "execution_moment", execution_moment)
        pulumi.set(__self__, "node_selector", node_selector)
        pulumi.set(__self__, "script_args", script_args)
        pulumi.set(__self__, "script_name", script_name)
        pulumi.set(__self__, "script_path", script_path)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter(name="executionFailStrategy")
    def execution_fail_strategy(self) -> pulumi.Input[str]:
        """
        The bootstrap scripts execution fail strategy, ’FAILED_BLOCKED’ or ‘FAILED_CONTINUE’ .
        """
        return pulumi.get(self, "execution_fail_strategy")

    @execution_fail_strategy.setter
    def execution_fail_strategy(self, value: pulumi.Input[str]):
        pulumi.set(self, "execution_fail_strategy", value)

    @property
    @pulumi.getter(name="executionMoment")
    def execution_moment(self) -> pulumi.Input[str]:
        """
        The bootstrap scripts execution moment, ’BEFORE_INSTALL’ or ‘AFTER_STARTED’ .
        """
        return pulumi.get(self, "execution_moment")

    @execution_moment.setter
    def execution_moment(self, value: pulumi.Input[str]):
        pulumi.set(self, "execution_moment", value)

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> pulumi.Input['ClusterBootstrapScriptNodeSelectorArgs']:
        """
        The bootstrap scripts execution target. See `node_selector` below.
        """
        return pulumi.get(self, "node_selector")

    @node_selector.setter
    def node_selector(self, value: pulumi.Input['ClusterBootstrapScriptNodeSelectorArgs']):
        pulumi.set(self, "node_selector", value)

    @property
    @pulumi.getter(name="scriptArgs")
    def script_args(self) -> pulumi.Input[str]:
        """
        The bootstrap script args, e.g. "--a=b".
        """
        return pulumi.get(self, "script_args")

    @script_args.setter
    def script_args(self, value: pulumi.Input[str]):
        pulumi.set(self, "script_args", value)

    @property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> pulumi.Input[str]:
        """
        The bootstrap script name.
        """
        return pulumi.get(self, "script_name")

    @script_name.setter
    def script_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "script_name", value)

    @property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> pulumi.Input[str]:
        """
        The bootstrap script path, e.g. "oss://bucket/path".
        """
        return pulumi.get(self, "script_path")

    @script_path.setter
    def script_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "script_path", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[int]]:
        """
        The bootstrap scripts priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "priority", value)


@pulumi.input_type
class ClusterBootstrapScriptNodeSelectorArgs:
    def __init__(__self__, *,
                 node_select_type: pulumi.Input[str],
                 node_group_id: Optional[pulumi.Input[str]] = None,
                 node_group_name: Optional[pulumi.Input[str]] = None,
                 node_group_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 node_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] node_select_type: The bootstrap scripts execution target node select type. Supported value: NODE, NODEGROUP or CLUSTER.
        :param pulumi.Input[str] node_group_id: The configuration effected which node group id of emr cluster.
        :param pulumi.Input[str] node_group_name: The configuration effected which node group name of emr cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_group_types: The bootstrap scripts execution target node group types.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] node_names: The bootstrap scripts execution target node names.
        """
        pulumi.set(__self__, "node_select_type", node_select_type)
        if node_group_id is not None:
            pulumi.set(__self__, "node_group_id", node_group_id)
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)
        if node_group_types is not None:
            pulumi.set(__self__, "node_group_types", node_group_types)
        if node_names is not None:
            pulumi.set(__self__, "node_names", node_names)

    @property
    @pulumi.getter(name="nodeSelectType")
    def node_select_type(self) -> pulumi.Input[str]:
        """
        The bootstrap scripts execution target node select type. Supported value: NODE, NODEGROUP or CLUSTER.
        """
        return pulumi.get(self, "node_select_type")

    @node_select_type.setter
    def node_select_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_select_type", value)

    @property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration effected which node group id of emr cluster.
        """
        return pulumi.get(self, "node_group_id")

    @node_group_id.setter
    def node_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_group_id", value)

    @property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The configuration effected which node group name of emr cluster.
        """
        return pulumi.get(self, "node_group_name")

    @node_group_name.setter
    def node_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_group_name", value)

    @property
    @pulumi.getter(name="nodeGroupTypes")
    def node_group_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The bootstrap scripts execution target node group types.
        """
        return pulumi.get(self, "node_group_types")

    @node_group_types.setter
    def node_group_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_group_types", value)

    @property
    @pulumi.getter(name="nodeNames")
    def node_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The bootstrap scripts execution target node names.
        """
        return pulumi.get(self, "node_names")

    @node_names.setter
    def node_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "node_names", value)


@pulumi.input_type
class ClusterNodeAttributeArgs:
    def __init__(__self__, *,
                 key_pair_name: pulumi.Input[str],
                 ram_role: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 zone_id: pulumi.Input[str],
                 data_disk_encrypted: Optional[pulumi.Input[bool]] = None,
                 data_disk_kms_key_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key_pair_name: The name of the key pair.
        :param pulumi.Input[str] ram_role: Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        :param pulumi.Input[str] security_group_id: Security Group ID for Cluster.
        :param pulumi.Input[str] vpc_id: Used to retrieve instances belong to specified VPC.
        :param pulumi.Input[str] zone_id: Zone ID, e.g. cn-hangzhou-i
        :param pulumi.Input[bool] data_disk_encrypted: Whether to enable data disk encryption.
        :param pulumi.Input[str] data_disk_kms_key_id: The kms key id used to encrypt the data disk. It takes effect when data_disk_encrypted is true.
        """
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        pulumi.set(__self__, "ram_role", ram_role)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if data_disk_encrypted is not None:
            pulumi.set(__self__, "data_disk_encrypted", data_disk_encrypted)
        if data_disk_kms_key_id is not None:
            pulumi.set(__self__, "data_disk_kms_key_id", data_disk_kms_key_id)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> pulumi.Input[str]:
        """
        The name of the key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @key_pair_name.setter
    def key_pair_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_pair_name", value)

    @property
    @pulumi.getter(name="ramRole")
    def ram_role(self) -> pulumi.Input[str]:
        """
        Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        """
        return pulumi.get(self, "ram_role")

    @ram_role.setter
    def ram_role(self, value: pulumi.Input[str]):
        pulumi.set(self, "ram_role", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        Security Group ID for Cluster.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Used to retrieve instances belong to specified VPC.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[str]:
        """
        Zone ID, e.g. cn-hangzhou-i
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter(name="dataDiskEncrypted")
    def data_disk_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable data disk encryption.
        """
        return pulumi.get(self, "data_disk_encrypted")

    @data_disk_encrypted.setter
    def data_disk_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "data_disk_encrypted", value)

    @property
    @pulumi.getter(name="dataDiskKmsKeyId")
    def data_disk_kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The kms key id used to encrypt the data disk. It takes effect when data_disk_encrypted is true.
        """
        return pulumi.get(self, "data_disk_kms_key_id")

    @data_disk_kms_key_id.setter
    def data_disk_kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_disk_kms_key_id", value)


@pulumi.input_type
class ClusterNodeGroupArgs:
    def __init__(__self__, *,
                 data_disks: pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupDataDiskArgs']]],
                 instance_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 node_count: pulumi.Input[int],
                 node_group_name: pulumi.Input[str],
                 node_group_type: pulumi.Input[str],
                 system_disk: pulumi.Input['ClusterNodeGroupSystemDiskArgs'],
                 additional_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cost_optimized_config: Optional[pulumi.Input['ClusterNodeGroupCostOptimizedConfigArgs']] = None,
                 graceful_shutdown: Optional[pulumi.Input[bool]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 spot_bid_prices: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupSpotBidPriceArgs']]]] = None,
                 spot_instance_remedy: Optional[pulumi.Input[bool]] = None,
                 subscription_config: Optional[pulumi.Input['ClusterNodeGroupSubscriptionConfigArgs']] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 with_public_ip: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupDataDiskArgs']]] data_disks: Host Ecs data disks information in this node group. See `data_disks` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: Host Ecs instance types.
        :param pulumi.Input[int] node_count: Host Ecs number in this node group.
        :param pulumi.Input[str] node_group_name: The node group name of emr cluster.
        :param pulumi.Input[str] node_group_type: The node group type of emr cluster, supported value: MASTER, CORE or TASK.
        :param pulumi.Input['ClusterNodeGroupSystemDiskArgs'] system_disk: Host Ecs system disk information in this node group. See `system_disk` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] additional_security_group_ids: Additional security Group IDS for Cluster, you can also specify this key for each node group.
        :param pulumi.Input['ClusterNodeGroupCostOptimizedConfigArgs'] cost_optimized_config: The detail cost optimized configuration of emr cluster. See `cost_optimized_config` below.
        :param pulumi.Input[bool] graceful_shutdown: Enable emr cluster of task node graceful decommission, ’true’ or ‘false’ .
        :param pulumi.Input[str] payment_type: Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupSpotBidPriceArgs']]] spot_bid_prices: The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
        :param pulumi.Input[bool] spot_instance_remedy: Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        :param pulumi.Input['ClusterNodeGroupSubscriptionConfigArgs'] subscription_config: The detail configuration of subscription payment type. See `subscription_config` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vswitch_ids: Global vSwitch ids, you can also specify it in node group.
        :param pulumi.Input[bool] with_public_ip: Whether the node has a public IP address enabled.
        """
        pulumi.set(__self__, "data_disks", data_disks)
        pulumi.set(__self__, "instance_types", instance_types)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_group_name", node_group_name)
        pulumi.set(__self__, "node_group_type", node_group_type)
        pulumi.set(__self__, "system_disk", system_disk)
        if additional_security_group_ids is not None:
            pulumi.set(__self__, "additional_security_group_ids", additional_security_group_ids)
        if cost_optimized_config is not None:
            pulumi.set(__self__, "cost_optimized_config", cost_optimized_config)
        if graceful_shutdown is not None:
            pulumi.set(__self__, "graceful_shutdown", graceful_shutdown)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if spot_bid_prices is not None:
            pulumi.set(__self__, "spot_bid_prices", spot_bid_prices)
        if spot_instance_remedy is not None:
            pulumi.set(__self__, "spot_instance_remedy", spot_instance_remedy)
        if subscription_config is not None:
            pulumi.set(__self__, "subscription_config", subscription_config)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if with_public_ip is not None:
            pulumi.set(__self__, "with_public_ip", with_public_ip)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupDataDiskArgs']]]:
        """
        Host Ecs data disks information in this node group. See `data_disks` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupDataDiskArgs']]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Host Ecs instance types.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Input[int]:
        """
        Host Ecs number in this node group.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> pulumi.Input[str]:
        """
        The node group name of emr cluster.
        """
        return pulumi.get(self, "node_group_name")

    @node_group_name.setter
    def node_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_group_name", value)

    @property
    @pulumi.getter(name="nodeGroupType")
    def node_group_type(self) -> pulumi.Input[str]:
        """
        The node group type of emr cluster, supported value: MASTER, CORE or TASK.
        """
        return pulumi.get(self, "node_group_type")

    @node_group_type.setter
    def node_group_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_group_type", value)

    @property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> pulumi.Input['ClusterNodeGroupSystemDiskArgs']:
        """
        Host Ecs system disk information in this node group. See `system_disk` below.
        """
        return pulumi.get(self, "system_disk")

    @system_disk.setter
    def system_disk(self, value: pulumi.Input['ClusterNodeGroupSystemDiskArgs']):
        pulumi.set(self, "system_disk", value)

    @property
    @pulumi.getter(name="additionalSecurityGroupIds")
    def additional_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Additional security Group IDS for Cluster, you can also specify this key for each node group.
        """
        return pulumi.get(self, "additional_security_group_ids")

    @additional_security_group_ids.setter
    def additional_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "additional_security_group_ids", value)

    @property
    @pulumi.getter(name="costOptimizedConfig")
    def cost_optimized_config(self) -> Optional[pulumi.Input['ClusterNodeGroupCostOptimizedConfigArgs']]:
        """
        The detail cost optimized configuration of emr cluster. See `cost_optimized_config` below.
        """
        return pulumi.get(self, "cost_optimized_config")

    @cost_optimized_config.setter
    def cost_optimized_config(self, value: Optional[pulumi.Input['ClusterNodeGroupCostOptimizedConfigArgs']]):
        pulumi.set(self, "cost_optimized_config", value)

    @property
    @pulumi.getter(name="gracefulShutdown")
    def graceful_shutdown(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable emr cluster of task node graceful decommission, ’true’ or ‘false’ .
        """
        return pulumi.get(self, "graceful_shutdown")

    @graceful_shutdown.setter
    def graceful_shutdown(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "graceful_shutdown", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="spotBidPrices")
    def spot_bid_prices(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupSpotBidPriceArgs']]]]:
        """
        The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
        """
        return pulumi.get(self, "spot_bid_prices")

    @spot_bid_prices.setter
    def spot_bid_prices(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupSpotBidPriceArgs']]]]):
        pulumi.set(self, "spot_bid_prices", value)

    @property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @spot_instance_remedy.setter
    def spot_instance_remedy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "spot_instance_remedy", value)

    @property
    @pulumi.getter(name="subscriptionConfig")
    def subscription_config(self) -> Optional[pulumi.Input['ClusterNodeGroupSubscriptionConfigArgs']]:
        """
        The detail configuration of subscription payment type. See `subscription_config` below.
        """
        return pulumi.get(self, "subscription_config")

    @subscription_config.setter
    def subscription_config(self, value: Optional[pulumi.Input['ClusterNodeGroupSubscriptionConfigArgs']]):
        pulumi.set(self, "subscription_config", value)

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Global vSwitch ids, you can also specify it in node group.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vswitch_ids", value)

    @property
    @pulumi.getter(name="withPublicIp")
    def with_public_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the node has a public IP address enabled.
        """
        return pulumi.get(self, "with_public_ip")

    @with_public_ip.setter
    def with_public_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "with_public_ip", value)


@pulumi.input_type
class ClusterNodeGroupCostOptimizedConfigArgs:
    def __init__(__self__, *,
                 on_demand_base_capacity: pulumi.Input[int],
                 on_demand_percentage_above_base_capacity: pulumi.Input[int],
                 spot_instance_pools: pulumi.Input[int]):
        """
        :param pulumi.Input[int] on_demand_base_capacity: The cost optimized configuration which on demand based capacity.
        :param pulumi.Input[int] on_demand_percentage_above_base_capacity: The cost optimized configuration which on demand percentage above based capacity.
        :param pulumi.Input[int] spot_instance_pools: The cost optimized configuration with spot instance pools.
        """
        pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)

    @property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> pulumi.Input[int]:
        """
        The cost optimized configuration which on demand based capacity.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @on_demand_base_capacity.setter
    def on_demand_base_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "on_demand_base_capacity", value)

    @property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> pulumi.Input[int]:
        """
        The cost optimized configuration which on demand percentage above based capacity.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @on_demand_percentage_above_base_capacity.setter
    def on_demand_percentage_above_base_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "on_demand_percentage_above_base_capacity", value)

    @property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> pulumi.Input[int]:
        """
        The cost optimized configuration with spot instance pools.
        """
        return pulumi.get(self, "spot_instance_pools")

    @spot_instance_pools.setter
    def spot_instance_pools(self, value: pulumi.Input[int]):
        pulumi.set(self, "spot_instance_pools", value)


@pulumi.input_type
class ClusterNodeGroupDataDiskArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[str],
                 size: pulumi.Input[int],
                 count: Optional[pulumi.Input[int]] = None,
                 performance_level: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] category: The type of the data disk. Valid values: `cloud_efficiency` and `cloud_essd`.
        :param pulumi.Input[int] size: The size of a data disk, at least 40. Unit: GiB.
        :param pulumi.Input[int] count: The count of a data disk.
        :param pulumi.Input[str] performance_level: Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "size", size)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Input[str]:
        """
        The type of the data disk. Valid values: `cloud_efficiency` and `cloud_essd`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[str]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of a data disk, at least 40. Unit: GiB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        The count of a data disk.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_level", value)


@pulumi.input_type
class ClusterNodeGroupSpotBidPriceArgs:
    def __init__(__self__, *,
                 bid_price: pulumi.Input[int],
                 instance_type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] bid_price: The spot bid price of a PayAsYouGo instance.
        :param pulumi.Input[str] instance_type: Host Ecs instance type.
        """
        pulumi.set(__self__, "bid_price", bid_price)
        pulumi.set(__self__, "instance_type", instance_type)

    @property
    @pulumi.getter(name="bidPrice")
    def bid_price(self) -> pulumi.Input[int]:
        """
        The spot bid price of a PayAsYouGo instance.
        """
        return pulumi.get(self, "bid_price")

    @bid_price.setter
    def bid_price(self, value: pulumi.Input[int]):
        pulumi.set(self, "bid_price", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        Host Ecs instance type.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)


@pulumi.input_type
class ClusterNodeGroupSubscriptionConfigArgs:
    def __init__(__self__, *,
                 payment_duration: pulumi.Input[int],
                 payment_duration_unit: pulumi.Input[str],
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_duration: Optional[pulumi.Input[int]] = None,
                 auto_renew_duration_unit: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] payment_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param pulumi.Input[str] payment_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        :param pulumi.Input[bool] auto_renew: Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        :param pulumi.Input[int] auto_renew_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param pulumi.Input[str] auto_renew_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        pulumi.set(__self__, "payment_duration", payment_duration)
        pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if auto_renew_duration_unit is not None:
            pulumi.set(__self__, "auto_renew_duration_unit", auto_renew_duration_unit)

    @property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> pulumi.Input[int]:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "payment_duration")

    @payment_duration.setter
    def payment_duration(self, value: pulumi.Input[int]):
        pulumi.set(self, "payment_duration", value)

    @property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> pulumi.Input[str]:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "payment_duration_unit")

    @payment_duration_unit.setter
    def payment_duration_unit(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_duration_unit", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[pulumi.Input[int]]:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "auto_renew_duration")

    @auto_renew_duration.setter
    def auto_renew_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_duration", value)

    @property
    @pulumi.getter(name="autoRenewDurationUnit")
    def auto_renew_duration_unit(self) -> Optional[pulumi.Input[str]]:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "auto_renew_duration_unit")

    @auto_renew_duration_unit.setter
    def auto_renew_duration_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew_duration_unit", value)


@pulumi.input_type
class ClusterNodeGroupSystemDiskArgs:
    def __init__(__self__, *,
                 category: pulumi.Input[str],
                 size: pulumi.Input[int],
                 count: Optional[pulumi.Input[int]] = None,
                 performance_level: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] category: The type of the data disk. Valid values: `cloud_efficiency` and `cloud_essd`.
        :param pulumi.Input[int] size: The size of a data disk, at least 40. Unit: GiB.
        :param pulumi.Input[int] count: The count of a data disk.
        :param pulumi.Input[str] performance_level: Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "size", size)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Input[str]:
        """
        The type of the data disk. Valid values: `cloud_efficiency` and `cloud_essd`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: pulumi.Input[str]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of a data disk, at least 40. Unit: GiB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def count(self) -> Optional[pulumi.Input[int]]:
        """
        The count of a data disk.
        """
        return pulumi.get(self, "count")

    @count.setter
    def count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "count", value)

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_level", value)


@pulumi.input_type
class ClusterSubscriptionConfigArgs:
    def __init__(__self__, *,
                 payment_duration: pulumi.Input[int],
                 payment_duration_unit: pulumi.Input[str],
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 auto_renew_duration: Optional[pulumi.Input[int]] = None,
                 auto_renew_duration_unit: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] payment_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param pulumi.Input[str] payment_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        :param pulumi.Input[bool] auto_renew: Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        :param pulumi.Input[int] auto_renew_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param pulumi.Input[str] auto_renew_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        pulumi.set(__self__, "payment_duration", payment_duration)
        pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if auto_renew_duration_unit is not None:
            pulumi.set(__self__, "auto_renew_duration_unit", auto_renew_duration_unit)

    @property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> pulumi.Input[int]:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "payment_duration")

    @payment_duration.setter
    def payment_duration(self, value: pulumi.Input[int]):
        pulumi.set(self, "payment_duration", value)

    @property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> pulumi.Input[str]:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "payment_duration_unit")

    @payment_duration_unit.setter
    def payment_duration_unit(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_duration_unit", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[pulumi.Input[int]]:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "auto_renew_duration")

    @auto_renew_duration.setter
    def auto_renew_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "auto_renew_duration", value)

    @property
    @pulumi.getter(name="autoRenewDurationUnit")
    def auto_renew_duration_unit(self) -> Optional[pulumi.Input[str]]:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "auto_renew_duration_unit")

    @auto_renew_duration_unit.setter
    def auto_renew_duration_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew_duration_unit", value)


