# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 applications: pulumi.Input[Sequence[pulumi.Input[str]]],
                 cluster_name: pulumi.Input[str],
                 cluster_type: pulumi.Input[str],
                 node_attributes: pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]],
                 node_groups: pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]],
                 release_version: pulumi.Input[str],
                 application_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]]] = None,
                 bootstrap_scripts: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]]] = None,
                 deploy_mode: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_mode: Optional[pulumi.Input[str]] = None,
                 subscription_config: Optional[pulumi.Input['ClusterSubscriptionConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] applications: The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
        :param pulumi.Input[str] cluster_name: The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        :param pulumi.Input[str] cluster_type: EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]] node_attributes: The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]] node_groups: Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below.
        :param pulumi.Input[str] release_version: EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]] application_configs: The application configurations of EMR cluster. See `application_configs` below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]] bootstrap_scripts: The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster. See `bootstrap_scripts` below.
        :param pulumi.Input[str] deploy_mode: The deploy mode of EMR cluster. Supported value: NORMAL or HA.
        :param pulumi.Input[str] payment_type: Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        :param pulumi.Input[str] resource_group_id: The Id of resource group which the emr-cluster belongs.
        :param pulumi.Input[str] security_mode: The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
        :param pulumi.Input['ClusterSubscriptionConfigArgs'] subscription_config: The detail configuration of subscription payment type. See `subscription_config` below.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "applications", applications)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "node_attributes", node_attributes)
        pulumi.set(__self__, "node_groups", node_groups)
        pulumi.set(__self__, "release_version", release_version)
        if application_configs is not None:
            pulumi.set(__self__, "application_configs", application_configs)
        if bootstrap_scripts is not None:
            pulumi.set(__self__, "bootstrap_scripts", bootstrap_scripts)
        if deploy_mode is not None:
            pulumi.set(__self__, "deploy_mode", deploy_mode)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_mode is not None:
            pulumi.set(__self__, "security_mode", security_mode)
        if subscription_config is not None:
            pulumi.set(__self__, "subscription_config", subscription_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def applications(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "applications", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[str]:
        """
        The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Input[str]:
        """
        EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_type", value)

    @property
    @pulumi.getter(name="nodeAttributes")
    def node_attributes(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]]:
        """
        The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
        """
        return pulumi.get(self, "node_attributes")

    @node_attributes.setter
    def node_attributes(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]]):
        pulumi.set(self, "node_attributes", value)

    @property
    @pulumi.getter(name="nodeGroups")
    def node_groups(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]:
        """
        Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below.
        """
        return pulumi.get(self, "node_groups")

    @node_groups.setter
    def node_groups(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]):
        pulumi.set(self, "node_groups", value)

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> pulumi.Input[str]:
        """
        EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
        """
        return pulumi.get(self, "release_version")

    @release_version.setter
    def release_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "release_version", value)

    @property
    @pulumi.getter(name="applicationConfigs")
    def application_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]]]:
        """
        The application configurations of EMR cluster. See `application_configs` below.
        """
        return pulumi.get(self, "application_configs")

    @application_configs.setter
    def application_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]]]):
        pulumi.set(self, "application_configs", value)

    @property
    @pulumi.getter(name="bootstrapScripts")
    def bootstrap_scripts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]]]:
        """
        The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster. See `bootstrap_scripts` below.
        """
        return pulumi.get(self, "bootstrap_scripts")

    @bootstrap_scripts.setter
    def bootstrap_scripts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]]]):
        pulumi.set(self, "bootstrap_scripts", value)

    @property
    @pulumi.getter(name="deployMode")
    def deploy_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The deploy mode of EMR cluster. Supported value: NORMAL or HA.
        """
        return pulumi.get(self, "deploy_mode")

    @deploy_mode.setter
    def deploy_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_mode", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of resource group which the emr-cluster belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
        """
        return pulumi.get(self, "security_mode")

    @security_mode.setter
    def security_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_mode", value)

    @property
    @pulumi.getter(name="subscriptionConfig")
    def subscription_config(self) -> Optional[pulumi.Input['ClusterSubscriptionConfigArgs']]:
        """
        The detail configuration of subscription payment type. See `subscription_config` below.
        """
        return pulumi.get(self, "subscription_config")

    @subscription_config.setter
    def subscription_config(self, value: Optional[pulumi.Input['ClusterSubscriptionConfigArgs']]):
        pulumi.set(self, "subscription_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 application_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bootstrap_scripts: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 cluster_type: Optional[pulumi.Input[str]] = None,
                 deploy_mode: Optional[pulumi.Input[str]] = None,
                 node_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]]] = None,
                 node_groups: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 release_version: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_mode: Optional[pulumi.Input[str]] = None,
                 subscription_config: Optional[pulumi.Input['ClusterSubscriptionConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]] application_configs: The application configurations of EMR cluster. See `application_configs` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] applications: The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]] bootstrap_scripts: The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster. See `bootstrap_scripts` below.
        :param pulumi.Input[str] cluster_name: The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        :param pulumi.Input[str] cluster_type: EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
        :param pulumi.Input[str] deploy_mode: The deploy mode of EMR cluster. Supported value: NORMAL or HA.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]] node_attributes: The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]] node_groups: Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below.
        :param pulumi.Input[str] payment_type: Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        :param pulumi.Input[str] release_version: EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
        :param pulumi.Input[str] resource_group_id: The Id of resource group which the emr-cluster belongs.
        :param pulumi.Input[str] security_mode: The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
        :param pulumi.Input['ClusterSubscriptionConfigArgs'] subscription_config: The detail configuration of subscription payment type. See `subscription_config` below.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        """
        if application_configs is not None:
            pulumi.set(__self__, "application_configs", application_configs)
        if applications is not None:
            pulumi.set(__self__, "applications", applications)
        if bootstrap_scripts is not None:
            pulumi.set(__self__, "bootstrap_scripts", bootstrap_scripts)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_type is not None:
            pulumi.set(__self__, "cluster_type", cluster_type)
        if deploy_mode is not None:
            pulumi.set(__self__, "deploy_mode", deploy_mode)
        if node_attributes is not None:
            pulumi.set(__self__, "node_attributes", node_attributes)
        if node_groups is not None:
            pulumi.set(__self__, "node_groups", node_groups)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if release_version is not None:
            pulumi.set(__self__, "release_version", release_version)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if security_mode is not None:
            pulumi.set(__self__, "security_mode", security_mode)
        if subscription_config is not None:
            pulumi.set(__self__, "subscription_config", subscription_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="applicationConfigs")
    def application_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]]]:
        """
        The application configurations of EMR cluster. See `application_configs` below.
        """
        return pulumi.get(self, "application_configs")

    @application_configs.setter
    def application_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterApplicationConfigArgs']]]]):
        pulumi.set(self, "application_configs", value)

    @property
    @pulumi.getter
    def applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
        """
        return pulumi.get(self, "applications")

    @applications.setter
    def applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "applications", value)

    @property
    @pulumi.getter(name="bootstrapScripts")
    def bootstrap_scripts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]]]:
        """
        The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster. See `bootstrap_scripts` below.
        """
        return pulumi.get(self, "bootstrap_scripts")

    @bootstrap_scripts.setter
    def bootstrap_scripts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterBootstrapScriptArgs']]]]):
        pulumi.set(self, "bootstrap_scripts", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> Optional[pulumi.Input[str]]:
        """
        EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
        """
        return pulumi.get(self, "cluster_type")

    @cluster_type.setter
    def cluster_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_type", value)

    @property
    @pulumi.getter(name="deployMode")
    def deploy_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The deploy mode of EMR cluster. Supported value: NORMAL or HA.
        """
        return pulumi.get(self, "deploy_mode")

    @deploy_mode.setter
    def deploy_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deploy_mode", value)

    @property
    @pulumi.getter(name="nodeAttributes")
    def node_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]]]:
        """
        The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
        """
        return pulumi.get(self, "node_attributes")

    @node_attributes.setter
    def node_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeAttributeArgs']]]]):
        pulumi.set(self, "node_attributes", value)

    @property
    @pulumi.getter(name="nodeGroups")
    def node_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]]:
        """
        Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below.
        """
        return pulumi.get(self, "node_groups")

    @node_groups.setter
    def node_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeGroupArgs']]]]):
        pulumi.set(self, "node_groups", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> Optional[pulumi.Input[str]]:
        """
        EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
        """
        return pulumi.get(self, "release_version")

    @release_version.setter
    def release_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "release_version", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of resource group which the emr-cluster belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
        """
        return pulumi.get(self, "security_mode")

    @security_mode.setter
    def security_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_mode", value)

    @property
    @pulumi.getter(name="subscriptionConfig")
    def subscription_config(self) -> Optional[pulumi.Input['ClusterSubscriptionConfigArgs']]:
        """
        The detail configuration of subscription payment type. See `subscription_config` below.
        """
        return pulumi.get(self, "subscription_config")

    @subscription_config.setter
    def subscription_config(self, value: Optional[pulumi.Input['ClusterSubscriptionConfigArgs']]):
        pulumi.set(self, "subscription_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterApplicationConfigArgs']]]]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bootstrap_scripts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterBootstrapScriptArgs']]]]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 cluster_type: Optional[pulumi.Input[str]] = None,
                 deploy_mode: Optional[pulumi.Input[str]] = None,
                 node_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeAttributeArgs']]]]] = None,
                 node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeGroupArgs']]]]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 release_version: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_mode: Optional[pulumi.Input[str]] = None,
                 subscription_config: Optional[pulumi.Input[pulumi.InputType['ClusterSubscriptionConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        """
        Provides a EMR cluster resource. This resource is based on EMR's new version OpenAPI.

        For information about EMR New and how to use it, see [Add a domain](https://www.alibabacloud.com/help/doc-detail/28068.htm).

        > **NOTE:** Available since v1.199.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_zones = alicloud.get_zones(available_instance_type="ecs.g7.xlarge")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="172.16.0.0/12")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=default_zones.zones[0].id,
            vswitch_name=name)
        default_ecs_key_pair = alicloud.ecs.EcsKeyPair("defaultEcsKeyPair", key_pair_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_role = alicloud.ram.Role("defaultRole",
            document=\"\"\"    {
                "Statement": [
                {
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                    "Service": [
                        "emr.aliyuncs.com",
                        "ecs.aliyuncs.com"
                    ]
                    }
                }
                ],
                "Version": "1"
            }
        \"\"\",
            description="this is a role example.",
            force=True)
        default_cluster = alicloud.emrv2.Cluster("defaultCluster",
            payment_type="PayAsYouGo",
            cluster_type="DATALAKE",
            release_version="EMR-5.10.0",
            cluster_name=name,
            deploy_mode="NORMAL",
            security_mode="NORMAL",
            applications=[
                "HADOOP-COMMON",
                "HDFS",
                "YARN",
                "HIVE",
                "SPARK3",
                "TEZ",
            ],
            application_configs=[
                alicloud.emrv2.ClusterApplicationConfigArgs(
                    application_name="HIVE",
                    config_file_name="hivemetastore-site.xml",
                    config_item_key="hive.metastore.type",
                    config_item_value="DLF",
                    config_scope="CLUSTER",
                ),
                alicloud.emrv2.ClusterApplicationConfigArgs(
                    application_name="SPARK3",
                    config_file_name="hive-site.xml",
                    config_item_key="hive.metastore.type",
                    config_item_value="DLF",
                    config_scope="CLUSTER",
                ),
            ],
            node_attributes=[alicloud.emrv2.ClusterNodeAttributeArgs(
                ram_role=default_role.name,
                security_group_id=default_security_group.id,
                vpc_id=default_network.id,
                zone_id=default_zones.zones[0].id,
                key_pair_name=default_ecs_key_pair.id,
            )],
            tags={
                "created": "tf",
            },
            node_groups=[
                alicloud.emrv2.ClusterNodeGroupArgs(
                    node_group_type="MASTER",
                    node_group_name="emr-master",
                    payment_type="PayAsYouGo",
                    vswitch_ids=[default_switch.id],
                    with_public_ip=False,
                    instance_types=["ecs.g7.xlarge"],
                    node_count=1,
                    system_disk=alicloud.emrv2.ClusterNodeGroupSystemDiskArgs(
                        category="cloud_essd",
                        size=80,
                        count=1,
                    ),
                    data_disks=[alicloud.emrv2.ClusterNodeGroupDataDiskArgs(
                        category="cloud_essd",
                        size=80,
                        count=3,
                    )],
                ),
                alicloud.emrv2.ClusterNodeGroupArgs(
                    node_group_type="CORE",
                    node_group_name="emr-core",
                    payment_type="PayAsYouGo",
                    vswitch_ids=[default_switch.id],
                    with_public_ip=False,
                    instance_types=["ecs.g7.xlarge"],
                    node_count=3,
                    system_disk=alicloud.emrv2.ClusterNodeGroupSystemDiskArgs(
                        category="cloud_essd",
                        size=80,
                        count=1,
                    ),
                    data_disks=[alicloud.emrv2.ClusterNodeGroupDataDiskArgs(
                        category="cloud_essd",
                        size=80,
                        count=3,
                    )],
                ),
            ],
            resource_group_id=default_resource_groups.ids[0])
        ```

        ## Import

        Aliclioud E-MapReduce cluster can be imported using the id e.g.

        ```sh
         $ pulumi import alicloud:emrv2/cluster:Cluster default <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterApplicationConfigArgs']]]] application_configs: The application configurations of EMR cluster. See `application_configs` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] applications: The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterBootstrapScriptArgs']]]] bootstrap_scripts: The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster. See `bootstrap_scripts` below.
        :param pulumi.Input[str] cluster_name: The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        :param pulumi.Input[str] cluster_type: EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
        :param pulumi.Input[str] deploy_mode: The deploy mode of EMR cluster. Supported value: NORMAL or HA.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeAttributeArgs']]]] node_attributes: The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeGroupArgs']]]] node_groups: Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below.
        :param pulumi.Input[str] payment_type: Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        :param pulumi.Input[str] release_version: EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
        :param pulumi.Input[str] resource_group_id: The Id of resource group which the emr-cluster belongs.
        :param pulumi.Input[str] security_mode: The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
        :param pulumi.Input[pulumi.InputType['ClusterSubscriptionConfigArgs']] subscription_config: The detail configuration of subscription payment type. See `subscription_config` below.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a EMR cluster resource. This resource is based on EMR's new version OpenAPI.

        For information about EMR New and how to use it, see [Add a domain](https://www.alibabacloud.com/help/doc-detail/28068.htm).

        > **NOTE:** Available since v1.199.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_resource_groups = alicloud.resourcemanager.get_resource_groups()
        default_zones = alicloud.get_zones(available_instance_type="ecs.g7.xlarge")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="172.16.0.0/12")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/21",
            zone_id=default_zones.zones[0].id,
            vswitch_name=name)
        default_ecs_key_pair = alicloud.ecs.EcsKeyPair("defaultEcsKeyPair", key_pair_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_role = alicloud.ram.Role("defaultRole",
            document=\"\"\"    {
                "Statement": [
                {
                    "Action": "sts:AssumeRole",
                    "Effect": "Allow",
                    "Principal": {
                    "Service": [
                        "emr.aliyuncs.com",
                        "ecs.aliyuncs.com"
                    ]
                    }
                }
                ],
                "Version": "1"
            }
        \"\"\",
            description="this is a role example.",
            force=True)
        default_cluster = alicloud.emrv2.Cluster("defaultCluster",
            payment_type="PayAsYouGo",
            cluster_type="DATALAKE",
            release_version="EMR-5.10.0",
            cluster_name=name,
            deploy_mode="NORMAL",
            security_mode="NORMAL",
            applications=[
                "HADOOP-COMMON",
                "HDFS",
                "YARN",
                "HIVE",
                "SPARK3",
                "TEZ",
            ],
            application_configs=[
                alicloud.emrv2.ClusterApplicationConfigArgs(
                    application_name="HIVE",
                    config_file_name="hivemetastore-site.xml",
                    config_item_key="hive.metastore.type",
                    config_item_value="DLF",
                    config_scope="CLUSTER",
                ),
                alicloud.emrv2.ClusterApplicationConfigArgs(
                    application_name="SPARK3",
                    config_file_name="hive-site.xml",
                    config_item_key="hive.metastore.type",
                    config_item_value="DLF",
                    config_scope="CLUSTER",
                ),
            ],
            node_attributes=[alicloud.emrv2.ClusterNodeAttributeArgs(
                ram_role=default_role.name,
                security_group_id=default_security_group.id,
                vpc_id=default_network.id,
                zone_id=default_zones.zones[0].id,
                key_pair_name=default_ecs_key_pair.id,
            )],
            tags={
                "created": "tf",
            },
            node_groups=[
                alicloud.emrv2.ClusterNodeGroupArgs(
                    node_group_type="MASTER",
                    node_group_name="emr-master",
                    payment_type="PayAsYouGo",
                    vswitch_ids=[default_switch.id],
                    with_public_ip=False,
                    instance_types=["ecs.g7.xlarge"],
                    node_count=1,
                    system_disk=alicloud.emrv2.ClusterNodeGroupSystemDiskArgs(
                        category="cloud_essd",
                        size=80,
                        count=1,
                    ),
                    data_disks=[alicloud.emrv2.ClusterNodeGroupDataDiskArgs(
                        category="cloud_essd",
                        size=80,
                        count=3,
                    )],
                ),
                alicloud.emrv2.ClusterNodeGroupArgs(
                    node_group_type="CORE",
                    node_group_name="emr-core",
                    payment_type="PayAsYouGo",
                    vswitch_ids=[default_switch.id],
                    with_public_ip=False,
                    instance_types=["ecs.g7.xlarge"],
                    node_count=3,
                    system_disk=alicloud.emrv2.ClusterNodeGroupSystemDiskArgs(
                        category="cloud_essd",
                        size=80,
                        count=1,
                    ),
                    data_disks=[alicloud.emrv2.ClusterNodeGroupDataDiskArgs(
                        category="cloud_essd",
                        size=80,
                        count=3,
                    )],
                ),
            ],
            resource_group_id=default_resource_groups.ids[0])
        ```

        ## Import

        Aliclioud E-MapReduce cluster can be imported using the id e.g.

        ```sh
         $ pulumi import alicloud:emrv2/cluster:Cluster default <id>
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterApplicationConfigArgs']]]]] = None,
                 applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bootstrap_scripts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterBootstrapScriptArgs']]]]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 cluster_type: Optional[pulumi.Input[str]] = None,
                 deploy_mode: Optional[pulumi.Input[str]] = None,
                 node_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeAttributeArgs']]]]] = None,
                 node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeGroupArgs']]]]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 release_version: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 security_mode: Optional[pulumi.Input[str]] = None,
                 subscription_config: Optional[pulumi.Input[pulumi.InputType['ClusterSubscriptionConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["application_configs"] = application_configs
            if applications is None and not opts.urn:
                raise TypeError("Missing required property 'applications'")
            __props__.__dict__["applications"] = applications
            __props__.__dict__["bootstrap_scripts"] = bootstrap_scripts
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            if cluster_type is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_type'")
            __props__.__dict__["cluster_type"] = cluster_type
            __props__.__dict__["deploy_mode"] = deploy_mode
            if node_attributes is None and not opts.urn:
                raise TypeError("Missing required property 'node_attributes'")
            __props__.__dict__["node_attributes"] = node_attributes
            if node_groups is None and not opts.urn:
                raise TypeError("Missing required property 'node_groups'")
            __props__.__dict__["node_groups"] = node_groups
            __props__.__dict__["payment_type"] = payment_type
            if release_version is None and not opts.urn:
                raise TypeError("Missing required property 'release_version'")
            __props__.__dict__["release_version"] = release_version
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["security_mode"] = security_mode
            __props__.__dict__["subscription_config"] = subscription_config
            __props__.__dict__["tags"] = tags
        super(Cluster, __self__).__init__(
            'alicloud:emrv2/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterApplicationConfigArgs']]]]] = None,
            applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            bootstrap_scripts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterBootstrapScriptArgs']]]]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            cluster_type: Optional[pulumi.Input[str]] = None,
            deploy_mode: Optional[pulumi.Input[str]] = None,
            node_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeAttributeArgs']]]]] = None,
            node_groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeGroupArgs']]]]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            release_version: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            security_mode: Optional[pulumi.Input[str]] = None,
            subscription_config: Optional[pulumi.Input[pulumi.InputType['ClusterSubscriptionConfigArgs']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterApplicationConfigArgs']]]] application_configs: The application configurations of EMR cluster. See `application_configs` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] applications: The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterBootstrapScriptArgs']]]] bootstrap_scripts: The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster. See `bootstrap_scripts` below.
        :param pulumi.Input[str] cluster_name: The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        :param pulumi.Input[str] cluster_type: EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
        :param pulumi.Input[str] deploy_mode: The deploy mode of EMR cluster. Supported value: NORMAL or HA.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeAttributeArgs']]]] node_attributes: The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeGroupArgs']]]] node_groups: Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below.
        :param pulumi.Input[str] payment_type: Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        :param pulumi.Input[str] release_version: EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
        :param pulumi.Input[str] resource_group_id: The Id of resource group which the emr-cluster belongs.
        :param pulumi.Input[str] security_mode: The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
        :param pulumi.Input[pulumi.InputType['ClusterSubscriptionConfigArgs']] subscription_config: The detail configuration of subscription payment type. See `subscription_config` below.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["application_configs"] = application_configs
        __props__.__dict__["applications"] = applications
        __props__.__dict__["bootstrap_scripts"] = bootstrap_scripts
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["cluster_type"] = cluster_type
        __props__.__dict__["deploy_mode"] = deploy_mode
        __props__.__dict__["node_attributes"] = node_attributes
        __props__.__dict__["node_groups"] = node_groups
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["release_version"] = release_version
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["security_mode"] = security_mode
        __props__.__dict__["subscription_config"] = subscription_config
        __props__.__dict__["tags"] = tags
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationConfigs")
    def application_configs(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterApplicationConfig']]]:
        """
        The application configurations of EMR cluster. See `application_configs` below.
        """
        return pulumi.get(self, "application_configs")

    @property
    @pulumi.getter
    def applications(self) -> pulumi.Output[Sequence[str]]:
        """
        The applications of EMR cluster to be installed, e.g. HADOOP-COMMON, HDFS, YARN, HIVE, SPARK2, SPARK3, ZOOKEEPER etc. You can find all valid applications in emr web console.
        """
        return pulumi.get(self, "applications")

    @property
    @pulumi.getter(name="bootstrapScripts")
    def bootstrap_scripts(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterBootstrapScript']]]:
        """
        The bootstrap scripts to be effected when creating emr-cluster or resize emr-cluster. See `bootstrap_scripts` below.
        """
        return pulumi.get(self, "bootstrap_scripts")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        The name of emr cluster. The name length must be less than 64. Supported characters: chinese character, english character, number, "-", "_".
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> pulumi.Output[str]:
        """
        EMR Cluster Type, e.g. DATALAKE, OLAP, DATAFLOW, DATASERVING, CUSTOM etc. You can find all valid EMR cluster type in emr web console.
        """
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter(name="deployMode")
    def deploy_mode(self) -> pulumi.Output[str]:
        """
        The deploy mode of EMR cluster. Supported value: NORMAL or HA.
        """
        return pulumi.get(self, "deploy_mode")

    @property
    @pulumi.getter(name="nodeAttributes")
    def node_attributes(self) -> pulumi.Output[Sequence['outputs.ClusterNodeAttribute']]:
        """
        The node attributes of ecs instances which the emr-cluster belongs. See `node_attributes` below.
        """
        return pulumi.get(self, "node_attributes")

    @property
    @pulumi.getter(name="nodeGroups")
    def node_groups(self) -> pulumi.Output[Sequence['outputs.ClusterNodeGroup']]:
        """
        Groups of node, You can specify MASTER as a group, CORE as a group (just like the above example). See `node_groups` below.
        """
        return pulumi.get(self, "node_groups")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> pulumi.Output[str]:
        """
        EMR Version, e.g. EMR-5.10.0. You can find the all valid EMR Version in emr web console.
        """
        return pulumi.get(self, "release_version")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The Id of resource group which the emr-cluster belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> pulumi.Output[str]:
        """
        The security mode of EMR cluster. Supported value: NORMAL or KERBEROS.
        """
        return pulumi.get(self, "security_mode")

    @property
    @pulumi.getter(name="subscriptionConfig")
    def subscription_config(self) -> pulumi.Output[Optional['outputs.ClusterSubscriptionConfig']]:
        """
        The detail configuration of subscription payment type. See `subscription_config` below.
        """
        return pulumi.get(self, "subscription_config")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

