# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterApplicationConfig',
    'ClusterBootstrapScript',
    'ClusterBootstrapScriptNodeSelector',
    'ClusterNodeAttribute',
    'ClusterNodeGroup',
    'ClusterNodeGroupCostOptimizedConfig',
    'ClusterNodeGroupDataDisk',
    'ClusterNodeGroupSpotBidPrice',
    'ClusterNodeGroupSubscriptionConfig',
    'ClusterNodeGroupSystemDisk',
    'ClusterSubscriptionConfig',
    'GetClustersClusterResult',
    'GetClustersClusterTagResult',
]

@pulumi.output_type
class ClusterApplicationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationName":
            suggest = "application_name"
        elif key == "configFileName":
            suggest = "config_file_name"
        elif key == "configItemKey":
            suggest = "config_item_key"
        elif key == "configItemValue":
            suggest = "config_item_value"
        elif key == "configDescription":
            suggest = "config_description"
        elif key == "configScope":
            suggest = "config_scope"
        elif key == "nodeGroupId":
            suggest = "node_group_id"
        elif key == "nodeGroupName":
            suggest = "node_group_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterApplicationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterApplicationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterApplicationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_name: str,
                 config_file_name: str,
                 config_item_key: str,
                 config_item_value: str,
                 config_description: Optional[str] = None,
                 config_scope: Optional[str] = None,
                 node_group_id: Optional[str] = None,
                 node_group_name: Optional[str] = None):
        """
        :param str application_name: The application name of EMR cluster which has installed.
        :param str config_file_name: The configuration file name of application installed.
        :param str config_item_key: The configuration item key of application installed.
        :param str config_item_value: The configuration item value of application installed.
        :param str config_description: The configuration description of application installed.
        :param str config_scope: The configuration scope of emr cluster. Supported value: CLUSTER or NODEGROUP.
        :param str node_group_id: The configuration effected which node group id of emr cluster.
        :param str node_group_name: The configuration effected which node group name of emr cluster.
        """
        pulumi.set(__self__, "application_name", application_name)
        pulumi.set(__self__, "config_file_name", config_file_name)
        pulumi.set(__self__, "config_item_key", config_item_key)
        pulumi.set(__self__, "config_item_value", config_item_value)
        if config_description is not None:
            pulumi.set(__self__, "config_description", config_description)
        if config_scope is not None:
            pulumi.set(__self__, "config_scope", config_scope)
        if node_group_id is not None:
            pulumi.set(__self__, "node_group_id", node_group_id)
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> str:
        """
        The application name of EMR cluster which has installed.
        """
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter(name="configFileName")
    def config_file_name(self) -> str:
        """
        The configuration file name of application installed.
        """
        return pulumi.get(self, "config_file_name")

    @property
    @pulumi.getter(name="configItemKey")
    def config_item_key(self) -> str:
        """
        The configuration item key of application installed.
        """
        return pulumi.get(self, "config_item_key")

    @property
    @pulumi.getter(name="configItemValue")
    def config_item_value(self) -> str:
        """
        The configuration item value of application installed.
        """
        return pulumi.get(self, "config_item_value")

    @property
    @pulumi.getter(name="configDescription")
    def config_description(self) -> Optional[str]:
        """
        The configuration description of application installed.
        """
        return pulumi.get(self, "config_description")

    @property
    @pulumi.getter(name="configScope")
    def config_scope(self) -> Optional[str]:
        """
        The configuration scope of emr cluster. Supported value: CLUSTER or NODEGROUP.
        """
        return pulumi.get(self, "config_scope")

    @property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> Optional[str]:
        """
        The configuration effected which node group id of emr cluster.
        """
        return pulumi.get(self, "node_group_id")

    @property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> Optional[str]:
        """
        The configuration effected which node group name of emr cluster.
        """
        return pulumi.get(self, "node_group_name")


@pulumi.output_type
class ClusterBootstrapScript(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionFailStrategy":
            suggest = "execution_fail_strategy"
        elif key == "executionMoment":
            suggest = "execution_moment"
        elif key == "nodeSelector":
            suggest = "node_selector"
        elif key == "scriptArgs":
            suggest = "script_args"
        elif key == "scriptName":
            suggest = "script_name"
        elif key == "scriptPath":
            suggest = "script_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBootstrapScript. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBootstrapScript.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBootstrapScript.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_fail_strategy: str,
                 execution_moment: str,
                 node_selector: 'outputs.ClusterBootstrapScriptNodeSelector',
                 script_args: str,
                 script_name: str,
                 script_path: str,
                 priority: Optional[int] = None):
        """
        :param str execution_fail_strategy: The bootstrap scripts execution fail strategy, ’FAILED_BLOCKED’ or ‘FAILED_CONTINUE’ .
        :param str execution_moment: The bootstrap scripts execution moment, ’BEFORE_INSTALL’ or ‘AFTER_STARTED’ .
        :param 'ClusterBootstrapScriptNodeSelectorArgs' node_selector: The bootstrap scripts execution target. See `node_selector` below.
        :param str script_args: The bootstrap script args, e.g. "--a=b".
        :param str script_name: The bootstrap script name.
        :param str script_path: The bootstrap script path, e.g. "oss://bucket/path".
        :param int priority: The bootstrap scripts priority.
        """
        pulumi.set(__self__, "execution_fail_strategy", execution_fail_strategy)
        pulumi.set(__self__, "execution_moment", execution_moment)
        pulumi.set(__self__, "node_selector", node_selector)
        pulumi.set(__self__, "script_args", script_args)
        pulumi.set(__self__, "script_name", script_name)
        pulumi.set(__self__, "script_path", script_path)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter(name="executionFailStrategy")
    def execution_fail_strategy(self) -> str:
        """
        The bootstrap scripts execution fail strategy, ’FAILED_BLOCKED’ or ‘FAILED_CONTINUE’ .
        """
        return pulumi.get(self, "execution_fail_strategy")

    @property
    @pulumi.getter(name="executionMoment")
    def execution_moment(self) -> str:
        """
        The bootstrap scripts execution moment, ’BEFORE_INSTALL’ or ‘AFTER_STARTED’ .
        """
        return pulumi.get(self, "execution_moment")

    @property
    @pulumi.getter(name="nodeSelector")
    def node_selector(self) -> 'outputs.ClusterBootstrapScriptNodeSelector':
        """
        The bootstrap scripts execution target. See `node_selector` below.
        """
        return pulumi.get(self, "node_selector")

    @property
    @pulumi.getter(name="scriptArgs")
    def script_args(self) -> str:
        """
        The bootstrap script args, e.g. "--a=b".
        """
        return pulumi.get(self, "script_args")

    @property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> str:
        """
        The bootstrap script name.
        """
        return pulumi.get(self, "script_name")

    @property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> str:
        """
        The bootstrap script path, e.g. "oss://bucket/path".
        """
        return pulumi.get(self, "script_path")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        The bootstrap scripts priority.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class ClusterBootstrapScriptNodeSelector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeSelectType":
            suggest = "node_select_type"
        elif key == "nodeGroupId":
            suggest = "node_group_id"
        elif key == "nodeGroupName":
            suggest = "node_group_name"
        elif key == "nodeGroupTypes":
            suggest = "node_group_types"
        elif key == "nodeNames":
            suggest = "node_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterBootstrapScriptNodeSelector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterBootstrapScriptNodeSelector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterBootstrapScriptNodeSelector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_select_type: str,
                 node_group_id: Optional[str] = None,
                 node_group_name: Optional[str] = None,
                 node_group_types: Optional[Sequence[str]] = None,
                 node_names: Optional[Sequence[str]] = None):
        """
        :param str node_select_type: The bootstrap scripts execution target node select type. Supported value: NODE, NODEGROUP or CLUSTER.
        :param str node_group_id: The configuration effected which node group id of emr cluster.
        :param str node_group_name: The configuration effected which node group name of emr cluster.
        :param Sequence[str] node_group_types: The bootstrap scripts execution target node group types.
        :param Sequence[str] node_names: The bootstrap scripts execution target node names.
        """
        pulumi.set(__self__, "node_select_type", node_select_type)
        if node_group_id is not None:
            pulumi.set(__self__, "node_group_id", node_group_id)
        if node_group_name is not None:
            pulumi.set(__self__, "node_group_name", node_group_name)
        if node_group_types is not None:
            pulumi.set(__self__, "node_group_types", node_group_types)
        if node_names is not None:
            pulumi.set(__self__, "node_names", node_names)

    @property
    @pulumi.getter(name="nodeSelectType")
    def node_select_type(self) -> str:
        """
        The bootstrap scripts execution target node select type. Supported value: NODE, NODEGROUP or CLUSTER.
        """
        return pulumi.get(self, "node_select_type")

    @property
    @pulumi.getter(name="nodeGroupId")
    def node_group_id(self) -> Optional[str]:
        """
        The configuration effected which node group id of emr cluster.
        """
        return pulumi.get(self, "node_group_id")

    @property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> Optional[str]:
        """
        The configuration effected which node group name of emr cluster.
        """
        return pulumi.get(self, "node_group_name")

    @property
    @pulumi.getter(name="nodeGroupTypes")
    def node_group_types(self) -> Optional[Sequence[str]]:
        """
        The bootstrap scripts execution target node group types.
        """
        return pulumi.get(self, "node_group_types")

    @property
    @pulumi.getter(name="nodeNames")
    def node_names(self) -> Optional[Sequence[str]]:
        """
        The bootstrap scripts execution target node names.
        """
        return pulumi.get(self, "node_names")


@pulumi.output_type
class ClusterNodeAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyPairName":
            suggest = "key_pair_name"
        elif key == "ramRole":
            suggest = "ram_role"
        elif key == "securityGroupId":
            suggest = "security_group_id"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "zoneId":
            suggest = "zone_id"
        elif key == "dataDiskEncrypted":
            suggest = "data_disk_encrypted"
        elif key == "dataDiskKmsKeyId":
            suggest = "data_disk_kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_pair_name: str,
                 ram_role: str,
                 security_group_id: str,
                 vpc_id: str,
                 zone_id: str,
                 data_disk_encrypted: Optional[bool] = None,
                 data_disk_kms_key_id: Optional[str] = None):
        """
        :param str key_pair_name: The name of the key pair.
        :param str ram_role: Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        :param str security_group_id: Security Group ID for Cluster.
        :param str vpc_id: Used to retrieve instances belong to specified VPC.
        :param str zone_id: Zone ID, e.g. cn-hangzhou-i
        :param bool data_disk_encrypted: Whether to enable data disk encryption.
        :param str data_disk_kms_key_id: The kms key id used to encrypt the data disk. It takes effect when data_disk_encrypted is true.
        """
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        pulumi.set(__self__, "ram_role", ram_role)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_id", zone_id)
        if data_disk_encrypted is not None:
            pulumi.set(__self__, "data_disk_encrypted", data_disk_encrypted)
        if data_disk_kms_key_id is not None:
            pulumi.set(__self__, "data_disk_kms_key_id", data_disk_kms_key_id)

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> str:
        """
        The name of the key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter(name="ramRole")
    def ram_role(self) -> str:
        """
        Alicloud EMR uses roles to perform actions on your behalf when provisioning cluster resources, running applications, dynamically scaling resources. EMR uses the following roles when interacting with other Alicloud services. Default value is AliyunEmrEcsDefaultRole.
        """
        return pulumi.get(self, "ram_role")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        Security Group ID for Cluster.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Used to retrieve instances belong to specified VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        Zone ID, e.g. cn-hangzhou-i
        """
        return pulumi.get(self, "zone_id")

    @property
    @pulumi.getter(name="dataDiskEncrypted")
    def data_disk_encrypted(self) -> Optional[bool]:
        """
        Whether to enable data disk encryption.
        """
        return pulumi.get(self, "data_disk_encrypted")

    @property
    @pulumi.getter(name="dataDiskKmsKeyId")
    def data_disk_kms_key_id(self) -> Optional[str]:
        """
        The kms key id used to encrypt the data disk. It takes effect when data_disk_encrypted is true.
        """
        return pulumi.get(self, "data_disk_kms_key_id")


@pulumi.output_type
class ClusterNodeGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataDisks":
            suggest = "data_disks"
        elif key == "instanceTypes":
            suggest = "instance_types"
        elif key == "nodeCount":
            suggest = "node_count"
        elif key == "nodeGroupName":
            suggest = "node_group_name"
        elif key == "nodeGroupType":
            suggest = "node_group_type"
        elif key == "systemDisk":
            suggest = "system_disk"
        elif key == "additionalSecurityGroupIds":
            suggest = "additional_security_group_ids"
        elif key == "costOptimizedConfig":
            suggest = "cost_optimized_config"
        elif key == "gracefulShutdown":
            suggest = "graceful_shutdown"
        elif key == "paymentType":
            suggest = "payment_type"
        elif key == "spotBidPrices":
            suggest = "spot_bid_prices"
        elif key == "spotInstanceRemedy":
            suggest = "spot_instance_remedy"
        elif key == "subscriptionConfig":
            suggest = "subscription_config"
        elif key == "vswitchIds":
            suggest = "vswitch_ids"
        elif key == "withPublicIp":
            suggest = "with_public_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data_disks: Sequence['outputs.ClusterNodeGroupDataDisk'],
                 instance_types: Sequence[str],
                 node_count: int,
                 node_group_name: str,
                 node_group_type: str,
                 system_disk: 'outputs.ClusterNodeGroupSystemDisk',
                 additional_security_group_ids: Optional[Sequence[str]] = None,
                 cost_optimized_config: Optional['outputs.ClusterNodeGroupCostOptimizedConfig'] = None,
                 graceful_shutdown: Optional[bool] = None,
                 payment_type: Optional[str] = None,
                 spot_bid_prices: Optional[Sequence['outputs.ClusterNodeGroupSpotBidPrice']] = None,
                 spot_instance_remedy: Optional[bool] = None,
                 subscription_config: Optional['outputs.ClusterNodeGroupSubscriptionConfig'] = None,
                 vswitch_ids: Optional[Sequence[str]] = None,
                 with_public_ip: Optional[bool] = None):
        """
        :param Sequence['ClusterNodeGroupDataDiskArgs'] data_disks: Host Ecs data disks information in this node group. See `data_disks` below.
        :param Sequence[str] instance_types: Host Ecs instance types.
        :param int node_count: Host Ecs number in this node group.
        :param str node_group_name: The node group name of emr cluster.
        :param str node_group_type: The node group type of emr cluster, supported value: MASTER, CORE or TASK.
        :param 'ClusterNodeGroupSystemDiskArgs' system_disk: Host Ecs system disk information in this node group. See `system_disk` below.
        :param Sequence[str] additional_security_group_ids: Additional security Group IDS for Cluster, you can also specify this key for each node group.
        :param 'ClusterNodeGroupCostOptimizedConfigArgs' cost_optimized_config: The detail cost optimized configuration of emr cluster. See `cost_optimized_config` below.
        :param bool graceful_shutdown: Enable emr cluster of task node graceful decommission, ’true’ or ‘false’ .
        :param str payment_type: Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        :param Sequence['ClusterNodeGroupSpotBidPriceArgs'] spot_bid_prices: The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
        :param bool spot_instance_remedy: Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        :param 'ClusterNodeGroupSubscriptionConfigArgs' subscription_config: The detail configuration of subscription payment type. See `subscription_config` below.
        :param Sequence[str] vswitch_ids: Global vSwitch ids, you can also specify it in node group.
        :param bool with_public_ip: Whether the node has a public IP address enabled.
        """
        pulumi.set(__self__, "data_disks", data_disks)
        pulumi.set(__self__, "instance_types", instance_types)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_group_name", node_group_name)
        pulumi.set(__self__, "node_group_type", node_group_type)
        pulumi.set(__self__, "system_disk", system_disk)
        if additional_security_group_ids is not None:
            pulumi.set(__self__, "additional_security_group_ids", additional_security_group_ids)
        if cost_optimized_config is not None:
            pulumi.set(__self__, "cost_optimized_config", cost_optimized_config)
        if graceful_shutdown is not None:
            pulumi.set(__self__, "graceful_shutdown", graceful_shutdown)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if spot_bid_prices is not None:
            pulumi.set(__self__, "spot_bid_prices", spot_bid_prices)
        if spot_instance_remedy is not None:
            pulumi.set(__self__, "spot_instance_remedy", spot_instance_remedy)
        if subscription_config is not None:
            pulumi.set(__self__, "subscription_config", subscription_config)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if with_public_ip is not None:
            pulumi.set(__self__, "with_public_ip", with_public_ip)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Sequence['outputs.ClusterNodeGroupDataDisk']:
        """
        Host Ecs data disks information in this node group. See `data_disks` below.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Sequence[str]:
        """
        Host Ecs instance types.
        """
        return pulumi.get(self, "instance_types")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        """
        Host Ecs number in this node group.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nodeGroupName")
    def node_group_name(self) -> str:
        """
        The node group name of emr cluster.
        """
        return pulumi.get(self, "node_group_name")

    @property
    @pulumi.getter(name="nodeGroupType")
    def node_group_type(self) -> str:
        """
        The node group type of emr cluster, supported value: MASTER, CORE or TASK.
        """
        return pulumi.get(self, "node_group_type")

    @property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> 'outputs.ClusterNodeGroupSystemDisk':
        """
        Host Ecs system disk information in this node group. See `system_disk` below.
        """
        return pulumi.get(self, "system_disk")

    @property
    @pulumi.getter(name="additionalSecurityGroupIds")
    def additional_security_group_ids(self) -> Optional[Sequence[str]]:
        """
        Additional security Group IDS for Cluster, you can also specify this key for each node group.
        """
        return pulumi.get(self, "additional_security_group_ids")

    @property
    @pulumi.getter(name="costOptimizedConfig")
    def cost_optimized_config(self) -> Optional['outputs.ClusterNodeGroupCostOptimizedConfig']:
        """
        The detail cost optimized configuration of emr cluster. See `cost_optimized_config` below.
        """
        return pulumi.get(self, "cost_optimized_config")

    @property
    @pulumi.getter(name="gracefulShutdown")
    def graceful_shutdown(self) -> Optional[bool]:
        """
        Enable emr cluster of task node graceful decommission, ’true’ or ‘false’ .
        """
        return pulumi.get(self, "graceful_shutdown")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[str]:
        """
        Payment Type for this cluster. Supported value: PayAsYouGo or Subscription.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="spotBidPrices")
    def spot_bid_prices(self) -> Optional[Sequence['outputs.ClusterNodeGroupSpotBidPrice']]:
        """
        The spot bid prices of a PayAsYouGo instance. See `spot_bid_prices` below.
        """
        return pulumi.get(self, "spot_bid_prices")

    @property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> Optional[bool]:
        """
        Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @property
    @pulumi.getter(name="subscriptionConfig")
    def subscription_config(self) -> Optional['outputs.ClusterNodeGroupSubscriptionConfig']:
        """
        The detail configuration of subscription payment type. See `subscription_config` below.
        """
        return pulumi.get(self, "subscription_config")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[Sequence[str]]:
        """
        Global vSwitch ids, you can also specify it in node group.
        """
        return pulumi.get(self, "vswitch_ids")

    @property
    @pulumi.getter(name="withPublicIp")
    def with_public_ip(self) -> Optional[bool]:
        """
        Whether the node has a public IP address enabled.
        """
        return pulumi.get(self, "with_public_ip")


@pulumi.output_type
class ClusterNodeGroupCostOptimizedConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onDemandBaseCapacity":
            suggest = "on_demand_base_capacity"
        elif key == "onDemandPercentageAboveBaseCapacity":
            suggest = "on_demand_percentage_above_base_capacity"
        elif key == "spotInstancePools":
            suggest = "spot_instance_pools"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupCostOptimizedConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupCostOptimizedConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupCostOptimizedConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_demand_base_capacity: int,
                 on_demand_percentage_above_base_capacity: int,
                 spot_instance_pools: int):
        """
        :param int on_demand_base_capacity: The cost optimized configuration which on demand based capacity.
        :param int on_demand_percentage_above_base_capacity: The cost optimized configuration which on demand percentage above based capacity.
        :param int spot_instance_pools: The cost optimized configuration with spot instance pools.
        """
        pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)

    @property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> int:
        """
        The cost optimized configuration which on demand based capacity.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> int:
        """
        The cost optimized configuration which on demand percentage above based capacity.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> int:
        """
        The cost optimized configuration with spot instance pools.
        """
        return pulumi.get(self, "spot_instance_pools")


@pulumi.output_type
class ClusterNodeGroupDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "performanceLevel":
            suggest = "performance_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: str,
                 size: int,
                 count: Optional[int] = None,
                 performance_level: Optional[str] = None):
        """
        :param str category: The type of the data disk. Valid values: `cloud_efficiency` and `cloud_essd`.
        :param int size: The size of a data disk, at least 40. Unit: GiB.
        :param int count: The count of a data disk.
        :param str performance_level: Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "size", size)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        The type of the data disk. Valid values: `cloud_efficiency` and `cloud_essd`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of a data disk, at least 40. Unit: GiB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The count of a data disk.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[str]:
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        return pulumi.get(self, "performance_level")


@pulumi.output_type
class ClusterNodeGroupSpotBidPrice(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bidPrice":
            suggest = "bid_price"
        elif key == "instanceType":
            suggest = "instance_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupSpotBidPrice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupSpotBidPrice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupSpotBidPrice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bid_price: int,
                 instance_type: str):
        """
        :param int bid_price: The spot bid price of a PayAsYouGo instance.
        :param str instance_type: Host Ecs instance type.
        """
        pulumi.set(__self__, "bid_price", bid_price)
        pulumi.set(__self__, "instance_type", instance_type)

    @property
    @pulumi.getter(name="bidPrice")
    def bid_price(self) -> int:
        """
        The spot bid price of a PayAsYouGo instance.
        """
        return pulumi.get(self, "bid_price")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Host Ecs instance type.
        """
        return pulumi.get(self, "instance_type")


@pulumi.output_type
class ClusterNodeGroupSubscriptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "paymentDuration":
            suggest = "payment_duration"
        elif key == "paymentDurationUnit":
            suggest = "payment_duration_unit"
        elif key == "autoRenew":
            suggest = "auto_renew"
        elif key == "autoRenewDuration":
            suggest = "auto_renew_duration"
        elif key == "autoRenewDurationUnit":
            suggest = "auto_renew_duration_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupSubscriptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupSubscriptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupSubscriptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 payment_duration: int,
                 payment_duration_unit: str,
                 auto_renew: Optional[bool] = None,
                 auto_renew_duration: Optional[int] = None,
                 auto_renew_duration_unit: Optional[str] = None):
        """
        :param int payment_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param str payment_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        :param bool auto_renew: Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        :param int auto_renew_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param str auto_renew_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        pulumi.set(__self__, "payment_duration", payment_duration)
        pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if auto_renew_duration_unit is not None:
            pulumi.set(__self__, "auto_renew_duration_unit", auto_renew_duration_unit)

    @property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> int:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "payment_duration")

    @property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> str:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "payment_duration_unit")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[bool]:
        """
        Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[int]:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "auto_renew_duration")

    @property
    @pulumi.getter(name="autoRenewDurationUnit")
    def auto_renew_duration_unit(self) -> Optional[str]:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "auto_renew_duration_unit")


@pulumi.output_type
class ClusterNodeGroupSystemDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "performanceLevel":
            suggest = "performance_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterNodeGroupSystemDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterNodeGroupSystemDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterNodeGroupSystemDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category: str,
                 size: int,
                 count: Optional[int] = None,
                 performance_level: Optional[str] = None):
        """
        :param str category: The type of the data disk. Valid values: `cloud_efficiency` and `cloud_essd`.
        :param int size: The size of a data disk, at least 40. Unit: GiB.
        :param int count: The count of a data disk.
        :param str performance_level: Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "size", size)
        if count is not None:
            pulumi.set(__self__, "count", count)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        The type of the data disk. Valid values: `cloud_efficiency` and `cloud_essd`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The size of a data disk, at least 40. Unit: GiB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def count(self) -> Optional[int]:
        """
        The count of a data disk.
        """
        return pulumi.get(self, "count")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[str]:
        """
        Worker node data disk performance level, when `category` values `cloud_essd`, the optional values are `PL0`, `PL1`, `PL2` or `PL3`, but the specific performance level is related to the disk capacity.
        """
        return pulumi.get(self, "performance_level")


@pulumi.output_type
class ClusterSubscriptionConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "paymentDuration":
            suggest = "payment_duration"
        elif key == "paymentDurationUnit":
            suggest = "payment_duration_unit"
        elif key == "autoRenew":
            suggest = "auto_renew"
        elif key == "autoRenewDuration":
            suggest = "auto_renew_duration"
        elif key == "autoRenewDurationUnit":
            suggest = "auto_renew_duration_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterSubscriptionConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterSubscriptionConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterSubscriptionConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 payment_duration: int,
                 payment_duration_unit: str,
                 auto_renew: Optional[bool] = None,
                 auto_renew_duration: Optional[int] = None,
                 auto_renew_duration_unit: Optional[str] = None):
        """
        :param int payment_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param str payment_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        :param bool auto_renew: Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        :param int auto_renew_duration: If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        :param str auto_renew_duration_unit: If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        pulumi.set(__self__, "payment_duration", payment_duration)
        pulumi.set(__self__, "payment_duration_unit", payment_duration_unit)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_renew_duration is not None:
            pulumi.set(__self__, "auto_renew_duration", auto_renew_duration)
        if auto_renew_duration_unit is not None:
            pulumi.set(__self__, "auto_renew_duration_unit", auto_renew_duration_unit)

    @property
    @pulumi.getter(name="paymentDuration")
    def payment_duration(self) -> int:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "payment_duration")

    @property
    @pulumi.getter(name="paymentDurationUnit")
    def payment_duration_unit(self) -> str:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "payment_duration_unit")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[bool]:
        """
        Auto renew for prepaid, ’true’ or ‘false’ . Default value: false.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="autoRenewDuration")
    def auto_renew_duration(self) -> Optional[int]:
        """
        If paymentType is Subscription, this should be specified. Supported value: 1、2、3、4、5、6、7、8、9、12、24、36、48.
        """
        return pulumi.get(self, "auto_renew_duration")

    @property
    @pulumi.getter(name="autoRenewDurationUnit")
    def auto_renew_duration_unit(self) -> Optional[str]:
        """
        If paymentType is Subscription, this should be specified. Supported value: Month or Year.
        """
        return pulumi.get(self, "auto_renew_duration_unit")


@pulumi.output_type
class GetClustersClusterResult(dict):
    def __init__(__self__, *,
                 cluster_id: str,
                 cluster_name: str,
                 cluster_state: str,
                 cluster_type: str,
                 create_time: str,
                 emr_default_role: str,
                 end_time: str,
                 expire_time: str,
                 payment_type: str,
                 ready_time: str,
                 release_version: str,
                 resource_group_id: str,
                 state_change_reason: Mapping[str, Any],
                 tags: Sequence['outputs.GetClustersClusterTagResult']):
        """
        :param str cluster_id: The first ID of the resource.
        :param str cluster_name: The name of the emr cluster.
        :param str cluster_state: The state of the emr cluster.
        :param str cluster_type: The type of the emr cluster.
        :param str create_time: The creation time of the resource.
        :param str emr_default_role: The ecs default role belongs to this emr cluster.
        :param str end_time: The end time of the resource.
        :param str expire_time: The expire time of the resource.
        :param str payment_type: The payment type of the emr cluster.
        :param str ready_time: The ready time of the resource.
        :param str release_version: The release version of the resource.
        :param str resource_group_id: The resource group id of the resource.
        :param Mapping[str, Any] state_change_reason: The cluster state change reason.
        :param Sequence['GetClustersClusterTagArgs'] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "cluster_state", cluster_state)
        pulumi.set(__self__, "cluster_type", cluster_type)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "emr_default_role", emr_default_role)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "expire_time", expire_time)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "ready_time", ready_time)
        pulumi.set(__self__, "release_version", release_version)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "state_change_reason", state_change_reason)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        The name of the emr cluster.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="clusterState")
    def cluster_state(self) -> str:
        """
        The state of the emr cluster.
        """
        return pulumi.get(self, "cluster_state")

    @property
    @pulumi.getter(name="clusterType")
    def cluster_type(self) -> str:
        """
        The type of the emr cluster.
        """
        return pulumi.get(self, "cluster_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="emrDefaultRole")
    def emr_default_role(self) -> str:
        """
        The ecs default role belongs to this emr cluster.
        """
        return pulumi.get(self, "emr_default_role")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The end time of the resource.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The expire time of the resource.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The payment type of the emr cluster.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="readyTime")
    def ready_time(self) -> str:
        """
        The ready time of the resource.
        """
        return pulumi.get(self, "ready_time")

    @property
    @pulumi.getter(name="releaseVersion")
    def release_version(self) -> str:
        """
        The release version of the resource.
        """
        return pulumi.get(self, "release_version")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The resource group id of the resource.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="stateChangeReason")
    def state_change_reason(self) -> Mapping[str, Any]:
        """
        The cluster state change reason.
        """
        return pulumi.get(self, "state_change_reason")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetClustersClusterTagResult']:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetClustersClusterTagResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


