# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['EipArgs', 'Eip']

@pulumi.input_type
class EipArgs:
    def __init__(__self__, *,
                 ens_region_id: pulumi.Input[str],
                 internet_charge_type: pulumi.Input[str],
                 payment_type: pulumi.Input[str],
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_name: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Eip resource.
        :param pulumi.Input[str] ens_region_id: Ens node ID.
        :param pulumi.Input[str] internet_charge_type: Billing type of the EIP instance. Valid value: 95bandwidthbymonth.
        :param pulumi.Input[str] payment_type: The billing type of the EIP instanceValue: PayAsYouGo.
        :param pulumi.Input[int] bandwidth: The peak bandwidth of the EIP to be specified.Rules:Default value: 5, value range: 5~10000, unit: Mbps. Example value: 5.
        :param pulumi.Input[str] description: The description of the EIP.
        :param pulumi.Input[str] eip_name: Name of the EIP instance.
        :param pulumi.Input[str] isp: Internet service provider, if not filled in, it will be assigned according to the default rules.
        """
        pulumi.set(__self__, "ens_region_id", ens_region_id)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "payment_type", payment_type)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_name is not None:
            pulumi.set(__self__, "eip_name", eip_name)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)

    @property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> pulumi.Input[str]:
        """
        Ens node ID.
        """
        return pulumi.get(self, "ens_region_id")

    @ens_region_id.setter
    def ens_region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "ens_region_id", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Input[str]:
        """
        Billing type of the EIP instance. Valid value: 95bandwidthbymonth.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        The billing type of the EIP instanceValue: PayAsYouGo.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The peak bandwidth of the EIP to be specified.Rules:Default value: 5, value range: 5~10000, unit: Mbps. Example value: 5.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the EIP.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eipName")
    def eip_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the EIP instance.
        """
        return pulumi.get(self, "eip_name")

    @eip_name.setter
    def eip_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_name", value)

    @property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[str]]:
        """
        Internet service provider, if not filled in, it will be assigned according to the default rules.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "isp", value)


@pulumi.input_type
class _EipState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_name: Optional[pulumi.Input[str]] = None,
                 ens_region_id: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Eip resources.
        :param pulumi.Input[int] bandwidth: The peak bandwidth of the EIP to be specified.Rules:Default value: 5, value range: 5~10000, unit: Mbps. Example value: 5.
        :param pulumi.Input[str] create_time: The creation time of the EIP instance.
        :param pulumi.Input[str] description: The description of the EIP.
        :param pulumi.Input[str] eip_name: Name of the EIP instance.
        :param pulumi.Input[str] ens_region_id: Ens node ID.
        :param pulumi.Input[str] internet_charge_type: Billing type of the EIP instance. Valid value: 95bandwidthbymonth.
        :param pulumi.Input[str] isp: Internet service provider, if not filled in, it will be assigned according to the default rules.
        :param pulumi.Input[str] payment_type: The billing type of the EIP instanceValue: PayAsYouGo.
        :param pulumi.Input[str] status: The status of the EIP instance.Rules:Associating: bindingUnassociating: UnbindingInUse: AssignedAvailable: AvailableCreating: CreatingReleasing: Releasing.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_name is not None:
            pulumi.set(__self__, "eip_name", eip_name)
        if ens_region_id is not None:
            pulumi.set(__self__, "ens_region_id", ens_region_id)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The peak bandwidth of the EIP to be specified.Rules:Default value: 5, value range: 5~10000, unit: Mbps. Example value: 5.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the EIP instance.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the EIP.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eipName")
    def eip_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the EIP instance.
        """
        return pulumi.get(self, "eip_name")

    @eip_name.setter
    def eip_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_name", value)

    @property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        Ens node ID.
        """
        return pulumi.get(self, "ens_region_id")

    @ens_region_id.setter
    def ens_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ens_region_id", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Billing type of the EIP instance. Valid value: 95bandwidthbymonth.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[str]]:
        """
        Internet service provider, if not filled in, it will be assigned according to the default rules.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "isp", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        The billing type of the EIP instanceValue: PayAsYouGo.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the EIP instance.Rules:Associating: bindingUnassociating: UnbindingInUse: AssignedAvailable: AvailableCreating: CreatingReleasing: Releasing.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class Eip(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_name: Optional[pulumi.Input[str]] = None,
                 ens_region_id: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a ENS Eip resource. Edge elastic public network IP. When you use it for the first time, please contact the product classmates to add a resource whitelist.

        For information about ENS Eip and how to use it, see [What is Eip](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createeipinstance).

        > **NOTE:** Available since v1.213.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ens.Eip("default",
            description="EipDescription_autotest",
            bandwidth=5,
            isp="cmcc",
            payment_type="PayAsYouGo",
            ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
            eip_name=name,
            internet_charge_type="95BandwidthByMonth")
        ```

        ## Import

        ENS Eip can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ens/eip:Eip example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth: The peak bandwidth of the EIP to be specified.Rules:Default value: 5, value range: 5~10000, unit: Mbps. Example value: 5.
        :param pulumi.Input[str] description: The description of the EIP.
        :param pulumi.Input[str] eip_name: Name of the EIP instance.
        :param pulumi.Input[str] ens_region_id: Ens node ID.
        :param pulumi.Input[str] internet_charge_type: Billing type of the EIP instance. Valid value: 95bandwidthbymonth.
        :param pulumi.Input[str] isp: Internet service provider, if not filled in, it will be assigned according to the default rules.
        :param pulumi.Input[str] payment_type: The billing type of the EIP instanceValue: PayAsYouGo.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ENS Eip resource. Edge elastic public network IP. When you use it for the first time, please contact the product classmates to add a resource whitelist.

        For information about ENS Eip and how to use it, see [What is Eip](https://www.alibabacloud.com/help/en/ens/developer-reference/api-createeipinstance).

        > **NOTE:** Available since v1.213.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.ens.Eip("default",
            description="EipDescription_autotest",
            bandwidth=5,
            isp="cmcc",
            payment_type="PayAsYouGo",
            ens_region_id="cn-chenzhou-telecom_unicom_cmcc",
            eip_name=name,
            internet_charge_type="95BandwidthByMonth")
        ```

        ## Import

        ENS Eip can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ens/eip:Eip example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_name: Optional[pulumi.Input[str]] = None,
                 ens_region_id: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipArgs.__new__(EipArgs)

            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["description"] = description
            __props__.__dict__["eip_name"] = eip_name
            if ens_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'ens_region_id'")
            __props__.__dict__["ens_region_id"] = ens_region_id
            if internet_charge_type is None and not opts.urn:
                raise TypeError("Missing required property 'internet_charge_type'")
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["isp"] = isp
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Eip, __self__).__init__(
            'alicloud:ens/eip:Eip',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[int]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            eip_name: Optional[pulumi.Input[str]] = None,
            ens_region_id: Optional[pulumi.Input[str]] = None,
            internet_charge_type: Optional[pulumi.Input[str]] = None,
            isp: Optional[pulumi.Input[str]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'Eip':
        """
        Get an existing Eip resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth: The peak bandwidth of the EIP to be specified.Rules:Default value: 5, value range: 5~10000, unit: Mbps. Example value: 5.
        :param pulumi.Input[str] create_time: The creation time of the EIP instance.
        :param pulumi.Input[str] description: The description of the EIP.
        :param pulumi.Input[str] eip_name: Name of the EIP instance.
        :param pulumi.Input[str] ens_region_id: Ens node ID.
        :param pulumi.Input[str] internet_charge_type: Billing type of the EIP instance. Valid value: 95bandwidthbymonth.
        :param pulumi.Input[str] isp: Internet service provider, if not filled in, it will be assigned according to the default rules.
        :param pulumi.Input[str] payment_type: The billing type of the EIP instanceValue: PayAsYouGo.
        :param pulumi.Input[str] status: The status of the EIP instance.Rules:Associating: bindingUnassociating: UnbindingInUse: AssignedAvailable: AvailableCreating: CreatingReleasing: Releasing.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipState.__new__(_EipState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["eip_name"] = eip_name
        __props__.__dict__["ens_region_id"] = ens_region_id
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["isp"] = isp
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["status"] = status
        return Eip(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[int]:
        """
        The peak bandwidth of the EIP to be specified.Rules:Default value: 5, value range: 5~10000, unit: Mbps. Example value: 5.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time of the EIP instance.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the EIP.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eipName")
    def eip_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the EIP instance.
        """
        return pulumi.get(self, "eip_name")

    @property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> pulumi.Output[str]:
        """
        Ens node ID.
        """
        return pulumi.get(self, "ens_region_id")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[str]:
        """
        Billing type of the EIP instance. Valid value: 95bandwidthbymonth.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter
    def isp(self) -> pulumi.Output[str]:
        """
        Internet service provider, if not filled in, it will be assigned according to the default rules.
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        The billing type of the EIP instanceValue: PayAsYouGo.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the EIP instance.Rules:Associating: bindingUnassociating: UnbindingInUse: AssignedAvailable: AvailableCreating: CreatingReleasing: Releasing.
        """
        return pulumi.get(self, "status")

