# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 instance_type: pulumi.Input[str],
                 internet_max_bandwidth_out: pulumi.Input[int],
                 payment_type: pulumi.Input[str],
                 schedule_area_level: pulumi.Input[str],
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 carrier: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]] = None,
                 ens_region_id: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_charge_strategy: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 net_district_code: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 public_ip_identification: Optional[pulumi.Input[bool]] = None,
                 quantity: Optional[pulumi.Input[str]] = None,
                 scheduling_price_strategy: Optional[pulumi.Input[str]] = None,
                 scheduling_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk: Optional[pulumi.Input['InstanceSystemDiskArgs']] = None,
                 unique_suffix: Optional[pulumi.Input[bool]] = None,
                 user_data: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] instance_type: Instance specifications type.
        :param pulumi.Input[int] internet_max_bandwidth_out: The maximum public network bandwidth.
        :param pulumi.Input[str] payment_type: Instance payment method, Subscription: prepaid, monthly package; PayAsYouGo: Pay as you go.
        :param pulumi.Input[str] schedule_area_level: Scheduling level, which is used to perform node level or regional scheduling.
        :param pulumi.Input[bool] auto_renew: Whether to automatically renew, default to False, this parameter is invalid when paying by volume.
        :param pulumi.Input[str] carrier: Operator, required for regional level scheduling, invalid for node level scheduling.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]] data_disks: Data disk specifications. See `data_disk` below.
        :param pulumi.Input[str] ens_region_id: Node id. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big, Middle, Small, EnsRegionId is not required.
        :param pulumi.Input[str] host_name: Host Name.
        :param pulumi.Input[str] image_id: The Image Id field. If InstanceType is arm_bmi, the image Id is a non-required parameter. If instanceType is another specification value, the image Id is a required parameter.
        :param pulumi.Input[str] instance_charge_strategy: Instance billing strategy, instance: instance granularity (prepaid method currently does not support instance), user: by user dimension (not transferred or prepaid method supports user).
        :param pulumi.Input[str] instance_name: The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-). The default value is the InstanceId of the instance.
        :param pulumi.Input[str] internet_charge_type: Instance Charge type.it could be BandwidthByDay, 95BandwidthByMonth, PayByBandwidth4thMonth.
        :param pulumi.Input[str] net_district_code: Region code, required for regional level scheduling, invalid for node level scheduling.
        :param pulumi.Input[str] password: The password of the instance。It is 8 to 30 characters in length and must contain three types of characters: uppercase and lowercase letters, numbers, and special symbols. The following special symbols can be set: '''()'~! @#$%^& *-_+ =|{}[]:;',.? /'''.
        :param pulumi.Input[bool] password_inherit: Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed.
        :param pulumi.Input[int] period: The duration of purchasing resources. If PeriodUnit is not specified, it defaults to purchasing on a monthly basis. Currently, only days and months are supported. If PeriodUnit=Day, Period can only be 3. If PeriodUnit=Monthc, then Period can be 1-9,12.
        :param pulumi.Input[str] period_unit: The unit of time for purchasing resources. If PeriodUnit is not specified, it defaults to purchasing by Month. Currently, only days and months are supported. If PeriodUnit=Day, Period can only be 3. If PeriodUnit=Month, then Period can be 1-9,12.
        :param pulumi.Input[bool] public_ip_identification: Whether to allocate public IP. Value：true (default): can be assigned，false: cannot be assigned.
        :param pulumi.Input[str] quantity: Number of instances.
        :param pulumi.Input[str] scheduling_price_strategy: Dispatch price strategy. If left blank, it defaults to prioritizing low prices. Values: PriceLowPriority (priority high price), PriceLowPriority (priority low price).
        :param pulumi.Input[str] scheduling_strategy: When scheduling at the node level, it is Concentrate. When scheduling at the regional level, it is selected according to customer needs. Concentrate: Centralized; Disperse: Disperse.
        :param pulumi.Input['InstanceSystemDiskArgs'] system_disk: The field representing the system disk specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
        :param pulumi.Input[bool] unique_suffix: Specifies whether to automatically append sequential suffixes to the hostnames specified by the HostName parameter and instance names specified by the InstanceName parameter when you create multiple instances at a time. The sequential suffix ranges from 001 to 999. Valid values:  true false Default value: false.
        :param pulumi.Input[str] user_data: User defined data, with a maximum support of 16KB. You can input UserData information. UserData encoded in Base64 format.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "schedule_area_level", schedule_area_level)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if carrier is not None:
            pulumi.set(__self__, "carrier", carrier)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if ens_region_id is not None:
            pulumi.set(__self__, "ens_region_id", ens_region_id)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_charge_strategy is not None:
            pulumi.set(__self__, "instance_charge_strategy", instance_charge_strategy)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if net_district_code is not None:
            pulumi.set(__self__, "net_district_code", net_district_code)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if public_ip_identification is not None:
            pulumi.set(__self__, "public_ip_identification", public_ip_identification)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)
        if scheduling_price_strategy is not None:
            pulumi.set(__self__, "scheduling_price_strategy", scheduling_price_strategy)
        if scheduling_strategy is not None:
            pulumi.set(__self__, "scheduling_strategy", scheduling_strategy)
        if system_disk is not None:
            pulumi.set(__self__, "system_disk", system_disk)
        if unique_suffix is not None:
            pulumi.set(__self__, "unique_suffix", unique_suffix)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Input[str]:
        """
        Instance specifications type.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> pulumi.Input[int]:
        """
        The maximum public network bandwidth.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: pulumi.Input[int]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Input[str]:
        """
        Instance payment method, Subscription: prepaid, monthly package; PayAsYouGo: Pay as you go.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter(name="scheduleAreaLevel")
    def schedule_area_level(self) -> pulumi.Input[str]:
        """
        Scheduling level, which is used to perform node level or regional scheduling.
        """
        return pulumi.get(self, "schedule_area_level")

    @schedule_area_level.setter
    def schedule_area_level(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule_area_level", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically renew, default to False, this parameter is invalid when paying by volume.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter
    def carrier(self) -> Optional[pulumi.Input[str]]:
        """
        Operator, required for regional level scheduling, invalid for node level scheduling.
        """
        return pulumi.get(self, "carrier")

    @carrier.setter
    def carrier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "carrier", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]:
        """
        Data disk specifications. See `data_disk` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        Node id. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big, Middle, Small, EnsRegionId is not required.
        """
        return pulumi.get(self, "ens_region_id")

    @ens_region_id.setter
    def ens_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ens_region_id", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host Name.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Image Id field. If InstanceType is arm_bmi, the image Id is a non-required parameter. If instanceType is another specification value, the image Id is a required parameter.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceChargeStrategy")
    def instance_charge_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Instance billing strategy, instance: instance granularity (prepaid method currently does not support instance), user: by user dimension (not transferred or prepaid method supports user).
        """
        return pulumi.get(self, "instance_charge_strategy")

    @instance_charge_strategy.setter
    def instance_charge_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_strategy", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-). The default value is the InstanceId of the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance Charge type.it could be BandwidthByDay, 95BandwidthByMonth, PayByBandwidth4thMonth.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter(name="netDistrictCode")
    def net_district_code(self) -> Optional[pulumi.Input[str]]:
        """
        Region code, required for regional level scheduling, invalid for node level scheduling.
        """
        return pulumi.get(self, "net_district_code")

    @net_district_code.setter
    def net_district_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "net_district_code", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the instance。It is 8 to 30 characters in length and must contain three types of characters: uppercase and lowercase letters, numbers, and special symbols. The following special symbols can be set: '''()'~! @#$%^& *-_+ =|{}[]:;',.? /'''.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed.
        """
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_inherit", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration of purchasing resources. If PeriodUnit is not specified, it defaults to purchasing on a monthly basis. Currently, only days and months are supported. If PeriodUnit=Day, Period can only be 3. If PeriodUnit=Monthc, then Period can be 1-9,12.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of time for purchasing resources. If PeriodUnit is not specified, it defaults to purchasing by Month. Currently, only days and months are supported. If PeriodUnit=Day, Period can only be 3. If PeriodUnit=Month, then Period can be 1-9,12.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="publicIpIdentification")
    def public_ip_identification(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allocate public IP. Value：true (default): can be assigned，false: cannot be assigned.
        """
        return pulumi.get(self, "public_ip_identification")

    @public_ip_identification.setter
    def public_ip_identification(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_ip_identification", value)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[pulumi.Input[str]]:
        """
        Number of instances.
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quantity", value)

    @property
    @pulumi.getter(name="schedulingPriceStrategy")
    def scheduling_price_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Dispatch price strategy. If left blank, it defaults to prioritizing low prices. Values: PriceLowPriority (priority high price), PriceLowPriority (priority low price).
        """
        return pulumi.get(self, "scheduling_price_strategy")

    @scheduling_price_strategy.setter
    def scheduling_price_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduling_price_strategy", value)

    @property
    @pulumi.getter(name="schedulingStrategy")
    def scheduling_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        When scheduling at the node level, it is Concentrate. When scheduling at the regional level, it is selected according to customer needs. Concentrate: Centralized; Disperse: Disperse.
        """
        return pulumi.get(self, "scheduling_strategy")

    @scheduling_strategy.setter
    def scheduling_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduling_strategy", value)

    @property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> Optional[pulumi.Input['InstanceSystemDiskArgs']]:
        """
        The field representing the system disk specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
        """
        return pulumi.get(self, "system_disk")

    @system_disk.setter
    def system_disk(self, value: Optional[pulumi.Input['InstanceSystemDiskArgs']]):
        pulumi.set(self, "system_disk", value)

    @property
    @pulumi.getter(name="uniqueSuffix")
    def unique_suffix(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically append sequential suffixes to the hostnames specified by the HostName parameter and instance names specified by the InstanceName parameter when you create multiple instances at a time. The sequential suffix ranges from 001 to 999. Valid values:  true false Default value: false.
        """
        return pulumi.get(self, "unique_suffix")

    @unique_suffix.setter
    def unique_suffix(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unique_suffix", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        User defined data, with a maximum support of 16KB. You can input UserData information. UserData encoded in Base64 format.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 carrier: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]] = None,
                 ens_region_id: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_charge_strategy: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 net_district_code: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 public_ip_identification: Optional[pulumi.Input[bool]] = None,
                 quantity: Optional[pulumi.Input[str]] = None,
                 schedule_area_level: Optional[pulumi.Input[str]] = None,
                 scheduling_price_strategy: Optional[pulumi.Input[str]] = None,
                 scheduling_strategy: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system_disk: Optional[pulumi.Input['InstanceSystemDiskArgs']] = None,
                 unique_suffix: Optional[pulumi.Input[bool]] = None,
                 user_data: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[bool] auto_renew: Whether to automatically renew, default to False, this parameter is invalid when paying by volume.
        :param pulumi.Input[str] carrier: Operator, required for regional level scheduling, invalid for node level scheduling.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]] data_disks: Data disk specifications. See `data_disk` below.
        :param pulumi.Input[str] ens_region_id: Node id. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big, Middle, Small, EnsRegionId is not required.
        :param pulumi.Input[str] host_name: Host Name.
        :param pulumi.Input[str] image_id: The Image Id field. If InstanceType is arm_bmi, the image Id is a non-required parameter. If instanceType is another specification value, the image Id is a required parameter.
        :param pulumi.Input[str] instance_charge_strategy: Instance billing strategy, instance: instance granularity (prepaid method currently does not support instance), user: by user dimension (not transferred or prepaid method supports user).
        :param pulumi.Input[str] instance_name: The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-). The default value is the InstanceId of the instance.
        :param pulumi.Input[str] instance_type: Instance specifications type.
        :param pulumi.Input[str] internet_charge_type: Instance Charge type.it could be BandwidthByDay, 95BandwidthByMonth, PayByBandwidth4thMonth.
        :param pulumi.Input[int] internet_max_bandwidth_out: The maximum public network bandwidth.
        :param pulumi.Input[str] net_district_code: Region code, required for regional level scheduling, invalid for node level scheduling.
        :param pulumi.Input[str] password: The password of the instance。It is 8 to 30 characters in length and must contain three types of characters: uppercase and lowercase letters, numbers, and special symbols. The following special symbols can be set: '''()'~! @#$%^& *-_+ =|{}[]:;',.? /'''.
        :param pulumi.Input[bool] password_inherit: Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed.
        :param pulumi.Input[str] payment_type: Instance payment method, Subscription: prepaid, monthly package; PayAsYouGo: Pay as you go.
        :param pulumi.Input[int] period: The duration of purchasing resources. If PeriodUnit is not specified, it defaults to purchasing on a monthly basis. Currently, only days and months are supported. If PeriodUnit=Day, Period can only be 3. If PeriodUnit=Monthc, then Period can be 1-9,12.
        :param pulumi.Input[str] period_unit: The unit of time for purchasing resources. If PeriodUnit is not specified, it defaults to purchasing by Month. Currently, only days and months are supported. If PeriodUnit=Day, Period can only be 3. If PeriodUnit=Month, then Period can be 1-9,12.
        :param pulumi.Input[bool] public_ip_identification: Whether to allocate public IP. Value：true (default): can be assigned，false: cannot be assigned.
        :param pulumi.Input[str] quantity: Number of instances.
        :param pulumi.Input[str] schedule_area_level: Scheduling level, which is used to perform node level or regional scheduling.
        :param pulumi.Input[str] scheduling_price_strategy: Dispatch price strategy. If left blank, it defaults to prioritizing low prices. Values: PriceLowPriority (priority high price), PriceLowPriority (priority low price).
        :param pulumi.Input[str] scheduling_strategy: When scheduling at the node level, it is Concentrate. When scheduling at the regional level, it is selected according to customer needs. Concentrate: Centralized; Disperse: Disperse.
        :param pulumi.Input[str] status: the status of the resource.
        :param pulumi.Input['InstanceSystemDiskArgs'] system_disk: The field representing the system disk specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
        :param pulumi.Input[bool] unique_suffix: Specifies whether to automatically append sequential suffixes to the hostnames specified by the HostName parameter and instance names specified by the InstanceName parameter when you create multiple instances at a time. The sequential suffix ranges from 001 to 999. Valid values:  true false Default value: false.
        :param pulumi.Input[str] user_data: User defined data, with a maximum support of 16KB. You can input UserData information. UserData encoded in Base64 format.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if carrier is not None:
            pulumi.set(__self__, "carrier", carrier)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if ens_region_id is not None:
            pulumi.set(__self__, "ens_region_id", ens_region_id)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_charge_strategy is not None:
            pulumi.set(__self__, "instance_charge_strategy", instance_charge_strategy)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if net_district_code is not None:
            pulumi.set(__self__, "net_district_code", net_district_code)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if public_ip_identification is not None:
            pulumi.set(__self__, "public_ip_identification", public_ip_identification)
        if quantity is not None:
            pulumi.set(__self__, "quantity", quantity)
        if schedule_area_level is not None:
            pulumi.set(__self__, "schedule_area_level", schedule_area_level)
        if scheduling_price_strategy is not None:
            pulumi.set(__self__, "scheduling_price_strategy", scheduling_price_strategy)
        if scheduling_strategy is not None:
            pulumi.set(__self__, "scheduling_strategy", scheduling_strategy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_disk is not None:
            pulumi.set(__self__, "system_disk", system_disk)
        if unique_suffix is not None:
            pulumi.set(__self__, "unique_suffix", unique_suffix)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to automatically renew, default to False, this parameter is invalid when paying by volume.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter
    def carrier(self) -> Optional[pulumi.Input[str]]:
        """
        Operator, required for regional level scheduling, invalid for node level scheduling.
        """
        return pulumi.get(self, "carrier")

    @carrier.setter
    def carrier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "carrier", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]:
        """
        Data disk specifications. See `data_disk` below.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        Node id. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big, Middle, Small, EnsRegionId is not required.
        """
        return pulumi.get(self, "ens_region_id")

    @ens_region_id.setter
    def ens_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ens_region_id", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Host Name.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Image Id field. If InstanceType is arm_bmi, the image Id is a non-required parameter. If instanceType is another specification value, the image Id is a required parameter.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="instanceChargeStrategy")
    def instance_charge_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Instance billing strategy, instance: instance granularity (prepaid method currently does not support instance), user: by user dimension (not transferred or prepaid method supports user).
        """
        return pulumi.get(self, "instance_charge_strategy")

    @instance_charge_strategy.setter
    def instance_charge_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_charge_strategy", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-). The default value is the InstanceId of the instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance specifications type.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance Charge type.it could be BandwidthByDay, 95BandwidthByMonth, PayByBandwidth4thMonth.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum public network bandwidth.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @property
    @pulumi.getter(name="netDistrictCode")
    def net_district_code(self) -> Optional[pulumi.Input[str]]:
        """
        Region code, required for regional level scheduling, invalid for node level scheduling.
        """
        return pulumi.get(self, "net_district_code")

    @net_district_code.setter
    def net_district_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "net_district_code", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the instance。It is 8 to 30 characters in length and must contain three types of characters: uppercase and lowercase letters, numbers, and special symbols. The following special symbols can be set: '''()'~! @#$%^& *-_+ =|{}[]:;',.? /'''.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed.
        """
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_inherit", value)

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance payment method, Subscription: prepaid, monthly package; PayAsYouGo: Pay as you go.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payment_type", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The duration of purchasing resources. If PeriodUnit is not specified, it defaults to purchasing on a monthly basis. Currently, only days and months are supported. If PeriodUnit=Day, Period can only be 3. If PeriodUnit=Monthc, then Period can be 1-9,12.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit of time for purchasing resources. If PeriodUnit is not specified, it defaults to purchasing by Month. Currently, only days and months are supported. If PeriodUnit=Day, Period can only be 3. If PeriodUnit=Month, then Period can be 1-9,12.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="publicIpIdentification")
    def public_ip_identification(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to allocate public IP. Value：true (default): can be assigned，false: cannot be assigned.
        """
        return pulumi.get(self, "public_ip_identification")

    @public_ip_identification.setter
    def public_ip_identification(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "public_ip_identification", value)

    @property
    @pulumi.getter
    def quantity(self) -> Optional[pulumi.Input[str]]:
        """
        Number of instances.
        """
        return pulumi.get(self, "quantity")

    @quantity.setter
    def quantity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quantity", value)

    @property
    @pulumi.getter(name="scheduleAreaLevel")
    def schedule_area_level(self) -> Optional[pulumi.Input[str]]:
        """
        Scheduling level, which is used to perform node level or regional scheduling.
        """
        return pulumi.get(self, "schedule_area_level")

    @schedule_area_level.setter
    def schedule_area_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_area_level", value)

    @property
    @pulumi.getter(name="schedulingPriceStrategy")
    def scheduling_price_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Dispatch price strategy. If left blank, it defaults to prioritizing low prices. Values: PriceLowPriority (priority high price), PriceLowPriority (priority low price).
        """
        return pulumi.get(self, "scheduling_price_strategy")

    @scheduling_price_strategy.setter
    def scheduling_price_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduling_price_strategy", value)

    @property
    @pulumi.getter(name="schedulingStrategy")
    def scheduling_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        When scheduling at the node level, it is Concentrate. When scheduling at the regional level, it is selected according to customer needs. Concentrate: Centralized; Disperse: Disperse.
        """
        return pulumi.get(self, "scheduling_strategy")

    @scheduling_strategy.setter
    def scheduling_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduling_strategy", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        the status of the resource.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> Optional[pulumi.Input['InstanceSystemDiskArgs']]:
        """
        The field representing the system disk specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
        """
        return pulumi.get(self, "system_disk")

    @system_disk.setter
    def system_disk(self, value: Optional[pulumi.Input['InstanceSystemDiskArgs']]):
        pulumi.set(self, "system_disk", value)

    @property
    @pulumi.getter(name="uniqueSuffix")
    def unique_suffix(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically append sequential suffixes to the hostnames specified by the HostName parameter and instance names specified by the InstanceName parameter when you create multiple instances at a time. The sequential suffix ranges from 001 to 999. Valid values:  true false Default value: false.
        """
        return pulumi.get(self, "unique_suffix")

    @unique_suffix.setter
    def unique_suffix(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "unique_suffix", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        User defined data, with a maximum support of 16KB. You can input UserData information. UserData encoded in Base64 format.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 carrier: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataDiskArgs']]]]] = None,
                 ens_region_id: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_charge_strategy: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 net_district_code: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 public_ip_identification: Optional[pulumi.Input[bool]] = None,
                 quantity: Optional[pulumi.Input[str]] = None,
                 schedule_area_level: Optional[pulumi.Input[str]] = None,
                 scheduling_price_strategy: Optional[pulumi.Input[str]] = None,
                 scheduling_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk: Optional[pulumi.Input[pulumi.InputType['InstanceSystemDiskArgs']]] = None,
                 unique_suffix: Optional[pulumi.Input[bool]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        ENS Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ens/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: Whether to automatically renew, default to False, this parameter is invalid when paying by volume.
        :param pulumi.Input[str] carrier: Operator, required for regional level scheduling, invalid for node level scheduling.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataDiskArgs']]]] data_disks: Data disk specifications. See `data_disk` below.
        :param pulumi.Input[str] ens_region_id: Node id. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big, Middle, Small, EnsRegionId is not required.
        :param pulumi.Input[str] host_name: Host Name.
        :param pulumi.Input[str] image_id: The Image Id field. If InstanceType is arm_bmi, the image Id is a non-required parameter. If instanceType is another specification value, the image Id is a required parameter.
        :param pulumi.Input[str] instance_charge_strategy: Instance billing strategy, instance: instance granularity (prepaid method currently does not support instance), user: by user dimension (not transferred or prepaid method supports user).
        :param pulumi.Input[str] instance_name: The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-). The default value is the InstanceId of the instance.
        :param pulumi.Input[str] instance_type: Instance specifications type.
        :param pulumi.Input[str] internet_charge_type: Instance Charge type.it could be BandwidthByDay, 95BandwidthByMonth, PayByBandwidth4thMonth.
        :param pulumi.Input[int] internet_max_bandwidth_out: The maximum public network bandwidth.
        :param pulumi.Input[str] net_district_code: Region code, required for regional level scheduling, invalid for node level scheduling.
        :param pulumi.Input[str] password: The password of the instance。It is 8 to 30 characters in length and must contain three types of characters: uppercase and lowercase letters, numbers, and special symbols. The following special symbols can be set: '''()'~! @#$%^& *-_+ =|{}[]:;',.? /'''.
        :param pulumi.Input[bool] password_inherit: Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed.
        :param pulumi.Input[str] payment_type: Instance payment method, Subscription: prepaid, monthly package; PayAsYouGo: Pay as you go.
        :param pulumi.Input[int] period: The duration of purchasing resources. If PeriodUnit is not specified, it defaults to purchasing on a monthly basis. Currently, only days and months are supported. If PeriodUnit=Day, Period can only be 3. If PeriodUnit=Monthc, then Period can be 1-9,12.
        :param pulumi.Input[str] period_unit: The unit of time for purchasing resources. If PeriodUnit is not specified, it defaults to purchasing by Month. Currently, only days and months are supported. If PeriodUnit=Day, Period can only be 3. If PeriodUnit=Month, then Period can be 1-9,12.
        :param pulumi.Input[bool] public_ip_identification: Whether to allocate public IP. Value：true (default): can be assigned，false: cannot be assigned.
        :param pulumi.Input[str] quantity: Number of instances.
        :param pulumi.Input[str] schedule_area_level: Scheduling level, which is used to perform node level or regional scheduling.
        :param pulumi.Input[str] scheduling_price_strategy: Dispatch price strategy. If left blank, it defaults to prioritizing low prices. Values: PriceLowPriority (priority high price), PriceLowPriority (priority low price).
        :param pulumi.Input[str] scheduling_strategy: When scheduling at the node level, it is Concentrate. When scheduling at the regional level, it is selected according to customer needs. Concentrate: Centralized; Disperse: Disperse.
        :param pulumi.Input[pulumi.InputType['InstanceSystemDiskArgs']] system_disk: The field representing the system disk specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
        :param pulumi.Input[bool] unique_suffix: Specifies whether to automatically append sequential suffixes to the hostnames specified by the HostName parameter and instance names specified by the InstanceName parameter when you create multiple instances at a time. The sequential suffix ranges from 001 to 999. Valid values:  true false Default value: false.
        :param pulumi.Input[str] user_data: User defined data, with a maximum support of 16KB. You can input UserData information. UserData encoded in Base64 format.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        ENS Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ens/instance:Instance example <id>
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 carrier: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataDiskArgs']]]]] = None,
                 ens_region_id: Optional[pulumi.Input[str]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 instance_charge_strategy: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 net_district_code: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 payment_type: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 public_ip_identification: Optional[pulumi.Input[bool]] = None,
                 quantity: Optional[pulumi.Input[str]] = None,
                 schedule_area_level: Optional[pulumi.Input[str]] = None,
                 scheduling_price_strategy: Optional[pulumi.Input[str]] = None,
                 scheduling_strategy: Optional[pulumi.Input[str]] = None,
                 system_disk: Optional[pulumi.Input[pulumi.InputType['InstanceSystemDiskArgs']]] = None,
                 unique_suffix: Optional[pulumi.Input[bool]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["carrier"] = carrier
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["ens_region_id"] = ens_region_id
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["instance_charge_strategy"] = instance_charge_strategy
            __props__.__dict__["instance_name"] = instance_name
            if instance_type is None and not opts.urn:
                raise TypeError("Missing required property 'instance_type'")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            if internet_max_bandwidth_out is None and not opts.urn:
                raise TypeError("Missing required property 'internet_max_bandwidth_out'")
            __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
            __props__.__dict__["net_district_code"] = net_district_code
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["password_inherit"] = password_inherit
            if payment_type is None and not opts.urn:
                raise TypeError("Missing required property 'payment_type'")
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["public_ip_identification"] = public_ip_identification
            __props__.__dict__["quantity"] = quantity
            if schedule_area_level is None and not opts.urn:
                raise TypeError("Missing required property 'schedule_area_level'")
            __props__.__dict__["schedule_area_level"] = schedule_area_level
            __props__.__dict__["scheduling_price_strategy"] = scheduling_price_strategy
            __props__.__dict__["scheduling_strategy"] = scheduling_strategy
            __props__.__dict__["system_disk"] = system_disk
            __props__.__dict__["unique_suffix"] = unique_suffix
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["status"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'alicloud:ens/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            carrier: Optional[pulumi.Input[str]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataDiskArgs']]]]] = None,
            ens_region_id: Optional[pulumi.Input[str]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            instance_charge_strategy: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            internet_charge_type: Optional[pulumi.Input[str]] = None,
            internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
            net_district_code: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            password_inherit: Optional[pulumi.Input[bool]] = None,
            payment_type: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            public_ip_identification: Optional[pulumi.Input[bool]] = None,
            quantity: Optional[pulumi.Input[str]] = None,
            schedule_area_level: Optional[pulumi.Input[str]] = None,
            scheduling_price_strategy: Optional[pulumi.Input[str]] = None,
            scheduling_strategy: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            system_disk: Optional[pulumi.Input[pulumi.InputType['InstanceSystemDiskArgs']]] = None,
            unique_suffix: Optional[pulumi.Input[bool]] = None,
            user_data: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_renew: Whether to automatically renew, default to False, this parameter is invalid when paying by volume.
        :param pulumi.Input[str] carrier: Operator, required for regional level scheduling, invalid for node level scheduling.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceDataDiskArgs']]]] data_disks: Data disk specifications. See `data_disk` below.
        :param pulumi.Input[str] ens_region_id: Node id. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big, Middle, Small, EnsRegionId is not required.
        :param pulumi.Input[str] host_name: Host Name.
        :param pulumi.Input[str] image_id: The Image Id field. If InstanceType is arm_bmi, the image Id is a non-required parameter. If instanceType is another specification value, the image Id is a required parameter.
        :param pulumi.Input[str] instance_charge_strategy: Instance billing strategy, instance: instance granularity (prepaid method currently does not support instance), user: by user dimension (not transferred or prepaid method supports user).
        :param pulumi.Input[str] instance_name: The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-). The default value is the InstanceId of the instance.
        :param pulumi.Input[str] instance_type: Instance specifications type.
        :param pulumi.Input[str] internet_charge_type: Instance Charge type.it could be BandwidthByDay, 95BandwidthByMonth, PayByBandwidth4thMonth.
        :param pulumi.Input[int] internet_max_bandwidth_out: The maximum public network bandwidth.
        :param pulumi.Input[str] net_district_code: Region code, required for regional level scheduling, invalid for node level scheduling.
        :param pulumi.Input[str] password: The password of the instance。It is 8 to 30 characters in length and must contain three types of characters: uppercase and lowercase letters, numbers, and special symbols. The following special symbols can be set: '''()'~! @#$%^& *-_+ =|{}[]:;',.? /'''.
        :param pulumi.Input[bool] password_inherit: Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed.
        :param pulumi.Input[str] payment_type: Instance payment method, Subscription: prepaid, monthly package; PayAsYouGo: Pay as you go.
        :param pulumi.Input[int] period: The duration of purchasing resources. If PeriodUnit is not specified, it defaults to purchasing on a monthly basis. Currently, only days and months are supported. If PeriodUnit=Day, Period can only be 3. If PeriodUnit=Monthc, then Period can be 1-9,12.
        :param pulumi.Input[str] period_unit: The unit of time for purchasing resources. If PeriodUnit is not specified, it defaults to purchasing by Month. Currently, only days and months are supported. If PeriodUnit=Day, Period can only be 3. If PeriodUnit=Month, then Period can be 1-9,12.
        :param pulumi.Input[bool] public_ip_identification: Whether to allocate public IP. Value：true (default): can be assigned，false: cannot be assigned.
        :param pulumi.Input[str] quantity: Number of instances.
        :param pulumi.Input[str] schedule_area_level: Scheduling level, which is used to perform node level or regional scheduling.
        :param pulumi.Input[str] scheduling_price_strategy: Dispatch price strategy. If left blank, it defaults to prioritizing low prices. Values: PriceLowPriority (priority high price), PriceLowPriority (priority low price).
        :param pulumi.Input[str] scheduling_strategy: When scheduling at the node level, it is Concentrate. When scheduling at the regional level, it is selected according to customer needs. Concentrate: Centralized; Disperse: Disperse.
        :param pulumi.Input[str] status: the status of the resource.
        :param pulumi.Input[pulumi.InputType['InstanceSystemDiskArgs']] system_disk: The field representing the system disk specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
        :param pulumi.Input[bool] unique_suffix: Specifies whether to automatically append sequential suffixes to the hostnames specified by the HostName parameter and instance names specified by the InstanceName parameter when you create multiple instances at a time. The sequential suffix ranges from 001 to 999. Valid values:  true false Default value: false.
        :param pulumi.Input[str] user_data: User defined data, with a maximum support of 16KB. You can input UserData information. UserData encoded in Base64 format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["carrier"] = carrier
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["ens_region_id"] = ens_region_id
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["instance_charge_strategy"] = instance_charge_strategy
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
        __props__.__dict__["net_district_code"] = net_district_code
        __props__.__dict__["password"] = password
        __props__.__dict__["password_inherit"] = password_inherit
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["public_ip_identification"] = public_ip_identification
        __props__.__dict__["quantity"] = quantity
        __props__.__dict__["schedule_area_level"] = schedule_area_level
        __props__.__dict__["scheduling_price_strategy"] = scheduling_price_strategy
        __props__.__dict__["scheduling_strategy"] = scheduling_strategy
        __props__.__dict__["status"] = status
        __props__.__dict__["system_disk"] = system_disk
        __props__.__dict__["unique_suffix"] = unique_suffix
        __props__.__dict__["user_data"] = user_data
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to automatically renew, default to False, this parameter is invalid when paying by volume.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter
    def carrier(self) -> pulumi.Output[Optional[str]]:
        """
        Operator, required for regional level scheduling, invalid for node level scheduling.
        """
        return pulumi.get(self, "carrier")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceDataDisk']]]:
        """
        Data disk specifications. See `data_disk` below.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="ensRegionId")
    def ens_region_id(self) -> pulumi.Output[Optional[str]]:
        """
        Node id. When ScheduleAreaLevel is Region, EnsRegionId is required. When ScheduleAreaLevel is Big, Middle, Small, EnsRegionId is not required.
        """
        return pulumi.get(self, "ens_region_id")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[str]:
        """
        Host Name.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Image Id field. If InstanceType is arm_bmi, the image Id is a non-required parameter. If instanceType is another specification value, the image Id is a required parameter.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceChargeStrategy")
    def instance_charge_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        Instance billing strategy, instance: instance granularity (prepaid method currently does not support instance), user: by user dimension (not transferred or prepaid method supports user).
        """
        return pulumi.get(self, "instance_charge_strategy")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        The instance name. It must be 2 to 128 characters in length and must start with an uppercase or lowercase letter or a Chinese character. It cannot start with http:// or https. It can contain Chinese, English, numbers, half-width colons (:), underscores (_), periods (.), or hyphens (-). The default value is the InstanceId of the instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        Instance specifications type.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[Optional[str]]:
        """
        Instance Charge type.it could be BandwidthByDay, 95BandwidthByMonth, PayByBandwidth4thMonth.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> pulumi.Output[int]:
        """
        The maximum public network bandwidth.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @property
    @pulumi.getter(name="netDistrictCode")
    def net_district_code(self) -> pulumi.Output[Optional[str]]:
        """
        Region code, required for regional level scheduling, invalid for node level scheduling.
        """
        return pulumi.get(self, "net_district_code")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password of the instance。It is 8 to 30 characters in length and must contain three types of characters: uppercase and lowercase letters, numbers, and special symbols. The following special symbols can be set: '''()'~! @#$%^& *-_+ =|{}[]:;',.? /'''.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to use image preset password prompt: Password and KeyPairNamePasswordInherit must be passed.
        """
        return pulumi.get(self, "password_inherit")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[str]:
        """
        Instance payment method, Subscription: prepaid, monthly package; PayAsYouGo: Pay as you go.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The duration of purchasing resources. If PeriodUnit is not specified, it defaults to purchasing on a monthly basis. Currently, only days and months are supported. If PeriodUnit=Day, Period can only be 3. If PeriodUnit=Monthc, then Period can be 1-9,12.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        The unit of time for purchasing resources. If PeriodUnit is not specified, it defaults to purchasing by Month. Currently, only days and months are supported. If PeriodUnit=Day, Period can only be 3. If PeriodUnit=Month, then Period can be 1-9,12.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter(name="publicIpIdentification")
    def public_ip_identification(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to allocate public IP. Value：true (default): can be assigned，false: cannot be assigned.
        """
        return pulumi.get(self, "public_ip_identification")

    @property
    @pulumi.getter
    def quantity(self) -> pulumi.Output[Optional[str]]:
        """
        Number of instances.
        """
        return pulumi.get(self, "quantity")

    @property
    @pulumi.getter(name="scheduleAreaLevel")
    def schedule_area_level(self) -> pulumi.Output[str]:
        """
        Scheduling level, which is used to perform node level or regional scheduling.
        """
        return pulumi.get(self, "schedule_area_level")

    @property
    @pulumi.getter(name="schedulingPriceStrategy")
    def scheduling_price_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        Dispatch price strategy. If left blank, it defaults to prioritizing low prices. Values: PriceLowPriority (priority high price), PriceLowPriority (priority low price).
        """
        return pulumi.get(self, "scheduling_price_strategy")

    @property
    @pulumi.getter(name="schedulingStrategy")
    def scheduling_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        When scheduling at the node level, it is Concentrate. When scheduling at the regional level, it is selected according to customer needs. Concentrate: Centralized; Disperse: Disperse.
        """
        return pulumi.get(self, "scheduling_strategy")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        the status of the resource.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> pulumi.Output[Optional['outputs.InstanceSystemDisk']]:
        """
        The field representing the system disk specification. SystemDisk is a non-required parameter when InstanceType is x86_pm,x86_bmi,x86_bm,pc_bmi, or arm_bmi. SystemDisk is a required parameter when instanceType is other specification families. See `system_disk` below.
        """
        return pulumi.get(self, "system_disk")

    @property
    @pulumi.getter(name="uniqueSuffix")
    def unique_suffix(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to automatically append sequential suffixes to the hostnames specified by the HostName parameter and instance names specified by the InstanceName parameter when you create multiple instances at a time. The sequential suffix ranges from 001 to 999. Valid values:  true false Default value: false.
        """
        return pulumi.get(self, "unique_suffix")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        User defined data, with a maximum support of 16KB. You can input UserData information. UserData encoded in Base64 format.
        """
        return pulumi.get(self, "user_data")

