# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'InstanceDataDisk',
    'InstanceSystemDisk',
    'GetKeyPairsPairResult',
]

@pulumi.output_type
class InstanceDataDisk(dict):
    def __init__(__self__, *,
                 category: Optional[str] = None,
                 size: Optional[int] = None):
        """
        :param str category: Type of dataDisk
               - cloud_efficiency：High-efficiency cloud disk
               - cloud_ssd：Full flash cloud disk
               - local_hdd：Local hdd disk
               - local_ssd：Local disk ssd.
        :param int size: Data disk size, cloud_efficiency is 20-32000,cloud_ssd/local_hdd/local_ssd is 20-25000, unit: GB.
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Type of dataDisk
        - cloud_efficiency：High-efficiency cloud disk
        - cloud_ssd：Full flash cloud disk
        - local_hdd：Local hdd disk
        - local_ssd：Local disk ssd.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        Data disk size, cloud_efficiency is 20-32000,cloud_ssd/local_hdd/local_ssd is 20-25000, unit: GB.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class InstanceSystemDisk(dict):
    def __init__(__self__, *,
                 size: Optional[int] = None):
        """
        :param int size: System disk size, cloud_efficiency is 20-32000,cloud_ssd/local_hdd/local_ssd is 20-25000, unit: GB.
        """
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        System disk size, cloud_efficiency is 20-32000,cloud_ssd/local_hdd/local_ssd is 20-25000, unit: GB.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class GetKeyPairsPairResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 id: str,
                 key_pair_finger_print: str,
                 key_pair_name: str,
                 version: str):
        """
        :param str create_time: The creation time of the key pair. The date format is in accordance with ISO8601 notation and uses UTC time. The format is yyyy-MM-ddTHH:mm:ssZ.
        :param str id: The ID of the Key Pair.
        :param str key_pair_finger_print: Fingerprint of the key pair.
        :param str key_pair_name: The name of the key pair.
        :param str version: The version number.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key_pair_finger_print", key_pair_finger_print)
        pulumi.set(__self__, "key_pair_name", key_pair_name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the key pair. The date format is in accordance with ISO8601 notation and uses UTC time. The format is yyyy-MM-ddTHH:mm:ssZ.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Key Pair.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyPairFingerPrint")
    def key_pair_finger_print(self) -> str:
        """
        Fingerprint of the key pair.
        """
        return pulumi.get(self, "key_pair_finger_print")

    @property
    @pulumi.getter(name="keyPairName")
    def key_pair_name(self) -> str:
        """
        The name of the key pair.
        """
        return pulumi.get(self, "key_pair_name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version number.
        """
        return pulumi.get(self, "version")


