# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'EciScalingConfigurationAcrRegistryInfoArgs',
    'EciScalingConfigurationContainerArgs',
    'EciScalingConfigurationContainerEnvironmentVarArgs',
    'EciScalingConfigurationContainerPortArgs',
    'EciScalingConfigurationContainerVolumeMountArgs',
    'EciScalingConfigurationHostAliasArgs',
    'EciScalingConfigurationImageRegistryCredentialArgs',
    'EciScalingConfigurationInitContainerArgs',
    'EciScalingConfigurationInitContainerEnvironmentVarArgs',
    'EciScalingConfigurationInitContainerPortArgs',
    'EciScalingConfigurationInitContainerVolumeMountArgs',
    'EciScalingConfigurationVolumeArgs',
    'EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs',
    'ScalingConfigurationDataDiskArgs',
    'ScalingConfigurationInstancePatternInfoArgs',
    'ScalingConfigurationSpotPriceLimitArgs',
    'ScalingGroupVServerGroupsVserverGroupArgs',
    'ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs',
    'ScalingRuleStepAdjustmentArgs',
]

@pulumi.input_type
class EciScalingConfigurationAcrRegistryInfoArgs:
    def __init__(__self__, *,
                 domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] domains: Endpoint of Container Registry Enterprise Edition instance. By default, all endpoints of the Container Registry Enterprise Edition instance are displayed. It is required
               when `acr_registry_info` is configured.
        :param pulumi.Input[str] instance_id: The ID of Container Registry Enterprise Edition instance. It is required
               when `acr_registry_info` is configured.
        :param pulumi.Input[str] instance_name: The name of Container Registry Enterprise Edition instance. It is required when `acr_registry_info` is
               configured.
        :param pulumi.Input[str] region_id: The region ID of Container Registry Enterprise Edition instance. It is required
               when `acr_registry_info` is configured.
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)

    @property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Endpoint of Container Registry Enterprise Edition instance. By default, all endpoints of the Container Registry Enterprise Edition instance are displayed. It is required
        when `acr_registry_info` is configured.
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "domains", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of Container Registry Enterprise Edition instance. It is required
        when `acr_registry_info` is configured.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of Container Registry Enterprise Edition instance. It is required when `acr_registry_info` is
        configured.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The region ID of Container Registry Enterprise Edition instance. It is required
        when `acr_registry_info` is configured.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_id", value)


@pulumi.input_type
class EciScalingConfigurationContainerArgs:
    def __init__(__self__, *,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cpu: Optional[pulumi.Input[float]] = None,
                 environment_vars: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerEnvironmentVarArgs']]]] = None,
                 gpu: Optional[pulumi.Input[int]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 image_pull_policy: Optional[pulumi.Input[str]] = None,
                 liveness_probe_exec_commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 liveness_probe_failure_threshold: Optional[pulumi.Input[int]] = None,
                 liveness_probe_http_get_path: Optional[pulumi.Input[str]] = None,
                 liveness_probe_http_get_port: Optional[pulumi.Input[int]] = None,
                 liveness_probe_http_get_scheme: Optional[pulumi.Input[str]] = None,
                 liveness_probe_initial_delay_seconds: Optional[pulumi.Input[int]] = None,
                 liveness_probe_period_seconds: Optional[pulumi.Input[int]] = None,
                 liveness_probe_success_threshold: Optional[pulumi.Input[int]] = None,
                 liveness_probe_tcp_socket_port: Optional[pulumi.Input[int]] = None,
                 liveness_probe_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 memory: Optional[pulumi.Input[float]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerPortArgs']]]] = None,
                 readiness_probe_exec_commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 readiness_probe_failure_threshold: Optional[pulumi.Input[int]] = None,
                 readiness_probe_http_get_path: Optional[pulumi.Input[str]] = None,
                 readiness_probe_http_get_port: Optional[pulumi.Input[int]] = None,
                 readiness_probe_http_get_scheme: Optional[pulumi.Input[str]] = None,
                 readiness_probe_initial_delay_seconds: Optional[pulumi.Input[int]] = None,
                 readiness_probe_period_seconds: Optional[pulumi.Input[int]] = None,
                 readiness_probe_success_threshold: Optional[pulumi.Input[int]] = None,
                 readiness_probe_tcp_socket_port: Optional[pulumi.Input[int]] = None,
                 readiness_probe_timeout_seconds: Optional[pulumi.Input[int]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerVolumeMountArgs']]]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: The arguments passed to the commands.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: The commands run by the init container.
        :param pulumi.Input[float] cpu: The amount of CPU resources allocated to the container.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerEnvironmentVarArgs']]] environment_vars: The structure of environmentVars.
               See `environment_vars` below for details.
        :param pulumi.Input[int] gpu: The number GPUs.
        :param pulumi.Input[str] image: The image of the container.
        :param pulumi.Input[str] image_pull_policy: The restart policy of the image.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] liveness_probe_exec_commands: Commands that you want to run in containers when you use the CLI to perform liveness probes.
        :param pulumi.Input[int] liveness_probe_failure_threshold: The minimum number of consecutive failures for the liveness probe to be considered failed after having been successful. Default value: 3.
        :param pulumi.Input[str] liveness_probe_http_get_path: The path to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
        :param pulumi.Input[int] liveness_probe_http_get_port: The port to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
        :param pulumi.Input[str] liveness_probe_http_get_scheme: The protocol type of HTTP GET requests when you use HTTP requests for liveness probes.Valid values:HTTP and HTTPS.
        :param pulumi.Input[int] liveness_probe_initial_delay_seconds: The number of seconds after container has started before liveness probes are initiated.
        :param pulumi.Input[int] liveness_probe_period_seconds: The interval at which the liveness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
        :param pulumi.Input[int] liveness_probe_success_threshold: The minimum number of consecutive successes for the liveness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
        :param pulumi.Input[int] liveness_probe_tcp_socket_port: The port detected by TCP sockets when you use TCP sockets to perform liveness probes.
        :param pulumi.Input[int] liveness_probe_timeout_seconds: The timeout period for the liveness probe. Unit: seconds. Default value: 1. Minimum value: 1.
        :param pulumi.Input[float] memory: The amount of memory resources allocated to the container.
        :param pulumi.Input[str] name: The name of the mounted volume.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerPortArgs']]] ports: The structure of port. See `ports` below for details.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] readiness_probe_exec_commands: Commands that you want to run in containers when you use the CLI to perform readiness probes.
        :param pulumi.Input[int] readiness_probe_failure_threshold: The minimum number of consecutive failures for the readiness probe to be considered failed after having been successful. Default value: 3.
        :param pulumi.Input[str] readiness_probe_http_get_path: The path to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
        :param pulumi.Input[int] readiness_probe_http_get_port: The port to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
        :param pulumi.Input[str] readiness_probe_http_get_scheme: The protocol type of HTTP GET requests when you use HTTP requests for readiness probes. Valid values: HTTP and HTTPS.
        :param pulumi.Input[int] readiness_probe_initial_delay_seconds: The number of seconds after container N has started before readiness probes are initiated.
        :param pulumi.Input[int] readiness_probe_period_seconds: The interval at which the readiness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
        :param pulumi.Input[int] readiness_probe_success_threshold: The minimum number of consecutive successes for the readiness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
        :param pulumi.Input[int] readiness_probe_tcp_socket_port: The port detected by Transmission Control Protocol (TCP) sockets when you use TCP sockets to perform readiness probes.
        :param pulumi.Input[int] readiness_probe_timeout_seconds: The timeout period for the readiness probe. Unit: seconds. Default value: 1. Minimum value: 1.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerVolumeMountArgs']]] volume_mounts: The structure of volumeMounts. 
               See `volume_mounts` below for details.
        :param pulumi.Input[str] working_dir: The working directory of the container.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if environment_vars is not None:
            pulumi.set(__self__, "environment_vars", environment_vars)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if liveness_probe_exec_commands is not None:
            pulumi.set(__self__, "liveness_probe_exec_commands", liveness_probe_exec_commands)
        if liveness_probe_failure_threshold is not None:
            pulumi.set(__self__, "liveness_probe_failure_threshold", liveness_probe_failure_threshold)
        if liveness_probe_http_get_path is not None:
            pulumi.set(__self__, "liveness_probe_http_get_path", liveness_probe_http_get_path)
        if liveness_probe_http_get_port is not None:
            pulumi.set(__self__, "liveness_probe_http_get_port", liveness_probe_http_get_port)
        if liveness_probe_http_get_scheme is not None:
            pulumi.set(__self__, "liveness_probe_http_get_scheme", liveness_probe_http_get_scheme)
        if liveness_probe_initial_delay_seconds is not None:
            pulumi.set(__self__, "liveness_probe_initial_delay_seconds", liveness_probe_initial_delay_seconds)
        if liveness_probe_period_seconds is not None:
            pulumi.set(__self__, "liveness_probe_period_seconds", liveness_probe_period_seconds)
        if liveness_probe_success_threshold is not None:
            pulumi.set(__self__, "liveness_probe_success_threshold", liveness_probe_success_threshold)
        if liveness_probe_tcp_socket_port is not None:
            pulumi.set(__self__, "liveness_probe_tcp_socket_port", liveness_probe_tcp_socket_port)
        if liveness_probe_timeout_seconds is not None:
            pulumi.set(__self__, "liveness_probe_timeout_seconds", liveness_probe_timeout_seconds)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if readiness_probe_exec_commands is not None:
            pulumi.set(__self__, "readiness_probe_exec_commands", readiness_probe_exec_commands)
        if readiness_probe_failure_threshold is not None:
            pulumi.set(__self__, "readiness_probe_failure_threshold", readiness_probe_failure_threshold)
        if readiness_probe_http_get_path is not None:
            pulumi.set(__self__, "readiness_probe_http_get_path", readiness_probe_http_get_path)
        if readiness_probe_http_get_port is not None:
            pulumi.set(__self__, "readiness_probe_http_get_port", readiness_probe_http_get_port)
        if readiness_probe_http_get_scheme is not None:
            pulumi.set(__self__, "readiness_probe_http_get_scheme", readiness_probe_http_get_scheme)
        if readiness_probe_initial_delay_seconds is not None:
            pulumi.set(__self__, "readiness_probe_initial_delay_seconds", readiness_probe_initial_delay_seconds)
        if readiness_probe_period_seconds is not None:
            pulumi.set(__self__, "readiness_probe_period_seconds", readiness_probe_period_seconds)
        if readiness_probe_success_threshold is not None:
            pulumi.set(__self__, "readiness_probe_success_threshold", readiness_probe_success_threshold)
        if readiness_probe_tcp_socket_port is not None:
            pulumi.set(__self__, "readiness_probe_tcp_socket_port", readiness_probe_tcp_socket_port)
        if readiness_probe_timeout_seconds is not None:
            pulumi.set(__self__, "readiness_probe_timeout_seconds", readiness_probe_timeout_seconds)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The arguments passed to the commands.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The commands run by the init container.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of CPU resources allocated to the container.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerEnvironmentVarArgs']]]]:
        """
        The structure of environmentVars.
        See `environment_vars` below for details.
        """
        return pulumi.get(self, "environment_vars")

    @environment_vars.setter
    def environment_vars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerEnvironmentVarArgs']]]]):
        pulumi.set(self, "environment_vars", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[int]]:
        """
        The number GPUs.
        """
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        The image of the container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The restart policy of the image.
        """
        return pulumi.get(self, "image_pull_policy")

    @image_pull_policy.setter
    def image_pull_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_pull_policy", value)

    @property
    @pulumi.getter(name="livenessProbeExecCommands")
    def liveness_probe_exec_commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Commands that you want to run in containers when you use the CLI to perform liveness probes.
        """
        return pulumi.get(self, "liveness_probe_exec_commands")

    @liveness_probe_exec_commands.setter
    def liveness_probe_exec_commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "liveness_probe_exec_commands", value)

    @property
    @pulumi.getter(name="livenessProbeFailureThreshold")
    def liveness_probe_failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of consecutive failures for the liveness probe to be considered failed after having been successful. Default value: 3.
        """
        return pulumi.get(self, "liveness_probe_failure_threshold")

    @liveness_probe_failure_threshold.setter
    def liveness_probe_failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "liveness_probe_failure_threshold", value)

    @property
    @pulumi.getter(name="livenessProbeHttpGetPath")
    def liveness_probe_http_get_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
        """
        return pulumi.get(self, "liveness_probe_http_get_path")

    @liveness_probe_http_get_path.setter
    def liveness_probe_http_get_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "liveness_probe_http_get_path", value)

    @property
    @pulumi.getter(name="livenessProbeHttpGetPort")
    def liveness_probe_http_get_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
        """
        return pulumi.get(self, "liveness_probe_http_get_port")

    @liveness_probe_http_get_port.setter
    def liveness_probe_http_get_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "liveness_probe_http_get_port", value)

    @property
    @pulumi.getter(name="livenessProbeHttpGetScheme")
    def liveness_probe_http_get_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol type of HTTP GET requests when you use HTTP requests for liveness probes.Valid values:HTTP and HTTPS.
        """
        return pulumi.get(self, "liveness_probe_http_get_scheme")

    @liveness_probe_http_get_scheme.setter
    def liveness_probe_http_get_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "liveness_probe_http_get_scheme", value)

    @property
    @pulumi.getter(name="livenessProbeInitialDelaySeconds")
    def liveness_probe_initial_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds after container has started before liveness probes are initiated.
        """
        return pulumi.get(self, "liveness_probe_initial_delay_seconds")

    @liveness_probe_initial_delay_seconds.setter
    def liveness_probe_initial_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "liveness_probe_initial_delay_seconds", value)

    @property
    @pulumi.getter(name="livenessProbePeriodSeconds")
    def liveness_probe_period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The interval at which the liveness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
        """
        return pulumi.get(self, "liveness_probe_period_seconds")

    @liveness_probe_period_seconds.setter
    def liveness_probe_period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "liveness_probe_period_seconds", value)

    @property
    @pulumi.getter(name="livenessProbeSuccessThreshold")
    def liveness_probe_success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of consecutive successes for the liveness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
        """
        return pulumi.get(self, "liveness_probe_success_threshold")

    @liveness_probe_success_threshold.setter
    def liveness_probe_success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "liveness_probe_success_threshold", value)

    @property
    @pulumi.getter(name="livenessProbeTcpSocketPort")
    def liveness_probe_tcp_socket_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port detected by TCP sockets when you use TCP sockets to perform liveness probes.
        """
        return pulumi.get(self, "liveness_probe_tcp_socket_port")

    @liveness_probe_tcp_socket_port.setter
    def liveness_probe_tcp_socket_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "liveness_probe_tcp_socket_port", value)

    @property
    @pulumi.getter(name="livenessProbeTimeoutSeconds")
    def liveness_probe_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout period for the liveness probe. Unit: seconds. Default value: 1. Minimum value: 1.
        """
        return pulumi.get(self, "liveness_probe_timeout_seconds")

    @liveness_probe_timeout_seconds.setter
    def liveness_probe_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "liveness_probe_timeout_seconds", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of memory resources allocated to the container.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerPortArgs']]]]:
        """
        The structure of port. See `ports` below for details.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="readinessProbeExecCommands")
    def readiness_probe_exec_commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Commands that you want to run in containers when you use the CLI to perform readiness probes.
        """
        return pulumi.get(self, "readiness_probe_exec_commands")

    @readiness_probe_exec_commands.setter
    def readiness_probe_exec_commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "readiness_probe_exec_commands", value)

    @property
    @pulumi.getter(name="readinessProbeFailureThreshold")
    def readiness_probe_failure_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of consecutive failures for the readiness probe to be considered failed after having been successful. Default value: 3.
        """
        return pulumi.get(self, "readiness_probe_failure_threshold")

    @readiness_probe_failure_threshold.setter
    def readiness_probe_failure_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "readiness_probe_failure_threshold", value)

    @property
    @pulumi.getter(name="readinessProbeHttpGetPath")
    def readiness_probe_http_get_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
        """
        return pulumi.get(self, "readiness_probe_http_get_path")

    @readiness_probe_http_get_path.setter
    def readiness_probe_http_get_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "readiness_probe_http_get_path", value)

    @property
    @pulumi.getter(name="readinessProbeHttpGetPort")
    def readiness_probe_http_get_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
        """
        return pulumi.get(self, "readiness_probe_http_get_port")

    @readiness_probe_http_get_port.setter
    def readiness_probe_http_get_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "readiness_probe_http_get_port", value)

    @property
    @pulumi.getter(name="readinessProbeHttpGetScheme")
    def readiness_probe_http_get_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol type of HTTP GET requests when you use HTTP requests for readiness probes. Valid values: HTTP and HTTPS.
        """
        return pulumi.get(self, "readiness_probe_http_get_scheme")

    @readiness_probe_http_get_scheme.setter
    def readiness_probe_http_get_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "readiness_probe_http_get_scheme", value)

    @property
    @pulumi.getter(name="readinessProbeInitialDelaySeconds")
    def readiness_probe_initial_delay_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The number of seconds after container N has started before readiness probes are initiated.
        """
        return pulumi.get(self, "readiness_probe_initial_delay_seconds")

    @readiness_probe_initial_delay_seconds.setter
    def readiness_probe_initial_delay_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "readiness_probe_initial_delay_seconds", value)

    @property
    @pulumi.getter(name="readinessProbePeriodSeconds")
    def readiness_probe_period_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The interval at which the readiness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
        """
        return pulumi.get(self, "readiness_probe_period_seconds")

    @readiness_probe_period_seconds.setter
    def readiness_probe_period_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "readiness_probe_period_seconds", value)

    @property
    @pulumi.getter(name="readinessProbeSuccessThreshold")
    def readiness_probe_success_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum number of consecutive successes for the readiness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
        """
        return pulumi.get(self, "readiness_probe_success_threshold")

    @readiness_probe_success_threshold.setter
    def readiness_probe_success_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "readiness_probe_success_threshold", value)

    @property
    @pulumi.getter(name="readinessProbeTcpSocketPort")
    def readiness_probe_tcp_socket_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port detected by Transmission Control Protocol (TCP) sockets when you use TCP sockets to perform readiness probes.
        """
        return pulumi.get(self, "readiness_probe_tcp_socket_port")

    @readiness_probe_tcp_socket_port.setter
    def readiness_probe_tcp_socket_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "readiness_probe_tcp_socket_port", value)

    @property
    @pulumi.getter(name="readinessProbeTimeoutSeconds")
    def readiness_probe_timeout_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The timeout period for the readiness probe. Unit: seconds. Default value: 1. Minimum value: 1.
        """
        return pulumi.get(self, "readiness_probe_timeout_seconds")

    @readiness_probe_timeout_seconds.setter
    def readiness_probe_timeout_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "readiness_probe_timeout_seconds", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerVolumeMountArgs']]]]:
        """
        The structure of volumeMounts. 
        See `volume_mounts` below for details.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        The working directory of the container.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class EciScalingConfigurationContainerEnvironmentVarArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The name of the variable. The name can be 1 to 128 characters in length and can contain letters,
               digits, and underscores (_). It cannot start with a digit.
        :param pulumi.Input[str] value: The value of the variable. The value can be 0 to 256 characters in length.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the variable. The name can be 1 to 128 characters in length and can contain letters,
        digits, and underscores (_). It cannot start with a digit.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the variable. The value can be 0 to 256 characters in length.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EciScalingConfigurationContainerPortArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] port: The port number. Valid values: 1 to 65535.
        :param pulumi.Input[str] protocol: Valid values: TCP and UDP.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number. Valid values: 1 to 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values: TCP and UDP.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class EciScalingConfigurationContainerVolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] mount_path: The directory of the mounted volume. Data under this directory will be overwritten by the
               data in the volume.
        :param pulumi.Input[str] name: The name of the mounted volume.
        :param pulumi.Input[bool] read_only: Default to `false`.
        """
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        The directory of the mounted volume. Data under this directory will be overwritten by the
        data in the volume.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Default to `false`.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class EciScalingConfigurationHostAliasArgs:
    def __init__(__self__, *,
                 hostnames: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] hostnames: Adds a host name.
        :param pulumi.Input[str] ip: Adds an IP address.
        """
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def hostnames(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Adds a host name.
        """
        return pulumi.get(self, "hostnames")

    @hostnames.setter
    def hostnames(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "hostnames", value)

    @property
    @pulumi.getter
    def ip(self) -> Optional[pulumi.Input[str]]:
        """
        Adds an IP address.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip", value)


@pulumi.input_type
class EciScalingConfigurationImageRegistryCredentialArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 server: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] password: The password used to log on to the image repository. It is required
               when `image_registry_credential` is configured.
        :param pulumi.Input[str] server: The address of the image repository. It is required when `image_registry_credential` is
               configured.
        :param pulumi.Input[str] username: The username used to log on to the image repository. It is required
               when `image_registry_credential` is configured.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password used to log on to the image repository. It is required
        when `image_registry_credential` is configured.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def server(self) -> Optional[pulumi.Input[str]]:
        """
        The address of the image repository. It is required when `image_registry_credential` is
        configured.
        """
        return pulumi.get(self, "server")

    @server.setter
    def server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "server", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username used to log on to the image repository. It is required
        when `image_registry_credential` is configured.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class EciScalingConfigurationInitContainerArgs:
    def __init__(__self__, *,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cpu: Optional[pulumi.Input[float]] = None,
                 environment_vars: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerEnvironmentVarArgs']]]] = None,
                 gpu: Optional[pulumi.Input[int]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 image_pull_policy: Optional[pulumi.Input[str]] = None,
                 memory: Optional[pulumi.Input[float]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerPortArgs']]]] = None,
                 volume_mounts: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerVolumeMountArgs']]]] = None,
                 working_dir: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: The arguments passed to the commands.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: The commands run by the init container.
        :param pulumi.Input[float] cpu: The amount of CPU resources allocated to the container.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerEnvironmentVarArgs']]] environment_vars: The structure of environmentVars. 
               See `environment_vars` below for details.
        :param pulumi.Input[int] gpu: The number GPUs.
        :param pulumi.Input[str] image: The image of the container.
        :param pulumi.Input[str] image_pull_policy: The restart policy of the image.
        :param pulumi.Input[float] memory: The amount of memory resources allocated to the container.
        :param pulumi.Input[str] name: The name of the mounted volume.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerPortArgs']]] ports: The structure of port. See `ports` below for details.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerVolumeMountArgs']]] volume_mounts: The structure of volumeMounts. See `volume_mounts` below for details.
        :param pulumi.Input[str] working_dir: The working directory of the container.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if environment_vars is not None:
            pulumi.set(__self__, "environment_vars", environment_vars)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The arguments passed to the commands.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The commands run by the init container.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of CPU resources allocated to the container.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerEnvironmentVarArgs']]]]:
        """
        The structure of environmentVars. 
        See `environment_vars` below for details.
        """
        return pulumi.get(self, "environment_vars")

    @environment_vars.setter
    def environment_vars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerEnvironmentVarArgs']]]]):
        pulumi.set(self, "environment_vars", value)

    @property
    @pulumi.getter
    def gpu(self) -> Optional[pulumi.Input[int]]:
        """
        The number GPUs.
        """
        return pulumi.get(self, "gpu")

    @gpu.setter
    def gpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "gpu", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        The image of the container.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The restart policy of the image.
        """
        return pulumi.get(self, "image_pull_policy")

    @image_pull_policy.setter
    def image_pull_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_pull_policy", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of memory resources allocated to the container.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerPortArgs']]]]:
        """
        The structure of port. See `ports` below for details.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerPortArgs']]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerVolumeMountArgs']]]]:
        """
        The structure of volumeMounts. See `volume_mounts` below for details.
        """
        return pulumi.get(self, "volume_mounts")

    @volume_mounts.setter
    def volume_mounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerVolumeMountArgs']]]]):
        pulumi.set(self, "volume_mounts", value)

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[pulumi.Input[str]]:
        """
        The working directory of the container.
        """
        return pulumi.get(self, "working_dir")

    @working_dir.setter
    def working_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "working_dir", value)


@pulumi.input_type
class EciScalingConfigurationInitContainerEnvironmentVarArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key: The name of the variable. The name can be 1 to 128 characters in length and can contain letters,
               digits, and underscores (_). It cannot start with a digit.
        :param pulumi.Input[str] value: The value of the variable. The value can be 0 to 256 characters in length.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the variable. The name can be 1 to 128 characters in length and can contain letters,
        digits, and underscores (_). It cannot start with a digit.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the variable. The value can be 0 to 256 characters in length.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class EciScalingConfigurationInitContainerPortArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] port: The port number. Valid values: 1 to 65535.
        :param pulumi.Input[str] protocol: Valid values: TCP and UDP.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number. Valid values: 1 to 65535.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Valid values: TCP and UDP.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class EciScalingConfigurationInitContainerVolumeMountArgs:
    def __init__(__self__, *,
                 mount_path: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 read_only: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] mount_path: The directory of the mounted volume. Data under this directory will be overwritten by the
               data in the volume.
        :param pulumi.Input[str] name: The name of the mounted volume.
        :param pulumi.Input[bool] read_only: Default to `false`.
        """
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[pulumi.Input[str]]:
        """
        The directory of the mounted volume. Data under this directory will be overwritten by the
        data in the volume.
        """
        return pulumi.get(self, "mount_path")

    @mount_path.setter
    def mount_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mount_path", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        Default to `false`.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "read_only", value)


@pulumi.input_type
class EciScalingConfigurationVolumeArgs:
    def __init__(__self__, *,
                 config_file_volume_config_file_to_paths: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs']]]] = None,
                 disk_volume_disk_id: Optional[pulumi.Input[str]] = None,
                 disk_volume_disk_size: Optional[pulumi.Input[int]] = None,
                 disk_volume_fs_type: Optional[pulumi.Input[str]] = None,
                 flex_volume_driver: Optional[pulumi.Input[str]] = None,
                 flex_volume_fs_type: Optional[pulumi.Input[str]] = None,
                 flex_volume_options: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nfs_volume_path: Optional[pulumi.Input[str]] = None,
                 nfs_volume_read_only: Optional[pulumi.Input[bool]] = None,
                 nfs_volume_server: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs']]] config_file_volume_config_file_to_paths: ConfigFileVolumeConfigFileToPaths.
               See `config_file_volume_config_file_to_paths` below for details.
        :param pulumi.Input[str] disk_volume_disk_id: The ID of DiskVolume.
        :param pulumi.Input[int] disk_volume_disk_size: The disk size of DiskVolume.
        :param pulumi.Input[str] disk_volume_fs_type: The system type of DiskVolume.
        :param pulumi.Input[str] flex_volume_driver: The name of the FlexVolume driver.
        :param pulumi.Input[str] flex_volume_fs_type: The type of the mounted file system. The default value is determined by the script
               of FlexVolume.
        :param pulumi.Input[str] flex_volume_options: The list of FlexVolume objects. Each object is a key-value pair contained in a JSON
               string.
        :param pulumi.Input[str] name: The name of the volume.
        :param pulumi.Input[str] nfs_volume_path: The path to the NFS volume.
        :param pulumi.Input[bool] nfs_volume_read_only: The nfs volume read only. Default to `false`.
        :param pulumi.Input[str] nfs_volume_server: The address of the NFS server.
               
               > **NOTE:** Every volume mounted must have a name and type attributes.
        :param pulumi.Input[str] type: The type of the volume.
        """
        if config_file_volume_config_file_to_paths is not None:
            pulumi.set(__self__, "config_file_volume_config_file_to_paths", config_file_volume_config_file_to_paths)
        if disk_volume_disk_id is not None:
            pulumi.set(__self__, "disk_volume_disk_id", disk_volume_disk_id)
        if disk_volume_disk_size is not None:
            pulumi.set(__self__, "disk_volume_disk_size", disk_volume_disk_size)
        if disk_volume_fs_type is not None:
            pulumi.set(__self__, "disk_volume_fs_type", disk_volume_fs_type)
        if flex_volume_driver is not None:
            pulumi.set(__self__, "flex_volume_driver", flex_volume_driver)
        if flex_volume_fs_type is not None:
            pulumi.set(__self__, "flex_volume_fs_type", flex_volume_fs_type)
        if flex_volume_options is not None:
            pulumi.set(__self__, "flex_volume_options", flex_volume_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_volume_path is not None:
            pulumi.set(__self__, "nfs_volume_path", nfs_volume_path)
        if nfs_volume_read_only is not None:
            pulumi.set(__self__, "nfs_volume_read_only", nfs_volume_read_only)
        if nfs_volume_server is not None:
            pulumi.set(__self__, "nfs_volume_server", nfs_volume_server)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="configFileVolumeConfigFileToPaths")
    def config_file_volume_config_file_to_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs']]]]:
        """
        ConfigFileVolumeConfigFileToPaths.
        See `config_file_volume_config_file_to_paths` below for details.
        """
        return pulumi.get(self, "config_file_volume_config_file_to_paths")

    @config_file_volume_config_file_to_paths.setter
    def config_file_volume_config_file_to_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs']]]]):
        pulumi.set(self, "config_file_volume_config_file_to_paths", value)

    @property
    @pulumi.getter(name="diskVolumeDiskId")
    def disk_volume_disk_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_disk_id")

    @disk_volume_disk_id.setter
    def disk_volume_disk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_volume_disk_id", value)

    @property
    @pulumi.getter(name="diskVolumeDiskSize")
    def disk_volume_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        The disk size of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_disk_size")

    @disk_volume_disk_size.setter
    def disk_volume_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_volume_disk_size", value)

    @property
    @pulumi.getter(name="diskVolumeFsType")
    def disk_volume_fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        The system type of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_fs_type")

    @disk_volume_fs_type.setter
    def disk_volume_fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_volume_fs_type", value)

    @property
    @pulumi.getter(name="flexVolumeDriver")
    def flex_volume_driver(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the FlexVolume driver.
        """
        return pulumi.get(self, "flex_volume_driver")

    @flex_volume_driver.setter
    def flex_volume_driver(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flex_volume_driver", value)

    @property
    @pulumi.getter(name="flexVolumeFsType")
    def flex_volume_fs_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the mounted file system. The default value is determined by the script
        of FlexVolume.
        """
        return pulumi.get(self, "flex_volume_fs_type")

    @flex_volume_fs_type.setter
    def flex_volume_fs_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flex_volume_fs_type", value)

    @property
    @pulumi.getter(name="flexVolumeOptions")
    def flex_volume_options(self) -> Optional[pulumi.Input[str]]:
        """
        The list of FlexVolume objects. Each object is a key-value pair contained in a JSON
        string.
        """
        return pulumi.get(self, "flex_volume_options")

    @flex_volume_options.setter
    def flex_volume_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flex_volume_options", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the volume.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nfsVolumePath")
    def nfs_volume_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the NFS volume.
        """
        return pulumi.get(self, "nfs_volume_path")

    @nfs_volume_path.setter
    def nfs_volume_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nfs_volume_path", value)

    @property
    @pulumi.getter(name="nfsVolumeReadOnly")
    def nfs_volume_read_only(self) -> Optional[pulumi.Input[bool]]:
        """
        The nfs volume read only. Default to `false`.
        """
        return pulumi.get(self, "nfs_volume_read_only")

    @nfs_volume_read_only.setter
    def nfs_volume_read_only(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "nfs_volume_read_only", value)

    @property
    @pulumi.getter(name="nfsVolumeServer")
    def nfs_volume_server(self) -> Optional[pulumi.Input[str]]:
        """
        The address of the NFS server.

        > **NOTE:** Every volume mounted must have a name and type attributes.
        """
        return pulumi.get(self, "nfs_volume_server")

    @nfs_volume_server.setter
    def nfs_volume_server(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nfs_volume_server", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the volume.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] content: The content of the configuration file. Maximum size: 32 KB.
        :param pulumi.Input[str] path: The relative file path.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The content of the configuration file. Maximum size: 32 KB.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The relative file path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class ScalingConfigurationDataDiskArgs:
    def __init__(__self__, *,
                 auto_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 delete_with_instance: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device: Optional[pulumi.Input[str]] = None,
                 encrypted: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 performance_level: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 snapshot_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] auto_snapshot_policy_id: The id of auto snapshot policy for data disk.
        :param pulumi.Input[str] category: Category of data disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd` and `cloud`.
        :param pulumi.Input[bool] delete_with_instance: Whether to delete data disks attached on ecs when release ecs instance. Optional value: `true` or `false`, default to `true`.
        :param pulumi.Input[str] description: The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[str] device: The mount point of data disk N. Valid values of N: 1 to 16. If this parameter is not specified, the system automatically allocates a mount point to created ECS instances. The name of the mount point ranges from /dev/xvdb to /dev/xvdz in alphabetical order.
        :param pulumi.Input[bool] encrypted: Specifies whether data disk N is to be encrypted. Valid values of N: 1 to 16. Valid values: `true`: encrypted, `false`: not encrypted. Default value: `false`.
        :param pulumi.Input[str] kms_key_id: The CMK ID for data disk N. Valid values of N: 1 to 16.
        :param pulumi.Input[str] name: The name of data disk N. Valid values of N: 1 to 16. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        :param pulumi.Input[str] performance_level: The performance level of the ESSD used as data disk.
        :param pulumi.Input[int] size: Size of data disk, in GB. The value ranges [5,2000] for a cloud disk, [5,1024] for an ephemeral disk, [5,800] for an ephemeral_ssd disk, [20,32768] for cloud_efficiency, cloud_ssd, cloud_essd disk.
        :param pulumi.Input[str] snapshot_id: Snapshot used for creating the data disk. If this parameter is specified, the size parameter is neglected, and the size of the created disk is the size of the snapshot.
        """
        if auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            warnings.warn("""Attribute device has been deprecated on disk attachment resource. Suggest to remove it from your template.""", DeprecationWarning)
            pulumi.log.warn("""device is deprecated: Attribute device has been deprecated on disk attachment resource. Suggest to remove it from your template.""")
        if device is not None:
            pulumi.set(__self__, "device", device)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of auto snapshot policy for data disk.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @auto_snapshot_policy_id.setter
    def auto_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_snapshot_policy_id", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        Category of data disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd` and `cloud`.
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to delete data disks attached on ecs when release ecs instance. Optional value: `true` or `false`, default to `true`.
        """
        return pulumi.get(self, "delete_with_instance")

    @delete_with_instance.setter
    def delete_with_instance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_with_instance", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def device(self) -> Optional[pulumi.Input[str]]:
        """
        The mount point of data disk N. Valid values of N: 1 to 16. If this parameter is not specified, the system automatically allocates a mount point to created ECS instances. The name of the mount point ranges from /dev/xvdb to /dev/xvdz in alphabetical order.
        """
        warnings.warn("""Attribute device has been deprecated on disk attachment resource. Suggest to remove it from your template.""", DeprecationWarning)
        pulumi.log.warn("""device is deprecated: Attribute device has been deprecated on disk attachment resource. Suggest to remove it from your template.""")

        return pulumi.get(self, "device")

    @device.setter
    def device(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device", value)

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether data disk N is to be encrypted. Valid values of N: 1 to 16. Valid values: `true`: encrypted, `false`: not encrypted. Default value: `false`.
        """
        return pulumi.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encrypted", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The CMK ID for data disk N. Valid values of N: 1 to 16.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of data disk N. Valid values of N: 1 to 16. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        The performance level of the ESSD used as data disk.
        """
        return pulumi.get(self, "performance_level")

    @performance_level.setter
    def performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "performance_level", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of data disk, in GB. The value ranges [5,2000] for a cloud disk, [5,1024] for an ephemeral disk, [5,800] for an ephemeral_ssd disk, [20,32768] for cloud_efficiency, cloud_ssd, cloud_essd disk.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[str]]:
        """
        Snapshot used for creating the data disk. If this parameter is specified, the size parameter is neglected, and the size of the created disk is the size of the snapshot.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "snapshot_id", value)


@pulumi.input_type
class ScalingConfigurationInstancePatternInfoArgs:
    def __init__(__self__, *,
                 cores: Optional[pulumi.Input[int]] = None,
                 instance_family_level: Optional[pulumi.Input[str]] = None,
                 max_price: Optional[pulumi.Input[float]] = None,
                 memory: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[int] cores: The number of vCPUs that are specified for an instance type in instancePatternInfo.
        :param pulumi.Input[str] instance_family_level: The instance family level in instancePatternInfo.
        :param pulumi.Input[float] max_price: The maximum hourly price for a pay-as-you-go instance or a preemptible instance in instancePatternInfo.
        :param pulumi.Input[float] memory: The memory size that is specified for an instance type in instancePatternInfo.
        """
        if cores is not None:
            pulumi.set(__self__, "cores", cores)
        if instance_family_level is not None:
            pulumi.set(__self__, "instance_family_level", instance_family_level)
        if max_price is not None:
            pulumi.set(__self__, "max_price", max_price)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cores(self) -> Optional[pulumi.Input[int]]:
        """
        The number of vCPUs that are specified for an instance type in instancePatternInfo.
        """
        return pulumi.get(self, "cores")

    @cores.setter
    def cores(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cores", value)

    @property
    @pulumi.getter(name="instanceFamilyLevel")
    def instance_family_level(self) -> Optional[pulumi.Input[str]]:
        """
        The instance family level in instancePatternInfo.
        """
        return pulumi.get(self, "instance_family_level")

    @instance_family_level.setter
    def instance_family_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_family_level", value)

    @property
    @pulumi.getter(name="maxPrice")
    def max_price(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum hourly price for a pay-as-you-go instance or a preemptible instance in instancePatternInfo.
        """
        return pulumi.get(self, "max_price")

    @max_price.setter
    def max_price(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_price", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[float]]:
        """
        The memory size that is specified for an instance type in instancePatternInfo.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory", value)


@pulumi.input_type
class ScalingConfigurationSpotPriceLimitArgs:
    def __init__(__self__, *,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 price_limit: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] instance_type: Resource type of an ECS instance.
        :param pulumi.Input[float] price_limit: Price limit hourly of instance type, 2 decimals is allowed at most.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if price_limit is not None:
            pulumi.set(__self__, "price_limit", price_limit)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type of an ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="priceLimit")
    def price_limit(self) -> Optional[pulumi.Input[float]]:
        """
        Price limit hourly of instance type, 2 decimals is allowed at most.
        """
        return pulumi.get(self, "price_limit")

    @price_limit.setter
    def price_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "price_limit", value)


@pulumi.input_type
class ScalingGroupVServerGroupsVserverGroupArgs:
    def __init__(__self__, *,
                 loadbalancer_id: pulumi.Input[str],
                 vserver_attributes: pulumi.Input[Sequence[pulumi.Input['ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs']]]):
        """
        :param pulumi.Input[str] loadbalancer_id: Loadbalancer server ID of VServer Group.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs']]] vserver_attributes: A list of VServer Group attributes. See `vserver_attributes` below.
        """
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        pulumi.set(__self__, "vserver_attributes", vserver_attributes)

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Input[str]:
        """
        Loadbalancer server ID of VServer Group.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "loadbalancer_id", value)

    @property
    @pulumi.getter(name="vserverAttributes")
    def vserver_attributes(self) -> pulumi.Input[Sequence[pulumi.Input['ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs']]]:
        """
        A list of VServer Group attributes. See `vserver_attributes` below.
        """
        return pulumi.get(self, "vserver_attributes")

    @vserver_attributes.setter
    def vserver_attributes(self, value: pulumi.Input[Sequence[pulumi.Input['ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs']]]):
        pulumi.set(self, "vserver_attributes", value)


@pulumi.input_type
class ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 vserver_group_id: pulumi.Input[str],
                 weight: pulumi.Input[int]):
        """
        :param pulumi.Input[int] port: The port will be used for VServer Group backend server.
        :param pulumi.Input[str] vserver_group_id: ID of VServer Group.
        :param pulumi.Input[int] weight: The weight of an ECS instance attached to the VServer Group.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "vserver_group_id", vserver_group_id)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The port will be used for VServer Group backend server.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="vserverGroupId")
    def vserver_group_id(self) -> pulumi.Input[str]:
        """
        ID of VServer Group.
        """
        return pulumi.get(self, "vserver_group_id")

    @vserver_group_id.setter
    def vserver_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vserver_group_id", value)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[int]:
        """
        The weight of an ECS instance attached to the VServer Group.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[int]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class ScalingRuleStepAdjustmentArgs:
    def __init__(__self__, *,
                 metric_interval_lower_bound: Optional[pulumi.Input[str]] = None,
                 metric_interval_upper_bound: Optional[pulumi.Input[str]] = None,
                 scaling_adjustment: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] metric_interval_lower_bound: The lower bound of step.
        :param pulumi.Input[str] metric_interval_upper_bound: The upper bound of step.
        :param pulumi.Input[int] scaling_adjustment: The adjust value of step.
        """
        if metric_interval_lower_bound is not None:
            pulumi.set(__self__, "metric_interval_lower_bound", metric_interval_lower_bound)
        if metric_interval_upper_bound is not None:
            pulumi.set(__self__, "metric_interval_upper_bound", metric_interval_upper_bound)
        if scaling_adjustment is not None:
            pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)

    @property
    @pulumi.getter(name="metricIntervalLowerBound")
    def metric_interval_lower_bound(self) -> Optional[pulumi.Input[str]]:
        """
        The lower bound of step.
        """
        return pulumi.get(self, "metric_interval_lower_bound")

    @metric_interval_lower_bound.setter
    def metric_interval_lower_bound(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_interval_lower_bound", value)

    @property
    @pulumi.getter(name="metricIntervalUpperBound")
    def metric_interval_upper_bound(self) -> Optional[pulumi.Input[str]]:
        """
        The upper bound of step.
        """
        return pulumi.get(self, "metric_interval_upper_bound")

    @metric_interval_upper_bound.setter
    def metric_interval_upper_bound(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_interval_upper_bound", value)

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> Optional[pulumi.Input[int]]:
        """
        The adjust value of step.
        """
        return pulumi.get(self, "scaling_adjustment")

    @scaling_adjustment.setter
    def scaling_adjustment(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scaling_adjustment", value)


