# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EciScalingConfigurationArgs', 'EciScalingConfiguration']

@pulumi.input_type
class EciScalingConfigurationArgs:
    def __init__(__self__, *,
                 scaling_group_id: pulumi.Input[str],
                 acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 auto_create_eip: Optional[pulumi.Input[bool]] = None,
                 container_group_name: Optional[pulumi.Input[str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]]] = None,
                 cpu: Optional[pulumi.Input[float]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_policy: Optional[pulumi.Input[str]] = None,
                 egress_bandwidth: Optional[pulumi.Input[int]] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 enable_sls: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]]] = None,
                 ingress_bandwidth: Optional[pulumi.Input[int]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]]] = None,
                 memory: Optional[pulumi.Input[float]] = None,
                 ram_role_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 restart_policy: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]]] = None):
        """
        The set of arguments for constructing a EciScalingConfiguration resource.
        :param pulumi.Input[str] scaling_group_id: ID of the scaling group of a eci scaling configuration.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]] acr_registry_infos: Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
        :param pulumi.Input[bool] active: Whether active current eci scaling configuration in the specified scaling group. Note that only
               one configuration can be active. Default to `false`.
        :param pulumi.Input[bool] auto_create_eip: Whether create eip automatically.
        :param pulumi.Input[str] container_group_name: The name of the container group.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]] containers: The list of containers. See `containers` below for details.
        :param pulumi.Input[float] cpu: The amount of CPU resources allocated to the container group.
        :param pulumi.Input[str] description: The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
               256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[str] dns_policy: dns policy of contain group.
        :param pulumi.Input[int] egress_bandwidth: egress bandwidth.
        :param pulumi.Input[int] eip_bandwidth: Eip bandwidth.
        :param pulumi.Input[bool] enable_sls: Enable sls log service.
        :param pulumi.Input[bool] force_delete: The eci scaling configuration will be deleted forcibly with deleting its scaling group.
               Default to false.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]] host_aliases: HostAliases. See `host_aliases` below.
        :param pulumi.Input[str] host_name: Hostname of an ECI instance.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]] image_registry_credentials: The image registry credential.   See `image_registry_credentials` below for
               details.
        :param pulumi.Input[int] ingress_bandwidth: Ingress bandwidth.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]] init_containers: The list of initContainers. See `init_containers` below for details.
        :param pulumi.Input[float] memory: The amount of memory resources allocated to the container group.
        :param pulumi.Input[str] ram_role_name: The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        :param pulumi.Input[str] resource_group_id: ID of resource group.
        :param pulumi.Input[str] restart_policy: The restart policy of the container group. Default to `Always`.
        :param pulumi.Input[str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (
               English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
               underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
               EciScalingConfigurationId.
        :param pulumi.Input[str] security_group_id: ID of the security group used to create new instance. It is conflict
               with `security_group_ids`.
        :param pulumi.Input[float] spot_price_limit: The maximum price hourly for spot instance.
        :param pulumi.Input[str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
               , `SpotWithPriceLimit`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
               be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
               a null string.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]] volumes: The list of volumes. See `volumes` below for details.
        """
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if acr_registry_infos is not None:
            pulumi.set(__self__, "acr_registry_infos", acr_registry_infos)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if auto_create_eip is not None:
            pulumi.set(__self__, "auto_create_eip", auto_create_eip)
        if container_group_name is not None:
            pulumi.set(__self__, "container_group_name", container_group_name)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_policy is not None:
            pulumi.set(__self__, "dns_policy", dns_policy)
        if egress_bandwidth is not None:
            pulumi.set(__self__, "egress_bandwidth", egress_bandwidth)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if enable_sls is not None:
            pulumi.set(__self__, "enable_sls", enable_sls)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if host_aliases is not None:
            pulumi.set(__self__, "host_aliases", host_aliases)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_registry_credentials is not None:
            pulumi.set(__self__, "image_registry_credentials", image_registry_credentials)
        if ingress_bandwidth is not None:
            pulumi.set(__self__, "ingress_bandwidth", ingress_bandwidth)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if scaling_configuration_name is not None:
            pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[str]:
        """
        ID of the scaling group of a eci scaling configuration.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_group_id", value)

    @property
    @pulumi.getter(name="acrRegistryInfos")
    def acr_registry_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]]]:
        """
        Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
        """
        return pulumi.get(self, "acr_registry_infos")

    @acr_registry_infos.setter
    def acr_registry_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]]]):
        pulumi.set(self, "acr_registry_infos", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether active current eci scaling configuration in the specified scaling group. Note that only
        one configuration can be active. Default to `false`.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="autoCreateEip")
    def auto_create_eip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether create eip automatically.
        """
        return pulumi.get(self, "auto_create_eip")

    @auto_create_eip.setter
    def auto_create_eip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_create_eip", value)

    @property
    @pulumi.getter(name="containerGroupName")
    def container_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the container group.
        """
        return pulumi.get(self, "container_group_name")

    @container_group_name.setter
    def container_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_group_name", value)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]]]:
        """
        The list of containers. See `containers` below for details.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of CPU resources allocated to the container group.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
        256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> Optional[pulumi.Input[str]]:
        """
        dns policy of contain group.
        """
        return pulumi.get(self, "dns_policy")

    @dns_policy.setter
    def dns_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_policy", value)

    @property
    @pulumi.getter(name="egressBandwidth")
    def egress_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        egress bandwidth.
        """
        return pulumi.get(self, "egress_bandwidth")

    @egress_bandwidth.setter
    def egress_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "egress_bandwidth", value)

    @property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Eip bandwidth.
        """
        return pulumi.get(self, "eip_bandwidth")

    @eip_bandwidth.setter
    def eip_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eip_bandwidth", value)

    @property
    @pulumi.getter(name="enableSls")
    def enable_sls(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable sls log service.
        """
        return pulumi.get(self, "enable_sls")

    @enable_sls.setter
    def enable_sls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_sls", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        The eci scaling configuration will be deleted forcibly with deleting its scaling group.
        Default to false.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="hostAliases")
    def host_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]]]:
        """
        HostAliases. See `host_aliases` below.
        """
        return pulumi.get(self, "host_aliases")

    @host_aliases.setter
    def host_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]]]):
        pulumi.set(self, "host_aliases", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of an ECI instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="imageRegistryCredentials")
    def image_registry_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]]]:
        """
        The image registry credential.   See `image_registry_credentials` below for
        details.
        """
        return pulumi.get(self, "image_registry_credentials")

    @image_registry_credentials.setter
    def image_registry_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]]]):
        pulumi.set(self, "image_registry_credentials", value)

    @property
    @pulumi.getter(name="ingressBandwidth")
    def ingress_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Ingress bandwidth.
        """
        return pulumi.get(self, "ingress_bandwidth")

    @ingress_bandwidth.setter
    def ingress_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ingress_bandwidth", value)

    @property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]]]:
        """
        The list of initContainers. See `init_containers` below for details.
        """
        return pulumi.get(self, "init_containers")

    @init_containers.setter
    def init_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]]]):
        pulumi.set(self, "init_containers", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of memory resources allocated to the container group.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ram_role_name", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The restart policy of the container group. Default to `Always`.
        """
        return pulumi.get(self, "restart_policy")

    @restart_policy.setter
    def restart_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restart_policy", value)

    @property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name shown for the scheduled task. which must contain 2-64 characters (
        English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
        underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
        EciScalingConfigurationId.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_configuration_name", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the security group used to create new instance. It is conflict
        with `security_group_ids`.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum price hourly for spot instance.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "spot_price_limit", value)

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
        , `SpotWithPriceLimit`.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_strategy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
        be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
        a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]]]:
        """
        The list of volumes. See `volumes` below for details.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


@pulumi.input_type
class _EciScalingConfigurationState:
    def __init__(__self__, *,
                 acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 auto_create_eip: Optional[pulumi.Input[bool]] = None,
                 container_group_name: Optional[pulumi.Input[str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]]] = None,
                 cpu: Optional[pulumi.Input[float]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_policy: Optional[pulumi.Input[str]] = None,
                 egress_bandwidth: Optional[pulumi.Input[int]] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 enable_sls: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]]] = None,
                 ingress_bandwidth: Optional[pulumi.Input[int]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]]] = None,
                 memory: Optional[pulumi.Input[float]] = None,
                 ram_role_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 restart_policy: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]]] = None):
        """
        Input properties used for looking up and filtering EciScalingConfiguration resources.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]] acr_registry_infos: Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
        :param pulumi.Input[bool] active: Whether active current eci scaling configuration in the specified scaling group. Note that only
               one configuration can be active. Default to `false`.
        :param pulumi.Input[bool] auto_create_eip: Whether create eip automatically.
        :param pulumi.Input[str] container_group_name: The name of the container group.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]] containers: The list of containers. See `containers` below for details.
        :param pulumi.Input[float] cpu: The amount of CPU resources allocated to the container group.
        :param pulumi.Input[str] description: The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
               256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[str] dns_policy: dns policy of contain group.
        :param pulumi.Input[int] egress_bandwidth: egress bandwidth.
        :param pulumi.Input[int] eip_bandwidth: Eip bandwidth.
        :param pulumi.Input[bool] enable_sls: Enable sls log service.
        :param pulumi.Input[bool] force_delete: The eci scaling configuration will be deleted forcibly with deleting its scaling group.
               Default to false.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]] host_aliases: HostAliases. See `host_aliases` below.
        :param pulumi.Input[str] host_name: Hostname of an ECI instance.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]] image_registry_credentials: The image registry credential.   See `image_registry_credentials` below for
               details.
        :param pulumi.Input[int] ingress_bandwidth: Ingress bandwidth.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]] init_containers: The list of initContainers. See `init_containers` below for details.
        :param pulumi.Input[float] memory: The amount of memory resources allocated to the container group.
        :param pulumi.Input[str] ram_role_name: The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        :param pulumi.Input[str] resource_group_id: ID of resource group.
        :param pulumi.Input[str] restart_policy: The restart policy of the container group. Default to `Always`.
        :param pulumi.Input[str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (
               English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
               underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
               EciScalingConfigurationId.
        :param pulumi.Input[str] scaling_group_id: ID of the scaling group of a eci scaling configuration.
        :param pulumi.Input[str] security_group_id: ID of the security group used to create new instance. It is conflict
               with `security_group_ids`.
        :param pulumi.Input[float] spot_price_limit: The maximum price hourly for spot instance.
        :param pulumi.Input[str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
               , `SpotWithPriceLimit`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
               be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
               a null string.
        :param pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]] volumes: The list of volumes. See `volumes` below for details.
        """
        if acr_registry_infos is not None:
            pulumi.set(__self__, "acr_registry_infos", acr_registry_infos)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if auto_create_eip is not None:
            pulumi.set(__self__, "auto_create_eip", auto_create_eip)
        if container_group_name is not None:
            pulumi.set(__self__, "container_group_name", container_group_name)
        if containers is not None:
            pulumi.set(__self__, "containers", containers)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_policy is not None:
            pulumi.set(__self__, "dns_policy", dns_policy)
        if egress_bandwidth is not None:
            pulumi.set(__self__, "egress_bandwidth", egress_bandwidth)
        if eip_bandwidth is not None:
            pulumi.set(__self__, "eip_bandwidth", eip_bandwidth)
        if enable_sls is not None:
            pulumi.set(__self__, "enable_sls", enable_sls)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if host_aliases is not None:
            pulumi.set(__self__, "host_aliases", host_aliases)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_registry_credentials is not None:
            pulumi.set(__self__, "image_registry_credentials", image_registry_credentials)
        if ingress_bandwidth is not None:
            pulumi.set(__self__, "ingress_bandwidth", ingress_bandwidth)
        if init_containers is not None:
            pulumi.set(__self__, "init_containers", init_containers)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if ram_role_name is not None:
            pulumi.set(__self__, "ram_role_name", ram_role_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if restart_policy is not None:
            pulumi.set(__self__, "restart_policy", restart_policy)
        if scaling_configuration_name is not None:
            pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if spot_price_limit is not None:
            pulumi.set(__self__, "spot_price_limit", spot_price_limit)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="acrRegistryInfos")
    def acr_registry_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]]]:
        """
        Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
        """
        return pulumi.get(self, "acr_registry_infos")

    @acr_registry_infos.setter
    def acr_registry_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationAcrRegistryInfoArgs']]]]):
        pulumi.set(self, "acr_registry_infos", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether active current eci scaling configuration in the specified scaling group. Note that only
        one configuration can be active. Default to `false`.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="autoCreateEip")
    def auto_create_eip(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether create eip automatically.
        """
        return pulumi.get(self, "auto_create_eip")

    @auto_create_eip.setter
    def auto_create_eip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_create_eip", value)

    @property
    @pulumi.getter(name="containerGroupName")
    def container_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the container group.
        """
        return pulumi.get(self, "container_group_name")

    @container_group_name.setter
    def container_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_group_name", value)

    @property
    @pulumi.getter
    def containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]]]:
        """
        The list of containers. See `containers` below for details.
        """
        return pulumi.get(self, "containers")

    @containers.setter
    def containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationContainerArgs']]]]):
        pulumi.set(self, "containers", value)

    @property
    @pulumi.getter
    def cpu(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of CPU resources allocated to the container group.
        """
        return pulumi.get(self, "cpu")

    @cpu.setter
    def cpu(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
        256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> Optional[pulumi.Input[str]]:
        """
        dns policy of contain group.
        """
        return pulumi.get(self, "dns_policy")

    @dns_policy.setter
    def dns_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_policy", value)

    @property
    @pulumi.getter(name="egressBandwidth")
    def egress_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        egress bandwidth.
        """
        return pulumi.get(self, "egress_bandwidth")

    @egress_bandwidth.setter
    def egress_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "egress_bandwidth", value)

    @property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Eip bandwidth.
        """
        return pulumi.get(self, "eip_bandwidth")

    @eip_bandwidth.setter
    def eip_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eip_bandwidth", value)

    @property
    @pulumi.getter(name="enableSls")
    def enable_sls(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable sls log service.
        """
        return pulumi.get(self, "enable_sls")

    @enable_sls.setter
    def enable_sls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_sls", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        The eci scaling configuration will be deleted forcibly with deleting its scaling group.
        Default to false.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="hostAliases")
    def host_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]]]:
        """
        HostAliases. See `host_aliases` below.
        """
        return pulumi.get(self, "host_aliases")

    @host_aliases.setter
    def host_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationHostAliasArgs']]]]):
        pulumi.set(self, "host_aliases", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of an ECI instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="imageRegistryCredentials")
    def image_registry_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]]]:
        """
        The image registry credential.   See `image_registry_credentials` below for
        details.
        """
        return pulumi.get(self, "image_registry_credentials")

    @image_registry_credentials.setter
    def image_registry_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationImageRegistryCredentialArgs']]]]):
        pulumi.set(self, "image_registry_credentials", value)

    @property
    @pulumi.getter(name="ingressBandwidth")
    def ingress_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        Ingress bandwidth.
        """
        return pulumi.get(self, "ingress_bandwidth")

    @ingress_bandwidth.setter
    def ingress_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ingress_bandwidth", value)

    @property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]]]:
        """
        The list of initContainers. See `init_containers` below for details.
        """
        return pulumi.get(self, "init_containers")

    @init_containers.setter
    def init_containers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationInitContainerArgs']]]]):
        pulumi.set(self, "init_containers", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[float]]:
        """
        The amount of memory resources allocated to the container group.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        """
        return pulumi.get(self, "ram_role_name")

    @ram_role_name.setter
    def ram_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ram_role_name", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The restart policy of the container group. Default to `Always`.
        """
        return pulumi.get(self, "restart_policy")

    @restart_policy.setter
    def restart_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "restart_policy", value)

    @property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name shown for the scheduled task. which must contain 2-64 characters (
        English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
        underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
        EciScalingConfigurationId.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_configuration_name", value)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the scaling group of a eci scaling configuration.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_group_id", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the security group used to create new instance. It is conflict
        with `security_group_ids`.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum price hourly for spot instance.
        """
        return pulumi.get(self, "spot_price_limit")

    @spot_price_limit.setter
    def spot_price_limit(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "spot_price_limit", value)

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
        , `SpotWithPriceLimit`.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_strategy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
        be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
        a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]]]:
        """
        The list of volumes. See `volumes` below for details.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EciScalingConfigurationVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)


class EciScalingConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationAcrRegistryInfoArgs']]]]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 auto_create_eip: Optional[pulumi.Input[bool]] = None,
                 container_group_name: Optional[pulumi.Input[str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationContainerArgs']]]]] = None,
                 cpu: Optional[pulumi.Input[float]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_policy: Optional[pulumi.Input[str]] = None,
                 egress_bandwidth: Optional[pulumi.Input[int]] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 enable_sls: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationHostAliasArgs']]]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationImageRegistryCredentialArgs']]]]] = None,
                 ingress_bandwidth: Optional[pulumi.Input[int]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationInitContainerArgs']]]]] = None,
                 memory: Optional[pulumi.Input[float]] = None,
                 ram_role_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 restart_policy: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationVolumeArgs']]]]] = None,
                 __props__=None):
        """
        Provides a ESS eci scaling configuration resource.

        For information about ess eci scaling configuration, see [CreateEciScalingConfiguration](https://www.alibabacloud.com/help/en/auto-scaling/latest/create-eci-scaling-configuration).

        > **NOTE:** Available since v1.164.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default_zones.zones[0].id,
            vswitch_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_scaling_group = alicloud.ess.ScalingGroup("defaultScalingGroup",
            min_size=0,
            max_size=1,
            scaling_group_name=name,
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ],
            vswitch_ids=[default_switch.id],
            group_type="ECI")
        default_eci_scaling_configuration = alicloud.ess.EciScalingConfiguration("defaultEciScalingConfiguration",
            scaling_group_id=default_scaling_group.id,
            cpu=2,
            memory=4,
            security_group_id=default_security_group.id,
            force_delete=True,
            active=True,
            container_group_name="container-group-1649839595174",
            containers=[alicloud.ess.EciScalingConfigurationContainerArgs(
                name="container-1",
                image="registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5",
            )])
        ```

        ## Import

        ESS eci scaling configuration can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ess/eciScalingConfiguration:EciScalingConfiguration example asc-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationAcrRegistryInfoArgs']]]] acr_registry_infos: Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
        :param pulumi.Input[bool] active: Whether active current eci scaling configuration in the specified scaling group. Note that only
               one configuration can be active. Default to `false`.
        :param pulumi.Input[bool] auto_create_eip: Whether create eip automatically.
        :param pulumi.Input[str] container_group_name: The name of the container group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationContainerArgs']]]] containers: The list of containers. See `containers` below for details.
        :param pulumi.Input[float] cpu: The amount of CPU resources allocated to the container group.
        :param pulumi.Input[str] description: The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
               256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[str] dns_policy: dns policy of contain group.
        :param pulumi.Input[int] egress_bandwidth: egress bandwidth.
        :param pulumi.Input[int] eip_bandwidth: Eip bandwidth.
        :param pulumi.Input[bool] enable_sls: Enable sls log service.
        :param pulumi.Input[bool] force_delete: The eci scaling configuration will be deleted forcibly with deleting its scaling group.
               Default to false.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationHostAliasArgs']]]] host_aliases: HostAliases. See `host_aliases` below.
        :param pulumi.Input[str] host_name: Hostname of an ECI instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationImageRegistryCredentialArgs']]]] image_registry_credentials: The image registry credential.   See `image_registry_credentials` below for
               details.
        :param pulumi.Input[int] ingress_bandwidth: Ingress bandwidth.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationInitContainerArgs']]]] init_containers: The list of initContainers. See `init_containers` below for details.
        :param pulumi.Input[float] memory: The amount of memory resources allocated to the container group.
        :param pulumi.Input[str] ram_role_name: The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        :param pulumi.Input[str] resource_group_id: ID of resource group.
        :param pulumi.Input[str] restart_policy: The restart policy of the container group. Default to `Always`.
        :param pulumi.Input[str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (
               English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
               underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
               EciScalingConfigurationId.
        :param pulumi.Input[str] scaling_group_id: ID of the scaling group of a eci scaling configuration.
        :param pulumi.Input[str] security_group_id: ID of the security group used to create new instance. It is conflict
               with `security_group_ids`.
        :param pulumi.Input[float] spot_price_limit: The maximum price hourly for spot instance.
        :param pulumi.Input[str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
               , `SpotWithPriceLimit`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
               be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
               a null string.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationVolumeArgs']]]] volumes: The list of volumes. See `volumes` below for details.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EciScalingConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESS eci scaling configuration resource.

        For information about ess eci scaling configuration, see [CreateEciScalingConfiguration](https://www.alibabacloud.com/help/en/auto-scaling/latest/create-eci-scaling-configuration).

        > **NOTE:** Available since v1.164.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default_zones.zones[0].id,
            vswitch_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_scaling_group = alicloud.ess.ScalingGroup("defaultScalingGroup",
            min_size=0,
            max_size=1,
            scaling_group_name=name,
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ],
            vswitch_ids=[default_switch.id],
            group_type="ECI")
        default_eci_scaling_configuration = alicloud.ess.EciScalingConfiguration("defaultEciScalingConfiguration",
            scaling_group_id=default_scaling_group.id,
            cpu=2,
            memory=4,
            security_group_id=default_security_group.id,
            force_delete=True,
            active=True,
            container_group_name="container-group-1649839595174",
            containers=[alicloud.ess.EciScalingConfigurationContainerArgs(
                name="container-1",
                image="registry-vpc.cn-hangzhou.aliyuncs.com/eci_open/alpine:3.5",
            )])
        ```

        ## Import

        ESS eci scaling configuration can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ess/eciScalingConfiguration:EciScalingConfiguration example asc-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param EciScalingConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EciScalingConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationAcrRegistryInfoArgs']]]]] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 auto_create_eip: Optional[pulumi.Input[bool]] = None,
                 container_group_name: Optional[pulumi.Input[str]] = None,
                 containers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationContainerArgs']]]]] = None,
                 cpu: Optional[pulumi.Input[float]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_policy: Optional[pulumi.Input[str]] = None,
                 egress_bandwidth: Optional[pulumi.Input[int]] = None,
                 eip_bandwidth: Optional[pulumi.Input[int]] = None,
                 enable_sls: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationHostAliasArgs']]]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationImageRegistryCredentialArgs']]]]] = None,
                 ingress_bandwidth: Optional[pulumi.Input[int]] = None,
                 init_containers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationInitContainerArgs']]]]] = None,
                 memory: Optional[pulumi.Input[float]] = None,
                 ram_role_name: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 restart_policy: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 spot_price_limit: Optional[pulumi.Input[float]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationVolumeArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EciScalingConfigurationArgs.__new__(EciScalingConfigurationArgs)

            __props__.__dict__["acr_registry_infos"] = acr_registry_infos
            __props__.__dict__["active"] = active
            __props__.__dict__["auto_create_eip"] = auto_create_eip
            __props__.__dict__["container_group_name"] = container_group_name
            __props__.__dict__["containers"] = containers
            __props__.__dict__["cpu"] = cpu
            __props__.__dict__["description"] = description
            __props__.__dict__["dns_policy"] = dns_policy
            __props__.__dict__["egress_bandwidth"] = egress_bandwidth
            __props__.__dict__["eip_bandwidth"] = eip_bandwidth
            __props__.__dict__["enable_sls"] = enable_sls
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["host_aliases"] = host_aliases
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["image_registry_credentials"] = image_registry_credentials
            __props__.__dict__["ingress_bandwidth"] = ingress_bandwidth
            __props__.__dict__["init_containers"] = init_containers
            __props__.__dict__["memory"] = memory
            __props__.__dict__["ram_role_name"] = ram_role_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["restart_policy"] = restart_policy
            __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["spot_price_limit"] = spot_price_limit
            __props__.__dict__["spot_strategy"] = spot_strategy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["volumes"] = volumes
        super(EciScalingConfiguration, __self__).__init__(
            'alicloud:ess/eciScalingConfiguration:EciScalingConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acr_registry_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationAcrRegistryInfoArgs']]]]] = None,
            active: Optional[pulumi.Input[bool]] = None,
            auto_create_eip: Optional[pulumi.Input[bool]] = None,
            container_group_name: Optional[pulumi.Input[str]] = None,
            containers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationContainerArgs']]]]] = None,
            cpu: Optional[pulumi.Input[float]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dns_policy: Optional[pulumi.Input[str]] = None,
            egress_bandwidth: Optional[pulumi.Input[int]] = None,
            eip_bandwidth: Optional[pulumi.Input[int]] = None,
            enable_sls: Optional[pulumi.Input[bool]] = None,
            force_delete: Optional[pulumi.Input[bool]] = None,
            host_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationHostAliasArgs']]]]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            image_registry_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationImageRegistryCredentialArgs']]]]] = None,
            ingress_bandwidth: Optional[pulumi.Input[int]] = None,
            init_containers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationInitContainerArgs']]]]] = None,
            memory: Optional[pulumi.Input[float]] = None,
            ram_role_name: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            restart_policy: Optional[pulumi.Input[str]] = None,
            scaling_configuration_name: Optional[pulumi.Input[str]] = None,
            scaling_group_id: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            spot_price_limit: Optional[pulumi.Input[float]] = None,
            spot_strategy: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationVolumeArgs']]]]] = None) -> 'EciScalingConfiguration':
        """
        Get an existing EciScalingConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationAcrRegistryInfoArgs']]]] acr_registry_infos: Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
        :param pulumi.Input[bool] active: Whether active current eci scaling configuration in the specified scaling group. Note that only
               one configuration can be active. Default to `false`.
        :param pulumi.Input[bool] auto_create_eip: Whether create eip automatically.
        :param pulumi.Input[str] container_group_name: The name of the container group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationContainerArgs']]]] containers: The list of containers. See `containers` below for details.
        :param pulumi.Input[float] cpu: The amount of CPU resources allocated to the container group.
        :param pulumi.Input[str] description: The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
               256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[str] dns_policy: dns policy of contain group.
        :param pulumi.Input[int] egress_bandwidth: egress bandwidth.
        :param pulumi.Input[int] eip_bandwidth: Eip bandwidth.
        :param pulumi.Input[bool] enable_sls: Enable sls log service.
        :param pulumi.Input[bool] force_delete: The eci scaling configuration will be deleted forcibly with deleting its scaling group.
               Default to false.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationHostAliasArgs']]]] host_aliases: HostAliases. See `host_aliases` below.
        :param pulumi.Input[str] host_name: Hostname of an ECI instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationImageRegistryCredentialArgs']]]] image_registry_credentials: The image registry credential.   See `image_registry_credentials` below for
               details.
        :param pulumi.Input[int] ingress_bandwidth: Ingress bandwidth.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationInitContainerArgs']]]] init_containers: The list of initContainers. See `init_containers` below for details.
        :param pulumi.Input[float] memory: The amount of memory resources allocated to the container group.
        :param pulumi.Input[str] ram_role_name: The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        :param pulumi.Input[str] resource_group_id: ID of resource group.
        :param pulumi.Input[str] restart_policy: The restart policy of the container group. Default to `Always`.
        :param pulumi.Input[str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (
               English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
               underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
               EciScalingConfigurationId.
        :param pulumi.Input[str] scaling_group_id: ID of the scaling group of a eci scaling configuration.
        :param pulumi.Input[str] security_group_id: ID of the security group used to create new instance. It is conflict
               with `security_group_ids`.
        :param pulumi.Input[float] spot_price_limit: The maximum price hourly for spot instance.
        :param pulumi.Input[str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
               , `SpotWithPriceLimit`.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
               be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
               a null string.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EciScalingConfigurationVolumeArgs']]]] volumes: The list of volumes. See `volumes` below for details.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EciScalingConfigurationState.__new__(_EciScalingConfigurationState)

        __props__.__dict__["acr_registry_infos"] = acr_registry_infos
        __props__.__dict__["active"] = active
        __props__.__dict__["auto_create_eip"] = auto_create_eip
        __props__.__dict__["container_group_name"] = container_group_name
        __props__.__dict__["containers"] = containers
        __props__.__dict__["cpu"] = cpu
        __props__.__dict__["description"] = description
        __props__.__dict__["dns_policy"] = dns_policy
        __props__.__dict__["egress_bandwidth"] = egress_bandwidth
        __props__.__dict__["eip_bandwidth"] = eip_bandwidth
        __props__.__dict__["enable_sls"] = enable_sls
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["host_aliases"] = host_aliases
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["image_registry_credentials"] = image_registry_credentials
        __props__.__dict__["ingress_bandwidth"] = ingress_bandwidth
        __props__.__dict__["init_containers"] = init_containers
        __props__.__dict__["memory"] = memory
        __props__.__dict__["ram_role_name"] = ram_role_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["restart_policy"] = restart_policy
        __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["spot_price_limit"] = spot_price_limit
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["tags"] = tags
        __props__.__dict__["volumes"] = volumes
        return EciScalingConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acrRegistryInfos")
    def acr_registry_infos(self) -> pulumi.Output[Optional[Sequence['outputs.EciScalingConfigurationAcrRegistryInfo']]]:
        """
        Information about the Container Registry Enterprise Edition instance. See `acr_registry_infos` below for details.
        """
        return pulumi.get(self, "acr_registry_infos")

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether active current eci scaling configuration in the specified scaling group. Note that only
        one configuration can be active. Default to `false`.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="autoCreateEip")
    def auto_create_eip(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether create eip automatically.
        """
        return pulumi.get(self, "auto_create_eip")

    @property
    @pulumi.getter(name="containerGroupName")
    def container_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the container group.
        """
        return pulumi.get(self, "container_group_name")

    @property
    @pulumi.getter
    def containers(self) -> pulumi.Output[Optional[Sequence['outputs.EciScalingConfigurationContainer']]]:
        """
        The list of containers. See `containers` below for details.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter
    def cpu(self) -> pulumi.Output[Optional[float]]:
        """
        The amount of CPU resources allocated to the container group.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to
        256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsPolicy")
    def dns_policy(self) -> pulumi.Output[Optional[str]]:
        """
        dns policy of contain group.
        """
        return pulumi.get(self, "dns_policy")

    @property
    @pulumi.getter(name="egressBandwidth")
    def egress_bandwidth(self) -> pulumi.Output[Optional[int]]:
        """
        egress bandwidth.
        """
        return pulumi.get(self, "egress_bandwidth")

    @property
    @pulumi.getter(name="eipBandwidth")
    def eip_bandwidth(self) -> pulumi.Output[Optional[int]]:
        """
        Eip bandwidth.
        """
        return pulumi.get(self, "eip_bandwidth")

    @property
    @pulumi.getter(name="enableSls")
    def enable_sls(self) -> pulumi.Output[Optional[bool]]:
        """
        Enable sls log service.
        """
        return pulumi.get(self, "enable_sls")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[bool]]:
        """
        The eci scaling configuration will be deleted forcibly with deleting its scaling group.
        Default to false.
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter(name="hostAliases")
    def host_aliases(self) -> pulumi.Output[Optional[Sequence['outputs.EciScalingConfigurationHostAlias']]]:
        """
        HostAliases. See `host_aliases` below.
        """
        return pulumi.get(self, "host_aliases")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[str]]:
        """
        Hostname of an ECI instance.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="imageRegistryCredentials")
    def image_registry_credentials(self) -> pulumi.Output[Optional[Sequence['outputs.EciScalingConfigurationImageRegistryCredential']]]:
        """
        The image registry credential.   See `image_registry_credentials` below for
        details.
        """
        return pulumi.get(self, "image_registry_credentials")

    @property
    @pulumi.getter(name="ingressBandwidth")
    def ingress_bandwidth(self) -> pulumi.Output[Optional[int]]:
        """
        Ingress bandwidth.
        """
        return pulumi.get(self, "ingress_bandwidth")

    @property
    @pulumi.getter(name="initContainers")
    def init_containers(self) -> pulumi.Output[Optional[Sequence['outputs.EciScalingConfigurationInitContainer']]]:
        """
        The list of initContainers. See `init_containers` below for details.
        """
        return pulumi.get(self, "init_containers")

    @property
    @pulumi.getter
    def memory(self) -> pulumi.Output[Optional[float]]:
        """
        The amount of memory resources allocated to the container group.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="ramRoleName")
    def ram_role_name(self) -> pulumi.Output[Optional[str]]:
        """
        The RAM role that the container group assumes. ECI and ECS share the same RAM role.
        """
        return pulumi.get(self, "ram_role_name")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> pulumi.Output[Optional[str]]:
        """
        The restart policy of the container group. Default to `Always`.
        """
        return pulumi.get(self, "restart_policy")

    @property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> pulumi.Output[str]:
        """
        Name shown for the scheduled task. which must contain 2-64 characters (
        English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number,
        underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is
        EciScalingConfigurationId.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[str]:
        """
        ID of the scaling group of a eci scaling configuration.
        """
        return pulumi.get(self, "scaling_group_id")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the security group used to create new instance. It is conflict
        with `security_group_ids`.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="spotPriceLimit")
    def spot_price_limit(self) -> pulumi.Output[Optional[float]]:
        """
        The maximum price hourly for spot instance.
        """
        return pulumi.get(self, "spot_price_limit")

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`
        , `SpotWithPriceLimit`.
        """
        return pulumi.get(self, "spot_strategy")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource. It will be applied for ECI instances finally.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot
        be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be
        a null string.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def volumes(self) -> pulumi.Output[Optional[Sequence['outputs.EciScalingConfigurationVolume']]]:
        """
        The list of volumes. See `volumes` below for details.
        """
        return pulumi.get(self, "volumes")

