# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'EciScalingConfigurationAcrRegistryInfo',
    'EciScalingConfigurationContainer',
    'EciScalingConfigurationContainerEnvironmentVar',
    'EciScalingConfigurationContainerPort',
    'EciScalingConfigurationContainerVolumeMount',
    'EciScalingConfigurationHostAlias',
    'EciScalingConfigurationImageRegistryCredential',
    'EciScalingConfigurationInitContainer',
    'EciScalingConfigurationInitContainerEnvironmentVar',
    'EciScalingConfigurationInitContainerPort',
    'EciScalingConfigurationInitContainerVolumeMount',
    'EciScalingConfigurationVolume',
    'EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPath',
    'ScalingConfigurationDataDisk',
    'ScalingConfigurationInstancePatternInfo',
    'ScalingConfigurationSpotPriceLimit',
    'ScalingGroupVServerGroupsVserverGroup',
    'ScalingGroupVServerGroupsVserverGroupVserverAttribute',
    'ScalingRuleStepAdjustment',
    'GetAlarmsAlarmResult',
    'GetLifecycleHooksHookResult',
    'GetNotificationsNotificationResult',
    'GetScalingConfigurationsConfigurationResult',
    'GetScalingConfigurationsConfigurationDataDiskResult',
    'GetScalingConfigurationsConfigurationSpotPriceLimitResult',
    'GetScalingGroupsGroupResult',
    'GetScalingRulesRuleResult',
    'GetScheduledTasksTaskResult',
]

@pulumi.output_type
class EciScalingConfigurationAcrRegistryInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "instanceName":
            suggest = "instance_name"
        elif key == "regionId":
            suggest = "region_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EciScalingConfigurationAcrRegistryInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EciScalingConfigurationAcrRegistryInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EciScalingConfigurationAcrRegistryInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domains: Optional[Sequence[str]] = None,
                 instance_id: Optional[str] = None,
                 instance_name: Optional[str] = None,
                 region_id: Optional[str] = None):
        """
        :param Sequence[str] domains: Endpoint of Container Registry Enterprise Edition instance. By default, all endpoints of the Container Registry Enterprise Edition instance are displayed. It is required
               when `acr_registry_info` is configured.
        :param str instance_id: The ID of Container Registry Enterprise Edition instance. It is required
               when `acr_registry_info` is configured.
        :param str instance_name: The name of Container Registry Enterprise Edition instance. It is required when `acr_registry_info` is
               configured.
        :param str region_id: The region ID of Container Registry Enterprise Edition instance. It is required
               when `acr_registry_info` is configured.
        """
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)

    @property
    @pulumi.getter
    def domains(self) -> Optional[Sequence[str]]:
        """
        Endpoint of Container Registry Enterprise Edition instance. By default, all endpoints of the Container Registry Enterprise Edition instance are displayed. It is required
        when `acr_registry_info` is configured.
        """
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The ID of Container Registry Enterprise Edition instance. It is required
        when `acr_registry_info` is configured.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[str]:
        """
        The name of Container Registry Enterprise Edition instance. It is required when `acr_registry_info` is
        configured.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[str]:
        """
        The region ID of Container Registry Enterprise Edition instance. It is required
        when `acr_registry_info` is configured.
        """
        return pulumi.get(self, "region_id")


@pulumi.output_type
class EciScalingConfigurationContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentVars":
            suggest = "environment_vars"
        elif key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "livenessProbeExecCommands":
            suggest = "liveness_probe_exec_commands"
        elif key == "livenessProbeFailureThreshold":
            suggest = "liveness_probe_failure_threshold"
        elif key == "livenessProbeHttpGetPath":
            suggest = "liveness_probe_http_get_path"
        elif key == "livenessProbeHttpGetPort":
            suggest = "liveness_probe_http_get_port"
        elif key == "livenessProbeHttpGetScheme":
            suggest = "liveness_probe_http_get_scheme"
        elif key == "livenessProbeInitialDelaySeconds":
            suggest = "liveness_probe_initial_delay_seconds"
        elif key == "livenessProbePeriodSeconds":
            suggest = "liveness_probe_period_seconds"
        elif key == "livenessProbeSuccessThreshold":
            suggest = "liveness_probe_success_threshold"
        elif key == "livenessProbeTcpSocketPort":
            suggest = "liveness_probe_tcp_socket_port"
        elif key == "livenessProbeTimeoutSeconds":
            suggest = "liveness_probe_timeout_seconds"
        elif key == "readinessProbeExecCommands":
            suggest = "readiness_probe_exec_commands"
        elif key == "readinessProbeFailureThreshold":
            suggest = "readiness_probe_failure_threshold"
        elif key == "readinessProbeHttpGetPath":
            suggest = "readiness_probe_http_get_path"
        elif key == "readinessProbeHttpGetPort":
            suggest = "readiness_probe_http_get_port"
        elif key == "readinessProbeHttpGetScheme":
            suggest = "readiness_probe_http_get_scheme"
        elif key == "readinessProbeInitialDelaySeconds":
            suggest = "readiness_probe_initial_delay_seconds"
        elif key == "readinessProbePeriodSeconds":
            suggest = "readiness_probe_period_seconds"
        elif key == "readinessProbeSuccessThreshold":
            suggest = "readiness_probe_success_threshold"
        elif key == "readinessProbeTcpSocketPort":
            suggest = "readiness_probe_tcp_socket_port"
        elif key == "readinessProbeTimeoutSeconds":
            suggest = "readiness_probe_timeout_seconds"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EciScalingConfigurationContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EciScalingConfigurationContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EciScalingConfigurationContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Optional[Sequence[str]] = None,
                 commands: Optional[Sequence[str]] = None,
                 cpu: Optional[float] = None,
                 environment_vars: Optional[Sequence['outputs.EciScalingConfigurationContainerEnvironmentVar']] = None,
                 gpu: Optional[int] = None,
                 image: Optional[str] = None,
                 image_pull_policy: Optional[str] = None,
                 liveness_probe_exec_commands: Optional[Sequence[str]] = None,
                 liveness_probe_failure_threshold: Optional[int] = None,
                 liveness_probe_http_get_path: Optional[str] = None,
                 liveness_probe_http_get_port: Optional[int] = None,
                 liveness_probe_http_get_scheme: Optional[str] = None,
                 liveness_probe_initial_delay_seconds: Optional[int] = None,
                 liveness_probe_period_seconds: Optional[int] = None,
                 liveness_probe_success_threshold: Optional[int] = None,
                 liveness_probe_tcp_socket_port: Optional[int] = None,
                 liveness_probe_timeout_seconds: Optional[int] = None,
                 memory: Optional[float] = None,
                 name: Optional[str] = None,
                 ports: Optional[Sequence['outputs.EciScalingConfigurationContainerPort']] = None,
                 readiness_probe_exec_commands: Optional[Sequence[str]] = None,
                 readiness_probe_failure_threshold: Optional[int] = None,
                 readiness_probe_http_get_path: Optional[str] = None,
                 readiness_probe_http_get_port: Optional[int] = None,
                 readiness_probe_http_get_scheme: Optional[str] = None,
                 readiness_probe_initial_delay_seconds: Optional[int] = None,
                 readiness_probe_period_seconds: Optional[int] = None,
                 readiness_probe_success_threshold: Optional[int] = None,
                 readiness_probe_tcp_socket_port: Optional[int] = None,
                 readiness_probe_timeout_seconds: Optional[int] = None,
                 volume_mounts: Optional[Sequence['outputs.EciScalingConfigurationContainerVolumeMount']] = None,
                 working_dir: Optional[str] = None):
        """
        :param Sequence[str] args: The arguments passed to the commands.
        :param Sequence[str] commands: The commands run by the init container.
        :param float cpu: The amount of CPU resources allocated to the container.
        :param Sequence['EciScalingConfigurationContainerEnvironmentVarArgs'] environment_vars: The structure of environmentVars.
               See `environment_vars` below for details.
        :param int gpu: The number GPUs.
        :param str image: The image of the container.
        :param str image_pull_policy: The restart policy of the image.
        :param Sequence[str] liveness_probe_exec_commands: Commands that you want to run in containers when you use the CLI to perform liveness probes.
        :param int liveness_probe_failure_threshold: The minimum number of consecutive failures for the liveness probe to be considered failed after having been successful. Default value: 3.
        :param str liveness_probe_http_get_path: The path to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
        :param int liveness_probe_http_get_port: The port to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
        :param str liveness_probe_http_get_scheme: The protocol type of HTTP GET requests when you use HTTP requests for liveness probes.Valid values:HTTP and HTTPS.
        :param int liveness_probe_initial_delay_seconds: The number of seconds after container has started before liveness probes are initiated.
        :param int liveness_probe_period_seconds: The interval at which the liveness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
        :param int liveness_probe_success_threshold: The minimum number of consecutive successes for the liveness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
        :param int liveness_probe_tcp_socket_port: The port detected by TCP sockets when you use TCP sockets to perform liveness probes.
        :param int liveness_probe_timeout_seconds: The timeout period for the liveness probe. Unit: seconds. Default value: 1. Minimum value: 1.
        :param float memory: The amount of memory resources allocated to the container.
        :param str name: The name of the mounted volume.
        :param Sequence['EciScalingConfigurationContainerPortArgs'] ports: The structure of port. See `ports` below for details.
        :param Sequence[str] readiness_probe_exec_commands: Commands that you want to run in containers when you use the CLI to perform readiness probes.
        :param int readiness_probe_failure_threshold: The minimum number of consecutive failures for the readiness probe to be considered failed after having been successful. Default value: 3.
        :param str readiness_probe_http_get_path: The path to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
        :param int readiness_probe_http_get_port: The port to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
        :param str readiness_probe_http_get_scheme: The protocol type of HTTP GET requests when you use HTTP requests for readiness probes. Valid values: HTTP and HTTPS.
        :param int readiness_probe_initial_delay_seconds: The number of seconds after container N has started before readiness probes are initiated.
        :param int readiness_probe_period_seconds: The interval at which the readiness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
        :param int readiness_probe_success_threshold: The minimum number of consecutive successes for the readiness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
        :param int readiness_probe_tcp_socket_port: The port detected by Transmission Control Protocol (TCP) sockets when you use TCP sockets to perform readiness probes.
        :param int readiness_probe_timeout_seconds: The timeout period for the readiness probe. Unit: seconds. Default value: 1. Minimum value: 1.
        :param Sequence['EciScalingConfigurationContainerVolumeMountArgs'] volume_mounts: The structure of volumeMounts. 
               See `volume_mounts` below for details.
        :param str working_dir: The working directory of the container.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if environment_vars is not None:
            pulumi.set(__self__, "environment_vars", environment_vars)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if liveness_probe_exec_commands is not None:
            pulumi.set(__self__, "liveness_probe_exec_commands", liveness_probe_exec_commands)
        if liveness_probe_failure_threshold is not None:
            pulumi.set(__self__, "liveness_probe_failure_threshold", liveness_probe_failure_threshold)
        if liveness_probe_http_get_path is not None:
            pulumi.set(__self__, "liveness_probe_http_get_path", liveness_probe_http_get_path)
        if liveness_probe_http_get_port is not None:
            pulumi.set(__self__, "liveness_probe_http_get_port", liveness_probe_http_get_port)
        if liveness_probe_http_get_scheme is not None:
            pulumi.set(__self__, "liveness_probe_http_get_scheme", liveness_probe_http_get_scheme)
        if liveness_probe_initial_delay_seconds is not None:
            pulumi.set(__self__, "liveness_probe_initial_delay_seconds", liveness_probe_initial_delay_seconds)
        if liveness_probe_period_seconds is not None:
            pulumi.set(__self__, "liveness_probe_period_seconds", liveness_probe_period_seconds)
        if liveness_probe_success_threshold is not None:
            pulumi.set(__self__, "liveness_probe_success_threshold", liveness_probe_success_threshold)
        if liveness_probe_tcp_socket_port is not None:
            pulumi.set(__self__, "liveness_probe_tcp_socket_port", liveness_probe_tcp_socket_port)
        if liveness_probe_timeout_seconds is not None:
            pulumi.set(__self__, "liveness_probe_timeout_seconds", liveness_probe_timeout_seconds)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if readiness_probe_exec_commands is not None:
            pulumi.set(__self__, "readiness_probe_exec_commands", readiness_probe_exec_commands)
        if readiness_probe_failure_threshold is not None:
            pulumi.set(__self__, "readiness_probe_failure_threshold", readiness_probe_failure_threshold)
        if readiness_probe_http_get_path is not None:
            pulumi.set(__self__, "readiness_probe_http_get_path", readiness_probe_http_get_path)
        if readiness_probe_http_get_port is not None:
            pulumi.set(__self__, "readiness_probe_http_get_port", readiness_probe_http_get_port)
        if readiness_probe_http_get_scheme is not None:
            pulumi.set(__self__, "readiness_probe_http_get_scheme", readiness_probe_http_get_scheme)
        if readiness_probe_initial_delay_seconds is not None:
            pulumi.set(__self__, "readiness_probe_initial_delay_seconds", readiness_probe_initial_delay_seconds)
        if readiness_probe_period_seconds is not None:
            pulumi.set(__self__, "readiness_probe_period_seconds", readiness_probe_period_seconds)
        if readiness_probe_success_threshold is not None:
            pulumi.set(__self__, "readiness_probe_success_threshold", readiness_probe_success_threshold)
        if readiness_probe_tcp_socket_port is not None:
            pulumi.set(__self__, "readiness_probe_tcp_socket_port", readiness_probe_tcp_socket_port)
        if readiness_probe_timeout_seconds is not None:
            pulumi.set(__self__, "readiness_probe_timeout_seconds", readiness_probe_timeout_seconds)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        The arguments passed to the commands.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        The commands run by the init container.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def cpu(self) -> Optional[float]:
        """
        The amount of CPU resources allocated to the container.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Optional[Sequence['outputs.EciScalingConfigurationContainerEnvironmentVar']]:
        """
        The structure of environmentVars.
        See `environment_vars` below for details.
        """
        return pulumi.get(self, "environment_vars")

    @property
    @pulumi.getter
    def gpu(self) -> Optional[int]:
        """
        The number GPUs.
        """
        return pulumi.get(self, "gpu")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        The image of the container.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[str]:
        """
        The restart policy of the image.
        """
        return pulumi.get(self, "image_pull_policy")

    @property
    @pulumi.getter(name="livenessProbeExecCommands")
    def liveness_probe_exec_commands(self) -> Optional[Sequence[str]]:
        """
        Commands that you want to run in containers when you use the CLI to perform liveness probes.
        """
        return pulumi.get(self, "liveness_probe_exec_commands")

    @property
    @pulumi.getter(name="livenessProbeFailureThreshold")
    def liveness_probe_failure_threshold(self) -> Optional[int]:
        """
        The minimum number of consecutive failures for the liveness probe to be considered failed after having been successful. Default value: 3.
        """
        return pulumi.get(self, "liveness_probe_failure_threshold")

    @property
    @pulumi.getter(name="livenessProbeHttpGetPath")
    def liveness_probe_http_get_path(self) -> Optional[str]:
        """
        The path to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
        """
        return pulumi.get(self, "liveness_probe_http_get_path")

    @property
    @pulumi.getter(name="livenessProbeHttpGetPort")
    def liveness_probe_http_get_port(self) -> Optional[int]:
        """
        The port to which HTTP GET requests are sent when you use HTTP requests to perform liveness probes.
        """
        return pulumi.get(self, "liveness_probe_http_get_port")

    @property
    @pulumi.getter(name="livenessProbeHttpGetScheme")
    def liveness_probe_http_get_scheme(self) -> Optional[str]:
        """
        The protocol type of HTTP GET requests when you use HTTP requests for liveness probes.Valid values:HTTP and HTTPS.
        """
        return pulumi.get(self, "liveness_probe_http_get_scheme")

    @property
    @pulumi.getter(name="livenessProbeInitialDelaySeconds")
    def liveness_probe_initial_delay_seconds(self) -> Optional[int]:
        """
        The number of seconds after container has started before liveness probes are initiated.
        """
        return pulumi.get(self, "liveness_probe_initial_delay_seconds")

    @property
    @pulumi.getter(name="livenessProbePeriodSeconds")
    def liveness_probe_period_seconds(self) -> Optional[int]:
        """
        The interval at which the liveness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
        """
        return pulumi.get(self, "liveness_probe_period_seconds")

    @property
    @pulumi.getter(name="livenessProbeSuccessThreshold")
    def liveness_probe_success_threshold(self) -> Optional[int]:
        """
        The minimum number of consecutive successes for the liveness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
        """
        return pulumi.get(self, "liveness_probe_success_threshold")

    @property
    @pulumi.getter(name="livenessProbeTcpSocketPort")
    def liveness_probe_tcp_socket_port(self) -> Optional[int]:
        """
        The port detected by TCP sockets when you use TCP sockets to perform liveness probes.
        """
        return pulumi.get(self, "liveness_probe_tcp_socket_port")

    @property
    @pulumi.getter(name="livenessProbeTimeoutSeconds")
    def liveness_probe_timeout_seconds(self) -> Optional[int]:
        """
        The timeout period for the liveness probe. Unit: seconds. Default value: 1. Minimum value: 1.
        """
        return pulumi.get(self, "liveness_probe_timeout_seconds")

    @property
    @pulumi.getter
    def memory(self) -> Optional[float]:
        """
        The amount of memory resources allocated to the container.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.EciScalingConfigurationContainerPort']]:
        """
        The structure of port. See `ports` below for details.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="readinessProbeExecCommands")
    def readiness_probe_exec_commands(self) -> Optional[Sequence[str]]:
        """
        Commands that you want to run in containers when you use the CLI to perform readiness probes.
        """
        return pulumi.get(self, "readiness_probe_exec_commands")

    @property
    @pulumi.getter(name="readinessProbeFailureThreshold")
    def readiness_probe_failure_threshold(self) -> Optional[int]:
        """
        The minimum number of consecutive failures for the readiness probe to be considered failed after having been successful. Default value: 3.
        """
        return pulumi.get(self, "readiness_probe_failure_threshold")

    @property
    @pulumi.getter(name="readinessProbeHttpGetPath")
    def readiness_probe_http_get_path(self) -> Optional[str]:
        """
        The path to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
        """
        return pulumi.get(self, "readiness_probe_http_get_path")

    @property
    @pulumi.getter(name="readinessProbeHttpGetPort")
    def readiness_probe_http_get_port(self) -> Optional[int]:
        """
        The port to which HTTP GET requests are sent when you use HTTP requests to perform readiness probes.
        """
        return pulumi.get(self, "readiness_probe_http_get_port")

    @property
    @pulumi.getter(name="readinessProbeHttpGetScheme")
    def readiness_probe_http_get_scheme(self) -> Optional[str]:
        """
        The protocol type of HTTP GET requests when you use HTTP requests for readiness probes. Valid values: HTTP and HTTPS.
        """
        return pulumi.get(self, "readiness_probe_http_get_scheme")

    @property
    @pulumi.getter(name="readinessProbeInitialDelaySeconds")
    def readiness_probe_initial_delay_seconds(self) -> Optional[int]:
        """
        The number of seconds after container N has started before readiness probes are initiated.
        """
        return pulumi.get(self, "readiness_probe_initial_delay_seconds")

    @property
    @pulumi.getter(name="readinessProbePeriodSeconds")
    def readiness_probe_period_seconds(self) -> Optional[int]:
        """
        The interval at which the readiness probe is performed. Unit: seconds. Default value: 10. Minimum value: 1.
        """
        return pulumi.get(self, "readiness_probe_period_seconds")

    @property
    @pulumi.getter(name="readinessProbeSuccessThreshold")
    def readiness_probe_success_threshold(self) -> Optional[int]:
        """
        The minimum number of consecutive successes for the readiness probe to be considered successful after having failed. Default value: 1. Set the value to 1.
        """
        return pulumi.get(self, "readiness_probe_success_threshold")

    @property
    @pulumi.getter(name="readinessProbeTcpSocketPort")
    def readiness_probe_tcp_socket_port(self) -> Optional[int]:
        """
        The port detected by Transmission Control Protocol (TCP) sockets when you use TCP sockets to perform readiness probes.
        """
        return pulumi.get(self, "readiness_probe_tcp_socket_port")

    @property
    @pulumi.getter(name="readinessProbeTimeoutSeconds")
    def readiness_probe_timeout_seconds(self) -> Optional[int]:
        """
        The timeout period for the readiness probe. Unit: seconds. Default value: 1. Minimum value: 1.
        """
        return pulumi.get(self, "readiness_probe_timeout_seconds")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.EciScalingConfigurationContainerVolumeMount']]:
        """
        The structure of volumeMounts. 
        See `volume_mounts` below for details.
        """
        return pulumi.get(self, "volume_mounts")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[str]:
        """
        The working directory of the container.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class EciScalingConfigurationContainerEnvironmentVar(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The name of the variable. The name can be 1 to 128 characters in length and can contain letters,
               digits, and underscores (_). It cannot start with a digit.
        :param str value: The value of the variable. The value can be 0 to 256 characters in length.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the variable. The name can be 1 to 128 characters in length and can contain letters,
        digits, and underscores (_). It cannot start with a digit.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the variable. The value can be 0 to 256 characters in length.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EciScalingConfigurationContainerPort(dict):
    def __init__(__self__, *,
                 port: Optional[int] = None,
                 protocol: Optional[str] = None):
        """
        :param int port: The port number. Valid values: 1 to 65535.
        :param str protocol: Valid values: TCP and UDP.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number. Valid values: 1 to 65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Valid values: TCP and UDP.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class EciScalingConfigurationContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EciScalingConfigurationContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EciScalingConfigurationContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EciScalingConfigurationContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: Optional[str] = None,
                 name: Optional[str] = None,
                 read_only: Optional[bool] = None):
        """
        :param str mount_path: The directory of the mounted volume. Data under this directory will be overwritten by the
               data in the volume.
        :param str name: The name of the mounted volume.
        :param bool read_only: Default to `false`.
        """
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[str]:
        """
        The directory of the mounted volume. Data under this directory will be overwritten by the
        data in the volume.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        """
        Default to `false`.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class EciScalingConfigurationHostAlias(dict):
    def __init__(__self__, *,
                 hostnames: Optional[Sequence[str]] = None,
                 ip: Optional[str] = None):
        """
        :param Sequence[str] hostnames: Adds a host name.
        :param str ip: Adds an IP address.
        """
        if hostnames is not None:
            pulumi.set(__self__, "hostnames", hostnames)
        if ip is not None:
            pulumi.set(__self__, "ip", ip)

    @property
    @pulumi.getter
    def hostnames(self) -> Optional[Sequence[str]]:
        """
        Adds a host name.
        """
        return pulumi.get(self, "hostnames")

    @property
    @pulumi.getter
    def ip(self) -> Optional[str]:
        """
        Adds an IP address.
        """
        return pulumi.get(self, "ip")


@pulumi.output_type
class EciScalingConfigurationImageRegistryCredential(dict):
    def __init__(__self__, *,
                 password: Optional[str] = None,
                 server: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str password: The password used to log on to the image repository. It is required
               when `image_registry_credential` is configured.
        :param str server: The address of the image repository. It is required when `image_registry_credential` is
               configured.
        :param str username: The username used to log on to the image repository. It is required
               when `image_registry_credential` is configured.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password used to log on to the image repository. It is required
        when `image_registry_credential` is configured.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def server(self) -> Optional[str]:
        """
        The address of the image repository. It is required when `image_registry_credential` is
        configured.
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username used to log on to the image repository. It is required
        when `image_registry_credential` is configured.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class EciScalingConfigurationInitContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "environmentVars":
            suggest = "environment_vars"
        elif key == "imagePullPolicy":
            suggest = "image_pull_policy"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDir":
            suggest = "working_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EciScalingConfigurationInitContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EciScalingConfigurationInitContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EciScalingConfigurationInitContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Optional[Sequence[str]] = None,
                 commands: Optional[Sequence[str]] = None,
                 cpu: Optional[float] = None,
                 environment_vars: Optional[Sequence['outputs.EciScalingConfigurationInitContainerEnvironmentVar']] = None,
                 gpu: Optional[int] = None,
                 image: Optional[str] = None,
                 image_pull_policy: Optional[str] = None,
                 memory: Optional[float] = None,
                 name: Optional[str] = None,
                 ports: Optional[Sequence['outputs.EciScalingConfigurationInitContainerPort']] = None,
                 volume_mounts: Optional[Sequence['outputs.EciScalingConfigurationInitContainerVolumeMount']] = None,
                 working_dir: Optional[str] = None):
        """
        :param Sequence[str] args: The arguments passed to the commands.
        :param Sequence[str] commands: The commands run by the init container.
        :param float cpu: The amount of CPU resources allocated to the container.
        :param Sequence['EciScalingConfigurationInitContainerEnvironmentVarArgs'] environment_vars: The structure of environmentVars. 
               See `environment_vars` below for details.
        :param int gpu: The number GPUs.
        :param str image: The image of the container.
        :param str image_pull_policy: The restart policy of the image.
        :param float memory: The amount of memory resources allocated to the container.
        :param str name: The name of the mounted volume.
        :param Sequence['EciScalingConfigurationInitContainerPortArgs'] ports: The structure of port. See `ports` below for details.
        :param Sequence['EciScalingConfigurationInitContainerVolumeMountArgs'] volume_mounts: The structure of volumeMounts. See `volume_mounts` below for details.
        :param str working_dir: The working directory of the container.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if environment_vars is not None:
            pulumi.set(__self__, "environment_vars", environment_vars)
        if gpu is not None:
            pulumi.set(__self__, "gpu", gpu)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if image_pull_policy is not None:
            pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if volume_mounts is not None:
            pulumi.set(__self__, "volume_mounts", volume_mounts)
        if working_dir is not None:
            pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        The arguments passed to the commands.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        The commands run by the init container.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter
    def cpu(self) -> Optional[float]:
        """
        The amount of CPU resources allocated to the container.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="environmentVars")
    def environment_vars(self) -> Optional[Sequence['outputs.EciScalingConfigurationInitContainerEnvironmentVar']]:
        """
        The structure of environmentVars. 
        See `environment_vars` below for details.
        """
        return pulumi.get(self, "environment_vars")

    @property
    @pulumi.getter
    def gpu(self) -> Optional[int]:
        """
        The number GPUs.
        """
        return pulumi.get(self, "gpu")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        The image of the container.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> Optional[str]:
        """
        The restart policy of the image.
        """
        return pulumi.get(self, "image_pull_policy")

    @property
    @pulumi.getter
    def memory(self) -> Optional[float]:
        """
        The amount of memory resources allocated to the container.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Optional[Sequence['outputs.EciScalingConfigurationInitContainerPort']]:
        """
        The structure of port. See `ports` below for details.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.EciScalingConfigurationInitContainerVolumeMount']]:
        """
        The structure of volumeMounts. See `volume_mounts` below for details.
        """
        return pulumi.get(self, "volume_mounts")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> Optional[str]:
        """
        The working directory of the container.
        """
        return pulumi.get(self, "working_dir")


@pulumi.output_type
class EciScalingConfigurationInitContainerEnvironmentVar(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The name of the variable. The name can be 1 to 128 characters in length and can contain letters,
               digits, and underscores (_). It cannot start with a digit.
        :param str value: The value of the variable. The value can be 0 to 256 characters in length.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the variable. The name can be 1 to 128 characters in length and can contain letters,
        digits, and underscores (_). It cannot start with a digit.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the variable. The value can be 0 to 256 characters in length.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class EciScalingConfigurationInitContainerPort(dict):
    def __init__(__self__, *,
                 port: Optional[int] = None,
                 protocol: Optional[str] = None):
        """
        :param int port: The port number. Valid values: 1 to 65535.
        :param str protocol: Valid values: TCP and UDP.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        The port number. Valid values: 1 to 65535.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        Valid values: TCP and UDP.
        """
        return pulumi.get(self, "protocol")


@pulumi.output_type
class EciScalingConfigurationInitContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "readOnly":
            suggest = "read_only"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EciScalingConfigurationInitContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EciScalingConfigurationInitContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EciScalingConfigurationInitContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: Optional[str] = None,
                 name: Optional[str] = None,
                 read_only: Optional[bool] = None):
        """
        :param str mount_path: The directory of the mounted volume. Data under this directory will be overwritten by the
               data in the volume.
        :param str name: The name of the mounted volume.
        :param bool read_only: Default to `false`.
        """
        if mount_path is not None:
            pulumi.set(__self__, "mount_path", mount_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> Optional[str]:
        """
        The directory of the mounted volume. Data under this directory will be overwritten by the
        data in the volume.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the mounted volume.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[bool]:
        """
        Default to `false`.
        """
        return pulumi.get(self, "read_only")


@pulumi.output_type
class EciScalingConfigurationVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configFileVolumeConfigFileToPaths":
            suggest = "config_file_volume_config_file_to_paths"
        elif key == "diskVolumeDiskId":
            suggest = "disk_volume_disk_id"
        elif key == "diskVolumeDiskSize":
            suggest = "disk_volume_disk_size"
        elif key == "diskVolumeFsType":
            suggest = "disk_volume_fs_type"
        elif key == "flexVolumeDriver":
            suggest = "flex_volume_driver"
        elif key == "flexVolumeFsType":
            suggest = "flex_volume_fs_type"
        elif key == "flexVolumeOptions":
            suggest = "flex_volume_options"
        elif key == "nfsVolumePath":
            suggest = "nfs_volume_path"
        elif key == "nfsVolumeReadOnly":
            suggest = "nfs_volume_read_only"
        elif key == "nfsVolumeServer":
            suggest = "nfs_volume_server"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EciScalingConfigurationVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EciScalingConfigurationVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EciScalingConfigurationVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config_file_volume_config_file_to_paths: Optional[Sequence['outputs.EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPath']] = None,
                 disk_volume_disk_id: Optional[str] = None,
                 disk_volume_disk_size: Optional[int] = None,
                 disk_volume_fs_type: Optional[str] = None,
                 flex_volume_driver: Optional[str] = None,
                 flex_volume_fs_type: Optional[str] = None,
                 flex_volume_options: Optional[str] = None,
                 name: Optional[str] = None,
                 nfs_volume_path: Optional[str] = None,
                 nfs_volume_read_only: Optional[bool] = None,
                 nfs_volume_server: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param Sequence['EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPathArgs'] config_file_volume_config_file_to_paths: ConfigFileVolumeConfigFileToPaths.
               See `config_file_volume_config_file_to_paths` below for details.
        :param str disk_volume_disk_id: The ID of DiskVolume.
        :param int disk_volume_disk_size: The disk size of DiskVolume.
        :param str disk_volume_fs_type: The system type of DiskVolume.
        :param str flex_volume_driver: The name of the FlexVolume driver.
        :param str flex_volume_fs_type: The type of the mounted file system. The default value is determined by the script
               of FlexVolume.
        :param str flex_volume_options: The list of FlexVolume objects. Each object is a key-value pair contained in a JSON
               string.
        :param str name: The name of the volume.
        :param str nfs_volume_path: The path to the NFS volume.
        :param bool nfs_volume_read_only: The nfs volume read only. Default to `false`.
        :param str nfs_volume_server: The address of the NFS server.
               
               > **NOTE:** Every volume mounted must have a name and type attributes.
        :param str type: The type of the volume.
        """
        if config_file_volume_config_file_to_paths is not None:
            pulumi.set(__self__, "config_file_volume_config_file_to_paths", config_file_volume_config_file_to_paths)
        if disk_volume_disk_id is not None:
            pulumi.set(__self__, "disk_volume_disk_id", disk_volume_disk_id)
        if disk_volume_disk_size is not None:
            pulumi.set(__self__, "disk_volume_disk_size", disk_volume_disk_size)
        if disk_volume_fs_type is not None:
            pulumi.set(__self__, "disk_volume_fs_type", disk_volume_fs_type)
        if flex_volume_driver is not None:
            pulumi.set(__self__, "flex_volume_driver", flex_volume_driver)
        if flex_volume_fs_type is not None:
            pulumi.set(__self__, "flex_volume_fs_type", flex_volume_fs_type)
        if flex_volume_options is not None:
            pulumi.set(__self__, "flex_volume_options", flex_volume_options)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_volume_path is not None:
            pulumi.set(__self__, "nfs_volume_path", nfs_volume_path)
        if nfs_volume_read_only is not None:
            pulumi.set(__self__, "nfs_volume_read_only", nfs_volume_read_only)
        if nfs_volume_server is not None:
            pulumi.set(__self__, "nfs_volume_server", nfs_volume_server)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="configFileVolumeConfigFileToPaths")
    def config_file_volume_config_file_to_paths(self) -> Optional[Sequence['outputs.EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPath']]:
        """
        ConfigFileVolumeConfigFileToPaths.
        See `config_file_volume_config_file_to_paths` below for details.
        """
        return pulumi.get(self, "config_file_volume_config_file_to_paths")

    @property
    @pulumi.getter(name="diskVolumeDiskId")
    def disk_volume_disk_id(self) -> Optional[str]:
        """
        The ID of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_disk_id")

    @property
    @pulumi.getter(name="diskVolumeDiskSize")
    def disk_volume_disk_size(self) -> Optional[int]:
        """
        The disk size of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_disk_size")

    @property
    @pulumi.getter(name="diskVolumeFsType")
    def disk_volume_fs_type(self) -> Optional[str]:
        """
        The system type of DiskVolume.
        """
        return pulumi.get(self, "disk_volume_fs_type")

    @property
    @pulumi.getter(name="flexVolumeDriver")
    def flex_volume_driver(self) -> Optional[str]:
        """
        The name of the FlexVolume driver.
        """
        return pulumi.get(self, "flex_volume_driver")

    @property
    @pulumi.getter(name="flexVolumeFsType")
    def flex_volume_fs_type(self) -> Optional[str]:
        """
        The type of the mounted file system. The default value is determined by the script
        of FlexVolume.
        """
        return pulumi.get(self, "flex_volume_fs_type")

    @property
    @pulumi.getter(name="flexVolumeOptions")
    def flex_volume_options(self) -> Optional[str]:
        """
        The list of FlexVolume objects. Each object is a key-value pair contained in a JSON
        string.
        """
        return pulumi.get(self, "flex_volume_options")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the volume.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nfsVolumePath")
    def nfs_volume_path(self) -> Optional[str]:
        """
        The path to the NFS volume.
        """
        return pulumi.get(self, "nfs_volume_path")

    @property
    @pulumi.getter(name="nfsVolumeReadOnly")
    def nfs_volume_read_only(self) -> Optional[bool]:
        """
        The nfs volume read only. Default to `false`.
        """
        return pulumi.get(self, "nfs_volume_read_only")

    @property
    @pulumi.getter(name="nfsVolumeServer")
    def nfs_volume_server(self) -> Optional[str]:
        """
        The address of the NFS server.

        > **NOTE:** Every volume mounted must have a name and type attributes.
        """
        return pulumi.get(self, "nfs_volume_server")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the volume.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EciScalingConfigurationVolumeConfigFileVolumeConfigFileToPath(dict):
    def __init__(__self__, *,
                 content: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str content: The content of the configuration file. Maximum size: 32 KB.
        :param str path: The relative file path.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        The content of the configuration file. Maximum size: 32 KB.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The relative file path.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class ScalingConfigurationDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoSnapshotPolicyId":
            suggest = "auto_snapshot_policy_id"
        elif key == "deleteWithInstance":
            suggest = "delete_with_instance"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "performanceLevel":
            suggest = "performance_level"
        elif key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingConfigurationDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingConfigurationDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingConfigurationDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_snapshot_policy_id: Optional[str] = None,
                 category: Optional[str] = None,
                 delete_with_instance: Optional[bool] = None,
                 description: Optional[str] = None,
                 device: Optional[str] = None,
                 encrypted: Optional[bool] = None,
                 kms_key_id: Optional[str] = None,
                 name: Optional[str] = None,
                 performance_level: Optional[str] = None,
                 size: Optional[int] = None,
                 snapshot_id: Optional[str] = None):
        """
        :param str auto_snapshot_policy_id: The id of auto snapshot policy for data disk.
        :param str category: Category of data disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd` and `cloud`.
        :param bool delete_with_instance: Whether to delete data disks attached on ecs when release ecs instance. Optional value: `true` or `false`, default to `true`.
        :param str description: The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param str device: The mount point of data disk N. Valid values of N: 1 to 16. If this parameter is not specified, the system automatically allocates a mount point to created ECS instances. The name of the mount point ranges from /dev/xvdb to /dev/xvdz in alphabetical order.
        :param bool encrypted: Specifies whether data disk N is to be encrypted. Valid values of N: 1 to 16. Valid values: `true`: encrypted, `false`: not encrypted. Default value: `false`.
        :param str kms_key_id: The CMK ID for data disk N. Valid values of N: 1 to 16.
        :param str name: The name of data disk N. Valid values of N: 1 to 16. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        :param str performance_level: The performance level of the ESSD used as data disk.
        :param int size: Size of data disk, in GB. The value ranges [5,2000] for a cloud disk, [5,1024] for an ephemeral disk, [5,800] for an ephemeral_ssd disk, [20,32768] for cloud_efficiency, cloud_ssd, cloud_essd disk.
        :param str snapshot_id: Snapshot used for creating the data disk. If this parameter is specified, the size parameter is neglected, and the size of the created disk is the size of the snapshot.
        """
        if auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "auto_snapshot_policy_id", auto_snapshot_policy_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if delete_with_instance is not None:
            pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device is not None:
            pulumi.set(__self__, "device", device)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_level is not None:
            pulumi.set(__self__, "performance_level", performance_level)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter(name="autoSnapshotPolicyId")
    def auto_snapshot_policy_id(self) -> Optional[str]:
        """
        The id of auto snapshot policy for data disk.
        """
        return pulumi.get(self, "auto_snapshot_policy_id")

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        """
        Category of data disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd` and `cloud`.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> Optional[bool]:
        """
        Whether to delete data disks attached on ecs when release ecs instance. Optional value: `true` or `false`, default to `true`.
        """
        return pulumi.get(self, "delete_with_instance")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of data disk N. Valid values of N: 1 to 16. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def device(self) -> Optional[str]:
        """
        The mount point of data disk N. Valid values of N: 1 to 16. If this parameter is not specified, the system automatically allocates a mount point to created ECS instances. The name of the mount point ranges from /dev/xvdb to /dev/xvdz in alphabetical order.
        """
        warnings.warn("""Attribute device has been deprecated on disk attachment resource. Suggest to remove it from your template.""", DeprecationWarning)
        pulumi.log.warn("""device is deprecated: Attribute device has been deprecated on disk attachment resource. Suggest to remove it from your template.""")

        return pulumi.get(self, "device")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Specifies whether data disk N is to be encrypted. Valid values of N: 1 to 16. Valid values: `true`: encrypted, `false`: not encrypted. Default value: `false`.
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The CMK ID for data disk N. Valid values of N: 1 to 16.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of data disk N. Valid values of N: 1 to 16. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> Optional[str]:
        """
        The performance level of the ESSD used as data disk.
        """
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        Size of data disk, in GB. The value ranges [5,2000] for a cloud disk, [5,1024] for an ephemeral disk, [5,800] for an ephemeral_ssd disk, [20,32768] for cloud_efficiency, cloud_ssd, cloud_essd disk.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        Snapshot used for creating the data disk. If this parameter is specified, the size parameter is neglected, and the size of the created disk is the size of the snapshot.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class ScalingConfigurationInstancePatternInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceFamilyLevel":
            suggest = "instance_family_level"
        elif key == "maxPrice":
            suggest = "max_price"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingConfigurationInstancePatternInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingConfigurationInstancePatternInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingConfigurationInstancePatternInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cores: Optional[int] = None,
                 instance_family_level: Optional[str] = None,
                 max_price: Optional[float] = None,
                 memory: Optional[float] = None):
        """
        :param int cores: The number of vCPUs that are specified for an instance type in instancePatternInfo.
        :param str instance_family_level: The instance family level in instancePatternInfo.
        :param float max_price: The maximum hourly price for a pay-as-you-go instance or a preemptible instance in instancePatternInfo.
        :param float memory: The memory size that is specified for an instance type in instancePatternInfo.
        """
        if cores is not None:
            pulumi.set(__self__, "cores", cores)
        if instance_family_level is not None:
            pulumi.set(__self__, "instance_family_level", instance_family_level)
        if max_price is not None:
            pulumi.set(__self__, "max_price", max_price)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)

    @property
    @pulumi.getter
    def cores(self) -> Optional[int]:
        """
        The number of vCPUs that are specified for an instance type in instancePatternInfo.
        """
        return pulumi.get(self, "cores")

    @property
    @pulumi.getter(name="instanceFamilyLevel")
    def instance_family_level(self) -> Optional[str]:
        """
        The instance family level in instancePatternInfo.
        """
        return pulumi.get(self, "instance_family_level")

    @property
    @pulumi.getter(name="maxPrice")
    def max_price(self) -> Optional[float]:
        """
        The maximum hourly price for a pay-as-you-go instance or a preemptible instance in instancePatternInfo.
        """
        return pulumi.get(self, "max_price")

    @property
    @pulumi.getter
    def memory(self) -> Optional[float]:
        """
        The memory size that is specified for an instance type in instancePatternInfo.
        """
        return pulumi.get(self, "memory")


@pulumi.output_type
class ScalingConfigurationSpotPriceLimit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "priceLimit":
            suggest = "price_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingConfigurationSpotPriceLimit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingConfigurationSpotPriceLimit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingConfigurationSpotPriceLimit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[str] = None,
                 price_limit: Optional[float] = None):
        """
        :param str instance_type: Resource type of an ECS instance.
        :param float price_limit: Price limit hourly of instance type, 2 decimals is allowed at most.
        """
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if price_limit is not None:
            pulumi.set(__self__, "price_limit", price_limit)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        """
        Resource type of an ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="priceLimit")
    def price_limit(self) -> Optional[float]:
        """
        Price limit hourly of instance type, 2 decimals is allowed at most.
        """
        return pulumi.get(self, "price_limit")


@pulumi.output_type
class ScalingGroupVServerGroupsVserverGroup(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "loadbalancerId":
            suggest = "loadbalancer_id"
        elif key == "vserverAttributes":
            suggest = "vserver_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingGroupVServerGroupsVserverGroup. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingGroupVServerGroupsVserverGroup.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingGroupVServerGroupsVserverGroup.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 loadbalancer_id: str,
                 vserver_attributes: Sequence['outputs.ScalingGroupVServerGroupsVserverGroupVserverAttribute']):
        """
        :param str loadbalancer_id: Loadbalancer server ID of VServer Group.
        :param Sequence['ScalingGroupVServerGroupsVserverGroupVserverAttributeArgs'] vserver_attributes: A list of VServer Group attributes. See `vserver_attributes` below.
        """
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        pulumi.set(__self__, "vserver_attributes", vserver_attributes)

    @property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> str:
        """
        Loadbalancer server ID of VServer Group.
        """
        return pulumi.get(self, "loadbalancer_id")

    @property
    @pulumi.getter(name="vserverAttributes")
    def vserver_attributes(self) -> Sequence['outputs.ScalingGroupVServerGroupsVserverGroupVserverAttribute']:
        """
        A list of VServer Group attributes. See `vserver_attributes` below.
        """
        return pulumi.get(self, "vserver_attributes")


@pulumi.output_type
class ScalingGroupVServerGroupsVserverGroupVserverAttribute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vserverGroupId":
            suggest = "vserver_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingGroupVServerGroupsVserverGroupVserverAttribute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingGroupVServerGroupsVserverGroupVserverAttribute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingGroupVServerGroupsVserverGroupVserverAttribute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 vserver_group_id: str,
                 weight: int):
        """
        :param int port: The port will be used for VServer Group backend server.
        :param str vserver_group_id: ID of VServer Group.
        :param int weight: The weight of an ECS instance attached to the VServer Group.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "vserver_group_id", vserver_group_id)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port will be used for VServer Group backend server.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="vserverGroupId")
    def vserver_group_id(self) -> str:
        """
        ID of VServer Group.
        """
        return pulumi.get(self, "vserver_group_id")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The weight of an ECS instance attached to the VServer Group.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class ScalingRuleStepAdjustment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricIntervalLowerBound":
            suggest = "metric_interval_lower_bound"
        elif key == "metricIntervalUpperBound":
            suggest = "metric_interval_upper_bound"
        elif key == "scalingAdjustment":
            suggest = "scaling_adjustment"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingRuleStepAdjustment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingRuleStepAdjustment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingRuleStepAdjustment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_interval_lower_bound: Optional[str] = None,
                 metric_interval_upper_bound: Optional[str] = None,
                 scaling_adjustment: Optional[int] = None):
        """
        :param str metric_interval_lower_bound: The lower bound of step.
        :param str metric_interval_upper_bound: The upper bound of step.
        :param int scaling_adjustment: The adjust value of step.
        """
        if metric_interval_lower_bound is not None:
            pulumi.set(__self__, "metric_interval_lower_bound", metric_interval_lower_bound)
        if metric_interval_upper_bound is not None:
            pulumi.set(__self__, "metric_interval_upper_bound", metric_interval_upper_bound)
        if scaling_adjustment is not None:
            pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)

    @property
    @pulumi.getter(name="metricIntervalLowerBound")
    def metric_interval_lower_bound(self) -> Optional[str]:
        """
        The lower bound of step.
        """
        return pulumi.get(self, "metric_interval_lower_bound")

    @property
    @pulumi.getter(name="metricIntervalUpperBound")
    def metric_interval_upper_bound(self) -> Optional[str]:
        """
        The upper bound of step.
        """
        return pulumi.get(self, "metric_interval_upper_bound")

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> Optional[int]:
        """
        The adjust value of step.
        """
        return pulumi.get(self, "scaling_adjustment")


@pulumi.output_type
class GetAlarmsAlarmResult(dict):
    def __init__(__self__, *,
                 alarm_actions: Sequence[str],
                 cloud_monitor_group_id: int,
                 comparison_operator: str,
                 description: str,
                 dimensions: Mapping[str, Any],
                 enable: bool,
                 evaluation_count: int,
                 id: str,
                 metric_name: str,
                 metric_type: str,
                 name: str,
                 period: int,
                 scaling_group_id: str,
                 state: str,
                 statistics: str,
                 threshold: str):
        """
        :param Sequence[str] alarm_actions: The list of actions to execute when this alarm transition into an ALARM state. Each action is specified as ess scaling rule ari.
        :param int cloud_monitor_group_id: Defines the application group id defined by CMS which is assigned when you upload custom metric to CMS, only available for custom metirc.
        :param str comparison_operator: The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand.
        :param str description: The description for the alarm.
        :param Mapping[str, Any] dimensions: The dimension map for the alarm's associated metric.
        :param bool enable: Whether to enable specific ess alarm.
        :param int evaluation_count: The number of times that needs to satisfies comparison condition before transition into ALARM state.
        :param str id: The id of alarm.
        :param str metric_name: The name for the alarm's associated metric.
        :param str metric_type: The type for the alarm's associated metric. Supported value: system, custom. "system" means the metric data is collected by Aliyun Cloud Monitor Service(CMS), "custom" means the metric data is upload to CMS by users. Defaults to system.
        :param str name: The name for ess alarm.
        :param int period: The period in seconds over which the specified statistic is applied.
        :param str scaling_group_id: Scaling group id the alarms belong to.
        :param str state: The state of alarm task.
        :param str statistics: The statistic to apply to the alarm's associated metric.
        :param str threshold: The value against which the specified statistics is compared.
        """
        pulumi.set(__self__, "alarm_actions", alarm_actions)
        pulumi.set(__self__, "cloud_monitor_group_id", cloud_monitor_group_id)
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "enable", enable)
        pulumi.set(__self__, "evaluation_count", evaluation_count)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "metric_type", metric_type)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "statistics", statistics)
        pulumi.set(__self__, "threshold", threshold)

    @property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Sequence[str]:
        """
        The list of actions to execute when this alarm transition into an ALARM state. Each action is specified as ess scaling rule ari.
        """
        return pulumi.get(self, "alarm_actions")

    @property
    @pulumi.getter(name="cloudMonitorGroupId")
    def cloud_monitor_group_id(self) -> int:
        """
        Defines the application group id defined by CMS which is assigned when you upload custom metric to CMS, only available for custom metirc.
        """
        return pulumi.get(self, "cloud_monitor_group_id")

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> str:
        """
        The arithmetic operation to use when comparing the specified Statistic and Threshold. The specified Statistic value is used as the first operand.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description for the alarm.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dimensions(self) -> Mapping[str, Any]:
        """
        The dimension map for the alarm's associated metric.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def enable(self) -> bool:
        """
        Whether to enable specific ess alarm.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="evaluationCount")
    def evaluation_count(self) -> int:
        """
        The number of times that needs to satisfies comparison condition before transition into ALARM state.
        """
        return pulumi.get(self, "evaluation_count")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of alarm.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        """
        The name for the alarm's associated metric.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter(name="metricType")
    def metric_type(self) -> str:
        """
        The type for the alarm's associated metric. Supported value: system, custom. "system" means the metric data is collected by Aliyun Cloud Monitor Service(CMS), "custom" means the metric data is upload to CMS by users. Defaults to system.
        """
        return pulumi.get(self, "metric_type")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name for ess alarm.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def period(self) -> int:
        """
        The period in seconds over which the specified statistic is applied.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> str:
        """
        Scaling group id the alarms belong to.
        """
        return pulumi.get(self, "scaling_group_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of alarm task.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def statistics(self) -> str:
        """
        The statistic to apply to the alarm's associated metric.
        """
        return pulumi.get(self, "statistics")

    @property
    @pulumi.getter
    def threshold(self) -> str:
        """
        The value against which the specified statistics is compared.
        """
        return pulumi.get(self, "threshold")


@pulumi.output_type
class GetLifecycleHooksHookResult(dict):
    def __init__(__self__, *,
                 default_result: str,
                 heartbeat_timeout: int,
                 id: str,
                 lifecycle_transition: str,
                 name: str,
                 notification_arn: str,
                 notification_metadata: str,
                 scaling_group_id: str):
        """
        :param str default_result: Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses.
        :param int heartbeat_timeout: Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the default_result parameter.
        :param str id: ID of the lifecycle hook.
        :param str lifecycle_transition: Type of Scaling activity attached to lifecycle hook.
        :param str name: Name of the lifecycle hook.
        :param str notification_arn: The Arn of notification target.
        :param str notification_metadata: Additional information that you want to include when Auto Scaling sends a message to the notification target.
        :param str scaling_group_id: Scaling group id the lifecycle hooks belong to.
        """
        pulumi.set(__self__, "default_result", default_result)
        pulumi.set(__self__, "heartbeat_timeout", heartbeat_timeout)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_transition", lifecycle_transition)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "notification_arn", notification_arn)
        pulumi.set(__self__, "notification_metadata", notification_metadata)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)

    @property
    @pulumi.getter(name="defaultResult")
    def default_result(self) -> str:
        """
        Defines the action the Auto Scaling group should take when the lifecycle hook timeout elapses.
        """
        return pulumi.get(self, "default_result")

    @property
    @pulumi.getter(name="heartbeatTimeout")
    def heartbeat_timeout(self) -> int:
        """
        Defines the amount of time, in seconds, that can elapse before the lifecycle hook times out. When the lifecycle hook times out, Auto Scaling performs the action defined in the default_result parameter.
        """
        return pulumi.get(self, "heartbeat_timeout")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the lifecycle hook.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleTransition")
    def lifecycle_transition(self) -> str:
        """
        Type of Scaling activity attached to lifecycle hook.
        """
        return pulumi.get(self, "lifecycle_transition")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the lifecycle hook.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationArn")
    def notification_arn(self) -> str:
        """
        The Arn of notification target.
        """
        return pulumi.get(self, "notification_arn")

    @property
    @pulumi.getter(name="notificationMetadata")
    def notification_metadata(self) -> str:
        """
        Additional information that you want to include when Auto Scaling sends a message to the notification target.
        """
        return pulumi.get(self, "notification_metadata")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> str:
        """
        Scaling group id the lifecycle hooks belong to.
        """
        return pulumi.get(self, "scaling_group_id")


@pulumi.output_type
class GetNotificationsNotificationResult(dict):
    def __init__(__self__, *,
                 id: str,
                 notification_arn: str,
                 notification_types: Sequence[str],
                 scaling_group_id: str):
        """
        :param str id: ID of the notification.
        :param str notification_arn: The Alibaba Cloud Resource Name (ARN) for the notification object.
        :param Sequence[str] notification_types: The notification types of Auto Scaling events and resource changes.
        :param str scaling_group_id: Scaling group id the notifications belong to.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "notification_arn", notification_arn)
        pulumi.set(__self__, "notification_types", notification_types)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the notification.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="notificationArn")
    def notification_arn(self) -> str:
        """
        The Alibaba Cloud Resource Name (ARN) for the notification object.
        """
        return pulumi.get(self, "notification_arn")

    @property
    @pulumi.getter(name="notificationTypes")
    def notification_types(self) -> Sequence[str]:
        """
        The notification types of Auto Scaling events and resource changes.
        """
        return pulumi.get(self, "notification_types")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> str:
        """
        Scaling group id the notifications belong to.
        """
        return pulumi.get(self, "scaling_group_id")


@pulumi.output_type
class GetScalingConfigurationsConfigurationResult(dict):
    def __init__(__self__, *,
                 creation_time: str,
                 credit_specification: str,
                 data_disks: Sequence['outputs.GetScalingConfigurationsConfigurationDataDiskResult'],
                 host_name: str,
                 id: str,
                 image_id: str,
                 instance_name: str,
                 instance_type: str,
                 internet_charge_type: str,
                 internet_max_bandwidth_in: int,
                 internet_max_bandwidth_out: int,
                 lifecycle_state: str,
                 name: str,
                 scaling_group_id: str,
                 security_group_id: str,
                 spot_price_limits: Sequence['outputs.GetScalingConfigurationsConfigurationSpotPriceLimitResult'],
                 spot_strategy: str,
                 system_disk_category: str,
                 system_disk_performance_level: str,
                 system_disk_size: int):
        """
        :param str creation_time: Creation time of the scaling configuration.
        :param str credit_specification: Performance mode of the t5 burstable instance.
        :param Sequence['GetScalingConfigurationsConfigurationDataDiskArgs'] data_disks: Data disks of the scaling configuration.
        :param str host_name: (Optional,Available in 1.143.0+) Hostname of an ECS instance.
        :param str id: ID of the scaling rule.
        :param str image_id: Image ID of the scaling configuration.
        :param str instance_name: (Optional,Available in 1.143.0+) InstanceName of an ECS instance.
        :param str instance_type: Resource type of an ECS instance.
        :param str internet_charge_type: Internet charge type of the scaling configuration.
        :param int internet_max_bandwidth_in: Internet max bandwidth in of the scaling configuration.
        :param int internet_max_bandwidth_out: Internet max bandwidth of the scaling configuration.
        :param str lifecycle_state: Lifecycle state of the scaling configuration.
        :param str name: Name of the scaling configuration.
        :param str scaling_group_id: Scaling group id the scaling configurations belong to.
        :param str security_group_id: Security group ID of the scaling configuration.
        :param Sequence['GetScalingConfigurationsConfigurationSpotPriceLimitArgs'] spot_price_limits: (Optional, Available in 1.151.0+) The maximum price hourly for instance types.
        :param str spot_strategy: (Optional, Available in 1.151.0+) The spot strategy for a Pay-As-You-Go instance.
        :param str system_disk_category: System disk category of the scaling configuration.
        :param str system_disk_performance_level: The performance level of the ESSD used as the system disk.
        :param int system_disk_size: System disk size of the scaling configuration.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "credit_specification", credit_specification)
        pulumi.set(__self__, "data_disks", data_disks)
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        pulumi.set(__self__, "internet_max_bandwidth_in", internet_max_bandwidth_in)
        pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "spot_price_limits", spot_price_limits)
        pulumi.set(__self__, "spot_strategy", spot_strategy)
        pulumi.set(__self__, "system_disk_category", system_disk_category)
        pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        pulumi.set(__self__, "system_disk_size", system_disk_size)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Creation time of the scaling configuration.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> str:
        """
        Performance mode of the t5 burstable instance.
        """
        return pulumi.get(self, "credit_specification")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Sequence['outputs.GetScalingConfigurationsConfigurationDataDiskResult']:
        """
        Data disks of the scaling configuration.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        (Optional,Available in 1.143.0+) Hostname of an ECS instance.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the scaling rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        Image ID of the scaling configuration.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        (Optional,Available in 1.143.0+) InstanceName of an ECS instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Resource type of an ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> str:
        """
        Internet charge type of the scaling configuration.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> int:
        """
        Internet max bandwidth in of the scaling configuration.
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> int:
        """
        Internet max bandwidth of the scaling configuration.
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> str:
        """
        Lifecycle state of the scaling configuration.
        """
        return pulumi.get(self, "lifecycle_state")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the scaling configuration.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> str:
        """
        Scaling group id the scaling configurations belong to.
        """
        return pulumi.get(self, "scaling_group_id")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        Security group ID of the scaling configuration.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> Sequence['outputs.GetScalingConfigurationsConfigurationSpotPriceLimitResult']:
        """
        (Optional, Available in 1.151.0+) The maximum price hourly for instance types.
        """
        return pulumi.get(self, "spot_price_limits")

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> str:
        """
        (Optional, Available in 1.151.0+) The spot strategy for a Pay-As-You-Go instance.
        """
        return pulumi.get(self, "spot_strategy")

    @property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> str:
        """
        System disk category of the scaling configuration.
        """
        return pulumi.get(self, "system_disk_category")

    @property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> str:
        """
        The performance level of the ESSD used as the system disk.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> int:
        """
        System disk size of the scaling configuration.
        """
        return pulumi.get(self, "system_disk_size")


@pulumi.output_type
class GetScalingConfigurationsConfigurationDataDiskResult(dict):
    def __init__(__self__, *,
                 category: str,
                 delete_with_instance: bool,
                 device: str,
                 performance_level: str,
                 size: int,
                 snapshot_id: str):
        """
        :param str category: Category of data disk.
        :param bool delete_with_instance: Delete_with_instance attribute of data disk.
        :param str device: Device attribute of data disk.
        :param str performance_level: The performance level of the ESSD used as data disk.
        :param int size: Size of data disk.
        :param str snapshot_id: Size of data disk.
        """
        pulumi.set(__self__, "category", category)
        pulumi.set(__self__, "delete_with_instance", delete_with_instance)
        pulumi.set(__self__, "device", device)
        pulumi.set(__self__, "performance_level", performance_level)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "snapshot_id", snapshot_id)

    @property
    @pulumi.getter
    def category(self) -> str:
        """
        Category of data disk.
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="deleteWithInstance")
    def delete_with_instance(self) -> bool:
        """
        Delete_with_instance attribute of data disk.
        """
        return pulumi.get(self, "delete_with_instance")

    @property
    @pulumi.getter
    def device(self) -> str:
        """
        Device attribute of data disk.
        """
        return pulumi.get(self, "device")

    @property
    @pulumi.getter(name="performanceLevel")
    def performance_level(self) -> str:
        """
        The performance level of the ESSD used as data disk.
        """
        return pulumi.get(self, "performance_level")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Size of data disk.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> str:
        """
        Size of data disk.
        """
        return pulumi.get(self, "snapshot_id")


@pulumi.output_type
class GetScalingConfigurationsConfigurationSpotPriceLimitResult(dict):
    def __init__(__self__, *,
                 instance_type: str,
                 price_limit: float):
        """
        :param str instance_type: Resource type of an ECS instance.
        :param float price_limit: Price limit hourly of instance type.
        """
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "price_limit", price_limit)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        Resource type of an ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="priceLimit")
    def price_limit(self) -> float:
        """
        Price limit hourly of instance type.
        """
        return pulumi.get(self, "price_limit")


@pulumi.output_type
class GetScalingGroupsGroupResult(dict):
    def __init__(__self__, *,
                 active_capacity: int,
                 active_scaling_configuration: str,
                 cooldown_time: int,
                 creation_time: str,
                 db_instance_ids: Sequence[str],
                 group_deletion_protection: bool,
                 health_check_type: str,
                 id: str,
                 launch_template_id: str,
                 launch_template_version: str,
                 lifecycle_state: str,
                 load_balancer_ids: Sequence[str],
                 max_size: int,
                 min_size: int,
                 modification_time: str,
                 name: str,
                 pending_capacity: int,
                 region_id: str,
                 removal_policies: Sequence[str],
                 removing_capacity: int,
                 suspended_processes: Sequence[str],
                 total_capacity: int,
                 total_instance_count: int,
                 vpc_id: str,
                 vswitch_id: str,
                 vswitch_ids: Sequence[str],
                 tags: Optional[Mapping[str, Any]] = None):
        """
        :param int active_capacity: Number of active instances in scaling group.
        :param str active_scaling_configuration: Active scaling configuration for scaling group.
        :param int cooldown_time: Default cooldown time of scaling group.
        :param str creation_time: Creation time of scaling group.
        :param Sequence[str] db_instance_ids: Db instances id which the ECS instance attached to.
        :param bool group_deletion_protection: Whether the scaling group deletion protection is enabled.
        :param str health_check_type: The health check method of the scaling group.
        :param str id: ID of the scaling group.
        :param str launch_template_id: Active launch template ID for scaling group.
        :param str launch_template_version: Version of active launch template.
        :param str lifecycle_state: Lifecycle state of scaling group.
        :param Sequence[str] load_balancer_ids: Slb instances id which the ECS instance attached to.
        :param int max_size: The maximum number of ECS instances.
        :param int min_size: The minimum number of ECS instances.
        :param str modification_time: The modification time.
        :param str name: Name of the scaling group.
        :param int pending_capacity: Number of pending instances in scaling group.
        :param str region_id: Region ID the scaling group belongs to.
        :param Sequence[str] removal_policies: Removal policy used to select the ECS instance to remove from the scaling group.
        :param int removing_capacity: Number of removing instances in scaling group.
        :param Sequence[str] suspended_processes: The Process in suspension.
        :param int total_capacity: Number of instances in scaling group.
        :param int total_instance_count: The number of all ECS instances in the scaling group.
        :param str vpc_id: The ID of the VPC to which the scaling group belongs.
        :param str vswitch_id: The ID of the vSwitch to which the scaling group belongs.
        :param Sequence[str] vswitch_ids: Vswitches id in which the ECS instance launched.
        :param Mapping[str, Any] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "active_capacity", active_capacity)
        pulumi.set(__self__, "active_scaling_configuration", active_scaling_configuration)
        pulumi.set(__self__, "cooldown_time", cooldown_time)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "db_instance_ids", db_instance_ids)
        pulumi.set(__self__, "group_deletion_protection", group_deletion_protection)
        pulumi.set(__self__, "health_check_type", health_check_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "launch_template_id", launch_template_id)
        pulumi.set(__self__, "launch_template_version", launch_template_version)
        pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        pulumi.set(__self__, "load_balancer_ids", load_balancer_ids)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "modification_time", modification_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pending_capacity", pending_capacity)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "removal_policies", removal_policies)
        pulumi.set(__self__, "removing_capacity", removing_capacity)
        pulumi.set(__self__, "suspended_processes", suspended_processes)
        pulumi.set(__self__, "total_capacity", total_capacity)
        pulumi.set(__self__, "total_instance_count", total_instance_count)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="activeCapacity")
    def active_capacity(self) -> int:
        """
        Number of active instances in scaling group.
        """
        return pulumi.get(self, "active_capacity")

    @property
    @pulumi.getter(name="activeScalingConfiguration")
    def active_scaling_configuration(self) -> str:
        """
        Active scaling configuration for scaling group.
        """
        return pulumi.get(self, "active_scaling_configuration")

    @property
    @pulumi.getter(name="cooldownTime")
    def cooldown_time(self) -> int:
        """
        Default cooldown time of scaling group.
        """
        return pulumi.get(self, "cooldown_time")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Creation time of scaling group.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="dbInstanceIds")
    def db_instance_ids(self) -> Sequence[str]:
        """
        Db instances id which the ECS instance attached to.
        """
        return pulumi.get(self, "db_instance_ids")

    @property
    @pulumi.getter(name="groupDeletionProtection")
    def group_deletion_protection(self) -> bool:
        """
        Whether the scaling group deletion protection is enabled.
        """
        return pulumi.get(self, "group_deletion_protection")

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> str:
        """
        The health check method of the scaling group.
        """
        return pulumi.get(self, "health_check_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the scaling group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> str:
        """
        Active launch template ID for scaling group.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> str:
        """
        Version of active launch template.
        """
        return pulumi.get(self, "launch_template_version")

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> str:
        """
        Lifecycle state of scaling group.
        """
        return pulumi.get(self, "lifecycle_state")

    @property
    @pulumi.getter(name="loadBalancerIds")
    def load_balancer_ids(self) -> Sequence[str]:
        """
        Slb instances id which the ECS instance attached to.
        """
        return pulumi.get(self, "load_balancer_ids")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> int:
        """
        The maximum number of ECS instances.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> int:
        """
        The minimum number of ECS instances.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="modificationTime")
    def modification_time(self) -> str:
        """
        The modification time.
        """
        return pulumi.get(self, "modification_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the scaling group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pendingCapacity")
    def pending_capacity(self) -> int:
        """
        Number of pending instances in scaling group.
        """
        return pulumi.get(self, "pending_capacity")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        Region ID the scaling group belongs to.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="removalPolicies")
    def removal_policies(self) -> Sequence[str]:
        """
        Removal policy used to select the ECS instance to remove from the scaling group.
        """
        return pulumi.get(self, "removal_policies")

    @property
    @pulumi.getter(name="removingCapacity")
    def removing_capacity(self) -> int:
        """
        Number of removing instances in scaling group.
        """
        return pulumi.get(self, "removing_capacity")

    @property
    @pulumi.getter(name="suspendedProcesses")
    def suspended_processes(self) -> Sequence[str]:
        """
        The Process in suspension.
        """
        return pulumi.get(self, "suspended_processes")

    @property
    @pulumi.getter(name="totalCapacity")
    def total_capacity(self) -> int:
        """
        Number of instances in scaling group.
        """
        return pulumi.get(self, "total_capacity")

    @property
    @pulumi.getter(name="totalInstanceCount")
    def total_instance_count(self) -> int:
        """
        The number of all ECS instances in the scaling group.
        """
        return pulumi.get(self, "total_instance_count")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The ID of the VPC to which the scaling group belongs.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> str:
        """
        The ID of the vSwitch to which the scaling group belongs.
        """
        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[str]:
        """
        Vswitches id in which the ECS instance launched.
        """
        return pulumi.get(self, "vswitch_ids")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, Any]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetScalingRulesRuleResult(dict):
    def __init__(__self__, *,
                 adjustment_type: str,
                 adjustment_value: int,
                 cooldown: int,
                 id: str,
                 min_adjustment_magnitude: int,
                 name: str,
                 scaling_group_id: str,
                 scaling_rule_ari: str,
                 type: str):
        """
        :param str adjustment_type: Adjustment type of the scaling rule.
        :param int adjustment_value: Adjustment value of the scaling rule.
        :param int cooldown: Cooldown time of the scaling rule.
        :param str id: ID of the scaling rule.
        :param int min_adjustment_magnitude: Min adjustment magnitude of scaling rule.
        :param str name: Name of the scaling rule.
        :param str scaling_group_id: Scaling group id the scaling rules belong to.
        :param str scaling_rule_ari: Ari of scaling rule.
        :param str type: Type of scaling rule.
        """
        pulumi.set(__self__, "adjustment_type", adjustment_type)
        pulumi.set(__self__, "adjustment_value", adjustment_value)
        pulumi.set(__self__, "cooldown", cooldown)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "min_adjustment_magnitude", min_adjustment_magnitude)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        pulumi.set(__self__, "scaling_rule_ari", scaling_rule_ari)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="adjustmentType")
    def adjustment_type(self) -> str:
        """
        Adjustment type of the scaling rule.
        """
        return pulumi.get(self, "adjustment_type")

    @property
    @pulumi.getter(name="adjustmentValue")
    def adjustment_value(self) -> int:
        """
        Adjustment value of the scaling rule.
        """
        return pulumi.get(self, "adjustment_value")

    @property
    @pulumi.getter
    def cooldown(self) -> int:
        """
        Cooldown time of the scaling rule.
        """
        return pulumi.get(self, "cooldown")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the scaling rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="minAdjustmentMagnitude")
    def min_adjustment_magnitude(self) -> int:
        """
        Min adjustment magnitude of scaling rule.
        """
        return pulumi.get(self, "min_adjustment_magnitude")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the scaling rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> str:
        """
        Scaling group id the scaling rules belong to.
        """
        return pulumi.get(self, "scaling_group_id")

    @property
    @pulumi.getter(name="scalingRuleAri")
    def scaling_rule_ari(self) -> str:
        """
        Ari of scaling rule.
        """
        return pulumi.get(self, "scaling_rule_ari")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of scaling rule.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetScheduledTasksTaskResult(dict):
    def __init__(__self__, *,
                 description: str,
                 id: str,
                 launch_expiration_time: int,
                 launch_time: str,
                 max_value: int,
                 min_value: int,
                 name: str,
                 recurrence_end_time: str,
                 recurrence_type: str,
                 recurrence_value: str,
                 scheduled_action: str,
                 task_enabled: bool):
        """
        :param str description: Description of the scheduled task.
        :param str id: ID of the scheduled task id.
        :param int launch_expiration_time: The time period during which a failed scheduled task is retried.
        :param str launch_time: The time at which the scheduled task is triggered.
        :param str name: Name of the scheduled task name.
        :param str recurrence_end_time: Specifies the end time after which the scheduled task is no longer repeated.
        :param str recurrence_type: Specifies the recurrence type of the scheduled task.
        :param str recurrence_value: Specifies how often a scheduled task recurs.
        :param str scheduled_action: The operation to be performed when a scheduled task is triggered.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "launch_expiration_time", launch_expiration_time)
        pulumi.set(__self__, "launch_time", launch_time)
        pulumi.set(__self__, "max_value", max_value)
        pulumi.set(__self__, "min_value", min_value)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "recurrence_end_time", recurrence_end_time)
        pulumi.set(__self__, "recurrence_type", recurrence_type)
        pulumi.set(__self__, "recurrence_value", recurrence_value)
        pulumi.set(__self__, "scheduled_action", scheduled_action)
        pulumi.set(__self__, "task_enabled", task_enabled)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the scheduled task.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the scheduled task id.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="launchExpirationTime")
    def launch_expiration_time(self) -> int:
        """
        The time period during which a failed scheduled task is retried.
        """
        return pulumi.get(self, "launch_expiration_time")

    @property
    @pulumi.getter(name="launchTime")
    def launch_time(self) -> str:
        """
        The time at which the scheduled task is triggered.
        """
        return pulumi.get(self, "launch_time")

    @property
    @pulumi.getter(name="maxValue")
    def max_value(self) -> int:
        return pulumi.get(self, "max_value")

    @property
    @pulumi.getter(name="minValue")
    def min_value(self) -> int:
        return pulumi.get(self, "min_value")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the scheduled task name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="recurrenceEndTime")
    def recurrence_end_time(self) -> str:
        """
        Specifies the end time after which the scheduled task is no longer repeated.
        """
        return pulumi.get(self, "recurrence_end_time")

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> str:
        """
        Specifies the recurrence type of the scheduled task.
        """
        return pulumi.get(self, "recurrence_type")

    @property
    @pulumi.getter(name="recurrenceValue")
    def recurrence_value(self) -> str:
        """
        Specifies how often a scheduled task recurs.
        """
        return pulumi.get(self, "recurrence_value")

    @property
    @pulumi.getter(name="scheduledAction")
    def scheduled_action(self) -> str:
        """
        The operation to be performed when a scheduled task is triggered.
        """
        return pulumi.get(self, "scheduled_action")

    @property
    @pulumi.getter(name="taskEnabled")
    def task_enabled(self) -> bool:
        return pulumi.get(self, "task_enabled")


