# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScalingConfigurationArgs', 'ScalingConfiguration']

@pulumi.input_type
class ScalingConfigurationArgs:
    def __init__(__self__, *,
                 scaling_group_id: pulumi.Input[str],
                 active: Optional[pulumi.Input[bool]] = None,
                 credit_specification: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_pattern_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 io_optimized: Optional[pulumi.Input[str]] = None,
                 is_outdated: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 override: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 substitute: Optional[pulumi.Input[str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_description: Optional[pulumi.Input[str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[bool]] = None,
                 system_disk_name: Optional[pulumi.Input[str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ScalingConfiguration resource.
        :param pulumi.Input[str] scaling_group_id: ID of the scaling group of a scaling configuration.
        :param pulumi.Input[bool] active: Whether active current scaling configuration in the specified scaling group. Default to `false`.
        :param pulumi.Input[str] credit_specification: Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]] data_disks: DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
        :param pulumi.Input[bool] enable: Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
        :param pulumi.Input[bool] force_delete: The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
        :param pulumi.Input[str] host_name: Hostname of an ECS instance.
        :param pulumi.Input[str] image_id: ID of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[str] image_name: Name of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_ids: It has been deprecated from version 1.6.0. New resource `ess.Attachment` replaces it.
        :param pulumi.Input[str] instance_name: Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]] instance_pattern_infos: intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
        :param pulumi.Input[str] instance_type: Resource type of an ECS instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: Resource types of an ECS instance.
        :param pulumi.Input[str] internet_charge_type: Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
        :param pulumi.Input[int] internet_max_bandwidth_in: Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). The value range is [1,200].
        :param pulumi.Input[int] internet_max_bandwidth_out: Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
        :param pulumi.Input[str] io_optimized: It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
        :param pulumi.Input[bool] is_outdated: Whether to use outdated instance type. Default to false.
        :param pulumi.Input[str] key_name: The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[bool] override: Indicates whether to overwrite the existing data. Default to false.
        :param pulumi.Input[str] password: The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
        :param pulumi.Input[bool] password_inherit: Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
        :param pulumi.Input[str] resource_group_id: ID of resource group.
        :param pulumi.Input[str] role_name: Instance RAM role name. The name is provided and maintained by RAM. You can use `ram.Role` to create a new one.
        :param pulumi.Input[str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
        :param pulumi.Input[str] security_group_id: ID of the security group used to create new instance. It is conflict with `security_group_ids`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]] spot_price_limits: Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
               
               > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
               
               > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
               
               > **NOTE:** Restrictions on attaching ECS instances:
               
               - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
               - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
               - The attached ECS instances must in the running state.
               - The attached ECS instances has not been attached to other scaling groups.
               - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
               
               > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
        :param pulumi.Input[str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
        :param pulumi.Input[str] substitute: The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
        :param pulumi.Input[str] system_disk_auto_snapshot_policy_id: The id of auto snapshot policy for system disk.
        :param pulumi.Input[str] system_disk_category: Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
        :param pulumi.Input[str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[bool] system_disk_encrypted: Whether to encrypt the system disk.
        :param pulumi.Input[str] system_disk_name: The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        :param pulumi.Input[str] system_disk_performance_level: The performance level of the ESSD used as the system disk.
        :param pulumi.Input[int] system_disk_size: Size of system disk, in GiB. Optional values: cloud: 20-500, cloud_efficiency: 20-500, cloud_ssd: 20-500, ephemeral_ssd: 20-500 The default value is max{40, ImageSize}. If this parameter is set, the system disk size must be greater than or equal to max{40, ImageSize}.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
        :param pulumi.Input[str] user_data: User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
        """
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if instance_ids is not None:
            warnings.warn("""Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""instance_ids is deprecated: Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""")
        if instance_ids is not None:
            pulumi.set(__self__, "instance_ids", instance_ids)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_pattern_infos is not None:
            pulumi.set(__self__, "instance_pattern_infos", instance_pattern_infos)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_in is not None:
            pulumi.set(__self__, "internet_max_bandwidth_in", internet_max_bandwidth_in)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if io_optimized is not None:
            warnings.warn("""Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""", DeprecationWarning)
            pulumi.log.warn("""io_optimized is deprecated: Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""")
        if io_optimized is not None:
            pulumi.set(__self__, "io_optimized", io_optimized)
        if is_outdated is not None:
            pulumi.set(__self__, "is_outdated", is_outdated)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if override is not None:
            pulumi.set(__self__, "override", override)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if scaling_configuration_name is not None:
            pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_price_limits is not None:
            pulumi.set(__self__, "spot_price_limits", spot_price_limits)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if substitute is not None:
            pulumi.set(__self__, "substitute", substitute)
        if system_disk_auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "system_disk_auto_snapshot_policy_id", system_disk_auto_snapshot_policy_id)
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_description is not None:
            pulumi.set(__self__, "system_disk_description", system_disk_description)
        if system_disk_encrypted is not None:
            pulumi.set(__self__, "system_disk_encrypted", system_disk_encrypted)
        if system_disk_name is not None:
            pulumi.set(__self__, "system_disk_name", system_disk_name)
        if system_disk_performance_level is not None:
            pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[str]:
        """
        ID of the scaling group of a scaling configuration.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_group_id", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether active current scaling configuration in the specified scaling group. Default to `false`.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input[str]]:
        """
        Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credit_specification", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]]]:
        """
        DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of an ECS instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of an image file, indicating the image resource selected when an instance is enabled.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of an image file, indicating the image resource selected when an instance is enabled.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        It has been deprecated from version 1.6.0. New resource `ess.Attachment` replaces it.
        """
        warnings.warn("""Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""", DeprecationWarning)
        pulumi.log.warn("""instance_ids is deprecated: Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""")

        return pulumi.get(self, "instance_ids")

    @instance_ids.setter
    def instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_ids", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instancePatternInfos")
    def instance_pattern_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]]]:
        """
        intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
        """
        return pulumi.get(self, "instance_pattern_infos")

    @instance_pattern_infos.setter
    def instance_pattern_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]]]):
        pulumi.set(self, "instance_pattern_infos", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type of an ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Resource types of an ECS instance.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). The value range is [1,200].
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @internet_max_bandwidth_in.setter
    def internet_max_bandwidth_in(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_in", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @property
    @pulumi.getter(name="ioOptimized")
    def io_optimized(self) -> Optional[pulumi.Input[str]]:
        """
        It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
        """
        warnings.warn("""Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""", DeprecationWarning)
        pulumi.log.warn("""io_optimized is deprecated: Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""")

        return pulumi.get(self, "io_optimized")

    @io_optimized.setter
    def io_optimized(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "io_optimized", value)

    @property
    @pulumi.getter(name="isOutdated")
    def is_outdated(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use outdated instance type. Default to false.
        """
        return pulumi.get(self, "is_outdated")

    @is_outdated.setter
    def is_outdated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_outdated", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[str]]:
        """
        An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @property
    @pulumi.getter
    def override(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to overwrite the existing data. Default to false.
        """
        return pulumi.get(self, "override")

    @override.setter
    def override(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "override", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
        """
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_inherit", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        Instance RAM role name. The name is provided and maintained by RAM. You can use `ram.Role` to create a new one.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_configuration_name", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the security group used to create new instance. It is conflict with `security_group_ids`.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]]]:
        """
        Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.

        > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.

        > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.

        > **NOTE:** Restrictions on attaching ECS instances:

        - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
        - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
        - The attached ECS instances must in the running state.
        - The attached ECS instances has not been attached to other scaling groups.
        - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.

        > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
        """
        return pulumi.get(self, "spot_price_limits")

    @spot_price_limits.setter
    def spot_price_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]]]):
        pulumi.set(self, "spot_price_limits", value)

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_strategy", value)

    @property
    @pulumi.getter
    def substitute(self) -> Optional[pulumi.Input[str]]:
        """
        The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
        """
        return pulumi.get(self, "substitute")

    @substitute.setter
    def substitute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "substitute", value)

    @property
    @pulumi.getter(name="systemDiskAutoSnapshotPolicyId")
    def system_disk_auto_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of auto snapshot policy for system disk.
        """
        return pulumi.get(self, "system_disk_auto_snapshot_policy_id")

    @system_disk_auto_snapshot_policy_id.setter
    def system_disk_auto_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_auto_snapshot_policy_id", value)

    @property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_category", value)

    @property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "system_disk_description")

    @system_disk_description.setter
    def system_disk_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_description", value)

    @property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to encrypt the system disk.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @system_disk_encrypted.setter
    def system_disk_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "system_disk_encrypted", value)

    @property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        """
        return pulumi.get(self, "system_disk_name")

    @system_disk_name.setter
    def system_disk_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_name", value)

    @property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        The performance level of the ESSD used as the system disk.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @system_disk_performance_level.setter
    def system_disk_performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_performance_level", value)

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of system disk, in GiB. Optional values: cloud: 20-500, cloud_efficiency: 20-500, cloud_ssd: 20-500, ephemeral_ssd: 20-500 The default value is max{40, ImageSize}. If this parameter is set, the system disk size must be greater than or equal to max{40, ImageSize}.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "system_disk_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _ScalingConfigurationState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 credit_specification: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_pattern_infos: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 io_optimized: Optional[pulumi.Input[str]] = None,
                 is_outdated: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 override: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 substitute: Optional[pulumi.Input[str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_description: Optional[pulumi.Input[str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[bool]] = None,
                 system_disk_name: Optional[pulumi.Input[str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ScalingConfiguration resources.
        :param pulumi.Input[bool] active: Whether active current scaling configuration in the specified scaling group. Default to `false`.
        :param pulumi.Input[str] credit_specification: Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]] data_disks: DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
        :param pulumi.Input[bool] enable: Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
        :param pulumi.Input[bool] force_delete: The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
        :param pulumi.Input[str] host_name: Hostname of an ECS instance.
        :param pulumi.Input[str] image_id: ID of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[str] image_name: Name of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_ids: It has been deprecated from version 1.6.0. New resource `ess.Attachment` replaces it.
        :param pulumi.Input[str] instance_name: Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]] instance_pattern_infos: intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
        :param pulumi.Input[str] instance_type: Resource type of an ECS instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: Resource types of an ECS instance.
        :param pulumi.Input[str] internet_charge_type: Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
        :param pulumi.Input[int] internet_max_bandwidth_in: Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). The value range is [1,200].
        :param pulumi.Input[int] internet_max_bandwidth_out: Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
        :param pulumi.Input[str] io_optimized: It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
        :param pulumi.Input[bool] is_outdated: Whether to use outdated instance type. Default to false.
        :param pulumi.Input[str] key_name: The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[bool] override: Indicates whether to overwrite the existing data. Default to false.
        :param pulumi.Input[str] password: The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
        :param pulumi.Input[bool] password_inherit: Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
        :param pulumi.Input[str] resource_group_id: ID of resource group.
        :param pulumi.Input[str] role_name: Instance RAM role name. The name is provided and maintained by RAM. You can use `ram.Role` to create a new one.
        :param pulumi.Input[str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
        :param pulumi.Input[str] scaling_group_id: ID of the scaling group of a scaling configuration.
        :param pulumi.Input[str] security_group_id: ID of the security group used to create new instance. It is conflict with `security_group_ids`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
        :param pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]] spot_price_limits: Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
               
               > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
               
               > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
               
               > **NOTE:** Restrictions on attaching ECS instances:
               
               - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
               - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
               - The attached ECS instances must in the running state.
               - The attached ECS instances has not been attached to other scaling groups.
               - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
               
               > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
        :param pulumi.Input[str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
        :param pulumi.Input[str] substitute: The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
        :param pulumi.Input[str] system_disk_auto_snapshot_policy_id: The id of auto snapshot policy for system disk.
        :param pulumi.Input[str] system_disk_category: Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
        :param pulumi.Input[str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[bool] system_disk_encrypted: Whether to encrypt the system disk.
        :param pulumi.Input[str] system_disk_name: The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        :param pulumi.Input[str] system_disk_performance_level: The performance level of the ESSD used as the system disk.
        :param pulumi.Input[int] system_disk_size: Size of system disk, in GiB. Optional values: cloud: 20-500, cloud_efficiency: 20-500, cloud_ssd: 20-500, ephemeral_ssd: 20-500 The default value is max{40, ImageSize}. If this parameter is set, the system disk size must be greater than or equal to max{40, ImageSize}.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
        :param pulumi.Input[str] user_data: User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if credit_specification is not None:
            pulumi.set(__self__, "credit_specification", credit_specification)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if enable is not None:
            pulumi.set(__self__, "enable", enable)
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if instance_ids is not None:
            warnings.warn("""Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""", DeprecationWarning)
            pulumi.log.warn("""instance_ids is deprecated: Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""")
        if instance_ids is not None:
            pulumi.set(__self__, "instance_ids", instance_ids)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_pattern_infos is not None:
            pulumi.set(__self__, "instance_pattern_infos", instance_pattern_infos)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if instance_types is not None:
            pulumi.set(__self__, "instance_types", instance_types)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if internet_max_bandwidth_in is not None:
            pulumi.set(__self__, "internet_max_bandwidth_in", internet_max_bandwidth_in)
        if internet_max_bandwidth_out is not None:
            pulumi.set(__self__, "internet_max_bandwidth_out", internet_max_bandwidth_out)
        if io_optimized is not None:
            warnings.warn("""Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""", DeprecationWarning)
            pulumi.log.warn("""io_optimized is deprecated: Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""")
        if io_optimized is not None:
            pulumi.set(__self__, "io_optimized", io_optimized)
        if is_outdated is not None:
            pulumi.set(__self__, "is_outdated", is_outdated)
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if kms_encryption_context is not None:
            pulumi.set(__self__, "kms_encryption_context", kms_encryption_context)
        if override is not None:
            pulumi.set(__self__, "override", override)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_inherit is not None:
            pulumi.set(__self__, "password_inherit", password_inherit)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if scaling_configuration_name is not None:
            pulumi.set(__self__, "scaling_configuration_name", scaling_configuration_name)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_price_limits is not None:
            pulumi.set(__self__, "spot_price_limits", spot_price_limits)
        if spot_strategy is not None:
            pulumi.set(__self__, "spot_strategy", spot_strategy)
        if substitute is not None:
            pulumi.set(__self__, "substitute", substitute)
        if system_disk_auto_snapshot_policy_id is not None:
            pulumi.set(__self__, "system_disk_auto_snapshot_policy_id", system_disk_auto_snapshot_policy_id)
        if system_disk_category is not None:
            pulumi.set(__self__, "system_disk_category", system_disk_category)
        if system_disk_description is not None:
            pulumi.set(__self__, "system_disk_description", system_disk_description)
        if system_disk_encrypted is not None:
            pulumi.set(__self__, "system_disk_encrypted", system_disk_encrypted)
        if system_disk_name is not None:
            pulumi.set(__self__, "system_disk_name", system_disk_name)
        if system_disk_performance_level is not None:
            pulumi.set(__self__, "system_disk_performance_level", system_disk_performance_level)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether active current scaling configuration in the specified scaling group. Default to `false`.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> Optional[pulumi.Input[str]]:
        """
        Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        """
        return pulumi.get(self, "credit_specification")

    @credit_specification.setter
    def credit_specification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credit_specification", value)

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]]]:
        """
        DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @property
    @pulumi.getter
    def enable(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
        """
        return pulumi.get(self, "enable")

    @enable.setter
    def enable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable", value)

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> Optional[pulumi.Input[bool]]:
        """
        The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_delete", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Hostname of an ECS instance.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of an image file, indicating the image resource selected when an instance is enabled.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of an image file, indicating the image resource selected when an instance is enabled.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_name", value)

    @property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        It has been deprecated from version 1.6.0. New resource `ess.Attachment` replaces it.
        """
        warnings.warn("""Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""", DeprecationWarning)
        pulumi.log.warn("""instance_ids is deprecated: Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""")

        return pulumi.get(self, "instance_ids")

    @instance_ids.setter
    def instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_ids", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instancePatternInfos")
    def instance_pattern_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]]]:
        """
        intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
        """
        return pulumi.get(self, "instance_pattern_infos")

    @instance_pattern_infos.setter
    def instance_pattern_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationInstancePatternInfoArgs']]]]):
        pulumi.set(self, "instance_pattern_infos", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type of an ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Resource types of an ECS instance.
        """
        return pulumi.get(self, "instance_types")

    @instance_types.setter
    def instance_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_types", value)

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "internet_charge_type", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). The value range is [1,200].
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @internet_max_bandwidth_in.setter
    def internet_max_bandwidth_in(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_in", value)

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @internet_max_bandwidth_out.setter
    def internet_max_bandwidth_out(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "internet_max_bandwidth_out", value)

    @property
    @pulumi.getter(name="ioOptimized")
    def io_optimized(self) -> Optional[pulumi.Input[str]]:
        """
        It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
        """
        warnings.warn("""Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""", DeprecationWarning)
        pulumi.log.warn("""io_optimized is deprecated: Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""")

        return pulumi.get(self, "io_optimized")

    @io_optimized.setter
    def io_optimized(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "io_optimized", value)

    @property
    @pulumi.getter(name="isOutdated")
    def is_outdated(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use outdated instance type. Default to false.
        """
        return pulumi.get(self, "is_outdated")

    @is_outdated.setter
    def is_outdated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_outdated", value)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[str]]:
        """
        An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @kms_encryption_context.setter
    def kms_encryption_context(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "kms_encryption_context", value)

    @property
    @pulumi.getter
    def override(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether to overwrite the existing data. Default to false.
        """
        return pulumi.get(self, "override")

    @override.setter
    def override(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "override", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
        """
        return pulumi.get(self, "password_inherit")

    @password_inherit.setter
    def password_inherit(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "password_inherit", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        Instance RAM role name. The name is provided and maintained by RAM. You can use `ram.Role` to create a new one.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @scaling_configuration_name.setter
    def scaling_configuration_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_configuration_name", value)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the scaling group of a scaling configuration.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_group_id", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the security group used to create new instance. It is conflict with `security_group_ids`.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]]]:
        """
        Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.

        > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.

        > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.

        > **NOTE:** Restrictions on attaching ECS instances:

        - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
        - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
        - The attached ECS instances must in the running state.
        - The attached ECS instances has not been attached to other scaling groups.
        - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.

        > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
        """
        return pulumi.get(self, "spot_price_limits")

    @spot_price_limits.setter
    def spot_price_limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ScalingConfigurationSpotPriceLimitArgs']]]]):
        pulumi.set(self, "spot_price_limits", value)

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
        """
        return pulumi.get(self, "spot_strategy")

    @spot_strategy.setter
    def spot_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spot_strategy", value)

    @property
    @pulumi.getter
    def substitute(self) -> Optional[pulumi.Input[str]]:
        """
        The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
        """
        return pulumi.get(self, "substitute")

    @substitute.setter
    def substitute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "substitute", value)

    @property
    @pulumi.getter(name="systemDiskAutoSnapshotPolicyId")
    def system_disk_auto_snapshot_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of auto snapshot policy for system disk.
        """
        return pulumi.get(self, "system_disk_auto_snapshot_policy_id")

    @system_disk_auto_snapshot_policy_id.setter
    def system_disk_auto_snapshot_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_auto_snapshot_policy_id", value)

    @property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> Optional[pulumi.Input[str]]:
        """
        Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "system_disk_category")

    @system_disk_category.setter
    def system_disk_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_category", value)

    @property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "system_disk_description")

    @system_disk_description.setter
    def system_disk_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_description", value)

    @property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to encrypt the system disk.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @system_disk_encrypted.setter
    def system_disk_encrypted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "system_disk_encrypted", value)

    @property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        """
        return pulumi.get(self, "system_disk_name")

    @system_disk_name.setter
    def system_disk_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_name", value)

    @property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> Optional[pulumi.Input[str]]:
        """
        The performance level of the ESSD used as the system disk.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @system_disk_performance_level.setter
    def system_disk_performance_level(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_disk_performance_level", value)

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[int]]:
        """
        Size of system disk, in GiB. Optional values: cloud: 20-500, cloud_efficiency: 20-500, cloud_ssd: 20-500, ephemeral_ssd: 20-500 The default value is max{40, ImageSize}. If this parameter is set, the system disk size must be greater than or equal to max{40, ImageSize}.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "system_disk_size", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)


class ScalingConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 credit_specification: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationDataDiskArgs']]]]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_pattern_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationInstancePatternInfoArgs']]]]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 io_optimized: Optional[pulumi.Input[str]] = None,
                 is_outdated: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 override: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationSpotPriceLimitArgs']]]]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 substitute: Optional[pulumi.Input[str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_description: Optional[pulumi.Input[str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[bool]] = None,
                 system_disk_name: Optional[pulumi.Input[str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a ESS scaling configuration resource.

        > **NOTE:** Several instance types have outdated in some regions and availability zones, such as `ecs.t1.*`, `ecs.s2.*`, `ecs.n1.*` and so on. If you want to keep them, you should set `is_outdated` to true. For more about the upgraded instance type, refer to `ecs_get_instance_types` datasource.

        > **NOTE:** Available since v1.39.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            cpu_core_count=2,
            memory_size=4)
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default_zones.zones[0].id,
            vswitch_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_security_group_rule = alicloud.ecs.SecurityGroupRule("defaultSecurityGroupRule",
            type="ingress",
            ip_protocol="tcp",
            nic_type="intranet",
            policy="accept",
            port_range="22/22",
            priority=1,
            security_group_id=default_security_group.id,
            cidr_ip="172.16.0.0/24")
        default_scaling_group = alicloud.ess.ScalingGroup("defaultScalingGroup",
            min_size=1,
            max_size=1,
            scaling_group_name=name,
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ],
            vswitch_ids=[default_switch.id])
        default_scaling_configuration = alicloud.ess.ScalingConfiguration("defaultScalingConfiguration",
            scaling_group_id=default_scaling_group.id,
            image_id=default_images.images[0].id,
            instance_type=default_instance_types.instance_types[0].id,
            security_group_id=default_security_group.id,
            force_delete=True,
            active=True)
        ```
        ## Module Support

        You can use to the existing autoscaling module
        to create a configuration, scaling group and lifecycle hook one-click.

        ## Import

        ESS scaling configuration can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ess/scalingConfiguration:ScalingConfiguration example asg-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: Whether active current scaling configuration in the specified scaling group. Default to `false`.
        :param pulumi.Input[str] credit_specification: Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationDataDiskArgs']]]] data_disks: DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
        :param pulumi.Input[bool] enable: Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
        :param pulumi.Input[bool] force_delete: The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
        :param pulumi.Input[str] host_name: Hostname of an ECS instance.
        :param pulumi.Input[str] image_id: ID of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[str] image_name: Name of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_ids: It has been deprecated from version 1.6.0. New resource `ess.Attachment` replaces it.
        :param pulumi.Input[str] instance_name: Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationInstancePatternInfoArgs']]]] instance_pattern_infos: intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
        :param pulumi.Input[str] instance_type: Resource type of an ECS instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: Resource types of an ECS instance.
        :param pulumi.Input[str] internet_charge_type: Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
        :param pulumi.Input[int] internet_max_bandwidth_in: Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). The value range is [1,200].
        :param pulumi.Input[int] internet_max_bandwidth_out: Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
        :param pulumi.Input[str] io_optimized: It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
        :param pulumi.Input[bool] is_outdated: Whether to use outdated instance type. Default to false.
        :param pulumi.Input[str] key_name: The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[bool] override: Indicates whether to overwrite the existing data. Default to false.
        :param pulumi.Input[str] password: The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
        :param pulumi.Input[bool] password_inherit: Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
        :param pulumi.Input[str] resource_group_id: ID of resource group.
        :param pulumi.Input[str] role_name: Instance RAM role name. The name is provided and maintained by RAM. You can use `ram.Role` to create a new one.
        :param pulumi.Input[str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
        :param pulumi.Input[str] scaling_group_id: ID of the scaling group of a scaling configuration.
        :param pulumi.Input[str] security_group_id: ID of the security group used to create new instance. It is conflict with `security_group_ids`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationSpotPriceLimitArgs']]]] spot_price_limits: Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
               
               > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
               
               > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
               
               > **NOTE:** Restrictions on attaching ECS instances:
               
               - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
               - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
               - The attached ECS instances must in the running state.
               - The attached ECS instances has not been attached to other scaling groups.
               - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
               
               > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
        :param pulumi.Input[str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
        :param pulumi.Input[str] substitute: The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
        :param pulumi.Input[str] system_disk_auto_snapshot_policy_id: The id of auto snapshot policy for system disk.
        :param pulumi.Input[str] system_disk_category: Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
        :param pulumi.Input[str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[bool] system_disk_encrypted: Whether to encrypt the system disk.
        :param pulumi.Input[str] system_disk_name: The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        :param pulumi.Input[str] system_disk_performance_level: The performance level of the ESSD used as the system disk.
        :param pulumi.Input[int] system_disk_size: Size of system disk, in GiB. Optional values: cloud: 20-500, cloud_efficiency: 20-500, cloud_ssd: 20-500, ephemeral_ssd: 20-500 The default value is max{40, ImageSize}. If this parameter is set, the system disk size must be greater than or equal to max{40, ImageSize}.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
        :param pulumi.Input[str] user_data: User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScalingConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESS scaling configuration resource.

        > **NOTE:** Several instance types have outdated in some regions and availability zones, such as `ecs.t1.*`, `ecs.s2.*`, `ecs.n1.*` and so on. If you want to keep them, you should set `is_outdated` to true. For more about the upgraded instance type, refer to `ecs_get_instance_types` datasource.

        > **NOTE:** Available since v1.39.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            cpu_core_count=2,
            memory_size=4)
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default_zones.zones[0].id,
            vswitch_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_security_group_rule = alicloud.ecs.SecurityGroupRule("defaultSecurityGroupRule",
            type="ingress",
            ip_protocol="tcp",
            nic_type="intranet",
            policy="accept",
            port_range="22/22",
            priority=1,
            security_group_id=default_security_group.id,
            cidr_ip="172.16.0.0/24")
        default_scaling_group = alicloud.ess.ScalingGroup("defaultScalingGroup",
            min_size=1,
            max_size=1,
            scaling_group_name=name,
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ],
            vswitch_ids=[default_switch.id])
        default_scaling_configuration = alicloud.ess.ScalingConfiguration("defaultScalingConfiguration",
            scaling_group_id=default_scaling_group.id,
            image_id=default_images.images[0].id,
            instance_type=default_instance_types.instance_types[0].id,
            security_group_id=default_security_group.id,
            force_delete=True,
            active=True)
        ```
        ## Module Support

        You can use to the existing autoscaling module
        to create a configuration, scaling group and lifecycle hook one-click.

        ## Import

        ESS scaling configuration can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ess/scalingConfiguration:ScalingConfiguration example asg-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param ScalingConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScalingConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 credit_specification: Optional[pulumi.Input[str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationDataDiskArgs']]]]] = None,
                 enable: Optional[pulumi.Input[bool]] = None,
                 force_delete: Optional[pulumi.Input[bool]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_name: Optional[pulumi.Input[str]] = None,
                 instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_pattern_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationInstancePatternInfoArgs']]]]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 internet_charge_type: Optional[pulumi.Input[str]] = None,
                 internet_max_bandwidth_in: Optional[pulumi.Input[int]] = None,
                 internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
                 io_optimized: Optional[pulumi.Input[str]] = None,
                 is_outdated: Optional[pulumi.Input[bool]] = None,
                 key_name: Optional[pulumi.Input[str]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[str]] = None,
                 kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 override: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 password_inherit: Optional[pulumi.Input[bool]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 scaling_configuration_name: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationSpotPriceLimitArgs']]]]] = None,
                 spot_strategy: Optional[pulumi.Input[str]] = None,
                 substitute: Optional[pulumi.Input[str]] = None,
                 system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
                 system_disk_category: Optional[pulumi.Input[str]] = None,
                 system_disk_description: Optional[pulumi.Input[str]] = None,
                 system_disk_encrypted: Optional[pulumi.Input[bool]] = None,
                 system_disk_name: Optional[pulumi.Input[str]] = None,
                 system_disk_performance_level: Optional[pulumi.Input[str]] = None,
                 system_disk_size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScalingConfigurationArgs.__new__(ScalingConfigurationArgs)

            __props__.__dict__["active"] = active
            __props__.__dict__["credit_specification"] = credit_specification
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["enable"] = enable
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["image_name"] = image_name
            __props__.__dict__["instance_ids"] = instance_ids
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["instance_pattern_infos"] = instance_pattern_infos
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["instance_types"] = instance_types
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["internet_max_bandwidth_in"] = internet_max_bandwidth_in
            __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
            __props__.__dict__["io_optimized"] = io_optimized
            __props__.__dict__["is_outdated"] = is_outdated
            __props__.__dict__["key_name"] = key_name
            __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
            __props__.__dict__["kms_encryption_context"] = kms_encryption_context
            __props__.__dict__["override"] = override
            __props__.__dict__["password"] = password
            __props__.__dict__["password_inherit"] = password_inherit
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["spot_price_limits"] = spot_price_limits
            __props__.__dict__["spot_strategy"] = spot_strategy
            __props__.__dict__["substitute"] = substitute
            __props__.__dict__["system_disk_auto_snapshot_policy_id"] = system_disk_auto_snapshot_policy_id
            __props__.__dict__["system_disk_category"] = system_disk_category
            __props__.__dict__["system_disk_description"] = system_disk_description
            __props__.__dict__["system_disk_encrypted"] = system_disk_encrypted
            __props__.__dict__["system_disk_name"] = system_disk_name
            __props__.__dict__["system_disk_performance_level"] = system_disk_performance_level
            __props__.__dict__["system_disk_size"] = system_disk_size
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
        super(ScalingConfiguration, __self__).__init__(
            'alicloud:ess/scalingConfiguration:ScalingConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[bool]] = None,
            credit_specification: Optional[pulumi.Input[str]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationDataDiskArgs']]]]] = None,
            enable: Optional[pulumi.Input[bool]] = None,
            force_delete: Optional[pulumi.Input[bool]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            image_name: Optional[pulumi.Input[str]] = None,
            instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_pattern_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationInstancePatternInfoArgs']]]]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            instance_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            internet_charge_type: Optional[pulumi.Input[str]] = None,
            internet_max_bandwidth_in: Optional[pulumi.Input[int]] = None,
            internet_max_bandwidth_out: Optional[pulumi.Input[int]] = None,
            io_optimized: Optional[pulumi.Input[str]] = None,
            is_outdated: Optional[pulumi.Input[bool]] = None,
            key_name: Optional[pulumi.Input[str]] = None,
            kms_encrypted_password: Optional[pulumi.Input[str]] = None,
            kms_encryption_context: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            override: Optional[pulumi.Input[bool]] = None,
            password: Optional[pulumi.Input[str]] = None,
            password_inherit: Optional[pulumi.Input[bool]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            role_name: Optional[pulumi.Input[str]] = None,
            scaling_configuration_name: Optional[pulumi.Input[str]] = None,
            scaling_group_id: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            spot_price_limits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationSpotPriceLimitArgs']]]]] = None,
            spot_strategy: Optional[pulumi.Input[str]] = None,
            substitute: Optional[pulumi.Input[str]] = None,
            system_disk_auto_snapshot_policy_id: Optional[pulumi.Input[str]] = None,
            system_disk_category: Optional[pulumi.Input[str]] = None,
            system_disk_description: Optional[pulumi.Input[str]] = None,
            system_disk_encrypted: Optional[pulumi.Input[bool]] = None,
            system_disk_name: Optional[pulumi.Input[str]] = None,
            system_disk_performance_level: Optional[pulumi.Input[str]] = None,
            system_disk_size: Optional[pulumi.Input[int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            user_data: Optional[pulumi.Input[str]] = None) -> 'ScalingConfiguration':
        """
        Get an existing ScalingConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: Whether active current scaling configuration in the specified scaling group. Default to `false`.
        :param pulumi.Input[str] credit_specification: Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationDataDiskArgs']]]] data_disks: DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
        :param pulumi.Input[bool] enable: Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
        :param pulumi.Input[bool] force_delete: The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
        :param pulumi.Input[str] host_name: Hostname of an ECS instance.
        :param pulumi.Input[str] image_id: ID of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[str] image_name: Name of an image file, indicating the image resource selected when an instance is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_ids: It has been deprecated from version 1.6.0. New resource `ess.Attachment` replaces it.
        :param pulumi.Input[str] instance_name: Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationInstancePatternInfoArgs']]]] instance_pattern_infos: intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
        :param pulumi.Input[str] instance_type: Resource type of an ECS instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_types: Resource types of an ECS instance.
        :param pulumi.Input[str] internet_charge_type: Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
        :param pulumi.Input[int] internet_max_bandwidth_in: Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). The value range is [1,200].
        :param pulumi.Input[int] internet_max_bandwidth_out: Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
        :param pulumi.Input[str] io_optimized: It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
        :param pulumi.Input[bool] is_outdated: Whether to use outdated instance type. Default to false.
        :param pulumi.Input[str] key_name: The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        :param pulumi.Input[str] kms_encrypted_password: An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
        :param pulumi.Input[Mapping[str, Any]] kms_encryption_context: An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        :param pulumi.Input[bool] override: Indicates whether to overwrite the existing data. Default to false.
        :param pulumi.Input[str] password: The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
        :param pulumi.Input[bool] password_inherit: Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
        :param pulumi.Input[str] resource_group_id: ID of resource group.
        :param pulumi.Input[str] role_name: Instance RAM role name. The name is provided and maintained by RAM. You can use `ram.Role` to create a new one.
        :param pulumi.Input[str] scaling_configuration_name: Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
        :param pulumi.Input[str] scaling_group_id: ID of the scaling group of a scaling configuration.
        :param pulumi.Input[str] security_group_id: ID of the security group used to create new instance. It is conflict with `security_group_ids`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ScalingConfigurationSpotPriceLimitArgs']]]] spot_price_limits: Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.
               
               > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.
               
               > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.
               
               > **NOTE:** Restrictions on attaching ECS instances:
               
               - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
               - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
               - The attached ECS instances must in the running state.
               - The attached ECS instances has not been attached to other scaling groups.
               - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.
               
               > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
        :param pulumi.Input[str] spot_strategy: The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
        :param pulumi.Input[str] substitute: The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
        :param pulumi.Input[str] system_disk_auto_snapshot_policy_id: The id of auto snapshot policy for system disk.
        :param pulumi.Input[str] system_disk_category: Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
        :param pulumi.Input[str] system_disk_description: The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        :param pulumi.Input[bool] system_disk_encrypted: Whether to encrypt the system disk.
        :param pulumi.Input[str] system_disk_name: The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        :param pulumi.Input[str] system_disk_performance_level: The performance level of the ESSD used as the system disk.
        :param pulumi.Input[int] system_disk_size: Size of system disk, in GiB. Optional values: cloud: 20-500, cloud_efficiency: 20-500, cloud_ssd: 20-500, ephemeral_ssd: 20-500 The default value is max{40, ImageSize}. If this parameter is set, the system disk size must be greater than or equal to max{40, ImageSize}.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
        :param pulumi.Input[str] user_data: User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScalingConfigurationState.__new__(_ScalingConfigurationState)

        __props__.__dict__["active"] = active
        __props__.__dict__["credit_specification"] = credit_specification
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["enable"] = enable
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["instance_ids"] = instance_ids
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_pattern_infos"] = instance_pattern_infos
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["instance_types"] = instance_types
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["internet_max_bandwidth_in"] = internet_max_bandwidth_in
        __props__.__dict__["internet_max_bandwidth_out"] = internet_max_bandwidth_out
        __props__.__dict__["io_optimized"] = io_optimized
        __props__.__dict__["is_outdated"] = is_outdated
        __props__.__dict__["key_name"] = key_name
        __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
        __props__.__dict__["kms_encryption_context"] = kms_encryption_context
        __props__.__dict__["override"] = override
        __props__.__dict__["password"] = password
        __props__.__dict__["password_inherit"] = password_inherit
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["scaling_configuration_name"] = scaling_configuration_name
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["spot_price_limits"] = spot_price_limits
        __props__.__dict__["spot_strategy"] = spot_strategy
        __props__.__dict__["substitute"] = substitute
        __props__.__dict__["system_disk_auto_snapshot_policy_id"] = system_disk_auto_snapshot_policy_id
        __props__.__dict__["system_disk_category"] = system_disk_category
        __props__.__dict__["system_disk_description"] = system_disk_description
        __props__.__dict__["system_disk_encrypted"] = system_disk_encrypted
        __props__.__dict__["system_disk_name"] = system_disk_name
        __props__.__dict__["system_disk_performance_level"] = system_disk_performance_level
        __props__.__dict__["system_disk_size"] = system_disk_size
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_data"] = user_data
        return ScalingConfiguration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[bool]:
        """
        Whether active current scaling configuration in the specified scaling group. Default to `false`.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="creditSpecification")
    def credit_specification(self) -> pulumi.Output[Optional[str]]:
        """
        Performance mode of the t5 burstable instance. Valid values: 'Standard', 'Unlimited'.
        """
        return pulumi.get(self, "credit_specification")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.ScalingConfigurationDataDisk']]]:
        """
        DataDisk mappings to attach to ecs instance. See `data_disk` below for details.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter
    def enable(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether enable the specified scaling group(make it active) to which the current scaling configuration belongs.
        """
        return pulumi.get(self, "enable")

    @property
    @pulumi.getter(name="forceDelete")
    def force_delete(self) -> pulumi.Output[Optional[bool]]:
        """
        The last scaling configuration will be deleted forcibly with deleting its scaling group. Default to false.
        """
        return pulumi.get(self, "force_delete")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[str]]:
        """
        Hostname of an ECS instance.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of an image file, indicating the image resource selected when an instance is enabled.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of an image file, indicating the image resource selected when an instance is enabled.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="instanceIds")
    def instance_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        It has been deprecated from version 1.6.0. New resource `ess.Attachment` replaces it.
        """
        warnings.warn("""Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""", DeprecationWarning)
        pulumi.log.warn("""instance_ids is deprecated: Field 'instance_ids' has been deprecated from provider version 1.6.0. New resource 'alicloud_ess_attachment' replaces it.""")

        return pulumi.get(self, "instance_ids")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of an ECS instance. Default to "ESS-Instance". It is valid from version 1.7.1.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instancePatternInfos")
    def instance_pattern_infos(self) -> pulumi.Output[Optional[Sequence['outputs.ScalingConfigurationInstancePatternInfo']]]:
        """
        intelligent configuration mode. In this mode, you only need to specify the number of vCPUs, memory size, instance family, and maximum price. The system selects an instance type that is provided at the lowest price based on your configurations to create ECS instances. This mode is available only for scaling groups that reside in virtual private clouds (VPCs). This mode helps reduce the failures of scale-out activities caused by insufficient inventory of instance types.  See `instance_pattern_info` below for details.
        """
        return pulumi.get(self, "instance_pattern_infos")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[str]]:
        """
        Resource type of an ECS instance.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="instanceTypes")
    def instance_types(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Resource types of an ECS instance.
        """
        return pulumi.get(self, "instance_types")

    @property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[Optional[str]]:
        """
        Network billing type, Values: PayByBandwidth or PayByTraffic. Default to `PayByBandwidth`.
        """
        return pulumi.get(self, "internet_charge_type")

    @property
    @pulumi.getter(name="internetMaxBandwidthIn")
    def internet_max_bandwidth_in(self) -> pulumi.Output[int]:
        """
        Maximum incoming bandwidth from the public network, measured in Mbps (Mega bit per second). The value range is [1,200].
        """
        return pulumi.get(self, "internet_max_bandwidth_in")

    @property
    @pulumi.getter(name="internetMaxBandwidthOut")
    def internet_max_bandwidth_out(self) -> pulumi.Output[Optional[int]]:
        """
        Maximum outgoing bandwidth from the public network, measured in Mbps (Mega bit per second). The value range for PayByBandwidth is [0,1024].
        """
        return pulumi.get(self, "internet_max_bandwidth_out")

    @property
    @pulumi.getter(name="ioOptimized")
    def io_optimized(self) -> pulumi.Output[Optional[str]]:
        """
        It has been deprecated on instance resource. All the launched alicloud instances will be I/O optimized.
        """
        warnings.warn("""Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""", DeprecationWarning)
        pulumi.log.warn("""io_optimized is deprecated: Attribute io_optimized has been deprecated on instance resource. All the launched alicloud instances will be IO optimized. Suggest to remove it from your template.""")

        return pulumi.get(self, "io_optimized")

    @property
    @pulumi.getter(name="isOutdated")
    def is_outdated(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to use outdated instance type. Default to false.
        """
        return pulumi.get(self, "is_outdated")

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of key pair that can login ECS instance successfully without password. If it is specified, the password would be invalid.
        """
        return pulumi.get(self, "key_name")

    @property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> pulumi.Output[Optional[str]]:
        """
        An KMS encrypts password used to a db account. If the `password` is filled in, this field will be ignored.
        """
        return pulumi.get(self, "kms_encrypted_password")

    @property
    @pulumi.getter(name="kmsEncryptionContext")
    def kms_encryption_context(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        An KMS encryption context used to decrypt `kms_encrypted_password` before creating or updating a db account with `kms_encrypted_password`. See [Encryption Context](https://www.alibabacloud.com/help/doc-detail/42975.htm). It is valid when `kms_encrypted_password` is set.
        """
        return pulumi.get(self, "kms_encryption_context")

    @property
    @pulumi.getter
    def override(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether to overwrite the existing data. Default to false.
        """
        return pulumi.get(self, "override")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        The password of the ECS instance. The password must be 8 to 30 characters in length. It must contains at least three of the following character types: uppercase letters, lowercase letters, digits, and special characters. Special characters include `() ~!@#$%^&*-_+=\\|{}[]:;'<>,.?/`, The password of Windows-based instances cannot start with a forward slash (/).
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordInherit")
    def password_inherit(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to use the password that is predefined in the image. If the PasswordInherit parameter is set to true, the `password` and `kms_encrypted_password` will be ignored. You must ensure that the selected image has a password configured.
        """
        return pulumi.get(self, "password_inherit")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of resource group.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[Optional[str]]:
        """
        Instance RAM role name. The name is provided and maintained by RAM. You can use `ram.Role` to create a new one.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="scalingConfigurationName")
    def scaling_configuration_name(self) -> pulumi.Output[str]:
        """
        Name shown for the scheduled task. which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain number, underscores `_`, hypens `-`, and decimal point `.`. If this parameter value is not specified, the default value is ScalingConfigurationId.
        """
        return pulumi.get(self, "scaling_configuration_name")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[str]:
        """
        ID of the scaling group of a scaling configuration.
        """
        return pulumi.get(self, "scaling_group_id")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        ID of the security group used to create new instance. It is conflict with `security_group_ids`.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List IDs of the security group used to create new instances. It is conflict with `security_group_id`.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter(name="spotPriceLimits")
    def spot_price_limits(self) -> pulumi.Output[Optional[Sequence['outputs.ScalingConfigurationSpotPriceLimit']]]:
        """
        Sets the maximum price hourly for instance types. See `spot_price_limit` below for details.

        > **NOTE:** Before enabling the scaling group, it must have a active scaling configuration.

        > **NOTE:** If the number of attached ECS instances by `instance_ids` is smaller than MinSize, the Auto Scaling Service will automatically create ECS Pay-As-You-Go instance to cater to MinSize. For example, MinSize=5 and 2 existing ECS instances has been attached to the scaling group. When the scaling group is enabled, it will create 3 instnaces automatically based on its current active scaling configuration.

        > **NOTE:** Restrictions on attaching ECS instances:

        - The attached ECS instances and the scaling group must have the same region and network type(`Classic` or `VPC`).
        - The attached ECS instances and the instance with active scaling configurations must have the same instance type.
        - The attached ECS instances must in the running state.
        - The attached ECS instances has not been attached to other scaling groups.
        - The attached ECS instances supports Subscription and Pay-As-You-Go payment methods.

        > **NOTE:** The last scaling configuration can't be set to inactive and deleted alone.
        """
        return pulumi.get(self, "spot_price_limits")

    @property
    @pulumi.getter(name="spotStrategy")
    def spot_strategy(self) -> pulumi.Output[Optional[str]]:
        """
        The spot strategy for a Pay-As-You-Go instance. Valid values: `NoSpot`, `SpotAsPriceGo`, `SpotWithPriceLimit`.
        """
        return pulumi.get(self, "spot_strategy")

    @property
    @pulumi.getter
    def substitute(self) -> pulumi.Output[str]:
        """
        The another scaling configuration which will be active automatically and replace current configuration when setting `active` to 'false'. It is invalid when `active` is 'true'.
        """
        return pulumi.get(self, "substitute")

    @property
    @pulumi.getter(name="systemDiskAutoSnapshotPolicyId")
    def system_disk_auto_snapshot_policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        The id of auto snapshot policy for system disk.
        """
        return pulumi.get(self, "system_disk_auto_snapshot_policy_id")

    @property
    @pulumi.getter(name="systemDiskCategory")
    def system_disk_category(self) -> pulumi.Output[Optional[str]]:
        """
        Category of the system disk. The parameter value options are `ephemeral_ssd`, `cloud_efficiency`, `cloud_ssd`, `cloud_essd` and `cloud`. `cloud` only is used to some no I/O optimized instance. Default to `cloud_efficiency`.
        """
        return pulumi.get(self, "system_disk_category")

    @property
    @pulumi.getter(name="systemDiskDescription")
    def system_disk_description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the system disk. The description must be 2 to 256 characters in length and cannot start with http:// or https://.
        """
        return pulumi.get(self, "system_disk_description")

    @property
    @pulumi.getter(name="systemDiskEncrypted")
    def system_disk_encrypted(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to encrypt the system disk.
        """
        return pulumi.get(self, "system_disk_encrypted")

    @property
    @pulumi.getter(name="systemDiskName")
    def system_disk_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the system disk. It must be 2 to 128 characters in length. It must start with a letter and cannot start with http:// or https://. It can contain letters, digits, colons (:), underscores (_), and hyphens (-). Default value: null.
        """
        return pulumi.get(self, "system_disk_name")

    @property
    @pulumi.getter(name="systemDiskPerformanceLevel")
    def system_disk_performance_level(self) -> pulumi.Output[Optional[str]]:
        """
        The performance level of the ESSD used as the system disk.
        """
        return pulumi.get(self, "system_disk_performance_level")

    @property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> pulumi.Output[Optional[int]]:
        """
        Size of system disk, in GiB. Optional values: cloud: 20-500, cloud_efficiency: 20-500, cloud_ssd: 20-500, ephemeral_ssd: 20-500 The default value is max{40, ImageSize}. If this parameter is set, the system disk size must be greater than or equal to max{40, ImageSize}.
        """
        return pulumi.get(self, "system_disk_size")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource. It will be applied for ECS instances finally.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "http://", or "https://" It can be a null string.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        User-defined data to customize the startup behaviors of the ECS instance and to pass data into the ECS instance.
        """
        return pulumi.get(self, "user_data")

