# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ScalingGroupArgs', 'ScalingGroup']

@pulumi.input_type
class ScalingGroupArgs:
    def __init__(__self__, *,
                 max_size: pulumi.Input[int],
                 min_size: pulumi.Input[int],
                 db_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_cooldown: Optional[pulumi.Input[int]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 group_deletion_protection: Optional[pulumi.Input[bool]] = None,
                 group_type: Optional[pulumi.Input[str]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 launch_template_version: Optional[pulumi.Input[str]] = None,
                 loadbalancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 multi_az_policy: Optional[pulumi.Input[str]] = None,
                 on_demand_base_capacity: Optional[pulumi.Input[int]] = None,
                 on_demand_percentage_above_base_capacity: Optional[pulumi.Input[int]] = None,
                 protected_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 removal_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scaling_group_name: Optional[pulumi.Input[str]] = None,
                 spot_instance_pools: Optional[pulumi.Input[int]] = None,
                 spot_instance_remedy: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ScalingGroup resource.
        :param pulumi.Input[int] max_size: Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
        :param pulumi.Input[int] min_size: Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_instance_ids: If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
               - The specified RDS instance must be in running status.
               - The specified RDS instance’s whitelist must have room for more IP addresses.
        :param pulumi.Input[int] default_cooldown: Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
        :param pulumi.Input[int] desired_capacity: Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
        :param pulumi.Input[bool] group_deletion_protection: Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
        :param pulumi.Input[str] group_type: Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
        :param pulumi.Input[str] health_check_type: Resource type within scaling group. Optional values: ECS, NONE. Default to ECS.
        :param pulumi.Input[str] launch_template_id: Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
        :param pulumi.Input[str] launch_template_version: The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] loadbalancer_ids: If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
               - The Server Load Balancer instance must be enabled.
               - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
               targeting your `slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
               - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
               - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
        :param pulumi.Input[str] multi_az_policy: Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, BALANCE or COST_OPTIMIZED(Available in 1.54.0+).
        :param pulumi.Input[int] on_demand_base_capacity: The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
        :param pulumi.Input[int] on_demand_percentage_above_base_capacity: Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protected_instances: Set or unset instances within group into protected status.
               
               > **NOTE:** When detach loadbalancers, instances in group will be remove from loadbalancer's `Default Server Group`; On the contrary, When attach loadbalancers, instances in group will be added to loadbalancer's `Default Server Group`.
               
               > **NOTE:** When detach dbInstances, private ip of instances in group will be remove from dbInstance's `WhiteList`; On the contrary, When attach dbInstances, private ip of instances in group will be added to dbInstance's `WhiteList`.
               
               > **NOTE:** `on_demand_base_capacity`,`on_demand_percentage_above_base_capacity`,`spot_instance_pools`,`spot_instance_remedy` are valid only if `multi_az_policy` is 'COST_OPTIMIZED'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] removal_policies: RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
               - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
               - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
               - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
               - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
        :param pulumi.Input[str] scaling_group_name: Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
        :param pulumi.Input[int] spot_instance_pools: The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
        :param pulumi.Input[bool] spot_instance_remedy: Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] vswitch_id: It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vswitch_ids: List of virtual switch IDs in which the ecs instances to be launched.
        """
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)
        if db_instance_ids is not None:
            pulumi.set(__self__, "db_instance_ids", db_instance_ids)
        if default_cooldown is not None:
            pulumi.set(__self__, "default_cooldown", default_cooldown)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if group_deletion_protection is not None:
            pulumi.set(__self__, "group_deletion_protection", group_deletion_protection)
        if group_type is not None:
            pulumi.set(__self__, "group_type", group_type)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_version is not None:
            pulumi.set(__self__, "launch_template_version", launch_template_version)
        if loadbalancer_ids is not None:
            pulumi.set(__self__, "loadbalancer_ids", loadbalancer_ids)
        if multi_az_policy is not None:
            pulumi.set(__self__, "multi_az_policy", multi_az_policy)
        if on_demand_base_capacity is not None:
            pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        if on_demand_percentage_above_base_capacity is not None:
            pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        if protected_instances is not None:
            pulumi.set(__self__, "protected_instances", protected_instances)
        if removal_policies is not None:
            pulumi.set(__self__, "removal_policies", removal_policies)
        if scaling_group_name is not None:
            pulumi.set(__self__, "scaling_group_name", scaling_group_name)
        if spot_instance_pools is not None:
            pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)
        if spot_instance_remedy is not None:
            pulumi.set(__self__, "spot_instance_remedy", spot_instance_remedy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitch_id is not None:
            warnings.warn("""Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""", DeprecationWarning)
            pulumi.log.warn("""vswitch_id is deprecated: Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""")
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Input[int]:
        """
        Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
        **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Input[int]:
        """
        Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
        **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="dbInstanceIds")
    def db_instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
        - The specified RDS instance must be in running status.
        - The specified RDS instance’s whitelist must have room for more IP addresses.
        """
        return pulumi.get(self, "db_instance_ids")

    @db_instance_ids.setter
    def db_instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "db_instance_ids", value)

    @property
    @pulumi.getter(name="defaultCooldown")
    def default_cooldown(self) -> Optional[pulumi.Input[int]]:
        """
        Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
        """
        return pulumi.get(self, "default_cooldown")

    @default_cooldown.setter
    def default_cooldown(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_cooldown", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="groupDeletionProtection")
    def group_deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
        """
        return pulumi.get(self, "group_deletion_protection")

    @group_deletion_protection.setter
    def group_deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "group_deletion_protection", value)

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
        """
        return pulumi.get(self, "group_type")

    @group_type.setter
    def group_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_type", value)

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type within scaling group. Optional values: ECS, NONE. Default to ECS.
        """
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_type", value)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
        """
        return pulumi.get(self, "launch_template_version")

    @launch_template_version.setter
    def launch_template_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_version", value)

    @property
    @pulumi.getter(name="loadbalancerIds")
    def loadbalancer_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
        - The Server Load Balancer instance must be enabled.
        - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
        targeting your `slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
        - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
        - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
        """
        return pulumi.get(self, "loadbalancer_ids")

    @loadbalancer_ids.setter
    def loadbalancer_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "loadbalancer_ids", value)

    @property
    @pulumi.getter(name="multiAzPolicy")
    def multi_az_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, BALANCE or COST_OPTIMIZED(Available in 1.54.0+).
        """
        return pulumi.get(self, "multi_az_policy")

    @multi_az_policy.setter
    def multi_az_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_az_policy", value)

    @property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @on_demand_base_capacity.setter
    def on_demand_base_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "on_demand_base_capacity", value)

    @property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @on_demand_percentage_above_base_capacity.setter
    def on_demand_percentage_above_base_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "on_demand_percentage_above_base_capacity", value)

    @property
    @pulumi.getter(name="protectedInstances")
    def protected_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set or unset instances within group into protected status.

        > **NOTE:** When detach loadbalancers, instances in group will be remove from loadbalancer's `Default Server Group`; On the contrary, When attach loadbalancers, instances in group will be added to loadbalancer's `Default Server Group`.

        > **NOTE:** When detach dbInstances, private ip of instances in group will be remove from dbInstance's `WhiteList`; On the contrary, When attach dbInstances, private ip of instances in group will be added to dbInstance's `WhiteList`.

        > **NOTE:** `on_demand_base_capacity`,`on_demand_percentage_above_base_capacity`,`spot_instance_pools`,`spot_instance_remedy` are valid only if `multi_az_policy` is 'COST_OPTIMIZED'.
        """
        return pulumi.get(self, "protected_instances")

    @protected_instances.setter
    def protected_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protected_instances", value)

    @property
    @pulumi.getter(name="removalPolicies")
    def removal_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
        - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
        - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
        - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
        - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
        """
        return pulumi.get(self, "removal_policies")

    @removal_policies.setter
    def removal_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "removal_policies", value)

    @property
    @pulumi.getter(name="scalingGroupName")
    def scaling_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
        """
        return pulumi.get(self, "scaling_group_name")

    @scaling_group_name.setter
    def scaling_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_group_name", value)

    @property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> Optional[pulumi.Input[int]]:
        """
        The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
        """
        return pulumi.get(self, "spot_instance_pools")

    @spot_instance_pools.setter
    def spot_instance_pools(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "spot_instance_pools", value)

    @property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @spot_instance_remedy.setter
    def spot_instance_remedy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "spot_instance_remedy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
        """
        warnings.warn("""Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""", DeprecationWarning)
        pulumi.log.warn("""vswitch_id is deprecated: Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""")

        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of virtual switch IDs in which the ecs instances to be launched.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vswitch_ids", value)


@pulumi.input_type
class _ScalingGroupState:
    def __init__(__self__, *,
                 db_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_cooldown: Optional[pulumi.Input[int]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 group_deletion_protection: Optional[pulumi.Input[bool]] = None,
                 group_type: Optional[pulumi.Input[str]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 launch_template_version: Optional[pulumi.Input[str]] = None,
                 loadbalancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 multi_az_policy: Optional[pulumi.Input[str]] = None,
                 on_demand_base_capacity: Optional[pulumi.Input[int]] = None,
                 on_demand_percentage_above_base_capacity: Optional[pulumi.Input[int]] = None,
                 protected_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 removal_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scaling_group_name: Optional[pulumi.Input[str]] = None,
                 spot_instance_pools: Optional[pulumi.Input[int]] = None,
                 spot_instance_remedy: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering ScalingGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_instance_ids: If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
               - The specified RDS instance must be in running status.
               - The specified RDS instance’s whitelist must have room for more IP addresses.
        :param pulumi.Input[int] default_cooldown: Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
        :param pulumi.Input[int] desired_capacity: Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
        :param pulumi.Input[bool] group_deletion_protection: Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
        :param pulumi.Input[str] group_type: Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
        :param pulumi.Input[str] health_check_type: Resource type within scaling group. Optional values: ECS, NONE. Default to ECS.
        :param pulumi.Input[str] launch_template_id: Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
        :param pulumi.Input[str] launch_template_version: The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] loadbalancer_ids: If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
               - The Server Load Balancer instance must be enabled.
               - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
               targeting your `slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
               - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
               - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
        :param pulumi.Input[int] max_size: Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
        :param pulumi.Input[int] min_size: Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
        :param pulumi.Input[str] multi_az_policy: Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, BALANCE or COST_OPTIMIZED(Available in 1.54.0+).
        :param pulumi.Input[int] on_demand_base_capacity: The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
        :param pulumi.Input[int] on_demand_percentage_above_base_capacity: Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protected_instances: Set or unset instances within group into protected status.
               
               > **NOTE:** When detach loadbalancers, instances in group will be remove from loadbalancer's `Default Server Group`; On the contrary, When attach loadbalancers, instances in group will be added to loadbalancer's `Default Server Group`.
               
               > **NOTE:** When detach dbInstances, private ip of instances in group will be remove from dbInstance's `WhiteList`; On the contrary, When attach dbInstances, private ip of instances in group will be added to dbInstance's `WhiteList`.
               
               > **NOTE:** `on_demand_base_capacity`,`on_demand_percentage_above_base_capacity`,`spot_instance_pools`,`spot_instance_remedy` are valid only if `multi_az_policy` is 'COST_OPTIMIZED'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] removal_policies: RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
               - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
               - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
               - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
               - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
        :param pulumi.Input[str] scaling_group_name: Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
        :param pulumi.Input[int] spot_instance_pools: The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
        :param pulumi.Input[bool] spot_instance_remedy: Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] vswitch_id: It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vswitch_ids: List of virtual switch IDs in which the ecs instances to be launched.
        """
        if db_instance_ids is not None:
            pulumi.set(__self__, "db_instance_ids", db_instance_ids)
        if default_cooldown is not None:
            pulumi.set(__self__, "default_cooldown", default_cooldown)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if group_deletion_protection is not None:
            pulumi.set(__self__, "group_deletion_protection", group_deletion_protection)
        if group_type is not None:
            pulumi.set(__self__, "group_type", group_type)
        if health_check_type is not None:
            pulumi.set(__self__, "health_check_type", health_check_type)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_version is not None:
            pulumi.set(__self__, "launch_template_version", launch_template_version)
        if loadbalancer_ids is not None:
            pulumi.set(__self__, "loadbalancer_ids", loadbalancer_ids)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if multi_az_policy is not None:
            pulumi.set(__self__, "multi_az_policy", multi_az_policy)
        if on_demand_base_capacity is not None:
            pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        if on_demand_percentage_above_base_capacity is not None:
            pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        if protected_instances is not None:
            pulumi.set(__self__, "protected_instances", protected_instances)
        if removal_policies is not None:
            pulumi.set(__self__, "removal_policies", removal_policies)
        if scaling_group_name is not None:
            pulumi.set(__self__, "scaling_group_name", scaling_group_name)
        if spot_instance_pools is not None:
            pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)
        if spot_instance_remedy is not None:
            pulumi.set(__self__, "spot_instance_remedy", spot_instance_remedy)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitch_id is not None:
            warnings.warn("""Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""", DeprecationWarning)
            pulumi.log.warn("""vswitch_id is deprecated: Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""")
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)
        if vswitch_ids is not None:
            pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @property
    @pulumi.getter(name="dbInstanceIds")
    def db_instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
        - The specified RDS instance must be in running status.
        - The specified RDS instance’s whitelist must have room for more IP addresses.
        """
        return pulumi.get(self, "db_instance_ids")

    @db_instance_ids.setter
    def db_instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "db_instance_ids", value)

    @property
    @pulumi.getter(name="defaultCooldown")
    def default_cooldown(self) -> Optional[pulumi.Input[int]]:
        """
        Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
        """
        return pulumi.get(self, "default_cooldown")

    @default_cooldown.setter
    def default_cooldown(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_cooldown", value)

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "desired_capacity", value)

    @property
    @pulumi.getter(name="groupDeletionProtection")
    def group_deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
        """
        return pulumi.get(self, "group_deletion_protection")

    @group_deletion_protection.setter
    def group_deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "group_deletion_protection", value)

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
        """
        return pulumi.get(self, "group_type")

    @group_type.setter
    def group_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_type", value)

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> Optional[pulumi.Input[str]]:
        """
        Resource type within scaling group. Optional values: ECS, NONE. Default to ECS.
        """
        return pulumi.get(self, "health_check_type")

    @health_check_type.setter
    def health_check_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_type", value)

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
        """
        return pulumi.get(self, "launch_template_id")

    @launch_template_id.setter
    def launch_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_id", value)

    @property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
        """
        return pulumi.get(self, "launch_template_version")

    @launch_template_version.setter
    def launch_template_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "launch_template_version", value)

    @property
    @pulumi.getter(name="loadbalancerIds")
    def loadbalancer_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
        - The Server Load Balancer instance must be enabled.
        - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
        targeting your `slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
        - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
        - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
        """
        return pulumi.get(self, "loadbalancer_ids")

    @loadbalancer_ids.setter
    def loadbalancer_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "loadbalancer_ids", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
        **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
        **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter(name="multiAzPolicy")
    def multi_az_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, BALANCE or COST_OPTIMIZED(Available in 1.54.0+).
        """
        return pulumi.get(self, "multi_az_policy")

    @multi_az_policy.setter
    def multi_az_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "multi_az_policy", value)

    @property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @on_demand_base_capacity.setter
    def on_demand_base_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "on_demand_base_capacity", value)

    @property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @on_demand_percentage_above_base_capacity.setter
    def on_demand_percentage_above_base_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "on_demand_percentage_above_base_capacity", value)

    @property
    @pulumi.getter(name="protectedInstances")
    def protected_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set or unset instances within group into protected status.

        > **NOTE:** When detach loadbalancers, instances in group will be remove from loadbalancer's `Default Server Group`; On the contrary, When attach loadbalancers, instances in group will be added to loadbalancer's `Default Server Group`.

        > **NOTE:** When detach dbInstances, private ip of instances in group will be remove from dbInstance's `WhiteList`; On the contrary, When attach dbInstances, private ip of instances in group will be added to dbInstance's `WhiteList`.

        > **NOTE:** `on_demand_base_capacity`,`on_demand_percentage_above_base_capacity`,`spot_instance_pools`,`spot_instance_remedy` are valid only if `multi_az_policy` is 'COST_OPTIMIZED'.
        """
        return pulumi.get(self, "protected_instances")

    @protected_instances.setter
    def protected_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protected_instances", value)

    @property
    @pulumi.getter(name="removalPolicies")
    def removal_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
        - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
        - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
        - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
        - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
        """
        return pulumi.get(self, "removal_policies")

    @removal_policies.setter
    def removal_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "removal_policies", value)

    @property
    @pulumi.getter(name="scalingGroupName")
    def scaling_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
        """
        return pulumi.get(self, "scaling_group_name")

    @scaling_group_name.setter
    def scaling_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_group_name", value)

    @property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> Optional[pulumi.Input[int]]:
        """
        The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
        """
        return pulumi.get(self, "spot_instance_pools")

    @spot_instance_pools.setter
    def spot_instance_pools(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "spot_instance_pools", value)

    @property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @spot_instance_remedy.setter
    def spot_instance_remedy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "spot_instance_remedy", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[str]]:
        """
        It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
        """
        warnings.warn("""Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""", DeprecationWarning)
        pulumi.log.warn("""vswitch_id is deprecated: Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""")

        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vswitch_id", value)

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of virtual switch IDs in which the ecs instances to be launched.
        """
        return pulumi.get(self, "vswitch_ids")

    @vswitch_ids.setter
    def vswitch_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vswitch_ids", value)


class ScalingGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_cooldown: Optional[pulumi.Input[int]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 group_deletion_protection: Optional[pulumi.Input[bool]] = None,
                 group_type: Optional[pulumi.Input[str]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 launch_template_version: Optional[pulumi.Input[str]] = None,
                 loadbalancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 multi_az_policy: Optional[pulumi.Input[str]] = None,
                 on_demand_base_capacity: Optional[pulumi.Input[int]] = None,
                 on_demand_percentage_above_base_capacity: Optional[pulumi.Input[int]] = None,
                 protected_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 removal_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scaling_group_name: Optional[pulumi.Input[str]] = None,
                 spot_instance_pools: Optional[pulumi.Input[int]] = None,
                 spot_instance_remedy: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a ESS scaling group resource which is a collection of ECS instances with the same application scenarios.

        It defines the maximum and minimum numbers of ECS instances in the group, and their associated Server Load Balancer instances, RDS instances, and other attributes.

        > **NOTE:** You can launch an ESS scaling group for a VPC network via specifying parameter `vswitch_ids`.

        For information about ess scaling rule, see [CreateScalingGroup](https://www.alibabacloud.com/help/en/auto-scaling/latest/createscalinggroup).

        > **NOTE:** Available since v1.39.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            cpu_core_count=2,
            memory_size=4)
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default_zones.zones[0].id,
            vswitch_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_security_group_rule = alicloud.ecs.SecurityGroupRule("defaultSecurityGroupRule",
            type="ingress",
            ip_protocol="tcp",
            nic_type="intranet",
            policy="accept",
            port_range="22/22",
            priority=1,
            security_group_id=default_security_group.id,
            cidr_ip="172.16.0.0/24")
        default2 = alicloud.vpc.Switch("default2",
            vpc_id=default_network.id,
            cidr_block="172.16.1.0/24",
            zone_id=default_zones.zones[0].id,
            vswitch_name=f"{name}-bar")
        default_scaling_group = alicloud.ess.ScalingGroup("defaultScalingGroup",
            min_size=1,
            max_size=1,
            scaling_group_name=name,
            default_cooldown=20,
            vswitch_ids=[
                default_switch.id,
                default2.id,
            ],
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ])
        ```
        ## Module Support

        You can use to the existing autoscaling module
        to create a scaling group, configuration and lifecycle hook one-click.

        ## Import

        ESS scaling group can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ess/scalingGroup:ScalingGroup example asg-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_instance_ids: If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
               - The specified RDS instance must be in running status.
               - The specified RDS instance’s whitelist must have room for more IP addresses.
        :param pulumi.Input[int] default_cooldown: Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
        :param pulumi.Input[int] desired_capacity: Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
        :param pulumi.Input[bool] group_deletion_protection: Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
        :param pulumi.Input[str] group_type: Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
        :param pulumi.Input[str] health_check_type: Resource type within scaling group. Optional values: ECS, NONE. Default to ECS.
        :param pulumi.Input[str] launch_template_id: Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
        :param pulumi.Input[str] launch_template_version: The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] loadbalancer_ids: If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
               - The Server Load Balancer instance must be enabled.
               - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
               targeting your `slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
               - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
               - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
        :param pulumi.Input[int] max_size: Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
        :param pulumi.Input[int] min_size: Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
        :param pulumi.Input[str] multi_az_policy: Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, BALANCE or COST_OPTIMIZED(Available in 1.54.0+).
        :param pulumi.Input[int] on_demand_base_capacity: The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
        :param pulumi.Input[int] on_demand_percentage_above_base_capacity: Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protected_instances: Set or unset instances within group into protected status.
               
               > **NOTE:** When detach loadbalancers, instances in group will be remove from loadbalancer's `Default Server Group`; On the contrary, When attach loadbalancers, instances in group will be added to loadbalancer's `Default Server Group`.
               
               > **NOTE:** When detach dbInstances, private ip of instances in group will be remove from dbInstance's `WhiteList`; On the contrary, When attach dbInstances, private ip of instances in group will be added to dbInstance's `WhiteList`.
               
               > **NOTE:** `on_demand_base_capacity`,`on_demand_percentage_above_base_capacity`,`spot_instance_pools`,`spot_instance_remedy` are valid only if `multi_az_policy` is 'COST_OPTIMIZED'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] removal_policies: RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
               - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
               - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
               - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
               - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
        :param pulumi.Input[str] scaling_group_name: Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
        :param pulumi.Input[int] spot_instance_pools: The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
        :param pulumi.Input[bool] spot_instance_remedy: Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] vswitch_id: It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vswitch_ids: List of virtual switch IDs in which the ecs instances to be launched.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScalingGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a ESS scaling group resource which is a collection of ECS instances with the same application scenarios.

        It defines the maximum and minimum numbers of ECS instances in the group, and their associated Server Load Balancer instances, RDS instances, and other attributes.

        > **NOTE:** You can launch an ESS scaling group for a VPC network via specifying parameter `vswitch_ids`.

        For information about ess scaling rule, see [CreateScalingGroup](https://www.alibabacloud.com/help/en/auto-scaling/latest/createscalinggroup).

        > **NOTE:** Available since v1.39.0.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default_zones = alicloud.get_zones(available_disk_category="cloud_efficiency",
            available_resource_creation="VSwitch")
        default_instance_types = alicloud.ecs.get_instance_types(availability_zone=default_zones.zones[0].id,
            cpu_core_count=2,
            memory_size=4)
        default_images = alicloud.ecs.get_images(name_regex="^ubuntu_18.*64",
            most_recent=True,
            owners="system")
        default_network = alicloud.vpc.Network("defaultNetwork",
            vpc_name=name,
            cidr_block="172.16.0.0/16")
        default_switch = alicloud.vpc.Switch("defaultSwitch",
            vpc_id=default_network.id,
            cidr_block="172.16.0.0/24",
            zone_id=default_zones.zones[0].id,
            vswitch_name=name)
        default_security_group = alicloud.ecs.SecurityGroup("defaultSecurityGroup", vpc_id=default_network.id)
        default_security_group_rule = alicloud.ecs.SecurityGroupRule("defaultSecurityGroupRule",
            type="ingress",
            ip_protocol="tcp",
            nic_type="intranet",
            policy="accept",
            port_range="22/22",
            priority=1,
            security_group_id=default_security_group.id,
            cidr_ip="172.16.0.0/24")
        default2 = alicloud.vpc.Switch("default2",
            vpc_id=default_network.id,
            cidr_block="172.16.1.0/24",
            zone_id=default_zones.zones[0].id,
            vswitch_name=f"{name}-bar")
        default_scaling_group = alicloud.ess.ScalingGroup("defaultScalingGroup",
            min_size=1,
            max_size=1,
            scaling_group_name=name,
            default_cooldown=20,
            vswitch_ids=[
                default_switch.id,
                default2.id,
            ],
            removal_policies=[
                "OldestInstance",
                "NewestInstance",
            ])
        ```
        ## Module Support

        You can use to the existing autoscaling module
        to create a scaling group, configuration and lifecycle hook one-click.

        ## Import

        ESS scaling group can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ess/scalingGroup:ScalingGroup example asg-abc123456
        ```

        :param str resource_name: The name of the resource.
        :param ScalingGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScalingGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 default_cooldown: Optional[pulumi.Input[int]] = None,
                 desired_capacity: Optional[pulumi.Input[int]] = None,
                 group_deletion_protection: Optional[pulumi.Input[bool]] = None,
                 group_type: Optional[pulumi.Input[str]] = None,
                 health_check_type: Optional[pulumi.Input[str]] = None,
                 launch_template_id: Optional[pulumi.Input[str]] = None,
                 launch_template_version: Optional[pulumi.Input[str]] = None,
                 loadbalancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 multi_az_policy: Optional[pulumi.Input[str]] = None,
                 on_demand_base_capacity: Optional[pulumi.Input[int]] = None,
                 on_demand_percentage_above_base_capacity: Optional[pulumi.Input[int]] = None,
                 protected_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 removal_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scaling_group_name: Optional[pulumi.Input[str]] = None,
                 spot_instance_pools: Optional[pulumi.Input[int]] = None,
                 spot_instance_remedy: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 vswitch_id: Optional[pulumi.Input[str]] = None,
                 vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScalingGroupArgs.__new__(ScalingGroupArgs)

            __props__.__dict__["db_instance_ids"] = db_instance_ids
            __props__.__dict__["default_cooldown"] = default_cooldown
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["group_deletion_protection"] = group_deletion_protection
            __props__.__dict__["group_type"] = group_type
            __props__.__dict__["health_check_type"] = health_check_type
            __props__.__dict__["launch_template_id"] = launch_template_id
            __props__.__dict__["launch_template_version"] = launch_template_version
            __props__.__dict__["loadbalancer_ids"] = loadbalancer_ids
            if max_size is None and not opts.urn:
                raise TypeError("Missing required property 'max_size'")
            __props__.__dict__["max_size"] = max_size
            if min_size is None and not opts.urn:
                raise TypeError("Missing required property 'min_size'")
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["multi_az_policy"] = multi_az_policy
            __props__.__dict__["on_demand_base_capacity"] = on_demand_base_capacity
            __props__.__dict__["on_demand_percentage_above_base_capacity"] = on_demand_percentage_above_base_capacity
            __props__.__dict__["protected_instances"] = protected_instances
            __props__.__dict__["removal_policies"] = removal_policies
            __props__.__dict__["scaling_group_name"] = scaling_group_name
            __props__.__dict__["spot_instance_pools"] = spot_instance_pools
            __props__.__dict__["spot_instance_remedy"] = spot_instance_remedy
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["vswitch_ids"] = vswitch_ids
        super(ScalingGroup, __self__).__init__(
            'alicloud:ess/scalingGroup:ScalingGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            db_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            default_cooldown: Optional[pulumi.Input[int]] = None,
            desired_capacity: Optional[pulumi.Input[int]] = None,
            group_deletion_protection: Optional[pulumi.Input[bool]] = None,
            group_type: Optional[pulumi.Input[str]] = None,
            health_check_type: Optional[pulumi.Input[str]] = None,
            launch_template_id: Optional[pulumi.Input[str]] = None,
            launch_template_version: Optional[pulumi.Input[str]] = None,
            loadbalancer_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            max_size: Optional[pulumi.Input[int]] = None,
            min_size: Optional[pulumi.Input[int]] = None,
            multi_az_policy: Optional[pulumi.Input[str]] = None,
            on_demand_base_capacity: Optional[pulumi.Input[int]] = None,
            on_demand_percentage_above_base_capacity: Optional[pulumi.Input[int]] = None,
            protected_instances: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            removal_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            scaling_group_name: Optional[pulumi.Input[str]] = None,
            spot_instance_pools: Optional[pulumi.Input[int]] = None,
            spot_instance_remedy: Optional[pulumi.Input[bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            vswitch_id: Optional[pulumi.Input[str]] = None,
            vswitch_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'ScalingGroup':
        """
        Get an existing ScalingGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_instance_ids: If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
               - The specified RDS instance must be in running status.
               - The specified RDS instance’s whitelist must have room for more IP addresses.
        :param pulumi.Input[int] default_cooldown: Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
        :param pulumi.Input[int] desired_capacity: Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
        :param pulumi.Input[bool] group_deletion_protection: Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
        :param pulumi.Input[str] group_type: Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
        :param pulumi.Input[str] health_check_type: Resource type within scaling group. Optional values: ECS, NONE. Default to ECS.
        :param pulumi.Input[str] launch_template_id: Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
        :param pulumi.Input[str] launch_template_version: The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] loadbalancer_ids: If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
               - The Server Load Balancer instance must be enabled.
               - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
               targeting your `slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
               - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
               - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
        :param pulumi.Input[int] max_size: Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
        :param pulumi.Input[int] min_size: Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
               **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
        :param pulumi.Input[str] multi_az_policy: Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, BALANCE or COST_OPTIMIZED(Available in 1.54.0+).
        :param pulumi.Input[int] on_demand_base_capacity: The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
        :param pulumi.Input[int] on_demand_percentage_above_base_capacity: Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protected_instances: Set or unset instances within group into protected status.
               
               > **NOTE:** When detach loadbalancers, instances in group will be remove from loadbalancer's `Default Server Group`; On the contrary, When attach loadbalancers, instances in group will be added to loadbalancer's `Default Server Group`.
               
               > **NOTE:** When detach dbInstances, private ip of instances in group will be remove from dbInstance's `WhiteList`; On the contrary, When attach dbInstances, private ip of instances in group will be added to dbInstance's `WhiteList`.
               
               > **NOTE:** `on_demand_base_capacity`,`on_demand_percentage_above_base_capacity`,`spot_instance_pools`,`spot_instance_remedy` are valid only if `multi_az_policy` is 'COST_OPTIMIZED'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] removal_policies: RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
               - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
               - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
               - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
               - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
        :param pulumi.Input[str] scaling_group_name: Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
        :param pulumi.Input[int] spot_instance_pools: The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
        :param pulumi.Input[bool] spot_instance_remedy: Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
               - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
               - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        :param pulumi.Input[str] vswitch_id: It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vswitch_ids: List of virtual switch IDs in which the ecs instances to be launched.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScalingGroupState.__new__(_ScalingGroupState)

        __props__.__dict__["db_instance_ids"] = db_instance_ids
        __props__.__dict__["default_cooldown"] = default_cooldown
        __props__.__dict__["desired_capacity"] = desired_capacity
        __props__.__dict__["group_deletion_protection"] = group_deletion_protection
        __props__.__dict__["group_type"] = group_type
        __props__.__dict__["health_check_type"] = health_check_type
        __props__.__dict__["launch_template_id"] = launch_template_id
        __props__.__dict__["launch_template_version"] = launch_template_version
        __props__.__dict__["loadbalancer_ids"] = loadbalancer_ids
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["min_size"] = min_size
        __props__.__dict__["multi_az_policy"] = multi_az_policy
        __props__.__dict__["on_demand_base_capacity"] = on_demand_base_capacity
        __props__.__dict__["on_demand_percentage_above_base_capacity"] = on_demand_percentage_above_base_capacity
        __props__.__dict__["protected_instances"] = protected_instances
        __props__.__dict__["removal_policies"] = removal_policies
        __props__.__dict__["scaling_group_name"] = scaling_group_name
        __props__.__dict__["spot_instance_pools"] = spot_instance_pools
        __props__.__dict__["spot_instance_remedy"] = spot_instance_remedy
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vswitch_id"] = vswitch_id
        __props__.__dict__["vswitch_ids"] = vswitch_ids
        return ScalingGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dbInstanceIds")
    def db_instance_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        If an RDS instance is specified in the scaling group, the scaling group automatically attaches the Intranet IP addresses of its ECS instances to the RDS access whitelist.
        - The specified RDS instance must be in running status.
        - The specified RDS instance’s whitelist must have room for more IP addresses.
        """
        return pulumi.get(self, "db_instance_ids")

    @property
    @pulumi.getter(name="defaultCooldown")
    def default_cooldown(self) -> pulumi.Output[Optional[int]]:
        """
        Default cool-down time (in seconds) of the scaling group. Value range: [0, 86400]. The default value is 300s.
        """
        return pulumi.get(self, "default_cooldown")

    @property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Output[Optional[int]]:
        """
        Expected number of ECS instances in the scaling group. Value range: [min_size, max_size].
        """
        return pulumi.get(self, "desired_capacity")

    @property
    @pulumi.getter(name="groupDeletionProtection")
    def group_deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether the scaling group deletion protection is enabled. `true` or `false`, Default value: `false`.
        """
        return pulumi.get(self, "group_deletion_protection")

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> pulumi.Output[str]:
        """
        Resource type within scaling group. Optional values: ECS, ECI. Default to ECS.
        """
        return pulumi.get(self, "group_type")

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> pulumi.Output[str]:
        """
        Resource type within scaling group. Optional values: ECS, NONE. Default to ECS.
        """
        return pulumi.get(self, "health_check_type")

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> pulumi.Output[Optional[str]]:
        """
        Instance launch template ID, scaling group obtains launch configuration from instance launch template, see [Launch Template](https://www.alibabacloud.com/help/doc-detail/73916.html). Creating scaling group from launch template enable group automatically.
        """
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateVersion")
    def launch_template_version(self) -> pulumi.Output[Optional[str]]:
        """
        The version number of the launch template. Valid values are the version number, `Latest`, or `Default`, Default value: `Default`.
        """
        return pulumi.get(self, "launch_template_version")

    @property
    @pulumi.getter(name="loadbalancerIds")
    def loadbalancer_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        If a Server Load Balancer instance is specified in the scaling group, the scaling group automatically attaches its ECS instances to the Server Load Balancer instance.
        - The Server Load Balancer instance must be enabled.
        - At least one listener must be configured for each Server Load Balancer and it HealthCheck must be on. Otherwise, creation will fail (it may be useful to add a `depends_on` argument
        targeting your `slb.Listener` in order to make sure the listener with its HealthCheck configuration is ready before creating your scaling group).
        - The Server Load Balancer instance attached with VPC-type ECS instances cannot be attached to the scaling group.
        - The default weight of an ECS instance attached to the Server Load Balancer instance is 50.
        """
        return pulumi.get(self, "loadbalancer_ids")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[int]:
        """
        Maximum number of ECS instances in the scaling group. Value range: [0, 2000].
        **NOTE:** From version 1.204.1, `max_size` can be set to `2000`.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[int]:
        """
        Minimum number of ECS instances in the scaling group. Value range: [0, 2000].
        **NOTE:** From version 1.204.1, `min_size` can be set to `2000`.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="multiAzPolicy")
    def multi_az_policy(self) -> pulumi.Output[Optional[str]]:
        """
        Multi-AZ scaling group ECS instance expansion and contraction strategy. PRIORITY, BALANCE or COST_OPTIMIZED(Available in 1.54.0+).
        """
        return pulumi.get(self, "multi_az_policy")

    @property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> pulumi.Output[int]:
        """
        The minimum amount of the Auto Scaling group's capacity that must be fulfilled by On-Demand Instances. This base portion is provisioned first as your group scales.
        """
        return pulumi.get(self, "on_demand_base_capacity")

    @property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> pulumi.Output[int]:
        """
        Controls the percentages of On-Demand Instances and Spot Instances for your additional capacity beyond OnDemandBaseCapacity.
        """
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @property
    @pulumi.getter(name="protectedInstances")
    def protected_instances(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Set or unset instances within group into protected status.

        > **NOTE:** When detach loadbalancers, instances in group will be remove from loadbalancer's `Default Server Group`; On the contrary, When attach loadbalancers, instances in group will be added to loadbalancer's `Default Server Group`.

        > **NOTE:** When detach dbInstances, private ip of instances in group will be remove from dbInstance's `WhiteList`; On the contrary, When attach dbInstances, private ip of instances in group will be added to dbInstance's `WhiteList`.

        > **NOTE:** `on_demand_base_capacity`,`on_demand_percentage_above_base_capacity`,`spot_instance_pools`,`spot_instance_remedy` are valid only if `multi_az_policy` is 'COST_OPTIMIZED'.
        """
        return pulumi.get(self, "protected_instances")

    @property
    @pulumi.getter(name="removalPolicies")
    def removal_policies(self) -> pulumi.Output[Sequence[str]]:
        """
        RemovalPolicy is used to select the ECS instances you want to remove from the scaling group when multiple candidates for removal exist. Optional values:
        - OldestInstance: removes the ECS instance that is added to the scaling group at the earliest point in time.
        - NewestInstance: removes the ECS instance that is added to the scaling group at the latest point in time.
        - OldestScalingConfiguration: removes the ECS instance that is created based on the earliest scaling configuration.
        - Default values: Default value of RemovalPolicy.1: OldestScalingConfiguration. Default value of RemovalPolicy.2: OldestInstance.
        """
        return pulumi.get(self, "removal_policies")

    @property
    @pulumi.getter(name="scalingGroupName")
    def scaling_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name shown for the scaling group, which must contain 2-64 characters (English or Chinese), starting with numbers, English letters or Chinese characters, and can contain numbers, underscores `_`, hyphens `-`, and decimal points `.`. If this parameter is not specified, the default value is ScalingGroupId.
        """
        return pulumi.get(self, "scaling_group_name")

    @property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> pulumi.Output[int]:
        """
        The number of Spot pools to use to allocate your Spot capacity. The Spot pools is composed of instance types of lowest price.
        """
        return pulumi.get(self, "spot_instance_pools")

    @property
    @pulumi.getter(name="spotInstanceRemedy")
    def spot_instance_remedy(self) -> pulumi.Output[bool]:
        """
        Whether to replace spot instances with newly created spot/onDemand instance when receive a spot recycling message.
        """
        return pulumi.get(self, "spot_instance_remedy")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        - Key: It can be up to 64 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It cannot be a null string.
        - Value: It can be up to 128 characters in length. It cannot begin with "aliyun", "acs:", "http://", or "https://". It can be a null string.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[str]]:
        """
        It has been deprecated from version 1.7.1 and new field 'vswitch_ids' replaces it.
        """
        warnings.warn("""Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""", DeprecationWarning)
        pulumi.log.warn("""vswitch_id is deprecated: Field 'vswitch_id' has been deprecated from provider version 1.7.1, and new field 'vswitch_ids' can replace it.""")

        return pulumi.get(self, "vswitch_id")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of virtual switch IDs in which the ecs instances to be launched.
        """
        return pulumi.get(self, "vswitch_ids")

