# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ApiDestinationHttpApiParameters',
    'ConnectionAuthParameters',
    'ConnectionAuthParametersApiKeyAuthParameters',
    'ConnectionAuthParametersBasicAuthParameters',
    'ConnectionAuthParametersOauthParameters',
    'ConnectionAuthParametersOauthParametersClientParameters',
    'ConnectionAuthParametersOauthParametersOauthHttpParameters',
    'ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter',
    'ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter',
    'ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter',
    'ConnectionNetworkParameters',
    'RuleTarget',
    'RuleTargetDeadLetterQueue',
    'RuleTargetParamList',
    'GetEventBusesBusResult',
    'GetEventSourcesSourceResult',
    'GetRulesRuleResult',
    'GetRulesRuleTargetResult',
]

@pulumi.output_type
class ApiDestinationHttpApiParameters(dict):
    def __init__(__self__, *,
                 endpoint: str,
                 method: str):
        """
        :param str endpoint: The endpoint of the API destination.
        :param str method: The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "method", method)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The endpoint of the API destination.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
        """
        return pulumi.get(self, "method")


@pulumi.output_type
class ConnectionAuthParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKeyAuthParameters":
            suggest = "api_key_auth_parameters"
        elif key == "authorizationType":
            suggest = "authorization_type"
        elif key == "basicAuthParameters":
            suggest = "basic_auth_parameters"
        elif key == "oauthParameters":
            suggest = "oauth_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key_auth_parameters: Optional['outputs.ConnectionAuthParametersApiKeyAuthParameters'] = None,
                 authorization_type: Optional[str] = None,
                 basic_auth_parameters: Optional['outputs.ConnectionAuthParametersBasicAuthParameters'] = None,
                 oauth_parameters: Optional['outputs.ConnectionAuthParametersOauthParameters'] = None):
        """
        :param 'ConnectionAuthParametersApiKeyAuthParametersArgs' api_key_auth_parameters: The parameters that are configured for API key authentication. See `api_key_auth_parameters` below.
        :param str authorization_type: The type of the authentication. Valid values: `API_KEY_AUTH`, `BASIC_AUTH`, `OAUTH_AUTH`.
        :param 'ConnectionAuthParametersBasicAuthParametersArgs' basic_auth_parameters: The parameters that are configured for basic authentication. See `basic_auth_parameters` below.
        :param 'ConnectionAuthParametersOauthParametersArgs' oauth_parameters: The parameters that are configured for OAuth authentication. See `oauth_parameters` below.
        """
        if api_key_auth_parameters is not None:
            pulumi.set(__self__, "api_key_auth_parameters", api_key_auth_parameters)
        if authorization_type is not None:
            pulumi.set(__self__, "authorization_type", authorization_type)
        if basic_auth_parameters is not None:
            pulumi.set(__self__, "basic_auth_parameters", basic_auth_parameters)
        if oauth_parameters is not None:
            pulumi.set(__self__, "oauth_parameters", oauth_parameters)

    @property
    @pulumi.getter(name="apiKeyAuthParameters")
    def api_key_auth_parameters(self) -> Optional['outputs.ConnectionAuthParametersApiKeyAuthParameters']:
        """
        The parameters that are configured for API key authentication. See `api_key_auth_parameters` below.
        """
        return pulumi.get(self, "api_key_auth_parameters")

    @property
    @pulumi.getter(name="authorizationType")
    def authorization_type(self) -> Optional[str]:
        """
        The type of the authentication. Valid values: `API_KEY_AUTH`, `BASIC_AUTH`, `OAUTH_AUTH`.
        """
        return pulumi.get(self, "authorization_type")

    @property
    @pulumi.getter(name="basicAuthParameters")
    def basic_auth_parameters(self) -> Optional['outputs.ConnectionAuthParametersBasicAuthParameters']:
        """
        The parameters that are configured for basic authentication. See `basic_auth_parameters` below.
        """
        return pulumi.get(self, "basic_auth_parameters")

    @property
    @pulumi.getter(name="oauthParameters")
    def oauth_parameters(self) -> Optional['outputs.ConnectionAuthParametersOauthParameters']:
        """
        The parameters that are configured for OAuth authentication. See `oauth_parameters` below.
        """
        return pulumi.get(self, "oauth_parameters")


@pulumi.output_type
class ConnectionAuthParametersApiKeyAuthParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "apiKeyName":
            suggest = "api_key_name"
        elif key == "apiKeyValue":
            suggest = "api_key_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParametersApiKeyAuthParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParametersApiKeyAuthParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParametersApiKeyAuthParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 api_key_name: Optional[str] = None,
                 api_key_value: Optional[str] = None):
        """
        :param str api_key_name: The name of the API key.
        :param str api_key_value: The value of the API key.
        """
        if api_key_name is not None:
            pulumi.set(__self__, "api_key_name", api_key_name)
        if api_key_value is not None:
            pulumi.set(__self__, "api_key_value", api_key_value)

    @property
    @pulumi.getter(name="apiKeyName")
    def api_key_name(self) -> Optional[str]:
        """
        The name of the API key.
        """
        return pulumi.get(self, "api_key_name")

    @property
    @pulumi.getter(name="apiKeyValue")
    def api_key_value(self) -> Optional[str]:
        """
        The value of the API key.
        """
        return pulumi.get(self, "api_key_value")


@pulumi.output_type
class ConnectionAuthParametersBasicAuthParameters(dict):
    def __init__(__self__, *,
                 password: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str password: The password for basic authentication.
        :param str username: The username for basic authentication.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password for basic authentication.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username for basic authentication.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ConnectionAuthParametersOauthParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "clientParameters":
            suggest = "client_parameters"
        elif key == "httpMethod":
            suggest = "http_method"
        elif key == "oauthHttpParameters":
            suggest = "oauth_http_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParametersOauthParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParametersOauthParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParametersOauthParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_endpoint: Optional[str] = None,
                 client_parameters: Optional['outputs.ConnectionAuthParametersOauthParametersClientParameters'] = None,
                 http_method: Optional[str] = None,
                 oauth_http_parameters: Optional['outputs.ConnectionAuthParametersOauthParametersOauthHttpParameters'] = None):
        """
        :param str authorization_endpoint: The IP address of the authorized endpoint.
        :param 'ConnectionAuthParametersOauthParametersClientParametersArgs' client_parameters: The parameters that are configured for the client. See `client_parameters` below.
        :param str http_method: The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
        :param 'ConnectionAuthParametersOauthParametersOauthHttpParametersArgs' oauth_http_parameters: The request parameters that are configured for OAuth authentication. See `oauth_http_parameters` below.
        """
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if client_parameters is not None:
            pulumi.set(__self__, "client_parameters", client_parameters)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if oauth_http_parameters is not None:
            pulumi.set(__self__, "oauth_http_parameters", oauth_http_parameters)

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        The IP address of the authorized endpoint.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="clientParameters")
    def client_parameters(self) -> Optional['outputs.ConnectionAuthParametersOauthParametersClientParameters']:
        """
        The parameters that are configured for the client. See `client_parameters` below.
        """
        return pulumi.get(self, "client_parameters")

    @property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[str]:
        """
        The HTTP request method. Valid values: `GET`, `POST`, `HEAD`, `DELETE`, `PUT`, `PATCH`.
        """
        return pulumi.get(self, "http_method")

    @property
    @pulumi.getter(name="oauthHttpParameters")
    def oauth_http_parameters(self) -> Optional['outputs.ConnectionAuthParametersOauthParametersOauthHttpParameters']:
        """
        The request parameters that are configured for OAuth authentication. See `oauth_http_parameters` below.
        """
        return pulumi.get(self, "oauth_http_parameters")


@pulumi.output_type
class ConnectionAuthParametersOauthParametersClientParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParametersOauthParametersClientParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParametersOauthParametersClientParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParametersOauthParametersClientParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[str] = None,
                 client_secret: Optional[str] = None):
        """
        :param str client_id: The ID of the client.
        :param str client_secret: The AccessKey secret of the client.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The ID of the client.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[str]:
        """
        The AccessKey secret of the client.
        """
        return pulumi.get(self, "client_secret")


@pulumi.output_type
class ConnectionAuthParametersOauthParametersOauthHttpParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bodyParameters":
            suggest = "body_parameters"
        elif key == "headerParameters":
            suggest = "header_parameters"
        elif key == "queryStringParameters":
            suggest = "query_string_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParametersOauthParametersOauthHttpParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 body_parameters: Optional[Sequence['outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter']] = None,
                 header_parameters: Optional[Sequence['outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter']] = None,
                 query_string_parameters: Optional[Sequence['outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter']] = None):
        """
        :param Sequence['ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameterArgs'] body_parameters: The parameters that are configured for the request body. See `body_parameters` below.
        :param Sequence['ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameterArgs'] header_parameters: The parameters that are configured for the request header. See `header_parameters` below.
        :param Sequence['ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameterArgs'] query_string_parameters: The parameters that are configured for the request path. See `query_string_parameters` below.
        """
        if body_parameters is not None:
            pulumi.set(__self__, "body_parameters", body_parameters)
        if header_parameters is not None:
            pulumi.set(__self__, "header_parameters", header_parameters)
        if query_string_parameters is not None:
            pulumi.set(__self__, "query_string_parameters", query_string_parameters)

    @property
    @pulumi.getter(name="bodyParameters")
    def body_parameters(self) -> Optional[Sequence['outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter']]:
        """
        The parameters that are configured for the request body. See `body_parameters` below.
        """
        return pulumi.get(self, "body_parameters")

    @property
    @pulumi.getter(name="headerParameters")
    def header_parameters(self) -> Optional[Sequence['outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter']]:
        """
        The parameters that are configured for the request header. See `header_parameters` below.
        """
        return pulumi.get(self, "header_parameters")

    @property
    @pulumi.getter(name="queryStringParameters")
    def query_string_parameters(self) -> Optional[Sequence['outputs.ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter']]:
        """
        The parameters that are configured for the request path. See `query_string_parameters` below.
        """
        return pulumi.get(self, "query_string_parameters")


@pulumi.output_type
class ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isValueSecret":
            suggest = "is_value_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParametersBodyParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_value_secret: Optional[str] = None,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str is_value_secret: Specifies whether to enable authentication.
        :param str key: The key of the request path.
        :param str value: The key of the request path.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[str]:
        """
        Specifies whether to enable authentication.
        """
        return pulumi.get(self, "is_value_secret")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The key of the request path.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The key of the request path.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isValueSecret":
            suggest = "is_value_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParametersHeaderParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_value_secret: Optional[str] = None,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str is_value_secret: Specifies whether to enable authentication.
        :param str key: The key of the request path.
        :param str value: The key of the request path.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[str]:
        """
        Specifies whether to enable authentication.
        """
        return pulumi.get(self, "is_value_secret")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The key of the request path.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The key of the request path.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isValueSecret":
            suggest = "is_value_secret"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionAuthParametersOauthParametersOauthHttpParametersQueryStringParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_value_secret: Optional[str] = None,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str is_value_secret: Specifies whether to enable authentication.
        :param str key: The key of the request path.
        :param str value: The key of the request path.
        """
        if is_value_secret is not None:
            pulumi.set(__self__, "is_value_secret", is_value_secret)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="isValueSecret")
    def is_value_secret(self) -> Optional[str]:
        """
        Specifies whether to enable authentication.
        """
        return pulumi.get(self, "is_value_secret")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The key of the request path.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The key of the request path.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ConnectionNetworkParameters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkType":
            suggest = "network_type"
        elif key == "securityGroupId":
            suggest = "security_group_id"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "vswitcheId":
            suggest = "vswitche_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConnectionNetworkParameters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConnectionNetworkParameters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConnectionNetworkParameters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_type: str,
                 security_group_id: Optional[str] = None,
                 vpc_id: Optional[str] = None,
                 vswitche_id: Optional[str] = None):
        """
        :param str network_type: The network type. Valid values: `PublicNetwork`, `PrivateNetwork`. **NOTE:** If you set `network_type` to `PrivateNetwork`, you must configure `vpc_id`, `vswitche_id`, and `security_group_id`.
        :param str security_group_id: The ID of the security group.
        :param str vpc_id: The ID of the VPC.
        :param str vswitche_id: The ID of the VSwitch.
        """
        pulumi.set(__self__, "network_type", network_type)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitche_id is not None:
            pulumi.set(__self__, "vswitche_id", vswitche_id)

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        The network type. Valid values: `PublicNetwork`, `PrivateNetwork`. **NOTE:** If you set `network_type` to `PrivateNetwork`, you must configure `vpc_id`, `vswitche_id`, and `security_group_id`.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[str]:
        """
        The ID of the security group.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The ID of the VPC.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitcheId")
    def vswitche_id(self) -> Optional[str]:
        """
        The ID of the VSwitch.
        """
        return pulumi.get(self, "vswitche_id")


@pulumi.output_type
class RuleTarget(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "paramLists":
            suggest = "param_lists"
        elif key == "targetId":
            suggest = "target_id"
        elif key == "deadLetterQueue":
            suggest = "dead_letter_queue"
        elif key == "pushRetryStrategy":
            suggest = "push_retry_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleTarget. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleTarget.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleTarget.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint: str,
                 param_lists: Sequence['outputs.RuleTargetParamList'],
                 target_id: str,
                 type: str,
                 dead_letter_queue: Optional['outputs.RuleTargetDeadLetterQueue'] = None,
                 push_retry_strategy: Optional[str] = None):
        """
        :param str endpoint: The endpoint of target.
        :param Sequence['RuleTargetParamListArgs'] param_lists: A list of param. See `param_list` below.
        :param str target_id: The ID of target.
        :param str type: The type of target. Valid values: `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.dingtalk`, `acs.eventbridge`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fc.function`, `acs.fnf`, `acs.k8s`, `acs.mail`, `acs.mns.queue`, `acs.mns.topic`, `acs.openapi`, `acs.rabbitmq`, `acs.rds.mysql`, `acs.rocketmq`, `acs.sae`, `acs.sls`, `acs.sms`, `http`,`https` and `mysql`.
               **NOTE:** From version 1.208.1, `type` can be set to `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fnf`, `acs.k8s`, `acs.openapi`, `acs.rds.mysql`, `acs.sae`, `acs.sls`, `mysql`.
        :param 'RuleTargetDeadLetterQueueArgs' dead_letter_queue: Dead letter queue. Events that are not processed or exceed the number of retries will be written to the dead letter. Support message service MNS and message queue RocketMQ. See `dead_letter_queue` below.
        :param str push_retry_strategy: The retry policy that is used to push the event. Valid values:
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "param_lists", param_lists)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "type", type)
        if dead_letter_queue is not None:
            pulumi.set(__self__, "dead_letter_queue", dead_letter_queue)
        if push_retry_strategy is not None:
            pulumi.set(__self__, "push_retry_strategy", push_retry_strategy)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The endpoint of target.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="paramLists")
    def param_lists(self) -> Sequence['outputs.RuleTargetParamList']:
        """
        A list of param. See `param_list` below.
        """
        return pulumi.get(self, "param_lists")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The ID of target.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of target. Valid values: `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.dingtalk`, `acs.eventbridge`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fc.function`, `acs.fnf`, `acs.k8s`, `acs.mail`, `acs.mns.queue`, `acs.mns.topic`, `acs.openapi`, `acs.rabbitmq`, `acs.rds.mysql`, `acs.rocketmq`, `acs.sae`, `acs.sls`, `acs.sms`, `http`,`https` and `mysql`.
        **NOTE:** From version 1.208.1, `type` can be set to `acs.alikafka`, `acs.api.destination`, `acs.arms.loki`, `acs.datahub`, `acs.eventbridge.olap`, `acs.eventbus.SLSCloudLens`, `acs.fnf`, `acs.k8s`, `acs.openapi`, `acs.rds.mysql`, `acs.sae`, `acs.sls`, `mysql`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="deadLetterQueue")
    def dead_letter_queue(self) -> Optional['outputs.RuleTargetDeadLetterQueue']:
        """
        Dead letter queue. Events that are not processed or exceed the number of retries will be written to the dead letter. Support message service MNS and message queue RocketMQ. See `dead_letter_queue` below.
        """
        return pulumi.get(self, "dead_letter_queue")

    @property
    @pulumi.getter(name="pushRetryStrategy")
    def push_retry_strategy(self) -> Optional[str]:
        """
        The retry policy that is used to push the event. Valid values:
        """
        return pulumi.get(self, "push_retry_strategy")


@pulumi.output_type
class RuleTargetDeadLetterQueue(dict):
    def __init__(__self__, *,
                 arn: Optional[str] = None):
        """
        :param str arn: The srn of the dead letter queue.
        """
        if arn is not None:
            pulumi.set(__self__, "arn", arn)

    @property
    @pulumi.getter
    def arn(self) -> Optional[str]:
        """
        The srn of the dead letter queue.
        """
        return pulumi.get(self, "arn")


@pulumi.output_type
class RuleTargetParamList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceKey":
            suggest = "resource_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleTargetParamList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleTargetParamList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleTargetParamList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 form: str,
                 resource_key: str,
                 template: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str form: The format of param. Valid values: `ORIGINAL`, `TEMPLATE`, `JSONPATH`, `CONSTANT`.
        :param str resource_key: The resource key of param.  For more information, see [Event target parameters](https://www.alibabacloud.com/help/en/eventbridge/latest/event-target-parameters)
        :param str template: The template of param.
        :param str value: The value of param.
               
               > **NOTE:** There exists a potential diff error that the backend service will return a default param as following:
               
               ```python
               import pulumi
               ```
               
               In order to fix the diff, from version 1.160.0,
               this resource has removed the param which `resource_key = "IsBase64Encode"` and `value = "false"`.
               If you want to set `resource_key = "IsBase64Encode"`, please avoid to set `value = "false"`.
        """
        pulumi.set(__self__, "form", form)
        pulumi.set(__self__, "resource_key", resource_key)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def form(self) -> str:
        """
        The format of param. Valid values: `ORIGINAL`, `TEMPLATE`, `JSONPATH`, `CONSTANT`.
        """
        return pulumi.get(self, "form")

    @property
    @pulumi.getter(name="resourceKey")
    def resource_key(self) -> str:
        """
        The resource key of param.  For more information, see [Event target parameters](https://www.alibabacloud.com/help/en/eventbridge/latest/event-target-parameters)
        """
        return pulumi.get(self, "resource_key")

    @property
    @pulumi.getter
    def template(self) -> Optional[str]:
        """
        The template of param.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of param.

        > **NOTE:** There exists a potential diff error that the backend service will return a default param as following:

        ```python
        import pulumi
        ```

        In order to fix the diff, from version 1.160.0,
        this resource has removed the param which `resource_key = "IsBase64Encode"` and `value = "false"`.
        If you want to set `resource_key = "IsBase64Encode"`, please avoid to set `value = "false"`.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetEventBusesBusResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 description: str,
                 event_bus_name: str,
                 id: str):
        """
        :param str create_time: The time of this bus was created.
        :param str description: The description of event bus.
        :param str event_bus_name: The name of event bus.
        :param str id: The ID of the Event Bus. Its value is same as Queue Name.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "event_bus_name", event_bus_name)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time of this bus was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of event bus.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventBusName")
    def event_bus_name(self) -> str:
        """
        The name of event bus.
        """
        return pulumi.get(self, "event_bus_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Event Bus. Its value is same as Queue Name.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetEventSourcesSourceResult(dict):
    def __init__(__self__, *,
                 description: str,
                 event_source_name: str,
                 external_source_config: Mapping[str, Any],
                 external_source_type: str,
                 id: str,
                 linked_external_source: bool,
                 type: str):
        """
        :param str description: The detail describe of event source.
        :param str event_source_name: The code name of event source.
        :param Mapping[str, Any] external_source_config: The config of external data source.
        :param str external_source_type: The type of external data source.
        :param str id: The ID of the Event Source.
        :param bool linked_external_source: Whether to connect to an external data source.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "event_source_name", event_source_name)
        pulumi.set(__self__, "external_source_config", external_source_config)
        pulumi.set(__self__, "external_source_type", external_source_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "linked_external_source", linked_external_source)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The detail describe of event source.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventSourceName")
    def event_source_name(self) -> str:
        """
        The code name of event source.
        """
        return pulumi.get(self, "event_source_name")

    @property
    @pulumi.getter(name="externalSourceConfig")
    def external_source_config(self) -> Mapping[str, Any]:
        """
        The config of external data source.
        """
        return pulumi.get(self, "external_source_config")

    @property
    @pulumi.getter(name="externalSourceType")
    def external_source_type(self) -> str:
        """
        The type of external data source.
        """
        return pulumi.get(self, "external_source_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Event Source.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="linkedExternalSource")
    def linked_external_source(self) -> bool:
        """
        Whether to connect to an external data source.
        """
        return pulumi.get(self, "linked_external_source")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRulesRuleResult(dict):
    def __init__(__self__, *,
                 description: str,
                 event_bus_name: str,
                 filter_pattern: str,
                 id: str,
                 rule_name: str,
                 status: str,
                 targets: Sequence['outputs.GetRulesRuleTargetResult']):
        """
        :param str description: The description of rule.
        :param str event_bus_name: The name of event bus.
        :param str filter_pattern: The pattern to match interested events.
        :param str id: The ID of the Rule.
        :param str rule_name: The name of rule.
        :param str status: Rule status, either Enable or Disable.
        :param Sequence['GetRulesRuleTargetArgs'] targets: The target for rule.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "event_bus_name", event_bus_name)
        pulumi.set(__self__, "filter_pattern", filter_pattern)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "targets", targets)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventBusName")
    def event_bus_name(self) -> str:
        """
        The name of event bus.
        """
        return pulumi.get(self, "event_bus_name")

    @property
    @pulumi.getter(name="filterPattern")
    def filter_pattern(self) -> str:
        """
        The pattern to match interested events.
        """
        return pulumi.get(self, "filter_pattern")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> str:
        """
        The name of rule.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Rule status, either Enable or Disable.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def targets(self) -> Sequence['outputs.GetRulesRuleTargetResult']:
        """
        The target for rule.
        """
        return pulumi.get(self, "targets")


@pulumi.output_type
class GetRulesRuleTargetResult(dict):
    def __init__(__self__, *,
                 endpoint: str,
                 target_id: str,
                 type: str):
        """
        :param str endpoint: The endpoint.
        :param str target_id: The id of target.
        :param str type: The type of target.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "target_id", target_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def endpoint(self) -> str:
        """
        The endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The id of target.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of target.
        """
        return pulumi.get(self, "type")


