# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVirtualBorderRoutersResult',
    'AwaitableGetVirtualBorderRoutersResult',
    'get_virtual_border_routers',
    'get_virtual_border_routers_output',
]

@pulumi.output_type
class GetVirtualBorderRoutersResult:
    """
    A collection of values returned by getVirtualBorderRouters.
    """
    def __init__(__self__, filters=None, id=None, ids=None, name_regex=None, names=None, output_file=None, routers=None, status=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if routers and not isinstance(routers, list):
            raise TypeError("Expected argument 'routers' to be a list")
        pulumi.set(__self__, "routers", routers)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVirtualBorderRoutersFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def routers(self) -> Sequence['outputs.GetVirtualBorderRoutersRouterResult']:
        return pulumi.get(self, "routers")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


class AwaitableGetVirtualBorderRoutersResult(GetVirtualBorderRoutersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualBorderRoutersResult(
            filters=self.filters,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            routers=self.routers,
            status=self.status)


def get_virtual_border_routers(filters: Optional[Sequence[pulumi.InputType['GetVirtualBorderRoutersFilterArgs']]] = None,
                               ids: Optional[Sequence[str]] = None,
                               name_regex: Optional[str] = None,
                               output_file: Optional[str] = None,
                               status: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualBorderRoutersResult:
    """
    This data source provides the Express Connect Virtual Border Routers of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.134.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.expressconnect.get_virtual_border_routers()
    pulumi.export("expressConnectVirtualBorderRouterId1", ids.routers[0].id)
    name_regex = alicloud.expressconnect.get_virtual_border_routers(name_regex="^my-VirtualBorderRouter")
    pulumi.export("expressConnectVirtualBorderRouterId2", name_regex.routers[0].id)
    filter = alicloud.expressconnect.get_virtual_border_routers(filters=[
        alicloud.expressconnect.GetVirtualBorderRoutersFilterArgs(
            key="PhysicalConnectionId",
            values=["pc-xxxx1"],
        ),
        alicloud.expressconnect.GetVirtualBorderRoutersFilterArgs(
            key="VbrId",
            values=[
                "vbr-xxxx1",
                "vbr-xxxx2",
            ],
        ),
    ])
    pulumi.export("expressConnectVirtualBorderRouterId3", filter.routers[0].id)
    ```


    :param Sequence[pulumi.InputType['GetVirtualBorderRoutersFilterArgs']] filters: Custom filter block as described below.
    :param Sequence[str] ids: A list of Virtual Border Router IDs.
    :param str name_regex: A regex string to filter results by Virtual Border Router name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The VBR state.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:expressconnect/getVirtualBorderRouters:getVirtualBorderRouters', __args__, opts=opts, typ=GetVirtualBorderRoutersResult).value

    return AwaitableGetVirtualBorderRoutersResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        routers=pulumi.get(__ret__, 'routers'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_virtual_border_routers)
def get_virtual_border_routers_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetVirtualBorderRoutersFilterArgs']]]]] = None,
                                      ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                      name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                                      output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                      status: Optional[pulumi.Input[Optional[str]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVirtualBorderRoutersResult]:
    """
    This data source provides the Express Connect Virtual Border Routers of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.134.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.expressconnect.get_virtual_border_routers()
    pulumi.export("expressConnectVirtualBorderRouterId1", ids.routers[0].id)
    name_regex = alicloud.expressconnect.get_virtual_border_routers(name_regex="^my-VirtualBorderRouter")
    pulumi.export("expressConnectVirtualBorderRouterId2", name_regex.routers[0].id)
    filter = alicloud.expressconnect.get_virtual_border_routers(filters=[
        alicloud.expressconnect.GetVirtualBorderRoutersFilterArgs(
            key="PhysicalConnectionId",
            values=["pc-xxxx1"],
        ),
        alicloud.expressconnect.GetVirtualBorderRoutersFilterArgs(
            key="VbrId",
            values=[
                "vbr-xxxx1",
                "vbr-xxxx2",
            ],
        ),
    ])
    pulumi.export("expressConnectVirtualBorderRouterId3", filter.routers[0].id)
    ```


    :param Sequence[pulumi.InputType['GetVirtualBorderRoutersFilterArgs']] filters: Custom filter block as described below.
    :param Sequence[str] ids: A list of Virtual Border Router IDs.
    :param str name_regex: A regex string to filter results by Virtual Border Router name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The VBR state.
    """
    ...
