# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetAccessPointsPointResult',
    'GetAccessPointsPointAccessPointFeatureModelResult',
    'GetGrantRuleToCensCenResult',
    'GetPhysicalConnectionsConnectionResult',
    'GetRouterInterfacesFilterResult',
    'GetRouterInterfacesInterfaceResult',
    'GetVbrPconnAssociationsAssociationResult',
    'GetVirtualBorderRoutersFilterResult',
    'GetVirtualBorderRoutersRouterResult',
    'GetVirtualPhysicalConnectionsConnectionResult',
]

@pulumi.output_type
class GetAccessPointsPointResult(dict):
    def __init__(__self__, *,
                 access_point_feature_models: Sequence['outputs.GetAccessPointsPointAccessPointFeatureModelResult'],
                 access_point_id: str,
                 access_point_name: str,
                 attached_region_no: str,
                 description: str,
                 host_operator: str,
                 id: str,
                 location: str,
                 status: str,
                 type: str):
        """
        :param Sequence['GetAccessPointsPointAccessPointFeatureModelArgs'] access_point_feature_models: Query to the Access Point Feature Model.
        :param str access_point_id: The Access Point ID.
        :param str access_point_name: Access Point Name.
        :param str attached_region_no: The Access Point Is Located an ID.
        :param str description: The Access Point Description.
        :param str host_operator: The Access Point Belongs to the Operator.
        :param str id: The ID of the Access Point.
        :param str location: The Location of the Access Point.
        :param str status: The Physical Connection to Which the Access Point State.
        :param str type: The Physical Connection to Which the Network Type.
        """
        pulumi.set(__self__, "access_point_feature_models", access_point_feature_models)
        pulumi.set(__self__, "access_point_id", access_point_id)
        pulumi.set(__self__, "access_point_name", access_point_name)
        pulumi.set(__self__, "attached_region_no", attached_region_no)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "host_operator", host_operator)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accessPointFeatureModels")
    def access_point_feature_models(self) -> Sequence['outputs.GetAccessPointsPointAccessPointFeatureModelResult']:
        """
        Query to the Access Point Feature Model.
        """
        return pulumi.get(self, "access_point_feature_models")

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> str:
        """
        The Access Point ID.
        """
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter(name="accessPointName")
    def access_point_name(self) -> str:
        """
        Access Point Name.
        """
        return pulumi.get(self, "access_point_name")

    @property
    @pulumi.getter(name="attachedRegionNo")
    def attached_region_no(self) -> str:
        """
        The Access Point Is Located an ID.
        """
        return pulumi.get(self, "attached_region_no")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The Access Point Description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="hostOperator")
    def host_operator(self) -> str:
        """
        The Access Point Belongs to the Operator.
        """
        return pulumi.get(self, "host_operator")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Access Point.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The Location of the Access Point.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The Physical Connection to Which the Access Point State.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The Physical Connection to Which the Network Type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAccessPointsPointAccessPointFeatureModelResult(dict):
    def __init__(__self__, *,
                 feature_key: str,
                 feature_value: str):
        """
        :param str feature_key: The Access Point Properties.
        :param str feature_value: The Access Point Characteristic Value.
        """
        pulumi.set(__self__, "feature_key", feature_key)
        pulumi.set(__self__, "feature_value", feature_value)

    @property
    @pulumi.getter(name="featureKey")
    def feature_key(self) -> str:
        """
        The Access Point Properties.
        """
        return pulumi.get(self, "feature_key")

    @property
    @pulumi.getter(name="featureValue")
    def feature_value(self) -> str:
        """
        The Access Point Characteristic Value.
        """
        return pulumi.get(self, "feature_value")


@pulumi.output_type
class GetGrantRuleToCensCenResult(dict):
    def __init__(__self__, *,
                 cen_id: str,
                 cen_owner_id: int,
                 create_time: str,
                 id: str):
        """
        :param str cen_id: The ID of the authorized CEN instance.
        :param int cen_owner_id: The user ID (UID) of the Alibaba Cloud account to which the CEN instance belongs.
        :param str create_time: The time when the instance was created.
        :param str id: The ID of the Grant Rule To Cen. It formats as `<cen_id>:<cen_owner_id>:<instance_id>`.
        """
        pulumi.set(__self__, "cen_id", cen_id)
        pulumi.set(__self__, "cen_owner_id", cen_owner_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="cenId")
    def cen_id(self) -> str:
        """
        The ID of the authorized CEN instance.
        """
        return pulumi.get(self, "cen_id")

    @property
    @pulumi.getter(name="cenOwnerId")
    def cen_owner_id(self) -> int:
        """
        The user ID (UID) of the Alibaba Cloud account to which the CEN instance belongs.
        """
        return pulumi.get(self, "cen_owner_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time when the instance was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Grant Rule To Cen. It formats as `<cen_id>:<cen_owner_id>:<instance_id>`.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetPhysicalConnectionsConnectionResult(dict):
    def __init__(__self__, *,
                 access_point_id: str,
                 ad_location: str,
                 bandwidth: str,
                 business_status: str,
                 circuit_code: str,
                 create_time: str,
                 description: str,
                 enabled_time: str,
                 end_time: str,
                 has_reservation_data: str,
                 id: str,
                 line_operator: str,
                 loa_status: str,
                 payment_type: str,
                 peer_location: str,
                 physical_connection_id: str,
                 physical_connection_name: str,
                 port_number: str,
                 port_type: str,
                 redundant_physical_connection_id: str,
                 reservation_active_time: str,
                 reservation_internet_charge_type: str,
                 reservation_order_type: str,
                 spec: str,
                 status: str,
                 type: str):
        """
        :param str access_point_id: The Physical Leased Line Access Point ID.
        :param str ad_location: To Connect a Device Physical Location.
        :param str bandwidth: On the Bandwidth of the ECC Service and Physical Connection.
        :param str business_status: The Physical Connection to Which the Payment Status: Normal, financiallocked, securitylocked.
        :param str circuit_code: Operators for Physical Connection Circuit Provided Coding.
        :param str create_time: The Representative of the Creation Time Resources Attribute Field.
        :param str description: The Physical Connection to Which the Description.
        :param str enabled_time: The Physical Connection to Which the Activation Time.
        :param str end_time: The Expiration Time.
        :param str has_reservation_data: HasReservationData.
        :param str id: The ID of the Physical Connection.
        :param str line_operator: Provides Access to the Physical Line Operator Value CT: China Telecom, CU: China Unicom, CM: china Mobile, CO: Other Chinese, Equinix:Equinix, Other: Other Overseas.
        :param str loa_status: Loa State.
        :param str payment_type: on Behalf of the Pay-as-You-Type of Resource Attribute Field.
        :param str peer_location: and an on-Premises Data Center Location.
        :param str physical_connection_id: on Behalf of the Resource Level Id of the Resources Property Fields.
        :param str physical_connection_name: on Behalf of the Resource Name of the Resources-Attribute Field.
        :param str port_number: To Connect a Device Port: The Port Number of.
        :param str port_type: The Physical Leased Line Access Port Type Value 100Base-T: Fast Electrical Ports, 1000Base-T (the Default): gigabit Electrical Ports, 1000Base-LX: Gigabit Singlemode Optical Ports (10Km), 10GBase-T: Gigabit Electrical Port, 10GBase-LR: Gigabit Singlemode Optical Ports (10Km).
        :param str redundant_physical_connection_id: Redundant Physical Connection to Which the ID.
        :param str reservation_active_time: The Renewal of the Entry into Force of the Time.
        :param str reservation_internet_charge_type: Renewal Type.
        :param str reservation_order_type: Renewal Order Type.
        :param str spec: The Physical Connection to Which the Specifications.
        :param str status: Resources on Behalf of a State of the Resource Attribute Field.
        :param str type: Physical Private Line of Type. Default Value: VPC.
        """
        pulumi.set(__self__, "access_point_id", access_point_id)
        pulumi.set(__self__, "ad_location", ad_location)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "circuit_code", circuit_code)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled_time", enabled_time)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "has_reservation_data", has_reservation_data)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "line_operator", line_operator)
        pulumi.set(__self__, "loa_status", loa_status)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "peer_location", peer_location)
        pulumi.set(__self__, "physical_connection_id", physical_connection_id)
        pulumi.set(__self__, "physical_connection_name", physical_connection_name)
        pulumi.set(__self__, "port_number", port_number)
        pulumi.set(__self__, "port_type", port_type)
        pulumi.set(__self__, "redundant_physical_connection_id", redundant_physical_connection_id)
        pulumi.set(__self__, "reservation_active_time", reservation_active_time)
        pulumi.set(__self__, "reservation_internet_charge_type", reservation_internet_charge_type)
        pulumi.set(__self__, "reservation_order_type", reservation_order_type)
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> str:
        """
        The Physical Leased Line Access Point ID.
        """
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter(name="adLocation")
    def ad_location(self) -> str:
        """
        To Connect a Device Physical Location.
        """
        return pulumi.get(self, "ad_location")

    @property
    @pulumi.getter
    def bandwidth(self) -> str:
        """
        On the Bandwidth of the ECC Service and Physical Connection.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> str:
        """
        The Physical Connection to Which the Payment Status: Normal, financiallocked, securitylocked.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> str:
        """
        Operators for Physical Connection Circuit Provided Coding.
        """
        return pulumi.get(self, "circuit_code")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The Representative of the Creation Time Resources Attribute Field.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The Physical Connection to Which the Description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enabledTime")
    def enabled_time(self) -> str:
        """
        The Physical Connection to Which the Activation Time.
        """
        return pulumi.get(self, "enabled_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The Expiration Time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="hasReservationData")
    def has_reservation_data(self) -> str:
        """
        HasReservationData.
        """
        return pulumi.get(self, "has_reservation_data")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Physical Connection.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lineOperator")
    def line_operator(self) -> str:
        """
        Provides Access to the Physical Line Operator Value CT: China Telecom, CU: China Unicom, CM: china Mobile, CO: Other Chinese, Equinix:Equinix, Other: Other Overseas.
        """
        return pulumi.get(self, "line_operator")

    @property
    @pulumi.getter(name="loaStatus")
    def loa_status(self) -> str:
        """
        Loa State.
        """
        return pulumi.get(self, "loa_status")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        on Behalf of the Pay-as-You-Type of Resource Attribute Field.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="peerLocation")
    def peer_location(self) -> str:
        """
        and an on-Premises Data Center Location.
        """
        return pulumi.get(self, "peer_location")

    @property
    @pulumi.getter(name="physicalConnectionId")
    def physical_connection_id(self) -> str:
        """
        on Behalf of the Resource Level Id of the Resources Property Fields.
        """
        return pulumi.get(self, "physical_connection_id")

    @property
    @pulumi.getter(name="physicalConnectionName")
    def physical_connection_name(self) -> str:
        """
        on Behalf of the Resource Name of the Resources-Attribute Field.
        """
        return pulumi.get(self, "physical_connection_name")

    @property
    @pulumi.getter(name="portNumber")
    def port_number(self) -> str:
        """
        To Connect a Device Port: The Port Number of.
        """
        return pulumi.get(self, "port_number")

    @property
    @pulumi.getter(name="portType")
    def port_type(self) -> str:
        """
        The Physical Leased Line Access Port Type Value 100Base-T: Fast Electrical Ports, 1000Base-T (the Default): gigabit Electrical Ports, 1000Base-LX: Gigabit Singlemode Optical Ports (10Km), 10GBase-T: Gigabit Electrical Port, 10GBase-LR: Gigabit Singlemode Optical Ports (10Km).
        """
        return pulumi.get(self, "port_type")

    @property
    @pulumi.getter(name="redundantPhysicalConnectionId")
    def redundant_physical_connection_id(self) -> str:
        """
        Redundant Physical Connection to Which the ID.
        """
        return pulumi.get(self, "redundant_physical_connection_id")

    @property
    @pulumi.getter(name="reservationActiveTime")
    def reservation_active_time(self) -> str:
        """
        The Renewal of the Entry into Force of the Time.
        """
        return pulumi.get(self, "reservation_active_time")

    @property
    @pulumi.getter(name="reservationInternetChargeType")
    def reservation_internet_charge_type(self) -> str:
        """
        Renewal Type.
        """
        return pulumi.get(self, "reservation_internet_charge_type")

    @property
    @pulumi.getter(name="reservationOrderType")
    def reservation_order_type(self) -> str:
        """
        Renewal Order Type.
        """
        return pulumi.get(self, "reservation_order_type")

    @property
    @pulumi.getter
    def spec(self) -> str:
        """
        The Physical Connection to Which the Specifications.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Resources on Behalf of a State of the Resource Attribute Field.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Physical Private Line of Type. Default Value: VPC.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetRouterInterfacesFilterResult(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "values")


@pulumi.output_type
class GetRouterInterfacesInterfaceResult(dict):
    def __init__(__self__, *,
                 access_point_id: str,
                 bandwidth: int,
                 business_status: str,
                 connected_time: str,
                 create_time: str,
                 cross_border: bool,
                 description: str,
                 end_time: str,
                 has_reservation_data: str,
                 hc_rate: int,
                 hc_threshold: str,
                 health_check_source_ip: str,
                 health_check_target_ip: str,
                 id: str,
                 opposite_access_point_id: str,
                 opposite_bandwidth: int,
                 opposite_interface_business_status: str,
                 opposite_interface_id: str,
                 opposite_interface_owner_id: str,
                 opposite_interface_spec: str,
                 opposite_interface_status: str,
                 opposite_region_id: str,
                 opposite_router_id: str,
                 opposite_router_type: str,
                 opposite_vpc_instance_id: str,
                 payment_type: str,
                 reservation_active_time: str,
                 reservation_bandwidth: str,
                 reservation_internet_charge_type: str,
                 reservation_order_type: str,
                 role: str,
                 router_id: str,
                 router_interface_id: str,
                 router_interface_name: str,
                 router_type: str,
                 spec: str,
                 status: str,
                 vpc_instance_id: str):
        """
        :param str access_point_id: The access point ID to which the VBR belongs.
        :param int bandwidth: The bandwidth of the resource.
        :param str business_status: The businessStatus of the resource. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
        :param str connected_time: The connected time of the resource.
        :param str create_time: The creation time of the resource
        :param bool cross_border: The cross border of the resource.
        :param str description: The description of the router interface.
        :param str end_time: The end time of the resource.
        :param str has_reservation_data: The has reservation data of the resource.
        :param int hc_rate: The hc rate of the resource.
        :param str hc_threshold: The hc threshold of the resource.
        :param str health_check_source_ip: The health check source IP address, must be an unused IP within the local VPC.
        :param str health_check_target_ip: The IP address for health screening purposes.
        :param str opposite_access_point_id: The Access point ID to which the other end belongs.
        :param int opposite_bandwidth: The opposite bandwidth of the router on the other side.
        :param str opposite_interface_business_status: The opposite interface business status of the router on the other side. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
        :param str opposite_interface_id: The Interface ID of the router at the other end.
        :param str opposite_interface_owner_id: The AliCloud account ID of the owner of the router interface on the other end.
        :param str opposite_interface_spec: The opposite interface spec of the router on the other side. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        :param str opposite_interface_status: The opposite interface status of the router on the other side. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        :param str opposite_region_id: The geographical ID of the location of the receiving end of the connection.
        :param str opposite_router_id: The id of the router at the other end.
        :param str opposite_router_type: The opposite router type of the router on the other side. Valid Values: `VRouter`, `VBR`.
        :param str opposite_vpc_instance_id: The opposite vpc instance id of the router on the other side.
        :param str payment_type: The payment methods for router interfaces. Valid Values: `PrePaid`, `PostPaid`.
        :param str reservation_active_time: The reservation active time of the resource.
        :param str reservation_bandwidth: The reservation bandwidth of the resource.
        :param str reservation_internet_charge_type: The reservation internet charge type of the resource.
        :param str reservation_order_type: The reservation order type of the resource.
        :param str role: The role of the router interface. Valid Values: `InitiatingSide`, `AcceptingSide`.
        :param str router_id: The router id associated with the router interface.
        :param str router_interface_id: The first ID of the resource.
        :param str router_interface_name: The name of the resource.
        :param str router_type: The type of router associated with the router interface. Valid Values: `VRouter`, `VBR`.
        :param str spec: The specification of the router interface. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        :param str status: The status of the resource. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        :param str vpc_instance_id: The vpc instance id of the resource.
        """
        pulumi.set(__self__, "access_point_id", access_point_id)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "connected_time", connected_time)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "cross_border", cross_border)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "has_reservation_data", has_reservation_data)
        pulumi.set(__self__, "hc_rate", hc_rate)
        pulumi.set(__self__, "hc_threshold", hc_threshold)
        pulumi.set(__self__, "health_check_source_ip", health_check_source_ip)
        pulumi.set(__self__, "health_check_target_ip", health_check_target_ip)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "opposite_access_point_id", opposite_access_point_id)
        pulumi.set(__self__, "opposite_bandwidth", opposite_bandwidth)
        pulumi.set(__self__, "opposite_interface_business_status", opposite_interface_business_status)
        pulumi.set(__self__, "opposite_interface_id", opposite_interface_id)
        pulumi.set(__self__, "opposite_interface_owner_id", opposite_interface_owner_id)
        pulumi.set(__self__, "opposite_interface_spec", opposite_interface_spec)
        pulumi.set(__self__, "opposite_interface_status", opposite_interface_status)
        pulumi.set(__self__, "opposite_region_id", opposite_region_id)
        pulumi.set(__self__, "opposite_router_id", opposite_router_id)
        pulumi.set(__self__, "opposite_router_type", opposite_router_type)
        pulumi.set(__self__, "opposite_vpc_instance_id", opposite_vpc_instance_id)
        pulumi.set(__self__, "payment_type", payment_type)
        pulumi.set(__self__, "reservation_active_time", reservation_active_time)
        pulumi.set(__self__, "reservation_bandwidth", reservation_bandwidth)
        pulumi.set(__self__, "reservation_internet_charge_type", reservation_internet_charge_type)
        pulumi.set(__self__, "reservation_order_type", reservation_order_type)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "router_id", router_id)
        pulumi.set(__self__, "router_interface_id", router_interface_id)
        pulumi.set(__self__, "router_interface_name", router_interface_name)
        pulumi.set(__self__, "router_type", router_type)
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vpc_instance_id", vpc_instance_id)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> str:
        """
        The access point ID to which the VBR belongs.
        """
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        The bandwidth of the resource.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> str:
        """
        The businessStatus of the resource. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="connectedTime")
    def connected_time(self) -> str:
        """
        The connected time of the resource.
        """
        return pulumi.get(self, "connected_time")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="crossBorder")
    def cross_border(self) -> bool:
        """
        The cross border of the resource.
        """
        return pulumi.get(self, "cross_border")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the router interface.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The end time of the resource.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="hasReservationData")
    def has_reservation_data(self) -> str:
        """
        The has reservation data of the resource.
        """
        return pulumi.get(self, "has_reservation_data")

    @property
    @pulumi.getter(name="hcRate")
    def hc_rate(self) -> int:
        """
        The hc rate of the resource.
        """
        return pulumi.get(self, "hc_rate")

    @property
    @pulumi.getter(name="hcThreshold")
    def hc_threshold(self) -> str:
        """
        The hc threshold of the resource.
        """
        return pulumi.get(self, "hc_threshold")

    @property
    @pulumi.getter(name="healthCheckSourceIp")
    def health_check_source_ip(self) -> str:
        """
        The health check source IP address, must be an unused IP within the local VPC.
        """
        return pulumi.get(self, "health_check_source_ip")

    @property
    @pulumi.getter(name="healthCheckTargetIp")
    def health_check_target_ip(self) -> str:
        """
        The IP address for health screening purposes.
        """
        return pulumi.get(self, "health_check_target_ip")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="oppositeAccessPointId")
    def opposite_access_point_id(self) -> str:
        """
        The Access point ID to which the other end belongs.
        """
        return pulumi.get(self, "opposite_access_point_id")

    @property
    @pulumi.getter(name="oppositeBandwidth")
    def opposite_bandwidth(self) -> int:
        """
        The opposite bandwidth of the router on the other side.
        """
        return pulumi.get(self, "opposite_bandwidth")

    @property
    @pulumi.getter(name="oppositeInterfaceBusinessStatus")
    def opposite_interface_business_status(self) -> str:
        """
        The opposite interface business status of the router on the other side. Valid Values: `Normal`, `FinancialLocked`, `SecurityLocked`.
        """
        return pulumi.get(self, "opposite_interface_business_status")

    @property
    @pulumi.getter(name="oppositeInterfaceId")
    def opposite_interface_id(self) -> str:
        """
        The Interface ID of the router at the other end.
        """
        return pulumi.get(self, "opposite_interface_id")

    @property
    @pulumi.getter(name="oppositeInterfaceOwnerId")
    def opposite_interface_owner_id(self) -> str:
        """
        The AliCloud account ID of the owner of the router interface on the other end.
        """
        return pulumi.get(self, "opposite_interface_owner_id")

    @property
    @pulumi.getter(name="oppositeInterfaceSpec")
    def opposite_interface_spec(self) -> str:
        """
        The opposite interface spec of the router on the other side. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        """
        return pulumi.get(self, "opposite_interface_spec")

    @property
    @pulumi.getter(name="oppositeInterfaceStatus")
    def opposite_interface_status(self) -> str:
        """
        The opposite interface status of the router on the other side. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        """
        return pulumi.get(self, "opposite_interface_status")

    @property
    @pulumi.getter(name="oppositeRegionId")
    def opposite_region_id(self) -> str:
        """
        The geographical ID of the location of the receiving end of the connection.
        """
        return pulumi.get(self, "opposite_region_id")

    @property
    @pulumi.getter(name="oppositeRouterId")
    def opposite_router_id(self) -> str:
        """
        The id of the router at the other end.
        """
        return pulumi.get(self, "opposite_router_id")

    @property
    @pulumi.getter(name="oppositeRouterType")
    def opposite_router_type(self) -> str:
        """
        The opposite router type of the router on the other side. Valid Values: `VRouter`, `VBR`.
        """
        return pulumi.get(self, "opposite_router_type")

    @property
    @pulumi.getter(name="oppositeVpcInstanceId")
    def opposite_vpc_instance_id(self) -> str:
        """
        The opposite vpc instance id of the router on the other side.
        """
        return pulumi.get(self, "opposite_vpc_instance_id")

    @property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> str:
        """
        The payment methods for router interfaces. Valid Values: `PrePaid`, `PostPaid`.
        """
        return pulumi.get(self, "payment_type")

    @property
    @pulumi.getter(name="reservationActiveTime")
    def reservation_active_time(self) -> str:
        """
        The reservation active time of the resource.
        """
        return pulumi.get(self, "reservation_active_time")

    @property
    @pulumi.getter(name="reservationBandwidth")
    def reservation_bandwidth(self) -> str:
        """
        The reservation bandwidth of the resource.
        """
        return pulumi.get(self, "reservation_bandwidth")

    @property
    @pulumi.getter(name="reservationInternetChargeType")
    def reservation_internet_charge_type(self) -> str:
        """
        The reservation internet charge type of the resource.
        """
        return pulumi.get(self, "reservation_internet_charge_type")

    @property
    @pulumi.getter(name="reservationOrderType")
    def reservation_order_type(self) -> str:
        """
        The reservation order type of the resource.
        """
        return pulumi.get(self, "reservation_order_type")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        The role of the router interface. Valid Values: `InitiatingSide`, `AcceptingSide`.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> str:
        """
        The router id associated with the router interface.
        """
        return pulumi.get(self, "router_id")

    @property
    @pulumi.getter(name="routerInterfaceId")
    def router_interface_id(self) -> str:
        """
        The first ID of the resource.
        """
        return pulumi.get(self, "router_interface_id")

    @property
    @pulumi.getter(name="routerInterfaceName")
    def router_interface_name(self) -> str:
        """
        The name of the resource.
        """
        return pulumi.get(self, "router_interface_name")

    @property
    @pulumi.getter(name="routerType")
    def router_type(self) -> str:
        """
        The type of router associated with the router interface. Valid Values: `VRouter`, `VBR`.
        """
        return pulumi.get(self, "router_type")

    @property
    @pulumi.getter
    def spec(self) -> str:
        """
        The specification of the router interface. Valid Values: `Mini.2`, `Mini.5`, `Mini.5`, `Small.2`, `Small.5`, `Middle.1`, `Middle.2`, `Middle.5`, `Large.1`, `Large.2`, `Large.5`, `XLarge.1`, `Negative`.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource. Valid Values: `Idle`, `AcceptingConnecting`, `Connecting`, `Activating`, `Active`, `Modifying`, `Deactivating`, `Inactive`, `Deleting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vpcInstanceId")
    def vpc_instance_id(self) -> str:
        """
        The vpc instance id of the resource.
        """
        return pulumi.get(self, "vpc_instance_id")


@pulumi.output_type
class GetVbrPconnAssociationsAssociationResult(dict):
    def __init__(__self__, *,
                 circuit_code: str,
                 enable_ipv6: bool,
                 id: str,
                 local_gateway_ip: str,
                 local_ipv6_gateway_ip: str,
                 peer_gateway_ip: str,
                 peer_ipv6_gateway_ip: str,
                 peering_ipv6_subnet_mask: str,
                 peering_subnet_mask: str,
                 physical_connection_id: str,
                 status: str,
                 vbr_id: str,
                 vlan_id: int):
        """
        :param str circuit_code: The circuit code provided by the operator for the physical connection.
        :param bool enable_ipv6: Whether IPv6 is enabled.
        :param str id: The ID of the Vbr Pconn Association.
        :param str local_gateway_ip: The Alibaba cloud IP address of the VBR instance.
        :param str local_ipv6_gateway_ip: The IPv6 address on the Alibaba Cloud side of the VBR instance.
        :param str peer_gateway_ip: The client IP address of the VBR instance.
        :param str peer_ipv6_gateway_ip: The IPv6 address of the client side of the VBR instance.
        :param str peering_ipv6_subnet_mask: The subnet mask of the Alibaba Cloud side and the client side of the VBR instance.Two IPv6 addresses must be in the same subnet.
        :param str peering_subnet_mask: The subnet mask of the Alibaba Cloud side and the client side of the VBR instance.The two IP addresses must be in the same subnet.
        :param str physical_connection_id: The ID of the leased line instance.
        :param str status: The status of the resource
        :param str vbr_id: The ID of the VBR instance.
        :param int vlan_id: VLAN ID of the VBR.
        """
        pulumi.set(__self__, "circuit_code", circuit_code)
        pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "local_gateway_ip", local_gateway_ip)
        pulumi.set(__self__, "local_ipv6_gateway_ip", local_ipv6_gateway_ip)
        pulumi.set(__self__, "peer_gateway_ip", peer_gateway_ip)
        pulumi.set(__self__, "peer_ipv6_gateway_ip", peer_ipv6_gateway_ip)
        pulumi.set(__self__, "peering_ipv6_subnet_mask", peering_ipv6_subnet_mask)
        pulumi.set(__self__, "peering_subnet_mask", peering_subnet_mask)
        pulumi.set(__self__, "physical_connection_id", physical_connection_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "vbr_id", vbr_id)
        pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> str:
        """
        The circuit code provided by the operator for the physical connection.
        """
        return pulumi.get(self, "circuit_code")

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> bool:
        """
        Whether IPv6 is enabled.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Vbr Pconn Association.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localGatewayIp")
    def local_gateway_ip(self) -> str:
        """
        The Alibaba cloud IP address of the VBR instance.
        """
        return pulumi.get(self, "local_gateway_ip")

    @property
    @pulumi.getter(name="localIpv6GatewayIp")
    def local_ipv6_gateway_ip(self) -> str:
        """
        The IPv6 address on the Alibaba Cloud side of the VBR instance.
        """
        return pulumi.get(self, "local_ipv6_gateway_ip")

    @property
    @pulumi.getter(name="peerGatewayIp")
    def peer_gateway_ip(self) -> str:
        """
        The client IP address of the VBR instance.
        """
        return pulumi.get(self, "peer_gateway_ip")

    @property
    @pulumi.getter(name="peerIpv6GatewayIp")
    def peer_ipv6_gateway_ip(self) -> str:
        """
        The IPv6 address of the client side of the VBR instance.
        """
        return pulumi.get(self, "peer_ipv6_gateway_ip")

    @property
    @pulumi.getter(name="peeringIpv6SubnetMask")
    def peering_ipv6_subnet_mask(self) -> str:
        """
        The subnet mask of the Alibaba Cloud side and the client side of the VBR instance.Two IPv6 addresses must be in the same subnet.
        """
        return pulumi.get(self, "peering_ipv6_subnet_mask")

    @property
    @pulumi.getter(name="peeringSubnetMask")
    def peering_subnet_mask(self) -> str:
        """
        The subnet mask of the Alibaba Cloud side and the client side of the VBR instance.The two IP addresses must be in the same subnet.
        """
        return pulumi.get(self, "peering_subnet_mask")

    @property
    @pulumi.getter(name="physicalConnectionId")
    def physical_connection_id(self) -> str:
        """
        The ID of the leased line instance.
        """
        return pulumi.get(self, "physical_connection_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vbrId")
    def vbr_id(self) -> str:
        """
        The ID of the VBR instance.
        """
        return pulumi.get(self, "vbr_id")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> int:
        """
        VLAN ID of the VBR.
        """
        return pulumi.get(self, "vlan_id")


@pulumi.output_type
class GetVirtualBorderRoutersFilterResult(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        :param str key: The key of the field to filter by, as defined by
               [Alibaba Cloud API](https://www.alibabacloud.com/help/en/doc-detail/124791.htm).
        :param Sequence[str] values: Set of values that are accepted for the given field.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The key of the field to filter by, as defined by
        [Alibaba Cloud API](https://www.alibabacloud.com/help/en/doc-detail/124791.htm).
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        Set of values that are accepted for the given field.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetVirtualBorderRoutersRouterResult(dict):
    def __init__(__self__, *,
                 access_point_id: str,
                 activation_time: str,
                 circuit_code: str,
                 cloud_box_instance_id: str,
                 create_time: str,
                 description: str,
                 detect_multiplier: int,
                 ecc_id: str,
                 enable_ipv6: bool,
                 id: str,
                 local_gateway_ip: str,
                 local_ipv6_gateway_ip: str,
                 min_rx_interval: int,
                 min_tx_interval: int,
                 payment_vbr_expire_time: str,
                 peer_gateway_ip: str,
                 peer_ipv6_gateway_ip: str,
                 peering_ipv6_subnet_mask: str,
                 peering_subnet_mask: str,
                 physical_connection_business_status: str,
                 physical_connection_id: str,
                 physical_connection_owner_uid: str,
                 physical_connection_status: str,
                 recovery_time: str,
                 route_table_id: str,
                 status: str,
                 termination_time: str,
                 type: str,
                 virtual_border_router_id: str,
                 virtual_border_router_name: str,
                 vlan_id: int,
                 vlan_interface_id: str):
        """
        :param str access_point_id: The physical leased line access point ID.
        :param str activation_time: The first activation time of VBR.
        :param str circuit_code: Operators for physical connection circuit provided coding.
        :param str cloud_box_instance_id: Box Instance Id.
        :param str create_time: The representative of the creation time resources attribute field.
        :param str description: The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        :param int detect_multiplier: Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        :param str ecc_id: High Speed Migration Service Instance Id.
        :param bool enable_ipv6: Whether to Enable IPv6.
        :param str id: The ID of the Virtual Border Router.
        :param str local_gateway_ip: Alibaba Cloud-Connected IPv4 address.
        :param str local_ipv6_gateway_ip: Alibaba Cloud-Connected IPv6 Address.
        :param int min_rx_interval: Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        :param int min_tx_interval: Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        :param str payment_vbr_expire_time: The Billing of the Extended Time.
        :param str peer_gateway_ip: The Client-Side Interconnection IPv4 Address.
        :param str peer_ipv6_gateway_ip: The Client-Side Interconnection IPv6 Address.
        :param str peering_ipv6_subnet_mask: Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        :param str peering_subnet_mask: Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        :param str physical_connection_business_status: Physical Private Line Service Status Value Normal: Normal, financiallocked: If You Lock.
        :param str physical_connection_id: The ID of the Physical Connection to Which the ID.
        :param str physical_connection_owner_uid: Physical Private Line Where the Account ID.
        :param str physical_connection_status: Physical Private Line State.
        :param str recovery_time: The Last from a Terminated State to the Active State of the Time.
        :param str route_table_id: Route Table ID.
        :param str status: The VBR state.
        :param str termination_time: The Most Recent Was Aborted by the Time.
        :param str type: VBR Type.
        :param str virtual_border_router_id: The VBR ID.
        :param str virtual_border_router_name: The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        :param int vlan_id: The VLAN ID of the VBR. Value range: 0~2999.
        :param str vlan_interface_id: The ID of the Router Interface.
        """
        pulumi.set(__self__, "access_point_id", access_point_id)
        pulumi.set(__self__, "activation_time", activation_time)
        pulumi.set(__self__, "circuit_code", circuit_code)
        pulumi.set(__self__, "cloud_box_instance_id", cloud_box_instance_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "detect_multiplier", detect_multiplier)
        pulumi.set(__self__, "ecc_id", ecc_id)
        pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "local_gateway_ip", local_gateway_ip)
        pulumi.set(__self__, "local_ipv6_gateway_ip", local_ipv6_gateway_ip)
        pulumi.set(__self__, "min_rx_interval", min_rx_interval)
        pulumi.set(__self__, "min_tx_interval", min_tx_interval)
        pulumi.set(__self__, "payment_vbr_expire_time", payment_vbr_expire_time)
        pulumi.set(__self__, "peer_gateway_ip", peer_gateway_ip)
        pulumi.set(__self__, "peer_ipv6_gateway_ip", peer_ipv6_gateway_ip)
        pulumi.set(__self__, "peering_ipv6_subnet_mask", peering_ipv6_subnet_mask)
        pulumi.set(__self__, "peering_subnet_mask", peering_subnet_mask)
        pulumi.set(__self__, "physical_connection_business_status", physical_connection_business_status)
        pulumi.set(__self__, "physical_connection_id", physical_connection_id)
        pulumi.set(__self__, "physical_connection_owner_uid", physical_connection_owner_uid)
        pulumi.set(__self__, "physical_connection_status", physical_connection_status)
        pulumi.set(__self__, "recovery_time", recovery_time)
        pulumi.set(__self__, "route_table_id", route_table_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "termination_time", termination_time)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "virtual_border_router_id", virtual_border_router_id)
        pulumi.set(__self__, "virtual_border_router_name", virtual_border_router_name)
        pulumi.set(__self__, "vlan_id", vlan_id)
        pulumi.set(__self__, "vlan_interface_id", vlan_interface_id)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> str:
        """
        The physical leased line access point ID.
        """
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter(name="activationTime")
    def activation_time(self) -> str:
        """
        The first activation time of VBR.
        """
        return pulumi.get(self, "activation_time")

    @property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> str:
        """
        Operators for physical connection circuit provided coding.
        """
        return pulumi.get(self, "circuit_code")

    @property
    @pulumi.getter(name="cloudBoxInstanceId")
    def cloud_box_instance_id(self) -> str:
        """
        Box Instance Id.
        """
        return pulumi.get(self, "cloud_box_instance_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The representative of the creation time resources attribute field.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="detectMultiplier")
    def detect_multiplier(self) -> int:
        """
        Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        """
        return pulumi.get(self, "detect_multiplier")

    @property
    @pulumi.getter(name="eccId")
    def ecc_id(self) -> str:
        """
        High Speed Migration Service Instance Id.
        """
        return pulumi.get(self, "ecc_id")

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> bool:
        """
        Whether to Enable IPv6.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Virtual Border Router.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localGatewayIp")
    def local_gateway_ip(self) -> str:
        """
        Alibaba Cloud-Connected IPv4 address.
        """
        return pulumi.get(self, "local_gateway_ip")

    @property
    @pulumi.getter(name="localIpv6GatewayIp")
    def local_ipv6_gateway_ip(self) -> str:
        """
        Alibaba Cloud-Connected IPv6 Address.
        """
        return pulumi.get(self, "local_ipv6_gateway_ip")

    @property
    @pulumi.getter(name="minRxInterval")
    def min_rx_interval(self) -> int:
        """
        Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        """
        return pulumi.get(self, "min_rx_interval")

    @property
    @pulumi.getter(name="minTxInterval")
    def min_tx_interval(self) -> int:
        """
        Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        """
        return pulumi.get(self, "min_tx_interval")

    @property
    @pulumi.getter(name="paymentVbrExpireTime")
    def payment_vbr_expire_time(self) -> str:
        """
        The Billing of the Extended Time.
        """
        return pulumi.get(self, "payment_vbr_expire_time")

    @property
    @pulumi.getter(name="peerGatewayIp")
    def peer_gateway_ip(self) -> str:
        """
        The Client-Side Interconnection IPv4 Address.
        """
        return pulumi.get(self, "peer_gateway_ip")

    @property
    @pulumi.getter(name="peerIpv6GatewayIp")
    def peer_ipv6_gateway_ip(self) -> str:
        """
        The Client-Side Interconnection IPv6 Address.
        """
        return pulumi.get(self, "peer_ipv6_gateway_ip")

    @property
    @pulumi.getter(name="peeringIpv6SubnetMask")
    def peering_ipv6_subnet_mask(self) -> str:
        """
        Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        """
        return pulumi.get(self, "peering_ipv6_subnet_mask")

    @property
    @pulumi.getter(name="peeringSubnetMask")
    def peering_subnet_mask(self) -> str:
        """
        Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        """
        return pulumi.get(self, "peering_subnet_mask")

    @property
    @pulumi.getter(name="physicalConnectionBusinessStatus")
    def physical_connection_business_status(self) -> str:
        """
        Physical Private Line Service Status Value Normal: Normal, financiallocked: If You Lock.
        """
        return pulumi.get(self, "physical_connection_business_status")

    @property
    @pulumi.getter(name="physicalConnectionId")
    def physical_connection_id(self) -> str:
        """
        The ID of the Physical Connection to Which the ID.
        """
        return pulumi.get(self, "physical_connection_id")

    @property
    @pulumi.getter(name="physicalConnectionOwnerUid")
    def physical_connection_owner_uid(self) -> str:
        """
        Physical Private Line Where the Account ID.
        """
        return pulumi.get(self, "physical_connection_owner_uid")

    @property
    @pulumi.getter(name="physicalConnectionStatus")
    def physical_connection_status(self) -> str:
        """
        Physical Private Line State.
        """
        return pulumi.get(self, "physical_connection_status")

    @property
    @pulumi.getter(name="recoveryTime")
    def recovery_time(self) -> str:
        """
        The Last from a Terminated State to the Active State of the Time.
        """
        return pulumi.get(self, "recovery_time")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> str:
        """
        Route Table ID.
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The VBR state.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="terminationTime")
    def termination_time(self) -> str:
        """
        The Most Recent Was Aborted by the Time.
        """
        return pulumi.get(self, "termination_time")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        VBR Type.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="virtualBorderRouterId")
    def virtual_border_router_id(self) -> str:
        """
        The VBR ID.
        """
        return pulumi.get(self, "virtual_border_router_id")

    @property
    @pulumi.getter(name="virtualBorderRouterName")
    def virtual_border_router_name(self) -> str:
        """
        The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        """
        return pulumi.get(self, "virtual_border_router_name")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> int:
        """
        The VLAN ID of the VBR. Value range: 0~2999.
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vlanInterfaceId")
    def vlan_interface_id(self) -> str:
        """
        The ID of the Router Interface.
        """
        return pulumi.get(self, "vlan_interface_id")


@pulumi.output_type
class GetVirtualPhysicalConnectionsConnectionResult(dict):
    def __init__(__self__, *,
                 access_point_id: str,
                 ad_location: str,
                 bandwidth: str,
                 business_status: str,
                 circuit_code: str,
                 create_time: str,
                 description: str,
                 enabled_time: str,
                 end_time: str,
                 expect_spec: str,
                 id: str,
                 line_operator: str,
                 loa_status: str,
                 order_mode: str,
                 parent_physical_connection_ali_uid: str,
                 parent_physical_connection_id: str,
                 peer_location: str,
                 port_number: str,
                 port_type: str,
                 redundant_physical_connection_id: str,
                 resource_group_id: str,
                 spec: str,
                 status: str,
                 virtual_physical_connection_id: str,
                 virtual_physical_connection_name: str,
                 virtual_physical_connection_status: str,
                 vlan_id: int,
                 vpconn_ali_uid: str):
        """
        :param str access_point_id: The ID of the access point of the physical connection.
        :param str ad_location: The physical location where the physical connection access device is located.
        :param str bandwidth: The bandwidth of the physical connection. Unit: Mbps.
        :param str business_status: The commercial status of the physical line. Value:
               - **Normal**: activated.
               - **Financialized**: Arrears locked.
               - **SecurityLocked**: locked for security reasons.
        :param str circuit_code: The circuit code provided by the operator for the physical connection.
        :param str create_time: The creation time of the resource
        :param str description: The description of the physical connection.
        :param str enabled_time: The opening time of the physical connection.
        :param str end_time: The expiration time of the shared line.Time is expressed according to ISO8601 standard and UTC time is used. The format is: YYYY-MM-DDThh:mm:ssZ.
        :param str expect_spec: The estimated bandwidth value of the shared line. The expected bandwidth value will not take effect until the payment is completed.Unit: **M** indicates Mbps,**G** indicates Gbps.
        :param str id: The ID of the Virtual Physical Connection.
        :param str line_operator: Operators that provide access to physical lines. Value:-**CT**: China Telecom.-**CU**: China Unicom.-**CM**: China Mobile.-**CO**: China Other.-**Equinix**:Equinix.-**Other**: Other abroad.
        :param str loa_status: The state of LOA. Value:-**Applying**:LOA application.-**Accept**:LOA application passed.-**Available**:LOA is Available.-**Rejected**:LOA application Rejected.-**Completing**: The dedicated line is under construction.-**Complete**: The construction of the dedicated line is completed.-**Deleted**:LOA has been Deleted.
        :param str order_mode: The payment method of shared dedicated line. Value:-**PayByPhysicalConnectionOwner**: indicates that the owner of the physical line associated with the shared line pays.-**PayByVirtualPhysicalConnectionOwner**: indicates that the owner of the shared line pays.
        :param str parent_physical_connection_ali_uid: The ID of the Alibaba Cloud account (primary account) to which the physical connection belongs.
        :param str parent_physical_connection_id: The ID of the instance of the physical connection.
        :param str peer_location: The geographic location of the local data center.
        :param str port_number: The port number of the physical connection device.
        :param str port_type: Physical connection port type. Value:-**100Base-T**: 100 megabytes port.-**1000Base-T**: Gigabit port.-**1000Base-LX**: Gigabit single mode optical port (10km).-**10GBase-T**: 10 Gigabit port.-**10GBase-LR**: 10 Gigabit single mode optical port (10km).-**40GBase-LR**: 40 megabytes single-mode optical port.-**100GBase-LR**: 100,000 megabytes single-mode optical port.
        :param str redundant_physical_connection_id: The ID of the redundant physical connection.
        :param str resource_group_id: The resource group id
        :param str spec: The bandwidth value of the shared line.Unit: **M** indicates Mbps,**G** indicates Gbps.
        :param str status: The status of the resource
        :param str virtual_physical_connection_id: The ID of the hosted connection
        :param str virtual_physical_connection_name: The name of the physical connection.
        :param str virtual_physical_connection_status: The business status of the shared line. Value:
               - **Confirmed**: The shared line has been Confirmed to receive.
               - **UnConfirmed**: The shared line has not been confirmed to be received.
               - **Deleted**: The shared line has been Deleted.
        :param int vlan_id: The VLAN ID of the shared leased line.
        :param str vpconn_ali_uid: The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
        """
        pulumi.set(__self__, "access_point_id", access_point_id)
        pulumi.set(__self__, "ad_location", ad_location)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "circuit_code", circuit_code)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled_time", enabled_time)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "expect_spec", expect_spec)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "line_operator", line_operator)
        pulumi.set(__self__, "loa_status", loa_status)
        pulumi.set(__self__, "order_mode", order_mode)
        pulumi.set(__self__, "parent_physical_connection_ali_uid", parent_physical_connection_ali_uid)
        pulumi.set(__self__, "parent_physical_connection_id", parent_physical_connection_id)
        pulumi.set(__self__, "peer_location", peer_location)
        pulumi.set(__self__, "port_number", port_number)
        pulumi.set(__self__, "port_type", port_type)
        pulumi.set(__self__, "redundant_physical_connection_id", redundant_physical_connection_id)
        pulumi.set(__self__, "resource_group_id", resource_group_id)
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "virtual_physical_connection_id", virtual_physical_connection_id)
        pulumi.set(__self__, "virtual_physical_connection_name", virtual_physical_connection_name)
        pulumi.set(__self__, "virtual_physical_connection_status", virtual_physical_connection_status)
        pulumi.set(__self__, "vlan_id", vlan_id)
        pulumi.set(__self__, "vpconn_ali_uid", vpconn_ali_uid)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> str:
        """
        The ID of the access point of the physical connection.
        """
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter(name="adLocation")
    def ad_location(self) -> str:
        """
        The physical location where the physical connection access device is located.
        """
        return pulumi.get(self, "ad_location")

    @property
    @pulumi.getter
    def bandwidth(self) -> str:
        """
        The bandwidth of the physical connection. Unit: Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> str:
        """
        The commercial status of the physical line. Value:
        - **Normal**: activated.
        - **Financialized**: Arrears locked.
        - **SecurityLocked**: locked for security reasons.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> str:
        """
        The circuit code provided by the operator for the physical connection.
        """
        return pulumi.get(self, "circuit_code")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the physical connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enabledTime")
    def enabled_time(self) -> str:
        """
        The opening time of the physical connection.
        """
        return pulumi.get(self, "enabled_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The expiration time of the shared line.Time is expressed according to ISO8601 standard and UTC time is used. The format is: YYYY-MM-DDThh:mm:ssZ.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="expectSpec")
    def expect_spec(self) -> str:
        """
        The estimated bandwidth value of the shared line. The expected bandwidth value will not take effect until the payment is completed.Unit: **M** indicates Mbps,**G** indicates Gbps.
        """
        return pulumi.get(self, "expect_spec")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the Virtual Physical Connection.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lineOperator")
    def line_operator(self) -> str:
        """
        Operators that provide access to physical lines. Value:-**CT**: China Telecom.-**CU**: China Unicom.-**CM**: China Mobile.-**CO**: China Other.-**Equinix**:Equinix.-**Other**: Other abroad.
        """
        return pulumi.get(self, "line_operator")

    @property
    @pulumi.getter(name="loaStatus")
    def loa_status(self) -> str:
        """
        The state of LOA. Value:-**Applying**:LOA application.-**Accept**:LOA application passed.-**Available**:LOA is Available.-**Rejected**:LOA application Rejected.-**Completing**: The dedicated line is under construction.-**Complete**: The construction of the dedicated line is completed.-**Deleted**:LOA has been Deleted.
        """
        return pulumi.get(self, "loa_status")

    @property
    @pulumi.getter(name="orderMode")
    def order_mode(self) -> str:
        """
        The payment method of shared dedicated line. Value:-**PayByPhysicalConnectionOwner**: indicates that the owner of the physical line associated with the shared line pays.-**PayByVirtualPhysicalConnectionOwner**: indicates that the owner of the shared line pays.
        """
        return pulumi.get(self, "order_mode")

    @property
    @pulumi.getter(name="parentPhysicalConnectionAliUid")
    def parent_physical_connection_ali_uid(self) -> str:
        """
        The ID of the Alibaba Cloud account (primary account) to which the physical connection belongs.
        """
        return pulumi.get(self, "parent_physical_connection_ali_uid")

    @property
    @pulumi.getter(name="parentPhysicalConnectionId")
    def parent_physical_connection_id(self) -> str:
        """
        The ID of the instance of the physical connection.
        """
        return pulumi.get(self, "parent_physical_connection_id")

    @property
    @pulumi.getter(name="peerLocation")
    def peer_location(self) -> str:
        """
        The geographic location of the local data center.
        """
        return pulumi.get(self, "peer_location")

    @property
    @pulumi.getter(name="portNumber")
    def port_number(self) -> str:
        """
        The port number of the physical connection device.
        """
        return pulumi.get(self, "port_number")

    @property
    @pulumi.getter(name="portType")
    def port_type(self) -> str:
        """
        Physical connection port type. Value:-**100Base-T**: 100 megabytes port.-**1000Base-T**: Gigabit port.-**1000Base-LX**: Gigabit single mode optical port (10km).-**10GBase-T**: 10 Gigabit port.-**10GBase-LR**: 10 Gigabit single mode optical port (10km).-**40GBase-LR**: 40 megabytes single-mode optical port.-**100GBase-LR**: 100,000 megabytes single-mode optical port.
        """
        return pulumi.get(self, "port_type")

    @property
    @pulumi.getter(name="redundantPhysicalConnectionId")
    def redundant_physical_connection_id(self) -> str:
        """
        The ID of the redundant physical connection.
        """
        return pulumi.get(self, "redundant_physical_connection_id")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> str:
        """
        The resource group id
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def spec(self) -> str:
        """
        The bandwidth value of the shared line.Unit: **M** indicates Mbps,**G** indicates Gbps.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="virtualPhysicalConnectionId")
    def virtual_physical_connection_id(self) -> str:
        """
        The ID of the hosted connection
        """
        return pulumi.get(self, "virtual_physical_connection_id")

    @property
    @pulumi.getter(name="virtualPhysicalConnectionName")
    def virtual_physical_connection_name(self) -> str:
        """
        The name of the physical connection.
        """
        return pulumi.get(self, "virtual_physical_connection_name")

    @property
    @pulumi.getter(name="virtualPhysicalConnectionStatus")
    def virtual_physical_connection_status(self) -> str:
        """
        The business status of the shared line. Value:
        - **Confirmed**: The shared line has been Confirmed to receive.
        - **UnConfirmed**: The shared line has not been confirmed to be received.
        - **Deleted**: The shared line has been Deleted.
        """
        return pulumi.get(self, "virtual_physical_connection_status")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> int:
        """
        The VLAN ID of the shared leased line.
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vpconnAliUid")
    def vpconn_ali_uid(self) -> str:
        """
        The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
        """
        return pulumi.get(self, "vpconn_ali_uid")


