# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['PhysicalConnectionArgs', 'PhysicalConnection']

@pulumi.input_type
class PhysicalConnectionArgs:
    def __init__(__self__, *,
                 access_point_id: pulumi.Input[str],
                 line_operator: pulumi.Input[str],
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 circuit_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 peer_location: Optional[pulumi.Input[str]] = None,
                 physical_connection_name: Optional[pulumi.Input[str]] = None,
                 port_type: Optional[pulumi.Input[str]] = None,
                 redundant_physical_connection_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PhysicalConnection resource.
        :param pulumi.Input[str] access_point_id: The Physical Leased Line Access Point ID.
        :param pulumi.Input[str] line_operator: Provides Access to the Physical Line Operator. Valid values:
               * CT: China Telecom
               * CU: China Unicom
               * CM: china Mobile
               * CO: Other Chinese
               * Equinix: Equinix
               * Other: Other Overseas.
        :param pulumi.Input[str] bandwidth: On the Bandwidth of the ECC Service and Physical Connection.
        :param pulumi.Input[str] circuit_code: Operators for Physical Connection Circuit Provided Coding.
        :param pulumi.Input[str] description: The Physical Connection to Which the Description.
        :param pulumi.Input[str] peer_location: and an on-Premises Data Center Location.
        :param pulumi.Input[str] physical_connection_name: on Behalf of the Resource Name of the Resources-Attribute Field.
        :param pulumi.Input[str] port_type: The Physical Leased Line Access Port Type. Valid value:
               * 100Base-T: Fast Electrical Ports
               * 1000Base-T: gigabit Electrical Ports
               * 1000Base-LX: Gigabit Singlemode Optical Ports (10Km)
               * 10GBase-T: Gigabit Electrical Port
               * 10GBase-LR: Gigabit Singlemode Optical Ports (10Km).
               * 40GBase-LR: 40 Gigabit Singlemode Optical Ports.
               * 100GBase-LR: One hundred thousand Gigabit Singlemode Optical Ports.
               
               **NOTE:** From in v1.185.0+, The `40GBase-LR` and `100GBase-LR` is valid. and Set these values based on the water levels of background ports. For details about the water levels, contact the business manager.
        :param pulumi.Input[str] redundant_physical_connection_id: Redundant Physical Connection to Which the ID.
        :param pulumi.Input[str] status: Resources on Behalf of a State of the Resource Attribute Field. Valid values: `Canceled`, `Enabled`, `Terminated`.
        :param pulumi.Input[str] type: Physical Private Line of Type. Default Value: VPC.
        """
        pulumi.set(__self__, "access_point_id", access_point_id)
        pulumi.set(__self__, "line_operator", line_operator)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if circuit_code is not None:
            pulumi.set(__self__, "circuit_code", circuit_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if peer_location is not None:
            pulumi.set(__self__, "peer_location", peer_location)
        if physical_connection_name is not None:
            pulumi.set(__self__, "physical_connection_name", physical_connection_name)
        if port_type is not None:
            pulumi.set(__self__, "port_type", port_type)
        if redundant_physical_connection_id is not None:
            pulumi.set(__self__, "redundant_physical_connection_id", redundant_physical_connection_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> pulumi.Input[str]:
        """
        The Physical Leased Line Access Point ID.
        """
        return pulumi.get(self, "access_point_id")

    @access_point_id.setter
    def access_point_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "access_point_id", value)

    @property
    @pulumi.getter(name="lineOperator")
    def line_operator(self) -> pulumi.Input[str]:
        """
        Provides Access to the Physical Line Operator. Valid values:
        * CT: China Telecom
        * CU: China Unicom
        * CM: china Mobile
        * CO: Other Chinese
        * Equinix: Equinix
        * Other: Other Overseas.
        """
        return pulumi.get(self, "line_operator")

    @line_operator.setter
    def line_operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "line_operator", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        On the Bandwidth of the ECC Service and Physical Connection.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> Optional[pulumi.Input[str]]:
        """
        Operators for Physical Connection Circuit Provided Coding.
        """
        return pulumi.get(self, "circuit_code")

    @circuit_code.setter
    def circuit_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "circuit_code", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The Physical Connection to Which the Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="peerLocation")
    def peer_location(self) -> Optional[pulumi.Input[str]]:
        """
        and an on-Premises Data Center Location.
        """
        return pulumi.get(self, "peer_location")

    @peer_location.setter
    def peer_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_location", value)

    @property
    @pulumi.getter(name="physicalConnectionName")
    def physical_connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        on Behalf of the Resource Name of the Resources-Attribute Field.
        """
        return pulumi.get(self, "physical_connection_name")

    @physical_connection_name.setter
    def physical_connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "physical_connection_name", value)

    @property
    @pulumi.getter(name="portType")
    def port_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Physical Leased Line Access Port Type. Valid value:
        * 100Base-T: Fast Electrical Ports
        * 1000Base-T: gigabit Electrical Ports
        * 1000Base-LX: Gigabit Singlemode Optical Ports (10Km)
        * 10GBase-T: Gigabit Electrical Port
        * 10GBase-LR: Gigabit Singlemode Optical Ports (10Km).
        * 40GBase-LR: 40 Gigabit Singlemode Optical Ports.
        * 100GBase-LR: One hundred thousand Gigabit Singlemode Optical Ports.

        **NOTE:** From in v1.185.0+, The `40GBase-LR` and `100GBase-LR` is valid. and Set these values based on the water levels of background ports. For details about the water levels, contact the business manager.
        """
        return pulumi.get(self, "port_type")

    @port_type.setter
    def port_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_type", value)

    @property
    @pulumi.getter(name="redundantPhysicalConnectionId")
    def redundant_physical_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        Redundant Physical Connection to Which the ID.
        """
        return pulumi.get(self, "redundant_physical_connection_id")

    @redundant_physical_connection_id.setter
    def redundant_physical_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundant_physical_connection_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Resources on Behalf of a State of the Resource Attribute Field. Valid values: `Canceled`, `Enabled`, `Terminated`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Physical Private Line of Type. Default Value: VPC.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _PhysicalConnectionState:
    def __init__(__self__, *,
                 access_point_id: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 circuit_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 line_operator: Optional[pulumi.Input[str]] = None,
                 peer_location: Optional[pulumi.Input[str]] = None,
                 physical_connection_name: Optional[pulumi.Input[str]] = None,
                 port_type: Optional[pulumi.Input[str]] = None,
                 redundant_physical_connection_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PhysicalConnection resources.
        :param pulumi.Input[str] access_point_id: The Physical Leased Line Access Point ID.
        :param pulumi.Input[str] bandwidth: On the Bandwidth of the ECC Service and Physical Connection.
        :param pulumi.Input[str] circuit_code: Operators for Physical Connection Circuit Provided Coding.
        :param pulumi.Input[str] description: The Physical Connection to Which the Description.
        :param pulumi.Input[str] line_operator: Provides Access to the Physical Line Operator. Valid values:
               * CT: China Telecom
               * CU: China Unicom
               * CM: china Mobile
               * CO: Other Chinese
               * Equinix: Equinix
               * Other: Other Overseas.
        :param pulumi.Input[str] peer_location: and an on-Premises Data Center Location.
        :param pulumi.Input[str] physical_connection_name: on Behalf of the Resource Name of the Resources-Attribute Field.
        :param pulumi.Input[str] port_type: The Physical Leased Line Access Port Type. Valid value:
               * 100Base-T: Fast Electrical Ports
               * 1000Base-T: gigabit Electrical Ports
               * 1000Base-LX: Gigabit Singlemode Optical Ports (10Km)
               * 10GBase-T: Gigabit Electrical Port
               * 10GBase-LR: Gigabit Singlemode Optical Ports (10Km).
               * 40GBase-LR: 40 Gigabit Singlemode Optical Ports.
               * 100GBase-LR: One hundred thousand Gigabit Singlemode Optical Ports.
               
               **NOTE:** From in v1.185.0+, The `40GBase-LR` and `100GBase-LR` is valid. and Set these values based on the water levels of background ports. For details about the water levels, contact the business manager.
        :param pulumi.Input[str] redundant_physical_connection_id: Redundant Physical Connection to Which the ID.
        :param pulumi.Input[str] status: Resources on Behalf of a State of the Resource Attribute Field. Valid values: `Canceled`, `Enabled`, `Terminated`.
        :param pulumi.Input[str] type: Physical Private Line of Type. Default Value: VPC.
        """
        if access_point_id is not None:
            pulumi.set(__self__, "access_point_id", access_point_id)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if circuit_code is not None:
            pulumi.set(__self__, "circuit_code", circuit_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if line_operator is not None:
            pulumi.set(__self__, "line_operator", line_operator)
        if peer_location is not None:
            pulumi.set(__self__, "peer_location", peer_location)
        if physical_connection_name is not None:
            pulumi.set(__self__, "physical_connection_name", physical_connection_name)
        if port_type is not None:
            pulumi.set(__self__, "port_type", port_type)
        if redundant_physical_connection_id is not None:
            pulumi.set(__self__, "redundant_physical_connection_id", redundant_physical_connection_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Physical Leased Line Access Point ID.
        """
        return pulumi.get(self, "access_point_id")

    @access_point_id.setter
    def access_point_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_point_id", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        On the Bandwidth of the ECC Service and Physical Connection.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> Optional[pulumi.Input[str]]:
        """
        Operators for Physical Connection Circuit Provided Coding.
        """
        return pulumi.get(self, "circuit_code")

    @circuit_code.setter
    def circuit_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "circuit_code", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The Physical Connection to Which the Description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="lineOperator")
    def line_operator(self) -> Optional[pulumi.Input[str]]:
        """
        Provides Access to the Physical Line Operator. Valid values:
        * CT: China Telecom
        * CU: China Unicom
        * CM: china Mobile
        * CO: Other Chinese
        * Equinix: Equinix
        * Other: Other Overseas.
        """
        return pulumi.get(self, "line_operator")

    @line_operator.setter
    def line_operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "line_operator", value)

    @property
    @pulumi.getter(name="peerLocation")
    def peer_location(self) -> Optional[pulumi.Input[str]]:
        """
        and an on-Premises Data Center Location.
        """
        return pulumi.get(self, "peer_location")

    @peer_location.setter
    def peer_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_location", value)

    @property
    @pulumi.getter(name="physicalConnectionName")
    def physical_connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        on Behalf of the Resource Name of the Resources-Attribute Field.
        """
        return pulumi.get(self, "physical_connection_name")

    @physical_connection_name.setter
    def physical_connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "physical_connection_name", value)

    @property
    @pulumi.getter(name="portType")
    def port_type(self) -> Optional[pulumi.Input[str]]:
        """
        The Physical Leased Line Access Port Type. Valid value:
        * 100Base-T: Fast Electrical Ports
        * 1000Base-T: gigabit Electrical Ports
        * 1000Base-LX: Gigabit Singlemode Optical Ports (10Km)
        * 10GBase-T: Gigabit Electrical Port
        * 10GBase-LR: Gigabit Singlemode Optical Ports (10Km).
        * 40GBase-LR: 40 Gigabit Singlemode Optical Ports.
        * 100GBase-LR: One hundred thousand Gigabit Singlemode Optical Ports.

        **NOTE:** From in v1.185.0+, The `40GBase-LR` and `100GBase-LR` is valid. and Set these values based on the water levels of background ports. For details about the water levels, contact the business manager.
        """
        return pulumi.get(self, "port_type")

    @port_type.setter
    def port_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_type", value)

    @property
    @pulumi.getter(name="redundantPhysicalConnectionId")
    def redundant_physical_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        Redundant Physical Connection to Which the ID.
        """
        return pulumi.get(self, "redundant_physical_connection_id")

    @redundant_physical_connection_id.setter
    def redundant_physical_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundant_physical_connection_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Resources on Behalf of a State of the Resource Attribute Field. Valid values: `Canceled`, `Enabled`, `Terminated`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Physical Private Line of Type. Default Value: VPC.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class PhysicalConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_id: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 circuit_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 line_operator: Optional[pulumi.Input[str]] = None,
                 peer_location: Optional[pulumi.Input[str]] = None,
                 physical_connection_name: Optional[pulumi.Input[str]] = None,
                 port_type: Optional[pulumi.Input[str]] = None,
                 redundant_physical_connection_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Express Connect Physical Connection resource.

        For information about Express Connect Physical Connection and how to use it, see [What is Physical Connection](https://www.alibabacloud.com/help/doc-detail/44852.htm).

        > **NOTE:** Available since v1.132.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        domestic = alicloud.expressconnect.PhysicalConnection("domestic",
            access_point_id="ap-cn-hangzhou-yh-B",
            bandwidth="100",
            description="my domestic connection",
            line_operator="CT",
            peer_location="example_value",
            physical_connection_name="example_value",
            port_type="1000Base-LX",
            type="VPC")
        international = alicloud.expressconnect.PhysicalConnection("international",
            access_point_id="ap-sg-singpore-A",
            bandwidth="100",
            description="my domestic connection",
            line_operator="Other",
            peer_location="example_value",
            physical_connection_name="example_value",
            port_type="1000Base-LX",
            type="VPC")
        ```

        ## Import

        Express Connect Physical Connection can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:expressconnect/physicalConnection:PhysicalConnection example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_point_id: The Physical Leased Line Access Point ID.
        :param pulumi.Input[str] bandwidth: On the Bandwidth of the ECC Service and Physical Connection.
        :param pulumi.Input[str] circuit_code: Operators for Physical Connection Circuit Provided Coding.
        :param pulumi.Input[str] description: The Physical Connection to Which the Description.
        :param pulumi.Input[str] line_operator: Provides Access to the Physical Line Operator. Valid values:
               * CT: China Telecom
               * CU: China Unicom
               * CM: china Mobile
               * CO: Other Chinese
               * Equinix: Equinix
               * Other: Other Overseas.
        :param pulumi.Input[str] peer_location: and an on-Premises Data Center Location.
        :param pulumi.Input[str] physical_connection_name: on Behalf of the Resource Name of the Resources-Attribute Field.
        :param pulumi.Input[str] port_type: The Physical Leased Line Access Port Type. Valid value:
               * 100Base-T: Fast Electrical Ports
               * 1000Base-T: gigabit Electrical Ports
               * 1000Base-LX: Gigabit Singlemode Optical Ports (10Km)
               * 10GBase-T: Gigabit Electrical Port
               * 10GBase-LR: Gigabit Singlemode Optical Ports (10Km).
               * 40GBase-LR: 40 Gigabit Singlemode Optical Ports.
               * 100GBase-LR: One hundred thousand Gigabit Singlemode Optical Ports.
               
               **NOTE:** From in v1.185.0+, The `40GBase-LR` and `100GBase-LR` is valid. and Set these values based on the water levels of background ports. For details about the water levels, contact the business manager.
        :param pulumi.Input[str] redundant_physical_connection_id: Redundant Physical Connection to Which the ID.
        :param pulumi.Input[str] status: Resources on Behalf of a State of the Resource Attribute Field. Valid values: `Canceled`, `Enabled`, `Terminated`.
        :param pulumi.Input[str] type: Physical Private Line of Type. Default Value: VPC.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PhysicalConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Express Connect Physical Connection resource.

        For information about Express Connect Physical Connection and how to use it, see [What is Physical Connection](https://www.alibabacloud.com/help/doc-detail/44852.htm).

        > **NOTE:** Available since v1.132.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        domestic = alicloud.expressconnect.PhysicalConnection("domestic",
            access_point_id="ap-cn-hangzhou-yh-B",
            bandwidth="100",
            description="my domestic connection",
            line_operator="CT",
            peer_location="example_value",
            physical_connection_name="example_value",
            port_type="1000Base-LX",
            type="VPC")
        international = alicloud.expressconnect.PhysicalConnection("international",
            access_point_id="ap-sg-singpore-A",
            bandwidth="100",
            description="my domestic connection",
            line_operator="Other",
            peer_location="example_value",
            physical_connection_name="example_value",
            port_type="1000Base-LX",
            type="VPC")
        ```

        ## Import

        Express Connect Physical Connection can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:expressconnect/physicalConnection:PhysicalConnection example <id>
        ```

        :param str resource_name: The name of the resource.
        :param PhysicalConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PhysicalConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_point_id: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 circuit_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 line_operator: Optional[pulumi.Input[str]] = None,
                 peer_location: Optional[pulumi.Input[str]] = None,
                 physical_connection_name: Optional[pulumi.Input[str]] = None,
                 port_type: Optional[pulumi.Input[str]] = None,
                 redundant_physical_connection_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PhysicalConnectionArgs.__new__(PhysicalConnectionArgs)

            if access_point_id is None and not opts.urn:
                raise TypeError("Missing required property 'access_point_id'")
            __props__.__dict__["access_point_id"] = access_point_id
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["circuit_code"] = circuit_code
            __props__.__dict__["description"] = description
            if line_operator is None and not opts.urn:
                raise TypeError("Missing required property 'line_operator'")
            __props__.__dict__["line_operator"] = line_operator
            __props__.__dict__["peer_location"] = peer_location
            __props__.__dict__["physical_connection_name"] = physical_connection_name
            __props__.__dict__["port_type"] = port_type
            __props__.__dict__["redundant_physical_connection_id"] = redundant_physical_connection_id
            __props__.__dict__["status"] = status
            __props__.__dict__["type"] = type
        super(PhysicalConnection, __self__).__init__(
            'alicloud:expressconnect/physicalConnection:PhysicalConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_point_id: Optional[pulumi.Input[str]] = None,
            bandwidth: Optional[pulumi.Input[str]] = None,
            circuit_code: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            line_operator: Optional[pulumi.Input[str]] = None,
            peer_location: Optional[pulumi.Input[str]] = None,
            physical_connection_name: Optional[pulumi.Input[str]] = None,
            port_type: Optional[pulumi.Input[str]] = None,
            redundant_physical_connection_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'PhysicalConnection':
        """
        Get an existing PhysicalConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_point_id: The Physical Leased Line Access Point ID.
        :param pulumi.Input[str] bandwidth: On the Bandwidth of the ECC Service and Physical Connection.
        :param pulumi.Input[str] circuit_code: Operators for Physical Connection Circuit Provided Coding.
        :param pulumi.Input[str] description: The Physical Connection to Which the Description.
        :param pulumi.Input[str] line_operator: Provides Access to the Physical Line Operator. Valid values:
               * CT: China Telecom
               * CU: China Unicom
               * CM: china Mobile
               * CO: Other Chinese
               * Equinix: Equinix
               * Other: Other Overseas.
        :param pulumi.Input[str] peer_location: and an on-Premises Data Center Location.
        :param pulumi.Input[str] physical_connection_name: on Behalf of the Resource Name of the Resources-Attribute Field.
        :param pulumi.Input[str] port_type: The Physical Leased Line Access Port Type. Valid value:
               * 100Base-T: Fast Electrical Ports
               * 1000Base-T: gigabit Electrical Ports
               * 1000Base-LX: Gigabit Singlemode Optical Ports (10Km)
               * 10GBase-T: Gigabit Electrical Port
               * 10GBase-LR: Gigabit Singlemode Optical Ports (10Km).
               * 40GBase-LR: 40 Gigabit Singlemode Optical Ports.
               * 100GBase-LR: One hundred thousand Gigabit Singlemode Optical Ports.
               
               **NOTE:** From in v1.185.0+, The `40GBase-LR` and `100GBase-LR` is valid. and Set these values based on the water levels of background ports. For details about the water levels, contact the business manager.
        :param pulumi.Input[str] redundant_physical_connection_id: Redundant Physical Connection to Which the ID.
        :param pulumi.Input[str] status: Resources on Behalf of a State of the Resource Attribute Field. Valid values: `Canceled`, `Enabled`, `Terminated`.
        :param pulumi.Input[str] type: Physical Private Line of Type. Default Value: VPC.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PhysicalConnectionState.__new__(_PhysicalConnectionState)

        __props__.__dict__["access_point_id"] = access_point_id
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["circuit_code"] = circuit_code
        __props__.__dict__["description"] = description
        __props__.__dict__["line_operator"] = line_operator
        __props__.__dict__["peer_location"] = peer_location
        __props__.__dict__["physical_connection_name"] = physical_connection_name
        __props__.__dict__["port_type"] = port_type
        __props__.__dict__["redundant_physical_connection_id"] = redundant_physical_connection_id
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return PhysicalConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> pulumi.Output[str]:
        """
        The Physical Leased Line Access Point ID.
        """
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[str]:
        """
        On the Bandwidth of the ECC Service and Physical Connection.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> pulumi.Output[Optional[str]]:
        """
        Operators for Physical Connection Circuit Provided Coding.
        """
        return pulumi.get(self, "circuit_code")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The Physical Connection to Which the Description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="lineOperator")
    def line_operator(self) -> pulumi.Output[str]:
        """
        Provides Access to the Physical Line Operator. Valid values:
        * CT: China Telecom
        * CU: China Unicom
        * CM: china Mobile
        * CO: Other Chinese
        * Equinix: Equinix
        * Other: Other Overseas.
        """
        return pulumi.get(self, "line_operator")

    @property
    @pulumi.getter(name="peerLocation")
    def peer_location(self) -> pulumi.Output[Optional[str]]:
        """
        and an on-Premises Data Center Location.
        """
        return pulumi.get(self, "peer_location")

    @property
    @pulumi.getter(name="physicalConnectionName")
    def physical_connection_name(self) -> pulumi.Output[Optional[str]]:
        """
        on Behalf of the Resource Name of the Resources-Attribute Field.
        """
        return pulumi.get(self, "physical_connection_name")

    @property
    @pulumi.getter(name="portType")
    def port_type(self) -> pulumi.Output[Optional[str]]:
        """
        The Physical Leased Line Access Port Type. Valid value:
        * 100Base-T: Fast Electrical Ports
        * 1000Base-T: gigabit Electrical Ports
        * 1000Base-LX: Gigabit Singlemode Optical Ports (10Km)
        * 10GBase-T: Gigabit Electrical Port
        * 10GBase-LR: Gigabit Singlemode Optical Ports (10Km).
        * 40GBase-LR: 40 Gigabit Singlemode Optical Ports.
        * 100GBase-LR: One hundred thousand Gigabit Singlemode Optical Ports.

        **NOTE:** From in v1.185.0+, The `40GBase-LR` and `100GBase-LR` is valid. and Set these values based on the water levels of background ports. For details about the water levels, contact the business manager.
        """
        return pulumi.get(self, "port_type")

    @property
    @pulumi.getter(name="redundantPhysicalConnectionId")
    def redundant_physical_connection_id(self) -> pulumi.Output[Optional[str]]:
        """
        Redundant Physical Connection to Which the ID.
        """
        return pulumi.get(self, "redundant_physical_connection_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Resources on Behalf of a State of the Resource Attribute Field. Valid values: `Canceled`, `Enabled`, `Terminated`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Physical Private Line of Type. Default Value: VPC.
        """
        return pulumi.get(self, "type")

