# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VirtualBorderRouterArgs', 'VirtualBorderRouter']

@pulumi.input_type
class VirtualBorderRouterArgs:
    def __init__(__self__, *,
                 local_gateway_ip: pulumi.Input[str],
                 peer_gateway_ip: pulumi.Input[str],
                 peering_subnet_mask: pulumi.Input[str],
                 physical_connection_id: pulumi.Input[str],
                 vlan_id: pulumi.Input[int],
                 associated_physical_connections: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 circuit_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 detect_multiplier: Optional[pulumi.Input[int]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 include_cross_account_vbr: Optional[pulumi.Input[bool]] = None,
                 local_ipv6_gateway_ip: Optional[pulumi.Input[str]] = None,
                 min_rx_interval: Optional[pulumi.Input[int]] = None,
                 min_tx_interval: Optional[pulumi.Input[int]] = None,
                 peer_ipv6_gateway_ip: Optional[pulumi.Input[str]] = None,
                 peering_ipv6_subnet_mask: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vbr_owner_id: Optional[pulumi.Input[str]] = None,
                 virtual_border_router_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VirtualBorderRouter resource.
        :param pulumi.Input[str] local_gateway_ip: Alibaba Cloud-Connected IPv4 address.
        :param pulumi.Input[str] peer_gateway_ip: The Client-Side Interconnection IPv4 Address.
        :param pulumi.Input[str] peering_subnet_mask: Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        :param pulumi.Input[str] physical_connection_id: The ID of the Physical Connection to Which the ID.
        :param pulumi.Input[int] vlan_id: The VLAN ID of the VBR. Value range: 0~2999.
        :param pulumi.Input[str] associated_physical_connections: The associated physical connections.
        :param pulumi.Input[int] bandwidth: The bandwidth.
        :param pulumi.Input[str] circuit_code: Operators for physical connection circuit provided coding.
        :param pulumi.Input[str] description: The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        :param pulumi.Input[int] detect_multiplier: Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        :param pulumi.Input[bool] enable_ipv6: Whether to Enable IPv6. Valid values: `false`, `true`.
        :param pulumi.Input[bool] include_cross_account_vbr: Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
        :param pulumi.Input[str] local_ipv6_gateway_ip: Alibaba Cloud-Connected IPv6 Address.
        :param pulumi.Input[int] min_rx_interval: Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        :param pulumi.Input[int] min_tx_interval: Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        :param pulumi.Input[str] peer_ipv6_gateway_ip: The Client-Side Interconnection IPv6 Address.
        :param pulumi.Input[str] peering_ipv6_subnet_mask: Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        :param pulumi.Input[str] status: The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
        :param pulumi.Input[str] vbr_owner_id: The vbr owner id.
        :param pulumi.Input[str] virtual_border_router_name: The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        """
        pulumi.set(__self__, "local_gateway_ip", local_gateway_ip)
        pulumi.set(__self__, "peer_gateway_ip", peer_gateway_ip)
        pulumi.set(__self__, "peering_subnet_mask", peering_subnet_mask)
        pulumi.set(__self__, "physical_connection_id", physical_connection_id)
        pulumi.set(__self__, "vlan_id", vlan_id)
        if associated_physical_connections is not None:
            pulumi.set(__self__, "associated_physical_connections", associated_physical_connections)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if circuit_code is not None:
            pulumi.set(__self__, "circuit_code", circuit_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detect_multiplier is not None:
            pulumi.set(__self__, "detect_multiplier", detect_multiplier)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if include_cross_account_vbr is not None:
            pulumi.set(__self__, "include_cross_account_vbr", include_cross_account_vbr)
        if local_ipv6_gateway_ip is not None:
            pulumi.set(__self__, "local_ipv6_gateway_ip", local_ipv6_gateway_ip)
        if min_rx_interval is not None:
            pulumi.set(__self__, "min_rx_interval", min_rx_interval)
        if min_tx_interval is not None:
            pulumi.set(__self__, "min_tx_interval", min_tx_interval)
        if peer_ipv6_gateway_ip is not None:
            pulumi.set(__self__, "peer_ipv6_gateway_ip", peer_ipv6_gateway_ip)
        if peering_ipv6_subnet_mask is not None:
            pulumi.set(__self__, "peering_ipv6_subnet_mask", peering_ipv6_subnet_mask)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vbr_owner_id is not None:
            pulumi.set(__self__, "vbr_owner_id", vbr_owner_id)
        if virtual_border_router_name is not None:
            pulumi.set(__self__, "virtual_border_router_name", virtual_border_router_name)

    @property
    @pulumi.getter(name="localGatewayIp")
    def local_gateway_ip(self) -> pulumi.Input[str]:
        """
        Alibaba Cloud-Connected IPv4 address.
        """
        return pulumi.get(self, "local_gateway_ip")

    @local_gateway_ip.setter
    def local_gateway_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "local_gateway_ip", value)

    @property
    @pulumi.getter(name="peerGatewayIp")
    def peer_gateway_ip(self) -> pulumi.Input[str]:
        """
        The Client-Side Interconnection IPv4 Address.
        """
        return pulumi.get(self, "peer_gateway_ip")

    @peer_gateway_ip.setter
    def peer_gateway_ip(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_gateway_ip", value)

    @property
    @pulumi.getter(name="peeringSubnetMask")
    def peering_subnet_mask(self) -> pulumi.Input[str]:
        """
        Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        """
        return pulumi.get(self, "peering_subnet_mask")

    @peering_subnet_mask.setter
    def peering_subnet_mask(self, value: pulumi.Input[str]):
        pulumi.set(self, "peering_subnet_mask", value)

    @property
    @pulumi.getter(name="physicalConnectionId")
    def physical_connection_id(self) -> pulumi.Input[str]:
        """
        The ID of the Physical Connection to Which the ID.
        """
        return pulumi.get(self, "physical_connection_id")

    @physical_connection_id.setter
    def physical_connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "physical_connection_id", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Input[int]:
        """
        The VLAN ID of the VBR. Value range: 0~2999.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter(name="associatedPhysicalConnections")
    def associated_physical_connections(self) -> Optional[pulumi.Input[str]]:
        """
        The associated physical connections.
        """
        return pulumi.get(self, "associated_physical_connections")

    @associated_physical_connections.setter
    def associated_physical_connections(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "associated_physical_connections", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> Optional[pulumi.Input[str]]:
        """
        Operators for physical connection circuit provided coding.
        """
        return pulumi.get(self, "circuit_code")

    @circuit_code.setter
    def circuit_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "circuit_code", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="detectMultiplier")
    def detect_multiplier(self) -> Optional[pulumi.Input[int]]:
        """
        Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        """
        return pulumi.get(self, "detect_multiplier")

    @detect_multiplier.setter
    def detect_multiplier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "detect_multiplier", value)

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to Enable IPv6. Valid values: `false`, `true`.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @property
    @pulumi.getter(name="includeCrossAccountVbr")
    def include_cross_account_vbr(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
        """
        return pulumi.get(self, "include_cross_account_vbr")

    @include_cross_account_vbr.setter
    def include_cross_account_vbr(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_cross_account_vbr", value)

    @property
    @pulumi.getter(name="localIpv6GatewayIp")
    def local_ipv6_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Alibaba Cloud-Connected IPv6 Address.
        """
        return pulumi.get(self, "local_ipv6_gateway_ip")

    @local_ipv6_gateway_ip.setter
    def local_ipv6_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_ipv6_gateway_ip", value)

    @property
    @pulumi.getter(name="minRxInterval")
    def min_rx_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        """
        return pulumi.get(self, "min_rx_interval")

    @min_rx_interval.setter
    def min_rx_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_rx_interval", value)

    @property
    @pulumi.getter(name="minTxInterval")
    def min_tx_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        """
        return pulumi.get(self, "min_tx_interval")

    @min_tx_interval.setter
    def min_tx_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_tx_interval", value)

    @property
    @pulumi.getter(name="peerIpv6GatewayIp")
    def peer_ipv6_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The Client-Side Interconnection IPv6 Address.
        """
        return pulumi.get(self, "peer_ipv6_gateway_ip")

    @peer_ipv6_gateway_ip.setter
    def peer_ipv6_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_ipv6_gateway_ip", value)

    @property
    @pulumi.getter(name="peeringIpv6SubnetMask")
    def peering_ipv6_subnet_mask(self) -> Optional[pulumi.Input[str]]:
        """
        Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        """
        return pulumi.get(self, "peering_ipv6_subnet_mask")

    @peering_ipv6_subnet_mask.setter
    def peering_ipv6_subnet_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ipv6_subnet_mask", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="vbrOwnerId")
    def vbr_owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vbr owner id.
        """
        return pulumi.get(self, "vbr_owner_id")

    @vbr_owner_id.setter
    def vbr_owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vbr_owner_id", value)

    @property
    @pulumi.getter(name="virtualBorderRouterName")
    def virtual_border_router_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        """
        return pulumi.get(self, "virtual_border_router_name")

    @virtual_border_router_name.setter
    def virtual_border_router_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_border_router_name", value)


@pulumi.input_type
class _VirtualBorderRouterState:
    def __init__(__self__, *,
                 associated_physical_connections: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 circuit_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 detect_multiplier: Optional[pulumi.Input[int]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 include_cross_account_vbr: Optional[pulumi.Input[bool]] = None,
                 local_gateway_ip: Optional[pulumi.Input[str]] = None,
                 local_ipv6_gateway_ip: Optional[pulumi.Input[str]] = None,
                 min_rx_interval: Optional[pulumi.Input[int]] = None,
                 min_tx_interval: Optional[pulumi.Input[int]] = None,
                 peer_gateway_ip: Optional[pulumi.Input[str]] = None,
                 peer_ipv6_gateway_ip: Optional[pulumi.Input[str]] = None,
                 peering_ipv6_subnet_mask: Optional[pulumi.Input[str]] = None,
                 peering_subnet_mask: Optional[pulumi.Input[str]] = None,
                 physical_connection_id: Optional[pulumi.Input[str]] = None,
                 route_table_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vbr_owner_id: Optional[pulumi.Input[str]] = None,
                 virtual_border_router_name: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering VirtualBorderRouter resources.
        :param pulumi.Input[str] associated_physical_connections: The associated physical connections.
        :param pulumi.Input[int] bandwidth: The bandwidth.
        :param pulumi.Input[str] circuit_code: Operators for physical connection circuit provided coding.
        :param pulumi.Input[str] description: The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        :param pulumi.Input[int] detect_multiplier: Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        :param pulumi.Input[bool] enable_ipv6: Whether to Enable IPv6. Valid values: `false`, `true`.
        :param pulumi.Input[bool] include_cross_account_vbr: Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
        :param pulumi.Input[str] local_gateway_ip: Alibaba Cloud-Connected IPv4 address.
        :param pulumi.Input[str] local_ipv6_gateway_ip: Alibaba Cloud-Connected IPv6 Address.
        :param pulumi.Input[int] min_rx_interval: Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        :param pulumi.Input[int] min_tx_interval: Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        :param pulumi.Input[str] peer_gateway_ip: The Client-Side Interconnection IPv4 Address.
        :param pulumi.Input[str] peer_ipv6_gateway_ip: The Client-Side Interconnection IPv6 Address.
        :param pulumi.Input[str] peering_ipv6_subnet_mask: Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        :param pulumi.Input[str] peering_subnet_mask: Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        :param pulumi.Input[str] physical_connection_id: The ID of the Physical Connection to Which the ID.
        :param pulumi.Input[str] route_table_id: (Available in v1.166.0+) The Route Table ID Of the Virtual Border Router.
        :param pulumi.Input[str] status: The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
        :param pulumi.Input[str] vbr_owner_id: The vbr owner id.
        :param pulumi.Input[str] virtual_border_router_name: The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        :param pulumi.Input[int] vlan_id: The VLAN ID of the VBR. Value range: 0~2999.
        """
        if associated_physical_connections is not None:
            pulumi.set(__self__, "associated_physical_connections", associated_physical_connections)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if circuit_code is not None:
            pulumi.set(__self__, "circuit_code", circuit_code)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if detect_multiplier is not None:
            pulumi.set(__self__, "detect_multiplier", detect_multiplier)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if include_cross_account_vbr is not None:
            pulumi.set(__self__, "include_cross_account_vbr", include_cross_account_vbr)
        if local_gateway_ip is not None:
            pulumi.set(__self__, "local_gateway_ip", local_gateway_ip)
        if local_ipv6_gateway_ip is not None:
            pulumi.set(__self__, "local_ipv6_gateway_ip", local_ipv6_gateway_ip)
        if min_rx_interval is not None:
            pulumi.set(__self__, "min_rx_interval", min_rx_interval)
        if min_tx_interval is not None:
            pulumi.set(__self__, "min_tx_interval", min_tx_interval)
        if peer_gateway_ip is not None:
            pulumi.set(__self__, "peer_gateway_ip", peer_gateway_ip)
        if peer_ipv6_gateway_ip is not None:
            pulumi.set(__self__, "peer_ipv6_gateway_ip", peer_ipv6_gateway_ip)
        if peering_ipv6_subnet_mask is not None:
            pulumi.set(__self__, "peering_ipv6_subnet_mask", peering_ipv6_subnet_mask)
        if peering_subnet_mask is not None:
            pulumi.set(__self__, "peering_subnet_mask", peering_subnet_mask)
        if physical_connection_id is not None:
            pulumi.set(__self__, "physical_connection_id", physical_connection_id)
        if route_table_id is not None:
            pulumi.set(__self__, "route_table_id", route_table_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if vbr_owner_id is not None:
            pulumi.set(__self__, "vbr_owner_id", vbr_owner_id)
        if virtual_border_router_name is not None:
            pulumi.set(__self__, "virtual_border_router_name", virtual_border_router_name)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="associatedPhysicalConnections")
    def associated_physical_connections(self) -> Optional[pulumi.Input[str]]:
        """
        The associated physical connections.
        """
        return pulumi.get(self, "associated_physical_connections")

    @associated_physical_connections.setter
    def associated_physical_connections(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "associated_physical_connections", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> Optional[pulumi.Input[str]]:
        """
        Operators for physical connection circuit provided coding.
        """
        return pulumi.get(self, "circuit_code")

    @circuit_code.setter
    def circuit_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "circuit_code", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="detectMultiplier")
    def detect_multiplier(self) -> Optional[pulumi.Input[int]]:
        """
        Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        """
        return pulumi.get(self, "detect_multiplier")

    @detect_multiplier.setter
    def detect_multiplier(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "detect_multiplier", value)

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to Enable IPv6. Valid values: `false`, `true`.
        """
        return pulumi.get(self, "enable_ipv6")

    @enable_ipv6.setter
    def enable_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_ipv6", value)

    @property
    @pulumi.getter(name="includeCrossAccountVbr")
    def include_cross_account_vbr(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
        """
        return pulumi.get(self, "include_cross_account_vbr")

    @include_cross_account_vbr.setter
    def include_cross_account_vbr(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_cross_account_vbr", value)

    @property
    @pulumi.getter(name="localGatewayIp")
    def local_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Alibaba Cloud-Connected IPv4 address.
        """
        return pulumi.get(self, "local_gateway_ip")

    @local_gateway_ip.setter
    def local_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_gateway_ip", value)

    @property
    @pulumi.getter(name="localIpv6GatewayIp")
    def local_ipv6_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        Alibaba Cloud-Connected IPv6 Address.
        """
        return pulumi.get(self, "local_ipv6_gateway_ip")

    @local_ipv6_gateway_ip.setter
    def local_ipv6_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "local_ipv6_gateway_ip", value)

    @property
    @pulumi.getter(name="minRxInterval")
    def min_rx_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        """
        return pulumi.get(self, "min_rx_interval")

    @min_rx_interval.setter
    def min_rx_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_rx_interval", value)

    @property
    @pulumi.getter(name="minTxInterval")
    def min_tx_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        """
        return pulumi.get(self, "min_tx_interval")

    @min_tx_interval.setter
    def min_tx_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_tx_interval", value)

    @property
    @pulumi.getter(name="peerGatewayIp")
    def peer_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The Client-Side Interconnection IPv4 Address.
        """
        return pulumi.get(self, "peer_gateway_ip")

    @peer_gateway_ip.setter
    def peer_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_gateway_ip", value)

    @property
    @pulumi.getter(name="peerIpv6GatewayIp")
    def peer_ipv6_gateway_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The Client-Side Interconnection IPv6 Address.
        """
        return pulumi.get(self, "peer_ipv6_gateway_ip")

    @peer_ipv6_gateway_ip.setter
    def peer_ipv6_gateway_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_ipv6_gateway_ip", value)

    @property
    @pulumi.getter(name="peeringIpv6SubnetMask")
    def peering_ipv6_subnet_mask(self) -> Optional[pulumi.Input[str]]:
        """
        Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        """
        return pulumi.get(self, "peering_ipv6_subnet_mask")

    @peering_ipv6_subnet_mask.setter
    def peering_ipv6_subnet_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_ipv6_subnet_mask", value)

    @property
    @pulumi.getter(name="peeringSubnetMask")
    def peering_subnet_mask(self) -> Optional[pulumi.Input[str]]:
        """
        Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        """
        return pulumi.get(self, "peering_subnet_mask")

    @peering_subnet_mask.setter
    def peering_subnet_mask(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_subnet_mask", value)

    @property
    @pulumi.getter(name="physicalConnectionId")
    def physical_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Physical Connection to Which the ID.
        """
        return pulumi.get(self, "physical_connection_id")

    @physical_connection_id.setter
    def physical_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "physical_connection_id", value)

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Available in v1.166.0+) The Route Table ID Of the Virtual Border Router.
        """
        return pulumi.get(self, "route_table_id")

    @route_table_id.setter
    def route_table_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "route_table_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="vbrOwnerId")
    def vbr_owner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vbr owner id.
        """
        return pulumi.get(self, "vbr_owner_id")

    @vbr_owner_id.setter
    def vbr_owner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vbr_owner_id", value)

    @property
    @pulumi.getter(name="virtualBorderRouterName")
    def virtual_border_router_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        """
        return pulumi.get(self, "virtual_border_router_name")

    @virtual_border_router_name.setter
    def virtual_border_router_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_border_router_name", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[int]]:
        """
        The VLAN ID of the VBR. Value range: 0~2999.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_id", value)


class VirtualBorderRouter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_physical_connections: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 circuit_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 detect_multiplier: Optional[pulumi.Input[int]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 include_cross_account_vbr: Optional[pulumi.Input[bool]] = None,
                 local_gateway_ip: Optional[pulumi.Input[str]] = None,
                 local_ipv6_gateway_ip: Optional[pulumi.Input[str]] = None,
                 min_rx_interval: Optional[pulumi.Input[int]] = None,
                 min_tx_interval: Optional[pulumi.Input[int]] = None,
                 peer_gateway_ip: Optional[pulumi.Input[str]] = None,
                 peer_ipv6_gateway_ip: Optional[pulumi.Input[str]] = None,
                 peering_ipv6_subnet_mask: Optional[pulumi.Input[str]] = None,
                 peering_subnet_mask: Optional[pulumi.Input[str]] = None,
                 physical_connection_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vbr_owner_id: Optional[pulumi.Input[str]] = None,
                 virtual_border_router_name: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a Express Connect Virtual Border Router resource.

        For information about Express Connect Virtual Border Router and how to use it, see [What is Virtual Border Router](https://www.alibabacloud.com/help/en/doc-detail/44854.htm).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example_physical_connections = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
        vlan_id = random.RandomInteger("vlanId",
            max=2999,
            min=1)
        example_virtual_border_router = alicloud.expressconnect.VirtualBorderRouter("exampleVirtualBorderRouter",
            local_gateway_ip="10.0.0.1",
            peer_gateway_ip="10.0.0.2",
            peering_subnet_mask="255.255.255.252",
            physical_connection_id=example_physical_connections.connections[0].id,
            virtual_border_router_name=name,
            vlan_id=vlan_id.id,
            min_rx_interval=1000,
            min_tx_interval=1000,
            detect_multiplier=10)
        ```

        ## Import

        Express Connect Virtual Border Router can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:expressconnect/virtualBorderRouter:VirtualBorderRouter example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] associated_physical_connections: The associated physical connections.
        :param pulumi.Input[int] bandwidth: The bandwidth.
        :param pulumi.Input[str] circuit_code: Operators for physical connection circuit provided coding.
        :param pulumi.Input[str] description: The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        :param pulumi.Input[int] detect_multiplier: Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        :param pulumi.Input[bool] enable_ipv6: Whether to Enable IPv6. Valid values: `false`, `true`.
        :param pulumi.Input[bool] include_cross_account_vbr: Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
        :param pulumi.Input[str] local_gateway_ip: Alibaba Cloud-Connected IPv4 address.
        :param pulumi.Input[str] local_ipv6_gateway_ip: Alibaba Cloud-Connected IPv6 Address.
        :param pulumi.Input[int] min_rx_interval: Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        :param pulumi.Input[int] min_tx_interval: Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        :param pulumi.Input[str] peer_gateway_ip: The Client-Side Interconnection IPv4 Address.
        :param pulumi.Input[str] peer_ipv6_gateway_ip: The Client-Side Interconnection IPv6 Address.
        :param pulumi.Input[str] peering_ipv6_subnet_mask: Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        :param pulumi.Input[str] peering_subnet_mask: Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        :param pulumi.Input[str] physical_connection_id: The ID of the Physical Connection to Which the ID.
        :param pulumi.Input[str] status: The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
        :param pulumi.Input[str] vbr_owner_id: The vbr owner id.
        :param pulumi.Input[str] virtual_border_router_name: The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        :param pulumi.Input[int] vlan_id: The VLAN ID of the VBR. Value range: 0~2999.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualBorderRouterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Express Connect Virtual Border Router resource.

        For information about Express Connect Virtual Border Router and how to use it, see [What is Virtual Border Router](https://www.alibabacloud.com/help/en/doc-detail/44854.htm).

        > **NOTE:** Available since v1.134.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example_physical_connections = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
        vlan_id = random.RandomInteger("vlanId",
            max=2999,
            min=1)
        example_virtual_border_router = alicloud.expressconnect.VirtualBorderRouter("exampleVirtualBorderRouter",
            local_gateway_ip="10.0.0.1",
            peer_gateway_ip="10.0.0.2",
            peering_subnet_mask="255.255.255.252",
            physical_connection_id=example_physical_connections.connections[0].id,
            virtual_border_router_name=name,
            vlan_id=vlan_id.id,
            min_rx_interval=1000,
            min_tx_interval=1000,
            detect_multiplier=10)
        ```

        ## Import

        Express Connect Virtual Border Router can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:expressconnect/virtualBorderRouter:VirtualBorderRouter example <id>
        ```

        :param str resource_name: The name of the resource.
        :param VirtualBorderRouterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualBorderRouterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associated_physical_connections: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 circuit_code: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 detect_multiplier: Optional[pulumi.Input[int]] = None,
                 enable_ipv6: Optional[pulumi.Input[bool]] = None,
                 include_cross_account_vbr: Optional[pulumi.Input[bool]] = None,
                 local_gateway_ip: Optional[pulumi.Input[str]] = None,
                 local_ipv6_gateway_ip: Optional[pulumi.Input[str]] = None,
                 min_rx_interval: Optional[pulumi.Input[int]] = None,
                 min_tx_interval: Optional[pulumi.Input[int]] = None,
                 peer_gateway_ip: Optional[pulumi.Input[str]] = None,
                 peer_ipv6_gateway_ip: Optional[pulumi.Input[str]] = None,
                 peering_ipv6_subnet_mask: Optional[pulumi.Input[str]] = None,
                 peering_subnet_mask: Optional[pulumi.Input[str]] = None,
                 physical_connection_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 vbr_owner_id: Optional[pulumi.Input[str]] = None,
                 virtual_border_router_name: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualBorderRouterArgs.__new__(VirtualBorderRouterArgs)

            __props__.__dict__["associated_physical_connections"] = associated_physical_connections
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["circuit_code"] = circuit_code
            __props__.__dict__["description"] = description
            __props__.__dict__["detect_multiplier"] = detect_multiplier
            __props__.__dict__["enable_ipv6"] = enable_ipv6
            __props__.__dict__["include_cross_account_vbr"] = include_cross_account_vbr
            if local_gateway_ip is None and not opts.urn:
                raise TypeError("Missing required property 'local_gateway_ip'")
            __props__.__dict__["local_gateway_ip"] = local_gateway_ip
            __props__.__dict__["local_ipv6_gateway_ip"] = local_ipv6_gateway_ip
            __props__.__dict__["min_rx_interval"] = min_rx_interval
            __props__.__dict__["min_tx_interval"] = min_tx_interval
            if peer_gateway_ip is None and not opts.urn:
                raise TypeError("Missing required property 'peer_gateway_ip'")
            __props__.__dict__["peer_gateway_ip"] = peer_gateway_ip
            __props__.__dict__["peer_ipv6_gateway_ip"] = peer_ipv6_gateway_ip
            __props__.__dict__["peering_ipv6_subnet_mask"] = peering_ipv6_subnet_mask
            if peering_subnet_mask is None and not opts.urn:
                raise TypeError("Missing required property 'peering_subnet_mask'")
            __props__.__dict__["peering_subnet_mask"] = peering_subnet_mask
            if physical_connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'physical_connection_id'")
            __props__.__dict__["physical_connection_id"] = physical_connection_id
            __props__.__dict__["status"] = status
            __props__.__dict__["vbr_owner_id"] = vbr_owner_id
            __props__.__dict__["virtual_border_router_name"] = virtual_border_router_name
            if vlan_id is None and not opts.urn:
                raise TypeError("Missing required property 'vlan_id'")
            __props__.__dict__["vlan_id"] = vlan_id
            __props__.__dict__["route_table_id"] = None
        super(VirtualBorderRouter, __self__).__init__(
            'alicloud:expressconnect/virtualBorderRouter:VirtualBorderRouter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_physical_connections: Optional[pulumi.Input[str]] = None,
            bandwidth: Optional[pulumi.Input[int]] = None,
            circuit_code: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            detect_multiplier: Optional[pulumi.Input[int]] = None,
            enable_ipv6: Optional[pulumi.Input[bool]] = None,
            include_cross_account_vbr: Optional[pulumi.Input[bool]] = None,
            local_gateway_ip: Optional[pulumi.Input[str]] = None,
            local_ipv6_gateway_ip: Optional[pulumi.Input[str]] = None,
            min_rx_interval: Optional[pulumi.Input[int]] = None,
            min_tx_interval: Optional[pulumi.Input[int]] = None,
            peer_gateway_ip: Optional[pulumi.Input[str]] = None,
            peer_ipv6_gateway_ip: Optional[pulumi.Input[str]] = None,
            peering_ipv6_subnet_mask: Optional[pulumi.Input[str]] = None,
            peering_subnet_mask: Optional[pulumi.Input[str]] = None,
            physical_connection_id: Optional[pulumi.Input[str]] = None,
            route_table_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            vbr_owner_id: Optional[pulumi.Input[str]] = None,
            virtual_border_router_name: Optional[pulumi.Input[str]] = None,
            vlan_id: Optional[pulumi.Input[int]] = None) -> 'VirtualBorderRouter':
        """
        Get an existing VirtualBorderRouter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] associated_physical_connections: The associated physical connections.
        :param pulumi.Input[int] bandwidth: The bandwidth.
        :param pulumi.Input[str] circuit_code: Operators for physical connection circuit provided coding.
        :param pulumi.Input[str] description: The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        :param pulumi.Input[int] detect_multiplier: Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        :param pulumi.Input[bool] enable_ipv6: Whether to Enable IPv6. Valid values: `false`, `true`.
        :param pulumi.Input[bool] include_cross_account_vbr: Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
        :param pulumi.Input[str] local_gateway_ip: Alibaba Cloud-Connected IPv4 address.
        :param pulumi.Input[str] local_ipv6_gateway_ip: Alibaba Cloud-Connected IPv6 Address.
        :param pulumi.Input[int] min_rx_interval: Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        :param pulumi.Input[int] min_tx_interval: Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        :param pulumi.Input[str] peer_gateway_ip: The Client-Side Interconnection IPv4 Address.
        :param pulumi.Input[str] peer_ipv6_gateway_ip: The Client-Side Interconnection IPv6 Address.
        :param pulumi.Input[str] peering_ipv6_subnet_mask: Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        :param pulumi.Input[str] peering_subnet_mask: Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        :param pulumi.Input[str] physical_connection_id: The ID of the Physical Connection to Which the ID.
        :param pulumi.Input[str] route_table_id: (Available in v1.166.0+) The Route Table ID Of the Virtual Border Router.
        :param pulumi.Input[str] status: The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
        :param pulumi.Input[str] vbr_owner_id: The vbr owner id.
        :param pulumi.Input[str] virtual_border_router_name: The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        :param pulumi.Input[int] vlan_id: The VLAN ID of the VBR. Value range: 0~2999.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualBorderRouterState.__new__(_VirtualBorderRouterState)

        __props__.__dict__["associated_physical_connections"] = associated_physical_connections
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["circuit_code"] = circuit_code
        __props__.__dict__["description"] = description
        __props__.__dict__["detect_multiplier"] = detect_multiplier
        __props__.__dict__["enable_ipv6"] = enable_ipv6
        __props__.__dict__["include_cross_account_vbr"] = include_cross_account_vbr
        __props__.__dict__["local_gateway_ip"] = local_gateway_ip
        __props__.__dict__["local_ipv6_gateway_ip"] = local_ipv6_gateway_ip
        __props__.__dict__["min_rx_interval"] = min_rx_interval
        __props__.__dict__["min_tx_interval"] = min_tx_interval
        __props__.__dict__["peer_gateway_ip"] = peer_gateway_ip
        __props__.__dict__["peer_ipv6_gateway_ip"] = peer_ipv6_gateway_ip
        __props__.__dict__["peering_ipv6_subnet_mask"] = peering_ipv6_subnet_mask
        __props__.__dict__["peering_subnet_mask"] = peering_subnet_mask
        __props__.__dict__["physical_connection_id"] = physical_connection_id
        __props__.__dict__["route_table_id"] = route_table_id
        __props__.__dict__["status"] = status
        __props__.__dict__["vbr_owner_id"] = vbr_owner_id
        __props__.__dict__["virtual_border_router_name"] = virtual_border_router_name
        __props__.__dict__["vlan_id"] = vlan_id
        return VirtualBorderRouter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associatedPhysicalConnections")
    def associated_physical_connections(self) -> pulumi.Output[Optional[str]]:
        """
        The associated physical connections.
        """
        return pulumi.get(self, "associated_physical_connections")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[int]:
        """
        The bandwidth.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> pulumi.Output[Optional[str]]:
        """
        Operators for physical connection circuit provided coding.
        """
        return pulumi.get(self, "circuit_code")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of VBR. Length is from 2 to 256 characters, must start with a letter or the Chinese at the beginning, but not at the http:// Or https:// at the beginning.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="detectMultiplier")
    def detect_multiplier(self) -> pulumi.Output[int]:
        """
        Detection time multiplier that recipient allows the sender to send a message of the maximum allowable connections for the number of packets, used to detect whether the link normal. Value: 3~10.
        """
        return pulumi.get(self, "detect_multiplier")

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> pulumi.Output[bool]:
        """
        Whether to Enable IPv6. Valid values: `false`, `true`.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter(name="includeCrossAccountVbr")
    def include_cross_account_vbr(self) -> pulumi.Output[bool]:
        """
        Whether cross account border routers are included. Valid values: `false`, `true`. Default: `true`.
        """
        return pulumi.get(self, "include_cross_account_vbr")

    @property
    @pulumi.getter(name="localGatewayIp")
    def local_gateway_ip(self) -> pulumi.Output[str]:
        """
        Alibaba Cloud-Connected IPv4 address.
        """
        return pulumi.get(self, "local_gateway_ip")

    @property
    @pulumi.getter(name="localIpv6GatewayIp")
    def local_ipv6_gateway_ip(self) -> pulumi.Output[Optional[str]]:
        """
        Alibaba Cloud-Connected IPv6 Address.
        """
        return pulumi.get(self, "local_ipv6_gateway_ip")

    @property
    @pulumi.getter(name="minRxInterval")
    def min_rx_interval(self) -> pulumi.Output[int]:
        """
        Configure BFD packet reception interval of values include: 200~1000, unit: ms.
        """
        return pulumi.get(self, "min_rx_interval")

    @property
    @pulumi.getter(name="minTxInterval")
    def min_tx_interval(self) -> pulumi.Output[int]:
        """
        Configure BFD packet transmission interval maximum value: 200~1000, unit: ms.
        """
        return pulumi.get(self, "min_tx_interval")

    @property
    @pulumi.getter(name="peerGatewayIp")
    def peer_gateway_ip(self) -> pulumi.Output[str]:
        """
        The Client-Side Interconnection IPv4 Address.
        """
        return pulumi.get(self, "peer_gateway_ip")

    @property
    @pulumi.getter(name="peerIpv6GatewayIp")
    def peer_ipv6_gateway_ip(self) -> pulumi.Output[Optional[str]]:
        """
        The Client-Side Interconnection IPv6 Address.
        """
        return pulumi.get(self, "peer_ipv6_gateway_ip")

    @property
    @pulumi.getter(name="peeringIpv6SubnetMask")
    def peering_ipv6_subnet_mask(self) -> pulumi.Output[Optional[str]]:
        """
        Alibaba Cloud-Connected IPv6 with Client-Side Interconnection IPv6 of Subnet Mask.
        """
        return pulumi.get(self, "peering_ipv6_subnet_mask")

    @property
    @pulumi.getter(name="peeringSubnetMask")
    def peering_subnet_mask(self) -> pulumi.Output[str]:
        """
        Alibaba Cloud-Connected IPv4 and Client-Side Interconnection IPv4 of Subnet Mask.
        """
        return pulumi.get(self, "peering_subnet_mask")

    @property
    @pulumi.getter(name="physicalConnectionId")
    def physical_connection_id(self) -> pulumi.Output[str]:
        """
        The ID of the Physical Connection to Which the ID.
        """
        return pulumi.get(self, "physical_connection_id")

    @property
    @pulumi.getter(name="routeTableId")
    def route_table_id(self) -> pulumi.Output[str]:
        """
        (Available in v1.166.0+) The Route Table ID Of the Virtual Border Router.
        """
        return pulumi.get(self, "route_table_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The instance state. Valid values: `active`, `deleting`, `recovering`, `terminated`, `terminating`, `unconfirmed`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vbrOwnerId")
    def vbr_owner_id(self) -> pulumi.Output[Optional[str]]:
        """
        The vbr owner id.
        """
        return pulumi.get(self, "vbr_owner_id")

    @property
    @pulumi.getter(name="virtualBorderRouterName")
    def virtual_border_router_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of VBR. Length is from 2 to 128 characters, must start with a letter or the Chinese at the beginning can contain numbers, the underscore character (_) and dash (-). But do not start with http:// or https:// at the beginning.
        """
        return pulumi.get(self, "virtual_border_router_name")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[int]:
        """
        The VLAN ID of the VBR. Value range: 0~2999.
        """
        return pulumi.get(self, "vlan_id")

