# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VirtualPhysicalConnectionArgs', 'VirtualPhysicalConnection']

@pulumi.input_type
class VirtualPhysicalConnectionArgs:
    def __init__(__self__, *,
                 order_mode: pulumi.Input[str],
                 parent_physical_connection_id: pulumi.Input[str],
                 spec: pulumi.Input[str],
                 vlan_id: pulumi.Input[int],
                 vpconn_ali_uid: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 expect_spec: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 virtual_physical_connection_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VirtualPhysicalConnection resource.
        :param pulumi.Input[str] order_mode: The payment method of shared dedicated line. Value:
               - **PayByPhysicalConnectionOwner**: indicates that the owner of the physical line associated with the shared line pays.
               - **PayByVirtualPhysicalConnectionOwner**: indicates that the owner of the shared line pays.
        :param pulumi.Input[str] parent_physical_connection_id: The ID of the instance of the physical connection.
        :param pulumi.Input[str] spec: The bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
        :param pulumi.Input[int] vlan_id: The VLAN ID of the shared leased line. Valid values: `0` to `2999`.
        :param pulumi.Input[str] vpconn_ali_uid: The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
        :param pulumi.Input[str] description: The description of the physical connection.
        :param pulumi.Input[bool] dry_run: Specifies whether to precheck the API request. Valid values: `true` and `false`.
        :param pulumi.Input[str] expect_spec: The estimated bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
        :param pulumi.Input[str] resource_group_id: The resource group id.
        :param pulumi.Input[str] virtual_physical_connection_name: The name of the physical connection.
        """
        pulumi.set(__self__, "order_mode", order_mode)
        pulumi.set(__self__, "parent_physical_connection_id", parent_physical_connection_id)
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "vlan_id", vlan_id)
        pulumi.set(__self__, "vpconn_ali_uid", vpconn_ali_uid)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if expect_spec is not None:
            pulumi.set(__self__, "expect_spec", expect_spec)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if virtual_physical_connection_name is not None:
            pulumi.set(__self__, "virtual_physical_connection_name", virtual_physical_connection_name)

    @property
    @pulumi.getter(name="orderMode")
    def order_mode(self) -> pulumi.Input[str]:
        """
        The payment method of shared dedicated line. Value:
        - **PayByPhysicalConnectionOwner**: indicates that the owner of the physical line associated with the shared line pays.
        - **PayByVirtualPhysicalConnectionOwner**: indicates that the owner of the shared line pays.
        """
        return pulumi.get(self, "order_mode")

    @order_mode.setter
    def order_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "order_mode", value)

    @property
    @pulumi.getter(name="parentPhysicalConnectionId")
    def parent_physical_connection_id(self) -> pulumi.Input[str]:
        """
        The ID of the instance of the physical connection.
        """
        return pulumi.get(self, "parent_physical_connection_id")

    @parent_physical_connection_id.setter
    def parent_physical_connection_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "parent_physical_connection_id", value)

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Input[str]:
        """
        The bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: pulumi.Input[str]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Input[int]:
        """
        The VLAN ID of the shared leased line. Valid values: `0` to `2999`.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: pulumi.Input[int]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter(name="vpconnAliUid")
    def vpconn_ali_uid(self) -> pulumi.Input[str]:
        """
        The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
        """
        return pulumi.get(self, "vpconn_ali_uid")

    @vpconn_ali_uid.setter
    def vpconn_ali_uid(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpconn_ali_uid", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the physical connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to precheck the API request. Valid values: `true` and `false`.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="expectSpec")
    def expect_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The estimated bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
        """
        return pulumi.get(self, "expect_spec")

    @expect_spec.setter
    def expect_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expect_spec", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter(name="virtualPhysicalConnectionName")
    def virtual_physical_connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the physical connection.
        """
        return pulumi.get(self, "virtual_physical_connection_name")

    @virtual_physical_connection_name.setter
    def virtual_physical_connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_physical_connection_name", value)


@pulumi.input_type
class _VirtualPhysicalConnectionState:
    def __init__(__self__, *,
                 access_point_id: Optional[pulumi.Input[str]] = None,
                 ad_location: Optional[pulumi.Input[str]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 business_status: Optional[pulumi.Input[str]] = None,
                 circuit_code: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 enabled_time: Optional[pulumi.Input[str]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 expect_spec: Optional[pulumi.Input[str]] = None,
                 line_operator: Optional[pulumi.Input[str]] = None,
                 loa_status: Optional[pulumi.Input[str]] = None,
                 order_mode: Optional[pulumi.Input[str]] = None,
                 parent_physical_connection_ali_uid: Optional[pulumi.Input[str]] = None,
                 parent_physical_connection_id: Optional[pulumi.Input[str]] = None,
                 peer_location: Optional[pulumi.Input[str]] = None,
                 port_number: Optional[pulumi.Input[str]] = None,
                 port_type: Optional[pulumi.Input[str]] = None,
                 redundant_physical_connection_id: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 virtual_physical_connection_name: Optional[pulumi.Input[str]] = None,
                 virtual_physical_connection_status: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 vpconn_ali_uid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VirtualPhysicalConnection resources.
        :param pulumi.Input[str] access_point_id: The ID of the access point of the physical connection.
        :param pulumi.Input[str] ad_location: The physical location where the physical connection access device is located.
        :param pulumi.Input[str] bandwidth: The bandwidth of the physical connection. Unit: Mbps.
        :param pulumi.Input[str] business_status: The commercial status of the physical line. Value:-**Normal**: activated.-**Financialized**: Arrears locked.-**SecurityLocked**: locked for security reasons.
        :param pulumi.Input[str] circuit_code: The circuit code provided by the operator for the physical connection.
        :param pulumi.Input[str] create_time: The creation time of the resource
        :param pulumi.Input[str] description: The description of the physical connection.
        :param pulumi.Input[bool] dry_run: Specifies whether to precheck the API request. Valid values: `true` and `false`.
        :param pulumi.Input[str] enabled_time: The opening time of the physical connection.
        :param pulumi.Input[str] end_time: The expiration time of the shared line.Time is expressed according to ISO8601 standard and UTC time is used. The format is: YYYY-MM-DDThh:mm:ssZ.
        :param pulumi.Input[str] expect_spec: The estimated bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
        :param pulumi.Input[str] line_operator: Operators that provide access to physical lines. Value:-**CT**: China Telecom.-**CU**: China Unicom.-**CM**: China Mobile.-**CO**: China Other.-**Equinix**:Equinix.-**Other**: Other abroad.
        :param pulumi.Input[str] loa_status: The state of LOA. Value:-**Applying**:LOA application.-**Accept**:LOA application passed.-**Available**:LOA is Available.-**Rejected**:LOA application Rejected.-**Completing**: The dedicated line is under construction.-**Complete**: The construction of the dedicated line is completed.-**Deleted**:LOA has been Deleted.
        :param pulumi.Input[str] order_mode: The payment method of shared dedicated line. Value:
               - **PayByPhysicalConnectionOwner**: indicates that the owner of the physical line associated with the shared line pays.
               - **PayByVirtualPhysicalConnectionOwner**: indicates that the owner of the shared line pays.
        :param pulumi.Input[str] parent_physical_connection_ali_uid: The ID of the Alibaba Cloud account (primary account) to which the physical connection belongs.
        :param pulumi.Input[str] parent_physical_connection_id: The ID of the instance of the physical connection.
        :param pulumi.Input[str] peer_location: The geographic location of the local data center.
        :param pulumi.Input[str] port_number: The port number of the physical connection device.
        :param pulumi.Input[str] port_type: Physical connection port type. Value:-**100Base-T**: 100 megabytes port.-**1000Base-T**: Gigabit port.-**1000Base-LX**: Gigabit single mode optical port (10km).-**10GBase-T**: 10 Gigabit port.-**10GBase-LR**: 10 Gigabit single mode optical port (10km).-**40GBase-LR**: 40 megabytes single-mode optical port.-**100GBase-LR**: 100,000 megabytes single-mode optical port.
        :param pulumi.Input[str] redundant_physical_connection_id: The ID of the redundant physical connection.
        :param pulumi.Input[str] resource_group_id: The resource group id.
        :param pulumi.Input[str] spec: The bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
        :param pulumi.Input[str] status: The status of the resource
        :param pulumi.Input[str] virtual_physical_connection_name: The name of the physical connection.
        :param pulumi.Input[str] virtual_physical_connection_status: The business status of the shared line. Value:-**Confirmed**: The shared line has been Confirmed to receive.-**UnConfirmed**: The shared line has not been confirmed to be received.-**Deleted**: The shared line has been Deleted.
        :param pulumi.Input[int] vlan_id: The VLAN ID of the shared leased line. Valid values: `0` to `2999`.
        :param pulumi.Input[str] vpconn_ali_uid: The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
        """
        if access_point_id is not None:
            pulumi.set(__self__, "access_point_id", access_point_id)
        if ad_location is not None:
            pulumi.set(__self__, "ad_location", ad_location)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if business_status is not None:
            pulumi.set(__self__, "business_status", business_status)
        if circuit_code is not None:
            pulumi.set(__self__, "circuit_code", circuit_code)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if enabled_time is not None:
            pulumi.set(__self__, "enabled_time", enabled_time)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if expect_spec is not None:
            pulumi.set(__self__, "expect_spec", expect_spec)
        if line_operator is not None:
            pulumi.set(__self__, "line_operator", line_operator)
        if loa_status is not None:
            pulumi.set(__self__, "loa_status", loa_status)
        if order_mode is not None:
            pulumi.set(__self__, "order_mode", order_mode)
        if parent_physical_connection_ali_uid is not None:
            pulumi.set(__self__, "parent_physical_connection_ali_uid", parent_physical_connection_ali_uid)
        if parent_physical_connection_id is not None:
            pulumi.set(__self__, "parent_physical_connection_id", parent_physical_connection_id)
        if peer_location is not None:
            pulumi.set(__self__, "peer_location", peer_location)
        if port_number is not None:
            pulumi.set(__self__, "port_number", port_number)
        if port_type is not None:
            pulumi.set(__self__, "port_type", port_type)
        if redundant_physical_connection_id is not None:
            pulumi.set(__self__, "redundant_physical_connection_id", redundant_physical_connection_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if virtual_physical_connection_name is not None:
            pulumi.set(__self__, "virtual_physical_connection_name", virtual_physical_connection_name)
        if virtual_physical_connection_status is not None:
            pulumi.set(__self__, "virtual_physical_connection_status", virtual_physical_connection_status)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)
        if vpconn_ali_uid is not None:
            pulumi.set(__self__, "vpconn_ali_uid", vpconn_ali_uid)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the access point of the physical connection.
        """
        return pulumi.get(self, "access_point_id")

    @access_point_id.setter
    def access_point_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_point_id", value)

    @property
    @pulumi.getter(name="adLocation")
    def ad_location(self) -> Optional[pulumi.Input[str]]:
        """
        The physical location where the physical connection access device is located.
        """
        return pulumi.get(self, "ad_location")

    @ad_location.setter
    def ad_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ad_location", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        The bandwidth of the physical connection. Unit: Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> Optional[pulumi.Input[str]]:
        """
        The commercial status of the physical line. Value:-**Normal**: activated.-**Financialized**: Arrears locked.-**SecurityLocked**: locked for security reasons.
        """
        return pulumi.get(self, "business_status")

    @business_status.setter
    def business_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "business_status", value)

    @property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> Optional[pulumi.Input[str]]:
        """
        The circuit code provided by the operator for the physical connection.
        """
        return pulumi.get(self, "circuit_code")

    @circuit_code.setter
    def circuit_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "circuit_code", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the physical connection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to precheck the API request. Valid values: `true` and `false`.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dry_run", value)

    @property
    @pulumi.getter(name="enabledTime")
    def enabled_time(self) -> Optional[pulumi.Input[str]]:
        """
        The opening time of the physical connection.
        """
        return pulumi.get(self, "enabled_time")

    @enabled_time.setter
    def enabled_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enabled_time", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The expiration time of the shared line.Time is expressed according to ISO8601 standard and UTC time is used. The format is: YYYY-MM-DDThh:mm:ssZ.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="expectSpec")
    def expect_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The estimated bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
        """
        return pulumi.get(self, "expect_spec")

    @expect_spec.setter
    def expect_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expect_spec", value)

    @property
    @pulumi.getter(name="lineOperator")
    def line_operator(self) -> Optional[pulumi.Input[str]]:
        """
        Operators that provide access to physical lines. Value:-**CT**: China Telecom.-**CU**: China Unicom.-**CM**: China Mobile.-**CO**: China Other.-**Equinix**:Equinix.-**Other**: Other abroad.
        """
        return pulumi.get(self, "line_operator")

    @line_operator.setter
    def line_operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "line_operator", value)

    @property
    @pulumi.getter(name="loaStatus")
    def loa_status(self) -> Optional[pulumi.Input[str]]:
        """
        The state of LOA. Value:-**Applying**:LOA application.-**Accept**:LOA application passed.-**Available**:LOA is Available.-**Rejected**:LOA application Rejected.-**Completing**: The dedicated line is under construction.-**Complete**: The construction of the dedicated line is completed.-**Deleted**:LOA has been Deleted.
        """
        return pulumi.get(self, "loa_status")

    @loa_status.setter
    def loa_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "loa_status", value)

    @property
    @pulumi.getter(name="orderMode")
    def order_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The payment method of shared dedicated line. Value:
        - **PayByPhysicalConnectionOwner**: indicates that the owner of the physical line associated with the shared line pays.
        - **PayByVirtualPhysicalConnectionOwner**: indicates that the owner of the shared line pays.
        """
        return pulumi.get(self, "order_mode")

    @order_mode.setter
    def order_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "order_mode", value)

    @property
    @pulumi.getter(name="parentPhysicalConnectionAliUid")
    def parent_physical_connection_ali_uid(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Alibaba Cloud account (primary account) to which the physical connection belongs.
        """
        return pulumi.get(self, "parent_physical_connection_ali_uid")

    @parent_physical_connection_ali_uid.setter
    def parent_physical_connection_ali_uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_physical_connection_ali_uid", value)

    @property
    @pulumi.getter(name="parentPhysicalConnectionId")
    def parent_physical_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the instance of the physical connection.
        """
        return pulumi.get(self, "parent_physical_connection_id")

    @parent_physical_connection_id.setter
    def parent_physical_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_physical_connection_id", value)

    @property
    @pulumi.getter(name="peerLocation")
    def peer_location(self) -> Optional[pulumi.Input[str]]:
        """
        The geographic location of the local data center.
        """
        return pulumi.get(self, "peer_location")

    @peer_location.setter
    def peer_location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_location", value)

    @property
    @pulumi.getter(name="portNumber")
    def port_number(self) -> Optional[pulumi.Input[str]]:
        """
        The port number of the physical connection device.
        """
        return pulumi.get(self, "port_number")

    @port_number.setter
    def port_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_number", value)

    @property
    @pulumi.getter(name="portType")
    def port_type(self) -> Optional[pulumi.Input[str]]:
        """
        Physical connection port type. Value:-**100Base-T**: 100 megabytes port.-**1000Base-T**: Gigabit port.-**1000Base-LX**: Gigabit single mode optical port (10km).-**10GBase-T**: 10 Gigabit port.-**10GBase-LR**: 10 Gigabit single mode optical port (10km).-**40GBase-LR**: 40 megabytes single-mode optical port.-**100GBase-LR**: 100,000 megabytes single-mode optical port.
        """
        return pulumi.get(self, "port_type")

    @port_type.setter
    def port_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_type", value)

    @property
    @pulumi.getter(name="redundantPhysicalConnectionId")
    def redundant_physical_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the redundant physical connection.
        """
        return pulumi.get(self, "redundant_physical_connection_id")

    @redundant_physical_connection_id.setter
    def redundant_physical_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redundant_physical_connection_id", value)

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_group_id", value)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input[str]]:
        """
        The bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spec", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="virtualPhysicalConnectionName")
    def virtual_physical_connection_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the physical connection.
        """
        return pulumi.get(self, "virtual_physical_connection_name")

    @virtual_physical_connection_name.setter
    def virtual_physical_connection_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_physical_connection_name", value)

    @property
    @pulumi.getter(name="virtualPhysicalConnectionStatus")
    def virtual_physical_connection_status(self) -> Optional[pulumi.Input[str]]:
        """
        The business status of the shared line. Value:-**Confirmed**: The shared line has been Confirmed to receive.-**UnConfirmed**: The shared line has not been confirmed to be received.-**Deleted**: The shared line has been Deleted.
        """
        return pulumi.get(self, "virtual_physical_connection_status")

    @virtual_physical_connection_status.setter
    def virtual_physical_connection_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "virtual_physical_connection_status", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[int]]:
        """
        The VLAN ID of the shared leased line. Valid values: `0` to `2999`.
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_id", value)

    @property
    @pulumi.getter(name="vpconnAliUid")
    def vpconn_ali_uid(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
        """
        return pulumi.get(self, "vpconn_ali_uid")

    @vpconn_ali_uid.setter
    def vpconn_ali_uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpconn_ali_uid", value)


class VirtualPhysicalConnection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 expect_spec: Optional[pulumi.Input[str]] = None,
                 order_mode: Optional[pulumi.Input[str]] = None,
                 parent_physical_connection_id: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[str]] = None,
                 virtual_physical_connection_name: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 vpconn_ali_uid: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Express Connect Virtual Physical Connection resource.

        For information about Express Connect Virtual Physical Connection and how to use it, see [What is Virtual Physical Connection](https://www.alibabacloud.com/help/en/express-connect/latest/createvirtualphysicalconnection#doc-api-Vpc-CreateVirtualPhysicalConnection).

        > **NOTE:** Available since v1.196.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example_physical_connections = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
        vlan_id = random.RandomInteger("vlanId",
            max=2999,
            min=1)
        default = alicloud.get_account()
        example_virtual_physical_connection = alicloud.expressconnect.VirtualPhysicalConnection("exampleVirtualPhysicalConnection",
            virtual_physical_connection_name=name,
            description=name,
            order_mode="PayByPhysicalConnectionOwner",
            parent_physical_connection_id=example_physical_connections.ids[0],
            spec="50M",
            vlan_id=vlan_id.id,
            vpconn_ali_uid=default.id)
        ```

        ## Import

        Express Connect Virtual Physical Connection can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:expressconnect/virtualPhysicalConnection:VirtualPhysicalConnection example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the physical connection.
        :param pulumi.Input[bool] dry_run: Specifies whether to precheck the API request. Valid values: `true` and `false`.
        :param pulumi.Input[str] expect_spec: The estimated bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
        :param pulumi.Input[str] order_mode: The payment method of shared dedicated line. Value:
               - **PayByPhysicalConnectionOwner**: indicates that the owner of the physical line associated with the shared line pays.
               - **PayByVirtualPhysicalConnectionOwner**: indicates that the owner of the shared line pays.
        :param pulumi.Input[str] parent_physical_connection_id: The ID of the instance of the physical connection.
        :param pulumi.Input[str] resource_group_id: The resource group id.
        :param pulumi.Input[str] spec: The bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
        :param pulumi.Input[str] virtual_physical_connection_name: The name of the physical connection.
        :param pulumi.Input[int] vlan_id: The VLAN ID of the shared leased line. Valid values: `0` to `2999`.
        :param pulumi.Input[str] vpconn_ali_uid: The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VirtualPhysicalConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Express Connect Virtual Physical Connection resource.

        For information about Express Connect Virtual Physical Connection and how to use it, see [What is Virtual Physical Connection](https://www.alibabacloud.com/help/en/express-connect/latest/createvirtualphysicalconnection#doc-api-Vpc-CreateVirtualPhysicalConnection).

        > **NOTE:** Available since v1.196.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        example_physical_connections = alicloud.expressconnect.get_physical_connections(name_regex="^preserved-NODELETING")
        vlan_id = random.RandomInteger("vlanId",
            max=2999,
            min=1)
        default = alicloud.get_account()
        example_virtual_physical_connection = alicloud.expressconnect.VirtualPhysicalConnection("exampleVirtualPhysicalConnection",
            virtual_physical_connection_name=name,
            description=name,
            order_mode="PayByPhysicalConnectionOwner",
            parent_physical_connection_id=example_physical_connections.ids[0],
            spec="50M",
            vlan_id=vlan_id.id,
            vpconn_ali_uid=default.id)
        ```

        ## Import

        Express Connect Virtual Physical Connection can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:expressconnect/virtualPhysicalConnection:VirtualPhysicalConnection example <id>
        ```

        :param str resource_name: The name of the resource.
        :param VirtualPhysicalConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VirtualPhysicalConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dry_run: Optional[pulumi.Input[bool]] = None,
                 expect_spec: Optional[pulumi.Input[str]] = None,
                 order_mode: Optional[pulumi.Input[str]] = None,
                 parent_physical_connection_id: Optional[pulumi.Input[str]] = None,
                 resource_group_id: Optional[pulumi.Input[str]] = None,
                 spec: Optional[pulumi.Input[str]] = None,
                 virtual_physical_connection_name: Optional[pulumi.Input[str]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 vpconn_ali_uid: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VirtualPhysicalConnectionArgs.__new__(VirtualPhysicalConnectionArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["expect_spec"] = expect_spec
            if order_mode is None and not opts.urn:
                raise TypeError("Missing required property 'order_mode'")
            __props__.__dict__["order_mode"] = order_mode
            if parent_physical_connection_id is None and not opts.urn:
                raise TypeError("Missing required property 'parent_physical_connection_id'")
            __props__.__dict__["parent_physical_connection_id"] = parent_physical_connection_id
            __props__.__dict__["resource_group_id"] = resource_group_id
            if spec is None and not opts.urn:
                raise TypeError("Missing required property 'spec'")
            __props__.__dict__["spec"] = spec
            __props__.__dict__["virtual_physical_connection_name"] = virtual_physical_connection_name
            if vlan_id is None and not opts.urn:
                raise TypeError("Missing required property 'vlan_id'")
            __props__.__dict__["vlan_id"] = vlan_id
            if vpconn_ali_uid is None and not opts.urn:
                raise TypeError("Missing required property 'vpconn_ali_uid'")
            __props__.__dict__["vpconn_ali_uid"] = vpconn_ali_uid
            __props__.__dict__["access_point_id"] = None
            __props__.__dict__["ad_location"] = None
            __props__.__dict__["bandwidth"] = None
            __props__.__dict__["business_status"] = None
            __props__.__dict__["circuit_code"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["enabled_time"] = None
            __props__.__dict__["end_time"] = None
            __props__.__dict__["line_operator"] = None
            __props__.__dict__["loa_status"] = None
            __props__.__dict__["parent_physical_connection_ali_uid"] = None
            __props__.__dict__["peer_location"] = None
            __props__.__dict__["port_number"] = None
            __props__.__dict__["port_type"] = None
            __props__.__dict__["redundant_physical_connection_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["virtual_physical_connection_status"] = None
        super(VirtualPhysicalConnection, __self__).__init__(
            'alicloud:expressconnect/virtualPhysicalConnection:VirtualPhysicalConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_point_id: Optional[pulumi.Input[str]] = None,
            ad_location: Optional[pulumi.Input[str]] = None,
            bandwidth: Optional[pulumi.Input[str]] = None,
            business_status: Optional[pulumi.Input[str]] = None,
            circuit_code: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dry_run: Optional[pulumi.Input[bool]] = None,
            enabled_time: Optional[pulumi.Input[str]] = None,
            end_time: Optional[pulumi.Input[str]] = None,
            expect_spec: Optional[pulumi.Input[str]] = None,
            line_operator: Optional[pulumi.Input[str]] = None,
            loa_status: Optional[pulumi.Input[str]] = None,
            order_mode: Optional[pulumi.Input[str]] = None,
            parent_physical_connection_ali_uid: Optional[pulumi.Input[str]] = None,
            parent_physical_connection_id: Optional[pulumi.Input[str]] = None,
            peer_location: Optional[pulumi.Input[str]] = None,
            port_number: Optional[pulumi.Input[str]] = None,
            port_type: Optional[pulumi.Input[str]] = None,
            redundant_physical_connection_id: Optional[pulumi.Input[str]] = None,
            resource_group_id: Optional[pulumi.Input[str]] = None,
            spec: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            virtual_physical_connection_name: Optional[pulumi.Input[str]] = None,
            virtual_physical_connection_status: Optional[pulumi.Input[str]] = None,
            vlan_id: Optional[pulumi.Input[int]] = None,
            vpconn_ali_uid: Optional[pulumi.Input[str]] = None) -> 'VirtualPhysicalConnection':
        """
        Get an existing VirtualPhysicalConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_point_id: The ID of the access point of the physical connection.
        :param pulumi.Input[str] ad_location: The physical location where the physical connection access device is located.
        :param pulumi.Input[str] bandwidth: The bandwidth of the physical connection. Unit: Mbps.
        :param pulumi.Input[str] business_status: The commercial status of the physical line. Value:-**Normal**: activated.-**Financialized**: Arrears locked.-**SecurityLocked**: locked for security reasons.
        :param pulumi.Input[str] circuit_code: The circuit code provided by the operator for the physical connection.
        :param pulumi.Input[str] create_time: The creation time of the resource
        :param pulumi.Input[str] description: The description of the physical connection.
        :param pulumi.Input[bool] dry_run: Specifies whether to precheck the API request. Valid values: `true` and `false`.
        :param pulumi.Input[str] enabled_time: The opening time of the physical connection.
        :param pulumi.Input[str] end_time: The expiration time of the shared line.Time is expressed according to ISO8601 standard and UTC time is used. The format is: YYYY-MM-DDThh:mm:ssZ.
        :param pulumi.Input[str] expect_spec: The estimated bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
        :param pulumi.Input[str] line_operator: Operators that provide access to physical lines. Value:-**CT**: China Telecom.-**CU**: China Unicom.-**CM**: China Mobile.-**CO**: China Other.-**Equinix**:Equinix.-**Other**: Other abroad.
        :param pulumi.Input[str] loa_status: The state of LOA. Value:-**Applying**:LOA application.-**Accept**:LOA application passed.-**Available**:LOA is Available.-**Rejected**:LOA application Rejected.-**Completing**: The dedicated line is under construction.-**Complete**: The construction of the dedicated line is completed.-**Deleted**:LOA has been Deleted.
        :param pulumi.Input[str] order_mode: The payment method of shared dedicated line. Value:
               - **PayByPhysicalConnectionOwner**: indicates that the owner of the physical line associated with the shared line pays.
               - **PayByVirtualPhysicalConnectionOwner**: indicates that the owner of the shared line pays.
        :param pulumi.Input[str] parent_physical_connection_ali_uid: The ID of the Alibaba Cloud account (primary account) to which the physical connection belongs.
        :param pulumi.Input[str] parent_physical_connection_id: The ID of the instance of the physical connection.
        :param pulumi.Input[str] peer_location: The geographic location of the local data center.
        :param pulumi.Input[str] port_number: The port number of the physical connection device.
        :param pulumi.Input[str] port_type: Physical connection port type. Value:-**100Base-T**: 100 megabytes port.-**1000Base-T**: Gigabit port.-**1000Base-LX**: Gigabit single mode optical port (10km).-**10GBase-T**: 10 Gigabit port.-**10GBase-LR**: 10 Gigabit single mode optical port (10km).-**40GBase-LR**: 40 megabytes single-mode optical port.-**100GBase-LR**: 100,000 megabytes single-mode optical port.
        :param pulumi.Input[str] redundant_physical_connection_id: The ID of the redundant physical connection.
        :param pulumi.Input[str] resource_group_id: The resource group id.
        :param pulumi.Input[str] spec: The bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
        :param pulumi.Input[str] status: The status of the resource
        :param pulumi.Input[str] virtual_physical_connection_name: The name of the physical connection.
        :param pulumi.Input[str] virtual_physical_connection_status: The business status of the shared line. Value:-**Confirmed**: The shared line has been Confirmed to receive.-**UnConfirmed**: The shared line has not been confirmed to be received.-**Deleted**: The shared line has been Deleted.
        :param pulumi.Input[int] vlan_id: The VLAN ID of the shared leased line. Valid values: `0` to `2999`.
        :param pulumi.Input[str] vpconn_ali_uid: The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VirtualPhysicalConnectionState.__new__(_VirtualPhysicalConnectionState)

        __props__.__dict__["access_point_id"] = access_point_id
        __props__.__dict__["ad_location"] = ad_location
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["business_status"] = business_status
        __props__.__dict__["circuit_code"] = circuit_code
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["enabled_time"] = enabled_time
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["expect_spec"] = expect_spec
        __props__.__dict__["line_operator"] = line_operator
        __props__.__dict__["loa_status"] = loa_status
        __props__.__dict__["order_mode"] = order_mode
        __props__.__dict__["parent_physical_connection_ali_uid"] = parent_physical_connection_ali_uid
        __props__.__dict__["parent_physical_connection_id"] = parent_physical_connection_id
        __props__.__dict__["peer_location"] = peer_location
        __props__.__dict__["port_number"] = port_number
        __props__.__dict__["port_type"] = port_type
        __props__.__dict__["redundant_physical_connection_id"] = redundant_physical_connection_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["spec"] = spec
        __props__.__dict__["status"] = status
        __props__.__dict__["virtual_physical_connection_name"] = virtual_physical_connection_name
        __props__.__dict__["virtual_physical_connection_status"] = virtual_physical_connection_status
        __props__.__dict__["vlan_id"] = vlan_id
        __props__.__dict__["vpconn_ali_uid"] = vpconn_ali_uid
        return VirtualPhysicalConnection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPointId")
    def access_point_id(self) -> pulumi.Output[str]:
        """
        The ID of the access point of the physical connection.
        """
        return pulumi.get(self, "access_point_id")

    @property
    @pulumi.getter(name="adLocation")
    def ad_location(self) -> pulumi.Output[str]:
        """
        The physical location where the physical connection access device is located.
        """
        return pulumi.get(self, "ad_location")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[str]:
        """
        The bandwidth of the physical connection. Unit: Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> pulumi.Output[str]:
        """
        The commercial status of the physical line. Value:-**Normal**: activated.-**Financialized**: Arrears locked.-**SecurityLocked**: locked for security reasons.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="circuitCode")
    def circuit_code(self) -> pulumi.Output[str]:
        """
        The circuit code provided by the operator for the physical connection.
        """
        return pulumi.get(self, "circuit_code")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The creation time of the resource
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the physical connection.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to precheck the API request. Valid values: `true` and `false`.
        """
        return pulumi.get(self, "dry_run")

    @property
    @pulumi.getter(name="enabledTime")
    def enabled_time(self) -> pulumi.Output[str]:
        """
        The opening time of the physical connection.
        """
        return pulumi.get(self, "enabled_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[str]:
        """
        The expiration time of the shared line.Time is expressed according to ISO8601 standard and UTC time is used. The format is: YYYY-MM-DDThh:mm:ssZ.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="expectSpec")
    def expect_spec(self) -> pulumi.Output[Optional[str]]:
        """
        The estimated bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
        """
        return pulumi.get(self, "expect_spec")

    @property
    @pulumi.getter(name="lineOperator")
    def line_operator(self) -> pulumi.Output[str]:
        """
        Operators that provide access to physical lines. Value:-**CT**: China Telecom.-**CU**: China Unicom.-**CM**: China Mobile.-**CO**: China Other.-**Equinix**:Equinix.-**Other**: Other abroad.
        """
        return pulumi.get(self, "line_operator")

    @property
    @pulumi.getter(name="loaStatus")
    def loa_status(self) -> pulumi.Output[str]:
        """
        The state of LOA. Value:-**Applying**:LOA application.-**Accept**:LOA application passed.-**Available**:LOA is Available.-**Rejected**:LOA application Rejected.-**Completing**: The dedicated line is under construction.-**Complete**: The construction of the dedicated line is completed.-**Deleted**:LOA has been Deleted.
        """
        return pulumi.get(self, "loa_status")

    @property
    @pulumi.getter(name="orderMode")
    def order_mode(self) -> pulumi.Output[str]:
        """
        The payment method of shared dedicated line. Value:
        - **PayByPhysicalConnectionOwner**: indicates that the owner of the physical line associated with the shared line pays.
        - **PayByVirtualPhysicalConnectionOwner**: indicates that the owner of the shared line pays.
        """
        return pulumi.get(self, "order_mode")

    @property
    @pulumi.getter(name="parentPhysicalConnectionAliUid")
    def parent_physical_connection_ali_uid(self) -> pulumi.Output[str]:
        """
        The ID of the Alibaba Cloud account (primary account) to which the physical connection belongs.
        """
        return pulumi.get(self, "parent_physical_connection_ali_uid")

    @property
    @pulumi.getter(name="parentPhysicalConnectionId")
    def parent_physical_connection_id(self) -> pulumi.Output[str]:
        """
        The ID of the instance of the physical connection.
        """
        return pulumi.get(self, "parent_physical_connection_id")

    @property
    @pulumi.getter(name="peerLocation")
    def peer_location(self) -> pulumi.Output[str]:
        """
        The geographic location of the local data center.
        """
        return pulumi.get(self, "peer_location")

    @property
    @pulumi.getter(name="portNumber")
    def port_number(self) -> pulumi.Output[str]:
        """
        The port number of the physical connection device.
        """
        return pulumi.get(self, "port_number")

    @property
    @pulumi.getter(name="portType")
    def port_type(self) -> pulumi.Output[str]:
        """
        Physical connection port type. Value:-**100Base-T**: 100 megabytes port.-**1000Base-T**: Gigabit port.-**1000Base-LX**: Gigabit single mode optical port (10km).-**10GBase-T**: 10 Gigabit port.-**10GBase-LR**: 10 Gigabit single mode optical port (10km).-**40GBase-LR**: 40 megabytes single-mode optical port.-**100GBase-LR**: 100,000 megabytes single-mode optical port.
        """
        return pulumi.get(self, "port_type")

    @property
    @pulumi.getter(name="redundantPhysicalConnectionId")
    def redundant_physical_connection_id(self) -> pulumi.Output[str]:
        """
        The ID of the redundant physical connection.
        """
        return pulumi.get(self, "redundant_physical_connection_id")

    @property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[str]:
        """
        The resource group id.
        """
        return pulumi.get(self, "resource_group_id")

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Output[str]:
        """
        The bandwidth value of the shared line. Valid values: `50M`, `100M`, `200M`, `300M`, `400M`, `500M`, `1G`, `2G`, `5G`, `8G`, and `10G`. **Note**: By default, the values of 2G, 5G, 8G, and 10G are unavailable. If you want to specify these values, contact your customer manager. Unit: **M** indicates Mbps, **G** indicates Gbps.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the resource
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="virtualPhysicalConnectionName")
    def virtual_physical_connection_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the physical connection.
        """
        return pulumi.get(self, "virtual_physical_connection_name")

    @property
    @pulumi.getter(name="virtualPhysicalConnectionStatus")
    def virtual_physical_connection_status(self) -> pulumi.Output[str]:
        """
        The business status of the shared line. Value:-**Confirmed**: The shared line has been Confirmed to receive.-**UnConfirmed**: The shared line has not been confirmed to be received.-**Deleted**: The shared line has been Deleted.
        """
        return pulumi.get(self, "virtual_physical_connection_status")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[int]:
        """
        The VLAN ID of the shared leased line. Valid values: `0` to `2999`.
        """
        return pulumi.get(self, "vlan_id")

    @property
    @pulumi.getter(name="vpconnAliUid")
    def vpconn_ali_uid(self) -> pulumi.Output[str]:
        """
        The ID of the Alibaba Cloud account (primary account) of the owner of the shared line.
        """
        return pulumi.get(self, "vpconn_ali_uid")

