# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FunctionArgs', 'Function']

@pulumi.input_type
class FunctionArgs:
    def __init__(__self__, *,
                 handler: pulumi.Input[str],
                 runtime: pulumi.Input[str],
                 service: pulumi.Input[str],
                 ca_port: Optional[pulumi.Input[int]] = None,
                 code_checksum: Optional[pulumi.Input[str]] = None,
                 custom_container_config: Optional[pulumi.Input['FunctionCustomContainerConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 filename: Optional[pulumi.Input[str]] = None,
                 initialization_timeout: Optional[pulumi.Input[int]] = None,
                 initializer: Optional[pulumi.Input[str]] = None,
                 instance_concurrency: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 oss_bucket: Optional[pulumi.Input[str]] = None,
                 oss_key: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Function resource.
        :param pulumi.Input[str] handler: The function [entry point](https://www.alibabacloud.com/help/doc-detail/157704.htm) in your code.
        :param pulumi.Input[str] runtime: See [Runtimes][https://www.alibabacloud.com/help/zh/function-compute/latest/manage-functions#multiTask3514] for valid values.
        :param pulumi.Input[str] service: The Function Compute service name.
        :param pulumi.Input[int] ca_port: The port that the function listen to, only valid for [custom runtime](https://www.alibabacloud.com/help/doc-detail/132044.htm) and [custom container runtime](https://www.alibabacloud.com/help/doc-detail/179368.htm).
        :param pulumi.Input[str] code_checksum: The checksum (crc64) of the function code.Used to trigger updates.The value can be generated by data source alicloud_file_crc64_checksum.
               > **NOTE:** For more information, see [Limits](https://www.alibabacloud.com/help/doc-detail/51907.htm).
        :param pulumi.Input['FunctionCustomContainerConfigArgs'] custom_container_config: The configuration for custom container runtime.See `custom_container_config` below.
        :param pulumi.Input[str] description: The Function Compute function description.
        :param pulumi.Input[Mapping[str, Any]] environment_variables: A map that defines environment variables for the function.
        :param pulumi.Input[str] filename: The path to the function's deployment package within the local filesystem. It is conflict with the `oss_`-prefixed options.
        :param pulumi.Input[int] initialization_timeout: The maximum length of time, in seconds, that the function's initialization should be run for.
        :param pulumi.Input[str] initializer: The entry point of the function's [initialization](https://www.alibabacloud.com/help/doc-detail/157704.htm).
        :param pulumi.Input[int] instance_concurrency: The maximum number of requests can be executed concurrently within the single function instance.
        :param pulumi.Input[str] instance_type: The instance type of the function.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layers: The configuration for layers.
        :param pulumi.Input[int] memory_size: Amount of memory in MB your function can use at runtime. Defaults to `128`. Limits to [128, 32768].
        :param pulumi.Input[str] name: The Function Compute function name. It is the only in one service and is conflict with "name_prefix".
        :param pulumi.Input[str] name_prefix: Setting a prefix to get a only function name. It is conflict with "name".
        :param pulumi.Input[str] oss_bucket: The OSS bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same Alibaba Cloud region where you are creating the function.
        :param pulumi.Input[str] oss_key: The OSS key of an object containing the function's deployment package. Conflicts with `filename`.
        :param pulumi.Input[int] timeout: The amount of time your function has to run in seconds.
        """
        pulumi.set(__self__, "handler", handler)
        pulumi.set(__self__, "runtime", runtime)
        pulumi.set(__self__, "service", service)
        if ca_port is not None:
            pulumi.set(__self__, "ca_port", ca_port)
        if code_checksum is not None:
            pulumi.set(__self__, "code_checksum", code_checksum)
        if custom_container_config is not None:
            pulumi.set(__self__, "custom_container_config", custom_container_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if initialization_timeout is not None:
            pulumi.set(__self__, "initialization_timeout", initialization_timeout)
        if initializer is not None:
            pulumi.set(__self__, "initializer", initializer)
        if instance_concurrency is not None:
            pulumi.set(__self__, "instance_concurrency", instance_concurrency)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if memory_size is not None:
            pulumi.set(__self__, "memory_size", memory_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if oss_bucket is not None:
            pulumi.set(__self__, "oss_bucket", oss_bucket)
        if oss_key is not None:
            pulumi.set(__self__, "oss_key", oss_key)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def handler(self) -> pulumi.Input[str]:
        """
        The function [entry point](https://www.alibabacloud.com/help/doc-detail/157704.htm) in your code.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: pulumi.Input[str]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Input[str]:
        """
        See [Runtimes][https://www.alibabacloud.com/help/zh/function-compute/latest/manage-functions#multiTask3514] for valid values.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: pulumi.Input[str]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        The Function Compute service name.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="caPort")
    def ca_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that the function listen to, only valid for [custom runtime](https://www.alibabacloud.com/help/doc-detail/132044.htm) and [custom container runtime](https://www.alibabacloud.com/help/doc-detail/179368.htm).
        """
        return pulumi.get(self, "ca_port")

    @ca_port.setter
    def ca_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ca_port", value)

    @property
    @pulumi.getter(name="codeChecksum")
    def code_checksum(self) -> Optional[pulumi.Input[str]]:
        """
        The checksum (crc64) of the function code.Used to trigger updates.The value can be generated by data source alicloud_file_crc64_checksum.
        > **NOTE:** For more information, see [Limits](https://www.alibabacloud.com/help/doc-detail/51907.htm).
        """
        return pulumi.get(self, "code_checksum")

    @code_checksum.setter
    def code_checksum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_checksum", value)

    @property
    @pulumi.getter(name="customContainerConfig")
    def custom_container_config(self) -> Optional[pulumi.Input['FunctionCustomContainerConfigArgs']]:
        """
        The configuration for custom container runtime.See `custom_container_config` below.
        """
        return pulumi.get(self, "custom_container_config")

    @custom_container_config.setter
    def custom_container_config(self, value: Optional[pulumi.Input['FunctionCustomContainerConfigArgs']]):
        pulumi.set(self, "custom_container_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The Function Compute function description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A map that defines environment variables for the function.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the function's deployment package within the local filesystem. It is conflict with the `oss_`-prefixed options.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filename", value)

    @property
    @pulumi.getter(name="initializationTimeout")
    def initialization_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum length of time, in seconds, that the function's initialization should be run for.
        """
        return pulumi.get(self, "initialization_timeout")

    @initialization_timeout.setter
    def initialization_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initialization_timeout", value)

    @property
    @pulumi.getter
    def initializer(self) -> Optional[pulumi.Input[str]]:
        """
        The entry point of the function's [initialization](https://www.alibabacloud.com/help/doc-detail/157704.htm).
        """
        return pulumi.get(self, "initializer")

    @initializer.setter
    def initializer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initializer", value)

    @property
    @pulumi.getter(name="instanceConcurrency")
    def instance_concurrency(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of requests can be executed concurrently within the single function instance.
        """
        return pulumi.get(self, "instance_concurrency")

    @instance_concurrency.setter
    def instance_concurrency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_concurrency", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type of the function.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The configuration for layers.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of memory in MB your function can use at runtime. Defaults to `128`. Limits to [128, 32768].
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The Function Compute function name. It is the only in one service and is conflict with "name_prefix".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Setting a prefix to get a only function name. It is conflict with "name".
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="ossBucket")
    def oss_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The OSS bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same Alibaba Cloud region where you are creating the function.
        """
        return pulumi.get(self, "oss_bucket")

    @oss_bucket.setter
    def oss_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oss_bucket", value)

    @property
    @pulumi.getter(name="ossKey")
    def oss_key(self) -> Optional[pulumi.Input[str]]:
        """
        The OSS key of an object containing the function's deployment package. Conflicts with `filename`.
        """
        return pulumi.get(self, "oss_key")

    @oss_key.setter
    def oss_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oss_key", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time your function has to run in seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _FunctionState:
    def __init__(__self__, *,
                 ca_port: Optional[pulumi.Input[int]] = None,
                 code_checksum: Optional[pulumi.Input[str]] = None,
                 custom_container_config: Optional[pulumi.Input['FunctionCustomContainerConfigArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 filename: Optional[pulumi.Input[str]] = None,
                 function_id: Optional[pulumi.Input[str]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 initialization_timeout: Optional[pulumi.Input[int]] = None,
                 initializer: Optional[pulumi.Input[str]] = None,
                 instance_concurrency: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 last_modified: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 oss_bucket: Optional[pulumi.Input[str]] = None,
                 oss_key: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Function resources.
        :param pulumi.Input[int] ca_port: The port that the function listen to, only valid for [custom runtime](https://www.alibabacloud.com/help/doc-detail/132044.htm) and [custom container runtime](https://www.alibabacloud.com/help/doc-detail/179368.htm).
        :param pulumi.Input[str] code_checksum: The checksum (crc64) of the function code.Used to trigger updates.The value can be generated by data source alicloud_file_crc64_checksum.
               > **NOTE:** For more information, see [Limits](https://www.alibabacloud.com/help/doc-detail/51907.htm).
        :param pulumi.Input['FunctionCustomContainerConfigArgs'] custom_container_config: The configuration for custom container runtime.See `custom_container_config` below.
        :param pulumi.Input[str] description: The Function Compute function description.
        :param pulumi.Input[Mapping[str, Any]] environment_variables: A map that defines environment variables for the function.
        :param pulumi.Input[str] filename: The path to the function's deployment package within the local filesystem. It is conflict with the `oss_`-prefixed options.
        :param pulumi.Input[str] function_id: The Function Compute service ID.
        :param pulumi.Input[str] handler: The function [entry point](https://www.alibabacloud.com/help/doc-detail/157704.htm) in your code.
        :param pulumi.Input[int] initialization_timeout: The maximum length of time, in seconds, that the function's initialization should be run for.
        :param pulumi.Input[str] initializer: The entry point of the function's [initialization](https://www.alibabacloud.com/help/doc-detail/157704.htm).
        :param pulumi.Input[int] instance_concurrency: The maximum number of requests can be executed concurrently within the single function instance.
        :param pulumi.Input[str] instance_type: The instance type of the function.
        :param pulumi.Input[str] last_modified: The date this resource was last modified.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layers: The configuration for layers.
        :param pulumi.Input[int] memory_size: Amount of memory in MB your function can use at runtime. Defaults to `128`. Limits to [128, 32768].
        :param pulumi.Input[str] name: The Function Compute function name. It is the only in one service and is conflict with "name_prefix".
        :param pulumi.Input[str] name_prefix: Setting a prefix to get a only function name. It is conflict with "name".
        :param pulumi.Input[str] oss_bucket: The OSS bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same Alibaba Cloud region where you are creating the function.
        :param pulumi.Input[str] oss_key: The OSS key of an object containing the function's deployment package. Conflicts with `filename`.
        :param pulumi.Input[str] runtime: See [Runtimes][https://www.alibabacloud.com/help/zh/function-compute/latest/manage-functions#multiTask3514] for valid values.
        :param pulumi.Input[str] service: The Function Compute service name.
        :param pulumi.Input[int] timeout: The amount of time your function has to run in seconds.
        """
        if ca_port is not None:
            pulumi.set(__self__, "ca_port", ca_port)
        if code_checksum is not None:
            pulumi.set(__self__, "code_checksum", code_checksum)
        if custom_container_config is not None:
            pulumi.set(__self__, "custom_container_config", custom_container_config)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if filename is not None:
            pulumi.set(__self__, "filename", filename)
        if function_id is not None:
            pulumi.set(__self__, "function_id", function_id)
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if initialization_timeout is not None:
            pulumi.set(__self__, "initialization_timeout", initialization_timeout)
        if initializer is not None:
            pulumi.set(__self__, "initializer", initializer)
        if instance_concurrency is not None:
            pulumi.set(__self__, "instance_concurrency", instance_concurrency)
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if layers is not None:
            pulumi.set(__self__, "layers", layers)
        if memory_size is not None:
            pulumi.set(__self__, "memory_size", memory_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if oss_bucket is not None:
            pulumi.set(__self__, "oss_bucket", oss_bucket)
        if oss_key is not None:
            pulumi.set(__self__, "oss_key", oss_key)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="caPort")
    def ca_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that the function listen to, only valid for [custom runtime](https://www.alibabacloud.com/help/doc-detail/132044.htm) and [custom container runtime](https://www.alibabacloud.com/help/doc-detail/179368.htm).
        """
        return pulumi.get(self, "ca_port")

    @ca_port.setter
    def ca_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ca_port", value)

    @property
    @pulumi.getter(name="codeChecksum")
    def code_checksum(self) -> Optional[pulumi.Input[str]]:
        """
        The checksum (crc64) of the function code.Used to trigger updates.The value can be generated by data source alicloud_file_crc64_checksum.
        > **NOTE:** For more information, see [Limits](https://www.alibabacloud.com/help/doc-detail/51907.htm).
        """
        return pulumi.get(self, "code_checksum")

    @code_checksum.setter
    def code_checksum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code_checksum", value)

    @property
    @pulumi.getter(name="customContainerConfig")
    def custom_container_config(self) -> Optional[pulumi.Input['FunctionCustomContainerConfigArgs']]:
        """
        The configuration for custom container runtime.See `custom_container_config` below.
        """
        return pulumi.get(self, "custom_container_config")

    @custom_container_config.setter
    def custom_container_config(self, value: Optional[pulumi.Input['FunctionCustomContainerConfigArgs']]):
        pulumi.set(self, "custom_container_config", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The Function Compute function description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A map that defines environment variables for the function.
        """
        return pulumi.get(self, "environment_variables")

    @environment_variables.setter
    def environment_variables(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "environment_variables", value)

    @property
    @pulumi.getter
    def filename(self) -> Optional[pulumi.Input[str]]:
        """
        The path to the function's deployment package within the local filesystem. It is conflict with the `oss_`-prefixed options.
        """
        return pulumi.get(self, "filename")

    @filename.setter
    def filename(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filename", value)

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Function Compute service ID.
        """
        return pulumi.get(self, "function_id")

    @function_id.setter
    def function_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_id", value)

    @property
    @pulumi.getter
    def handler(self) -> Optional[pulumi.Input[str]]:
        """
        The function [entry point](https://www.alibabacloud.com/help/doc-detail/157704.htm) in your code.
        """
        return pulumi.get(self, "handler")

    @handler.setter
    def handler(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "handler", value)

    @property
    @pulumi.getter(name="initializationTimeout")
    def initialization_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum length of time, in seconds, that the function's initialization should be run for.
        """
        return pulumi.get(self, "initialization_timeout")

    @initialization_timeout.setter
    def initialization_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "initialization_timeout", value)

    @property
    @pulumi.getter
    def initializer(self) -> Optional[pulumi.Input[str]]:
        """
        The entry point of the function's [initialization](https://www.alibabacloud.com/help/doc-detail/157704.htm).
        """
        return pulumi.get(self, "initializer")

    @initializer.setter
    def initializer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initializer", value)

    @property
    @pulumi.getter(name="instanceConcurrency")
    def instance_concurrency(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of requests can be executed concurrently within the single function instance.
        """
        return pulumi.get(self, "instance_concurrency")

    @instance_concurrency.setter
    def instance_concurrency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_concurrency", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The instance type of the function.
        """
        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[str]]:
        """
        The date this resource was last modified.
        """
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified", value)

    @property
    @pulumi.getter
    def layers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The configuration for layers.
        """
        return pulumi.get(self, "layers")

    @layers.setter
    def layers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "layers", value)

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of memory in MB your function can use at runtime. Defaults to `128`. Limits to [128, 32768].
        """
        return pulumi.get(self, "memory_size")

    @memory_size.setter
    def memory_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The Function Compute function name. It is the only in one service and is conflict with "name_prefix".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Setting a prefix to get a only function name. It is conflict with "name".
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter(name="ossBucket")
    def oss_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The OSS bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same Alibaba Cloud region where you are creating the function.
        """
        return pulumi.get(self, "oss_bucket")

    @oss_bucket.setter
    def oss_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oss_bucket", value)

    @property
    @pulumi.getter(name="ossKey")
    def oss_key(self) -> Optional[pulumi.Input[str]]:
        """
        The OSS key of an object containing the function's deployment package. Conflicts with `filename`.
        """
        return pulumi.get(self, "oss_key")

    @oss_key.setter
    def oss_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oss_key", value)

    @property
    @pulumi.getter
    def runtime(self) -> Optional[pulumi.Input[str]]:
        """
        See [Runtimes][https://www.alibabacloud.com/help/zh/function-compute/latest/manage-functions#multiTask3514] for valid values.
        """
        return pulumi.get(self, "runtime")

    @runtime.setter
    def runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "runtime", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        The Function Compute service name.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time your function has to run in seconds.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


class Function(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_port: Optional[pulumi.Input[int]] = None,
                 code_checksum: Optional[pulumi.Input[str]] = None,
                 custom_container_config: Optional[pulumi.Input[pulumi.InputType['FunctionCustomContainerConfigArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 filename: Optional[pulumi.Input[str]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 initialization_timeout: Optional[pulumi.Input[int]] = None,
                 initializer: Optional[pulumi.Input[str]] = None,
                 instance_concurrency: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 oss_bucket: Optional[pulumi.Input[str]] = None,
                 oss_key: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a Alicloud Function Compute Function resource. Function allows you to trigger execution of code in response to events in Alibaba Cloud. The Function itself includes source code and runtime configuration.
         For information about Service and how to use it, see [What is Function Compute](https://www.alibabacloud.com/help/en/fc/developer-reference/api-createfunction).

        > **NOTE:** The resource requires a provider field 'account_id'. See account_id.

        > **NOTE:** Available since v1.10.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_project = alicloud.log.Project("defaultProject")
        default_store = alicloud.log.Store("defaultStore", project=default_project.name)
        default_role = alicloud.ram.Role("defaultRole",
            document=\"\"\"  {
              "Statement": [
                {
                  "Action": "sts:AssumeRole",
                  "Effect": "Allow",
                  "Principal": {
                    "Service": [
                      "fc.aliyuncs.com"
                    ]
                  }
                }
              ],
              "Version": "1"
          }
        \"\"\",
            description="this is a example",
            force=True)
        default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("defaultRolePolicyAttachment",
            role_name=default_role.name,
            policy_name="AliyunLogFullAccess",
            policy_type="System")
        default_service = alicloud.fc.Service("defaultService",
            description="example-value",
            role=default_role.arn,
            log_config=alicloud.fc.ServiceLogConfigArgs(
                project=default_project.name,
                logstore=default_store.name,
                enable_instance_metrics=True,
                enable_request_metrics=True,
            ))
        default_bucket = alicloud.oss.Bucket("defaultBucket", bucket=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"))
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("defaultBucketObject",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        foo = alicloud.fc.Function("foo",
            service=default_service.name,
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler",
            environment_variables={
                "prefix": "terraform",
            })
        ```
        ## Module Support

        You can use to the existing fc module
        to create a function quickly and set several triggers for it.

        ## Import

        Function Compute function can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:fc/function:Function foo my-fc-service:hello-world
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] ca_port: The port that the function listen to, only valid for [custom runtime](https://www.alibabacloud.com/help/doc-detail/132044.htm) and [custom container runtime](https://www.alibabacloud.com/help/doc-detail/179368.htm).
        :param pulumi.Input[str] code_checksum: The checksum (crc64) of the function code.Used to trigger updates.The value can be generated by data source alicloud_file_crc64_checksum.
               > **NOTE:** For more information, see [Limits](https://www.alibabacloud.com/help/doc-detail/51907.htm).
        :param pulumi.Input[pulumi.InputType['FunctionCustomContainerConfigArgs']] custom_container_config: The configuration for custom container runtime.See `custom_container_config` below.
        :param pulumi.Input[str] description: The Function Compute function description.
        :param pulumi.Input[Mapping[str, Any]] environment_variables: A map that defines environment variables for the function.
        :param pulumi.Input[str] filename: The path to the function's deployment package within the local filesystem. It is conflict with the `oss_`-prefixed options.
        :param pulumi.Input[str] handler: The function [entry point](https://www.alibabacloud.com/help/doc-detail/157704.htm) in your code.
        :param pulumi.Input[int] initialization_timeout: The maximum length of time, in seconds, that the function's initialization should be run for.
        :param pulumi.Input[str] initializer: The entry point of the function's [initialization](https://www.alibabacloud.com/help/doc-detail/157704.htm).
        :param pulumi.Input[int] instance_concurrency: The maximum number of requests can be executed concurrently within the single function instance.
        :param pulumi.Input[str] instance_type: The instance type of the function.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layers: The configuration for layers.
        :param pulumi.Input[int] memory_size: Amount of memory in MB your function can use at runtime. Defaults to `128`. Limits to [128, 32768].
        :param pulumi.Input[str] name: The Function Compute function name. It is the only in one service and is conflict with "name_prefix".
        :param pulumi.Input[str] name_prefix: Setting a prefix to get a only function name. It is conflict with "name".
        :param pulumi.Input[str] oss_bucket: The OSS bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same Alibaba Cloud region where you are creating the function.
        :param pulumi.Input[str] oss_key: The OSS key of an object containing the function's deployment package. Conflicts with `filename`.
        :param pulumi.Input[str] runtime: See [Runtimes][https://www.alibabacloud.com/help/zh/function-compute/latest/manage-functions#multiTask3514] for valid values.
        :param pulumi.Input[str] service: The Function Compute service name.
        :param pulumi.Input[int] timeout: The amount of time your function has to run in seconds.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FunctionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Alicloud Function Compute Function resource. Function allows you to trigger execution of code in response to events in Alibaba Cloud. The Function itself includes source code and runtime configuration.
         For information about Service and how to use it, see [What is Function Compute](https://www.alibabacloud.com/help/en/fc/developer-reference/api-createfunction).

        > **NOTE:** The resource requires a provider field 'account_id'. See account_id.

        > **NOTE:** Available since v1.10.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_project = alicloud.log.Project("defaultProject")
        default_store = alicloud.log.Store("defaultStore", project=default_project.name)
        default_role = alicloud.ram.Role("defaultRole",
            document=\"\"\"  {
              "Statement": [
                {
                  "Action": "sts:AssumeRole",
                  "Effect": "Allow",
                  "Principal": {
                    "Service": [
                      "fc.aliyuncs.com"
                    ]
                  }
                }
              ],
              "Version": "1"
          }
        \"\"\",
            description="this is a example",
            force=True)
        default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("defaultRolePolicyAttachment",
            role_name=default_role.name,
            policy_name="AliyunLogFullAccess",
            policy_type="System")
        default_service = alicloud.fc.Service("defaultService",
            description="example-value",
            role=default_role.arn,
            log_config=alicloud.fc.ServiceLogConfigArgs(
                project=default_project.name,
                logstore=default_store.name,
                enable_instance_metrics=True,
                enable_request_metrics=True,
            ))
        default_bucket = alicloud.oss.Bucket("defaultBucket", bucket=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"))
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("defaultBucketObject",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        foo = alicloud.fc.Function("foo",
            service=default_service.name,
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler",
            environment_variables={
                "prefix": "terraform",
            })
        ```
        ## Module Support

        You can use to the existing fc module
        to create a function quickly and set several triggers for it.

        ## Import

        Function Compute function can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:fc/function:Function foo my-fc-service:hello-world
        ```

        :param str resource_name: The name of the resource.
        :param FunctionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FunctionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_port: Optional[pulumi.Input[int]] = None,
                 code_checksum: Optional[pulumi.Input[str]] = None,
                 custom_container_config: Optional[pulumi.Input[pulumi.InputType['FunctionCustomContainerConfigArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 filename: Optional[pulumi.Input[str]] = None,
                 handler: Optional[pulumi.Input[str]] = None,
                 initialization_timeout: Optional[pulumi.Input[int]] = None,
                 initializer: Optional[pulumi.Input[str]] = None,
                 instance_concurrency: Optional[pulumi.Input[int]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 memory_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 oss_bucket: Optional[pulumi.Input[str]] = None,
                 oss_key: Optional[pulumi.Input[str]] = None,
                 runtime: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FunctionArgs.__new__(FunctionArgs)

            __props__.__dict__["ca_port"] = ca_port
            __props__.__dict__["code_checksum"] = code_checksum
            __props__.__dict__["custom_container_config"] = custom_container_config
            __props__.__dict__["description"] = description
            __props__.__dict__["environment_variables"] = environment_variables
            __props__.__dict__["filename"] = filename
            if handler is None and not opts.urn:
                raise TypeError("Missing required property 'handler'")
            __props__.__dict__["handler"] = handler
            __props__.__dict__["initialization_timeout"] = initialization_timeout
            __props__.__dict__["initializer"] = initializer
            __props__.__dict__["instance_concurrency"] = instance_concurrency
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["layers"] = layers
            __props__.__dict__["memory_size"] = memory_size
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["oss_bucket"] = oss_bucket
            __props__.__dict__["oss_key"] = oss_key
            if runtime is None and not opts.urn:
                raise TypeError("Missing required property 'runtime'")
            __props__.__dict__["runtime"] = runtime
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["function_id"] = None
            __props__.__dict__["last_modified"] = None
        super(Function, __self__).__init__(
            'alicloud:fc/function:Function',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ca_port: Optional[pulumi.Input[int]] = None,
            code_checksum: Optional[pulumi.Input[str]] = None,
            custom_container_config: Optional[pulumi.Input[pulumi.InputType['FunctionCustomContainerConfigArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            environment_variables: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            filename: Optional[pulumi.Input[str]] = None,
            function_id: Optional[pulumi.Input[str]] = None,
            handler: Optional[pulumi.Input[str]] = None,
            initialization_timeout: Optional[pulumi.Input[int]] = None,
            initializer: Optional[pulumi.Input[str]] = None,
            instance_concurrency: Optional[pulumi.Input[int]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            last_modified: Optional[pulumi.Input[str]] = None,
            layers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            memory_size: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_prefix: Optional[pulumi.Input[str]] = None,
            oss_bucket: Optional[pulumi.Input[str]] = None,
            oss_key: Optional[pulumi.Input[str]] = None,
            runtime: Optional[pulumi.Input[str]] = None,
            service: Optional[pulumi.Input[str]] = None,
            timeout: Optional[pulumi.Input[int]] = None) -> 'Function':
        """
        Get an existing Function resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] ca_port: The port that the function listen to, only valid for [custom runtime](https://www.alibabacloud.com/help/doc-detail/132044.htm) and [custom container runtime](https://www.alibabacloud.com/help/doc-detail/179368.htm).
        :param pulumi.Input[str] code_checksum: The checksum (crc64) of the function code.Used to trigger updates.The value can be generated by data source alicloud_file_crc64_checksum.
               > **NOTE:** For more information, see [Limits](https://www.alibabacloud.com/help/doc-detail/51907.htm).
        :param pulumi.Input[pulumi.InputType['FunctionCustomContainerConfigArgs']] custom_container_config: The configuration for custom container runtime.See `custom_container_config` below.
        :param pulumi.Input[str] description: The Function Compute function description.
        :param pulumi.Input[Mapping[str, Any]] environment_variables: A map that defines environment variables for the function.
        :param pulumi.Input[str] filename: The path to the function's deployment package within the local filesystem. It is conflict with the `oss_`-prefixed options.
        :param pulumi.Input[str] function_id: The Function Compute service ID.
        :param pulumi.Input[str] handler: The function [entry point](https://www.alibabacloud.com/help/doc-detail/157704.htm) in your code.
        :param pulumi.Input[int] initialization_timeout: The maximum length of time, in seconds, that the function's initialization should be run for.
        :param pulumi.Input[str] initializer: The entry point of the function's [initialization](https://www.alibabacloud.com/help/doc-detail/157704.htm).
        :param pulumi.Input[int] instance_concurrency: The maximum number of requests can be executed concurrently within the single function instance.
        :param pulumi.Input[str] instance_type: The instance type of the function.
        :param pulumi.Input[str] last_modified: The date this resource was last modified.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] layers: The configuration for layers.
        :param pulumi.Input[int] memory_size: Amount of memory in MB your function can use at runtime. Defaults to `128`. Limits to [128, 32768].
        :param pulumi.Input[str] name: The Function Compute function name. It is the only in one service and is conflict with "name_prefix".
        :param pulumi.Input[str] name_prefix: Setting a prefix to get a only function name. It is conflict with "name".
        :param pulumi.Input[str] oss_bucket: The OSS bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same Alibaba Cloud region where you are creating the function.
        :param pulumi.Input[str] oss_key: The OSS key of an object containing the function's deployment package. Conflicts with `filename`.
        :param pulumi.Input[str] runtime: See [Runtimes][https://www.alibabacloud.com/help/zh/function-compute/latest/manage-functions#multiTask3514] for valid values.
        :param pulumi.Input[str] service: The Function Compute service name.
        :param pulumi.Input[int] timeout: The amount of time your function has to run in seconds.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FunctionState.__new__(_FunctionState)

        __props__.__dict__["ca_port"] = ca_port
        __props__.__dict__["code_checksum"] = code_checksum
        __props__.__dict__["custom_container_config"] = custom_container_config
        __props__.__dict__["description"] = description
        __props__.__dict__["environment_variables"] = environment_variables
        __props__.__dict__["filename"] = filename
        __props__.__dict__["function_id"] = function_id
        __props__.__dict__["handler"] = handler
        __props__.__dict__["initialization_timeout"] = initialization_timeout
        __props__.__dict__["initializer"] = initializer
        __props__.__dict__["instance_concurrency"] = instance_concurrency
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["layers"] = layers
        __props__.__dict__["memory_size"] = memory_size
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["oss_bucket"] = oss_bucket
        __props__.__dict__["oss_key"] = oss_key
        __props__.__dict__["runtime"] = runtime
        __props__.__dict__["service"] = service
        __props__.__dict__["timeout"] = timeout
        return Function(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="caPort")
    def ca_port(self) -> pulumi.Output[Optional[int]]:
        """
        The port that the function listen to, only valid for [custom runtime](https://www.alibabacloud.com/help/doc-detail/132044.htm) and [custom container runtime](https://www.alibabacloud.com/help/doc-detail/179368.htm).
        """
        return pulumi.get(self, "ca_port")

    @property
    @pulumi.getter(name="codeChecksum")
    def code_checksum(self) -> pulumi.Output[str]:
        """
        The checksum (crc64) of the function code.Used to trigger updates.The value can be generated by data source alicloud_file_crc64_checksum.
        > **NOTE:** For more information, see [Limits](https://www.alibabacloud.com/help/doc-detail/51907.htm).
        """
        return pulumi.get(self, "code_checksum")

    @property
    @pulumi.getter(name="customContainerConfig")
    def custom_container_config(self) -> pulumi.Output[Optional['outputs.FunctionCustomContainerConfig']]:
        """
        The configuration for custom container runtime.See `custom_container_config` below.
        """
        return pulumi.get(self, "custom_container_config")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The Function Compute function description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A map that defines environment variables for the function.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter
    def filename(self) -> pulumi.Output[Optional[str]]:
        """
        The path to the function's deployment package within the local filesystem. It is conflict with the `oss_`-prefixed options.
        """
        return pulumi.get(self, "filename")

    @property
    @pulumi.getter(name="functionId")
    def function_id(self) -> pulumi.Output[str]:
        """
        The Function Compute service ID.
        """
        return pulumi.get(self, "function_id")

    @property
    @pulumi.getter
    def handler(self) -> pulumi.Output[str]:
        """
        The function [entry point](https://www.alibabacloud.com/help/doc-detail/157704.htm) in your code.
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter(name="initializationTimeout")
    def initialization_timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum length of time, in seconds, that the function's initialization should be run for.
        """
        return pulumi.get(self, "initialization_timeout")

    @property
    @pulumi.getter
    def initializer(self) -> pulumi.Output[Optional[str]]:
        """
        The entry point of the function's [initialization](https://www.alibabacloud.com/help/doc-detail/157704.htm).
        """
        return pulumi.get(self, "initializer")

    @property
    @pulumi.getter(name="instanceConcurrency")
    def instance_concurrency(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of requests can be executed concurrently within the single function instance.
        """
        return pulumi.get(self, "instance_concurrency")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[Optional[str]]:
        """
        The instance type of the function.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[str]:
        """
        The date this resource was last modified.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def layers(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The configuration for layers.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> pulumi.Output[Optional[int]]:
        """
        Amount of memory in MB your function can use at runtime. Defaults to `128`. Limits to [128, 32768].
        """
        return pulumi.get(self, "memory_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The Function Compute function name. It is the only in one service and is conflict with "name_prefix".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        Setting a prefix to get a only function name. It is conflict with "name".
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter(name="ossBucket")
    def oss_bucket(self) -> pulumi.Output[Optional[str]]:
        """
        The OSS bucket location containing the function's deployment package. Conflicts with `filename`. This bucket must reside in the same Alibaba Cloud region where you are creating the function.
        """
        return pulumi.get(self, "oss_bucket")

    @property
    @pulumi.getter(name="ossKey")
    def oss_key(self) -> pulumi.Output[Optional[str]]:
        """
        The OSS key of an object containing the function's deployment package. Conflicts with `filename`.
        """
        return pulumi.get(self, "oss_key")

    @property
    @pulumi.getter
    def runtime(self) -> pulumi.Output[str]:
        """
        See [Runtimes][https://www.alibabacloud.com/help/zh/function-compute/latest/manage-functions#multiTask3514] for valid values.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[str]:
        """
        The Function Compute service name.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[int]]:
        """
        The amount of time your function has to run in seconds.
        """
        return pulumi.get(self, "timeout")

