# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AliasRoutingConfig',
    'CustomDomainCertConfig',
    'CustomDomainRouteConfig',
    'FunctionAsyncInvokeConfigDestinationConfig',
    'FunctionAsyncInvokeConfigDestinationConfigOnFailure',
    'FunctionAsyncInvokeConfigDestinationConfigOnSuccess',
    'FunctionCustomContainerConfig',
    'ServiceLogConfig',
    'ServiceNasConfig',
    'ServiceNasConfigMountPoint',
    'ServiceTracingConfig',
    'ServiceVpcConfig',
    'V2FunctionCode',
    'V2FunctionCustomContainerConfig',
    'V2FunctionCustomDns',
    'V2FunctionCustomDnsDnsOption',
    'V2FunctionCustomHealthCheckConfig',
    'V2FunctionCustomRuntimeConfig',
    'V2FunctionInstanceLifecycleConfig',
    'V2FunctionInstanceLifecycleConfigPreFreeze',
    'V2FunctionInstanceLifecycleConfigPreStop',
    'GetCustomDomainsDomainResult',
    'GetCustomDomainsDomainCertConfigResult',
    'GetCustomDomainsDomainRouteConfigResult',
    'GetFunctionsFunctionResult',
    'GetFunctionsFunctionCustomContainerConfigResult',
    'GetServicesServiceResult',
    'GetServicesServiceLogConfigResult',
    'GetServicesServiceNasConfigResult',
    'GetServicesServiceNasConfigMountPointResult',
    'GetServicesServiceVpcConfigResult',
    'GetTriggersTriggerResult',
    'GetZonesZoneResult',
]

@pulumi.output_type
class AliasRoutingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalVersionWeights":
            suggest = "additional_version_weights"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AliasRoutingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AliasRoutingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AliasRoutingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_version_weights: Optional[Mapping[str, float]] = None):
        """
        :param Mapping[str, float] additional_version_weights: A map that defines the proportion of events that should be sent to different versions of a Function Compute service.
        """
        if additional_version_weights is not None:
            pulumi.set(__self__, "additional_version_weights", additional_version_weights)

    @property
    @pulumi.getter(name="additionalVersionWeights")
    def additional_version_weights(self) -> Optional[Mapping[str, float]]:
        """
        A map that defines the proportion of events that should be sent to different versions of a Function Compute service.
        """
        return pulumi.get(self, "additional_version_weights")


@pulumi.output_type
class CustomDomainCertConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certName":
            suggest = "cert_name"
        elif key == "privateKey":
            suggest = "private_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDomainCertConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDomainCertConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDomainCertConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert_name: str,
                 certificate: str,
                 private_key: str):
        """
        :param str cert_name: The name of the certificate, used to distinguish different certificates.
        :param str certificate: Certificate data of the HTTPS certificates, follow the 'pem' format.
        :param str private_key: Private key of the HTTPS certificates, follow the 'pem' format.
        """
        pulumi.set(__self__, "cert_name", cert_name)
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "private_key", private_key)

    @property
    @pulumi.getter(name="certName")
    def cert_name(self) -> str:
        """
        The name of the certificate, used to distinguish different certificates.
        """
        return pulumi.get(self, "cert_name")

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        Certificate data of the HTTPS certificates, follow the 'pem' format.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        """
        Private key of the HTTPS certificates, follow the 'pem' format.
        """
        return pulumi.get(self, "private_key")


@pulumi.output_type
class CustomDomainRouteConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionName":
            suggest = "function_name"
        elif key == "serviceName":
            suggest = "service_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDomainRouteConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDomainRouteConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDomainRouteConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_name: str,
                 path: str,
                 service_name: str,
                 methods: Optional[Sequence[str]] = None,
                 qualifier: Optional[str] = None):
        """
        :param str function_name: The name of the Function Compute function that requests are routed to.
        :param str path: The path that requests are routed from.
        :param str service_name: The name of the Function Compute service that requests are routed to.
        :param Sequence[str] methods: The requests of the specified HTTP methos are routed from. Valid method: GET, POST, DELETE, HEAD, PUT and PATCH. For example, "GET, HEAD" methods indicate that only requests from GET and HEAD methods are routed.
        :param str qualifier: The version or alias of the Function Compute service that requests are routed to. For example, qualifier v1 indicates that the requests are routed to the version 1 Function Compute service. For detail information about version and alias, please refer to the [developer guide](https://www.alibabacloud.com/help/doc-detail/96464.htm).
        """
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "service_name", service_name)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if qualifier is not None:
            pulumi.set(__self__, "qualifier", qualifier)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> str:
        """
        The name of the Function Compute function that requests are routed to.
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path that requests are routed from.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The name of the Function Compute service that requests are routed to.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def methods(self) -> Optional[Sequence[str]]:
        """
        The requests of the specified HTTP methos are routed from. Valid method: GET, POST, DELETE, HEAD, PUT and PATCH. For example, "GET, HEAD" methods indicate that only requests from GET and HEAD methods are routed.
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def qualifier(self) -> Optional[str]:
        """
        The version or alias of the Function Compute service that requests are routed to. For example, qualifier v1 indicates that the requests are routed to the version 1 Function Compute service. For detail information about version and alias, please refer to the [developer guide](https://www.alibabacloud.com/help/doc-detail/96464.htm).
        """
        return pulumi.get(self, "qualifier")


@pulumi.output_type
class FunctionAsyncInvokeConfigDestinationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onFailure":
            suggest = "on_failure"
        elif key == "onSuccess":
            suggest = "on_success"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionAsyncInvokeConfigDestinationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionAsyncInvokeConfigDestinationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionAsyncInvokeConfigDestinationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_failure: Optional['outputs.FunctionAsyncInvokeConfigDestinationConfigOnFailure'] = None,
                 on_success: Optional['outputs.FunctionAsyncInvokeConfigDestinationConfigOnSuccess'] = None):
        """
        :param 'FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs' on_failure: Configuration block with destination configuration for failed asynchronous invocations. See `on_failure` below.
        :param 'FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs' on_success: Configuration block with destination configuration for successful asynchronous invocations. See `on_success` below.
        """
        if on_failure is not None:
            pulumi.set(__self__, "on_failure", on_failure)
        if on_success is not None:
            pulumi.set(__self__, "on_success", on_success)

    @property
    @pulumi.getter(name="onFailure")
    def on_failure(self) -> Optional['outputs.FunctionAsyncInvokeConfigDestinationConfigOnFailure']:
        """
        Configuration block with destination configuration for failed asynchronous invocations. See `on_failure` below.
        """
        return pulumi.get(self, "on_failure")

    @property
    @pulumi.getter(name="onSuccess")
    def on_success(self) -> Optional['outputs.FunctionAsyncInvokeConfigDestinationConfigOnSuccess']:
        """
        Configuration block with destination configuration for successful asynchronous invocations. See `on_success` below.
        """
        return pulumi.get(self, "on_success")


@pulumi.output_type
class FunctionAsyncInvokeConfigDestinationConfigOnFailure(dict):
    def __init__(__self__, *,
                 destination: str):
        """
        :param str destination: Alicloud Resource Name (ARN) of the destination resource. See the [Developer Guide](https://www.alibabacloud.com/help/doc-detail/181866.htm) for acceptable resource types and associated RAM permissions.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Alicloud Resource Name (ARN) of the destination resource. See the [Developer Guide](https://www.alibabacloud.com/help/doc-detail/181866.htm) for acceptable resource types and associated RAM permissions.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class FunctionAsyncInvokeConfigDestinationConfigOnSuccess(dict):
    def __init__(__self__, *,
                 destination: str):
        """
        :param str destination: Alicloud Resource Name (ARN) of the destination resource. See the [Developer Guide](https://www.alibabacloud.com/help/doc-detail/181866.htm) for acceptable resource types and associated RAM permissions.
        """
        pulumi.set(__self__, "destination", destination)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        Alicloud Resource Name (ARN) of the destination resource. See the [Developer Guide](https://www.alibabacloud.com/help/doc-detail/181866.htm) for acceptable resource types and associated RAM permissions.
        """
        return pulumi.get(self, "destination")


@pulumi.output_type
class FunctionCustomContainerConfig(dict):
    def __init__(__self__, *,
                 image: str,
                 args: Optional[str] = None,
                 command: Optional[str] = None):
        """
        :param str image: The container image address.
        :param str args: The args field specifies the arguments passed to the command.
        :param str command: The entry point of the container, which specifies the actual command run by the container.
        """
        pulumi.set(__self__, "image", image)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The container image address.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def args(self) -> Optional[str]:
        """
        The args field specifies the arguments passed to the command.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Optional[str]:
        """
        The entry point of the container, which specifies the actual command run by the container.
        """
        return pulumi.get(self, "command")


@pulumi.output_type
class ServiceLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableInstanceMetrics":
            suggest = "enable_instance_metrics"
        elif key == "enableRequestMetrics":
            suggest = "enable_request_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 logstore: str,
                 project: str,
                 enable_instance_metrics: Optional[bool] = None,
                 enable_request_metrics: Optional[bool] = None):
        """
        :param str logstore: The log store name of Alicloud Simple Log Service.
        :param str project: The project name of the Alicloud Simple Log Service.
        :param bool enable_instance_metrics: Enable instance level metrics.
        :param bool enable_request_metrics: Enable request level metrics.
        """
        pulumi.set(__self__, "logstore", logstore)
        pulumi.set(__self__, "project", project)
        if enable_instance_metrics is not None:
            pulumi.set(__self__, "enable_instance_metrics", enable_instance_metrics)
        if enable_request_metrics is not None:
            pulumi.set(__self__, "enable_request_metrics", enable_request_metrics)

    @property
    @pulumi.getter
    def logstore(self) -> str:
        """
        The log store name of Alicloud Simple Log Service.
        """
        return pulumi.get(self, "logstore")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The project name of the Alicloud Simple Log Service.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="enableInstanceMetrics")
    def enable_instance_metrics(self) -> Optional[bool]:
        """
        Enable instance level metrics.
        """
        return pulumi.get(self, "enable_instance_metrics")

    @property
    @pulumi.getter(name="enableRequestMetrics")
    def enable_request_metrics(self) -> Optional[bool]:
        """
        Enable request level metrics.
        """
        return pulumi.get(self, "enable_request_metrics")


@pulumi.output_type
class ServiceNasConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupId":
            suggest = "group_id"
        elif key == "mountPoints":
            suggest = "mount_points"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceNasConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceNasConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceNasConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_id: int,
                 mount_points: Sequence['outputs.ServiceNasConfigMountPoint'],
                 user_id: int):
        """
        :param int group_id: The group id of your NAS file system.
        :param Sequence['ServiceNasConfigMountPointArgs'] mount_points: Config the NAS mount points.See `mount_points` below.
        :param int user_id: The user id of your NAS file system.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "mount_points", mount_points)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> int:
        """
        The group id of your NAS file system.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Sequence['outputs.ServiceNasConfigMountPoint']:
        """
        Config the NAS mount points.See `mount_points` below.
        """
        return pulumi.get(self, "mount_points")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> int:
        """
        The user id of your NAS file system.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class ServiceNasConfigMountPoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountDir":
            suggest = "mount_dir"
        elif key == "serverAddr":
            suggest = "server_addr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceNasConfigMountPoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceNasConfigMountPoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceNasConfigMountPoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_dir: str,
                 server_addr: str):
        """
        :param str mount_dir: The local address where to mount your remote NAS directory.
        :param str server_addr: The address of the remote NAS directory.
        """
        pulumi.set(__self__, "mount_dir", mount_dir)
        pulumi.set(__self__, "server_addr", server_addr)

    @property
    @pulumi.getter(name="mountDir")
    def mount_dir(self) -> str:
        """
        The local address where to mount your remote NAS directory.
        """
        return pulumi.get(self, "mount_dir")

    @property
    @pulumi.getter(name="serverAddr")
    def server_addr(self) -> str:
        """
        The address of the remote NAS directory.
        """
        return pulumi.get(self, "server_addr")


@pulumi.output_type
class ServiceTracingConfig(dict):
    def __init__(__self__, *,
                 params: Mapping[str, Any],
                 type: str):
        """
        :param Mapping[str, Any] params: Tracing parameters, which type is map[string]string. When the protocol type is Jaeger, the key is "endpoint" and the value is your tracing intranet endpoint. For example endpoint: http://tracing-analysis-dc-hz.aliyuncs.com/adapt_xxx/api/traces.
        :param str type: Tracing protocol type. Currently, only Jaeger is supported.
        """
        pulumi.set(__self__, "params", params)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def params(self) -> Mapping[str, Any]:
        """
        Tracing parameters, which type is map[string]string. When the protocol type is Jaeger, the key is "endpoint" and the value is your tracing intranet endpoint. For example endpoint: http://tracing-analysis-dc-hz.aliyuncs.com/adapt_xxx/api/traces.
        """
        return pulumi.get(self, "params")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Tracing protocol type. Currently, only Jaeger is supported.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ServiceVpcConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "securityGroupId":
            suggest = "security_group_id"
        elif key == "vswitchIds":
            suggest = "vswitch_ids"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceVpcConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceVpcConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceVpcConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 security_group_id: str,
                 vswitch_ids: Sequence[str],
                 vpc_id: Optional[str] = None):
        """
        :param str security_group_id: A security group ID associated with the Function Compute Service.
        :param Sequence[str] vswitch_ids: A list of vswitch IDs associated with the Function Compute Service.
        :param str vpc_id: A vpc ID associated with the Function Compute Service.
        """
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        A security group ID associated with the Function Compute Service.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[str]:
        """
        A list of vswitch IDs associated with the Function Compute Service.
        """
        return pulumi.get(self, "vswitch_ids")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        A vpc ID associated with the Function Compute Service.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class V2FunctionCode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ossBucketName":
            suggest = "oss_bucket_name"
        elif key == "ossObjectName":
            suggest = "oss_object_name"
        elif key == "zipFile":
            suggest = "zip_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2FunctionCode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2FunctionCode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2FunctionCode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oss_bucket_name: Optional[str] = None,
                 oss_object_name: Optional[str] = None,
                 zip_file: Optional[str] = None):
        """
        :param str oss_bucket_name: The OSS bucket name of the function code package.
        :param str oss_object_name: The OSS object name of the function code package.
        :param str zip_file: Upload the base64 encoding of the code zip package directly in the request body.
        """
        if oss_bucket_name is not None:
            pulumi.set(__self__, "oss_bucket_name", oss_bucket_name)
        if oss_object_name is not None:
            pulumi.set(__self__, "oss_object_name", oss_object_name)
        if zip_file is not None:
            pulumi.set(__self__, "zip_file", zip_file)

    @property
    @pulumi.getter(name="ossBucketName")
    def oss_bucket_name(self) -> Optional[str]:
        """
        The OSS bucket name of the function code package.
        """
        return pulumi.get(self, "oss_bucket_name")

    @property
    @pulumi.getter(name="ossObjectName")
    def oss_object_name(self) -> Optional[str]:
        """
        The OSS object name of the function code package.
        """
        return pulumi.get(self, "oss_object_name")

    @property
    @pulumi.getter(name="zipFile")
    def zip_file(self) -> Optional[str]:
        """
        Upload the base64 encoding of the code zip package directly in the request body.
        """
        return pulumi.get(self, "zip_file")


@pulumi.output_type
class V2FunctionCustomContainerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accelerationType":
            suggest = "acceleration_type"
        elif key == "webServerMode":
            suggest = "web_server_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2FunctionCustomContainerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2FunctionCustomContainerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2FunctionCustomContainerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 acceleration_type: Optional[str] = None,
                 args: Optional[str] = None,
                 command: Optional[str] = None,
                 image: Optional[str] = None,
                 web_server_mode: Optional[bool] = None):
        """
        :param str acceleration_type: Image acceleration type. The value Default is to enable acceleration and None is to disable acceleration.
        :param str args: Container startup parameters.
        :param str command: Container start command, equivalent to Docker ENTRYPOINT.
        :param str image: Container Image address. Example value: registry-vpc.cn-hangzhou.aliyuncs.com/fc-demo/helloworld:v1beta1.
        :param bool web_server_mode: Whether the image is run in Web Server mode. The value of true needs to implement the Web Server in the container image to listen to the port and process the request. The value of false needs to actively exit the process after the container runs, and the ExitCode needs to be 0. Default true.
        """
        if acceleration_type is not None:
            pulumi.set(__self__, "acceleration_type", acceleration_type)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if command is not None:
            pulumi.set(__self__, "command", command)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if web_server_mode is not None:
            pulumi.set(__self__, "web_server_mode", web_server_mode)

    @property
    @pulumi.getter(name="accelerationType")
    def acceleration_type(self) -> Optional[str]:
        """
        Image acceleration type. The value Default is to enable acceleration and None is to disable acceleration.
        """
        return pulumi.get(self, "acceleration_type")

    @property
    @pulumi.getter
    def args(self) -> Optional[str]:
        """
        Container startup parameters.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Optional[str]:
        """
        Container start command, equivalent to Docker ENTRYPOINT.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def image(self) -> Optional[str]:
        """
        Container Image address. Example value: registry-vpc.cn-hangzhou.aliyuncs.com/fc-demo/helloworld:v1beta1.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="webServerMode")
    def web_server_mode(self) -> Optional[bool]:
        """
        Whether the image is run in Web Server mode. The value of true needs to implement the Web Server in the container image to listen to the port and process the request. The value of false needs to actively exit the process after the container runs, and the ExitCode needs to be 0. Default true.
        """
        return pulumi.get(self, "web_server_mode")


@pulumi.output_type
class V2FunctionCustomDns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsOptions":
            suggest = "dns_options"
        elif key == "nameServers":
            suggest = "name_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2FunctionCustomDns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2FunctionCustomDns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2FunctionCustomDns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_options: Optional[Sequence['outputs.V2FunctionCustomDnsDnsOption']] = None,
                 name_servers: Optional[Sequence[str]] = None,
                 searches: Optional[Sequence[str]] = None):
        """
        :param Sequence['V2FunctionCustomDnsDnsOptionArgs'] dns_options: DNS resolver configuration parameter list. See `dns_options` below.
        :param Sequence[str] name_servers: List of IP addresses of DNS servers.
        :param Sequence[str] searches: List of DNS search domains.
        """
        if dns_options is not None:
            pulumi.set(__self__, "dns_options", dns_options)
        if name_servers is not None:
            pulumi.set(__self__, "name_servers", name_servers)
        if searches is not None:
            pulumi.set(__self__, "searches", searches)

    @property
    @pulumi.getter(name="dnsOptions")
    def dns_options(self) -> Optional[Sequence['outputs.V2FunctionCustomDnsDnsOption']]:
        """
        DNS resolver configuration parameter list. See `dns_options` below.
        """
        return pulumi.get(self, "dns_options")

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[Sequence[str]]:
        """
        List of IP addresses of DNS servers.
        """
        return pulumi.get(self, "name_servers")

    @property
    @pulumi.getter
    def searches(self) -> Optional[Sequence[str]]:
        """
        List of DNS search domains.
        """
        return pulumi.get(self, "searches")


@pulumi.output_type
class V2FunctionCustomDnsDnsOption(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str name: DNS option name.
        :param str value: DNS option value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        DNS option name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        DNS option value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class V2FunctionCustomHealthCheckConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpGetUrl":
            suggest = "http_get_url"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2FunctionCustomHealthCheckConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2FunctionCustomHealthCheckConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2FunctionCustomHealthCheckConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 http_get_url: Optional[str] = None,
                 initial_delay_seconds: Optional[int] = None,
                 period_seconds: Optional[int] = None,
                 success_threshold: Optional[int] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param int failure_threshold: The threshold for the number of health check failures. The system considers the check failed after the health check fails.
        :param str http_get_url: Container custom health check URL address.
        :param int initial_delay_seconds: Delay from container startup to initiation of health check.
        :param int period_seconds: Health check cycle.
        :param int success_threshold: The threshold for the number of successful health checks. After the health check is reached, the system considers the check successful.
        :param int timeout_seconds: Health check timeout.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_get_url is not None:
            pulumi.set(__self__, "http_get_url", http_get_url)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        The threshold for the number of health check failures. The system considers the check failed after the health check fails.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="httpGetUrl")
    def http_get_url(self) -> Optional[str]:
        """
        Container custom health check URL address.
        """
        return pulumi.get(self, "http_get_url")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[int]:
        """
        Delay from container startup to initiation of health check.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[int]:
        """
        Health check cycle.
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[int]:
        """
        The threshold for the number of successful health checks. After the health check is reached, the system considers the check successful.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        Health check timeout.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class V2FunctionCustomRuntimeConfig(dict):
    def __init__(__self__, *,
                 args: Optional[Sequence[str]] = None,
                 commands: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] args: Parameters received by the start entry command.
        :param Sequence[str] commands: List of Custom entry commands started by Custom Runtime. When there are multiple commands in the list, they are spliced in sequence.
        """
        if args is not None:
            pulumi.set(__self__, "args", args)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)

    @property
    @pulumi.getter
    def args(self) -> Optional[Sequence[str]]:
        """
        Parameters received by the start entry command.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        List of Custom entry commands started by Custom Runtime. When there are multiple commands in the list, they are spliced in sequence.
        """
        return pulumi.get(self, "commands")


@pulumi.output_type
class V2FunctionInstanceLifecycleConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preFreeze":
            suggest = "pre_freeze"
        elif key == "preStop":
            suggest = "pre_stop"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in V2FunctionInstanceLifecycleConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        V2FunctionInstanceLifecycleConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        V2FunctionInstanceLifecycleConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pre_freeze: Optional['outputs.V2FunctionInstanceLifecycleConfigPreFreeze'] = None,
                 pre_stop: Optional['outputs.V2FunctionInstanceLifecycleConfigPreStop'] = None):
        """
        :param 'V2FunctionInstanceLifecycleConfigPreFreezeArgs' pre_freeze: PreFreeze function configuration. See `pre_freeze` below.
        :param 'V2FunctionInstanceLifecycleConfigPreStopArgs' pre_stop: PreStop function configuration. See `pre_stop` below.
        """
        if pre_freeze is not None:
            pulumi.set(__self__, "pre_freeze", pre_freeze)
        if pre_stop is not None:
            pulumi.set(__self__, "pre_stop", pre_stop)

    @property
    @pulumi.getter(name="preFreeze")
    def pre_freeze(self) -> Optional['outputs.V2FunctionInstanceLifecycleConfigPreFreeze']:
        """
        PreFreeze function configuration. See `pre_freeze` below.
        """
        return pulumi.get(self, "pre_freeze")

    @property
    @pulumi.getter(name="preStop")
    def pre_stop(self) -> Optional['outputs.V2FunctionInstanceLifecycleConfigPreStop']:
        """
        PreStop function configuration. See `pre_stop` below.
        """
        return pulumi.get(self, "pre_stop")


@pulumi.output_type
class V2FunctionInstanceLifecycleConfigPreFreeze(dict):
    def __init__(__self__, *,
                 handler: Optional[str] = None,
                 timeout: Optional[int] = None):
        """
        :param str handler: entry point of function.
        :param int timeout: max running time of function.
        """
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def handler(self) -> Optional[str]:
        """
        entry point of function.
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        max running time of function.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class V2FunctionInstanceLifecycleConfigPreStop(dict):
    def __init__(__self__, *,
                 handler: Optional[str] = None,
                 timeout: Optional[int] = None):
        """
        :param str handler: entry point of function.
        :param int timeout: max running time of function.
        """
        if handler is not None:
            pulumi.set(__self__, "handler", handler)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def handler(self) -> Optional[str]:
        """
        entry point of function.
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        max running time of function.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class GetCustomDomainsDomainResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 api_version: str,
                 cert_config: 'outputs.GetCustomDomainsDomainCertConfigResult',
                 created_time: str,
                 domain_name: str,
                 id: str,
                 last_modified_time: str,
                 protocol: str,
                 route_configs: Sequence['outputs.GetCustomDomainsDomainRouteConfigResult']):
        """
        :param str account_id: The account id.
        :param str api_version: The API version of the Function Compute service.
        :param 'GetCustomDomainsDomainCertConfigArgs' cert_config: The configuration of HTTPS certificate.
        :param str created_time: The created time of the custom domain.
        :param str domain_name: The custom domain name.
        :param str id: The custom domain id, same as domain name.
        :param str last_modified_time: The last modified time of the custom domain.
        :param str protocol: The custom domain protocol.
        :param Sequence['GetCustomDomainsDomainRouteConfigArgs'] route_configs: The configuration of domain route, mapping the path and Function Compute function.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "api_version", api_version)
        pulumi.set(__self__, "cert_config", cert_config)
        pulumi.set(__self__, "created_time", created_time)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "last_modified_time", last_modified_time)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "route_configs", route_configs)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The account id.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> str:
        """
        The API version of the Function Compute service.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter(name="certConfig")
    def cert_config(self) -> 'outputs.GetCustomDomainsDomainCertConfigResult':
        """
        The configuration of HTTPS certificate.
        """
        return pulumi.get(self, "cert_config")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> str:
        """
        The created time of the custom domain.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The custom domain name.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The custom domain id, same as domain name.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> str:
        """
        The last modified time of the custom domain.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The custom domain protocol.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="routeConfigs")
    def route_configs(self) -> Sequence['outputs.GetCustomDomainsDomainRouteConfigResult']:
        """
        The configuration of domain route, mapping the path and Function Compute function.
        """
        return pulumi.get(self, "route_configs")


@pulumi.output_type
class GetCustomDomainsDomainCertConfigResult(dict):
    def __init__(__self__, *,
                 cert_name: str,
                 certificate: str):
        """
        :param str cert_name: The name of the certificate.
        :param str certificate: Certificate data of the HTTPS certificates, follow the 'pem'.
        """
        pulumi.set(__self__, "cert_name", cert_name)
        pulumi.set(__self__, "certificate", certificate)

    @property
    @pulumi.getter(name="certName")
    def cert_name(self) -> str:
        """
        The name of the certificate.
        """
        return pulumi.get(self, "cert_name")

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        Certificate data of the HTTPS certificates, follow the 'pem'.
        """
        return pulumi.get(self, "certificate")


@pulumi.output_type
class GetCustomDomainsDomainRouteConfigResult(dict):
    def __init__(__self__, *,
                 function_name: str,
                 methods: Sequence[str],
                 path: str,
                 qualifier: str,
                 service_name: str):
        """
        :param str function_name: The name of the Function Compute function that requests are routed to.
        :param Sequence[str] methods: The requests of the specified HTTP methos are routed from. Valid method: GET, POST, DELETE, HEAD, PUT and PATCH. For example, "GET, HEAD" methods indicate that only requests from GET and HEAD methods are routed.
        :param str path: The path that requests are routed from.
        :param str qualifier: The version or alias of the Function Compute service that requests are routed to. For example, qualifier v1 indicates that the requests are routed to the version 1 Function Compute service.
        :param str service_name: The name of the Function Compute service that requests are routed to.
        """
        pulumi.set(__self__, "function_name", function_name)
        pulumi.set(__self__, "methods", methods)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "qualifier", qualifier)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="functionName")
    def function_name(self) -> str:
        """
        The name of the Function Compute function that requests are routed to.
        """
        return pulumi.get(self, "function_name")

    @property
    @pulumi.getter
    def methods(self) -> Sequence[str]:
        """
        The requests of the specified HTTP methos are routed from. Valid method: GET, POST, DELETE, HEAD, PUT and PATCH. For example, "GET, HEAD" methods indicate that only requests from GET and HEAD methods are routed.
        """
        return pulumi.get(self, "methods")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path that requests are routed from.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def qualifier(self) -> str:
        """
        The version or alias of the Function Compute service that requests are routed to. For example, qualifier v1 indicates that the requests are routed to the version 1 Function Compute service.
        """
        return pulumi.get(self, "qualifier")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        The name of the Function Compute service that requests are routed to.
        """
        return pulumi.get(self, "service_name")


@pulumi.output_type
class GetFunctionsFunctionResult(dict):
    def __init__(__self__, *,
                 ca_port: int,
                 code_checksum: str,
                 code_size: int,
                 creation_time: str,
                 description: str,
                 environment_variables: Mapping[str, Any],
                 handler: str,
                 id: str,
                 initialization_timeout: int,
                 initializer: str,
                 instance_concurrency: int,
                 instance_type: str,
                 last_modification_time: str,
                 memory_size: int,
                 name: str,
                 runtime: str,
                 timeout: int,
                 custom_container_config: Optional['outputs.GetFunctionsFunctionCustomContainerConfigResult'] = None):
        """
        :param int ca_port: The port that the function listen to, only valid for [custom runtime](https://www.alibabacloud.com/help/doc-detail/132044.htm) and [custom container runtime](https://www.alibabacloud.com/help/doc-detail/179368.htm).
        :param str code_checksum: Checksum (crc64) of the function code.
        :param int code_size: Function code size in bytes.
        :param str creation_time: Function creation time.
        :param str description: Function description.
        :param Mapping[str, Any] environment_variables: A map that defines environment variables for the function.
        :param str handler: Function [entry point](https://www.alibabacloud.com/help/doc-detail/62213.htm) in the code.
        :param str id: Function ID.
        :param int initialization_timeout: The maximum length of time, in seconds, that the function's initialization should be run for.
        :param str initializer: The entry point of the function's [initialization](https://www.alibabacloud.com/help/doc-detail/157704.htm).
        :param int instance_concurrency: The maximum number of requests can be executed concurrently within the single function instance.
        :param str instance_type: The instance type of the function.
        :param str last_modification_time: Function last modification time.
        :param int memory_size: Amount of memory in MB the function can use at runtime.
        :param str name: Function name.
        :param str runtime: Function runtime. The list of possible values is [available here](https://www.alibabacloud.com/help/doc-detail/52077.htm).
        :param int timeout: Maximum amount of time the function can run in seconds.
        :param 'GetFunctionsFunctionCustomContainerConfigArgs' custom_container_config: The configuration for custom container runtime. It contains following attributes:
        """
        pulumi.set(__self__, "ca_port", ca_port)
        pulumi.set(__self__, "code_checksum", code_checksum)
        pulumi.set(__self__, "code_size", code_size)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "environment_variables", environment_variables)
        pulumi.set(__self__, "handler", handler)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "initialization_timeout", initialization_timeout)
        pulumi.set(__self__, "initializer", initializer)
        pulumi.set(__self__, "instance_concurrency", instance_concurrency)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "last_modification_time", last_modification_time)
        pulumi.set(__self__, "memory_size", memory_size)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "runtime", runtime)
        pulumi.set(__self__, "timeout", timeout)
        if custom_container_config is not None:
            pulumi.set(__self__, "custom_container_config", custom_container_config)

    @property
    @pulumi.getter(name="caPort")
    def ca_port(self) -> int:
        """
        The port that the function listen to, only valid for [custom runtime](https://www.alibabacloud.com/help/doc-detail/132044.htm) and [custom container runtime](https://www.alibabacloud.com/help/doc-detail/179368.htm).
        """
        return pulumi.get(self, "ca_port")

    @property
    @pulumi.getter(name="codeChecksum")
    def code_checksum(self) -> str:
        """
        Checksum (crc64) of the function code.
        """
        return pulumi.get(self, "code_checksum")

    @property
    @pulumi.getter(name="codeSize")
    def code_size(self) -> int:
        """
        Function code size in bytes.
        """
        return pulumi.get(self, "code_size")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        Function creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Function description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Mapping[str, Any]:
        """
        A map that defines environment variables for the function.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter
    def handler(self) -> str:
        """
        Function [entry point](https://www.alibabacloud.com/help/doc-detail/62213.htm) in the code.
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Function ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="initializationTimeout")
    def initialization_timeout(self) -> int:
        """
        The maximum length of time, in seconds, that the function's initialization should be run for.
        """
        return pulumi.get(self, "initialization_timeout")

    @property
    @pulumi.getter
    def initializer(self) -> str:
        """
        The entry point of the function's [initialization](https://www.alibabacloud.com/help/doc-detail/157704.htm).
        """
        return pulumi.get(self, "initializer")

    @property
    @pulumi.getter(name="instanceConcurrency")
    def instance_concurrency(self) -> int:
        """
        The maximum number of requests can be executed concurrently within the single function instance.
        """
        return pulumi.get(self, "instance_concurrency")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The instance type of the function.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="lastModificationTime")
    def last_modification_time(self) -> str:
        """
        Function last modification time.
        """
        return pulumi.get(self, "last_modification_time")

    @property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> int:
        """
        Amount of memory in MB the function can use at runtime.
        """
        return pulumi.get(self, "memory_size")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Function name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def runtime(self) -> str:
        """
        Function runtime. The list of possible values is [available here](https://www.alibabacloud.com/help/doc-detail/52077.htm).
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter
    def timeout(self) -> int:
        """
        Maximum amount of time the function can run in seconds.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="customContainerConfig")
    def custom_container_config(self) -> Optional['outputs.GetFunctionsFunctionCustomContainerConfigResult']:
        """
        The configuration for custom container runtime. It contains following attributes:
        """
        return pulumi.get(self, "custom_container_config")


@pulumi.output_type
class GetFunctionsFunctionCustomContainerConfigResult(dict):
    def __init__(__self__, *,
                 args: str,
                 command: str,
                 image: str):
        """
        :param str args: The args field specifies the arguments passed to the command.
        :param str command: The entry point of the container, which specifies the actual command run by the container.
        :param str image: The container image address.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter
    def args(self) -> str:
        """
        The args field specifies the arguments passed to the command.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> str:
        """
        The entry point of the container, which specifies the actual command run by the container.
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The container image address.
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class GetServicesServiceResult(dict):
    def __init__(__self__, *,
                 creation_time: str,
                 description: str,
                 id: str,
                 internet_access: bool,
                 last_modification_time: str,
                 log_config: 'outputs.GetServicesServiceLogConfigResult',
                 name: str,
                 nas_config: 'outputs.GetServicesServiceNasConfigResult',
                 role: str,
                 vpc_config: 'outputs.GetServicesServiceVpcConfigResult'):
        """
        :param str creation_time: FC service creation time.
        :param str description: FC service description.
        :param str id: FC service ID.
        :param bool internet_access: Indicate whether the service can access to internet or not.
        :param str last_modification_time: FC service last modification time.
        :param 'GetServicesServiceLogConfigArgs' log_config: A list of one element containing information about the associated log store. It contains the following attributes:
        :param str name: FC service name.
        :param 'GetServicesServiceNasConfigArgs' nas_config: A list of one element about the nas configuration.
        :param str role: FC service role ARN.
        :param 'GetServicesServiceVpcConfigArgs' vpc_config: A list of one element containing information about accessible VPC resources. It contains the following attributes:
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "internet_access", internet_access)
        pulumi.set(__self__, "last_modification_time", last_modification_time)
        pulumi.set(__self__, "log_config", log_config)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nas_config", nas_config)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "vpc_config", vpc_config)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        FC service creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        FC service description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        FC service ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internetAccess")
    def internet_access(self) -> bool:
        """
        Indicate whether the service can access to internet or not.
        """
        return pulumi.get(self, "internet_access")

    @property
    @pulumi.getter(name="lastModificationTime")
    def last_modification_time(self) -> str:
        """
        FC service last modification time.
        """
        return pulumi.get(self, "last_modification_time")

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> 'outputs.GetServicesServiceLogConfigResult':
        """
        A list of one element containing information about the associated log store. It contains the following attributes:
        """
        return pulumi.get(self, "log_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        FC service name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nasConfig")
    def nas_config(self) -> 'outputs.GetServicesServiceNasConfigResult':
        """
        A list of one element about the nas configuration.
        """
        return pulumi.get(self, "nas_config")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        FC service role ARN.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="vpcConfig")
    def vpc_config(self) -> 'outputs.GetServicesServiceVpcConfigResult':
        """
        A list of one element containing information about accessible VPC resources. It contains the following attributes:
        """
        return pulumi.get(self, "vpc_config")


@pulumi.output_type
class GetServicesServiceLogConfigResult(dict):
    def __init__(__self__, *,
                 logstore: str,
                 project: str):
        """
        :param str logstore: Log Service store name.
        :param str project: Log Service project name.
        """
        pulumi.set(__self__, "logstore", logstore)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def logstore(self) -> str:
        """
        Log Service store name.
        """
        return pulumi.get(self, "logstore")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Log Service project name.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GetServicesServiceNasConfigResult(dict):
    def __init__(__self__, *,
                 group_id: int,
                 mount_points: Sequence['outputs.GetServicesServiceNasConfigMountPointResult'],
                 user_id: int):
        """
        :param int group_id: The group id of the NAS file system.
        :param Sequence['GetServicesServiceNasConfigMountPointArgs'] mount_points: The mount points configuration, including following attributes:
        :param int user_id: The user id of the NAS file system.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "mount_points", mount_points)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> int:
        """
        The group id of the NAS file system.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="mountPoints")
    def mount_points(self) -> Sequence['outputs.GetServicesServiceNasConfigMountPointResult']:
        """
        The mount points configuration, including following attributes:
        """
        return pulumi.get(self, "mount_points")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> int:
        """
        The user id of the NAS file system.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetServicesServiceNasConfigMountPointResult(dict):
    def __init__(__self__, *,
                 mount_dir: str,
                 server_addr: str):
        """
        :param str mount_dir: The local address where to mount your remote NAS directory.
        :param str server_addr: The address of the remote NAS directory.
        """
        pulumi.set(__self__, "mount_dir", mount_dir)
        pulumi.set(__self__, "server_addr", server_addr)

    @property
    @pulumi.getter(name="mountDir")
    def mount_dir(self) -> str:
        """
        The local address where to mount your remote NAS directory.
        """
        return pulumi.get(self, "mount_dir")

    @property
    @pulumi.getter(name="serverAddr")
    def server_addr(self) -> str:
        """
        The address of the remote NAS directory.
        """
        return pulumi.get(self, "server_addr")


@pulumi.output_type
class GetServicesServiceVpcConfigResult(dict):
    def __init__(__self__, *,
                 security_group_id: str,
                 vpc_id: str,
                 vswitch_ids: Sequence[str]):
        """
        :param str security_group_id: Associated security group ID.
        :param str vpc_id: Associated VPC ID.
        :param Sequence[str] vswitch_ids: Associated VSwitch IDs.
        """
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "vswitch_ids", vswitch_ids)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        Associated security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Associated VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vswitchIds")
    def vswitch_ids(self) -> Sequence[str]:
        """
        Associated VSwitch IDs.
        """
        return pulumi.get(self, "vswitch_ids")


@pulumi.output_type
class GetTriggersTriggerResult(dict):
    def __init__(__self__, *,
                 config: str,
                 creation_time: str,
                 id: str,
                 invocation_role: str,
                 last_modification_time: str,
                 name: str,
                 source_arn: str,
                 type: str):
        """
        :param str config: JSON-encoded trigger configuration. See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        :param str creation_time: FC trigger creation time.
        :param str id: FC trigger ID.
        :param str invocation_role: RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param str last_modification_time: FC trigger last modification time.
        :param str name: FC trigger name.
        :param str source_arn: Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param str type: Type of the trigger. Valid values: `oss`, `log`, `timer`, `http`, `mns_topic`, `cdn_events` and `eventbridge`.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "invocation_role", invocation_role)
        pulumi.set(__self__, "last_modification_time", last_modification_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source_arn", source_arn)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def config(self) -> str:
        """
        JSON-encoded trigger configuration. See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        FC trigger creation time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        FC trigger ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="invocationRole")
    def invocation_role(self) -> str:
        """
        RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        return pulumi.get(self, "invocation_role")

    @property
    @pulumi.getter(name="lastModificationTime")
    def last_modification_time(self) -> str:
        """
        FC trigger last modification time.
        """
        return pulumi.get(self, "last_modification_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        FC trigger name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> str:
        """
        Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of the trigger. Valid values: `oss`, `log`, `timer`, `http`, `mns_topic`, `cdn_events` and `eventbridge`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetZonesZoneResult(dict):
    def __init__(__self__, *,
                 id: str):
        """
        :param str id: ID of the zone.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        ID of the zone.
        """
        return pulumi.get(self, "id")


