# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TriggerArgs', 'Trigger']

@pulumi.input_type
class TriggerArgs:
    def __init__(__self__, *,
                 function: pulumi.Input[str],
                 service: pulumi.Input[str],
                 type: pulumi.Input[str],
                 config: Optional[pulumi.Input[str]] = None,
                 config_mns: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Trigger resource.
        :param pulumi.Input[str] function: The Function Compute function name.
        :param pulumi.Input[str] service: The Function Compute service name.
        :param pulumi.Input[str] type: The Type of the trigger. Valid values: ["oss", "log", "timer", "http", "mns_topic", "cdn_events", "eventbridge"].
               
               > **NOTE:** Config does not support modification when type is mns_topic.
               > **NOTE:** type = cdn_events, available in 1.47.0+.
               > **NOTE:** type = eventbridge, available in 1.173.0+.
        :param pulumi.Input[str] config: The config of Function Compute trigger.It is valid when `type` is not "mns_topic".See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        :param pulumi.Input[str] config_mns: The config of Function Compute trigger when the type is "mns_topic".It is conflict with `config`.
        :param pulumi.Input[str] name: The Function Compute trigger name. It is the only in one service and is conflict with "name_prefix".
        :param pulumi.Input[str] name_prefix: Setting a prefix to get a only trigger name. It is conflict with "name".
        :param pulumi.Input[str] role: RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param pulumi.Input[str] source_arn: Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        pulumi.set(__self__, "function", function)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "type", type)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if config_mns is not None:
            pulumi.set(__self__, "config_mns", config_mns)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)

    @property
    @pulumi.getter
    def function(self) -> pulumi.Input[str]:
        """
        The Function Compute function name.
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: pulumi.Input[str]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        The Function Compute service name.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The Type of the trigger. Valid values: ["oss", "log", "timer", "http", "mns_topic", "cdn_events", "eventbridge"].

        > **NOTE:** Config does not support modification when type is mns_topic.
        > **NOTE:** type = cdn_events, available in 1.47.0+.
        > **NOTE:** type = eventbridge, available in 1.173.0+.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[str]]:
        """
        The config of Function Compute trigger.It is valid when `type` is not "mns_topic".See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="configMns")
    def config_mns(self) -> Optional[pulumi.Input[str]]:
        """
        The config of Function Compute trigger when the type is "mns_topic".It is conflict with `config`.
        """
        return pulumi.get(self, "config_mns")

    @config_mns.setter
    def config_mns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_mns", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The Function Compute trigger name. It is the only in one service and is conflict with "name_prefix".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Setting a prefix to get a only trigger name. It is conflict with "name".
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_arn", value)


@pulumi.input_type
class _TriggerState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[str]] = None,
                 config_mns: Optional[pulumi.Input[str]] = None,
                 function: Optional[pulumi.Input[str]] = None,
                 last_modified: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 trigger_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Trigger resources.
        :param pulumi.Input[str] config: The config of Function Compute trigger.It is valid when `type` is not "mns_topic".See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        :param pulumi.Input[str] config_mns: The config of Function Compute trigger when the type is "mns_topic".It is conflict with `config`.
        :param pulumi.Input[str] function: The Function Compute function name.
        :param pulumi.Input[str] last_modified: The date this resource was last modified.
        :param pulumi.Input[str] name: The Function Compute trigger name. It is the only in one service and is conflict with "name_prefix".
        :param pulumi.Input[str] name_prefix: Setting a prefix to get a only trigger name. It is conflict with "name".
        :param pulumi.Input[str] role: RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param pulumi.Input[str] service: The Function Compute service name.
        :param pulumi.Input[str] source_arn: Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param pulumi.Input[str] trigger_id: The Function Compute trigger ID.
        :param pulumi.Input[str] type: The Type of the trigger. Valid values: ["oss", "log", "timer", "http", "mns_topic", "cdn_events", "eventbridge"].
               
               > **NOTE:** Config does not support modification when type is mns_topic.
               > **NOTE:** type = cdn_events, available in 1.47.0+.
               > **NOTE:** type = eventbridge, available in 1.173.0+.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if config_mns is not None:
            pulumi.set(__self__, "config_mns", config_mns)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if last_modified is not None:
            pulumi.set(__self__, "last_modified", last_modified)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_prefix is not None:
            pulumi.set(__self__, "name_prefix", name_prefix)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if source_arn is not None:
            pulumi.set(__self__, "source_arn", source_arn)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[str]]:
        """
        The config of Function Compute trigger.It is valid when `type` is not "mns_topic".See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="configMns")
    def config_mns(self) -> Optional[pulumi.Input[str]]:
        """
        The config of Function Compute trigger when the type is "mns_topic".It is conflict with `config`.
        """
        return pulumi.get(self, "config_mns")

    @config_mns.setter
    def config_mns(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_mns", value)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[str]]:
        """
        The Function Compute function name.
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> Optional[pulumi.Input[str]]:
        """
        The date this resource was last modified.
        """
        return pulumi.get(self, "last_modified")

    @last_modified.setter
    def last_modified(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_modified", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The Function Compute trigger name. It is the only in one service and is conflict with "name_prefix".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Setting a prefix to get a only trigger name. It is conflict with "name".
        """
        return pulumi.get(self, "name_prefix")

    @name_prefix.setter
    def name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_prefix", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        The Function Compute service name.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> Optional[pulumi.Input[str]]:
        """
        Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        return pulumi.get(self, "source_arn")

    @source_arn.setter
    def source_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_arn", value)

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Function Compute trigger ID.
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The Type of the trigger. Valid values: ["oss", "log", "timer", "http", "mns_topic", "cdn_events", "eventbridge"].

        > **NOTE:** Config does not support modification when type is mns_topic.
        > **NOTE:** type = cdn_events, available in 1.47.0+.
        > **NOTE:** type = eventbridge, available in 1.173.0+.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Trigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[str]] = None,
                 config_mns: Optional[pulumi.Input[str]] = None,
                 function: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides an Alicloud Function Compute Trigger resource. Based on trigger, execute your code in response to events in Alibaba Cloud.
         For information about Service and how to use it, see [What is Function Compute](https://www.alibabacloud.com/help/en/fc/developer-reference/api-fc-open-2021-04-06-createtrigger).

        > **NOTE:** The resource requires a provider field 'account_id'. See account_id.

        > **NOTE:** Available since v1.93.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_account = alicloud.get_account()
        default_regions = alicloud.get_regions(current=True)
        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_project = alicloud.log.Project("defaultProject")
        default_store = alicloud.log.Store("defaultStore", project=default_project.name)
        source_store = alicloud.log.Store("sourceStore", project=default_project.name)
        default_role = alicloud.ram.Role("defaultRole",
            document=\"\"\"  {
              "Statement": [
                {
                  "Action": "sts:AssumeRole",
                  "Effect": "Allow",
                  "Principal": {
                    "Service": [
                      "fc.aliyuncs.com"
                    ]
                  }
                }
              ],
              "Version": "1"
          }
        \"\"\",
            description="this is a example",
            force=True)
        default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("defaultRolePolicyAttachment",
            role_name=default_role.name,
            policy_name="AliyunLogFullAccess",
            policy_type="System")
        default_service = alicloud.fc.Service("defaultService",
            description="example-value",
            role=default_role.arn,
            log_config=alicloud.fc.ServiceLogConfigArgs(
                project=default_project.name,
                logstore=default_store.name,
                enable_instance_metrics=True,
                enable_request_metrics=True,
            ))
        default_bucket = alicloud.oss.Bucket("defaultBucket", bucket=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"))
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("defaultBucketObject",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("defaultFunction",
            service=default_service.name,
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        default_trigger = alicloud.fc.Trigger("defaultTrigger",
            service=default_service.name,
            function=default_function.name,
            role=default_role.arn,
            source_arn=default_project.name.apply(lambda name: f"acs:log:{default_regions.regions[0].id}:{default_account.id}:project/{name}"),
            type="log",
            config=pulumi.Output.all(source_store.name, default_project.name, default_store.name).apply(lambda sourceStoreName, defaultProjectName, defaultStoreName: f\"\"\"    {{
                "sourceConfig": {{
                    "logstore": "{source_store_name}",
                    "startTime": null
                }},
                "jobConfig": {{
                    "maxRetryTime": 3,
                    "triggerInterval": 60
                }},
                "functionParameter": {{
                    "a": "b",
                    "c": "d"
                }},
                "logConfig": {{
                     "project": "{default_project_name}",
                    "logstore": "{default_store_name}"
                }},
                "targetConfig": null,
                "enable": true
            }}
          
        \"\"\"))
        ```

        MNS topic trigger:

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_account = alicloud.get_account()
        default_regions = alicloud.get_regions(current=True)
        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_topic = alicloud.mns.Topic("defaultTopic")
        default_role = alicloud.ram.Role("defaultRole",
            document=\"\"\"  {
              "Statement": [
                {
                  "Action": "sts:AssumeRole",
                  "Effect": "Allow",
                  "Principal": {
                    "Service": [
                      "mns.aliyuncs.com"
                    ]
                  }
                }
              ],
              "Version": "1"
          }
        \"\"\",
            description="this is a example",
            force=True)
        default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("defaultRolePolicyAttachment",
            role_name=default_role.name,
            policy_name="AliyunMNSNotificationRolePolicy",
            policy_type="System")
        default_service = alicloud.fc.Service("defaultService",
            description="example-value",
            internet_access=False)
        default_bucket = alicloud.oss.Bucket("defaultBucket", bucket=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"))
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("defaultBucketObject",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("defaultFunction",
            service=default_service.name,
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        default_trigger = alicloud.fc.Trigger("defaultTrigger",
            service=default_service.name,
            function=default_function.name,
            role=default_role.arn,
            source_arn=default_topic.name.apply(lambda name: f"acs:mns:{default_regions.regions[0].id}:{default_account.id}:/topics/{name}"),
            type="mns_topic",
            config_mns=\"\"\"  {
            "filterTag":"exampleTag",
            "notifyContentFormat":"STREAM",
            "notifyStrategy":"BACKOFF_RETRY"
          }
        \"\"\")
        ```

        CDN events trigger:

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_account = alicloud.get_account()
        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_domain_new = alicloud.cdn.DomainNew("defaultDomainNew",
            domain_name=default_random_integer.result.apply(lambda result: f"example{result}.tf.com"),
            cdn_type="web",
            scope="overseas",
            sources=[alicloud.cdn.DomainNewSourceArgs(
                content="1.1.1.1",
                type="ipaddr",
                priority=20,
                port=80,
                weight=10,
            )])
        default_service = alicloud.fc.Service("defaultService",
            description="example-value",
            internet_access=False)
        default_role = alicloud.ram.Role("defaultRole",
            document=\"\"\"    {
              "Statement": [
                {
                  "Action": "sts:AssumeRole",
                  "Effect": "Allow",
                  "Principal": {
                    "Service": [
                      "cdn.aliyuncs.com"
                    ]
                  }
                }
              ],
              "Version": "1"
          }
        \"\"\",
            description="this is a example",
            force=True)
        default_policy = alicloud.ram.Policy("defaultPolicy",
            policy_name=default_random_integer.result.apply(lambda result: f"fcservicepolicy-{result}"),
            policy_document=pulumi.Output.all(default_service.name, default_service.name).apply(lambda defaultServiceName, defaultServiceName1: f\"\"\"    {{
                "Version": "1",
                "Statement": [
                {{
                    "Action": [
                    "fc:InvokeFunction"
                    ],
                "Resource": [
                    "acs:fc:*:*:services/{default_service_name}/functions/*",
                    "acs:fc:*:*:services/{default_service_name1}.*/functions/*"
                ],
                "Effect": "Allow"
                }}
                ]
            }}
        \"\"\"),
            description="this is a example",
            force=True)
        default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("defaultRolePolicyAttachment",
            role_name=default_role.name,
            policy_name=default_policy.name,
            policy_type="Custom")
        default_bucket = alicloud.oss.Bucket("defaultBucket", bucket=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"))
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("defaultBucketObject",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("defaultFunction",
            service=default_service.name,
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        default_trigger = alicloud.fc.Trigger("defaultTrigger",
            service=default_service.name,
            function=default_function.name,
            role=default_role.arn,
            source_arn=f"acs:cdn:*:{default_account.id}",
            type="cdn_events",
            config=default_domain_new.domain_name.apply(lambda domain_name: f\"\"\"      {{"eventName":"LogFileCreated",
             "eventVersion":"1.0.0",
             "notes":"cdn events trigger",
             "filter":{{
                "domain": ["{domain_name}"]
                }}
            }}
        \"\"\"))
        ```

        EventBridge trigger:

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_account = alicloud.get_account()
        default_regions = alicloud.get_regions(current=True)
        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        service_linked_role = alicloud.eventbridge.ServiceLinkedRole("serviceLinkedRole", product_name="AliyunServiceRoleForEventBridgeSendToFC")
        default_service = alicloud.fc.Service("defaultService",
            description="example-value",
            internet_access=False)
        default_bucket = alicloud.oss.Bucket("defaultBucket", bucket=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"))
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("defaultBucketObject",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("defaultFunction",
            service=default_service.name,
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        oss_trigger = alicloud.fc.Trigger("ossTrigger",
            service=default_service.name,
            function=default_function.name,
            type="eventbridge",
            config=\"\"\"    {
                "triggerEnable": false,
                "asyncInvocationType": false,
                "eventRuleFilterPattern": {
                  "source":[
                    "acs.oss"
                    ],
                    "type":[
                      "oss:BucketCreated:PutBucket"
                    ]
                },
                "eventSourceConfig": {
                    "eventSourceType": "Default"
                }
            }
        \"\"\")
        mns_trigger = alicloud.fc.Trigger("mnsTrigger",
            service=default_service.name,
            function=default_function.name,
            type="eventbridge",
            config=\"\"\"    {
                "triggerEnable": false,
                "asyncInvocationType": false,
                "eventRuleFilterPattern": "{}",
                "eventSourceConfig": {
                    "eventSourceType": "MNS",
                    "eventSourceParameters": {
                        "sourceMNSParameters": {
                            "RegionId": "cn-hangzhou",
                            "QueueName": "mns-queue",
                            "IsBase64Decode": true
                        }
                    }
                }
            }
        \"\"\")
        default_instance = alicloud.rocketmq.Instance("defaultInstance",
            instance_name=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"),
            remark="terraform-example")
        default_group = alicloud.rocketmq.Group("defaultGroup",
            group_name="GID-example",
            instance_id=default_instance.id,
            remark="terraform-example")
        default_topic = alicloud.rocketmq.Topic("defaultTopic",
            topic_name="mytopic",
            instance_id=default_instance.id,
            message_type=0,
            remark="terraform-example")
        rocketmq_trigger = alicloud.fc.Trigger("rocketmqTrigger",
            service=default_service.name,
            function=default_function.name,
            type="eventbridge",
            config=pulumi.Output.all(default_instance.id, default_group.group_name, default_topic.topic_name).apply(lambda id, group_name, topic_name: f\"\"\"    {{
                "triggerEnable": false,
                "asyncInvocationType": false,
                "eventRuleFilterPattern": "{{}}",
                "eventSourceConfig": {{
                    "eventSourceType": "RocketMQ",
                    "eventSourceParameters": {{
                        "sourceRocketMQParameters": {{
                            "RegionId": "{default_regions.regions[0].id}",
                            "InstanceId": "{id}",
                            "GroupID": "{group_name}",
                            "Topic": "{topic_name}",
                            "Timestamp": 1686296162,
                            "Tag": "example-tag",
                            "Offset": "CONSUME_FROM_LAST_OFFSET"
                        }}
                    }}
                }}
            }}
        \"\"\"))
        default_amqp_instance_instance = alicloud.amqp.Instance("defaultAmqp/instanceInstance",
            instance_name=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"),
            instance_type="professional",
            max_tps="1000",
            queue_capacity="50",
            support_eip=True,
            max_eip_tps="128",
            payment_type="Subscription",
            period=1)
        default_virtual_host = alicloud.amqp.VirtualHost("defaultVirtualHost",
            instance_id=default_amqp / instance_instance["id"],
            virtual_host_name="example-VirtualHost")
        default_queue = alicloud.amqp.Queue("defaultQueue",
            instance_id=default_virtual_host.instance_id,
            queue_name="example-queue",
            virtual_host_name=default_virtual_host.virtual_host_name)
        rabbitmq_trigger = alicloud.fc.Trigger("rabbitmqTrigger",
            service=default_service.name,
            function=default_function.name,
            type="eventbridge",
            config=pulumi.Output.all(default_virtual_host.virtual_host_name, default_queue.queue_name).apply(lambda virtual_host_name, queue_name: f\"\"\"    {{
                "triggerEnable": false,
                "asyncInvocationType": false,
                "eventRuleFilterPattern": "{{}}",
                "eventSourceConfig": {{
                    "eventSourceType": "RabbitMQ",
                    "eventSourceParameters": {{
                        "sourceRabbitMQParameters": {{
                            "RegionId": "{default_regions.regions[0].id}",
                            "InstanceId": "{default_amqp / instance_instance["id"]}",
                            "VirtualHostName": "{virtual_host_name}",
                            "QueueName": "{queue_name}"
                        }}
                    }}
                }}
            }}
        \"\"\"))
        ```
        ## Module Support

        You can use to the existing fc module
        to create several triggers quickly.

        ## Import

        Function Compute trigger can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:fc/trigger:Trigger foo my-fc-service:hello-world:hello-trigger
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config: The config of Function Compute trigger.It is valid when `type` is not "mns_topic".See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        :param pulumi.Input[str] config_mns: The config of Function Compute trigger when the type is "mns_topic".It is conflict with `config`.
        :param pulumi.Input[str] function: The Function Compute function name.
        :param pulumi.Input[str] name: The Function Compute trigger name. It is the only in one service and is conflict with "name_prefix".
        :param pulumi.Input[str] name_prefix: Setting a prefix to get a only trigger name. It is conflict with "name".
        :param pulumi.Input[str] role: RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param pulumi.Input[str] service: The Function Compute service name.
        :param pulumi.Input[str] source_arn: Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param pulumi.Input[str] type: The Type of the trigger. Valid values: ["oss", "log", "timer", "http", "mns_topic", "cdn_events", "eventbridge"].
               
               > **NOTE:** Config does not support modification when type is mns_topic.
               > **NOTE:** type = cdn_events, available in 1.47.0+.
               > **NOTE:** type = eventbridge, available in 1.173.0+.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TriggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an Alicloud Function Compute Trigger resource. Based on trigger, execute your code in response to events in Alibaba Cloud.
         For information about Service and how to use it, see [What is Function Compute](https://www.alibabacloud.com/help/en/fc/developer-reference/api-fc-open-2021-04-06-createtrigger).

        > **NOTE:** The resource requires a provider field 'account_id'. See account_id.

        > **NOTE:** Available since v1.93.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_account = alicloud.get_account()
        default_regions = alicloud.get_regions(current=True)
        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_project = alicloud.log.Project("defaultProject")
        default_store = alicloud.log.Store("defaultStore", project=default_project.name)
        source_store = alicloud.log.Store("sourceStore", project=default_project.name)
        default_role = alicloud.ram.Role("defaultRole",
            document=\"\"\"  {
              "Statement": [
                {
                  "Action": "sts:AssumeRole",
                  "Effect": "Allow",
                  "Principal": {
                    "Service": [
                      "fc.aliyuncs.com"
                    ]
                  }
                }
              ],
              "Version": "1"
          }
        \"\"\",
            description="this is a example",
            force=True)
        default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("defaultRolePolicyAttachment",
            role_name=default_role.name,
            policy_name="AliyunLogFullAccess",
            policy_type="System")
        default_service = alicloud.fc.Service("defaultService",
            description="example-value",
            role=default_role.arn,
            log_config=alicloud.fc.ServiceLogConfigArgs(
                project=default_project.name,
                logstore=default_store.name,
                enable_instance_metrics=True,
                enable_request_metrics=True,
            ))
        default_bucket = alicloud.oss.Bucket("defaultBucket", bucket=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"))
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("defaultBucketObject",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("defaultFunction",
            service=default_service.name,
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        default_trigger = alicloud.fc.Trigger("defaultTrigger",
            service=default_service.name,
            function=default_function.name,
            role=default_role.arn,
            source_arn=default_project.name.apply(lambda name: f"acs:log:{default_regions.regions[0].id}:{default_account.id}:project/{name}"),
            type="log",
            config=pulumi.Output.all(source_store.name, default_project.name, default_store.name).apply(lambda sourceStoreName, defaultProjectName, defaultStoreName: f\"\"\"    {{
                "sourceConfig": {{
                    "logstore": "{source_store_name}",
                    "startTime": null
                }},
                "jobConfig": {{
                    "maxRetryTime": 3,
                    "triggerInterval": 60
                }},
                "functionParameter": {{
                    "a": "b",
                    "c": "d"
                }},
                "logConfig": {{
                     "project": "{default_project_name}",
                    "logstore": "{default_store_name}"
                }},
                "targetConfig": null,
                "enable": true
            }}
          
        \"\"\"))
        ```

        MNS topic trigger:

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_account = alicloud.get_account()
        default_regions = alicloud.get_regions(current=True)
        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_topic = alicloud.mns.Topic("defaultTopic")
        default_role = alicloud.ram.Role("defaultRole",
            document=\"\"\"  {
              "Statement": [
                {
                  "Action": "sts:AssumeRole",
                  "Effect": "Allow",
                  "Principal": {
                    "Service": [
                      "mns.aliyuncs.com"
                    ]
                  }
                }
              ],
              "Version": "1"
          }
        \"\"\",
            description="this is a example",
            force=True)
        default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("defaultRolePolicyAttachment",
            role_name=default_role.name,
            policy_name="AliyunMNSNotificationRolePolicy",
            policy_type="System")
        default_service = alicloud.fc.Service("defaultService",
            description="example-value",
            internet_access=False)
        default_bucket = alicloud.oss.Bucket("defaultBucket", bucket=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"))
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("defaultBucketObject",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("defaultFunction",
            service=default_service.name,
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        default_trigger = alicloud.fc.Trigger("defaultTrigger",
            service=default_service.name,
            function=default_function.name,
            role=default_role.arn,
            source_arn=default_topic.name.apply(lambda name: f"acs:mns:{default_regions.regions[0].id}:{default_account.id}:/topics/{name}"),
            type="mns_topic",
            config_mns=\"\"\"  {
            "filterTag":"exampleTag",
            "notifyContentFormat":"STREAM",
            "notifyStrategy":"BACKOFF_RETRY"
          }
        \"\"\")
        ```

        CDN events trigger:

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_account = alicloud.get_account()
        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_domain_new = alicloud.cdn.DomainNew("defaultDomainNew",
            domain_name=default_random_integer.result.apply(lambda result: f"example{result}.tf.com"),
            cdn_type="web",
            scope="overseas",
            sources=[alicloud.cdn.DomainNewSourceArgs(
                content="1.1.1.1",
                type="ipaddr",
                priority=20,
                port=80,
                weight=10,
            )])
        default_service = alicloud.fc.Service("defaultService",
            description="example-value",
            internet_access=False)
        default_role = alicloud.ram.Role("defaultRole",
            document=\"\"\"    {
              "Statement": [
                {
                  "Action": "sts:AssumeRole",
                  "Effect": "Allow",
                  "Principal": {
                    "Service": [
                      "cdn.aliyuncs.com"
                    ]
                  }
                }
              ],
              "Version": "1"
          }
        \"\"\",
            description="this is a example",
            force=True)
        default_policy = alicloud.ram.Policy("defaultPolicy",
            policy_name=default_random_integer.result.apply(lambda result: f"fcservicepolicy-{result}"),
            policy_document=pulumi.Output.all(default_service.name, default_service.name).apply(lambda defaultServiceName, defaultServiceName1: f\"\"\"    {{
                "Version": "1",
                "Statement": [
                {{
                    "Action": [
                    "fc:InvokeFunction"
                    ],
                "Resource": [
                    "acs:fc:*:*:services/{default_service_name}/functions/*",
                    "acs:fc:*:*:services/{default_service_name1}.*/functions/*"
                ],
                "Effect": "Allow"
                }}
                ]
            }}
        \"\"\"),
            description="this is a example",
            force=True)
        default_role_policy_attachment = alicloud.ram.RolePolicyAttachment("defaultRolePolicyAttachment",
            role_name=default_role.name,
            policy_name=default_policy.name,
            policy_type="Custom")
        default_bucket = alicloud.oss.Bucket("defaultBucket", bucket=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"))
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("defaultBucketObject",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("defaultFunction",
            service=default_service.name,
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        default_trigger = alicloud.fc.Trigger("defaultTrigger",
            service=default_service.name,
            function=default_function.name,
            role=default_role.arn,
            source_arn=f"acs:cdn:*:{default_account.id}",
            type="cdn_events",
            config=default_domain_new.domain_name.apply(lambda domain_name: f\"\"\"      {{"eventName":"LogFileCreated",
             "eventVersion":"1.0.0",
             "notes":"cdn events trigger",
             "filter":{{
                "domain": ["{domain_name}"]
                }}
            }}
        \"\"\"))
        ```

        EventBridge trigger:

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_account = alicloud.get_account()
        default_regions = alicloud.get_regions(current=True)
        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        service_linked_role = alicloud.eventbridge.ServiceLinkedRole("serviceLinkedRole", product_name="AliyunServiceRoleForEventBridgeSendToFC")
        default_service = alicloud.fc.Service("defaultService",
            description="example-value",
            internet_access=False)
        default_bucket = alicloud.oss.Bucket("defaultBucket", bucket=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"))
        # If you upload the function by OSS Bucket, you need to specify path can't upload by content.
        default_bucket_object = alicloud.oss.BucketObject("defaultBucketObject",
            bucket=default_bucket.id,
            key="index.py",
            content=\"\"\"import logging 
        def handler(event, context): 
        logger = logging.getLogger() 
        logger.info('hello world') 
        return 'hello world'\"\"\")
        default_function = alicloud.fc.Function("defaultFunction",
            service=default_service.name,
            description="example",
            oss_bucket=default_bucket.id,
            oss_key=default_bucket_object.key,
            memory_size=512,
            runtime="python3.10",
            handler="hello.handler")
        oss_trigger = alicloud.fc.Trigger("ossTrigger",
            service=default_service.name,
            function=default_function.name,
            type="eventbridge",
            config=\"\"\"    {
                "triggerEnable": false,
                "asyncInvocationType": false,
                "eventRuleFilterPattern": {
                  "source":[
                    "acs.oss"
                    ],
                    "type":[
                      "oss:BucketCreated:PutBucket"
                    ]
                },
                "eventSourceConfig": {
                    "eventSourceType": "Default"
                }
            }
        \"\"\")
        mns_trigger = alicloud.fc.Trigger("mnsTrigger",
            service=default_service.name,
            function=default_function.name,
            type="eventbridge",
            config=\"\"\"    {
                "triggerEnable": false,
                "asyncInvocationType": false,
                "eventRuleFilterPattern": "{}",
                "eventSourceConfig": {
                    "eventSourceType": "MNS",
                    "eventSourceParameters": {
                        "sourceMNSParameters": {
                            "RegionId": "cn-hangzhou",
                            "QueueName": "mns-queue",
                            "IsBase64Decode": true
                        }
                    }
                }
            }
        \"\"\")
        default_instance = alicloud.rocketmq.Instance("defaultInstance",
            instance_name=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"),
            remark="terraform-example")
        default_group = alicloud.rocketmq.Group("defaultGroup",
            group_name="GID-example",
            instance_id=default_instance.id,
            remark="terraform-example")
        default_topic = alicloud.rocketmq.Topic("defaultTopic",
            topic_name="mytopic",
            instance_id=default_instance.id,
            message_type=0,
            remark="terraform-example")
        rocketmq_trigger = alicloud.fc.Trigger("rocketmqTrigger",
            service=default_service.name,
            function=default_function.name,
            type="eventbridge",
            config=pulumi.Output.all(default_instance.id, default_group.group_name, default_topic.topic_name).apply(lambda id, group_name, topic_name: f\"\"\"    {{
                "triggerEnable": false,
                "asyncInvocationType": false,
                "eventRuleFilterPattern": "{{}}",
                "eventSourceConfig": {{
                    "eventSourceType": "RocketMQ",
                    "eventSourceParameters": {{
                        "sourceRocketMQParameters": {{
                            "RegionId": "{default_regions.regions[0].id}",
                            "InstanceId": "{id}",
                            "GroupID": "{group_name}",
                            "Topic": "{topic_name}",
                            "Timestamp": 1686296162,
                            "Tag": "example-tag",
                            "Offset": "CONSUME_FROM_LAST_OFFSET"
                        }}
                    }}
                }}
            }}
        \"\"\"))
        default_amqp_instance_instance = alicloud.amqp.Instance("defaultAmqp/instanceInstance",
            instance_name=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"),
            instance_type="professional",
            max_tps="1000",
            queue_capacity="50",
            support_eip=True,
            max_eip_tps="128",
            payment_type="Subscription",
            period=1)
        default_virtual_host = alicloud.amqp.VirtualHost("defaultVirtualHost",
            instance_id=default_amqp / instance_instance["id"],
            virtual_host_name="example-VirtualHost")
        default_queue = alicloud.amqp.Queue("defaultQueue",
            instance_id=default_virtual_host.instance_id,
            queue_name="example-queue",
            virtual_host_name=default_virtual_host.virtual_host_name)
        rabbitmq_trigger = alicloud.fc.Trigger("rabbitmqTrigger",
            service=default_service.name,
            function=default_function.name,
            type="eventbridge",
            config=pulumi.Output.all(default_virtual_host.virtual_host_name, default_queue.queue_name).apply(lambda virtual_host_name, queue_name: f\"\"\"    {{
                "triggerEnable": false,
                "asyncInvocationType": false,
                "eventRuleFilterPattern": "{{}}",
                "eventSourceConfig": {{
                    "eventSourceType": "RabbitMQ",
                    "eventSourceParameters": {{
                        "sourceRabbitMQParameters": {{
                            "RegionId": "{default_regions.regions[0].id}",
                            "InstanceId": "{default_amqp / instance_instance["id"]}",
                            "VirtualHostName": "{virtual_host_name}",
                            "QueueName": "{queue_name}"
                        }}
                    }}
                }}
            }}
        \"\"\"))
        ```
        ## Module Support

        You can use to the existing fc module
        to create several triggers quickly.

        ## Import

        Function Compute trigger can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:fc/trigger:Trigger foo my-fc-service:hello-world:hello-trigger
        ```

        :param str resource_name: The name of the resource.
        :param TriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[str]] = None,
                 config_mns: Optional[pulumi.Input[str]] = None,
                 function: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 name_prefix: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 source_arn: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TriggerArgs.__new__(TriggerArgs)

            __props__.__dict__["config"] = config
            __props__.__dict__["config_mns"] = config_mns
            if function is None and not opts.urn:
                raise TypeError("Missing required property 'function'")
            __props__.__dict__["function"] = function
            __props__.__dict__["name"] = name
            __props__.__dict__["name_prefix"] = name_prefix
            __props__.__dict__["role"] = role
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__.__dict__["service"] = service
            __props__.__dict__["source_arn"] = source_arn
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["last_modified"] = None
            __props__.__dict__["trigger_id"] = None
        super(Trigger, __self__).__init__(
            'alicloud:fc/trigger:Trigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[str]] = None,
            config_mns: Optional[pulumi.Input[str]] = None,
            function: Optional[pulumi.Input[str]] = None,
            last_modified: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            name_prefix: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            service: Optional[pulumi.Input[str]] = None,
            source_arn: Optional[pulumi.Input[str]] = None,
            trigger_id: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Trigger':
        """
        Get an existing Trigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] config: The config of Function Compute trigger.It is valid when `type` is not "mns_topic".See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        :param pulumi.Input[str] config_mns: The config of Function Compute trigger when the type is "mns_topic".It is conflict with `config`.
        :param pulumi.Input[str] function: The Function Compute function name.
        :param pulumi.Input[str] last_modified: The date this resource was last modified.
        :param pulumi.Input[str] name: The Function Compute trigger name. It is the only in one service and is conflict with "name_prefix".
        :param pulumi.Input[str] name_prefix: Setting a prefix to get a only trigger name. It is conflict with "name".
        :param pulumi.Input[str] role: RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param pulumi.Input[str] service: The Function Compute service name.
        :param pulumi.Input[str] source_arn: Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        :param pulumi.Input[str] trigger_id: The Function Compute trigger ID.
        :param pulumi.Input[str] type: The Type of the trigger. Valid values: ["oss", "log", "timer", "http", "mns_topic", "cdn_events", "eventbridge"].
               
               > **NOTE:** Config does not support modification when type is mns_topic.
               > **NOTE:** type = cdn_events, available in 1.47.0+.
               > **NOTE:** type = eventbridge, available in 1.173.0+.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TriggerState.__new__(_TriggerState)

        __props__.__dict__["config"] = config
        __props__.__dict__["config_mns"] = config_mns
        __props__.__dict__["function"] = function
        __props__.__dict__["last_modified"] = last_modified
        __props__.__dict__["name"] = name
        __props__.__dict__["name_prefix"] = name_prefix
        __props__.__dict__["role"] = role
        __props__.__dict__["service"] = service
        __props__.__dict__["source_arn"] = source_arn
        __props__.__dict__["trigger_id"] = trigger_id
        __props__.__dict__["type"] = type
        return Trigger(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional[str]]:
        """
        The config of Function Compute trigger.It is valid when `type` is not "mns_topic".See [Configure triggers and events](https://www.alibabacloud.com/help/doc-detail/70140.htm) for more details.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="configMns")
    def config_mns(self) -> pulumi.Output[Optional[str]]:
        """
        The config of Function Compute trigger when the type is "mns_topic".It is conflict with `config`.
        """
        return pulumi.get(self, "config_mns")

    @property
    @pulumi.getter
    def function(self) -> pulumi.Output[str]:
        """
        The Function Compute function name.
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter(name="lastModified")
    def last_modified(self) -> pulumi.Output[str]:
        """
        The date this resource was last modified.
        """
        return pulumi.get(self, "last_modified")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The Function Compute trigger name. It is the only in one service and is conflict with "name_prefix".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="namePrefix")
    def name_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        Setting a prefix to get a only trigger name. It is conflict with "name".
        """
        return pulumi.get(self, "name_prefix")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[Optional[str]]:
        """
        RAM role arn attached to the Function Compute trigger. Role used by the event source to call the function. The value format is "acs:ram::$account-id:role/$role-name". See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[str]:
        """
        The Function Compute service name.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="sourceArn")
    def source_arn(self) -> pulumi.Output[Optional[str]]:
        """
        Event source resource address. See [Create a trigger](https://www.alibabacloud.com/help/doc-detail/53102.htm) for more details.
        """
        return pulumi.get(self, "source_arn")

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> pulumi.Output[str]:
        """
        The Function Compute trigger ID.
        """
        return pulumi.get(self, "trigger_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The Type of the trigger. Valid values: ["oss", "log", "timer", "http", "mns_topic", "cdn_events", "eventbridge"].

        > **NOTE:** Config does not support modification when type is mns_topic.
        > **NOTE:** type = cdn_events, available in 1.47.0+.
        > **NOTE:** type = eventbridge, available in 1.173.0+.
        """
        return pulumi.get(self, "type")

