# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetExecutionsResult',
    'AwaitableGetExecutionsResult',
    'get_executions',
    'get_executions_output',
]

@pulumi.output_type
class GetExecutionsResult:
    """
    A collection of values returned by getExecutions.
    """
    def __init__(__self__, enable_details=None, executions=None, flow_name=None, id=None, ids=None, name_regex=None, names=None, output_file=None, status=None):
        if enable_details and not isinstance(enable_details, bool):
            raise TypeError("Expected argument 'enable_details' to be a bool")
        pulumi.set(__self__, "enable_details", enable_details)
        if executions and not isinstance(executions, list):
            raise TypeError("Expected argument 'executions' to be a list")
        pulumi.set(__self__, "executions", executions)
        if flow_name and not isinstance(flow_name, str):
            raise TypeError("Expected argument 'flow_name' to be a str")
        pulumi.set(__self__, "flow_name", flow_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="enableDetails")
    def enable_details(self) -> Optional[bool]:
        return pulumi.get(self, "enable_details")

    @property
    @pulumi.getter
    def executions(self) -> Sequence['outputs.GetExecutionsExecutionResult']:
        return pulumi.get(self, "executions")

    @property
    @pulumi.getter(name="flowName")
    def flow_name(self) -> str:
        return pulumi.get(self, "flow_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


class AwaitableGetExecutionsResult(GetExecutionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExecutionsResult(
            enable_details=self.enable_details,
            executions=self.executions,
            flow_name=self.flow_name,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            status=self.status)


def get_executions(enable_details: Optional[bool] = None,
                   flow_name: Optional[str] = None,
                   ids: Optional[Sequence[str]] = None,
                   name_regex: Optional[str] = None,
                   output_file: Optional[str] = None,
                   status: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExecutionsResult:
    """
    This data source provides the FnF Executions of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.149.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.fnf.get_executions(flow_name="example_value",
        ids=[
            "my-Execution-1",
            "my-Execution-2",
        ])
    pulumi.export("fnfExecutionId1", data["alicloud_fn_f_executions"]["ids"]["executions"][0]["id"])
    ```


    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param str flow_name: The name of the flow.
    :param Sequence[str] ids: A list of Execution IDs. The value formats as `<flow_name>:<execution_name>`.
    :param str name_regex: A regex string to filter results by Execution name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The status of the resource.
    """
    __args__ = dict()
    __args__['enableDetails'] = enable_details
    __args__['flowName'] = flow_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:fnf/getExecutions:getExecutions', __args__, opts=opts, typ=GetExecutionsResult).value

    return AwaitableGetExecutionsResult(
        enable_details=pulumi.get(__ret__, 'enable_details'),
        executions=pulumi.get(__ret__, 'executions'),
        flow_name=pulumi.get(__ret__, 'flow_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_executions)
def get_executions_output(enable_details: Optional[pulumi.Input[Optional[bool]]] = None,
                          flow_name: Optional[pulumi.Input[str]] = None,
                          ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                          name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                          output_file: Optional[pulumi.Input[Optional[str]]] = None,
                          status: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExecutionsResult]:
    """
    This data source provides the FnF Executions of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.149.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.fnf.get_executions(flow_name="example_value",
        ids=[
            "my-Execution-1",
            "my-Execution-2",
        ])
    pulumi.export("fnfExecutionId1", data["alicloud_fn_f_executions"]["ids"]["executions"][0]["id"])
    ```


    :param bool enable_details: Default to `false`. Set it to `true` can output more details about resource attributes.
    :param str flow_name: The name of the flow.
    :param Sequence[str] ids: A list of Execution IDs. The value formats as `<flow_name>:<execution_name>`.
    :param str name_regex: A regex string to filter results by Execution name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The status of the resource.
    """
    ...
