# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'AclAclEntryArgs',
    'CustomRoutingEndpointTrafficPolicyPortRangeArgs',
    'EndpointGroupEndpointConfigurationArgs',
    'EndpointGroupPortOverridesArgs',
    'ForwardingRuleRuleActionArgs',
    'ForwardingRuleRuleActionForwardGroupConfigArgs',
    'ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs',
    'ForwardingRuleRuleConditionArgs',
    'ForwardingRuleRuleConditionHostConfigArgs',
    'ForwardingRuleRuleConditionPathConfigArgs',
    'ListenerCertificateArgs',
    'ListenerForwardedForConfigArgs',
    'ListenerPortRangeArgs',
]

@pulumi.input_type
class AclAclEntryArgs:
    def __init__(__self__, *,
                 entry: Optional[pulumi.Input[str]] = None,
                 entry_description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] entry: The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
        :param pulumi.Input[str] entry_description: The description of the IP entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_).
        """
        if entry is not None:
            pulumi.set(__self__, "entry", entry)
        if entry_description is not None:
            pulumi.set(__self__, "entry_description", entry_description)

    @property
    @pulumi.getter
    def entry(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address(192.168.XX.XX) or CIDR(10.0.XX.XX/24) block that you want to add to the network ACL.
        """
        return pulumi.get(self, "entry")

    @entry.setter
    def entry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry", value)

    @property
    @pulumi.getter(name="entryDescription")
    def entry_description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the IP entry. The description must be `1` to `256` characters in length, and can contain letters, digits, hyphens (-), forward slashes (/), periods (.),and underscores (_).
        """
        return pulumi.get(self, "entry_description")

    @entry_description.setter
    def entry_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_description", value)


@pulumi.input_type
class CustomRoutingEndpointTrafficPolicyPortRangeArgs:
    def __init__(__self__, *,
                 from_port: Optional[pulumi.Input[int]] = None,
                 to_port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] from_port: The start port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
        :param pulumi.Input[int] to_port: The end port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
        """
        if from_port is not None:
            pulumi.set(__self__, "from_port", from_port)
        if to_port is not None:
            pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> Optional[pulumi.Input[int]]:
        """
        The start port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "from_port", value)

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> Optional[pulumi.Input[int]]:
        """
        The end port of the port range of the traffic destination. The specified port must fall within the port range of the specified endpoint group.
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "to_port", value)


@pulumi.input_type
class EndpointGroupEndpointConfigurationArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[str],
                 type: pulumi.Input[str],
                 weight: pulumi.Input[int],
                 enable_clientip_preservation: Optional[pulumi.Input[bool]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] endpoint: The IP address or domain name of Endpoint N in the endpoint group.
        :param pulumi.Input[str] type: The type of Endpoint N in the endpoint group. Valid values:
        :param pulumi.Input[int] weight: The weight of Endpoint N in the endpoint group. Valid values: `0` to `255`.
               > **NOTE:** If the weight of a terminal node is set to 0, global acceleration will terminate the distribution of traffic to the terminal node. Please be careful.
        :param pulumi.Input[bool] enable_clientip_preservation: Indicates whether client IP addresses are reserved. Default Value: `false`. Valid values:
        :param pulumi.Input[bool] enable_proxy_protocol: Specifies whether to preserve client IP addresses by using the ProxyProtocol module. Default Value: `false`. Valid values:
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "weight", weight)
        if enable_clientip_preservation is not None:
            pulumi.set(__self__, "enable_clientip_preservation", enable_clientip_preservation)
        if enable_proxy_protocol is not None:
            pulumi.set(__self__, "enable_proxy_protocol", enable_proxy_protocol)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        The IP address or domain name of Endpoint N in the endpoint group.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of Endpoint N in the endpoint group. Valid values:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Input[int]:
        """
        The weight of Endpoint N in the endpoint group. Valid values: `0` to `255`.
        > **NOTE:** If the weight of a terminal node is set to 0, global acceleration will terminate the distribution of traffic to the terminal node. Please be careful.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: pulumi.Input[int]):
        pulumi.set(self, "weight", value)

    @property
    @pulumi.getter(name="enableClientipPreservation")
    def enable_clientip_preservation(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether client IP addresses are reserved. Default Value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_clientip_preservation")

    @enable_clientip_preservation.setter
    def enable_clientip_preservation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_clientip_preservation", value)

    @property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to preserve client IP addresses by using the ProxyProtocol module. Default Value: `false`. Valid values:
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @enable_proxy_protocol.setter
    def enable_proxy_protocol(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_proxy_protocol", value)


@pulumi.input_type
class EndpointGroupPortOverridesArgs:
    def __init__(__self__, *,
                 endpoint_port: Optional[pulumi.Input[int]] = None,
                 listener_port: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] endpoint_port: Forwarding port.
        :param pulumi.Input[int] listener_port: Listener port.
        """
        if endpoint_port is not None:
            pulumi.set(__self__, "endpoint_port", endpoint_port)
        if listener_port is not None:
            pulumi.set(__self__, "listener_port", listener_port)

    @property
    @pulumi.getter(name="endpointPort")
    def endpoint_port(self) -> Optional[pulumi.Input[int]]:
        """
        Forwarding port.
        """
        return pulumi.get(self, "endpoint_port")

    @endpoint_port.setter
    def endpoint_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "endpoint_port", value)

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> Optional[pulumi.Input[int]]:
        """
        Listener port.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "listener_port", value)


@pulumi.input_type
class ForwardingRuleRuleActionArgs:
    def __init__(__self__, *,
                 order: pulumi.Input[int],
                 rule_action_type: pulumi.Input[str],
                 forward_group_config: Optional[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigArgs']] = None,
                 rule_action_value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] order: Forwarding priority.
        :param pulumi.Input[str] rule_action_type: Forward action type.
        :param pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigArgs'] forward_group_config: Forwarding configuration. See `forward_group_config` below.
               > **NOTE:** From version 1.207.0, We recommend that you do not use `forward_group_config`, and we recommend that you use the `rule_action_type` and `rule_action_value` to configure forwarding actions.
        :param pulumi.Input[str] rule_action_value: The value of the forwarding action type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
        """
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "rule_action_type", rule_action_type)
        if forward_group_config is not None:
            pulumi.set(__self__, "forward_group_config", forward_group_config)
        if rule_action_value is not None:
            pulumi.set(__self__, "rule_action_value", rule_action_value)

    @property
    @pulumi.getter
    def order(self) -> pulumi.Input[int]:
        """
        Forwarding priority.
        """
        return pulumi.get(self, "order")

    @order.setter
    def order(self, value: pulumi.Input[int]):
        pulumi.set(self, "order", value)

    @property
    @pulumi.getter(name="ruleActionType")
    def rule_action_type(self) -> pulumi.Input[str]:
        """
        Forward action type.
        """
        return pulumi.get(self, "rule_action_type")

    @rule_action_type.setter
    def rule_action_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_action_type", value)

    @property
    @pulumi.getter(name="forwardGroupConfig")
    def forward_group_config(self) -> Optional[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigArgs']]:
        """
        Forwarding configuration. See `forward_group_config` below.
        > **NOTE:** From version 1.207.0, We recommend that you do not use `forward_group_config`, and we recommend that you use the `rule_action_type` and `rule_action_value` to configure forwarding actions.
        """
        return pulumi.get(self, "forward_group_config")

    @forward_group_config.setter
    def forward_group_config(self, value: Optional[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigArgs']]):
        pulumi.set(self, "forward_group_config", value)

    @property
    @pulumi.getter(name="ruleActionValue")
    def rule_action_value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the forwarding action type. For more information, see [How to use it](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createforwardingrules).
        """
        return pulumi.get(self, "rule_action_value")

    @rule_action_value.setter
    def rule_action_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_action_value", value)


@pulumi.input_type
class ForwardingRuleRuleActionForwardGroupConfigArgs:
    def __init__(__self__, *,
                 server_group_tuples: pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs']]] server_group_tuples: The information about the endpoint group. See `server_group_tuples` below.
        """
        pulumi.set(__self__, "server_group_tuples", server_group_tuples)

    @property
    @pulumi.getter(name="serverGroupTuples")
    def server_group_tuples(self) -> pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs']]]:
        """
        The information about the endpoint group. See `server_group_tuples` below.
        """
        return pulumi.get(self, "server_group_tuples")

    @server_group_tuples.setter
    def server_group_tuples(self, value: pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs']]]):
        pulumi.set(self, "server_group_tuples", value)


@pulumi.input_type
class ForwardingRuleRuleActionForwardGroupConfigServerGroupTupleArgs:
    def __init__(__self__, *,
                 endpoint_group_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] endpoint_group_id: The ID of the endpoint group.
        """
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)

    @property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> pulumi.Input[str]:
        """
        The ID of the endpoint group.
        """
        return pulumi.get(self, "endpoint_group_id")

    @endpoint_group_id.setter
    def endpoint_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_group_id", value)


@pulumi.input_type
class ForwardingRuleRuleConditionArgs:
    def __init__(__self__, *,
                 rule_condition_type: pulumi.Input[str],
                 host_configs: Optional[pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleConditionHostConfigArgs']]]] = None,
                 path_config: Optional[pulumi.Input['ForwardingRuleRuleConditionPathConfigArgs']] = None):
        """
        :param pulumi.Input[str] rule_condition_type: The type of the forwarding conditions. Valid values: `Host`, `Path`.
        :param pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleConditionHostConfigArgs']]] host_configs: The configuration of the domain name. See `host_config` below.
        :param pulumi.Input['ForwardingRuleRuleConditionPathConfigArgs'] path_config: The configuration of the path. See `path_config` below.
        """
        pulumi.set(__self__, "rule_condition_type", rule_condition_type)
        if host_configs is not None:
            pulumi.set(__self__, "host_configs", host_configs)
        if path_config is not None:
            pulumi.set(__self__, "path_config", path_config)

    @property
    @pulumi.getter(name="ruleConditionType")
    def rule_condition_type(self) -> pulumi.Input[str]:
        """
        The type of the forwarding conditions. Valid values: `Host`, `Path`.
        """
        return pulumi.get(self, "rule_condition_type")

    @rule_condition_type.setter
    def rule_condition_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_condition_type", value)

    @property
    @pulumi.getter(name="hostConfigs")
    def host_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleConditionHostConfigArgs']]]]:
        """
        The configuration of the domain name. See `host_config` below.
        """
        return pulumi.get(self, "host_configs")

    @host_configs.setter
    def host_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ForwardingRuleRuleConditionHostConfigArgs']]]]):
        pulumi.set(self, "host_configs", value)

    @property
    @pulumi.getter(name="pathConfig")
    def path_config(self) -> Optional[pulumi.Input['ForwardingRuleRuleConditionPathConfigArgs']]:
        """
        The configuration of the path. See `path_config` below.
        """
        return pulumi.get(self, "path_config")

    @path_config.setter
    def path_config(self, value: Optional[pulumi.Input['ForwardingRuleRuleConditionPathConfigArgs']]):
        pulumi.set(self, "path_config", value)


@pulumi.input_type
class ForwardingRuleRuleConditionHostConfigArgs:
    def __init__(__self__, *,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ForwardingRuleRuleConditionPathConfigArgs:
    def __init__(__self__, *,
                 values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] values: The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
        """
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The domain name is 3-128 characters long, which can contain letters, numbers, dashes (-) and width period (.), and supports the use of asterisk (*) and width question mark (?) as wildcard characters.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class ListenerCertificateArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] id: The id of the certificate.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the certificate.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class ListenerForwardedForConfigArgs:
    def __init__(__self__, *,
                 forwarded_for_ga_ap_enabled: Optional[pulumi.Input[bool]] = None,
                 forwarded_for_ga_id_enabled: Optional[pulumi.Input[bool]] = None,
                 forwarded_for_port_enabled: Optional[pulumi.Input[bool]] = None,
                 forwarded_for_proto_enabled: Optional[pulumi.Input[bool]] = None,
                 real_ip_enabled: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] forwarded_for_ga_ap_enabled: Specifies whether to use the GA-AP header to retrieve the information about acceleration regions. Default value: `false`. Valid values:
        :param pulumi.Input[bool] forwarded_for_ga_id_enabled: Specifies whether to use the GA-ID header to retrieve the ID of the GA instance. Default value: `false`. Valid values:
        :param pulumi.Input[bool] forwarded_for_port_enabled: Specifies whether to use the GA-X-Forward-Port header to retrieve the listener ports of the GA instance. Default value: `false`. Valid values:
        :param pulumi.Input[bool] forwarded_for_proto_enabled: Specifies whether to use the GA-X-Forward-Proto header to retrieve the listener protocol of the GA instance. Default value: `false`. Valid values:
        :param pulumi.Input[bool] real_ip_enabled: Specifies whether to use the X-Real-IP header to retrieve client IP addresses. Default value: `false`. Valid values:
        """
        if forwarded_for_ga_ap_enabled is not None:
            pulumi.set(__self__, "forwarded_for_ga_ap_enabled", forwarded_for_ga_ap_enabled)
        if forwarded_for_ga_id_enabled is not None:
            pulumi.set(__self__, "forwarded_for_ga_id_enabled", forwarded_for_ga_id_enabled)
        if forwarded_for_port_enabled is not None:
            pulumi.set(__self__, "forwarded_for_port_enabled", forwarded_for_port_enabled)
        if forwarded_for_proto_enabled is not None:
            pulumi.set(__self__, "forwarded_for_proto_enabled", forwarded_for_proto_enabled)
        if real_ip_enabled is not None:
            pulumi.set(__self__, "real_ip_enabled", real_ip_enabled)

    @property
    @pulumi.getter(name="forwardedForGaApEnabled")
    def forwarded_for_ga_ap_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use the GA-AP header to retrieve the information about acceleration regions. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "forwarded_for_ga_ap_enabled")

    @forwarded_for_ga_ap_enabled.setter
    def forwarded_for_ga_ap_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "forwarded_for_ga_ap_enabled", value)

    @property
    @pulumi.getter(name="forwardedForGaIdEnabled")
    def forwarded_for_ga_id_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use the GA-ID header to retrieve the ID of the GA instance. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "forwarded_for_ga_id_enabled")

    @forwarded_for_ga_id_enabled.setter
    def forwarded_for_ga_id_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "forwarded_for_ga_id_enabled", value)

    @property
    @pulumi.getter(name="forwardedForPortEnabled")
    def forwarded_for_port_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use the GA-X-Forward-Port header to retrieve the listener ports of the GA instance. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "forwarded_for_port_enabled")

    @forwarded_for_port_enabled.setter
    def forwarded_for_port_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "forwarded_for_port_enabled", value)

    @property
    @pulumi.getter(name="forwardedForProtoEnabled")
    def forwarded_for_proto_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use the GA-X-Forward-Proto header to retrieve the listener protocol of the GA instance. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "forwarded_for_proto_enabled")

    @forwarded_for_proto_enabled.setter
    def forwarded_for_proto_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "forwarded_for_proto_enabled", value)

    @property
    @pulumi.getter(name="realIpEnabled")
    def real_ip_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use the X-Real-IP header to retrieve client IP addresses. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "real_ip_enabled")

    @real_ip_enabled.setter
    def real_ip_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "real_ip_enabled", value)


@pulumi.input_type
class ListenerPortRangeArgs:
    def __init__(__self__, *,
                 from_port: pulumi.Input[int],
                 to_port: pulumi.Input[int]):
        """
        :param pulumi.Input[int] from_port: The initial listening port used to receive requests and forward them to terminal nodes.
        :param pulumi.Input[int] to_port: The end listening port used to receive requests and forward them to terminal nodes.
        """
        pulumi.set(__self__, "from_port", from_port)
        pulumi.set(__self__, "to_port", to_port)

    @property
    @pulumi.getter(name="fromPort")
    def from_port(self) -> pulumi.Input[int]:
        """
        The initial listening port used to receive requests and forward them to terminal nodes.
        """
        return pulumi.get(self, "from_port")

    @from_port.setter
    def from_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "from_port", value)

    @property
    @pulumi.getter(name="toPort")
    def to_port(self) -> pulumi.Input[int]:
        """
        The end listening port used to receive requests and forward them to terminal nodes.
        """
        return pulumi.get(self, "to_port")

    @to_port.setter
    def to_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "to_port", value)


