# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AccessLogArgs', 'AccessLog']

@pulumi.input_type
class AccessLogArgs:
    def __init__(__self__, *,
                 accelerator_id: pulumi.Input[str],
                 endpoint_group_id: pulumi.Input[str],
                 listener_id: pulumi.Input[str],
                 sls_log_store_name: pulumi.Input[str],
                 sls_project_name: pulumi.Input[str],
                 sls_region_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a AccessLog resource.
        :param pulumi.Input[str] accelerator_id: The ID of the global acceleration instance.
        :param pulumi.Input[str] endpoint_group_id: The ID of the endpoint group instance.
        :param pulumi.Input[str] listener_id: The ID of the listener.
        :param pulumi.Input[str] sls_log_store_name: The name of the Log Store.
        :param pulumi.Input[str] sls_project_name: The name of the Log Service project.
        :param pulumi.Input[str] sls_region_id: The region ID of the Log Service project.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)
        pulumi.set(__self__, "listener_id", listener_id)
        pulumi.set(__self__, "sls_log_store_name", sls_log_store_name)
        pulumi.set(__self__, "sls_project_name", sls_project_name)
        pulumi.set(__self__, "sls_region_id", sls_region_id)

    @property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Input[str]:
        """
        The ID of the global acceleration instance.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "accelerator_id", value)

    @property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> pulumi.Input[str]:
        """
        The ID of the endpoint group instance.
        """
        return pulumi.get(self, "endpoint_group_id")

    @endpoint_group_id.setter
    def endpoint_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_group_id", value)

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Input[str]:
        """
        The ID of the listener.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "listener_id", value)

    @property
    @pulumi.getter(name="slsLogStoreName")
    def sls_log_store_name(self) -> pulumi.Input[str]:
        """
        The name of the Log Store.
        """
        return pulumi.get(self, "sls_log_store_name")

    @sls_log_store_name.setter
    def sls_log_store_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "sls_log_store_name", value)

    @property
    @pulumi.getter(name="slsProjectName")
    def sls_project_name(self) -> pulumi.Input[str]:
        """
        The name of the Log Service project.
        """
        return pulumi.get(self, "sls_project_name")

    @sls_project_name.setter
    def sls_project_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "sls_project_name", value)

    @property
    @pulumi.getter(name="slsRegionId")
    def sls_region_id(self) -> pulumi.Input[str]:
        """
        The region ID of the Log Service project.
        """
        return pulumi.get(self, "sls_region_id")

    @sls_region_id.setter
    def sls_region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sls_region_id", value)


@pulumi.input_type
class _AccessLogState:
    def __init__(__self__, *,
                 accelerator_id: Optional[pulumi.Input[str]] = None,
                 endpoint_group_id: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 sls_log_store_name: Optional[pulumi.Input[str]] = None,
                 sls_project_name: Optional[pulumi.Input[str]] = None,
                 sls_region_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AccessLog resources.
        :param pulumi.Input[str] accelerator_id: The ID of the global acceleration instance.
        :param pulumi.Input[str] endpoint_group_id: The ID of the endpoint group instance.
        :param pulumi.Input[str] listener_id: The ID of the listener.
        :param pulumi.Input[str] sls_log_store_name: The name of the Log Store.
        :param pulumi.Input[str] sls_project_name: The name of the Log Service project.
        :param pulumi.Input[str] sls_region_id: The region ID of the Log Service project.
        :param pulumi.Input[str] status: Whether access log is enabled.
        """
        if accelerator_id is not None:
            pulumi.set(__self__, "accelerator_id", accelerator_id)
        if endpoint_group_id is not None:
            pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if sls_log_store_name is not None:
            pulumi.set(__self__, "sls_log_store_name", sls_log_store_name)
        if sls_project_name is not None:
            pulumi.set(__self__, "sls_project_name", sls_project_name)
        if sls_region_id is not None:
            pulumi.set(__self__, "sls_region_id", sls_region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the global acceleration instance.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_id", value)

    @property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the endpoint group instance.
        """
        return pulumi.get(self, "endpoint_group_id")

    @endpoint_group_id.setter
    def endpoint_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_group_id", value)

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the listener.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_id", value)

    @property
    @pulumi.getter(name="slsLogStoreName")
    def sls_log_store_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Log Store.
        """
        return pulumi.get(self, "sls_log_store_name")

    @sls_log_store_name.setter
    def sls_log_store_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sls_log_store_name", value)

    @property
    @pulumi.getter(name="slsProjectName")
    def sls_project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Log Service project.
        """
        return pulumi.get(self, "sls_project_name")

    @sls_project_name.setter
    def sls_project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sls_project_name", value)

    @property
    @pulumi.getter(name="slsRegionId")
    def sls_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The region ID of the Log Service project.
        """
        return pulumi.get(self, "sls_region_id")

    @sls_region_id.setter
    def sls_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sls_region_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Whether access log is enabled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class AccessLog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_id: Optional[pulumi.Input[str]] = None,
                 endpoint_group_id: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 sls_log_store_name: Optional[pulumi.Input[str]] = None,
                 sls_project_name: Optional[pulumi.Input[str]] = None,
                 sls_region_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Global Accelerator (GA) Access Log resource.

        For information about Global Accelerator (GA) Access Log and how to use it, see [What is Access Log](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-attachlogstoretoendpointgroup).

        > **NOTE:** Available since v1.187.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_project = alicloud.log.Project("defaultProject")
        default_store = alicloud.log.Store("defaultStore", project=default_project.name)
        default_accelerator = alicloud.ga.Accelerator("defaultAccelerator",
            duration=1,
            auto_use_coupon=True,
            spec="2")
        default_bandwidth_package = alicloud.ga.BandwidthPackage("defaultBandwidthPackage",
            bandwidth=100,
            type="Basic",
            bandwidth_type="Basic",
            payment_type="PayAsYouGo",
            billing_type="PayBy95",
            ratio=30)
        default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("defaultBandwidthPackageAttachment",
            accelerator_id=default_accelerator.id,
            bandwidth_package_id=default_bandwidth_package.id)
        default_listener = alicloud.ga.Listener("defaultListener",
            accelerator_id=default_bandwidth_package_attachment.accelerator_id,
            client_affinity="SOURCE_IP",
            protocol="HTTP",
            port_ranges=[alicloud.ga.ListenerPortRangeArgs(
                from_port=70,
                to_port=70,
            )])
        default_eip_address = alicloud.ecs.EipAddress("defaultEipAddress",
            bandwidth="10",
            internet_charge_type="PayByBandwidth",
            address_name="terraform-example")
        default_endpoint_group = alicloud.ga.EndpointGroup("defaultEndpointGroup",
            accelerator_id=default_listener.accelerator_id,
            endpoint_configurations=[alicloud.ga.EndpointGroupEndpointConfigurationArgs(
                endpoint=default_eip_address.ip_address,
                type="PublicIp",
                weight=20,
            )],
            endpoint_group_region=region,
            listener_id=default_listener.id)
        default_access_log = alicloud.ga.AccessLog("defaultAccessLog",
            accelerator_id=default_accelerator.id,
            listener_id=default_listener.id,
            endpoint_group_id=default_endpoint_group.id,
            sls_project_name=default_project.name,
            sls_log_store_name=default_store.name,
            sls_region_id=region)
        ```

        ## Import

        Global Accelerator (GA) Access Log can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ga/accessLog:AccessLog example <accelerator_id>:<listener_id>:<endpoint_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accelerator_id: The ID of the global acceleration instance.
        :param pulumi.Input[str] endpoint_group_id: The ID of the endpoint group instance.
        :param pulumi.Input[str] listener_id: The ID of the listener.
        :param pulumi.Input[str] sls_log_store_name: The name of the Log Store.
        :param pulumi.Input[str] sls_project_name: The name of the Log Service project.
        :param pulumi.Input[str] sls_region_id: The region ID of the Log Service project.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccessLogArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Global Accelerator (GA) Access Log resource.

        For information about Global Accelerator (GA) Access Log and how to use it, see [What is Access Log](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-attachlogstoretoendpointgroup).

        > **NOTE:** Available since v1.187.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_project = alicloud.log.Project("defaultProject")
        default_store = alicloud.log.Store("defaultStore", project=default_project.name)
        default_accelerator = alicloud.ga.Accelerator("defaultAccelerator",
            duration=1,
            auto_use_coupon=True,
            spec="2")
        default_bandwidth_package = alicloud.ga.BandwidthPackage("defaultBandwidthPackage",
            bandwidth=100,
            type="Basic",
            bandwidth_type="Basic",
            payment_type="PayAsYouGo",
            billing_type="PayBy95",
            ratio=30)
        default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("defaultBandwidthPackageAttachment",
            accelerator_id=default_accelerator.id,
            bandwidth_package_id=default_bandwidth_package.id)
        default_listener = alicloud.ga.Listener("defaultListener",
            accelerator_id=default_bandwidth_package_attachment.accelerator_id,
            client_affinity="SOURCE_IP",
            protocol="HTTP",
            port_ranges=[alicloud.ga.ListenerPortRangeArgs(
                from_port=70,
                to_port=70,
            )])
        default_eip_address = alicloud.ecs.EipAddress("defaultEipAddress",
            bandwidth="10",
            internet_charge_type="PayByBandwidth",
            address_name="terraform-example")
        default_endpoint_group = alicloud.ga.EndpointGroup("defaultEndpointGroup",
            accelerator_id=default_listener.accelerator_id,
            endpoint_configurations=[alicloud.ga.EndpointGroupEndpointConfigurationArgs(
                endpoint=default_eip_address.ip_address,
                type="PublicIp",
                weight=20,
            )],
            endpoint_group_region=region,
            listener_id=default_listener.id)
        default_access_log = alicloud.ga.AccessLog("defaultAccessLog",
            accelerator_id=default_accelerator.id,
            listener_id=default_listener.id,
            endpoint_group_id=default_endpoint_group.id,
            sls_project_name=default_project.name,
            sls_log_store_name=default_store.name,
            sls_region_id=region)
        ```

        ## Import

        Global Accelerator (GA) Access Log can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ga/accessLog:AccessLog example <accelerator_id>:<listener_id>:<endpoint_group_id>
        ```

        :param str resource_name: The name of the resource.
        :param AccessLogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccessLogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_id: Optional[pulumi.Input[str]] = None,
                 endpoint_group_id: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 sls_log_store_name: Optional[pulumi.Input[str]] = None,
                 sls_project_name: Optional[pulumi.Input[str]] = None,
                 sls_region_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccessLogArgs.__new__(AccessLogArgs)

            if accelerator_id is None and not opts.urn:
                raise TypeError("Missing required property 'accelerator_id'")
            __props__.__dict__["accelerator_id"] = accelerator_id
            if endpoint_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_group_id'")
            __props__.__dict__["endpoint_group_id"] = endpoint_group_id
            if listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'listener_id'")
            __props__.__dict__["listener_id"] = listener_id
            if sls_log_store_name is None and not opts.urn:
                raise TypeError("Missing required property 'sls_log_store_name'")
            __props__.__dict__["sls_log_store_name"] = sls_log_store_name
            if sls_project_name is None and not opts.urn:
                raise TypeError("Missing required property 'sls_project_name'")
            __props__.__dict__["sls_project_name"] = sls_project_name
            if sls_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'sls_region_id'")
            __props__.__dict__["sls_region_id"] = sls_region_id
            __props__.__dict__["status"] = None
        super(AccessLog, __self__).__init__(
            'alicloud:ga/accessLog:AccessLog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerator_id: Optional[pulumi.Input[str]] = None,
            endpoint_group_id: Optional[pulumi.Input[str]] = None,
            listener_id: Optional[pulumi.Input[str]] = None,
            sls_log_store_name: Optional[pulumi.Input[str]] = None,
            sls_project_name: Optional[pulumi.Input[str]] = None,
            sls_region_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'AccessLog':
        """
        Get an existing AccessLog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accelerator_id: The ID of the global acceleration instance.
        :param pulumi.Input[str] endpoint_group_id: The ID of the endpoint group instance.
        :param pulumi.Input[str] listener_id: The ID of the listener.
        :param pulumi.Input[str] sls_log_store_name: The name of the Log Store.
        :param pulumi.Input[str] sls_project_name: The name of the Log Service project.
        :param pulumi.Input[str] sls_region_id: The region ID of the Log Service project.
        :param pulumi.Input[str] status: Whether access log is enabled.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccessLogState.__new__(_AccessLogState)

        __props__.__dict__["accelerator_id"] = accelerator_id
        __props__.__dict__["endpoint_group_id"] = endpoint_group_id
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["sls_log_store_name"] = sls_log_store_name
        __props__.__dict__["sls_project_name"] = sls_project_name
        __props__.__dict__["sls_region_id"] = sls_region_id
        __props__.__dict__["status"] = status
        return AccessLog(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Output[str]:
        """
        The ID of the global acceleration instance.
        """
        return pulumi.get(self, "accelerator_id")

    @property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> pulumi.Output[str]:
        """
        The ID of the endpoint group instance.
        """
        return pulumi.get(self, "endpoint_group_id")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[str]:
        """
        The ID of the listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="slsLogStoreName")
    def sls_log_store_name(self) -> pulumi.Output[str]:
        """
        The name of the Log Store.
        """
        return pulumi.get(self, "sls_log_store_name")

    @property
    @pulumi.getter(name="slsProjectName")
    def sls_project_name(self) -> pulumi.Output[str]:
        """
        The name of the Log Service project.
        """
        return pulumi.get(self, "sls_project_name")

    @property
    @pulumi.getter(name="slsRegionId")
    def sls_region_id(self) -> pulumi.Output[str]:
        """
        The region ID of the Log Service project.
        """
        return pulumi.get(self, "sls_region_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Whether access log is enabled.
        """
        return pulumi.get(self, "status")

