# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EndpointGroupArgs', 'EndpointGroup']

@pulumi.input_type
class EndpointGroupArgs:
    def __init__(__self__, *,
                 accelerator_id: pulumi.Input[str],
                 endpoint_configurations: pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]],
                 endpoint_group_region: pulumi.Input[str],
                 listener_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint_group_type: Optional[pulumi.Input[str]] = None,
                 endpoint_request_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_interval_seconds: Optional[pulumi.Input[int]] = None,
                 health_check_path: Optional[pulumi.Input[str]] = None,
                 health_check_port: Optional[pulumi.Input[int]] = None,
                 health_check_protocol: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port_overrides: Optional[pulumi.Input['EndpointGroupPortOverridesArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 threshold_count: Optional[pulumi.Input[int]] = None,
                 traffic_percentage: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a EndpointGroup resource.
        :param pulumi.Input[str] accelerator_id: The ID of the Global Accelerator instance to which the endpoint group will be added.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]] endpoint_configurations: The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
        :param pulumi.Input[str] endpoint_group_region: The ID of the region where the endpoint group is deployed.
        :param pulumi.Input[str] listener_id: The ID of the listener that is associated with the endpoint group.
        :param pulumi.Input[str] description: The description of the endpoint group.
        :param pulumi.Input[str] endpoint_group_type: The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
               > **NOTE:** Only the listening instance of HTTP or HTTPS protocol supports the creation of virtual terminal node group.
        :param pulumi.Input[str] endpoint_request_protocol: The endpoint request protocol. Valid values: `HTTP`, `HTTPS`.
               > **NOTE:** This item is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. For the listening instance of HTTP protocol, the back-end service protocol supports and only supports HTTP.
        :param pulumi.Input[int] health_check_interval_seconds: The interval between two consecutive health checks. Unit: seconds.
        :param pulumi.Input[str] health_check_path: The path specified as the destination of the targets for health checks.
        :param pulumi.Input[int] health_check_port: The port that is used for health checks.
        :param pulumi.Input[str] health_check_protocol: The protocol that is used to connect to the targets for health checks. Valid values: `http`, `https`, `tcp`.
        :param pulumi.Input[str] name: The name of the endpoint group.
        :param pulumi.Input['EndpointGroupPortOverridesArgs'] port_overrides: Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
               > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] threshold_count: The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
        :param pulumi.Input[int] traffic_percentage: The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "endpoint_configurations", endpoint_configurations)
        pulumi.set(__self__, "endpoint_group_region", endpoint_group_region)
        pulumi.set(__self__, "listener_id", listener_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint_group_type is not None:
            pulumi.set(__self__, "endpoint_group_type", endpoint_group_type)
        if endpoint_request_protocol is not None:
            pulumi.set(__self__, "endpoint_request_protocol", endpoint_request_protocol)
        if health_check_interval_seconds is not None:
            pulumi.set(__self__, "health_check_interval_seconds", health_check_interval_seconds)
        if health_check_path is not None:
            pulumi.set(__self__, "health_check_path", health_check_path)
        if health_check_port is not None:
            pulumi.set(__self__, "health_check_port", health_check_port)
        if health_check_protocol is not None:
            pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_overrides is not None:
            pulumi.set(__self__, "port_overrides", port_overrides)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threshold_count is not None:
            pulumi.set(__self__, "threshold_count", threshold_count)
        if traffic_percentage is not None:
            pulumi.set(__self__, "traffic_percentage", traffic_percentage)

    @property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Input[str]:
        """
        The ID of the Global Accelerator instance to which the endpoint group will be added.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "accelerator_id", value)

    @property
    @pulumi.getter(name="endpointConfigurations")
    def endpoint_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]]:
        """
        The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
        """
        return pulumi.get(self, "endpoint_configurations")

    @endpoint_configurations.setter
    def endpoint_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]]):
        pulumi.set(self, "endpoint_configurations", value)

    @property
    @pulumi.getter(name="endpointGroupRegion")
    def endpoint_group_region(self) -> pulumi.Input[str]:
        """
        The ID of the region where the endpoint group is deployed.
        """
        return pulumi.get(self, "endpoint_group_region")

    @endpoint_group_region.setter
    def endpoint_group_region(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint_group_region", value)

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Input[str]:
        """
        The ID of the listener that is associated with the endpoint group.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "listener_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the endpoint group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endpointGroupType")
    def endpoint_group_type(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
        > **NOTE:** Only the listening instance of HTTP or HTTPS protocol supports the creation of virtual terminal node group.
        """
        return pulumi.get(self, "endpoint_group_type")

    @endpoint_group_type.setter
    def endpoint_group_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_group_type", value)

    @property
    @pulumi.getter(name="endpointRequestProtocol")
    def endpoint_request_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint request protocol. Valid values: `HTTP`, `HTTPS`.
        > **NOTE:** This item is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. For the listening instance of HTTP protocol, the back-end service protocol supports and only supports HTTP.
        """
        return pulumi.get(self, "endpoint_request_protocol")

    @endpoint_request_protocol.setter
    def endpoint_request_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_request_protocol", value)

    @property
    @pulumi.getter(name="healthCheckIntervalSeconds")
    def health_check_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The interval between two consecutive health checks. Unit: seconds.
        """
        return pulumi.get(self, "health_check_interval_seconds")

    @health_check_interval_seconds.setter
    def health_check_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_interval_seconds", value)

    @property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path specified as the destination of the targets for health checks.
        """
        return pulumi.get(self, "health_check_path")

    @health_check_path.setter
    def health_check_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_path", value)

    @property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that is used for health checks.
        """
        return pulumi.get(self, "health_check_port")

    @health_check_port.setter
    def health_check_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_port", value)

    @property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol that is used to connect to the targets for health checks. Valid values: `http`, `https`, `tcp`.
        """
        return pulumi.get(self, "health_check_protocol")

    @health_check_protocol.setter
    def health_check_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_protocol", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the endpoint group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="portOverrides")
    def port_overrides(self) -> Optional[pulumi.Input['EndpointGroupPortOverridesArgs']]:
        """
        Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
        > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
        """
        return pulumi.get(self, "port_overrides")

    @port_overrides.setter
    def port_overrides(self, value: Optional[pulumi.Input['EndpointGroupPortOverridesArgs']]):
        pulumi.set(self, "port_overrides", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="thresholdCount")
    def threshold_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
        """
        return pulumi.get(self, "threshold_count")

    @threshold_count.setter
    def threshold_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "threshold_count", value)

    @property
    @pulumi.getter(name="trafficPercentage")
    def traffic_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        return pulumi.get(self, "traffic_percentage")

    @traffic_percentage.setter
    def traffic_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "traffic_percentage", value)


@pulumi.input_type
class _EndpointGroupState:
    def __init__(__self__, *,
                 accelerator_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]]] = None,
                 endpoint_group_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 endpoint_group_region: Optional[pulumi.Input[str]] = None,
                 endpoint_group_type: Optional[pulumi.Input[str]] = None,
                 endpoint_request_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_interval_seconds: Optional[pulumi.Input[int]] = None,
                 health_check_path: Optional[pulumi.Input[str]] = None,
                 health_check_port: Optional[pulumi.Input[int]] = None,
                 health_check_protocol: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port_overrides: Optional[pulumi.Input['EndpointGroupPortOverridesArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 threshold_count: Optional[pulumi.Input[int]] = None,
                 traffic_percentage: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering EndpointGroup resources.
        :param pulumi.Input[str] accelerator_id: The ID of the Global Accelerator instance to which the endpoint group will be added.
        :param pulumi.Input[str] description: The description of the endpoint group.
        :param pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]] endpoint_configurations: The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoint_group_ip_lists: (Available since v1.213.0) The active endpoint IP addresses of the endpoint group. `endpoint_group_ip_list` will change with the growth of network traffic. You can run `pulumi up` to query the latest CIDR blocks and IP addresses.
        :param pulumi.Input[str] endpoint_group_region: The ID of the region where the endpoint group is deployed.
        :param pulumi.Input[str] endpoint_group_type: The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
               > **NOTE:** Only the listening instance of HTTP or HTTPS protocol supports the creation of virtual terminal node group.
        :param pulumi.Input[str] endpoint_request_protocol: The endpoint request protocol. Valid values: `HTTP`, `HTTPS`.
               > **NOTE:** This item is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. For the listening instance of HTTP protocol, the back-end service protocol supports and only supports HTTP.
        :param pulumi.Input[int] health_check_interval_seconds: The interval between two consecutive health checks. Unit: seconds.
        :param pulumi.Input[str] health_check_path: The path specified as the destination of the targets for health checks.
        :param pulumi.Input[int] health_check_port: The port that is used for health checks.
        :param pulumi.Input[str] health_check_protocol: The protocol that is used to connect to the targets for health checks. Valid values: `http`, `https`, `tcp`.
        :param pulumi.Input[str] listener_id: The ID of the listener that is associated with the endpoint group.
        :param pulumi.Input[str] name: The name of the endpoint group.
        :param pulumi.Input['EndpointGroupPortOverridesArgs'] port_overrides: Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
               > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
        :param pulumi.Input[str] status: The status of the endpoint group.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] threshold_count: The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
        :param pulumi.Input[int] traffic_percentage: The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        if accelerator_id is not None:
            pulumi.set(__self__, "accelerator_id", accelerator_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if endpoint_configurations is not None:
            pulumi.set(__self__, "endpoint_configurations", endpoint_configurations)
        if endpoint_group_ip_lists is not None:
            pulumi.set(__self__, "endpoint_group_ip_lists", endpoint_group_ip_lists)
        if endpoint_group_region is not None:
            pulumi.set(__self__, "endpoint_group_region", endpoint_group_region)
        if endpoint_group_type is not None:
            pulumi.set(__self__, "endpoint_group_type", endpoint_group_type)
        if endpoint_request_protocol is not None:
            pulumi.set(__self__, "endpoint_request_protocol", endpoint_request_protocol)
        if health_check_interval_seconds is not None:
            pulumi.set(__self__, "health_check_interval_seconds", health_check_interval_seconds)
        if health_check_path is not None:
            pulumi.set(__self__, "health_check_path", health_check_path)
        if health_check_port is not None:
            pulumi.set(__self__, "health_check_port", health_check_port)
        if health_check_protocol is not None:
            pulumi.set(__self__, "health_check_protocol", health_check_protocol)
        if listener_id is not None:
            pulumi.set(__self__, "listener_id", listener_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_overrides is not None:
            pulumi.set(__self__, "port_overrides", port_overrides)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if threshold_count is not None:
            pulumi.set(__self__, "threshold_count", threshold_count)
        if traffic_percentage is not None:
            pulumi.set(__self__, "traffic_percentage", traffic_percentage)

    @property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Global Accelerator instance to which the endpoint group will be added.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the endpoint group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="endpointConfigurations")
    def endpoint_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]]]:
        """
        The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
        """
        return pulumi.get(self, "endpoint_configurations")

    @endpoint_configurations.setter
    def endpoint_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EndpointGroupEndpointConfigurationArgs']]]]):
        pulumi.set(self, "endpoint_configurations", value)

    @property
    @pulumi.getter(name="endpointGroupIpLists")
    def endpoint_group_ip_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Available since v1.213.0) The active endpoint IP addresses of the endpoint group. `endpoint_group_ip_list` will change with the growth of network traffic. You can run `pulumi up` to query the latest CIDR blocks and IP addresses.
        """
        return pulumi.get(self, "endpoint_group_ip_lists")

    @endpoint_group_ip_lists.setter
    def endpoint_group_ip_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "endpoint_group_ip_lists", value)

    @property
    @pulumi.getter(name="endpointGroupRegion")
    def endpoint_group_region(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the region where the endpoint group is deployed.
        """
        return pulumi.get(self, "endpoint_group_region")

    @endpoint_group_region.setter
    def endpoint_group_region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_group_region", value)

    @property
    @pulumi.getter(name="endpointGroupType")
    def endpoint_group_type(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
        > **NOTE:** Only the listening instance of HTTP or HTTPS protocol supports the creation of virtual terminal node group.
        """
        return pulumi.get(self, "endpoint_group_type")

    @endpoint_group_type.setter
    def endpoint_group_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_group_type", value)

    @property
    @pulumi.getter(name="endpointRequestProtocol")
    def endpoint_request_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The endpoint request protocol. Valid values: `HTTP`, `HTTPS`.
        > **NOTE:** This item is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. For the listening instance of HTTP protocol, the back-end service protocol supports and only supports HTTP.
        """
        return pulumi.get(self, "endpoint_request_protocol")

    @endpoint_request_protocol.setter
    def endpoint_request_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_request_protocol", value)

    @property
    @pulumi.getter(name="healthCheckIntervalSeconds")
    def health_check_interval_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        The interval between two consecutive health checks. Unit: seconds.
        """
        return pulumi.get(self, "health_check_interval_seconds")

    @health_check_interval_seconds.setter
    def health_check_interval_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_interval_seconds", value)

    @property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path specified as the destination of the targets for health checks.
        """
        return pulumi.get(self, "health_check_path")

    @health_check_path.setter
    def health_check_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_path", value)

    @property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that is used for health checks.
        """
        return pulumi.get(self, "health_check_port")

    @health_check_port.setter
    def health_check_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "health_check_port", value)

    @property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol that is used to connect to the targets for health checks. Valid values: `http`, `https`, `tcp`.
        """
        return pulumi.get(self, "health_check_protocol")

    @health_check_protocol.setter
    def health_check_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health_check_protocol", value)

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the listener that is associated with the endpoint group.
        """
        return pulumi.get(self, "listener_id")

    @listener_id.setter
    def listener_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the endpoint group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="portOverrides")
    def port_overrides(self) -> Optional[pulumi.Input['EndpointGroupPortOverridesArgs']]:
        """
        Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
        > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
        """
        return pulumi.get(self, "port_overrides")

    @port_overrides.setter
    def port_overrides(self, value: Optional[pulumi.Input['EndpointGroupPortOverridesArgs']]):
        pulumi.set(self, "port_overrides", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the endpoint group.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="thresholdCount")
    def threshold_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
        """
        return pulumi.get(self, "threshold_count")

    @threshold_count.setter
    def threshold_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "threshold_count", value)

    @property
    @pulumi.getter(name="trafficPercentage")
    def traffic_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        return pulumi.get(self, "traffic_percentage")

    @traffic_percentage.setter
    def traffic_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "traffic_percentage", value)


class EndpointGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointGroupEndpointConfigurationArgs']]]]] = None,
                 endpoint_group_region: Optional[pulumi.Input[str]] = None,
                 endpoint_group_type: Optional[pulumi.Input[str]] = None,
                 endpoint_request_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_interval_seconds: Optional[pulumi.Input[int]] = None,
                 health_check_path: Optional[pulumi.Input[str]] = None,
                 health_check_port: Optional[pulumi.Input[int]] = None,
                 health_check_protocol: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port_overrides: Optional[pulumi.Input[pulumi.InputType['EndpointGroupPortOverridesArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 threshold_count: Optional[pulumi.Input[int]] = None,
                 traffic_percentage: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a Global Accelerator (GA) Endpoint Group resource.

        For information about Global Accelerator (GA) Endpoint Group and how to use it, see [What is Endpoint Group](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createendpointgroup).

        > **NOTE:** Available since v1.113.0.

        > **NOTE:** Listeners that use different protocols support different types of endpoint groups:

        * For a TCP or UDP listener, you can create only one default endpoint group.
        * For an HTTP or HTTPS listener, you can create one default endpoint group and one virtual endpoint group. By default, you can create only one virtual endpoint group.
          * A default endpoint group refers to the endpoint group that you configure when you create an HTTP or HTTPS listener.
          * A virtual endpoint group refers to the endpoint group that you can create on the Endpoint Group page after you create a listener.
        * After you create a virtual endpoint group for an HTTP or HTTPS listener, you can create a forwarding rule and associate the forwarding rule with the virtual endpoint group. Then, the HTTP or HTTPS listener forwards requests with different destination domain names or paths to the default or virtual endpoint group based on the forwarding rule. This way, you can use one Global Accelerator (GA) instance to accelerate access to multiple domain names or paths. For more information about how to create a forwarding rule, see [Manage forwarding rules](https://www.alibabacloud.com/help/en/doc-detail/204224.htm).

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        default_accelerator = alicloud.ga.Accelerator("defaultAccelerator",
            duration=1,
            auto_use_coupon=True,
            spec="1")
        default_bandwidth_package = alicloud.ga.BandwidthPackage("defaultBandwidthPackage",
            bandwidth=100,
            type="Basic",
            bandwidth_type="Basic",
            payment_type="PayAsYouGo",
            billing_type="PayBy95",
            ratio=30)
        default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("defaultBandwidthPackageAttachment",
            accelerator_id=default_accelerator.id,
            bandwidth_package_id=default_bandwidth_package.id)
        default_listener = alicloud.ga.Listener("defaultListener",
            accelerator_id=default_bandwidth_package_attachment.accelerator_id,
            port_ranges=[alicloud.ga.ListenerPortRangeArgs(
                from_port=60,
                to_port=70,
            )],
            client_affinity="SOURCE_IP",
            protocol="UDP")
        default_eip_address = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_eip_address.append(alicloud.ecs.EipAddress(f"defaultEipAddress-{range['value']}",
                bandwidth="10",
                internet_charge_type="PayByBandwidth",
                address_name="terraform-example"))
        default_endpoint_group = alicloud.ga.EndpointGroup("defaultEndpointGroup",
            accelerator_id=default_accelerator.id,
            endpoint_configurations=[
                alicloud.ga.EndpointGroupEndpointConfigurationArgs(
                    endpoint=default_eip_address[0].ip_address,
                    type="PublicIp",
                    weight=20,
                ),
                alicloud.ga.EndpointGroupEndpointConfigurationArgs(
                    endpoint=default_eip_address[1].ip_address,
                    type="PublicIp",
                    weight=20,
                ),
            ],
            endpoint_group_region=region,
            listener_id=default_listener.id)
        ```

        ## Import

        Ga Endpoint Group can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ga/endpointGroup:EndpointGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accelerator_id: The ID of the Global Accelerator instance to which the endpoint group will be added.
        :param pulumi.Input[str] description: The description of the endpoint group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointGroupEndpointConfigurationArgs']]]] endpoint_configurations: The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
        :param pulumi.Input[str] endpoint_group_region: The ID of the region where the endpoint group is deployed.
        :param pulumi.Input[str] endpoint_group_type: The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
               > **NOTE:** Only the listening instance of HTTP or HTTPS protocol supports the creation of virtual terminal node group.
        :param pulumi.Input[str] endpoint_request_protocol: The endpoint request protocol. Valid values: `HTTP`, `HTTPS`.
               > **NOTE:** This item is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. For the listening instance of HTTP protocol, the back-end service protocol supports and only supports HTTP.
        :param pulumi.Input[int] health_check_interval_seconds: The interval between two consecutive health checks. Unit: seconds.
        :param pulumi.Input[str] health_check_path: The path specified as the destination of the targets for health checks.
        :param pulumi.Input[int] health_check_port: The port that is used for health checks.
        :param pulumi.Input[str] health_check_protocol: The protocol that is used to connect to the targets for health checks. Valid values: `http`, `https`, `tcp`.
        :param pulumi.Input[str] listener_id: The ID of the listener that is associated with the endpoint group.
        :param pulumi.Input[str] name: The name of the endpoint group.
        :param pulumi.Input[pulumi.InputType['EndpointGroupPortOverridesArgs']] port_overrides: Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
               > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] threshold_count: The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
        :param pulumi.Input[int] traffic_percentage: The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EndpointGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Global Accelerator (GA) Endpoint Group resource.

        For information about Global Accelerator (GA) Endpoint Group and how to use it, see [What is Endpoint Group](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createendpointgroup).

        > **NOTE:** Available since v1.113.0.

        > **NOTE:** Listeners that use different protocols support different types of endpoint groups:

        * For a TCP or UDP listener, you can create only one default endpoint group.
        * For an HTTP or HTTPS listener, you can create one default endpoint group and one virtual endpoint group. By default, you can create only one virtual endpoint group.
          * A default endpoint group refers to the endpoint group that you configure when you create an HTTP or HTTPS listener.
          * A virtual endpoint group refers to the endpoint group that you can create on the Endpoint Group page after you create a listener.
        * After you create a virtual endpoint group for an HTTP or HTTPS listener, you can create a forwarding rule and associate the forwarding rule with the virtual endpoint group. Then, the HTTP or HTTPS listener forwards requests with different destination domain names or paths to the default or virtual endpoint group based on the forwarding rule. This way, you can use one Global Accelerator (GA) instance to accelerate access to multiple domain names or paths. For more information about how to create a forwarding rule, see [Manage forwarding rules](https://www.alibabacloud.com/help/en/doc-detail/204224.htm).

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        region = config.get("region")
        if region is None:
            region = "cn-hangzhou"
        default_accelerator = alicloud.ga.Accelerator("defaultAccelerator",
            duration=1,
            auto_use_coupon=True,
            spec="1")
        default_bandwidth_package = alicloud.ga.BandwidthPackage("defaultBandwidthPackage",
            bandwidth=100,
            type="Basic",
            bandwidth_type="Basic",
            payment_type="PayAsYouGo",
            billing_type="PayBy95",
            ratio=30)
        default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("defaultBandwidthPackageAttachment",
            accelerator_id=default_accelerator.id,
            bandwidth_package_id=default_bandwidth_package.id)
        default_listener = alicloud.ga.Listener("defaultListener",
            accelerator_id=default_bandwidth_package_attachment.accelerator_id,
            port_ranges=[alicloud.ga.ListenerPortRangeArgs(
                from_port=60,
                to_port=70,
            )],
            client_affinity="SOURCE_IP",
            protocol="UDP")
        default_eip_address = []
        for range in [{"value": i} for i in range(0, 2)]:
            default_eip_address.append(alicloud.ecs.EipAddress(f"defaultEipAddress-{range['value']}",
                bandwidth="10",
                internet_charge_type="PayByBandwidth",
                address_name="terraform-example"))
        default_endpoint_group = alicloud.ga.EndpointGroup("defaultEndpointGroup",
            accelerator_id=default_accelerator.id,
            endpoint_configurations=[
                alicloud.ga.EndpointGroupEndpointConfigurationArgs(
                    endpoint=default_eip_address[0].ip_address,
                    type="PublicIp",
                    weight=20,
                ),
                alicloud.ga.EndpointGroupEndpointConfigurationArgs(
                    endpoint=default_eip_address[1].ip_address,
                    type="PublicIp",
                    weight=20,
                ),
            ],
            endpoint_group_region=region,
            listener_id=default_listener.id)
        ```

        ## Import

        Ga Endpoint Group can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ga/endpointGroup:EndpointGroup example <id>
        ```

        :param str resource_name: The name of the resource.
        :param EndpointGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EndpointGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 endpoint_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointGroupEndpointConfigurationArgs']]]]] = None,
                 endpoint_group_region: Optional[pulumi.Input[str]] = None,
                 endpoint_group_type: Optional[pulumi.Input[str]] = None,
                 endpoint_request_protocol: Optional[pulumi.Input[str]] = None,
                 health_check_interval_seconds: Optional[pulumi.Input[int]] = None,
                 health_check_path: Optional[pulumi.Input[str]] = None,
                 health_check_port: Optional[pulumi.Input[int]] = None,
                 health_check_protocol: Optional[pulumi.Input[str]] = None,
                 listener_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port_overrides: Optional[pulumi.Input[pulumi.InputType['EndpointGroupPortOverridesArgs']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 threshold_count: Optional[pulumi.Input[int]] = None,
                 traffic_percentage: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EndpointGroupArgs.__new__(EndpointGroupArgs)

            if accelerator_id is None and not opts.urn:
                raise TypeError("Missing required property 'accelerator_id'")
            __props__.__dict__["accelerator_id"] = accelerator_id
            __props__.__dict__["description"] = description
            if endpoint_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_configurations'")
            __props__.__dict__["endpoint_configurations"] = endpoint_configurations
            if endpoint_group_region is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint_group_region'")
            __props__.__dict__["endpoint_group_region"] = endpoint_group_region
            __props__.__dict__["endpoint_group_type"] = endpoint_group_type
            __props__.__dict__["endpoint_request_protocol"] = endpoint_request_protocol
            __props__.__dict__["health_check_interval_seconds"] = health_check_interval_seconds
            __props__.__dict__["health_check_path"] = health_check_path
            __props__.__dict__["health_check_port"] = health_check_port
            __props__.__dict__["health_check_protocol"] = health_check_protocol
            if listener_id is None and not opts.urn:
                raise TypeError("Missing required property 'listener_id'")
            __props__.__dict__["listener_id"] = listener_id
            __props__.__dict__["name"] = name
            __props__.__dict__["port_overrides"] = port_overrides
            __props__.__dict__["tags"] = tags
            __props__.__dict__["threshold_count"] = threshold_count
            __props__.__dict__["traffic_percentage"] = traffic_percentage
            __props__.__dict__["endpoint_group_ip_lists"] = None
            __props__.__dict__["status"] = None
        super(EndpointGroup, __self__).__init__(
            'alicloud:ga/endpointGroup:EndpointGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerator_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            endpoint_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointGroupEndpointConfigurationArgs']]]]] = None,
            endpoint_group_ip_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            endpoint_group_region: Optional[pulumi.Input[str]] = None,
            endpoint_group_type: Optional[pulumi.Input[str]] = None,
            endpoint_request_protocol: Optional[pulumi.Input[str]] = None,
            health_check_interval_seconds: Optional[pulumi.Input[int]] = None,
            health_check_path: Optional[pulumi.Input[str]] = None,
            health_check_port: Optional[pulumi.Input[int]] = None,
            health_check_protocol: Optional[pulumi.Input[str]] = None,
            listener_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            port_overrides: Optional[pulumi.Input[pulumi.InputType['EndpointGroupPortOverridesArgs']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            threshold_count: Optional[pulumi.Input[int]] = None,
            traffic_percentage: Optional[pulumi.Input[int]] = None) -> 'EndpointGroup':
        """
        Get an existing EndpointGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accelerator_id: The ID of the Global Accelerator instance to which the endpoint group will be added.
        :param pulumi.Input[str] description: The description of the endpoint group.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EndpointGroupEndpointConfigurationArgs']]]] endpoint_configurations: The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoint_group_ip_lists: (Available since v1.213.0) The active endpoint IP addresses of the endpoint group. `endpoint_group_ip_list` will change with the growth of network traffic. You can run `pulumi up` to query the latest CIDR blocks and IP addresses.
        :param pulumi.Input[str] endpoint_group_region: The ID of the region where the endpoint group is deployed.
        :param pulumi.Input[str] endpoint_group_type: The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
               > **NOTE:** Only the listening instance of HTTP or HTTPS protocol supports the creation of virtual terminal node group.
        :param pulumi.Input[str] endpoint_request_protocol: The endpoint request protocol. Valid values: `HTTP`, `HTTPS`.
               > **NOTE:** This item is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. For the listening instance of HTTP protocol, the back-end service protocol supports and only supports HTTP.
        :param pulumi.Input[int] health_check_interval_seconds: The interval between two consecutive health checks. Unit: seconds.
        :param pulumi.Input[str] health_check_path: The path specified as the destination of the targets for health checks.
        :param pulumi.Input[int] health_check_port: The port that is used for health checks.
        :param pulumi.Input[str] health_check_protocol: The protocol that is used to connect to the targets for health checks. Valid values: `http`, `https`, `tcp`.
        :param pulumi.Input[str] listener_id: The ID of the listener that is associated with the endpoint group.
        :param pulumi.Input[str] name: The name of the endpoint group.
        :param pulumi.Input[pulumi.InputType['EndpointGroupPortOverridesArgs']] port_overrides: Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
               > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
        :param pulumi.Input[str] status: The status of the endpoint group.
        :param pulumi.Input[Mapping[str, Any]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[int] threshold_count: The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
        :param pulumi.Input[int] traffic_percentage: The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EndpointGroupState.__new__(_EndpointGroupState)

        __props__.__dict__["accelerator_id"] = accelerator_id
        __props__.__dict__["description"] = description
        __props__.__dict__["endpoint_configurations"] = endpoint_configurations
        __props__.__dict__["endpoint_group_ip_lists"] = endpoint_group_ip_lists
        __props__.__dict__["endpoint_group_region"] = endpoint_group_region
        __props__.__dict__["endpoint_group_type"] = endpoint_group_type
        __props__.__dict__["endpoint_request_protocol"] = endpoint_request_protocol
        __props__.__dict__["health_check_interval_seconds"] = health_check_interval_seconds
        __props__.__dict__["health_check_path"] = health_check_path
        __props__.__dict__["health_check_port"] = health_check_port
        __props__.__dict__["health_check_protocol"] = health_check_protocol
        __props__.__dict__["listener_id"] = listener_id
        __props__.__dict__["name"] = name
        __props__.__dict__["port_overrides"] = port_overrides
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["threshold_count"] = threshold_count
        __props__.__dict__["traffic_percentage"] = traffic_percentage
        return EndpointGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Output[str]:
        """
        The ID of the Global Accelerator instance to which the endpoint group will be added.
        """
        return pulumi.get(self, "accelerator_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the endpoint group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="endpointConfigurations")
    def endpoint_configurations(self) -> pulumi.Output[Sequence['outputs.EndpointGroupEndpointConfiguration']]:
        """
        The endpointConfigurations of the endpoint group. See `endpoint_configurations` below.
        """
        return pulumi.get(self, "endpoint_configurations")

    @property
    @pulumi.getter(name="endpointGroupIpLists")
    def endpoint_group_ip_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        (Available since v1.213.0) The active endpoint IP addresses of the endpoint group. `endpoint_group_ip_list` will change with the growth of network traffic. You can run `pulumi up` to query the latest CIDR blocks and IP addresses.
        """
        return pulumi.get(self, "endpoint_group_ip_lists")

    @property
    @pulumi.getter(name="endpointGroupRegion")
    def endpoint_group_region(self) -> pulumi.Output[str]:
        """
        The ID of the region where the endpoint group is deployed.
        """
        return pulumi.get(self, "endpoint_group_region")

    @property
    @pulumi.getter(name="endpointGroupType")
    def endpoint_group_type(self) -> pulumi.Output[str]:
        """
        The endpoint group type. Default value: `default`. Valid values: `default`, `virtual`.
        > **NOTE:** Only the listening instance of HTTP or HTTPS protocol supports the creation of virtual terminal node group.
        """
        return pulumi.get(self, "endpoint_group_type")

    @property
    @pulumi.getter(name="endpointRequestProtocol")
    def endpoint_request_protocol(self) -> pulumi.Output[str]:
        """
        The endpoint request protocol. Valid values: `HTTP`, `HTTPS`.
        > **NOTE:** This item is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. For the listening instance of HTTP protocol, the back-end service protocol supports and only supports HTTP.
        """
        return pulumi.get(self, "endpoint_request_protocol")

    @property
    @pulumi.getter(name="healthCheckIntervalSeconds")
    def health_check_interval_seconds(self) -> pulumi.Output[Optional[int]]:
        """
        The interval between two consecutive health checks. Unit: seconds.
        """
        return pulumi.get(self, "health_check_interval_seconds")

    @property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> pulumi.Output[Optional[str]]:
        """
        The path specified as the destination of the targets for health checks.
        """
        return pulumi.get(self, "health_check_path")

    @property
    @pulumi.getter(name="healthCheckPort")
    def health_check_port(self) -> pulumi.Output[Optional[int]]:
        """
        The port that is used for health checks.
        """
        return pulumi.get(self, "health_check_port")

    @property
    @pulumi.getter(name="healthCheckProtocol")
    def health_check_protocol(self) -> pulumi.Output[Optional[str]]:
        """
        The protocol that is used to connect to the targets for health checks. Valid values: `http`, `https`, `tcp`.
        """
        return pulumi.get(self, "health_check_protocol")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> pulumi.Output[str]:
        """
        The ID of the listener that is associated with the endpoint group.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the endpoint group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="portOverrides")
    def port_overrides(self) -> pulumi.Output[Optional['outputs.EndpointGroupPortOverrides']]:
        """
        Mapping between listening port and forwarding port of boarding point. See `port_overrides` below.
        > **NOTE:** Port mapping is only supported when creating terminal node group for listening instance of HTTP or HTTPS protocol. The listening port in the port map must be consistent with the listening port of the current listening instance.
        """
        return pulumi.get(self, "port_overrides")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the endpoint group.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="thresholdCount")
    def threshold_count(self) -> pulumi.Output[int]:
        """
        The number of consecutive failed heath checks that must occur before the endpoint is deemed unhealthy. Default value: `3`.
        """
        return pulumi.get(self, "threshold_count")

    @property
    @pulumi.getter(name="trafficPercentage")
    def traffic_percentage(self) -> pulumi.Output[Optional[int]]:
        """
        The weight of the endpoint group when the corresponding listener is associated with multiple endpoint groups.
        """
        return pulumi.get(self, "traffic_percentage")

