# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCustomRoutingEndpointGroupsResult',
    'AwaitableGetCustomRoutingEndpointGroupsResult',
    'get_custom_routing_endpoint_groups',
    'get_custom_routing_endpoint_groups_output',
]

@pulumi.output_type
class GetCustomRoutingEndpointGroupsResult:
    """
    A collection of values returned by getCustomRoutingEndpointGroups.
    """
    def __init__(__self__, accelerator_id=None, endpoint_group_id=None, groups=None, id=None, ids=None, listener_id=None, name_regex=None, names=None, output_file=None, page_number=None, page_size=None, status=None):
        if accelerator_id and not isinstance(accelerator_id, str):
            raise TypeError("Expected argument 'accelerator_id' to be a str")
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        if endpoint_group_id and not isinstance(endpoint_group_id, str):
            raise TypeError("Expected argument 'endpoint_group_id' to be a str")
        pulumi.set(__self__, "endpoint_group_id", endpoint_group_id)
        if groups and not isinstance(groups, list):
            raise TypeError("Expected argument 'groups' to be a list")
        pulumi.set(__self__, "groups", groups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if listener_id and not isinstance(listener_id, str):
            raise TypeError("Expected argument 'listener_id' to be a str")
        pulumi.set(__self__, "listener_id", listener_id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> str:
        """
        The ID of the GA instance.
        """
        return pulumi.get(self, "accelerator_id")

    @property
    @pulumi.getter(name="endpointGroupId")
    def endpoint_group_id(self) -> Optional[str]:
        """
        The ID of the Custom Routing Endpoint Group.
        """
        return pulumi.get(self, "endpoint_group_id")

    @property
    @pulumi.getter
    def groups(self) -> Sequence['outputs.GetCustomRoutingEndpointGroupsGroupResult']:
        """
        A list of Custom Routing Endpoint Groups. Each element contains the following attributes:
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="listenerId")
    def listener_id(self) -> Optional[str]:
        """
        The ID of the custom routing listener.
        """
        return pulumi.get(self, "listener_id")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        A list of Custom Routing Endpoint Group names.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[int]:
        return pulumi.get(self, "page_number")

    @property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[int]:
        return pulumi.get(self, "page_size")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the endpoint group.
        """
        return pulumi.get(self, "status")


class AwaitableGetCustomRoutingEndpointGroupsResult(GetCustomRoutingEndpointGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomRoutingEndpointGroupsResult(
            accelerator_id=self.accelerator_id,
            endpoint_group_id=self.endpoint_group_id,
            groups=self.groups,
            id=self.id,
            ids=self.ids,
            listener_id=self.listener_id,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            status=self.status)


def get_custom_routing_endpoint_groups(accelerator_id: Optional[str] = None,
                                       endpoint_group_id: Optional[str] = None,
                                       ids: Optional[Sequence[str]] = None,
                                       listener_id: Optional[str] = None,
                                       name_regex: Optional[str] = None,
                                       output_file: Optional[str] = None,
                                       page_number: Optional[int] = None,
                                       page_size: Optional[int] = None,
                                       status: Optional[str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomRoutingEndpointGroupsResult:
    """
    This data source provides the Global Accelerator (GA) Custom Routing Endpoint Groups of the current Alibaba Cloud user.

    > **NOTE:** Available in 1.197.0+

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ga.get_custom_routing_endpoint_groups(ids=["example_id"],
        accelerator_id="your_accelerator_id")
    pulumi.export("gaCustomRoutingEndpointGroupsId1", ids.groups[0].id)
    name_regex = alicloud.ga.get_custom_routing_endpoint_groups(name_regex="tf-example",
        accelerator_id="your_accelerator_id")
    pulumi.export("gaCustomRoutingEndpointGroupsId2", name_regex.groups[0].id)
    ```


    :param str accelerator_id: The ID of the GA instance.
    :param str endpoint_group_id: The ID of the endpoint group.
    :param Sequence[str] ids: A list of Custom Routing Endpoint Group IDs.
    :param str listener_id: The ID of the custom routing listener.
    :param str name_regex: A regex string to filter results by Custom Routing Endpoint Group name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The status of the endpoint group. Valid Values: `init`, `active`, `updating`, `deleting`.
    """
    __args__ = dict()
    __args__['acceleratorId'] = accelerator_id
    __args__['endpointGroupId'] = endpoint_group_id
    __args__['ids'] = ids
    __args__['listenerId'] = listener_id
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:ga/getCustomRoutingEndpointGroups:getCustomRoutingEndpointGroups', __args__, opts=opts, typ=GetCustomRoutingEndpointGroupsResult).value

    return AwaitableGetCustomRoutingEndpointGroupsResult(
        accelerator_id=pulumi.get(__ret__, 'accelerator_id'),
        endpoint_group_id=pulumi.get(__ret__, 'endpoint_group_id'),
        groups=pulumi.get(__ret__, 'groups'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        listener_id=pulumi.get(__ret__, 'listener_id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_custom_routing_endpoint_groups)
def get_custom_routing_endpoint_groups_output(accelerator_id: Optional[pulumi.Input[str]] = None,
                                              endpoint_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                              ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                              listener_id: Optional[pulumi.Input[Optional[str]]] = None,
                                              name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                                              output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                              page_number: Optional[pulumi.Input[Optional[int]]] = None,
                                              page_size: Optional[pulumi.Input[Optional[int]]] = None,
                                              status: Optional[pulumi.Input[Optional[str]]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCustomRoutingEndpointGroupsResult]:
    """
    This data source provides the Global Accelerator (GA) Custom Routing Endpoint Groups of the current Alibaba Cloud user.

    > **NOTE:** Available in 1.197.0+

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.ga.get_custom_routing_endpoint_groups(ids=["example_id"],
        accelerator_id="your_accelerator_id")
    pulumi.export("gaCustomRoutingEndpointGroupsId1", ids.groups[0].id)
    name_regex = alicloud.ga.get_custom_routing_endpoint_groups(name_regex="tf-example",
        accelerator_id="your_accelerator_id")
    pulumi.export("gaCustomRoutingEndpointGroupsId2", name_regex.groups[0].id)
    ```


    :param str accelerator_id: The ID of the GA instance.
    :param str endpoint_group_id: The ID of the endpoint group.
    :param Sequence[str] ids: A list of Custom Routing Endpoint Group IDs.
    :param str listener_id: The ID of the custom routing listener.
    :param str name_regex: A regex string to filter results by Custom Routing Endpoint Group name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The status of the endpoint group. Valid Values: `init`, `active`, `updating`, `deleting`.
    """
    ...
