# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ListenerArgs', 'Listener']

@pulumi.input_type
class ListenerArgs:
    def __init__(__self__, *,
                 accelerator_id: pulumi.Input[str],
                 port_ranges: pulumi.Input[Sequence[pulumi.Input['ListenerPortRangeArgs']]],
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCertificateArgs']]]] = None,
                 client_affinity: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 forwarded_for_config: Optional[pulumi.Input['ListenerForwardedForConfigArgs']] = None,
                 listener_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Listener resource.
        :param pulumi.Input[str] accelerator_id: The accelerator id.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerPortRangeArgs']]] port_ranges: The portRanges of the listener. See `port_ranges` below.
               > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerCertificateArgs']]] certificates: The certificates of the listener. See `certificates` below.
               > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
        :param pulumi.Input[str] client_affinity: The clientAffinity of the listener. Default value: `NONE`. Valid values:
        :param pulumi.Input[str] description: The description of the listener.
        :param pulumi.Input['ListenerForwardedForConfigArgs'] forwarded_for_config: The XForward headers. See `forwarded_for_config` below.
        :param pulumi.Input[str] listener_type: The routing type of the listener. Default Value: `Standard`. Valid values:
        :param pulumi.Input[str] name: The name of the listener. The length of the name is 2-128 characters. It starts with uppercase and lowercase letters or Chinese characters. It can contain numbers and underscores and dashes.
        :param pulumi.Input[str] protocol: Type of network transport protocol monitored. Default value: `TCP`. Valid values: `TCP`, `UDP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[bool] proxy_protocol: The proxy protocol of the listener. Default value: `false`. Valid values:
        :param pulumi.Input[str] security_policy_id: The ID of the security policy. **NOTE:** Only `HTTPS` listeners support this parameter. Valid values:
        """
        pulumi.set(__self__, "accelerator_id", accelerator_id)
        pulumi.set(__self__, "port_ranges", port_ranges)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if client_affinity is not None:
            pulumi.set(__self__, "client_affinity", client_affinity)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if forwarded_for_config is not None:
            pulumi.set(__self__, "forwarded_for_config", forwarded_for_config)
        if listener_type is not None:
            pulumi.set(__self__, "listener_type", listener_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if proxy_protocol is not None:
            pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)

    @property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Input[str]:
        """
        The accelerator id.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "accelerator_id", value)

    @property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> pulumi.Input[Sequence[pulumi.Input['ListenerPortRangeArgs']]]:
        """
        The portRanges of the listener. See `port_ranges` below.
        > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
        """
        return pulumi.get(self, "port_ranges")

    @port_ranges.setter
    def port_ranges(self, value: pulumi.Input[Sequence[pulumi.Input['ListenerPortRangeArgs']]]):
        pulumi.set(self, "port_ranges", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCertificateArgs']]]]:
        """
        The certificates of the listener. See `certificates` below.
        > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter(name="clientAffinity")
    def client_affinity(self) -> Optional[pulumi.Input[str]]:
        """
        The clientAffinity of the listener. Default value: `NONE`. Valid values:
        """
        return pulumi.get(self, "client_affinity")

    @client_affinity.setter
    def client_affinity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_affinity", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="forwardedForConfig")
    def forwarded_for_config(self) -> Optional[pulumi.Input['ListenerForwardedForConfigArgs']]:
        """
        The XForward headers. See `forwarded_for_config` below.
        """
        return pulumi.get(self, "forwarded_for_config")

    @forwarded_for_config.setter
    def forwarded_for_config(self, value: Optional[pulumi.Input['ListenerForwardedForConfigArgs']]):
        pulumi.set(self, "forwarded_for_config", value)

    @property
    @pulumi.getter(name="listenerType")
    def listener_type(self) -> Optional[pulumi.Input[str]]:
        """
        The routing type of the listener. Default Value: `Standard`. Valid values:
        """
        return pulumi.get(self, "listener_type")

    @listener_type.setter
    def listener_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the listener. The length of the name is 2-128 characters. It starts with uppercase and lowercase letters or Chinese characters. It can contain numbers and underscores and dashes.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Type of network transport protocol monitored. Default value: `TCP`. Valid values: `TCP`, `UDP`, `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> Optional[pulumi.Input[bool]]:
        """
        The proxy protocol of the listener. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "proxy_protocol")

    @proxy_protocol.setter
    def proxy_protocol(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proxy_protocol", value)

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security policy. **NOTE:** Only `HTTPS` listeners support this parameter. Valid values:
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy_id", value)


@pulumi.input_type
class _ListenerState:
    def __init__(__self__, *,
                 accelerator_id: Optional[pulumi.Input[str]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCertificateArgs']]]] = None,
                 client_affinity: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 forwarded_for_config: Optional[pulumi.Input['ListenerForwardedForConfigArgs']] = None,
                 listener_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerPortRangeArgs']]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Listener resources.
        :param pulumi.Input[str] accelerator_id: The accelerator id.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerCertificateArgs']]] certificates: The certificates of the listener. See `certificates` below.
               > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
        :param pulumi.Input[str] client_affinity: The clientAffinity of the listener. Default value: `NONE`. Valid values:
        :param pulumi.Input[str] description: The description of the listener.
        :param pulumi.Input['ListenerForwardedForConfigArgs'] forwarded_for_config: The XForward headers. See `forwarded_for_config` below.
        :param pulumi.Input[str] listener_type: The routing type of the listener. Default Value: `Standard`. Valid values:
        :param pulumi.Input[str] name: The name of the listener. The length of the name is 2-128 characters. It starts with uppercase and lowercase letters or Chinese characters. It can contain numbers and underscores and dashes.
        :param pulumi.Input[Sequence[pulumi.Input['ListenerPortRangeArgs']]] port_ranges: The portRanges of the listener. See `port_ranges` below.
               > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
        :param pulumi.Input[str] protocol: Type of network transport protocol monitored. Default value: `TCP`. Valid values: `TCP`, `UDP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[bool] proxy_protocol: The proxy protocol of the listener. Default value: `false`. Valid values:
        :param pulumi.Input[str] security_policy_id: The ID of the security policy. **NOTE:** Only `HTTPS` listeners support this parameter. Valid values:
        :param pulumi.Input[str] status: The status of the listener.
        """
        if accelerator_id is not None:
            pulumi.set(__self__, "accelerator_id", accelerator_id)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if client_affinity is not None:
            pulumi.set(__self__, "client_affinity", client_affinity)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if forwarded_for_config is not None:
            pulumi.set(__self__, "forwarded_for_config", forwarded_for_config)
        if listener_type is not None:
            pulumi.set(__self__, "listener_type", listener_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if port_ranges is not None:
            pulumi.set(__self__, "port_ranges", port_ranges)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if proxy_protocol is not None:
            pulumi.set(__self__, "proxy_protocol", proxy_protocol)
        if security_policy_id is not None:
            pulumi.set(__self__, "security_policy_id", security_policy_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> Optional[pulumi.Input[str]]:
        """
        The accelerator id.
        """
        return pulumi.get(self, "accelerator_id")

    @accelerator_id.setter
    def accelerator_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accelerator_id", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCertificateArgs']]]]:
        """
        The certificates of the listener. See `certificates` below.
        > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerCertificateArgs']]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter(name="clientAffinity")
    def client_affinity(self) -> Optional[pulumi.Input[str]]:
        """
        The clientAffinity of the listener. Default value: `NONE`. Valid values:
        """
        return pulumi.get(self, "client_affinity")

    @client_affinity.setter
    def client_affinity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_affinity", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the listener.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="forwardedForConfig")
    def forwarded_for_config(self) -> Optional[pulumi.Input['ListenerForwardedForConfigArgs']]:
        """
        The XForward headers. See `forwarded_for_config` below.
        """
        return pulumi.get(self, "forwarded_for_config")

    @forwarded_for_config.setter
    def forwarded_for_config(self, value: Optional[pulumi.Input['ListenerForwardedForConfigArgs']]):
        pulumi.set(self, "forwarded_for_config", value)

    @property
    @pulumi.getter(name="listenerType")
    def listener_type(self) -> Optional[pulumi.Input[str]]:
        """
        The routing type of the listener. Default Value: `Standard`. Valid values:
        """
        return pulumi.get(self, "listener_type")

    @listener_type.setter
    def listener_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listener_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the listener. The length of the name is 2-128 characters. It starts with uppercase and lowercase letters or Chinese characters. It can contain numbers and underscores and dashes.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ListenerPortRangeArgs']]]]:
        """
        The portRanges of the listener. See `port_ranges` below.
        > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
        """
        return pulumi.get(self, "port_ranges")

    @port_ranges.setter
    def port_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ListenerPortRangeArgs']]]]):
        pulumi.set(self, "port_ranges", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Type of network transport protocol monitored. Default value: `TCP`. Valid values: `TCP`, `UDP`, `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> Optional[pulumi.Input[bool]]:
        """
        The proxy protocol of the listener. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "proxy_protocol")

    @proxy_protocol.setter
    def proxy_protocol(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proxy_protocol", value)

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the security policy. **NOTE:** Only `HTTPS` listeners support this parameter. Valid values:
        """
        return pulumi.get(self, "security_policy_id")

    @security_policy_id.setter
    def security_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the listener.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class Listener(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_id: Optional[pulumi.Input[str]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerCertificateArgs']]]]] = None,
                 client_affinity: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 forwarded_for_config: Optional[pulumi.Input[pulumi.InputType['ListenerForwardedForConfigArgs']]] = None,
                 listener_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerPortRangeArgs']]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a Global Accelerator (GA) Listener resource.

        For information about Global Accelerator (GA) Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createlistener).

        > **NOTE:** Available since v1.111.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_accelerator = alicloud.ga.Accelerator("defaultAccelerator",
            duration=1,
            auto_use_coupon=True,
            spec="1")
        default_bandwidth_package = alicloud.ga.BandwidthPackage("defaultBandwidthPackage",
            bandwidth=100,
            type="Basic",
            bandwidth_type="Basic",
            payment_type="PayAsYouGo",
            billing_type="PayBy95",
            ratio=30)
        default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("defaultBandwidthPackageAttachment",
            accelerator_id=default_accelerator.id,
            bandwidth_package_id=default_bandwidth_package.id)
        default_listener = alicloud.ga.Listener("defaultListener",
            accelerator_id=default_bandwidth_package_attachment.accelerator_id,
            port_ranges=[alicloud.ga.ListenerPortRangeArgs(
                from_port=80,
                to_port=80,
            )])
        ```

        ## Import

        Ga Listener can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ga/listener:Listener example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accelerator_id: The accelerator id.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerCertificateArgs']]]] certificates: The certificates of the listener. See `certificates` below.
               > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
        :param pulumi.Input[str] client_affinity: The clientAffinity of the listener. Default value: `NONE`. Valid values:
        :param pulumi.Input[str] description: The description of the listener.
        :param pulumi.Input[pulumi.InputType['ListenerForwardedForConfigArgs']] forwarded_for_config: The XForward headers. See `forwarded_for_config` below.
        :param pulumi.Input[str] listener_type: The routing type of the listener. Default Value: `Standard`. Valid values:
        :param pulumi.Input[str] name: The name of the listener. The length of the name is 2-128 characters. It starts with uppercase and lowercase letters or Chinese characters. It can contain numbers and underscores and dashes.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerPortRangeArgs']]]] port_ranges: The portRanges of the listener. See `port_ranges` below.
               > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
        :param pulumi.Input[str] protocol: Type of network transport protocol monitored. Default value: `TCP`. Valid values: `TCP`, `UDP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[bool] proxy_protocol: The proxy protocol of the listener. Default value: `false`. Valid values:
        :param pulumi.Input[str] security_policy_id: The ID of the security policy. **NOTE:** Only `HTTPS` listeners support this parameter. Valid values:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ListenerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Global Accelerator (GA) Listener resource.

        For information about Global Accelerator (GA) Listener and how to use it, see [What is Listener](https://www.alibabacloud.com/help/en/global-accelerator/latest/api-ga-2019-11-20-createlistener).

        > **NOTE:** Available since v1.111.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        default_accelerator = alicloud.ga.Accelerator("defaultAccelerator",
            duration=1,
            auto_use_coupon=True,
            spec="1")
        default_bandwidth_package = alicloud.ga.BandwidthPackage("defaultBandwidthPackage",
            bandwidth=100,
            type="Basic",
            bandwidth_type="Basic",
            payment_type="PayAsYouGo",
            billing_type="PayBy95",
            ratio=30)
        default_bandwidth_package_attachment = alicloud.ga.BandwidthPackageAttachment("defaultBandwidthPackageAttachment",
            accelerator_id=default_accelerator.id,
            bandwidth_package_id=default_bandwidth_package.id)
        default_listener = alicloud.ga.Listener("defaultListener",
            accelerator_id=default_bandwidth_package_attachment.accelerator_id,
            port_ranges=[alicloud.ga.ListenerPortRangeArgs(
                from_port=80,
                to_port=80,
            )])
        ```

        ## Import

        Ga Listener can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:ga/listener:Listener example <id>
        ```

        :param str resource_name: The name of the resource.
        :param ListenerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ListenerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_id: Optional[pulumi.Input[str]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerCertificateArgs']]]]] = None,
                 client_affinity: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 forwarded_for_config: Optional[pulumi.Input[pulumi.InputType['ListenerForwardedForConfigArgs']]] = None,
                 listener_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerPortRangeArgs']]]]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 proxy_protocol: Optional[pulumi.Input[bool]] = None,
                 security_policy_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ListenerArgs.__new__(ListenerArgs)

            if accelerator_id is None and not opts.urn:
                raise TypeError("Missing required property 'accelerator_id'")
            __props__.__dict__["accelerator_id"] = accelerator_id
            __props__.__dict__["certificates"] = certificates
            __props__.__dict__["client_affinity"] = client_affinity
            __props__.__dict__["description"] = description
            __props__.__dict__["forwarded_for_config"] = forwarded_for_config
            __props__.__dict__["listener_type"] = listener_type
            __props__.__dict__["name"] = name
            if port_ranges is None and not opts.urn:
                raise TypeError("Missing required property 'port_ranges'")
            __props__.__dict__["port_ranges"] = port_ranges
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["proxy_protocol"] = proxy_protocol
            __props__.__dict__["security_policy_id"] = security_policy_id
            __props__.__dict__["status"] = None
        super(Listener, __self__).__init__(
            'alicloud:ga/listener:Listener',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerator_id: Optional[pulumi.Input[str]] = None,
            certificates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerCertificateArgs']]]]] = None,
            client_affinity: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            forwarded_for_config: Optional[pulumi.Input[pulumi.InputType['ListenerForwardedForConfigArgs']]] = None,
            listener_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            port_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerPortRangeArgs']]]]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            proxy_protocol: Optional[pulumi.Input[bool]] = None,
            security_policy_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'Listener':
        """
        Get an existing Listener resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accelerator_id: The accelerator id.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerCertificateArgs']]]] certificates: The certificates of the listener. See `certificates` below.
               > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
        :param pulumi.Input[str] client_affinity: The clientAffinity of the listener. Default value: `NONE`. Valid values:
        :param pulumi.Input[str] description: The description of the listener.
        :param pulumi.Input[pulumi.InputType['ListenerForwardedForConfigArgs']] forwarded_for_config: The XForward headers. See `forwarded_for_config` below.
        :param pulumi.Input[str] listener_type: The routing type of the listener. Default Value: `Standard`. Valid values:
        :param pulumi.Input[str] name: The name of the listener. The length of the name is 2-128 characters. It starts with uppercase and lowercase letters or Chinese characters. It can contain numbers and underscores and dashes.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ListenerPortRangeArgs']]]] port_ranges: The portRanges of the listener. See `port_ranges` below.
               > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
        :param pulumi.Input[str] protocol: Type of network transport protocol monitored. Default value: `TCP`. Valid values: `TCP`, `UDP`, `HTTP`, `HTTPS`.
        :param pulumi.Input[bool] proxy_protocol: The proxy protocol of the listener. Default value: `false`. Valid values:
        :param pulumi.Input[str] security_policy_id: The ID of the security policy. **NOTE:** Only `HTTPS` listeners support this parameter. Valid values:
        :param pulumi.Input[str] status: The status of the listener.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ListenerState.__new__(_ListenerState)

        __props__.__dict__["accelerator_id"] = accelerator_id
        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["client_affinity"] = client_affinity
        __props__.__dict__["description"] = description
        __props__.__dict__["forwarded_for_config"] = forwarded_for_config
        __props__.__dict__["listener_type"] = listener_type
        __props__.__dict__["name"] = name
        __props__.__dict__["port_ranges"] = port_ranges
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["proxy_protocol"] = proxy_protocol
        __props__.__dict__["security_policy_id"] = security_policy_id
        __props__.__dict__["status"] = status
        return Listener(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceleratorId")
    def accelerator_id(self) -> pulumi.Output[str]:
        """
        The accelerator id.
        """
        return pulumi.get(self, "accelerator_id")

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Optional[Sequence['outputs.ListenerCertificate']]]:
        """
        The certificates of the listener. See `certificates` below.
        > **NOTE:** This parameter needs to be configured only for monitoring of the `HTTPS` protocol.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="clientAffinity")
    def client_affinity(self) -> pulumi.Output[Optional[str]]:
        """
        The clientAffinity of the listener. Default value: `NONE`. Valid values:
        """
        return pulumi.get(self, "client_affinity")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the listener.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="forwardedForConfig")
    def forwarded_for_config(self) -> pulumi.Output[Optional['outputs.ListenerForwardedForConfig']]:
        """
        The XForward headers. See `forwarded_for_config` below.
        """
        return pulumi.get(self, "forwarded_for_config")

    @property
    @pulumi.getter(name="listenerType")
    def listener_type(self) -> pulumi.Output[str]:
        """
        The routing type of the listener. Default Value: `Standard`. Valid values:
        """
        return pulumi.get(self, "listener_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the listener. The length of the name is 2-128 characters. It starts with uppercase and lowercase letters or Chinese characters. It can contain numbers and underscores and dashes.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="portRanges")
    def port_ranges(self) -> pulumi.Output[Sequence['outputs.ListenerPortRange']]:
        """
        The portRanges of the listener. See `port_ranges` below.
        > **NOTE:** For `HTTP` or `HTTPS` protocol monitoring, only one monitoring port can be configured, that is, the start monitoring port and end monitoring port should be the same.
        """
        return pulumi.get(self, "port_ranges")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[str]]:
        """
        Type of network transport protocol monitored. Default value: `TCP`. Valid values: `TCP`, `UDP`, `HTTP`, `HTTPS`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="proxyProtocol")
    def proxy_protocol(self) -> pulumi.Output[Optional[bool]]:
        """
        The proxy protocol of the listener. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "proxy_protocol")

    @property
    @pulumi.getter(name="securityPolicyId")
    def security_policy_id(self) -> pulumi.Output[str]:
        """
        The ID of the security policy. **NOTE:** Only `HTTPS` listeners support this parameter. Valid values:
        """
        return pulumi.get(self, "security_policy_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the listener.
        """
        return pulumi.get(self, "status")

