# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbInstancePlansResult',
    'AwaitableGetDbInstancePlansResult',
    'get_db_instance_plans',
    'get_db_instance_plans_output',
]

@pulumi.output_type
class GetDbInstancePlansResult:
    """
    A collection of values returned by getDbInstancePlans.
    """
    def __init__(__self__, db_instance_id=None, id=None, ids=None, name_regex=None, names=None, output_file=None, plan_schedule_type=None, plan_type=None, plans=None, status=None):
        if db_instance_id and not isinstance(db_instance_id, str):
            raise TypeError("Expected argument 'db_instance_id' to be a str")
        pulumi.set(__self__, "db_instance_id", db_instance_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if plan_schedule_type and not isinstance(plan_schedule_type, str):
            raise TypeError("Expected argument 'plan_schedule_type' to be a str")
        pulumi.set(__self__, "plan_schedule_type", plan_schedule_type)
        if plan_type and not isinstance(plan_type, str):
            raise TypeError("Expected argument 'plan_type' to be a str")
        pulumi.set(__self__, "plan_type", plan_type)
        if plans and not isinstance(plans, list):
            raise TypeError("Expected argument 'plans' to be a list")
        pulumi.set(__self__, "plans", plans)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="dbInstanceId")
    def db_instance_id(self) -> str:
        return pulumi.get(self, "db_instance_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="planScheduleType")
    def plan_schedule_type(self) -> Optional[str]:
        return pulumi.get(self, "plan_schedule_type")

    @property
    @pulumi.getter(name="planType")
    def plan_type(self) -> Optional[str]:
        return pulumi.get(self, "plan_type")

    @property
    @pulumi.getter
    def plans(self) -> Sequence['outputs.GetDbInstancePlansPlanResult']:
        return pulumi.get(self, "plans")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")


class AwaitableGetDbInstancePlansResult(GetDbInstancePlansResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbInstancePlansResult(
            db_instance_id=self.db_instance_id,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            plan_schedule_type=self.plan_schedule_type,
            plan_type=self.plan_type,
            plans=self.plans,
            status=self.status)


def get_db_instance_plans(db_instance_id: Optional[str] = None,
                          ids: Optional[Sequence[str]] = None,
                          name_regex: Optional[str] = None,
                          output_file: Optional[str] = None,
                          plan_schedule_type: Optional[str] = None,
                          plan_type: Optional[str] = None,
                          status: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbInstancePlansResult:
    """
    This data source provides the Gpdb Db Instance Plans of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.189.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.gpdb.get_db_instance_plans(db_instance_id="example_value",
        ids=["example_value"])
    pulumi.export("gpdbDbInstancePlanId1", ids.plans[0].id)
    name_regex = alicloud.gpdb.get_db_instance_plans(db_instance_id="example_value",
        name_regex="^my-DBInstancePlan")
    pulumi.export("gpdbDbInstancePlanId2", name_regex.plans[0].id)
    ```


    :param str db_instance_id: The ID of the Database instance.
    :param Sequence[str] ids: A list of DB Instance Plan IDs.
    :param str name_regex: A regex string to filter results by DB Instance Plan name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str plan_schedule_type: Plan scheduling type. Valid values: `Postpone`, `Regular`.
    :param str plan_type: The type of the Plan. Valid values: `PauseResume`, `Resize`.
    :param str status: The Status of the Plan.
    """
    __args__ = dict()
    __args__['dbInstanceId'] = db_instance_id
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['planScheduleType'] = plan_schedule_type
    __args__['planType'] = plan_type
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:gpdb/getDbInstancePlans:getDbInstancePlans', __args__, opts=opts, typ=GetDbInstancePlansResult).value

    return AwaitableGetDbInstancePlansResult(
        db_instance_id=pulumi.get(__ret__, 'db_instance_id'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        plan_schedule_type=pulumi.get(__ret__, 'plan_schedule_type'),
        plan_type=pulumi.get(__ret__, 'plan_type'),
        plans=pulumi.get(__ret__, 'plans'),
        status=pulumi.get(__ret__, 'status'))


@_utilities.lift_output_func(get_db_instance_plans)
def get_db_instance_plans_output(db_instance_id: Optional[pulumi.Input[str]] = None,
                                 ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                 name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                                 output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                 plan_schedule_type: Optional[pulumi.Input[Optional[str]]] = None,
                                 plan_type: Optional[pulumi.Input[Optional[str]]] = None,
                                 status: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbInstancePlansResult]:
    """
    This data source provides the Gpdb Db Instance Plans of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.189.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.gpdb.get_db_instance_plans(db_instance_id="example_value",
        ids=["example_value"])
    pulumi.export("gpdbDbInstancePlanId1", ids.plans[0].id)
    name_regex = alicloud.gpdb.get_db_instance_plans(db_instance_id="example_value",
        name_regex="^my-DBInstancePlan")
    pulumi.export("gpdbDbInstancePlanId2", name_regex.plans[0].id)
    ```


    :param str db_instance_id: The ID of the Database instance.
    :param Sequence[str] ids: A list of DB Instance Plan IDs.
    :param str name_regex: A regex string to filter results by DB Instance Plan name.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str plan_schedule_type: Plan scheduling type. Valid values: `Postpone`, `Regular`.
    :param str plan_type: The type of the Plan. Valid values: `PauseResume`, `Resize`.
    :param str status: The Status of the Plan.
    """
    ...
