# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetHanaBackupClientsResult',
    'AwaitableGetHanaBackupClientsResult',
    'get_hana_backup_clients',
    'get_hana_backup_clients_output',
]

@pulumi.output_type
class GetHanaBackupClientsResult:
    """
    A collection of values returned by getHanaBackupClients.
    """
    def __init__(__self__, client_id=None, cluster_id=None, hana_backup_clients=None, id=None, ids=None, output_file=None, page_number=None, page_size=None, status=None, vault_id=None):
        if client_id and not isinstance(client_id, str):
            raise TypeError("Expected argument 'client_id' to be a str")
        pulumi.set(__self__, "client_id", client_id)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if hana_backup_clients and not isinstance(hana_backup_clients, list):
            raise TypeError("Expected argument 'hana_backup_clients' to be a list")
        pulumi.set(__self__, "hana_backup_clients", hana_backup_clients)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[str]:
        """
        The ID of the backup client.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[str]:
        """
        The ID of the SAP HANA instance.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="hanaBackupClients")
    def hana_backup_clients(self) -> Sequence['outputs.GetHanaBackupClientsHanaBackupClientResult']:
        """
        A list of Hana Backup Clients. Each element contains the following attributes:
        """
        return pulumi.get(self, "hana_backup_clients")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> Optional[int]:
        return pulumi.get(self, "page_number")

    @property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> Optional[int]:
        return pulumi.get(self, "page_size")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the backup client.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The ID of the backup vault.
        """
        return pulumi.get(self, "vault_id")


class AwaitableGetHanaBackupClientsResult(GetHanaBackupClientsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHanaBackupClientsResult(
            client_id=self.client_id,
            cluster_id=self.cluster_id,
            hana_backup_clients=self.hana_backup_clients,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            status=self.status,
            vault_id=self.vault_id)


def get_hana_backup_clients(client_id: Optional[str] = None,
                            cluster_id: Optional[str] = None,
                            ids: Optional[Sequence[str]] = None,
                            output_file: Optional[str] = None,
                            page_number: Optional[int] = None,
                            page_size: Optional[int] = None,
                            status: Optional[str] = None,
                            vault_id: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHanaBackupClientsResult:
    """
    This data source provides the Hybrid Backup Recovery (HBR) Hana Backup Clients of the current Alibaba Cloud user.

    > **NOTE:** Available in 1.198.0+

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.hbr.get_hana_backup_clients(ids=["example_id"],
        vault_id="your_vault_id")
    pulumi.export("hbrHanaBackupClientsId1", ids.hana_backup_clients[0].id)
    ```


    :param str client_id: The ID of the backup client.
    :param str cluster_id: The ID of the SAP HANA instance.
    :param Sequence[str] ids: A list of Hana Backup Client IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The status of the Hana Backup Client. Valid Values: `REGISTERED`, `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `UPGRADING`, `UPGRADE_FAILED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `STOPPED`, `UNKNOWN`.
    :param str vault_id: The ID of the backup vault.
    """
    __args__ = dict()
    __args__['clientId'] = client_id
    __args__['clusterId'] = cluster_id
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['status'] = status
    __args__['vaultId'] = vault_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:hbr/getHanaBackupClients:getHanaBackupClients', __args__, opts=opts, typ=GetHanaBackupClientsResult).value

    return AwaitableGetHanaBackupClientsResult(
        client_id=pulumi.get(__ret__, 'client_id'),
        cluster_id=pulumi.get(__ret__, 'cluster_id'),
        hana_backup_clients=pulumi.get(__ret__, 'hana_backup_clients'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        status=pulumi.get(__ret__, 'status'),
        vault_id=pulumi.get(__ret__, 'vault_id'))


@_utilities.lift_output_func(get_hana_backup_clients)
def get_hana_backup_clients_output(client_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   cluster_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                   output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                   page_number: Optional[pulumi.Input[Optional[int]]] = None,
                                   page_size: Optional[pulumi.Input[Optional[int]]] = None,
                                   status: Optional[pulumi.Input[Optional[str]]] = None,
                                   vault_id: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHanaBackupClientsResult]:
    """
    This data source provides the Hybrid Backup Recovery (HBR) Hana Backup Clients of the current Alibaba Cloud user.

    > **NOTE:** Available in 1.198.0+

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    ids = alicloud.hbr.get_hana_backup_clients(ids=["example_id"],
        vault_id="your_vault_id")
    pulumi.export("hbrHanaBackupClientsId1", ids.hana_backup_clients[0].id)
    ```


    :param str client_id: The ID of the backup client.
    :param str cluster_id: The ID of the SAP HANA instance.
    :param Sequence[str] ids: A list of Hana Backup Client IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    :param str status: The status of the Hana Backup Client. Valid Values: `REGISTERED`, `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `UPGRADING`, `UPGRADE_FAILED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `STOPPED`, `UNKNOWN`.
    :param str vault_id: The ID of the backup vault.
    """
    ...
