# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetReplicationVaultRegionsResult',
    'AwaitableGetReplicationVaultRegionsResult',
    'get_replication_vault_regions',
    'get_replication_vault_regions_output',
]

@pulumi.output_type
class GetReplicationVaultRegionsResult:
    """
    A collection of values returned by getReplicationVaultRegions.
    """
    def __init__(__self__, id=None, output_file=None, regions=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if regions and not isinstance(regions, list):
            raise TypeError("Expected argument 'regions' to be a list")
        pulumi.set(__self__, "regions", regions)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def regions(self) -> Sequence['outputs.GetReplicationVaultRegionsRegionResult']:
        return pulumi.get(self, "regions")


class AwaitableGetReplicationVaultRegionsResult(GetReplicationVaultRegionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetReplicationVaultRegionsResult(
            id=self.id,
            output_file=self.output_file,
            regions=self.regions)


def get_replication_vault_regions(output_file: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetReplicationVaultRegionsResult:
    """
    This data source provides the HBR Replication Vault Regions of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.152.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.hbr.get_replication_vault_regions()
    pulumi.export("hbrReplicationVaultRegionRegionId1", default.regions[0].replication_region_id)
    ```


    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:hbr/getReplicationVaultRegions:getReplicationVaultRegions', __args__, opts=opts, typ=GetReplicationVaultRegionsResult).value

    return AwaitableGetReplicationVaultRegionsResult(
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        regions=pulumi.get(__ret__, 'regions'))


@_utilities.lift_output_func(get_replication_vault_regions)
def get_replication_vault_regions_output(output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetReplicationVaultRegionsResult]:
    """
    This data source provides the HBR Replication Vault Regions of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.152.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.hbr.get_replication_vault_regions()
    pulumi.export("hbrReplicationVaultRegionRegionId1", default.regions[0].replication_region_id)
    ```


    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    ...
