# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetServerBackupPlansResult',
    'AwaitableGetServerBackupPlansResult',
    'get_server_backup_plans',
    'get_server_backup_plans_output',
]

@pulumi.output_type
class GetServerBackupPlansResult:
    """
    A collection of values returned by getServerBackupPlans.
    """
    def __init__(__self__, filters=None, id=None, ids=None, output_file=None, plans=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if plans and not isinstance(plans, list):
            raise TypeError("Expected argument 'plans' to be a list")
        pulumi.set(__self__, "plans", plans)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetServerBackupPlansFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def plans(self) -> Sequence['outputs.GetServerBackupPlansPlanResult']:
        return pulumi.get(self, "plans")


class AwaitableGetServerBackupPlansResult(GetServerBackupPlansResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerBackupPlansResult(
            filters=self.filters,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            plans=self.plans)


def get_server_backup_plans(filters: Optional[Sequence[pulumi.InputType['GetServerBackupPlansFilterArgs']]] = None,
                            ids: Optional[Sequence[str]] = None,
                            output_file: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerBackupPlansResult:
    """
    This data source provides the Hbr Server Backup Plans of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.142.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.ecs.get_instances(name_regex="no-deleteing-hbr-ecs-server-backup-plan",
        status="Running")
    ids = alicloud.hbr.get_server_backup_plans(filters=[alicloud.hbr.GetServerBackupPlansFilterArgs(
        key="instanceId",
        values=[default.instances[0].id],
    )])
    pulumi.export("hbrServerBackupPlanId1", ids.plans[0].id)
    ```


    :param Sequence[pulumi.InputType['GetServerBackupPlansFilterArgs']] filters: The filters.
    :param Sequence[str] ids: A list of Server Backup Plan IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('alicloud:hbr/getServerBackupPlans:getServerBackupPlans', __args__, opts=opts, typ=GetServerBackupPlansResult).value

    return AwaitableGetServerBackupPlansResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        plans=pulumi.get(__ret__, 'plans'))


@_utilities.lift_output_func(get_server_backup_plans)
def get_server_backup_plans_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetServerBackupPlansFilterArgs']]]]] = None,
                                   ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                   output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServerBackupPlansResult]:
    """
    This data source provides the Hbr Server Backup Plans of the current Alibaba Cloud user.

    > **NOTE:** Available in v1.142.0+.

    ## Example Usage

    Basic Usage

    ```python
    import pulumi
    import pulumi_alicloud as alicloud

    default = alicloud.ecs.get_instances(name_regex="no-deleteing-hbr-ecs-server-backup-plan",
        status="Running")
    ids = alicloud.hbr.get_server_backup_plans(filters=[alicloud.hbr.GetServerBackupPlansFilterArgs(
        key="instanceId",
        values=[default.instances[0].id],
    )])
    pulumi.export("hbrServerBackupPlanId1", ids.plans[0].id)
    ```


    :param Sequence[pulumi.InputType['GetServerBackupPlansFilterArgs']] filters: The filters.
    :param Sequence[str] ids: A list of Server Backup Plan IDs.
    :param str output_file: File name where to save data source results (after running `pulumi preview`).
    """
    ...
