# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['OssBackupPlanArgs', 'OssBackupPlan']

@pulumi.input_type
class OssBackupPlanArgs:
    def __init__(__self__, *,
                 backup_type: pulumi.Input[str],
                 bucket: pulumi.Input[str],
                 oss_backup_plan_name: pulumi.Input[str],
                 retention: pulumi.Input[str],
                 schedule: pulumi.Input[str],
                 vault_id: pulumi.Input[str],
                 cross_account_role_name: Optional[pulumi.Input[str]] = None,
                 cross_account_type: Optional[pulumi.Input[str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[int]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 prefix: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OssBackupPlan resource.
        :param pulumi.Input[str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[str] bucket: The name of OSS bucket.
        :param pulumi.Input[str] oss_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        :param pulumi.Input[str] vault_id: The ID of backup vault.
        :param pulumi.Input[str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`.
        :param pulumi.Input[str] prefix: Backup prefix. Once specified, only objects with matching prefixes will be backed up.
        """
        pulumi.set(__self__, "backup_type", backup_type)
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "oss_backup_plan_name", oss_backup_plan_name)
        pulumi.set(__self__, "retention", retention)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "vault_id", vault_id)
        if cross_account_role_name is not None:
            pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        if cross_account_type is not None:
            pulumi.set(__self__, "cross_account_type", cross_account_type)
        if cross_account_user_id is not None:
            pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Input[str]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "backup_type", value)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The name of OSS bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="ossBackupPlanName")
    def oss_backup_plan_name(self) -> pulumi.Input[str]:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "oss_backup_plan_name")

    @oss_backup_plan_name.setter
    def oss_backup_plan_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "oss_backup_plan_name", value)

    @property
    @pulumi.getter
    def retention(self) -> pulumi.Input[str]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: pulumi.Input[str]):
        pulumi.set(self, "retention", value)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input[str]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input[str]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[str]:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.
        """
        return pulumi.get(self, "cross_account_role_name")

    @cross_account_role_name.setter
    def cross_account_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_account_role_name", value)

    @property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @cross_account_type.setter
    def cross_account_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_account_type", value)

    @property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> Optional[pulumi.Input[int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @cross_account_user_id.setter
    def cross_account_user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cross_account_user_id", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Backup prefix. Once specified, only objects with matching prefixes will be backed up.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)


@pulumi.input_type
class _OssBackupPlanState:
    def __init__(__self__, *,
                 backup_type: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[str]] = None,
                 cross_account_type: Optional[pulumi.Input[str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[int]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 oss_backup_plan_name: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 retention: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OssBackupPlan resources.
        :param pulumi.Input[str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[str] bucket: The name of OSS bucket.
        :param pulumi.Input[str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`.
        :param pulumi.Input[str] oss_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[str] prefix: Backup prefix. Once specified, only objects with matching prefixes will be backed up.
        :param pulumi.Input[str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        :param pulumi.Input[str] vault_id: The ID of backup vault.
        """
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if cross_account_role_name is not None:
            pulumi.set(__self__, "cross_account_role_name", cross_account_role_name)
        if cross_account_type is not None:
            pulumi.set(__self__, "cross_account_type", cross_account_type)
        if cross_account_user_id is not None:
            pulumi.set(__self__, "cross_account_user_id", cross_account_user_id)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if oss_backup_plan_name is not None:
            pulumi.set(__self__, "oss_backup_plan_name", oss_backup_plan_name)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if retention is not None:
            pulumi.set(__self__, "retention", retention)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[str]]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_type", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of OSS bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> Optional[pulumi.Input[str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.
        """
        return pulumi.get(self, "cross_account_role_name")

    @cross_account_role_name.setter
    def cross_account_role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_account_role_name", value)

    @property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @cross_account_type.setter
    def cross_account_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cross_account_type", value)

    @property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> Optional[pulumi.Input[int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @cross_account_user_id.setter
    def cross_account_user_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cross_account_user_id", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="ossBackupPlanName")
    def oss_backup_plan_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "oss_backup_plan_name")

    @oss_backup_plan_name.setter
    def oss_backup_plan_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oss_backup_plan_name", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Backup prefix. Once specified, only objects with matching prefixes will be backed up.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter
    def retention(self) -> Optional[pulumi.Input[str]]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @retention.setter
    def retention(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input[str]]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_id", value)


class OssBackupPlan(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_type: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[str]] = None,
                 cross_account_type: Optional[pulumi.Input[str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[int]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 oss_backup_plan_name: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 retention: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a HBR Oss Backup Plan resource.

        For information about HBR Oss Backup Plan and how to use it, see [What is Oss Backup Plan](https://www.alibabacloud.com/help/doc-detail/130040.htm).

        > **NOTE:** Available in v1.131.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_vault = alicloud.hbr.Vault("defaultVault", vault_name=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"))
        default_bucket = alicloud.oss.Bucket("defaultBucket", bucket=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"))
        default_oss_backup_plan = alicloud.hbr.OssBackupPlan("defaultOssBackupPlan",
            oss_backup_plan_name="terraform-example",
            prefix="/",
            bucket=default_bucket.bucket,
            vault_id=default_vault.id,
            schedule="I|1602673264|PT2H",
            backup_type="COMPLETE",
            retention="2")
        ```

        ## Import

        HBR Oss Backup Plan can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:hbr/ossBackupPlan:OssBackupPlan example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[str] bucket: The name of OSS bucket.
        :param pulumi.Input[str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`.
        :param pulumi.Input[str] oss_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[str] prefix: Backup prefix. Once specified, only objects with matching prefixes will be backed up.
        :param pulumi.Input[str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        :param pulumi.Input[str] vault_id: The ID of backup vault.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OssBackupPlanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a HBR Oss Backup Plan resource.

        For information about HBR Oss Backup Plan and how to use it, see [What is Oss Backup Plan](https://www.alibabacloud.com/help/doc-detail/130040.htm).

        > **NOTE:** Available in v1.131.0+.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud
        import pulumi_random as random

        default_random_integer = random.RandomInteger("defaultRandomInteger",
            max=99999,
            min=10000)
        default_vault = alicloud.hbr.Vault("defaultVault", vault_name=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"))
        default_bucket = alicloud.oss.Bucket("defaultBucket", bucket=default_random_integer.result.apply(lambda result: f"terraform-example-{result}"))
        default_oss_backup_plan = alicloud.hbr.OssBackupPlan("defaultOssBackupPlan",
            oss_backup_plan_name="terraform-example",
            prefix="/",
            bucket=default_bucket.bucket,
            vault_id=default_vault.id,
            schedule="I|1602673264|PT2H",
            backup_type="COMPLETE",
            retention="2")
        ```

        ## Import

        HBR Oss Backup Plan can be imported using the id, e.g.

        ```sh
         $ pulumi import alicloud:hbr/ossBackupPlan:OssBackupPlan example <id>
        ```

        :param str resource_name: The name of the resource.
        :param OssBackupPlanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OssBackupPlanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_type: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 cross_account_role_name: Optional[pulumi.Input[str]] = None,
                 cross_account_type: Optional[pulumi.Input[str]] = None,
                 cross_account_user_id: Optional[pulumi.Input[int]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 oss_backup_plan_name: Optional[pulumi.Input[str]] = None,
                 prefix: Optional[pulumi.Input[str]] = None,
                 retention: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[str]] = None,
                 vault_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OssBackupPlanArgs.__new__(OssBackupPlanArgs)

            if backup_type is None and not opts.urn:
                raise TypeError("Missing required property 'backup_type'")
            __props__.__dict__["backup_type"] = backup_type
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["cross_account_role_name"] = cross_account_role_name
            __props__.__dict__["cross_account_type"] = cross_account_type
            __props__.__dict__["cross_account_user_id"] = cross_account_user_id
            __props__.__dict__["disabled"] = disabled
            if oss_backup_plan_name is None and not opts.urn:
                raise TypeError("Missing required property 'oss_backup_plan_name'")
            __props__.__dict__["oss_backup_plan_name"] = oss_backup_plan_name
            __props__.__dict__["prefix"] = prefix
            if retention is None and not opts.urn:
                raise TypeError("Missing required property 'retention'")
            __props__.__dict__["retention"] = retention
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
        super(OssBackupPlan, __self__).__init__(
            'alicloud:hbr/ossBackupPlan:OssBackupPlan',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_type: Optional[pulumi.Input[str]] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            cross_account_role_name: Optional[pulumi.Input[str]] = None,
            cross_account_type: Optional[pulumi.Input[str]] = None,
            cross_account_user_id: Optional[pulumi.Input[int]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            oss_backup_plan_name: Optional[pulumi.Input[str]] = None,
            prefix: Optional[pulumi.Input[str]] = None,
            retention: Optional[pulumi.Input[str]] = None,
            schedule: Optional[pulumi.Input[str]] = None,
            vault_id: Optional[pulumi.Input[str]] = None) -> 'OssBackupPlan':
        """
        Get an existing OssBackupPlan resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backup_type: Backup type. Valid values: `COMPLETE`.
        :param pulumi.Input[str] bucket: The name of OSS bucket.
        :param pulumi.Input[str] cross_account_role_name: The role name created in the original account RAM backup by the cross account managed by the current account.
        :param pulumi.Input[str] cross_account_type: The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        :param pulumi.Input[int] cross_account_user_id: The original account ID of the cross account backup managed by the current account.
        :param pulumi.Input[bool] disabled: Whether to disable the backup task. Valid values: `true`, `false`.
        :param pulumi.Input[str] oss_backup_plan_name: The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        :param pulumi.Input[str] prefix: Backup prefix. Once specified, only objects with matching prefixes will be backed up.
        :param pulumi.Input[str] retention: Backup retention days, the minimum is 1.
        :param pulumi.Input[str] schedule: Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        :param pulumi.Input[str] vault_id: The ID of backup vault.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OssBackupPlanState.__new__(_OssBackupPlanState)

        __props__.__dict__["backup_type"] = backup_type
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["cross_account_role_name"] = cross_account_role_name
        __props__.__dict__["cross_account_type"] = cross_account_type
        __props__.__dict__["cross_account_user_id"] = cross_account_user_id
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["oss_backup_plan_name"] = oss_backup_plan_name
        __props__.__dict__["prefix"] = prefix
        __props__.__dict__["retention"] = retention
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["vault_id"] = vault_id
        return OssBackupPlan(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Output[str]:
        """
        Backup type. Valid values: `COMPLETE`.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        The name of OSS bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="crossAccountRoleName")
    def cross_account_role_name(self) -> pulumi.Output[Optional[str]]:
        """
        The role name created in the original account RAM backup by the cross account managed by the current account.
        """
        return pulumi.get(self, "cross_account_role_name")

    @property
    @pulumi.getter(name="crossAccountType")
    def cross_account_type(self) -> pulumi.Output[str]:
        """
        The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
        """
        return pulumi.get(self, "cross_account_type")

    @property
    @pulumi.getter(name="crossAccountUserId")
    def cross_account_user_id(self) -> pulumi.Output[Optional[int]]:
        """
        The original account ID of the cross account backup managed by the current account.
        """
        return pulumi.get(self, "cross_account_user_id")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[bool]:
        """
        Whether to disable the backup task. Valid values: `true`, `false`.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="ossBackupPlanName")
    def oss_backup_plan_name(self) -> pulumi.Output[str]:
        """
        The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
        """
        return pulumi.get(self, "oss_backup_plan_name")

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Output[Optional[str]]:
        """
        Backup prefix. Once specified, only objects with matching prefixes will be backed up.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter
    def retention(self) -> pulumi.Output[str]:
        """
        Backup retention days, the minimum is 1.
        """
        return pulumi.get(self, "retention")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[str]:
        """
        Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[str]:
        """
        The ID of backup vault.
        """
        return pulumi.get(self, "vault_id")

